Attribute VB_Name = "Stats"
'Copyright 1999 Potato Software.  All rights reserved.
'See MAIN.BAS for License.

Public Type DayType
    PingsSent As Integer
    PingsRecv As Integer
    TotalLat As Double
End Type

Public Function WeekStats(Optional dx As Integer) As Long
    Dim Now As Date, newr As String, td As Date, week As Long, tv As Long
    
    On Error GoTo WeekError
    Now = Date
    x = InStr(RData(50), "[")
    z = 1
    While x <> 0
        a = Extract(Mid(RData(50), x + 1), "]")
        y = InStr(a, "=")
        If y <> 0 Then
            td = Left(a, y - 1)
            If Now - td < 8 And td <= Now Then
                tv = Val(Mid(a, y + 1))
                If td = Now Then
                    tv = tv + dx
                    found = True
                Else
                    week = week + tv
                End If
                newr = newr + "[" + Format(td, "dd-mmm-yy") + "=" + Trim(Str(tv)) + "]"
            End If
        End If
        z = x + 1
        x = InStr(z, RData(50), "[")
    Wend
    If dx <> 0 And Not found Then
        newr = newr + "[" + Format(Now, "dd-mmm-yy") + "=" + Trim(Str(dx)) + "]"
    End If
    RData(50) = newr
    WeekStats = week
Exit Function
WeekError:
    RData(50) = ""
    WeekStats = -1
End Function

Public Function BuildStats() As String
    Dim DayPing() As DayType, Rmlr(MaxRemailers) As String
    Dim ChainLog(4) As String, redun As String
    Dim TotalRemailers As Integer, Now As Date, GenDate As String
    Dim PingDate As Date, DateDiff As Double
    Dim TotalSent As Integer, TotalRecv As Integer, TotalLaty As Double
    Dim y2 As Single, y1 As Single, y0 As Single
    Dim RLine() As String, RLineUp() As Single
    Dim LongName As Boolean, AllStrings(2) As String
    
    On Error GoTo BuildError
    KeepDate(25) = Date + Time
    If Cnf(8, 9) = "False" And Cnf(8, 10) = "False" And Cnf(8, 11) = "False" Then BuildStats = "": Exit Function
    
    GenDate = DateLine(2, Date + Time)
    
    'Make List of Remailer Names
    TotalRemailers = 0
    x = 0
    Do While RString(x) <> ""
        RemailerString RString(x), rname, raddress, roptions
        If rname <> "" And raddress <> "" And InStr(roptions, " hide ") = 0 And (InStr(roptions, " cpunk ") <> 0 Or InStr(roptions, " mix ") <> 0) Then
            Rmlr(TotalRemailers) = rname
            If Len(rname) > 8 And InStr(roptions, " cpunk ") <> 0 Then LongName = True
            TotalRemailers = TotalRemailers + 1
        End If
        If rname <> "" And raddress <> "" And InStr(roptions, " hide ") = 0 Then
            AllStrings(0) = AllStrings(0) + Extract(RString(x), vbCr) + vbCrLf   '???
            If Val(Cnf(8, 13)) = 1 Then AllStrings(1) = AllStrings(1) + RString(x) + vbLf
        End If
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
    AllStrings(2) = Replace(Replace(AllStrings(0), "<", "&lt;"), ">", "&gt;")
    
    Now = Date + Time
        
    'Read Sent
    'Single Pings
    ReDim DayPing(TotalRemailers - 1, 1, 11)
    
    If Dir(Cnf(1, 5) + "\Stats\MKSSent.dat") <> "" Then
        n = FreeFile
        Open Cnf(1, 5) + "\Stats\MKSSent.dat" For Input As n
        p = FreeFile
        Open Cnf(1, 5) + "\Stats\MKSSent.tmp" For Output As p
        Print #p, "RELIABLE_STAT_SENT"
        Print #p,
        Print #p, "Reliable MakeStats File"
        Print #p, "DO NOT EDIT"
        Print #p, "Doing so may cause serious problems."
        Print #p,
        Print #p,
        Print #p, "---Version"
        Print #p, Version
        Print #p, "---Sent"
        While Not EOF(n)
            Line Input #n, a
            If a = "---Sent" Then
                While Not EOF(n)
                    Line Input #n, a
                    If Val(a) <> 0 Or Trim(a) = "0" Then
                        'Read Entry
                        rtype = Val(a)
                        If Not EOF(n) Then
                            Line Input #n, rname
                            If rname <> "" And Not EOF(n) Then
                                Input #n, PingDate
                                If PingDate - 1 < Now And Now - PingDate <= 13 Then
                                    'Keep Entry
                                    Print #p, rtype
                                    Print #p, rname
                                    Write #p, PingDate
                                    Print #p,
                                    If PingDate - (3 / 24 / 60) < Now And Now - PingDate <= 12 Then
                                        'Valid Entry
                                        'Find Remailer
                                        For i = 0 To TotalRemailers - 1
                                            If Rmlr(i) = rname Then
                                                'Add Sent
                                                x = Int(Now - PingDate)
                                                If x < 0 Then x = 0
                                                DayPing(i, rtype, x).PingsSent = DayPing(i, rtype, x).PingsSent + 1
                                                Exit For
                                            End If
                                        Next i
                                    End If
                                End If
                            End If
                        End If
                    End If
                Wend
            End If
        Wend
        Close p: p = 0
        Close n: n = 0
        FileCopy Cnf(1, 5) + "\Stats\MKSSent.dat", Cnf(1, 5) + "\Stats\MKSSent.bak"
        DelFile Cnf(1, 5) + "\Stats\MKSSent.dat"
        Name Cnf(1, 5) + "\Stats\MKSSent.tmp" As Cnf(1, 5) + "\Stats\MKSSent.dat"
    End If
    
    DoEvents
    
    'Read Recv
    If Dir(Cnf(1, 5) + "\Stats\MKSRecv.dat") <> "" Then
        n = FreeFile
        Open Cnf(1, 5) + "\Stats\MKSRecv.dat" For Input As n
        p = FreeFile
        Open Cnf(1, 5) + "\Stats\MKSRecv.tmp" For Output As p
        Print #p, "RELIABLE_STAT_RECV"
        Print #p,
        Print #p, "Reliable MakeStats File"
        Print #p, "DO NOT EDIT"
        Print #p, "Doing so may cause serious problems."
        Print #p,
        Print #p,
        Print #p, "---Version"
        Print #p, Version
        Print #p, "---Recv"
        While Not EOF(n)
            Line Input #n, a
            If a = "---Recv" Then
                While Not EOF(n)
                    Line Input #n, a
                    If Int(Val(a)) <> 0 Or Trim(a) = "0" Then
                        'Read Entry
                        ChainType = Int(Val(a))
                        If Not EOF(n) Then
                            Input #n, PingDate
                            If Not EOF(n) Then Input #n, DateDiff Else DateDiff = 0
                            If ChainType = 0 Then
                                If Not EOF(n) Then Line Input #n, a: rtype = Val(a)
                                If Not EOF(n) Then Line Input #n, rname
                            Else
                                If Not EOF(n) Then Line Input #n, rname
                                If Not EOF(n) Then Line Input #n, rname2
                            End If
                            If PingDate < Now And ((ChainType = 0 And Now - PingDate <= 12) Or (ChainType <> 0 And Now - PingDate <= 14)) And DateDiff <> 0 And rname <> "" Then
                                'Valid Entry
                                'Write Entry
                                Print #p, ChainType
                                Write #p, PingDate
                                Write #p, DateDiff
                                If ChainType = 0 Then
                                    Print #p, rtype
                                    Print #p, rname
                                    'Find Remailer
                                    For i = 0 To TotalRemailers - 1
                                        If Rmlr(i) = rname Then
                                            b = Trim(Str(rtype)) + rname + Format(PingDate, "ddhhnn")
                                            If InStr(redun, b) = 0 Then
                                                'Add Recv
                                                If DateDiff < 0 Then DateDiff = 0
                                                x = Int(Now - PingDate)
                                                DayPing(i, rtype, x).PingsRecv = DayPing(i, rtype, x).PingsRecv + 1
                                                DayPing(i, rtype, x).TotalLat = DayPing(i, rtype, x).TotalLat + DateDiff
                                                redun = redun + b
                                                Exit For
                                            End If
                                        End If
                                    Next i
                                Else
                                    Print #p, rname
                                    Print #p, rname2
                                    ChainLog(ChainType) = ChainLog(ChainType) + " " + Trim(rname) + "-" + Trim(rname2) + "=" + Trim(Str(Int(DateDiff * 24 * 60 + 0.9)))
                                End If
                                Print #p,
                            End If
                        End If
                    End If
                Wend
            End If
        Wend
        Close p: p = 0
        Close n: n = 0
        FileCopy Cnf(1, 5) + "\Stats\MKSRecv.dat", Cnf(1, 5) + "\Stats\MKSRecv.bak"
        DelFile Cnf(1, 5) + "\Stats\MKSRecv.dat"
        Name Cnf(1, 5) + "\Stats\MKSRecv.tmp" As Cnf(1, 5) + "\Stats\MKSRecv.dat"
    End If
    
    DoEvents
    
    'Make Single Response Sheet
    If Val(Cnf(8, 12)) = 0 Then histkey = "? #*+-._" Else histkey = "?.123456"
    ReDim RLine(2, TotalRemailers), RLineUp(TotalRemailers)
    
    For rtype = 0 To 1
        If Cnf(8, 9 + rtype) = "True" Then
            'Compile Remailer
            rx = 0
            For x = 0 To TotalRemailers - 1
                'Find Remailer
                r = 0
                Do While RString(r) <> ""
                    RemailerString RString(r), rname, raddress, roptions
                    If Rmlr(x) = rname Then Exit Do
                    r = r + 1: If r > MaxRemailers Then Exit Do
                Loop
                If Rmlr(x) = rname And raddress <> "" And InStr(roptions, " hide ") = 0 And ((InStr(roptions, " cpunk ") <> 0 And rtype = 0) Or (InStr(roptions, " mix ") <> 0 And rtype = 1)) Then
                    'Make Hists
                    hist = "": hist2 = "": uphist = ""
                    TotalSent = 0: TotalRecv = 0: TotalLaty = 0
                    For i = 11 To 0 Step -1
                        If DayPing(x, rtype, i).PingsRecv = 0 And DayPing(x, rtype, i).PingsSent = 0 Then
                            hist = hist + Mid(histkey, 1, 1)
                            hist2 = hist2 + "?"
                        Else
                            If DayPing(x, rtype, i).PingsRecv = 0 Then
                                hist = hist + Mid(histkey, 2, 1)
                                hist2 = hist2 + "?"
                            Else
                                lt = DayPing(x, rtype, i).TotalLat / DayPing(x, rtype, i).PingsRecv
                                y = 8
                                If lt < 2 Then y = 7
                                If lt < 1 Then y = 6
                                If lt < 4 / 24 Then y = 5
                                If lt < 1 / 24 Then y = 4
                                If lt < 5 / 24 / 60 Then y = 3
                                hist = hist + Mid(histkey, y, 1)
                                If lt < 9 / 24 Then
                                    If lt < 20 / 24 / 60 Then
                                        hist2 = hist2 + "0"
                                    Else
                                        hist2 = hist2 + Trim(Str(Int(lt * 24) + 1))
                                    End If
                                Else
                                    If lt < 12 / 24 Then
                                        a = "A"
                                    Else
                                        If lt > 48 / 24 Then
                                            a = "H"
                                        Else
                                            a = Chr(Int((lt * 24 - 12) / 6) + 66)
                                        End If
                                    End If
                                    hist2 = hist2 + a
                                End If
                            End If
                        End If
                        y = DayPing(x, rtype, i).PingsSent
                        If DayPing(x, rtype, i).PingsRecv > y Then y = DayPing(x, rtype, i).PingsRecv
                        TotalSent = TotalSent + y
                        TotalRecv = TotalRecv + DayPing(x, rtype, i).PingsRecv
                        TotalLaty = TotalLaty + DayPing(x, rtype, i).TotalLat
                        'Uptime-Hist
                        If y = 0 Then
                            uphist = uphist + "?"
                        Else
                            y1 = Int((DayPing(x, rtype, i).PingsRecv / y) * 10)
                            If y1 = 10 Then
                                uphist = uphist + "+"
                            Else
                                uphist = uphist + Trim(Str(y1))
                            End If
                        End If
                    Next i
                    If Val(Cnf(8, 12)) = 2 Then hist = hist2
                    If Val(Cnf(8, 12)) = 3 Then hist = uphist
                    'Calc Uptime
                    If TotalSent <> 0 Then y0 = TotalRecv / TotalSent Else y0 = 0
                    y1 = Int(y0 * 100)
                    y2 = (y0 * 100) - y1
                    uptime = Right("   " + Trim(Str(y1)), 3) + "."
                    a = Trim(Str(y2))
                    y = InStr(a, ".") + 1
                    uptime = uptime + Left(Trim(Str(Mid(a, y, 2))) + "00", 2)
                    'Calc Latency
                    If TotalRecv <> 0 Then lt = TotalLaty / TotalRecv Else lt = 4.166655
                    If lt > 4.166655 Then lt = 4.166655
                    If lt < 0 Then lt = 0
                    y0 = Int(lt * 24)
                    y1 = Int((lt - (y0 / 24)) * 24 * 60)
                    y2 = Int((lt - (y0 / 24) - (y1 / 24 / 60)) * 24 * 60 * 60)
                    lat = ":" + Right("00" + Trim(Str(y2)), 2)
                    If y0 <> 0 Then
                        lat = Right("  " + Trim(Str(y0)), 2) + ":" + Right("00" + Trim(Str(y1)), 2) + lat
                    Else
                        If y1 <> 0 Then lat = "   " + Right("  " + Trim(Str(y1)), 2) + lat Else lat = "     " + lat
                    End If
                    If Trim(Left(lat, 5)) = "" Then
                        lat2 = "  :01"
                    Else
                        lat2 = Left(lat, 5)
                        If InStr(lat2, ":") = 0 Then lat2 = "  :" + Right("00" + Trim(lat2), 2)
                    End If
                    'Calc Opts
                    'DP[MR2]H[G2]OXTCLEUAI9
                    If InStr(roptions, " middle ") <> 0 Then ro = "D" Else ro = " "
                    If InStr(roptions, " post ") <> 0 Then ro = ro + "P" Else ro = ro + " "
                    If InStr(roptions, " remix ") <> 0 Then
                        ro = ro + "R"
                    Else
                        If InStr(roptions, " remix2 ") <> 0 Then
                            ro = ro + "2"
                        Else
                            If InStr(roptions, " mix ") <> 0 Then ro = ro + "M" Else ro = ro + " "
                        End If
                    End If
                    If InStr(roptions, " hybrid ") <> 0 Then ro = ro + "H" Else ro = ro + " "
                    If InStr(roptions, " repgp ") <> 0 Then
                        ro = ro + "G"
                    Else
                        If InStr(roptions, " repgp2 ") <> 0 Then ro = ro + "2" Else ro = ro + " "
                    End If
                    If InStr(roptions, " pgponly ") <> 0 Then ro = ro + "O" Else ro = ro + " "
                    If InStr(roptions, " ext ") <> 0 Then ro = ro + "X" Else ro = ro + " "
                    If InStr(roptions, " max ") <> 0 Then ro = ro + "A" Else ro = ro + " "
                    If InStr(roptions, " test ") <> 0 Then ro = ro + "T" Else ro = ro + " "
                    If InStr(roptions, " latent ") <> 0 Then ro = ro + "L" Else ro = ro + " "
                    If InStr(roptions, " ek ") <> 0 Then
                        If InStr(roptions, " ekx ") <> 0 Then ro = ro + "E" Else ro = ro + "e"
                    Else: ro = ro + " "
                    End If
                    If InStr(roptions, " esub ") <> 0 Then ro = ro + "U" Else ro = ro + " "
                    If InStr(roptions, " inflt") <> 0 Then ro = ro + "I" Else ro = ro + " "
                    If InStr(roptions, " rhop") <> 0 Then ro = ro + "N" Else ro = ro + " "
                    y = InStr(roptions, " klen")
                    If y <> 0 Then
                        klen = Int(Abs(Val(Mid(roptions, y + 5))) / 100)
                        If klen > 9 Then klen = 9
                        ro = ro + Trim(Str(klen))
                    Else
                        ro = ro + " "
                    End If
                    'Add V1 Line
                    If LongName And rtype = 0 Then
                        RLine(0, rx) = Left(rname + String(15, " "), 12) + " "
                    Else
                        RLine(0, rx) = Left(rname + String(15, " "), 8 + 6 * rtype) + " "
                    End If
                    If rtype = 0 Then RLine(0, rx) = RLine(0, rx) + Left(raddress + String(32, " "), 32) + " "
                    RLine(0, rx) = RLine(0, rx) + hist + " "
                    RLine(0, rx) = RLine(0, rx) + lat + " " + uptime + "%"
                    'Add V2 Line
                    RLine(1, rx) = Left(rname + String(12, " "), 12) + " " + _
                                   hist2 + "  " + lat2 + "   " + _
                                   uphist + "  " + Left(uptime, 5) + "%" + "  " + ro
                    RLineUp(rx) = Val(uptime)
                    rx = rx + 1
                End If
                DoEvents
            Next x
            'Write Files
            For sver = 0 To 1
                For frmt = 0 To 1 '0 = plain; 1 = html
                    If Val(Cnf(8, 13)) = 0 Or frmt = 1 Then xle = vbCrLf Else xle = vbLf
                    FileX = 15 + (4 * sver) + (2 * frmt) + rtype
                    If Cnf(8, 9 + rtype) = "True" And Cnf(8, FileX) <> "" Then
                        'Open File
                        n = FreeFile
                        Open Cnf(8, FileX) For Output As n
                        'Write Header
                        If frmt = 1 Then
                            Print #n, "<HTML>"
                            Print #n, "<!-- Auto-Generated by Reliable v"; Version; "   http://www.bigfoot.com/~potatoware  -->"
                            Print #n, "<HEAD>"
                            If Cnf(8, 14) <> "" Then a = " - " + Cnf(8, 14) Else a = ""
                            If rtype = 0 Then Print #n, "<TITLE>Cypherpunk Remailers"; a; "</TITLE>" Else Print #n, "<TITLE>Mixmaster Remailers"; a; "</TITLE>"
                            Print #n, "<META name="; Chr(34); "Description"; Chr(34); " content="; Chr(34); "Remailer Reliability Statistics"; Chr(34); ">"
                            Print #n, "<META name="; Chr(34); "Keywords"; Chr(34); " content="; Chr(34); "stats, statistics, remailer, reliability, anonymous, nym, mixmaster"; Chr(34); ">"
                            Print #n, "</HEAD>"
                            Print #n, "<BODY>"
                            Print #n, "<CENTER>"
                            If Cnf(8, 14) <> "" Then Print #n, "<H2>"; Cnf(8, 14); "</H2>"
                            Print #n, "<H3>";
                            If rtype = 0 Then Print #n, "Cypherpunk"; Else Print #n, "Mixmaster";
                            Print #n, " Remailers</H3></CENTER>"
                            Print #n, "<BR><BR>"
                            'CPunk/Mix Link
                            a = ""
                            If rtype = 1 Then
                                If Cnf(8, 15 + 4 * sver + 2) <> "" Then a = "<A HREF=" + Chr(34) + PlainName(Cnf(8, 15 + 4 * sver + 2), 1) + Chr(34) + ">Cypherpunk</A>"
                                If a = "" And Cnf(8, 15 + 4 * sver) <> "" Then a = "<A HREF=" + Chr(34) + PlainName(Cnf(8, 15 + 4 * sver), 1) + Chr(34) + ">Cypherpunk</A>"
                            Else
                                If Cnf(8, 15 + 4 * sver + 3) <> "" Then a = "<A HREF=" + Chr(34) + PlainName(Cnf(8, 15 + 4 * sver + 3), 1) + Chr(34) + ">Mixmaster</A>"
                                If a = "" And Cnf(8, 15 + 4 * sver + 1) <> "" Then a = "<A HREF=" + Chr(34) + PlainName(Cnf(8, 15 + 4 * sver + 1), 1) + Chr(34) + ">Mixmaster</A>"
                            End If
                            'Chain Link
                            b = ""
                            If Cnf(8, 11) = "True" Then
                                If Cnf(8, 24) <> "" Then b = Cnf(8, 24) Else b = Cnf(8, 23)
                                If b <> "" Then b = "<A HREF=" + Chr(34) + PlainName(b, 1) + Chr(34) + ">Chain</A>"
                            End If
                            'Version Link
                            c = ""
                            If Cnf(8, 15 + 4 * Abs(sver - 1) + 2 + rtype) <> "" Then c = "<A HREF=" + Chr(34) + PlainName(Cnf(8, 15 + 4 * Abs(sver - 1) + 2 + rtype), 1) + Chr(34) + ">Version" + Str(Abs(sver - 1) + 1) + "</A>"
                            If a <> "" And b <> "" And c <> "" Then
                                a = a + ", " + b + ", and " + c
                                b = "": c = ""
                            Else
                                If a = "" Then
                                    a = b: b = c: c = ""
                                Else
                                    If b = "" Then b = c: c = ""
                                End If
                            End If
                            If a <> "" And b <> "" Then b = " and " + b
                            If a <> "" Or b <> "" Then b = b + " stats are also available."
                            Print #n, "This is an automatically generated list of remailer reliability statistics.  Please see the <A HREF="; Chr(34); "#Int"; Chr(34); ">Interpretation section</A> below for more information. "; a; b; "<BR><BR><BR>"
                            Print #n, "<PRE>"
                        Else
                            Print #n, xle;
                            If Cnf(8, 14) <> "" Then Print #n, String(Int((80 - Len(Left(Cnf(8, 14), 80))) / 2), " "); Left(Cnf(8, 14), 80); xle; xle;
                            If rtype = 0 Then a = "Cypherpunk Remailers" Else a = "Mixmaster Remailers"
                            Print #n, String(Int((80 - Len(a)) / 2), " "); a; xle;
                            Print #n, xle; xle;
                            Print #n, "This is an automatically generated list of remailer reliability statistics."; xle; xle;
                            'Header File
                            If Cnf(8, 25) <> "" And SDir(Cnf(8, 25)) <> "" Then
                                p = FreeFile
                                Open Cnf(8, 25) For Input As p
                                While Not EOF(p)
                                    Line Input #p, a
                                    Print #n, a; xle;
                                Wend
                                Close p: p = 0
                            End If
                            Print #n, xle;
                        End If
                        If sver = 0 Then
                            'Write Caps
                            If rtype = 0 Or Cnf(8, 15 + frmt * 2) = "" Then
                                If Val(Cnf(8, 13)) = 1 And frmt = 0 Then
                                    Print #n, AllStrings(1);
                                Else
                                    If frmt = 0 Then Print #n, AllStrings(0); Else Print #n, AllStrings(2);
                                End If
                                Print #n, xle; xle; xle;
                            End If
                            If rtype = 0 Then WriteMachine n, xle
                            'Last update: Mon 23 Nov 98 02:18:44 GMT
                            Print #n, "Last update: "; GenDate; xle;
                            If rtype = 0 Then
                                If LongName Then Print #n, "remailer     "; Else Print #n, "remailer ";
                                Print #n, " email address                        history  latency  uptime"; xle;
                            Else
                                Print #n, "mixmaster           history  latency  uptime"; xle;
                            End If
                            If LongName Then y1 = 44 - 31 * (rtype - 1) Else y1 = 44 - 27 * (rtype - 1)
                            Print #n, String(y1, "-"); xle;
                        Else
                            'Stats-Version: 2.0
                            Print #n, "Stats-Version: 2.0"; xle;
                            Print #n, "Generated: "; GenDate; xle;
                            If rtype = 0 Then a = "Cypherpunk" Else a = "Mixmaster "
                            Print #n, a; "   Latent-Hist   Latent  Uptime-Hist   Uptime  Options"; xle;
                            Print #n, String(72, "-"); xle;
                        End If
                        'Write Sorted Lines
                        For i = 0 To rx
                            RLine(2, i) = RLine(sver, i)
                        Next i
                        For i = 0 To rx
                            hi = -1
                            For j = 0 To rx
                                If RLine(2, j) <> "" Then
                                    If hi = -1 Then
                                        hi = j
                                    Else
                                        If RLineUp(j) > RLineUp(hi) Then hi = j
                                    End If
                                End If
                            Next j
                            If hi <> -1 Then
                                If RLine(2, hi) <> "" Then Print #n, RLine(2, hi); xle;
                                RLine(2, hi) = ""
                            End If
                        Next i
                        
                        If sver = 0 Then
                            If frmt = 1 Then Print #n, "</PRE>"
                            Print #n, xle;
                            Print #n, xle;
                            If frmt = 1 Then
                                Print #n, "<A NAME="; Chr(34); "Int"; Chr(34); "></A>"
                                Select Case Val(Cnf(8, 12))
                                Case 0, 1
                                    Print #n, "<BR>History: The result of test messages sent for each of the last 12 days.<BR>"
                                    Print #n, "<UL><TABLE CELLPADDING=0 CELLSPACING=0><TR><TD>?</TD><TD>No test message sent</TD></TR>"
                                    If Val(Cnf(8, 19)) = 1 Then
                                        Print #n, "<TR><TD WIDTH=50>.</TD><TD>Response not received</TD></TR>"
                                    Else
                                        Print #n, "<TR><TD>(space)  </TD><TD>Response not received</TD></TR>"
                                    End If
                                    Print #n, "<TR><TD>"; Mid(histkey, 3, 1); "</TD><TD>Response in less than 5 minutes</TD></TR>"
                                    Print #n, "<TR><TD>"; Mid(histkey, 4, 1); "</TD><TD>Response in less than 1 hour</TD></TR>"
                                    Print #n, "<TR><TD>"; Mid(histkey, 5, 1); "</TD><TD>Response in less than 4 hours</TD></TR>"
                                    Print #n, "<TR><TD>"; Mid(histkey, 6, 1); "</TD><TD>Response in less than 24 hours</TD></TR>"
                                    Print #n, "<TR><TD>"; Mid(histkey, 7, 1); "</TD><TD>Response in less than 2 days</TD></TR>"
                                    Print #n, "<TR><TD>"; Mid(histkey, 8, 1); "</TD><TD>Response in more than 2 days</TD></TR>"
                                    Print #n, "</TABLE></UL>"
                                    Print #n, "Latency: The average default response time of the remailer."
                                    Print #n, "<BR><BR>Uptime: The fraction of responses received from tests sent in the last 12 days.<BR><BR>"
                                Case 2
                                    Print #n, "<PRE>"; vbCrLf; vbCrLf
                                    Print #n, "Interpretation:"; vbCrLf
                                    Print #n, "History (Latent-Hist) shows the average default response time for each day:"
                                    Print #n, "    0   less than 20 minutes"
                                    Print #n, "    1   less than 1 hour"
                                    Print #n, "    ..."
                                    Print #n, "    9   less than 9 hours"
                                    Print #n, "    A   less than 12 hours"
                                    Print #n, "    B   less than 18 hours"
                                    Print #n, "    C   less than 24 hours"
                                    Print #n, "    ..."
                                    Print #n, "    G   less than 48 hours"
                                    Print #n, "    H   more than 48 hours"
                                    Print #n, "    ?   No responses received / No data"; vbCrLf
                                    Print #n, "Latency: The average default response time of the remailer."; vbCrLf
                                    Print #n, "Uptime: The fraction of responses received from tests sent in the last"; vbCrLf; "12 days."
                                    Print #n, "</PRE>"
                                Case 3
                                    Print #n, "<PRE>"; vbCrLf; vbCrLf
                                    Print #n, "Interpretation:"; vbCrLf
                                    Print #n, "History (Uptime-Hist) shows the Uptime percentage (responses received"
                                    Print #n, "divided by pings sent) for each day:"
                                    Print #n, "    +  100% (Responses were received for all pings sent)"
                                    Print #n, "    9  90-99.9% (About 9 responses were received for every 10 pings)"
                                    Print #n, "    ..."
                                    Print #n, "    1  10-19.9%"
                                    Print #n, "    0  0-9.9%"
                                    Print #n, "    ?  No pings sent / No data"; vbCrLf
                                    Print #n, "Latency: The average default response time of the remailer."; vbCrLf
                                    Print #n, "Uptime: The fraction of responses received from tests sent in the last"; vbCrLf; "12 days."
                                    Print #n, "</PRE>"
                                End Select
                            End If
                        Else
                            Print #n, xle;
                            Print #n, xle;
                            WriteMachine n, xle
                            Print #n, xle;
                            Print #n, "Remailer-Capabilities:"; xle; xle;
                            If Val(Cnf(8, 13)) = 1 And frmt = 0 Then
                                 'Plain,Lf EOL
                                 Print #n, AllStrings(1);
                            Else
                                'CrLf EOL
                                If frmt = 0 Then Print #n, AllStrings(0); Else Print #n, AllStrings(2);
                            End If
                            Print #n, xle; xle; xle;
                            If frmt = 1 Then
                                Print #n, "</PRE>"
                                Print #n, "<A NAME="; Chr(34); "Int"; Chr(34); "></A>"
                                Print #n, "<B><U>Interpretation:</U></B><BR>"
                                Print #n, "<PRE>"
                            Else
                                Print #n, xle; "Interpretation:"; xle;
                            End If
                            Print #n, xle;
                            Print #n, "The stats table shows the 12-day performance history of each remailer."; xle;
                            Print #n, "Pings (test messages) are sent to each remailer and response time is"; xle; "measured."; xle;
                            Print #n, xle;
                            Print #n, "Latent-Hist shows the average default response time for each day:"; xle;
                            Print #n, "    0   less than 20 minutes"; xle;
                            Print #n, "    1   less than 1 hour"; xle;
                            Print #n, "    ..."; xle;
                            Print #n, "    9   less than 9 hours"; xle;
                            Print #n, "    A   less than 12 hours"; xle;
                            Print #n, "    B   less than 18 hours"; xle;
                            Print #n, "    C   less than 24 hours"; xle;
                            Print #n, "    ..."; xle;
                            Print #n, "    G   less than 48 hours"; xle;
                            Print #n, "    H   more than 48 hours"; xle;
                            Print #n, "    ?   No responses received / No data"; xle;
                            Print #n, xle;
                            Print #n, "Latent shows the average default response time in HH:MM format."; xle;
                            Print #n, xle;
                            Print #n, "Uptime-Hist shows the Uptime percentage (responses received divided by"; xle;
                            Print #n, "pings sent) for each day:"; xle;
                            Print #n, "    +  100% (Responses were received for all pings sent)"; xle;
                            Print #n, "    9  90-99.9% (About 9 responses were received for every 10 pings)"; xle;
                            Print #n, "    ..."; xle;
                            Print #n, "    1  10-19.9%"; xle;
                            Print #n, "    0  0-9.9%"; xle;
                            Print #n, "    ?  No pings sent / No data"; xle;
                            Print #n, xle;
                            Print #n, "Uptime shows the average Uptime percentage for 12 days."; xle;
                            Print #n, xle;
                            Print #n, "Options shows an abbreviated form of the strings listed in the"; xle;
                            Print #n, "Remailer-Capabilities section above:"; xle;
                            Print #n, "    D       middle (Remailer is middleman and chains to other remailers)"; xle;
                            Print #n, "    P       post (Supports news posting (Anon-Post-To or Post)"; xle;
                            Print #n, "    M/R/2   mix/remix/remix2 (Supported Mixmaster features)"; xle;
                            Print #n, "    H       hybrid (Supports CPunk directives in Mix messages)"; xle;
                            Print #n, "    G/2     repgp/repgp2"; xle;
                            Print #n, "    O       pgponly (Requires Cypherpunk messages to be PGP encrypted)"; xle;
                            Print #n, "    X       ext (Supports extended directive features)"; xle;
                            Print #n, "    A       max (Supports Max-Size, Max-Count, and Max-Date directives)"; xle;
                            Print #n, "    T       test (Supports the Test-To directive)"; xle;
                            Print #n, "    L       latent (Supports the Latent-Time directive)"; xle;
                            Print #n, "    e/E     ek/ekx (Supports Encrypt-Key/-3DES,-CAST directives)"; xle;
                            Print #n, "    U       esub (Supports the Encrypt-Subject directive)"; xle;
                            Print #n, "    I       inflt (Supports the Inflate directive)"; xle;
                            Print #n, "    N       rhop (Supports the Rand-Hop directive)"; xle;
                            Print #n, "    #       klen - The digit indicates the maximum message size:"; xle;
                            Print #n, "                9   Max is greater than 900K "; xle;
                            Print #n, "                8   Max is less than 900K"; xle;
                            Print #n, "                ..."; xle;
                            Print #n, "                1   Max is less than 200K"; xle;
                            Print #n, "                0   Max is less than 100K"; xle; xle;
                            If frmt = 1 Then Print #n, "</PRE>"
                        End If
                        'Trailer File
                        If frmt = 1 And Cnf(8, 26) <> "" And SDir(Cnf(8, 26)) <> "" Then
                            p = FreeFile
                            Open Cnf(8, 26) For Input As p
                            While Not EOF(p)
                                Line Input #p, a
                                Print #n, a; xle;
                            Wend
                            Close p: p = 0
                        End If
                        If frmt = 1 Then Print #n, "</BODY></HTML>"
                        Close n: n = 0
                    End If
                Next frmt
            Next sver
        End If
    Next rtype
    
    DoEvents

    'Make Chain Sheet
    If Val(Cnf(8, 13)) = 0 Then xle = vbCrLf Else xle = vbLf
    If Cnf(8, 11) = "True" And (Cnf(8, 23) <> "" Or Cnf(8, 24) <> "") Then
        n = 0: p = 0
        If Cnf(8, 23) <> "" Then
            n = FreeFile
            Open Cnf(8, 23) For Output As n
        End If
        If Cnf(8, 24) <> "" Then
            p = FreeFile
            Open Cnf(8, 24) For Output As p
            Print #p, "<HTML>"
            Print #p, "<!-- Auto-Generated by Reliable v"; Version; "   http://www.bigfoot.com/~potatoware  -->"
            Print #p, "<HEAD>"
            If Cnf(8, 14) <> "" Then a = " - " + Cnf(8, 14) Else a = ""
            Print #p, "<TITLE>Cypherpunk Chains"; a; "</TITLE>"
            Print #p, "<META name="; Chr(34); "Description"; Chr(34); " content="; Chr(34); "Cypherpunk Chain Stats"; Chr(34); ">"
            Print #p, "<META name="; Chr(34); "Keywords"; Chr(34); " content="; Chr(34); "stats, statistics, Remailer, anonymous, nym"; Chr(34); ">"
            Print #p, "</HEAD>"
            Print #p, "<BODY>"
        End If
        If n <> 0 Then
            Print #n, xle;
            If Cnf(8, 14) <> "" Then Print #n, String(Int((80 - Len(Left(Cnf(8, 14), 80))) / 2), " "); Left(Cnf(8, 14), 80); xle; xle;
            a = "Cypherpunk Chain Stats"
            Print #n, String(Int((80 - Len(a)) / 2), " "); a; xle;
            Print #n, xle;
            Print #n, "The tables below show Remail-To, Anon-To, Encrypt-To, and Remix-To"; xle; "message chains.  ";
            Print #n, "This is a composite of tests conducted within 14 days"; xle; "of the generation date."; xle;
            Print #n, xle; xle; xle;
        End If
        If p <> 0 Then
            Print #p, "<CENTER>"
            If Cnf(8, 14) <> "" Then Print #p, "<H2>"; Cnf(8, 14); "</H2>"
            Print #p, "<H3>Cypherpunk Chain Stats</H3>"
            Print #p, "</CENTER><BR><BR>"
            Print #p, "The tables below show Remail-To, Anon-To, Encrypt-To, and Remix-To message chains.  This is a composite of tests conducted within 14 days of the generation date.<BR>"
            Print #p, "<BR><BR>"
            Print #p, "<CENTER>"
        End If
        'Get CPunk Remailers
        TotalRemailers = 0
        x = 0
        Do While RString(x) <> ""
            RemailerString RString(x), rname, raddress, roptions
            If rname <> "" And raddress <> "" And InStr(roptions, " hide ") = 0 And InStr(roptions, " cpunk ") <> 0 Then
                Rmlr(TotalRemailers) = rname + "=" + roptions
                TotalRemailers = TotalRemailers + 1
            End If
            x = x + 1: If x > MaxRemailers Then Exit Do
        Loop
        
        For chain = 1 To 4
            Select Case chain
                Case 1: a = "Remail-To"
                Case 2: a = "Anon-To"
                Case 3: a = "Encrypt-To"
                Case 4: a = "Remix-To"
            End Select
            If n <> 0 Then Print #n, Left("     " + a + String(10, " "), 16); "[Generated: "; GenDate; "]"; xle; "                [Last Pinged: "; RTrim(Left(DateLine(2, KeepDate(8 + chain)), 15)); "]"; xle; xle; "From\To  ";
            If p <> 0 Then
                Print #p, "<BIG><B>"; a; "</B></BIG><BR><SMALL>[Generated: "; GenDate; "]<BR>[Last Pinged: "; RTrim(Left(DateLine(2, KeepDate(8 + chain)), 15)); "]</SMALL><BR>"
                Print #p, "<TABLE CELLSPACING=2  CELLPADDING=1  BORDER=1>"
                'Print #p, "<CAPTION><B>"; a; "</B><BR><SMALL>[Generated: "; GenDate; "]<BR>[Last Pinged: "; RTrim(Left(DateLine(2, KeepDate(8 + chain)), 15)); "]</SMALL></CAPTION>"
                Print #p, "<TR>"
                Print #p, "<TH>From \ To</TH>"
            End If
            For i = 0 To TotalRemailers - 1
                rname = Extract(Rmlr(i), "=")
                roptions = Mid(Rmlr(i), InStr(Rmlr(i), "=") + 1)
                If chain <> 4 Or InStr(roptions, " mix ") <> 0 Then
                    'TO remailer
                    x = Int((6 - Len(Left(rname, 6))) / 2)
                    If n <> 0 Then Print #n, Left(String(x, " ") + rname + "      ", 6); " ";
                    If p <> 0 Then Print #p, "<TD>"; Left(rname, 6); "</TD>"
                End If
            Next i
            If n <> 0 Then Print #n, xle; xle;
            If p <> 0 Then Print #p, "</TR>"
            For i = 0 To TotalRemailers - 1
                rname = Extract(Rmlr(i), "=")
                roptions = Mid(Rmlr(i), InStr(Rmlr(i), "=") + 1)
                Select Case chain
                Case 1: x = 0
                Case 2
                    x = InStr(roptions, " repgp ")
                    If x = 0 Then x = InStr(roptions, " remix ")
                Case 3: x = InStr(roptions, " repgp")
                Case 4: x = InStr(roptions, " remix")
                End Select
                'FROM remailer
                If n <> 0 Then Print #n, Left(Left(rname, 6) + Left("*", x) + "         ", 9);
                If p <> 0 Then Print #p, "<TR ALIGN=CENTER><TD ALIGN=LEFT>"; Left(rname, 6) + Left("*", x); "</TD>";
                For j = 0 To TotalRemailers - 1
                    rname2 = Extract(Rmlr(j), "=")
                    roptions2 = Mid(Rmlr(j), InStr(Rmlr(j), "=") + 1)
                    If (chain <> 4 Or InStr(roptions2, " mix ") <> 0) Then
                        If rname = rname2 Then
                            '\
                            If n <> 0 Then Print #n, "  \    ";
                            If p <> 0 Then Print #p, "<TD>-</TD>";
                        Else
                            x = InStr(ChainLog(chain), " " + rname + "-" + rname2 + "=")
                            If x = 0 Then
                                '?
                                If n <> 0 Then Print #n, "  ?    ";
                                If p <> 0 Then Print #p, "<TD><B>?</B></TD>";
                            Else
                                '12:45
                                x = InStr(x, ChainLog(chain), "=")
                                DateDiff = Val(Extract(Mid(ChainLog(chain), x + 1), " "))
                                If DateDiff < 0 Then DateDiff = 0
                                H = Int(DateDiff / 60)
                                m = DateDiff - (H * 60)
                                If H > 99 Then H = 99
                                a = ":" + Right("0" + Trim(Str(m)), 2)
                                If H <> 0 Then a = Trim(Str(H)) + a Else a = " " + a
                                If H < 10 Then a = " " + a
                                a = a + "  "
                                If n <> 0 Then Print #n, a;
                                If p <> 0 Then Print #p, "<TD>"; a; "</TD>";
                            End If
                        End If
                    End If
                Next j
                If n <> 0 Then Print #n, xle; xle;
                If p <> 0 Then Print #p, "</TR>"
                DoEvents
            Next i
            If n <> 0 Then
                Select Case chain
                    Case 2: Print #n, " *  indicates remailer reportedly supports repgp or remix"; xle;
                    Case 3: Print #n, " *  indicates remailer reportedly supports repgp or repgp2"; xle;
                    Case 4: Print #n, " *  indicates remailer reportedly supports remix or remix2"; xle;
                End Select
                Print #n, xle; xle;
            End If
            If p <> 0 Then
                Print #p, "</TABLE>"
                Select Case chain
                    Case 2: Print #p, " <SMALL><B>*</B> indicates remailer reportedly supports repgp or remix</SMALL>"
                    Case 3: Print #p, " <SMALL><B>*</B> indicates remailer reportedly supports repgp or repgp2</SMALL>"
                    Case 4: Print #p, " <SMALL><B>*</B> indicates remailer reportedly supports remix or remix2</SMALL>"
                End Select
                Print #p, "<BR><BR><BR>"
            End If
            DoEvents
        Next chain
        If n <> 0 Then
            Print #n, xle; xle;
            Close n: n = 0
        End If
        If p <> 0 Then Print #p, "</CENTER>"; vbCrLf; "</BODY></HTML>": Close p: p = 0
    End If
    
    Erase DayPing, ChainLog, Rmlr, RLine, RLineUp
    BuildStats = ""
Exit Function
BuildError:
    BuildStats = Format(Time, "short time") + " " + LMsg(344) + vbCrLf + "      " + Error + vbCrLf
    CloseFile (n)
    CloseFile (p)
    CloseFile (s)
End Function

Private Sub WriteMachine(n, xle)
    On Error GoTo WriteError
    If Cnf(8, 27) <> "" And SDir(Cnf(8, 27)) <> "" Then
        p = FreeFile
        Open Cnf(8, 27) For Input As p
        While Not EOF(p)
            Line Input #p, a
            Print #n, a; xle;
        Wend
        Close p: p = 0
        Print #n, xle; xle;
    End If
Exit Sub
WriteError:
    CloseFile p
    Err.Raise Err.Number
End Sub

