Attribute VB_Name = "Send"
'Copyright 1999 Potato Software.  All rights reserved.
'See MAIN.BAS for License.

Public SendList() As FilesType, SendDex() As Integer
Public SendMore As Boolean, PostMore As Boolean
Public SendErrorString(1) As String, SendErrorCode(1) As Integer
Public NewsUser As String, NewsPass As String, NewsTimeout As Boolean
Public AbortSend As Boolean

Public Sub SendStart(Job As Byte)
    'Job = 0  SMTP
    'Job = 1  NNTP
    Dim fc As Integer, flen As Long, Rcpt As String
    Dim SendDate As Date, SendCount As Integer, QFile(1) As String
    Dim dt As Date
    Dim HN As New DocHeadersCls  'Project|References|NetManage Internet Object
    
    'Activate
    SendMore = False: PostMore = False
    Mgr(3 + Job).Status = LMsg(88)
    KeepDate(3 + Job) = Date + Time
    Mgr(3 + Job).LastRun = KeepDate(3 + Job)
    Mgr(0).LastRun = KeepDate(3 + Job)
    TurnColor 3 + Job, True
    AbortSend = False
    
    'Move Errors
    If Date + Time - KeepDate(30) > 6 / 24 Then
        If Job = 0 Then b = Cnf(1, 5) + "\MAILOUT\" Else b = Cnf(1, 5) + "\NNTP\"
        'Requeue
        a = SDir(b + "Errors\*.Q*")
        If a <> "" Then
            Sess(3 + Job, 1) = Sess(3 + Job, 1) + Format(Time, "short time") + " " + LMsg(401) + vbCrLf
            SessUp (3 + Job)
            On Error Resume Next
            While a <> ""
                Name b + "Errors\" + a As b + a
                Kill b + "Errors\" + a
                a = Dir
            Wend
            QueueProb
            On Error GoTo 0
        End If
        KeepDate(30) = Date + Time
    End If
    
    'Read Dir
    If Job = 0 Then
        FilesInOut = FilesInDir(Cnf(1, 5) + "\MAILOUT\*.Q0")
        fc = FilesInOut
        ErrMsg = GetList(Cnf(1, 5) + "\MAILOUT", fc, 0, SendCount)
    Else
        FilesInOut = FilesInDir(Cnf(1, 5) + "\NNTP\*.Q0")
        fc = FilesInOut
        ErrMsg = GetList(Cnf(1, 5) + "\NNTP", fc, 1, SendCount)
    End If
        
    Mgr(3 + Job).Load = SendCount: SessUp (3 + Job)
    Mgr(2).Load = FilesInDir(Cnf(1, 5) + "\MAILIN\*.*")
    SessUp (2): SessUp (0)
    If ErrMsg <> "" Then
        Sess(3 + Job, 1) = Sess(3 + Job, 1) + "      " + ErrMsg + vbCrLf
        Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + ErrMsg + vbCrLf
        Mgr(3 + Job).Errors = Mgr(3 + Job).Errors + 1
        Mgr(0).Errors = Mgr(0).Errors + 1
        SessUp (3 + Job)
        SessUp (0)
        Erase SendList
        Erase SendDex
        Exit Sub
    End If
    
    If Job = 0 Then WriteSendList Cnf(1, 5) + "\MAILOUT", fc, 0 Else _
        WriteSendList Cnf(1, 5) + "\NNTP", fc, 1
    
    If fc = 0 Or SendCount = 0 Or frmMain!chkSession(3 + Job).Value = 0 Then GoTo Deactivate
    
    'Display
    If frmMain!mnuVerbose.Checked Then
        If Job = 0 Then x = 225 Else x = 311
        Sess(3 + Job, 1) = Sess(3 + Job, 1) + Format(Time, "short time") + " " + LMsg(x) + " " + Trim(Str(SendCount)) + " " + LMsg(31) + "  [" + Trim(Str(fc)) + "]" + vbCrLf
    End If
    SessUp (3 + Job)
    DoEvents
    
    'Connect
    On Error GoTo SendError
    SendErrorCode(Job) = 0
    If Job = 0 Then
        frmMain!barStat.SimpleText = LMsg(228) + " " + Cnf(6, 1) + "...": frmMain!barStat.Refresh
        
        'Connect to the server
        frmMain!SmtpClient1.Blocking = True
        frmMain!SmtpClient1.Timeout = Val(Cnf(1, 27))
        frmMain!SmtpClient1.HostName = Cnf(6, 1)
        frmMain!SmtpClient1.RemoteService = "smtp"
        errcode = frmMain!SmtpClient1.Connect
    Else
        errcode = 0
        frmMain!barStat.SimpleText = LMsg(228) + " " + Cnf(6, 2) + "...": frmMain!barStat.Refresh
        NewsUser = Cnf(6, 4)
        NewsPass = Cnf(6, 5)
        NewsTimeout = False
        frmMain!NNTP1.Timeout(0) = Val(Cnf(1, 27)) * 1000
        frmMain!NNTP1.Timeout(1) = Val(Cnf(1, 27)) * 1000
        ntimeout = Val(Cnf(1, 27)) / 24 / 60 / 60
        On Error Resume Next
        If frmMain!NNTP1.state <> 6 Then frmMain!NNTP1.Quit: DoEvents
        On Error GoTo SendError
        frmMain!NNTP1.Connect Cnf(6, 2)
        dt = Date + Time
        While ((frmMain!NNTP1.state <> prcConnected And frmMain!NNTP1.state <> prcDisconnected) Or frmMain!NNTP1.Busy) And Not NewsTimeout And Date + Time - dt < ntimeout
            DoEvents
        Wend
        If frmMain!NNTP1.state <> prcConnected And SendErrorCode(1) = 0 Then SendErrorCode(1) = -1: SendErrorString(1) = "ERROR NNTP Unable to connect"
    End If
    If SendErrorCode(Job) <> 0 Or errcode <> 0 Then GoTo SendError2
    
    frmMain!barProgress.Value = 0
    frmMain!barProgress.Visible = (Job = 0)
    mcount = 0
    For qx = 0 To fc - 1
        If SendList(SendDex(qx)).FileDate < Date + Time + (6 / 60 / 24) Then
            SendErrorCode(Job) = 0
            SendErrorString(Job) = ""
            mcount = mcount + 1
            malform = 0
            If Job = 0 Then
                QFile(0) = Cnf(1, 5) + "\MAILOUT\" + SendList(SendDex(qx)).Filename + ".Q0"
                QFile(1) = Cnf(1, 5) + "\MAILOUT\" + SendList(SendDex(qx)).Filename + ".Q1"
            Else
                QFile(0) = Cnf(1, 5) + "\NNTP\" + SendList(SendDex(qx)).Filename + ".Q0"
                QFile(1) = Cnf(1, 5) + "\NNTP\" + SendList(SendDex(qx)).Filename + ".Q1"
            End If
            If SDir(QFile(0)) = "" Or SDir(QFile(1)) = "" Then
                malform = 220
            End If
            If malform = 0 Then
                On Error GoTo TransError
                'Read Headers
                Rcpt = "": FromFound = False: MessageIDFound = False
                n = FreeFile
                Open QFile(0) For Input As n
                If Not EOF(n) Then Line Input #n, a Else a = ""
                If Job = 0 Then b = "RELI_MAILOUT" Else b = "RELI_NNTP"
                If a <> b Then
                    If a = "RELI_MAILOUT" Or a = "RELI_NNTP" Then
                        'In Wrong Q Folder
                        If a = "RELI_NNTP" Then b = "NNTP" Else b = "MAILOUT"
                        Close n: n = 0
                        For i = 0 To 1
                            If Dir(QFile(i)) <> "" Then FileCopy QFile(i), Cnf(1, 5) + "\" + b + "\" + PlainName(QFile(i), 2) + ".Q" + Trim(Str(i))
                            DelFile QFile(i)
                        Next i
                        SendList(SendDex(qx)).Filename = ""
                        Sess(3 + Job, 1) = Sess(3 + Job, 1) + "      " + LMsg(221) + vbCrLf
                        SessUp (3 + Job)
                        mcount = mcount - 1
                        GoTo NextMessage
                    Else
                        'Not a mail file
                        malform = 222
                    End If
                Else
                    'Parse Headers
                    If Not EOF(n) Then
                        Line Input #n, a
                        SendDate = a
                    End If
                    If Not EOF(n) Then Line Input #n, a 'Blank Line
                    Do While Not EOF(n)
                        Line Input #n, a
                        If Trim(a) <> "" Then
                            x = InStr(a, ":")
                            If x = 0 Then x = 1
                            b = LCase(Left(a, x - 1))
                            c = LTrim(Mid(a, x + 1))
                            If b = "to" Or b = "cc" Or b = "bcc" Or b = "newsgroups" Then
                                'Dest Blocked?
                                dsta = c + ","
                                Y = 1
                                xd = InStr(dsta, ",")
                                While xd <> 0
                                    a2 = Trim(Mid(dsta, Y, xd - Y))
                                    If a2 <> "" Then
                                        ta = SubSearch(b + ": " + a2, CnfFiles(8), 1)
                                        If ta <> "" Then
                                            Sess(3 + Job, 1) = Sess(3 + Job, 1) + "      " + LMsg(226) + ": " + ta + " (" + LMsg(38) + ")" + vbCrLf
                                            SessUp (3 + Job)
                                            Close n: n = 0
                                            DelFile QFile(0): DelFile QFile(1)
                                            SendList(SendDex(qx)).Filename = ""
                                            mcount = mcount - 1
                                            GoTo NextMessage
                                        End If
                                    End If
                                    Y = xd + 1
                                    xd = InStr(Y, dsta, ",")
                                Wend
                                'Set Recipient
                                If Job = 0 Then
                                    If b = "to" Or b = "cc" Or b = "bcc" Then Rcpt = Rcpt + "," + c
                                Else
                                    If b = "newsgroups" Then Rcpt = Trim(c)
                                End If
                            End If
                            If b = "from" Then FromFound = True
                            If b = "message-id" Then MessageIDFound = True
                        Else
                            Exit Do
                        End If
                    Loop
                    If Replace(Rcpt, ",", "") = "" Then malform = 222
                End If
                Close n: n = 0
            End If
            If malform <> 0 Then
                If Job = 0 Then b = "MAILOUT" Else b = "NNTP"
                Malformatted Cnf(1, 5) + "\" + b + "\" + SendList(SendDex(qx)).Filename, malform, Job
            Else
                'Send Message
                If Job = 0 Then
                    If AddressSMTP(Rcpt) <> 0 Then GoTo TransError2
                Else
                    HN.Clear
                End If
                n = FreeFile
                Open QFile(0) For Input As n
                frmMain!barStat.SimpleText = LMsg(229) + Str(mcount) + " of" + Str(SendCount) + "  [" + Trim(Str(fc)) + "]"
                Line Input #n, a
                Line Input #n, a
                Line Input #n, a
                Do While Not EOF(n)
                    Line Input #n, a
                    If a <> "" Then
                        'Send Headers
                        b = LCase(Extract(a, ":"))
                        If b <> "bcc" And b <> "date" And (b <> "organization" Or Cnf(1, 18) = "") Then
                            If Job = 1 Then HN.Add Extract(a, ":"), LTrim(Mid(a, InStr(a, ":") + 1))
                            If (Job = 0 And b = "to") Or (Job = 1 And b = "newsgroups") Then
                                'Add From
                                If Not FromFound Then
                                    a = a + vbCrLf + "From: " + Cnf(1, 19)
                                    If Job = 1 Then HN.Add "From", Cnf(1, 19)
                                End If
                                'Add Date
                                a = a + vbCrLf + "Date: " + DateLine(0)
                                If Job = 1 Then
                                    HN.Add "Date", DateLine(0)
                                    If Cnf(1, 18) <> "" Then HN.Add "Organization", Cnf(1, 18)
                                End If
                                'Add Message-ID
                                If LTrim(Cnf(6, 6)) <> "" And Not MessageIDFound Then
                                    b = "<" + MakeTag + Trim(Str((Date + Time) * 1)) + "@" + Trim(Cnf(6, 6)) + ">"
                                    a = a + vbCrLf + "Message-ID: " + b
                                    If Job = 1 Then HN.Add "Message-ID", b
                                End If
                            End If
                            If Job = 0 Then
                                frmMain!SmtpClient1.SendLen = Len(a) + 2
                                frmMain!SmtpClient1.SendData = a + vbCrLf
                            End If
                        End If
                    End If
                Loop
                Close n: n = 0
                'Add Comments
                a = ""
                For i = 8 To 11
                    If Cnf(1, i) <> "" Then
                        If a = "" Then
                            If Job = 0 Then a = "Comments: "
                        Else: a = a + "        "
                        End If
                        a = a + Left(Cnf(1, i), 70) + vbCrLf
                    End If
                Next i
                If Job = 1 And Len(a) > 2 Then HN.Add "Comments", Left(a, Len(a) - 2)
                If Cnf(1, 3) = "True" And Cnf(1, 2) <> "" Then
                    a = a + "X-Remailer-Contact: " + Cnf(1, 2) + vbCrLf
                    If Job = 1 Then HN.Add "X-Remailer-Contact", Cnf(1, 2)
                End If
                a = a + vbCrLf
                If Job = 0 Then
                    frmMain!SmtpClient1.SendLen = Len(a)
                    frmMain!SmtpClient1.SendData = a
                End If
                'Send Body
                If Job = 0 Then
                    n = FreeFile
                    Open QFile(1) For Binary As n
                    flen = LOF(n)
                    frmMain!barStat.SimpleText = LMsg(229) + Str(mcount) + " of" + Str(SendCount) + "  [" + Trim(Str(fc)) + "]" + "   " + Trim(Str(Int(flen / 1024))) + "k": frmMain!barStat.Refresh
                    If flen > 0 Then frmMain!barProgress.Max = flen
                    slen = flen - Loc(n)
                    While slen > 0
                        If slen > 1024 Then slen = 1024
                        a = Input(slen, n)
                        If Job = 0 Then
                            frmMain!SmtpClient1.SendLen = Len(a)
                            frmMain!SmtpClient1.SendData = a
                        End If
                        slen = flen - Loc(n)
                        If Loc(n) <= flen Then frmMain!barProgress.Value = Loc(n)
                    Wend
                    Close n: n = 0
                End If
                If Job = 0 Then
                    If frmMain!SmtpClient1.SendMail <> 0 Then GoTo TransError2
                Else
                    dt = Date + Time
                    'Debug.Print frmMain!NNTP1.Busy
                    'Debug.Print "X1:"; frmMain!NNTP1.ProtocolState
                    'Debug.Print "X2:"; frmMain!NNTP1.State
                    While frmMain!NNTP1.Busy And Date + Time - dt < ntimeout
                        DoEvents
                    Wend
                    If SendErrorCode(1) <> 0 Then GoTo TransError2
                    'Debug.Print frmMain!NNTP1.Busy
                    'Debug.Print "X1:"; frmMain!NNTP1.ProtocolState
                    'Debug.Print "X2:"; frmMain!NNTP1.State
                    frmMain!NNTP1.SendDoc , HN, , QFile(1)
                    If SendErrorCode(1) <> 0 Then GoTo TransError2
                    dt = Date + Time
                    While frmMain!NNTP1.Busy
                        DoEvents
                    Wend
                    If SendErrorCode(1) <> 0 Then GoTo TransError2
                End If
                On Error GoTo SendError
                DelFile QFile(0): DelFile QFile(1)
                SendList(SendDex(qx)).Filename = ""
            End If
NextMessage:
            On Error GoTo SendError
            Mgr(3 + Job).Load = Mgr(3 + Job).Load - 1: If Mgr(3 + Job).Load < 0 Then Mgr(3 + Job).Load = 0
            Mgr(3 + Job).Counter = Mgr(3 + Job).Counter + 1
            SessUp (3 + Job): SessUp (0)
        End If
        If Job = 0 Then
            If frmMain!chkSession(3 + Job).Value = 0 Then SendMore = True: Exit For
        Else
            If frmMain!chkSession(4).Value = 0 Then PostMore = True: Exit For
        End If
        If (Val(Cnf(6, 0)) <> 0 And (Date + Time - KeepDate(3 + Job)) * 24 * 60 > Val(Cnf(6, 0))) Then
            If frmMain!mnuVerbose.Checked Then
                Sess(3 + Job, 1) = Sess(3 + Job, 1) + "      " + LMsg(232) + vbCrLf
                SessUp (3 + Job)
            End If
            If Job = 0 Then SendMore = True Else PostMore = True
            Exit For
        End If
    Next qx
    
    frmMain!barProgress.Visible = False
    
    'Disconnect
    If Job = 0 Then
        frmMain!barStat.SimpleText = LMsg(230) + " " + Cnf(6, 1) + "...": frmMain!barStat.Refresh
        frmMain!SmtpClient1.Disconnect
        frmMain!barStat.SimpleText = "": frmMain!barStat.Refresh
        WriteSendList Cnf(1, 5) + "\MAILOUT", fc, 0
    Else
        frmMain!barStat.SimpleText = LMsg(230) + " " + Cnf(6, 2) + "...": frmMain!barStat.Refresh
        frmMain!NNTP1.Quit
        dt = Date + Time
        While frmMain!NNTP1.Busy And Date + Time - dt < ntimeout
            DoEvents
        Wend
        frmMain!barStat.SimpleText = "": frmMain!barStat.Refresh
        WriteSendList Cnf(1, 5) + "\NNTP", fc, 1
    End If
    
    Erase SendList
    Erase SendDex
    If frmMain!mnuVerbose.Checked Then
        Sess(3 + Job, 1) = Sess(3 + Job, 1) + Format(Time, "short time") + Str(mcount) + " " + LMsg(231) + vbCrLf
        SessUp (3 + Job)
    End If
    GoTo Deactivate
Exit Sub
TransError:
    Aerr = Error
    Aerrnum = Err.Number
    Resume TransError2
TransError2:
    Debug.Print Aerrnum, Aerr
    Debug.Print "SEND: "; SendErrorCode(Job), SendErrorString(Job)
    On Error GoTo SendError
    If Job = 0 Then
        Select Case SendErrorCode(0)
        '27122  Remote host receiving message data
        '27105  Invalid handle passed to function
        Case 27122, 27105: GoTo SendError2
        End Select
    End If
    If AbortSend Then GoTo SendError2
    mcount = mcount - 1
    'Write Error
    If Aerr = "" Then Aerr = SendErrorString(Job)
    If Aerr <> SendErrorString(Job) And SendErrorString(Job) <> "" Then Aerr = Aerr + vbCrLf + "      " + SendErrorString(Job)
    If Job = 0 Then a = LMsg(227) Else a = LMsg(312)
    b = "      " + LMsg(402) + " " + PlainName(QFile(0), 0) + "Errors\" + PlainName(QFile(0), 2) + ".Q*"
    Sess(3 + Job, 1) = Sess(3 + Job, 1) + Format(Time, "short time") + " " + a + vbCrLf + "      " + Aerr + vbCrLf + b + vbCrLf
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + a + vbCrLf + "      " + Aerr + vbCrLf + b + vbCrLf
    Mgr(3 + Job).Errors = Mgr(3 + Job).Errors + 1
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (3 + Job)
    Aerr = "": Aerrnum = 0
    Err.Clear
    CloseFile n
    For i = 0 To 1
        If Not CreateDir(PlainName(QFile(i), 0) + "Errors") Then GoTo SendError3
    Next i
    For i = 0 To 1
        Name QFile(i) As PlainName(QFile(i), 0) + "Errors\" + PlainName(QFile(i), 1)
    Next i
    If Job = 1 Then
        If frmMain!NNTP1.state <> prcConnected Then GoTo SendError3
    End If
    QueueProb
    SessUp (0)
    DoEvents
    'Deferred errors which should also cause disconnect/non-recoverable
    '27111  Operation timed out waiting for response from server
    If Job = 0 Then
        If SendErrorCode(0) = 27111 Then GoTo SendError3
    End If
    SendErrorCode(Job) = 0
    SendErrorString(Job) = ""
    GoTo NextMessage
SendError:
    Aerr = Error
    Resume SendError2
SendError2:
    On Error GoTo Deactivate
    If Aerr = "" Then Aerr = SendErrorString(Job)
    If Aerr <> SendErrorString(Job) And SendErrorString(Job) <> "" Then Aerr = Aerr + vbCrLf + "      " + SendErrorString(Job)
    If Job = 0 Then a = LMsg(227) Else a = LMsg(312)
    Sess(3 + Job, 1) = Sess(3 + Job, 1) + Format(Time, "short time") + " " + a + vbCrLf + "      " + Aerr + vbCrLf
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + a + vbCrLf + "      " + Aerr + vbCrLf
    Mgr(3 + Job).Errors = Mgr(3 + Job).Errors + 1
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (3 + Job)
    SessUp (0)
SendError3:
    Erase SendList
    Erase SendDex
    frmMain!barStat.SimpleText = "": frmMain!barStat.Refresh
    frmMain!barProgress.Visible = False
    CloseFile n
    On Error Resume Next
    If Job = 0 Then
        frmMain!SmtpClient1.Cancel
        frmMain!SmtpClient1.Disconnect
        frmMain!SmtpClient1.Reset
    Else
        frmMain!NNTP1.Cancel
        frmMain!NNTP1.Quit
    End If
    DoEvents
    On Error GoTo 0
Deactivate:
    Mgr(3 + Job).Status = LMsg(64)
    KeepDate(3 + Job) = Date + Time
    Mgr(3 + Job).LastRun = KeepDate(3 + Job)
    Mgr(0).LastRun = KeepDate(3 + Job)
    TurnColor 3 + Job, False
    SessUp (3 + Job): SessUp (0)
    SessionRunning = -1
    frmMain!tmrSession.Interval = 300
    frmMain!tmrSession.Enabled = True
End Sub

Public Function AddressSMTP(Rcpt) As Long
    Dim fa As String, a As String, Aerr As Long
    fa = Cnf(6, 3)
    If Trim(fa) = "" Then fa = CleanAddress(Cnf(1, 19))
    SendErrorCode(0) = 0: Aerr = 0
    frmMain!SmtpClient1.Address = fa
    Aerr = frmMain!SmtpClient1.AddressMail
    If SendErrorCode(0) <> 0 Then Aerr = SendErrorCode(0)
    If Aerr <> 0 Then AddressSMTP = Aerr: Exit Function
    Rcpt = Trim(Rcpt) + ","
    x = InStr(Rcpt, ",")
    Y = 1
    While x <> 0
        a = Trim(Mid(Rcpt, Y, x - Y))
        If a <> "" Then
            SendErrorCode(0) = 0
            frmMain!SmtpClient1.Recipient = CleanAddress(a)
            If SendErrorCode(0) <> 0 Then AddressSMTP = SendErrorCode(0): Exit Function
        End If
        Y = x + 1
        x = InStr(Y, Rcpt, ",")
    Wend
    AddressSMTP = 0
End Function

' SEND SHARED SMTP/NNTP =================================================

Public Function GetList(Fldr, fc, Job As Byte, SendCount As Integer) As String
    Dim IndexList() As FilesType, Now As Date
    
    If fc > 1000 Then fc = 1000
    On Error GoTo ReadIndexError
    If SDir(Fldr + "\Reliable.IDX") <> "" Then
        n = FreeFile
        Open Fldr + "\Reliable.IDX" For Input As n
        Line Input #n, a
        If Job = 0 Then b = "RELI_MAILOUT_INDEX" Else b = "RELI_NNTP_INDEX"
        If a <> b Then GoTo ReadIndexError2
        For i = 1 To 5
            Line Input #n, a
        Next i
        If a <> "---" Then GoTo ReadIndexError2
        ReDim IndexList(1010 + fc)
        ic = 0
        Do While Not EOF(n) And ic <= fc + 1010
            Line Input #n, IndexList(ic).Filename
            Line Input #n, a
            IndexList(ic).FileDate = a
            ic = ic + 1
        Loop
        Close n: n = 0
    End If

ReadFiles:
    On Error GoTo ReadFilesError
    ReDim SendList(fc + 5)
    ReDim SendDex(fc + 5)
    Now = Date + Time + (6 / 60 / 24)
    SendCount = 0
    x = 0
    b = Dir(Fldr + "\*.Q0")
    Do While b <> ""
        a = Left(b, Len(b) - 3)
        'Look in IndexList
        Found = False
        For i = 0 To ic - 1
            If IndexList(i).Filename = a Then
                'Found
                SendList(x).Filename = a
                SendList(x).FileDate = IndexList(i).FileDate
                Found = True
                Exit For
            End If
        Next i
        If Not Found Then
            SendList(x).Filename = a
            n = FreeFile
            Open Fldr + "\" + b For Input As n
            If Not EOF(n) Then Line Input #n, a Else a = ""
            If Not EOF(n) Then Line Input #n, d Else d = ""
            If (a <> "RELI_MAILOUT" And a <> "RELI_NNTP") Or d = "" Then
                'Not a valid mail queue file
                Close n: n = 0
                Malformatted Fldr + "\" + SendList(x).Filename, 222, Job
            Else
                SendList(x).FileDate = DateVal(d)
                Found = True
                Close n: n = 0
            End If
        End If
        If Found Then
            SendDex(x) = x
            If SendList(x).FileDate < Now Then SendCount = SendCount + 1
            x = x + 1: If x > fc + 5 Then Exit Do
        End If
        b = Dir
    Loop

    Erase IndexList
    
    fc = x
    If fc > 0 Then QuickSortSendList 0, fc - 1
    
    GetList = ""
Exit Function
ReadFilesError:
    GetList = LMsg(219) + vbCrLf + "      " + Error
    CloseFile n
Exit Function
ReadIndexError:
    Resume ReadIndexError2
ReadIndexError2:
    CloseFile n
    DelFile Fldr + "\Reliable.IDX"
    ic = 0
    GoTo ReadFiles
End Function

Public Sub Malformatted(QFile, msg, Job As Byte)
    On Error Resume Next
    FileCopy QFile + ".Q0", Cnf(1, 6) + "\" + PlainName(QFile, 1) + ".Q0"
    FileCopy QFile + ".Q1", Cnf(1, 6) + "\" + PlainName(QFile, 1) + ".Q1"
    Kill QFile + ".Q0"
    Kill QFile + ".Q1"
    Sess(3 + Job, 1) = Sess(3 + Job, 1) + "      " + LMsg(224) + " " + Cnf(1, 6) + "\" + PlainName(QFile, 1) + ".Q*" + vbCrLf + "      " + LMsg(msg) + vbCrLf
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(224) + " " + Cnf(1, 6) + "\" + PlainName(QFile, 1) + ".Q*" + vbCrLf + "      " + LMsg(msg) + vbCrLf
    Mgr(3 + Job).Errors = Mgr(3 + Job).Errors + 1
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    SessUp (3 + Job)
End Sub

Public Sub WriteSendList(Fldr, fc, Job As Byte)
    'Write Index
    On Error GoTo WriteIndexError
    If fc > 1000 Then fc = 1000
    n = FreeFile
    Open Fldr + "\Reliable.IDX" For Output As n
    If Job = 0 Then Print #n, "RELI_MAILOUT_INDEX" Else Print #n, "RELI_NNTP_INDEX"
    Print #n, "Reliable Disposable Index File"
    Print #n, "This file may be deleted at will - no mail will be lost."
    Print #n, "DO NOT EDIT or move this file."
    Print #n,
    Print #n, "---"
    For i = 0 To fc - 1
        If SendList(i).Filename <> "" Then
            Print #n, SendList(i).Filename
            Print #n, SendList(i).FileDate
        End If
    Next i
    Close n: n = 0
Exit Sub
WriteIndexError:
    CloseFile n
    DelFile Fldr + "\Reliable.IDX"
End Sub

Private Sub QuickSortSendList(Start As Integer, Finish As Integer)
    Dim PosOfSplitter As Integer
    'Partition:
    Dim SplitPos As Integer, LeftPos As Integer
    Dim i As Integer, Splitter As Date, temp As Integer
    
    If Finish > Start Then
        'Begin Partition
        SplitPos = Start + Int((Finish - Start + 1) * Rnd)  'or  = (Start + Finish) / 2
        Splitter = SendList(SendDex(SplitPos)).FileDate
        temp = SendDex(SplitPos): SendDex(SplitPos) = SendDex(Start): SendDex(Start) = temp
        LeftPos = Start
        For i = Start + 1 To Finish
            If SendList(SendDex(i)).FileDate < Splitter Then
                LeftPos = LeftPos + 1
                temp = SendDex(LeftPos): SendDex(LeftPos) = SendDex(i): SendDex(i) = temp
            End If
        Next i
        temp = SendDex(Start): SendDex(Start) = SendDex(LeftPos): SendDex(LeftPos) = temp
        PosOfSplitter = LeftPos
        'End Partition
        QuickSortSendList Start, PosOfSplitter - 1
        QuickSortSendList PosOfSplitter + 1, Finish
    End If
End Sub


