Attribute VB_Name = "Retrieve"
'Copyright 1999 Potato Software.  All rights reserved.
'See MAIN.BAS for License.

Public MailFileNum As Integer, POPMsg As Long, TotalMsgCount As Long
Public RetrieveMore As Boolean, RetrieveErrorDate As Date
Public MailHead As String, MailText As String
Public CancelRetrieve As Boolean, AbortRetrieve As Boolean
Public POPErrorCode As Integer, POPErrorString As String
Dim MsgFrom() As String, dlcount As Long, md5count As Long

Public Sub RetrieveStart()
    Dim MsgSize As Long

    On Error GoTo RetrieveError

    'Activate
    RetrieveMore = False
    RetrieveErrorDate = 0
    Mgr(1).Status = LMsg(88)
    TurnColor 1, True
    TimerCheck = Date + Time
    frmMain!tmrCancel.Tag = "Retrieve"
    frmMain!tmrCancel.Interval = 10000
    frmMain!tmrCancel.Enabled = True

    LargeThresh = SVal(Cnf(1, 13))
    OverThresh = SVal(Cnf(1, 14))
    dlcount = 0: md5count = 0

    'Manager
    Mgr(2).Load = FilesInDir(Cnf(1, 5) + "\MAILIN\*.*")
    SessUp (2)
    KeepDate(1) = Date + Time
    Mgr(1).LastRun = KeepDate(1)
    Mgr(0).LastRun = KeepDate(1)
    Mgr(1).Load = FilesInIn
    SessUp (1): SessUp (0)

    ' Connect to POP server
    frmMain!PopClient1.Timeout = Val(Cnf(1, 27))  'seconds
    frmMain!PopClient1.HostName = Cnf(4, 3)
    frmMain!PopClient1.UserName = Cnf(4, 2)
    frmMain!PopClient1.Password = Cnf(4, 4)
    frmMain!barStat.SimpleText = LMsg(228) + " " + Cnf(4, 3) + "...": frmMain!barStat.Refresh
    For i = 0 To 1  'Loop corrects "Invalid response from server" error
        POPErrorCode = 0
        TimerCheck = Date + Time
        frmMain!PopClient1.Connect
        TimerCheck = Date + Time
        If POPErrorCode <> 26712 Then Exit For
        DoEvents
    Next i
    If POPErrorCode <> 0 Then GoTo RetrieveError2
    frmMain!PopClient1.Blocking = True
    frmMain!PopClient1.LineBreak = False
    
    'Prepare
    TotalMsgCount = frmMain!PopClient1.MessageCount
    Mgr(1).Load = TotalMsgCount
    SessUp (0)
    HighLoad = (Mgr(0).Load > Val(Cnf(1, 12)))
    If frmMain!mnuVerbose.Checked Then
        Sess(1, 1) = Sess(1, 1) + vbCrLf + Format(Time, "short time") + " POP:" + Str(TotalMsgCount) + " " + LMsg(31) + vbCrLf
    End If
    SessUp (1)
    DoEvents
    
    'Scan/Retrieve
    If TotalMsgCount > 0 Then
        ReDim MsgFrom(TotalMsgCount)
        frmMain!barProgress.Value = 0
        frmMain!barProgress.Visible = True
        
        'Scan
        If Cnf(4, 11) = "True" Then
            For POPMsg = 1 To TotalMsgCount
                Fail = False: msg = "":: MsgSize = 0
                frmMain!barProgress.Max = TotalMsgCount
                'Get Size
                MsgSize = GetPOPSize(POPMsg)
                frmMain!barStat.SimpleText = "Scanning Message" + Str(POPMsg) + " of" + Str(TotalMsgCount) + "  (" + Trim(Str(Int(MsgSize / 1024))) + "k)"
                'Oversize
                If MsgSize > OverThresh Then
                    If Cnf(4, 9) = "True" Then
                        frmMain!PopClient1.DeleteMessage POPMsg
                        dlcount = dlcount + 1
                        msg = LMsg(32) + " (" + Trim(Str(Int(MsgSize / 1024))) + "k)"
                    Else
                        msg = LMsg(33) + " (" + Trim(Str(Int(MsgSize / 1024))) + "k)"
                    End If
                    Fail = True
                End If
                'Large
                If MsgSize > LargeThresh And Cnf(4, 10) = "True" And HighLoad And Not Fail Then
                    Fail = True
                    msg = LMsg(34) + " (" + Trim(Str(Int(MsgSize / 1024))) + "k)"
                End If
                If Not Fail Then
                    'Get Scan
                    AbortRetrieve = False: CancelRetrieve = False
                    MailHead = "": MailText = "": MailFileNum = 0
                    ErrMsg = ReadPOPMessage(7)
                    If Not CancelRetrieve Then Fail = TestMessage(True) Else Fail = True
                End If
                If msg <> "" Then
                    Sess(1, 1) = Sess(1, 1) + "     " + Str(POPMsg) + ":(scan) " + msg + vbCrLf
                    SessUp (1)
                End If
                frmMain!barProgress.Value = POPMsg
                If (Date + Time - KeepDate(1)) * 24 * 60 > Val(Cnf(4, 1)) And (Val(Cnf(4, 1)) <> 0) Then
                    If frmMain!mnuVerbose.Checked Then
                        Sess(1, 1) = Sess(1, 1) + "     " + LMsg(44) + vbCrLf
                        SessUp (1)
                    End If
                    RetrieveMore = True
                    GoTo Done
                End If
                If frmMain!chkSession(1).Value = 0 Then RetrieveMore = True: GoTo Done
            Next POPMsg
            If Val(Cnf(4, 12)) <> 0 And Val(Cnf(4, 13)) <> 4 Then
                'Check Message Count
                For i = 1 To TotalMsgCount
                    If MsgFrom(i) <> "" Then
                        t = 0
                        For j = 1 To TotalMsgCount
                            If MsgFrom(i) = MsgFrom(j) Then t = t + 1
                        Next j
                        If t > Val(Cnf(4, 12)) Then
                            Sess(1, 1) = Sess(1, 1) + "      " + LMsg(35) + vbCrLf + "      From: " + MsgFrom(i) + vbCrLf
                            Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(35) + vbCrLf + "      From: " + MsgFrom(i) + vbCrLf
                            Mgr(1).Warnings = Mgr(1).Warnings + 1
                            Mgr(0).Warnings = Mgr(0).Warnings + 1
                            'Message Count Exceeded
                            '0 Delete all unretrieved messages from server, but process retrieved messages
                            '1 Delete all unretrieved messages from server, and add sender to Source Block
                            '2 Leave unretrieved messages on server, and process retrieved messages
                            '3 Leave unretrieved messages on server, and add sender to Source Block
                            '4XRetrieve and process all messages normally
                            If Val(Cnf(4, 13)) = 1 Or Val(Cnf(4, 13)) = 3 Then
                                'Add sender to source block
                                CnfFiles(6) = CnfFiles(6) + "From: " + MsgFrom(i) + vbCrLf
                                n = FreeFile
                                Open ProgDir + "\config6.dat" For Output As n
                                Print #n, CnfFiles(6);
                                Close n: n = 0
                                Sess(1, 1) = Sess(1, 1) + "      " + LMsg(36) + vbCrLf
                            End If
                            tempfrom = MsgFrom(i)
                            For j = 1 To TotalMsgCount
                                If MsgFrom(j) = tempfrom Then
                                    MsgFrom(j) = ""
                                    If Val(Cnf(4, 13)) < 2 Then
                                        frmMain!PopClient1.DeleteMessage j
                                        dlcount = dlcount + 1
                                    End If
                                End If
                            Next j
                            Sess(1, 1) = Sess(1, 1) + "     " + Str(t) + " " + LMsg(31)
                            If Val(Cnf(4, 13)) < 2 Then Sess(1, 1) = Sess(1, 1) + " " + LMsg(38) + vbCrLf Else Sess(1, 1) = Sess(1, 1) + " " + LMsg(37) + vbCrLf
                            SessUp (1): SessUp (0)
                        End If
                    End If
                Next i
            End If
            frmMain!barStat.SimpleText = "": frmMain!barStat.Refresh
        End If
        If frmMain!chkSession(1).Value = 0 Then GoTo Done
        
        'Retrieve
        For POPMsg = 1 To TotalMsgCount
            Fail = False: msg = ""
            If MsgFrom(POPMsg) <> "" Or Cnf(4, 11) <> "True" Then
                frmMain!barProgress.Value = 0
                If Cnf(4, 11) <> "True" Then
                    'Get Size
                    MsgSize = GetPOPSize(POPMsg)
                    'Oversize
                    If MsgSize > OverThresh Then
                        If Cnf(4, 9) = "True" Then
                            frmMain!PopClient1.DeleteMessage POPMsg
                            dlcount = dlcount + 1
                            msg = LMsg(32) + " (" + Trim(Str(Int(MsgSize / 1024))) + "k)"
                        Else
                            msg = LMsg(33) + " (" + Trim(Str(Int(MsgSize / 1024))) + "k)"
                        End If
                        Fail = True
                    End If
                    'Large
                    If MsgSize > LargeThresh And Cnf(4, 10) = "True" And Not Fail Then
                        Fail = True
                        msg = LMsg(34) + " (" + Trim(Str(Int(MsgSize / 1024))) + "k)"
                    End If
                End If
                If Not Fail Then
                    CancelRetrieve = False: AbortRetrieve = False
                    ErrMsg = ReadPOPMessage(0)
                    If MailFileNum <> 0 Then Close MailFileNum: MailFileNum = 0
                    If Not AbortRetrieve Then
                        If Cnf(4, 11) <> "True" And Not CancelRetrieve Then
                            'No Scan
                            Fail = TestMessage(False)
                            If Not Fail And MsgFrom(POPMsg) <> "" And Val(Cnf(4, 12)) <> 0 And Val(Cnf(4, 13)) <> 4 Then
                                'Check Message Count
                                t = 0
                                For j = 1 To TotalMsgCount
                                    If MsgFrom(POPMsg) = MsgFrom(j) Then t = t + 1
                                Next j
                                If t > Val(Cnf(4, 12)) Then
                                    If t = Val(Cnf(4, 12)) + 1 Then
                                        Sess(1, 1) = Sess(1, 1) + "      " + LMsg(35) + vbCrLf + "      From: " + MsgFrom(POPMsg) + vbCrLf
                                        Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(35) + vbCrLf + "      From: " + MsgFrom(POPMsg) + vbCrLf
                                        Mgr(1).Warnings = Mgr(1).Warnings + 1
                                        Mgr(0).Warnings = Mgr(0).Warnings + 1
                                        SessUp (0)
                                    End If
                                    'Message Count Exceeded
                                    '0 Delete all unretrieved messages from server, but process retrieved messages
                                    '1 Delete all unretrieved messages from server, and add sender to Source Block
                                    '2 Leave unretrieved messages on server, and process retrieved messages
                                    '3 Leave unretrieved messages on server, and add sender to Source Block
                                    '4XRetrieve and process all messages normally
                                    Fail = True
                                    If Val(Cnf(4, 13)) = 1 Or Val(Cnf(4, 13)) = 3 Then
                                        'Add sender to source block
                                        CnfFiles(6) = CnfFiles(6) + "From: " + MsgFrom(POPMsg) + vbCrLf
                                        n = FreeFile
                                        Open ProgDir + "\config6.dat" For Output As n
                                        Print #n, CnfFiles(6);
                                        Close n: n = 0
                                        Sess(1, 1) = Sess(1, 1) + "      " + LMsg(36) + vbCrLf
                                    End If
                                    If Val(Cnf(4, 13)) < 2 Then
                                        frmMain!PopClient1.DeleteMessage POPMsg
                                        dlcount = dlcount + 1
                                        If t = Val(Cnf(4, 12)) + 1 Then Sess(1, 1) = Sess(1, 1) + "      " + LMsg(38) + vbCrLf
                                    End If
                                    If t = Val(Cnf(4, 12)) + 1 Then SessUp (1)
                                End If
                            End If
                        End If
                        'MD5
                        If Not (Fail Or CancelRetrieve) And Int(Val(Cnf(4, 15))) > 0 Then
                            If Not MD5Test(MailFile) Then
                                Fail = True: msg = ""
                                If Cnf(4, 5) = "True" Then frmMain!PopClient1.DeleteMessage POPMsg: dlcount = dlcount + 1
                                md5count = md5count + 1
                            End If
                        End If
                        If Fail Or CancelRetrieve Then
                            'Delete Failed Message File
                            Kill MailFile
                        Else
                            'Keep Good Message
                            'Delete Message From Server
                            If Cnf(4, 5) = "True" Then frmMain!PopClient1.DeleteMessage POPMsg: dlcount = dlcount + 1
                            rtcount = rtcount + 1
                        End If
                    Else
                        'Retrieval Aborted
                        If MailFile <> "" Then Kill MailFile
                        Sess(1, 1) = Sess(1, 1) + "      " + LMsg(39) + vbCrLf
                        SessUp (1)
                        Exit For
                    End If
                    MailFile = ""
                End If
            End If
            If msg <> "" Then
                Sess(1, 1) = Sess(1, 1) + "     " + Str(POPMsg) + ": " + msg + vbCrLf
                SessUp (1)
            End If
            Mgr(1).Load = Mgr(1).Load - 1: If Mgr(1).Load < 0 Then Mgr(1).Load = 0
            Mgr(1).Counter = Mgr(1).Counter + 1
            SessUp (1): SessUp (0)
            If (Date + Time - KeepDate(1)) * 24 * 60 > Val(Cnf(4, 1)) And (Val(Cnf(4, 1)) <> 0) Then
                If frmMain!mnuVerbose.Checked Then
                    Sess(1, 1) = Sess(1, 1) + "     " + LMsg(44) + vbCrLf
                    SessUp (1)
                End If
                RetrieveMore = True
                GoTo Done
            End If
            If frmMain!chkSession(1).Value = 0 Then RetrieveMore = True: GoTo Done
        Next POPMsg
    End If
Done:
    frmMain!barProgress.Visible = False
    GoTo Deactivate
Exit Sub
RetrieveError:
    Aerr = Err.Description
    Resume RetrieveError2
RetrieveError2:
    On Error GoTo RetrieveError3
    frmMain!barProgress.Visible = False
    frmMain!barStat.SimpleText = ""
    If TimerCheck <> 0 Then a = LMsg(40) Else a = LMsg(42) 'Error ret / Time out
    If POPErrorString = Aerr Or POPErrorCode = 0 Then POPErrorString = ""
    If Aerr <> "" Then b = Aerr + vbCrLf Else b = ""
    If POPErrorString <> "" Then b = b + POPErrorString + vbCrLf
    If b <> "" Then b = "      " + b
    Sess(1, 1) = Sess(1, 1) + Format(Time, "short time") + " " + a + vbCrLf + b
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + a + vbCrLf + b
    Mgr(1).Errors = Mgr(1).Errors + 1
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    SessUp (1)
    AbortRetrieve = True
    CloseFile MailFileNum: MailFileNum = 0
    If MailFile <> "" Then If Dir(MailFile) <> "" Then Kill MailFile
    MailFile = ""
    RetrieveErrorDate = Date + Time
    frmMain!PopClient1.Cancel
    GoTo Deactivate
RetrieveError3:
    Resume Deactivate
Deactivate:
    On Error Resume Next
    frmMain!tmrCancel.Enabled = False: frmMain!tmrCancel.Tag = ""
    frmMain!barStat.SimpleText = LMsg(230) + " " + Cnf(4, 3) + "..."
    frmMain!barStat.Refresh
    frmMain!PopClient1.Disconnect
    frmMain!barStat.SimpleText = ""
    If TotalMsgCount > 0 And frmMain!mnuVerbose.Checked Then
        If md5count = 0 Then a = "" Else a = "     " + Str(md5count) + " " + LMsg(362) + vbCrLf
        Sess(1, 1) = Sess(1, 1) + "      -------------------------------------------" + vbCrLf + _
         a + "     " + Str(rtcount) + " " + LMsg(28) + vbCrLf + _
         "     " + Str(dlcount) + " " + LMsg(29) + vbCrLf + _
         "     " + Str(TotalMsgCount - dlcount) + " " + LMsg(30) + vbCrLf
        SessUp (1)
    End If
    WeekStats (TotalMsgCount)
    Mgr(1).Status = LMsg(64)
    TurnColor 1, False
    SessUp (1)
    SessionRunning = -1
    frmMain!tmrSession.Interval = 300
    frmMain!tmrSession.Enabled = True
End Sub

Private Function TestMessage(Scan As Boolean) As Boolean
    Dim OrigFrom As String, Fail As Boolean, x As Integer
    
    Fail = False
    
    'Find From
    x = InStr(MailHead, vbCrLf + "Reply-To: ")
    If x <> 0 Then
        OrigFrom = Extract(Mid(MailHead, x + 13), vbCrLf)
    Else
        x = InStr(MailHead, vbCrLf + "From: ")
        If x <> 0 Then OrigFrom = Extract(Mid(MailHead, x + 8), vbCrLf)
    End If
    
    'Set tm
    ts = SubSearch(MailHead, CnfFiles(6), 0)
    If ts <> "" Then
        'Source Blocked
        'Send Source Block Message
        b = BlockMessage(OrigFrom): If b <> "" Then b = b + vbCrLf + "      "
        Fail = True
        frmMain!PopClient1.DeleteMessage POPMsg
        dlcount = dlcount + 1
        msg = b + LMsg(21) + ": " + ts
    Else
        ts = SubSearch(MailHead, CnfFiles(5), 0)
        If ts = "" And Val(Cnf(4, 6)) <> 2 Then
            'Source Not Allowed
            Select Case Val(Cnf(4, 6))
            Case 0
                'Leave messages on server
                Fail = True
                If frmMain!mnuVerbose.Checked Then msg = LMsg(22)
            Case 1
                'Delete messages
                Fail = True
                frmMain!PopClient1.DeleteMessage POPMsg
                dlcount = dlcount + 1
                msg = LMsg(23)
            'Case 2
                'Ignore filter list and retrieve all messages
            End Select
        Else
            'Not info request or ping response?
            If InStr(1, MailHead, vbCrLf + "Subject: remailer-", vbTextCompare) + _
               InStr(1, MailHead, vbCrLf + "Subject: freedom-conf", vbTextCompare) + _
               InStr(1, MailHead, vbCrLf + "Subject: help", vbTextCompare) + _
               InStr(1, MailHead, vbCrLf + "Subject: conf", vbTextCompare) + _
               InStr(1, MailHead, vbCrLf + "Subject: reliable-", vbTextCompare) + _
               InStr(1, MailHead, vbCrLf + "Subject: -------MKS-RSP-------", vbTextCompare) + _
               InStr(1, MailText, "-------MKS-RSP-------" + vbCrLf) = 0 Then
                If Cnf(4, 8) = "True" Then
                    If InStr(1, MailText, "::" + vbCrLf + "Encrypted: PGP", vbTextCompare) + InStr(1, MailText, "::" + vbCrLf + "Remailer-Type: Mixmaster", vbTextCompare) = 0 Then
                        'Non-Encrypted
                        Fail = True
                        frmMain!PopClient1.DeleteMessage POPMsg
                        dlcount = dlcount + 1
                        msg = LMsg(25)
                    End If
                Else
                    If Cnf(4, 7) = "True" Or Cnf(4, 14) = "True" Then
                        If Not (MailText Like "*::" + vbCrLf + "*:*") Then
                            'Non-Remailer
                            If Cnf(4, 7) = "True" Then
                                'Delete Non-Remailer
                                Fail = True
                                frmMain!PopClient1.DeleteMessage POPMsg
                                dlcount = dlcount + 1
                                msg = LMsg(24)
                            Else
                                'Leave Non-Remailer
                                Fail = True
                                If frmMain!mnuVerbose.Checked Then msg = LMsg(330)
                            End If
                        End If
                    End If
                End If
            End If
       End If
    End If
    If Not Fail Then
        'Find From Header
        If Left(MailHead, 6) = "From: " Then MailHead = vbCrLf + MailHead + vbCrLf
        x = InStr(MailHead, vbCrLf + "From: ")
        If x = 0 Then
            'From Header Not Found
            MsgFrom(POPMsg) = ""
            If Scan Then
                msg = LMsg(27)
            Else
                msg = LMsg(26)
            End If
            SessUp (1)
        Else
            MsgFrom(POPMsg) = Extract(Mid(MailHead, x + 8), vbCrLf)
        End If
    Else
        MsgFrom(POPMsg) = ""
    End If
    If msg <> "" Then
        If Scan Then sc = "(scan)"
        Sess(1, 1) = Sess(1, 1) + "     " + Str(POPMsg) + ":" + sc + " " + msg + vbCrLf
        SessUp (1)
    End If
    TestMessage = Fail
End Function

Private Function ReadPOPMessage(MaxLines As Integer) As String
    Dim Buffer As String, nb As Long, a As String
    Dim ErrCount As Byte
    
    MailHead = "": MailText = ""
    If MaxLines <> 0 Then
        'Scan
        frmMain!PopClient1.Command = "TOP" + Str(POPMsg) + Str(MaxLines)
        frmMain!PopClient1.MultiLine = True
    Else
        'Retrieve
        frmMain!PopClient1.MultiLine = False
        frmMain!PopClient1.GetMessage POPMsg
        MsgSize = frmMain!PopClient1.MessageSize
        frmMain!barStat.SimpleText = "Retrieving message" + Str(POPMsg) + " of" + Str(TotalMsgCount) + "  (" + Trim(Str(Int(MsgSize / 1024))) + "k)": frmMain!barStat.Refresh
        frmMain!barProgress.Value = 0
        If MsgSize > 0 Then frmMain!barProgress.Max = MsgSize
        Do
            MTag = MakeTag
            MailFile = Cnf(1, 5) + "\MAILIN\" + MTag + ".ML0"
        Loop Until Dir(MailFile) = ""
        MailFileNum = FreeFile
        Open MailFile For Output As MailFileNum
        Print #MailFileNum, "From pop3@Reliable " + DateLine(1)
    End If
    POPErrorString = ""
    On Error GoTo BugFix
    If MaxLines <> 0 Then
        'Scan
        Do
            frmMain!PopClient1.Read Buffer, 1024
            a = a + Buffer
            DoEvents
            TimerCheck = Date + Time
        Loop Until frmMain!PopClient1.RecvNext = 0 Or Not frmMain!PopClient1.Connected
        frmMain!PopClient1.MultiLine = False
    Else
        'Retrieve
        Do
            frmMain!PopClient1.RecvLen = 1024
            Buffer = frmMain!PopClient1.RecvData
            If InStr(Buffer, Chr(0)) <> 0 Then Buffer = Replace(Buffer, Chr(0), " ")
            If InStr(Buffer, Chr(26)) <> 0 Then Buffer = Replace(Buffer, Chr(26), " ")
            If Len(Buffer) > 0 Then Print #MailFileNum, Buffer;
            nb = nb + frmMain!PopClient1.RecvLen 'Actual bytes received
            If nb < 5000 Then a = a + Buffer
            If nb <= frmMain!barProgress.Max Then frmMain!barProgress.Value = nb
            DoEvents
            TimerCheck = Date + Time
        Loop Until Len(Buffer) < 1024 Or Not frmMain!PopClient1.Connected
        If Not frmMain!PopClient1.Connected Then AbortRetrieve = True
        Close MailFileNum: MailFileNum = 0
    End If
    x = InStr(a, vbCrLf + vbCrLf)
    If x = 0 Then
        MailHead = a
    Else
        MailHead = Left(a, x + 1)
        MailText = Mid(a, x + 4)
    End If
    'Debug.Print "========================"
    'Debug.Print MailHead
    'Debug.Print "========================"
    'Debug.Print MailText
    'Debug.Print "========================"
    ReadPOPMessage = ""
Exit Function
BugFix:
    'This attempts to correct a bug where retrieval is halted
    'by a "runtime error 0"
    If Error = "" And POPErrorString = "" And ErrCount < 2 Then
        Debug.Print "Bang Resume"
        ErrCount = ErrCount + 1
        DoEvents
        Resume
    End If
    Debug.Print "Bang Raise"
    Err.Raise Err.Number, Err.Description
End Function

Private Function GetPOPSize(MsgNum) As Long
    frmMain!PopClient1.Command = "LIST" + Str(MsgNum)
    frmMain!PopClient1.MultiLine = True
    a = Trim(frmMain!PopClient1.ResultString)
    If frmMain!PopClient1.Trace Then
        n = FreeFile
        Open ProgDir + "\trace.log" For Append As n
        Print #n, "ResultString (Msgsize)="; a
        Close n: n = 0
    End If
    x = InStr(a, " ")
    If Val(Extract(a, " ")) <> MsgNum Or x = 0 Then
        GetPOPSize = 0
    Else
        GetPOPSize = Val(Mid(a, x + 1))
    End If
    frmMain!PopClient1.MultiLine = False
End Function

Public Function MD5Test(MFile) As Boolean
    Dim MD5Date As Date, MD5File As String, MD5Hash As String
    Dim MD5Msg As String * 65500, TempHash As String * 32
    Dim Body As Boolean, TempMsg As String
    Dim Fromh As String, Subjecth As String, ReplyToh As String
    Dim ExpHours As Integer
    Dim x As Long, Y As Long, h As String, a As String
    
    On Error GoTo MD5Error
    ExpHours = Int(Val(Cnf(4, 15)))
    If SDir(MFile) = "" Or ExpHours <= 0 Then MD5Test = True: Exit Function
    n = FreeFile
    Open MFile For Input As n
    x = LOF(n)
    If x > 65500 Then x = 65500
    TempMsg = Input(x, n)
    Close n: n = 0
    x = InStr(TempMsg, vbCrLf + vbCrLf)
    If x = 0 Then TempMsg = TempMsg + vbCrLf + vbCrLf: x = Len(TempMsg) - 3
    'Find Headers
    h = vbCrLf + Left(TempMsg, x - 1)
    'From
    Y = InStr(1, h, vbCrLf + "From:", vbTextCompare)
    If Y <> 0 Then Fromh = LCase(Extract(Mid(h, Y + 2), vbCrLf)) + vbCrLf
    'Reply-To
    Y = InStr(1, h, vbCrLf + "Reply-To:", vbTextCompare)
    If Y <> 0 Then ReplyToh = LCase(Extract(Mid(h, Y + 2), vbCrLf))
    'Subject
    Y = InStr(1, h, vbCrLf + "Subject:", vbTextCompare)
    If Y <> 0 Then Subjecth = LCase(Extract(Mid(h, Y + 2), vbCrLf))
    If Not (Subjecth Like "subject:*conf*" Or _
       Subjecth Like "subject:*-stat*" Or _
       Subjecth Like "subject:*help*" Or _
       Subjecth Like "subject:*-key*") Then Subjecth = ""
    'Body
    Body = True
    TempMsg = Mid(TempMsg, x + 4)
    If Len(TempMsg) < 255 Then
        If LTrim(Replace(TempMsg, vbCrLf, "")) = "" Then Body = False
    End If
    If Not Body And Subjecth = "" Then MD5Test = False: Exit Function
    If Not Body Then
        TempMsg = Subjecth + vbCrLf + ReplyToh + vbCrLf
        ExpHours = 3
    End If
        
    'Get Hash
    MD5Msg = Left(Fromh + TempMsg, 65499) & Chr(0)
    x = MD5(MD5Msg, TempHash)
    MD5Hash = Trim(Extract(TempHash, Chr(0)))
    MD5Test = True
    If Len(MD5Hash) = 32 Or x = 0 Then
        If SDir(Cnf(1, 5) + "\md5log") = "" Or Date + Time - KeepDate(24) > 3 / 24 Then
            p = FreeFile
            If SDir(Cnf(1, 5) + "\md5log") = "" Then
                Open Cnf(1, 5) + "\md5log" For Output As p
                Print #p, MD5Hash
                Write #p, Date + Time
                Close p: p = 0
                MD5Test = True
                Exit Function
            Else
                Open Cnf(1, 5) + "\md5log.tmp" For Output As p
            End If
        End If
        n = FreeFile
        Open Cnf(1, 5) + "\md5log" For Input As n
        Do While Not EOF(n)
            Line Input #n, a
            MD5Date = 0
            On Error Resume Next
            Input #n, MD5Date
            On Error GoTo MD5Error
            If a = MD5Hash Then
                If MD5Date <> 0 And (Date + Time - MD5Date) * 24 <= ExpHours Then
                    'Duplicate
                    MD5Test = False
                    If p = 0 Then Close n: Exit Function
                End If
            End If
            If p <> 0 Then
                If MD5Date <> 0 And (Date + Time - MD5Date) * 24 < ExpHours Then
                    Print #p, a
                    Write #p, MD5Date
                End If
            End If
        Loop
        Close n: n = 0
        If p <> 0 Then
            If MD5Test Then Print #p, MD5Hash: Write #p, Date + Time
            Close p: p = 0
            FileCopy Cnf(1, 5) + "\md5log.tmp", Cnf(1, 5) + "\md5log"
            DelFile Cnf(1, 5) + "\md5log.tmp"
            KeepDate(24) = Date + Time
        Else
            n = FreeFile
            Open Cnf(1, 5) + "\md5log" For Append As n
            Print #n, MD5Hash
            Write #n, Date + Time
            Close n: n = 0
        End If
        Exit Function
    End If
    'MD5 failure
    Err.Description = ""
MD5Error:
    If Error <> "" Then a = vbCrLf + "      " + Error Else a = ""
    Sess(1, 1) = Sess(1, 1) + Format(Time, "short time") + " " + LMsg(363) + a + vbCrLf
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(363) + a + vbCrLf
    Mgr(1).Errors = Mgr(1).Errors + 1
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    SessUp (1)
    CloseFile p
    CloseFile n
    DelFile MD5File
    MD5Test = True
End Function
