Attribute VB_Name = "Process"
'Copyright 1999 Potato Software.  All rights reserved.
'See MAIN.BAS for License.

Private Type RemHType
    AnonTo As String
    AnonPostTo As String
    RemixTo As String
    EncryptTo As String
    RemailTo As String
    LatentTime As String
    Cutmarks As String
    EncryptKey As String
    Encrypt3DES As String
    EncryptCAST As String
    EncryptSubject As String
    RandHop As String
    Inflate As String
    TestTo As String
    EncryptTest As String
    MaxSize As String
    MaxCount As String
    MaxDate As String
    Subject As String
    Newsgroups As String
    CC As String
    Bcc As String
    From As String
    MIMEVersion As String
    MIMEContent As String
    Hash As String
    Middle As Boolean
    TransRePGP As Boolean
    TransRemix As Boolean
    RemixList As String
    ReList As String
    RePGP As Boolean
    NewTo As String
    Size As Long
    MD5Hash As String
End Type
Dim Files() As FilesType, BlankRemH As RemHType
Dim TMsg As String, TSrc As String, PreMsg As String
Dim RandCount As Integer, PingProcessed As Boolean
Public RebuildStats As Boolean

Private Sub Process(ByVal Src As String)
    Dim a As String, Headers As String, THash As String
    Dim Job As String, msg As String, RSrc As String, x As Long
    Dim RemH As RemHType
    Dim OrigMix As Boolean, MixFinal As Boolean, OrigPGP As Boolean
    Dim LocalMail As Boolean, OrigFrom As String, TestOrigFrom As String
    Dim MD5Msg As String * 8192, tempdate As Date, TempHash As String * 32
    Dim ConvAlg As Long, cekey As String
    Dim PlainSubject As String * 256, EncSubject As String * 256
    Dim SubjectKey As String * 256, ret As Long
    
    On Error GoTo ProcessError
    TMsg = "Remailer-Type: Reliable v" + Version + vbCrLf + MakeString + vbCrLf + vbCrLf + _
           "BEGIN: Preprocessing message " + PlainName(Src, 1) + " at " + RTrim(Left(DateLine(0), 20)) + " GMT" + vbCrLf
    TSrc = ""

    TestOrigFrom = "": PreMsg = ""
    
    'Open
    n = FreeFile
    Open Src For Input As n
    'Size?
    RemH.Size = LOF(n)
    If RemH.Size > SVal(Cnf(1, 14)) Then Close n: n = 0: msg = LMsg(66): GoTo Failure
    
    a = ""
    While Not EOF(n) And Trim(a) = ""
        Line Input #n, a
    Wend
    
    'Previous Mix Message?
    If a = "-----Final Hop-----" Then GoTo MixMess
    
    'Sent Middle
    If Left(a, 25) = "From send.middle@Reliable" Then
        For i = 1 To 4: Line Input #n, a: Next i
        GoTo RemailerHeaders
    End If
    
    'Sent Local
    LocalMail = Left(a, 19) = "From local@Reliable"
    OrigPGP = Left(a, 27) = "From pgp.decrypted@Reliable"
    
    'Get Headers
    Headers = a + vbCrLf
    x = 0
    While Not EOF(n) And Trim(a) <> ""
        Line Input #n, a
        Headers = Headers + a + vbCrLf
        x = x + 1
        If Trim(a) <> "" And (x > 70 Or EOF(n)) Then Close n: n = 0: msg = LMsg(63): GoTo Failure
        If Left(a, 6) = "From: " Then OrigFrom = Mid(a, 7)
        If Left(a, 10) = "Reply-To: " Then OrigRT = Mid(a, 11)
        If Left(a, 17) = "Reliable-MD5SUM: " Then RemH.MD5Hash = Mid(a, 18): If Len(RemH.MD5Hash) <> 32 Then RemH.MD5Hash = ""
    Wend
    If OrigRT <> "" Then OrigFrom = OrigRT
    OrigRT = ""
    TestOrigFrom = OrigFrom
    
    'Parse Top of Message
    a = ""
    While Not EOF(n) And Trim(a) = ""
        Line Input #n, a
    Wend
    If Not LocalMail And Not OrigPGP Then
        'Source Block?
        ta = SubSearch(Headers, CnfFiles(6), 0)
        If ta <> "" Then
            b = BlockMessage(OrigFrom): If b <> "" Then b = b + vbCrLf + "      "
            Close n: n = 0: msg = b + LMsg(67) + ": " + ta: GoTo Failure
        End If
        'Source Allowed?
        If Val(Cnf(4, 6)) <> 2 Then
            ta = SubSearch(Headers, CnfFiles(5), 0)
            If ta = "" Then
                If Val(Cnf(4, 6)) = 0 Then
                    'Leave messages on server (send to dump)
                    Close n: n = 0: Job = "Plain": msg = LMsg(68): GoTo Failure
                Else
                    'Delete messages
                    Close n: n = 0: msg = LMsg(68): GoTo Failure
                End If
            End If
        End If
    End If
    
    'Non-remailer message?
    If a = "-------MKS-RSP-------" Then msg = ProcessPing(n, Src, Headers, Job): GoTo Failure
    If Trim(a) = "##" Then Close n: n = 0: msg = LMsg(69): GoTo Failure
    If Trim(a) <> "::" Then
        x = InStr(Headers, vbCrLf + "Subject:")
        If x <> 0 And CleanAddress(OrigFrom) <> "" Then
            'Info Request?
            RSrc = "": RSrcFile = ""
            Subj = LCase(Trim(Extract(Mid(Headers, x + 10), vbCrLf)))
            If Subj Like "remailer-conf*" Or _
               Subj Like "reliable-conf*" Or _
               Subj Like "freedom-conf*" Or _
               Subj Like "config" Or _
               Subj Like "conf" Or _
               Subj Like "remailer-stat*" Or _
               Subj Like "reliable-stat*" Then
                RSrcFile = PrepareConf
            Else
                If Subj Like "remailer-help" Or _
                   Subj Like "reliable-help" Or _
                   Subj Like "help" Then
                    If Dir(ProgDir + "\config13.dat") <> "" Then
                        RSrcFile = GetWork
                        FileCopy ProgDir + "\config13.dat", RSrcFile
                    Else
                        RSrc = "Help file not found." + vbCrLf
                    End If
                Else
                    If Subj Like "remailer-key" Or _
                       Subj Like "reliable-key" Then RSrc = CnfFiles(12)
                End If
            End If
            If RSrc = "" And RSrcFile = "" Then
                Close n: n = 0: Job = "Plain": msg = LMsg(65): GoTo Failure
            Else
                If RSrcFile = "" Then
                    Close n: n = 0
                    RSrcFile = GetWork
                    n = FreeFile
                    Open RSrcFile For Output As n
                        Print #n, RSrc
                    Close n: n = 0
                End If
                'Dest blocked?
                ta = SubSearch("To: " + OrigFrom, CnfFiles(8), 1)
                If ta <> "" Then DelFile RSrcFile: msg = LMsg(226) + ": " + a: GoTo Failure
                If Cnf(1, 4) <> "True" Or Val(Cnf(1, 20)) = 0 Then
                    'Queue
                    ErrMsg = QueueMail(RSrcFile, OrigFrom, "Subject: Re: " + Subj + "  [" + Cnf(1, 0) + "]" + vbCrLf + "From: " + Cnf(1, 19) + vbCrLf, "+0:00", "", 0)
                Else
                    ErrMsg = SendMiddle(RSrcFile, OrigFrom, "Re: " + Subj + "  [" + Cnf(1, 0) + "]")
                End If
                DelFile RSrcFile
                If ErrMsg <> "" Then Job = "Prob": msg = ErrMsg: GoTo Failure
                GoTo Failure
            End If
        End If
        Close n: n = 0: Job = "Plain": msg = LMsg(65): GoTo Failure
    End If
    
    'Large?
    If HighLoad And RemH.Size > SVal(Cnf(1, 13)) And ((Val(Cnf(5, 3)) = 0) Or ((Date + Time - FileDateTime(Src)) * 24 * 60 < SVal(Cnf(5, 3)))) Then
        Close n: n = 0: Job = "Defer": msg = LMsg(71): GoTo Failure
    End If

ParseTop:
    'Clear Original Headers
    OrigMix = False: Headers = "": OrigFrom = ""
    'Read First Line
    If Not EOF(n) Then Line Input #n, a Else a = ""
    a = Trim(a)
    If a = "" Then Close n: n = 0: msg = LMsg(69): GoTo Failure
    'Mixmaster?
    If Left(a, 25) = "Remailer-Type: Mixmaster " Then
        TMsg = TMsg + "Unmixmaster: Message is in Mixmaster format" + vbCrLf
        If Cnf(3, 0) <> "True" Then Close n: n = 0: msg = LMsg(70): GoTo Failure
        Close n: n = 0
        Dst = UnMixmaster(Src, ErrMsg)
        If Dst = "" Then
            'Unmix failure
            If InStr(ErrMsg, "Unable to get private key") = 1 Then Job = "Trash": msg = LMsg(173) + vbCrLf + "      " + ErrMsg: GoTo Failure
            If ErrMsg = "Ignoring redundant message." Or ErrMsg = "Ignoring old message." Or ErrMsg = "Succeeded storing partial message." Or ErrMsg = "No valid recipients." Then
                'Recognized No Output
                'Translate Error Message
                Select Case ErrMsg
                Case "Ignoring redundant message.": ErrMsg = LMsg(338)
                Case "Succeeded storing partial message.": ErrMsg = LMsg(339)
                Case "No valid recipients.": ErrMsg = LMsg(340)
                Case "Ignoring old message.": ErrMsg = LMsg(361)
                End Select
                msg = "Mixmaster: " + ErrMsg
                GoTo Failure
            Else
                If Left(ErrMsg, 7) = "Error: " Then Job = "Prob" Else Job = "Trash"
                If Trim(ErrMsg) <> "" Then msg = LMsg(337) + vbCrLf + "      " + ErrMsg Else msg = LMsg(337)
                GoTo Failure
            End If
        End If
        RemH = BlankRemH
        DelFile Src
        Src = Dst
        
        n = FreeFile
        Open Src For Input As n
        If Not EOF(n) Then Line Input #n, a
MixMess:
        'Size?
        RemH.Size = LOF(n)
        If RemH.Size > SVal(Cnf(1, 14)) Then Close n: n = 0: msg = LMsg(66): GoTo Failure
        'Large?
        If HighLoad And RemH.Size > SVal(Cnf(1, 13)) And ((SVal(Cnf(5, 3)) = 0) Or ((Date + Time - FileDateTime(Src)) * 24 * 60 < SVal(Cnf(5, 3)))) Then
            Close n: n = 0: Job = "Defer": msg = LMsg(71): GoTo Failure
        End If
        MixFinal = (a = "-----Final Hop-----")
        If MixFinal Or a = "-----Intermediate Hop-----" Then
            If Not EOF(n) Then Line Input #n, a Else a = "END"
            TMsg = TMsg + vbCrLf + "Mix Recipients:" + vbCrLf
            Do
                If a <> "END" Then
                    If LCase(Left(a, 5)) = "post:" Then
                        a = Trim(Mid(a, 6))
                        If RemH.AnonPostTo = "" Then RemH.AnonPostTo = a Else RemH.AnonPostTo = RemH.AnonPostTo + "," + a
                        TMsg = TMsg + "Post: " + a + vbCrLf
                        If Cnf(1, 21) <> "True" Then TMsg = TMsg + "     WARNING: Posting disabled" + vbCrLf: RemH.AnonPostTo = ""
                    Else
                        If RemH.AnonTo = "" Then RemH.AnonTo = a Else RemH.AnonTo = RemH.AnonTo + "," + a
                        TMsg = TMsg + "To: " + a + vbCrLf
                    End If
                End If
                If Not EOF(n) Then Line Input #n, a Else Exit Do
            Loop Until a = "END"
            If a = "END" Then
                If MixFinal Then
                    OrigMix = True
                    a = "##"
                    GoTo HashHeaders
                Else
                    RemH.RemailTo = RemH.AnonTo
                    RemH.AnonTo = ""
                    If Not EOF(n) Then Line Input #n, a
                    GoTo Process2
                End If
            End If
        End If
        Close n: n = 0: msg = LMsg(94): GoTo Failure
    End If
    'CPunk?
    If Cnf(2, 0) <> "True" Then Close n: n = 0: msg = LMsg(73): GoTo Failure
    'PGP Encrypted?
    If a = "Encrypted: PGP" Then
        TMsg = TMsg + "UnPGP: Message is PGP Encrypted" + vbCrLf
        PGPSrc = GetWork
        p = FreeFile
        Open PGPSrc For Output As p
        While Not EOF(n) And a <> "-----END PGP MESSAGE-----"
            Line Input #n, a
            Print #p, Trim(a)
        Wend
        Close p: p = 0
        If a = "-----END PGP MESSAGE-----" Then
            PGPDst = Decrypt(PGPSrc, XCrypt("@@@" + RSS, RightWin))
        Else
            Close n: n = 0: msg = LMsg(364): GoTo Failure
        End If
        If PGPDst <> "" Then
            'MD5 Hash
            RemH.MD5Hash = ""
            p = FreeFile
            Open PGPSrc For Input As p
            x = LOF(p)
            If x > 8191 Then x = 8191
            a = Input(x, p)
            Close p: p = 0
            x = InStr(a, "-----BEGIN PGP MESSAGE-----" + vbCrLf)
            If x <> 0 Then
                x = InStr(x, a, vbCrLf + vbCrLf)
                a = Mid(a, x + 4)
                If x <> 0 And Len(Extract(a, vbCrLf)) = 64 And InStr(a, vbCrLf + vbCrLf) = 0 And InStr(a, ":") = 0 Then
                    MD5Msg = Extract(a, "=") + Chr(0)
                    x = MD5(MD5Msg, TempHash)
                    RemH.MD5Hash = Trim(Extract(TempHash, Chr(0)))
                    If Len(RemH.MD5Hash) <> 32 Or x <> 0 Then Close n: n = 0: Close p: p = 0: msg = LMsg(363): Job = "Prob": GoTo Failure
                End If
            End If
        End If
        DelFile PGPSrc
        If PGPDst = "" Then Close n: n = 0: Job = "Trash": msg = LMsg(76): GoTo Failure
        p = FreeFile
        Open PGPDst For Input As p
        'Size?
        If LOF(p) > SVal(Cnf(1, 14)) Then Close p: p = 0: DelFile PGPDst: Close n: n = 0: msg = LMsg(66): GoTo Failure
        
        NewSrc = GetWork
        n2 = FreeFile
        Open NewSrc For Output As n2
        Print #n2, "From pgp.decrypted@Reliable "; DateLine(1)
        If RemH.MD5Hash <> "" Then Print #n2, "Reliable-MD5SUM: "; RemH.MD5Hash
        Print #n2, "To: "; Cnf(1, 1)
        Print #n2,
        While Not EOF(p)
            Line Input #p, a
            Print #n2, a
        Wend
        Close p: p = 0
        DelFile PGPDst
        While Not EOF(n)
            Line Input #n, a
            Print #n2, a
        Wend
        Close n: n = 0
        Close n2: n2 = 0
        DelFile Src
        Src = NewSrc
        n = FreeFile
        Open Src For Input As n
        'Size?
        RemH.Size = LOF(n)
        If RemH.Size > SVal(Cnf(1, 14)) Then Close n: n = 0: msg = LMsg(66): GoTo Failure
        Do While Not EOF(n)
            Line Input #n, a
            If Trim(a) = "" Then Exit Do
        Loop
        a = ""
        While Not EOF(n) And Trim(a) = ""
            Line Input #n, a
        Wend
        If Trim(a) = "::" Then
            OrigPGP = True
            GoTo ParseTop
        Else
            msg = LMsg(65): Job = "Plain": GoTo Failure
        End If
    Else
        'PGPOnly?
        If Cnf(2, 2) = "True" And Not OrigPGP Then Close n: n = 0: msg = LMsg(74): GoTo Failure
    End If
    
RemailerHeaders:
    'Read Remailer Directives
    Fail = False
    TMsg = TMsg + vbCrLf + "Remailer Directives:" + vbCrLf + "::" + vbCrLf
    Do While a <> "" And a <> "##"
        TMsg = TMsg + a + vbCrLf
        x = InStr(a, ":")
        If x = 0 Then x = 1
        b = Left(a, x - 1)
        c = Trim(Mid(a, x + 1))
        If b = "" Then Close n: n = 0: msg = LMsg(69): TMsg = TMsg + "ERROR: Incorrectly formatted remailer directive" + vbCrLf: GoTo Failure
        If InStr(1, vbCrLf + CnfFiles(9), vbCrLf + b + ":", vbTextCompare) = 0 Then
            WrongSection = False
            Select Case LCase(b)
            Case "anon-to", "request-remailing-to"
                RemH.AnonTo = c
            Case "anon-post-to", "post-to", "post"
                If Cnf(1, 21) = "True" Then RemH.AnonPostTo = c Else TMsg = TMsg + "     WARNING: Anon-Post-To header disabled" + vbCrLf
            Case "remix-to"
                If Cnf(2, 9) = "True" Or Cnf(2, 8) = "True" Then
                    RemH.RemixTo = c
                    If HighLoad And Cnf(5, 2) = "True" And ((SVal(Cnf(5, 3)) = 0) Or ((Date + Time - FileDateTime(Src)) * 24 * 60 < SVal(Cnf(5, 3)))) And RemH.TestTo = "" Then
                        Close n: n = 0: Job = "Defer": msg = LMsg(93): GoTo Failure
                    End If
                Else
                    TMsg = TMsg + "     WARNING: Remix-To header disabled" + vbCrLf
                End If
            Case "encrypt-to"
                If Cnf(2, 6) = "True" Or Cnf(2, 5) = "True" Then RemH.EncryptTo = c Else TMsg = TMsg + "     WARNING: Encrypt-To header disabled" + vbCrLf
            Case "remail-to"
                RemH.RemailTo = c
            Case "latent-time", "latent"
                If Cnf(2, 3) = "True" Then RemH.LatentTime = c Else TMsg = TMsg + "     WARNING: Latent-Time header disabled" + vbCrLf
            Case "cutmarks"
                RemH.Cutmarks = c
            Case "encrypt-key", "encryptkey", "encrypt-idea"
                If Cnf(2, 13) = "True" Then RemH.EncryptKey = c Else Close n: n = 0: msg = LMsg(75): TMsg = TMsg + "ERROR: Encrypt-Key not supported" + vbCrLf: GoTo Failure
                If (Val(Cnf(1, 17)) = 0 And Len(RemH.EncryptKey) > 94 - 2 * (Len(Cnf(1, 7)) + 11)) Or (Val(Cnf(1, 17)) = 1 And Len(RemH.EncryptKey) > 255) Then Close n: n = 0: msg = LMsg(218): TMsg = TMsg + "ERROR: Encrypt-Key too long" + vbCrLf: GoTo Failure
            Case "encrypt-3des", "encrypt-des", "encrypt-cast", "encrypt-cast5"
                If Val(Cnf(1, 17)) <> 0 And Cnf(2, 13) = "True" Then
                    If LCase(b) = "encrypt-3des" Or LCase(b) = "encrypt-des" Then
                        RemH.Encrypt3DES = c
                    Else
                        RemH.EncryptCAST = c
                    End If
                Else
                    Close n: n = 0: msg = LMsg(423): TMsg = TMsg + "ERROR: Encrypt-3DES/CAST not supported" + vbCrLf: GoTo Failure
                End If
            Case "encrypt-subject"
                RemH.EncryptSubject = c
            Case "rand-hop", "randhop", "rhop"
                If SVal(Cnf(2, 10)) <> 0 And SVal(c) > 0 Then RemH.RandHop = c Else TMsg = TMsg + "     WARNING: Rand-Hop header disabled" + vbCrLf
            Case "inflate"
                If SVal(Cnf(2, 4)) <> 0 And SVal(c) > 0 Then RemH.Inflate = c Else TMsg = TMsg + "     WARNING: Inflate header disabled" + vbCrLf
            Case "test-to"
                RemH.TestTo = c
                If LCase(Trim(RemH.TestTo)) = "me" Then
                    If TestOrigFrom = "" Then RemH.TestTo = "": Close n: n = 0: msg = LMsg(72): GoTo Failure
                    RemH.TestTo = TestOrigFrom
                End If
            Case "encrypt-test"
                RemH.EncryptTest = c
                If Len(RemH.EncryptTest) > 94 - 2 * (Len(Cnf(1, 7)) + 11) Then RemH.TestTo = "": Close n: n = 0: msg = LMsg(218): GoTo Failure
            Case "max-size", "maxsize"
                RemH.MaxSize = c
            Case "max-count", "maxcount"
                RemH.MaxCount = c
            Case "max-date", "maxdate"
                RemH.MaxDate = c
            Case "subject"
                RemH.Subject = Left(c, 80)
                If InStr(1, LTrim(RemH.Subject), "cmsg", vbTextCompare) <> 0 Then RemH.Subject = "None": TMsg = TMsg + "     WARNING: Control Subject header set to 'None'" + vbCrLf
                WrongSection = True
            Case "newsgroups"
                RemH.Newsgroups = Replace(Left(c, 1024), " ", "")
                WrongSection = True
            Case "cc"
                RemH.CC = c
                WrongSection = True
            Case "bcc"
                RemH.Bcc = c
                WrongSection = True
            Case "from"
                RemH.From = c
                WrongSection = True
            Case "null"
                Close n: n = 0: msg = "": TMsg = TMsg + "ERROR: (expected) Null header terminates processing" + vbCrLf: GoTo Failure
            Case Else
                TMsg = TMsg + "     WARNING: Directive (above) not recognized (ignored)" + vbCrLf
            End Select
            If WrongSection Then TMsg = TMsg + "     WARNING: Header (above) belongs in hash section (auto-corrected)" + vbCrLf
        Else
            TMsg = TMsg + "     WARNING: Header (above) stripped" + vbCrLf
        End If
        If Not EOF(n) Then Line Input #n, a Else a = ""
        a = Trim(a)
    Loop
            
HashHeaders:
    'Read Hash Headers
    If Not EOF(n) And Trim(a) <> "##" Then Line Input #n, a
    If Trim(a) = "##" Then
        TMsg = TMsg + vbCrLf + "Hash Headers:" + vbCrLf + "##" + vbCrLf
        t = 0
        Do While Not EOF(n)
            Line Input #n, a: TMsg = TMsg + a + vbCrLf
            t = t + 1: If t > 30 Then Close n: n = 0: msg = LMsg(69): TMsg = tsmg + "ERROR: Too many hash headers (30)" + vbCrLf: GoTo Failure
            a = LTrim(Left(a, 1024))
            If Trim(a) = "##" Then GoTo HashHeaders
            x = InStr(a, ":")
            If x <> 0 Then
                ContentFlag = False
                b = Left(a, x - 1)
                c = Trim(Mid(a, x + 1))
                If b <> "" And InStr(1, vbCrLf + CnfFiles(9), vbCrLf + b + ":", vbTextCompare) = 0 Then
                    If LCase(Left(b, 8)) = "content-" Then
                        RemH.MIMEContent = RemH.MIMEContent + b + ": " + c + vbCrLf: ContentFlag = True
                    Else
                        WrongSection = False
                        Select Case LCase(b)
                        Case "anon-to", "request-remailing-to"
                            RemH.AnonTo = c
                            WrongSection = True
                        Case "anon-post-to", "post-to", "post"
                            If Cnf(1, 21) = "True" Then RemH.AnonPostTo = c Else TMsg = TMsg + "     WARNING: Anon-Post-To header disabled" + vbCrLf
                            WrongSection = True
                        Case "remix-to"
                            If Cnf(2, 9) = "True" Or Cnf(2, 8) = "True" Then
                                RemH.RemixTo = c
                                If HighLoad And Cnf(5, 2) = "True" And ((SVal(Cnf(5, 3)) = 0) Or ((Date + Time - FileDateTime(Src)) * 24 * 60 < SVal(Cnf(5, 3)))) And RemH.TestTo = "" Then
                                    Close n: n = 0
                                    Job = "Defer": msg = LMsg(93): GoTo Failure
                                End If
                            Else
                                TMsg = TMsg + "     WARNING: Remix-To header disabled" + vbCrLf
                            End If
                            WrongSection = True
                        Case "encrypt-to"
                            If Cnf(2, 6) = "True" Or Cnf(2, 5) = "True" Then RemH.EncryptTo = c Else TMsg = TMsg + "     WARNING: Encrypt-To header disabled" + vbCrLf
                            WrongSection = True
                        Case "remail-to"
                            RemH.RemailTo = c
                            WrongSection = True
                        Case "latent-time", "latent"
                            If Cnf(2, 3) = "True" Then RemH.LatentTime = c Else TMsg = TMsg + "     WARNING: Latent-Time header disabled" + vbCrLf
                            WrongSection = True
                        Case "cutmarks"
                            RemH.Cutmarks = c
                            WrongSection = True
                        Case "encrypt-key", "encryptkey"
                            If Cnf(2, 13) = "True" Then RemH.EncryptKey = c Else Close n: n = 0: msg = LMsg(75): TMsg = TMsg + "ERROR: Encrypt-Key not supported" + vbCrLf: GoTo Failure
                            If (Val(Cnf(1, 17)) = 0 And Len(RemH.EncryptKey) > 94 - 2 * (Len(Cnf(1, 7)) + 11)) Or (Val(Cnf(1, 17)) = 1 And Len(RemH.EncryptKey) > 255) Then Close n: n = 0: msg = LMsg(218): TMsg = TMsg + "ERROR: Encrypt-Key too long" + vbCrLf: GoTo Failure
                            WrongSection = True
                        Case "encrypt-3des", "encrypt-des", "encrypt-cast", "encrypt-cast5"
                            If Val(Cnf(1, 17)) <> 0 And Cnf(2, 13) = "True" Then
                                If LCase(b) = "encrypt-3des" Or LCase(b) = "encrypt-des" Then
                                    RemH.Encrypt3DES = c
                                Else
                                    RemH.EncryptCAST = c
                                End If
                            Else
                                Close n: n = 0: msg = LMsg(423): TMsg = TMsg + "ERROR: Encrypt-3DES/CAST not supported" + vbCrLf: GoTo Failure
                            End If
                            WrongSection = True
                        Case "encrypt-subject"
                            RemH.EncryptSubject = c
                            WrongSection = True
                        Case "rand-hop", "randhop", "rhop"
                            If SVal(Cnf(2, 10)) <> 0 And SVal(c) > 0 Then RemH.RandHop = c Else TMsg = TMsg + "     WARNING: Rand-Hop header disabled" + vbCrLf
                            WrongSection = True
                        Case "inflate"
                            If SVal(Cnf(2, 4)) <> 0 And SVal(c) > 0 Then RemH.Inflate = c Else TMsg = TMsg + "     WARNING: Inflate header disabled" + vbCrLf
                            WrongSection = True
                        Case "test-to"
                            RemH.TestTo = c
                            If LCase(Trim(RemH.TestTo)) = "me" Then
                                If TestOrigFrom = "" Then RemH.TestTo = "": Close n: n = 0: msg = LMsg(72): GoTo Failure
                                RemH.TestTo = TestOrigFrom
                            End If
                            WrongSection = True
                        Case "encrypt-test"
                            RemH.EncryptTest = c
                            If Len(RemH.EncryptTest) > 94 - 2 * (Len(Cnf(1, 7)) + 11) Then RemH.TestTo = "": Close n: n = 0: msg = LMsg(218): GoTo Failure
                            WrongSection = True
                        Case "max-size", "maxsize"
                            RemH.MaxSize = c
                            WrongSection = True
                        Case "max-count", "maxcount"
                            RemH.MaxCount = c
                            WrongSection = True
                        Case "max-date", "maxdate"
                            RemH.MaxDate = c
                            WrongSection = True
                        Case "newsgroups"
                            RemH.Newsgroups = c
                        Case "to"
                        Case "cc", "bcc"
                            If LCase(b) = "cc" Then RemH.CC = c Else RemH.Bcc = c
                        Case "subject"
                            RemH.Subject = c
                            If InStr(1, LTrim(RemH.Subject), "cmsg", vbTextCompare) <> 0 Then RemH.Subject = "None": TMsg = TMsg + "     WARNING: Control Subject header set to 'None'" + vbCrLf
                        Case "from"
                            RemH.From = c
                        Case "comments"
                            For i = 8 To 11
                                If Trim(Cnf(1, i)) <> "" Then
                                     TMsg = TMsg + "     WARNING: Comments header removed" + vbCrLf
                                    Exit For
                                End If
                            Next i
                        Case "x-remailer-contact"
                            TMsg = TMsg + "     WARNING: X-Remailer-Contact header removed" + vbCrLf
                        Case "mime-version"
                            RemH.MIMEVersion = c
                        Case Else
                            RemH.Hash = RemH.Hash + b + ": " + c + vbCrLf
                        End Select
                        If WrongSection And Not OrigMix Then TMsg = TMsg + "     WARNING: Directive (above) belongs in remailer (::) section (auto-corrected)" + vbCrLf
                    End If
                Else
                    TMsg = TMsg + "     WARNING: Header (above) stripped" + vbCrLf
                End If
            Else
                If a <> "" Then
                    If Left(a, 1) <> " " Then a = "        " + a
                    If ContentFlag Then
                        RemH.MIMEContent = RemH.MIMEContent + a + vbCrLf
                    Else
                        RemH.Hash = RemH.Hash + a + vbCrLf
                    End If
                Else
                    Exit Do
                End If
            End If
        Loop
        If Not EOF(n) And a = "" Then Line Input #n, a Else a = ""
        If Trim(a) = "##" And OrigMix Then GoTo HashHeaders
    End If
    
Process2:
    FirstLine = a
    'Clean Headers
    TestOrigFrom = ""
    TMsg = TMsg + vbCrLf + "BEGIN: Examining headers" + vbCrLf
    'Max-Count
    If RemH.MaxCount <> "" Then
        If RemH.MD5Hash = "" Then TMsg = TMsg + vbCrLf + "ERROR: Message format not compatible with Max-Count" + vbCrLf: Close n: n = 0: GoTo Failure
        x = Int(SVal(RemH.MaxCount))
        If x <= 0 Then TMsg = TMsg + vbCrLf + "ERROR: Max-Count value is invalid" + vbCrLf: Close n: n = 0: GoTo Failure
        If x > 5 Then
            If x < 11 Then Y = 4 Else Y = 6
            x = x + Int(Rnd(1) * Y)
        End If
        fn = Cnf(1, 5) + "\md5count"
        If SDir(fn) <> "" Then tempdate = FileDateTime(fn) Else tempdate = 0
        Y = 0: p = 0
        n2 = FreeFile
        Open Cnf(1, 5) + "\md5count.tmp" For Output As n2
        If Int(tempdate) = Int(Date) Then
            p = FreeFile
            Open fn For Input As p
            While Not EOF(p)
                Line Input #p, a
                If Not EOF(p) Then Line Input #p, b Else b = "1"
                If a = RemH.MD5Hash Then
                    Y = Val(b)
                    If Y <> -1 Then TMsg = TMsg + vbCrLf + "Message Count =" + Str(Y + 1) + vbCrLf
                    If Y >= x Or Y = -1 Then Y = -1 Else Y = Y + 1
                    b = Str(Y)
                End If
                Print #n2, a
                Print #n2, b
            Wend
        End If
        If Y = 0 Then Print #n2, RemH.MD5Hash; vbCrLf; "1": TMsg = TMsg + vbCrLf + "Message Count = 1" + vbCrLf
        Close n2: n2 = 0
        If p <> 0 Then Close p: p = 0
        FileCopy Cnf(1, 5) + "\md5count.tmp", fn
        DelFile Cnf(1, 5) + "\md5count.tmp"
        If Y = -1 Then TMsg = TMsg + vbCrLf + "Message count exceeds Max-Count" + vbCrLf: Close n: n = 0: GoTo Failure
    End If
    'Max-Size
    If RemH.MaxSize <> "" Then
        TMsg = TMsg + vbCrLf + "Message Size =" + Str(Int((RemH.Size / 1024 + 0.04999) * 10) / 10) + "k" + vbCrLf
        x = SVal(RemH.MaxSize)
        If RemH.Size > x * 1024 Then TMsg = TMsg + vbCrLf + "Message length exceeds Max-Size" + vbCrLf: Close n: n = 0: GoTo Failure
    End If
    'Max-Date
    If RemH.MaxDate <> "" Then
        tempdate = ResolveDate(RemH.MaxDate)
        If tempdate <> 0 And InStr(RemH.MaxDate, ":") = 0 Then tempdate = tempdate + 1
        If tempdate = 0 Or Date + Time > tempdate Then
            If tempdate = 0 Then
                TMsg = TMsg + vbCrLf + "ERROR: Date format in Max-Date is invalid" + vbCrLf
            Else
                TMsg = TMsg + vbCrLf + "Message is expired per Max-Date" + vbCrLf
            End If
            Close n: n = 0: GoTo Failure
        End If
    End If
    ExtMsg = CleanHeaders(RemH)
    If ExtMsg <> "" And frmMain!mnuVerbose.Checked Then Sess(2, 1) = Sess(2, 1) + "      " + ExtMsg + vbCrLf
    If RemH.AnonTo + RemH.AnonPostTo + RemH.RemixTo + RemH.EncryptTo + RemH.RemailTo = "" Then Close n: n = 0: msg = LMsg(72): TMsg = TMsg + "ERROR: Insufficient destination directives" + vbCrLf: GoTo Failure
    
    '\\\\\\\GOOD
    'Process Message
    a = FirstLine
    If a = "." Then a = " "
    TMsg = TMsg + vbCrLf + "BEGIN: Processing" + vbCrLf
    Seg1 = GetWork
    s = FreeFile
    Open Seg1 For Output As s
    Do
        If RemH.Cutmarks <> "" Then If a = RemH.Cutmarks Then Exit Do
        Print #s, a
        If RemH.EncryptKey + RemH.Encrypt3DES + RemH.EncryptCAST <> "" And Seg2 = "" Then
            If a <> "" Then
                If Trim(a) = "**" Then
                    'Start Segment 2
                    Close s: s = 0
                    Seg2 = GetWork
                    s = FreeFile
                    Open Seg2 For Output As s
                End If
            End If
        End If
        If Not EOF(n) Then
            Line Input #n, a
            If a = "." Then a = " "
        Else
            Exit Do
        End If
    Loop Until True = False
    Close n: n = 0
    Close s: s = 0
    'Forgot **?
    If RemH.EncryptKey + RemH.Encrypt3DES + RemH.EncryptCAST <> "" And Seg2 = "" Then
        TMsg = TMsg + "     WARNING: Adding missing ** line" + vbCrLf
        Seg2 = GetWork
        s1 = FreeFile
        Open Seg1 For Input As s1
        s2 = FreeFile
        Open Seg2 For Output As s2
        While Not EOF(s1)
            Line Input #s1, a
            If a = "." Then a = " "
            Print #s2, a
        Wend
        Close s2: s2 = 0
        Close s1: s1 = 0
        s1 = FreeFile
        Open Seg1 For Output As s1
        Print #s1, "**"; vbCrLf
        Close s1: s1 = 0
    End If
                        
    'Inflate
    If RemH.Inflate <> "" Then
        inf = SVal(RemH.Inflate) * 16
        If inf > SVal(Cnf(2, 4)) * 16 Then inf = SVal(Cnf(2, 4)) * 16
        If LCase(Right(RemH.Inflate, 1)) = "r" Then inf = Int(Rnd(1) * (inf - 16)) + 16
        TMsg = TMsg + "Inflation: Adding garbage (" + Left(Trim(Str(inf / 16)), 4) + "k)" + vbCrLf
        If Dir(ProgDir + "\Garbage.dat") = "" Then MakeGarbage
        If Dir(ProgDir + "\Garbage.dat") = "" Then
            Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(78) + vbCrLf
            Mgr(0).Errors = Mgr(0).Errors + 1
            SessUp (0)
            Sess(2, 1) = Sess(2, 1) + PreMsg + "      " + LMsg(78) + vbCrLf
            Mgr(2).Errors = Mgr(2).Errors + 1
            SessUp (2)
            PreMsg = ""
        Else
            g = FreeFile
            Open ProgDir + "\Garbage.dat" For Input As g
            If LOF(g) < inf * 64 Then
                Close g: g = 0
                DelFile ProgDir + "\Garbage.dat"
                MakeGarbage
                g = FreeFile
                Open ProgDir + "\Garbage.dat" For Input As g
            End If
            n = FreeFile
            If RemH.EncryptKey + RemH.Encrypt3DES + RemH.EncryptCAST = "" Then Dst = Seg1 Else Dst = Seg2
            Open Dst For Append As n
            Print #n, "-----BEGIN GARBAGE-----"
            For i = 1 To inf
                If Not EOF(g) Then Line Input #g, a: Print #n, a
            Next i
            Print #n, "-----END GARBAGE-----"
            Close g: g = 0
            RemH.Size = LOF(n)
            Close n: n = 0
        End If
    End If
    
    'Encrypt-Key/3DES/CAST Seg2
    ConvPerformed = False
    For ConvAlg = 3 To 1 Step -1
        Select Case ConvAlg
        Case 1: cekey = RemH.EncryptKey: cedisp = "Encrypt-IDEA"
        Case 2: cekey = RemH.Encrypt3DES: cedisp = "Encrypt-3DES"
        Case 3: cekey = RemH.EncryptCAST: cedisp = "Encrypt-CAST5"
        End Select
        If cekey <> "" Then
            TMsg = TMsg + "Encryption: " + cedisp + " Conventional" + vbCrLf
            EncDst = Encrypt(Seg2, cekey, 0, ErrMsg, ConvAlg)
            DelFile Seg2
            If EncDst = "" Then
                EncGood = False
            Else
                Seg2 = GetWork
                s1 = FreeFile
                Open Seg2 For Output As s1
                s2 = FreeFile
                Open EncDst For Input As s2
                EncGood = PGPOK(s1, s2, True)
                Close s2: s2 = 0
                RemH.Size = LOF(s1)
                Close s1: s1 = 0
                DelFile EncDst
            End If
            If Not EncGood Then
                'Conv Encrypt Failure!
                DelFile Seg2
                DelFile Seg1
                msg = LMsg(77) + vbCrLf: Job = "Prob": TMsg = TMsg + "ERROR: Conventional encryption failure" + vbCrLf
                GoTo Failure
            End If
            ConvPerformed = True
        End If
    Next ConvAlg
    If ConvPerformed Then
        'Add conv-encrypted segment to seg1
        If Seg1 = "" Then
            Seg1 = Seg2
            Seg2 = ""
        Else
            s1 = FreeFile
            Open Seg1 For Append As s1
            s2 = FreeFile
            Open Seg2 For Input As s2
            PGPOK s1, s2, True
            Close s2: s2 = 0
            RemH.Size = LOF(s1)
            Close s1: s1 = 0
            DelFile Seg2
        End If
    End If
                        
    'Encrypt Subject
    If RemH.EncryptSubject <> "" Then
        PlainSubject = Left(RemH.Subject, 255) + Chr(0)
        EncSubject = Chr(0)
        SubjectKey = Left(RemH.EncryptSubject, 255) + Chr(0)
        If psEncryptSubject(PlainSubject, SubjectKey, EncSubject) = 0 Then
            RemH.Subject = Extract(EncSubject, Chr(0))
        Else
            RemH.Subject = ""
            TMsg = TMsg + "     WARNING: Encrypt-Subject failure" + vbCrLf
        End If
        RemH.EncryptSubject = String(Len(RemH.EncryptSubject), "@")
    End If
    
    'News Sig
    If RemH.AnonPostTo <> "" Or RemH.Newsgroups <> "" Then
        If (Val(Cnf(1, 23)) = 3) Or ((Val(Cnf(1, 23)) = 2) And RemH.AnonPostTo <> "") Or ((Val(Cnf(1, 23)) = 1) And RemH.From <> "") Or ((Val(Cnf(1, 23)) = 0) And RemH.From <> "" And RemH.AnonPostTo <> "") Then
            TMsg = TMsg + "News Signature: Adding" + vbCrLf
            If RemH.MIMEVersion = "" Or InStr(1, RemH.MIMEContent, "content-type:", vbTextCompare) = 0 Then
                Dst = GetWork
                n = FreeFile
                Open Seg1 For Input As n
                p = FreeFile
                Open Dst For Output As p
                blankcount = 0
                Do While Not EOF(n)
                    Line Input #n, a
                    If RTrim(a) = "" Then
                        blankcount = blankcount + 1
                        If blankcount < 4 Then Print #p, a
                    Else
                        Print #p, a
                        blankcount = 0
                    End If
                Loop
                Print #p, CnfFiles(11)
                Close p: p = 0
                Close n: n = 0
                DelFile Seg1
                Seg1 = Dst
            Else
                x = InStr(1, RemH.MIMEContent, "content-type", vbTextCompare)
                c = Extract(Mid(RemH.MIMEContent, x), vbCrLf)
                Dst = GetWork
                n = FreeFile
                Open Seg1 For Input As n
                p = FreeFile
                Open Dst For Output As p
                Y = InStr(1, c, "boundary", vbTextCompare)
                If Y <> 0 Then  'or instr (1,c,"alternative",vbTextCompare) <>0
                    b = Extract(Extract(LTrim(Mid(c, Y + 8)), " "), ";")
                    b = Replace(Mid(b, 2), Chr(34), "")
                Else
                    b = "===Next_Part===" + MakeTag
                    Print #p, "--"; b
                    Print #p, RemH.MIMEContent
                    RemH.MIMEContent = "Content-Type: multipart/mixed; boundary=" + Chr(34) + b + Chr(34) + vbCrLf
                End If
                blankcount = 0
                Do While Not EOF(n)
                    Line Input #n, a
                    If a = "--" + b + "--" Then Exit Do
                    If RTrim(a) = "" Then
                        blankcount = blankcount + 1
                        If blankcount < 4 Then Print #p, a
                    Else
                        Print #p, a
                        blankcount = 0
                    End If
                Loop
                Print #p,
                Print #p, "--"; b
                Print #p, "Content-Type: text/plain; charset=us-ascii"
                Print #p, "Content-Transfer-Encoding: 7bit"
                Print #p,
                Print #p, CnfFiles(11)
                Print #p, "--"; b; "--"
                Close p: p = 0
                Close n: n = 0
                DelFile Seg1
                Seg1 = Dst
            End If
        End If
    End If
        
    'Get ReList
    If RemH.TransRePGP Or (RemH.EncryptTo <> "") Then
        TMsg = TMsg + "RePGP: Compiling list" + vbCrLf
        If RemH.TransRePGP Then RemH.ReList = RemH.AnonTo Else RemH.ReList = RemH.EncryptTo
        RemH.RePGP = True
    End If
    
    'Get Remix List
    If RemH.TransRemix Or (RemH.RemixTo <> "") Then
        If RemH.TransRemix Then rt = RemH.AnonTo + "," Else rt = RemH.RemixTo + ","
        TMsg = TMsg + "RemixList: " + Left(rt, Len(rt) - 1) + " (compiling)" + vbCrLf
        x = InStr(rt, ","): Y = 1
        While x <> 0
            a = Mid(rt, Y, x - Y)
            If a <> "" Then
                If LCase(a) = "random" Then
                    RemH.RemixList = RemH.RemixList + "0" + vbCrLf
                Else
                    t = Type2(a)
                    If t > 0 Then
                        RemH.RemixList = RemH.RemixList + Trim(Str(t)) + vbCrLf
                    Else
                        'error reading type2
                        DelFile Seg1
                        Job = "Prob": msg = LMsg(80): TMsg = TMsg + "ERROR: Unable to read type2.lis" + vbCrLf: GoTo Failure
                    End If
                End If
            End If
            Y = x + 1
            x = InStr(x + 1, rt, ",")
        Wend
    End If
    
    'Randhop
    If RemH.RandHop <> "" Then
        rh = SVal(RemH.RandHop)
        If rh > SVal(Cnf(2, 10)) Then rh = SVal(Cnf(2, 10))
        If LCase(Right(RemH.RandHop, 1)) = "r" Then rh = Int(Rnd(1) * rh) + 1
        TMsg = TMsg + "Rand-Hop: Adding" + Str(rh) + vbCrLf
        If RemH.RemixList <> "" Or (Cnf(2, 8) = "True" And RemH.AnonTo <> "") Then
            'Randhop Mix
            For i = 1 To rh
                remlist = remlist + "0" + vbCrLf
            Next i
            RemH.RemixList = remlist + RemH.RemixList
        Else
            'Randhop CPunk
            remlist = "RANDOM"
            For i = 2 To rh
                remlist = remlist + ",RANDOM"
            Next i
            If RemH.ReList <> "" Then remlist = remlist + ","
            RemH.ReList = remlist + RemH.ReList
            If Cnf(2, 5) = "True" Then RemH.RePGP = True
        End If
    End If
    
    'Middle
    If RemH.Middle And (RemH.RemixList = "") Then
        If RemH.ReList = "" Then
            If Cnf(2, 8) = "True" And RemH.RemailTo = "" Then
                RemH.RemixList = "0" + vbCrLf
                TMsg = TMsg + "Middleman: Random remix hop selected" + vbCrLf
            Else
                TMsg = TMsg + "Middleman: Random "
                If Cnf(2, 5) = "True" And RemH.RemailTo = "" Then RemH.RePGP = True: TMsg = TMsg + "RePGP " Else TMsg = TMsg + "non-encrypted "
                TMsg = TMsg + "hop" + vbCrLf
                RemH.ReList = "RANDOM"
            End If
        Else
            RemH.ReList = "RANDOM," + RemH.ReList: TMsg = TMsg + "Middleman: Random hop added" + vbCrLf
        End If
    End If

    'Do ReList
    If RemH.ReList <> "" Then
        'Reverse order and resolve random
        t = 0: If (RemH.AnonTo <> "" Or RemH.RemailTo <> "") And Not RemH.TransRePGP Then t = 1: etlast = RemH.AnonTo + RemH.RemailTo
        If Not RemH.RePGP Then TMsg = TMsg + "RemailList: " Else TMsg = TMsg + "RePGPList: "
        TMsg = TMsg + RemH.ReList + vbCrLf
        rp = ResolveRandom(RemH.ReList, RemH.RePGP, RemH.RePGP And (t = 0), RemH.Middle, RemH.Size)
        If rp = "" Then msg = LMsg(82): Job = "Prob": TMsg = TMsg + "ERROR: Insufficient random remailers" + vbCrLf: GoTo Failure
        
        'Create
        x = InStr(rp, ","): Y = 1
        While x <> 0
            et = Mid(rp, Y, x - Y)
            If et <> "" Then
                'Build
                If LCase(et) = "random" Then
                    et = Extract(Mid(randlist, randlistX), ",")
                    randlistX = InStr(randlistX, randlist, ",") + 1
                End If
                Select Case t
                Case 0
                    'Simple RePGP
                    TMsg = TMsg + "     Encrypt To: " + et + vbCrLf
                    PGPDst = RePGP(Seg1, et)
                Case 1
                    'Full, Add Hash
                    TMsg = TMsg + "     Build To: " + et + " (hash)"
                    If RemH.RePGP Then TMsg = TMsg + " (encrypted)"
                    TMsg = TMsg + vbCrLf
                    PGPDst = CPunkMessage(Seg1, et, "Anon-To: " + etlast + vbCrLf, BuildHash(RemH), RemH.RePGP, ErrMsg)
                Case Else
                    'Full, No Hash
                    TMsg = TMsg + "     Build To: " + et + " (no hash)"
                    If RemH.RePGP Then TMsg = TMsg + " (encrypted)"
                    TMsg = TMsg + vbCrLf
                    PGPDst = CPunkMessage(Seg1, et, "Anon-To: " + etlast + vbCrLf, "", RemH.RePGP, ErrMsg)
                End Select
                If PGPDst = "" Then
                    'Houston, we have a problem
                    DelFile Seg1
                    Job = "Prob": msg = LMsg(79) + ": " + et: TMsg = TMsg + "ERROR: RePGP Failure" + vbCrLf: GoTo Failure
                Else
                    DelFile Seg1
                    Seg1 = PGPDst
                End If
                etlast = et
                If t > 0 Then RemH.NewTo = et
                t = t + 1
            End If
            Y = x + 1
            x = InStr(x + 1, rp, ",")
        Wend
    End If

    ErrMsg = ""
    'Remix
    If RemH.RemixList <> "" Then
        TMsg = TMsg + "RemixList: " + Replace(RemH.RemixList, vbCrLf, " ") + vbCrLf
        If RemH.AnonTo <> "" Or RemH.TransRemix Then
            Toh = RemH.AnonTo
        Else
            Y = 1
            Do
                x = InStr(Y, RemH.RemixTo, ",")
                If x <> 0 Then Y = x + 1
            Loop Until x = 0
            Toh = Mid(RemH.RemixTo, Y)
        End If
        MixDst = MixMessage(Seg1, Toh, BuildHash(RemH), RemH.RemixList, ErrMsg)
        TTo = Toh
        If MixDst = "" Then TMsg = TMsg + "ERROR: Mixmaster failure (possible insufficient random remailers)" + vbCrLf
        If MixDst <> "" Then ErrMsg = QueueMail(MixDst, "", "From: " + Cnf(1, 19) + vbCrLf, RemH.LatentTime, RemH.TestTo, 1)
    Else
        'Post
        If RemH.AnonPostTo <> "" Then
            THash = BuildHash(RemH)
            ErrMsg = QueueMail(Seg1, RemH.AnonPostTo, THash, RemH.LatentTime, RemH.TestTo, 2)
            TTo = "Newsgroups: " + RemH.AnonPostTo
        Else
            'CPunk
            If RemH.NewTo <> "" Then
                ErrMsg = QueueMail(Seg1, RemH.NewTo, "", RemH.LatentTime, RemH.TestTo, 0)
                TTo = "To: " + RemH.NewTo
            Else
                Toh = RemH.AnonTo
                If Toh = "" Then Toh = RemH.EncryptTo
                If Toh = "" Then Toh = RemH.RemailTo
                THash = BuildHash(RemH)
                ErrMsg = QueueMail(Seg1, Toh, THash, RemH.LatentTime, RemH.TestTo, 0)
                TTo = "To: " + Toh
            End If
        End If
    End If
        
    DelFile Seg1
    If ErrMsg <> "" Then
        Job = "Prob": msg = ErrMsg: TMsg = TMsg + ErrMsg + vbCrLf: GoTo Failure
    End If
    If RemH.TestTo <> "" Then QueueTest Src, TTo + vbCrLf + THash, RemH.TestTo, RemH.EncryptTest
    
    DelFile Src
Exit Sub
Failure:
    Headers = "": OrigFrom = "": OrigTestFrom = ""
    TMsg = TMsg + vbCrLf + "Message processing terminated."
    TMsg = TMsg + vbCrLf + "Disposal: "
    If Job = "Prob" Then
        TMsg = TMsg + "Requeue (Your message would have been moved to the Problems folder and" + _
         vbCrLf + "requeued when the internal configuration problem was corrected.)" + vbCrLf
    Else
        TMsg = TMsg + "Deleted" + vbCrLf
    End If
    Close
    If RemH.TestTo <> "" Then
        TSrc = "": QueueTest Src, "", RemH.TestTo, RemH.EncryptTest
        DelFile Src
    Else
        Disposal Src, Job, msg
    End If
Exit Sub
ProcessError:
    msg = LMsg(84) + vbCrLf + "      " + Error
    CloseFile n
    CloseFile p
    CloseFile g
    CloseFile s1
    CloseFile s2
    Job = "Prob"
    TMsg = TMsg + "ERROR: A critical internal error has occured." + vbCrLf + "     " + Error + vbCrLf
    GoTo Failure
End Sub

Private Function BuildHash(RemH As RemHType) As String
    If RemH.From <> "" Then BuildHash = BuildHash + "From: " + RemH.From + vbCrLf
    If RemH.Subject <> "" Then BuildHash = BuildHash + "Subject: " + RemH.Subject + vbCrLf
    If RemH.Bcc <> "" Then BuildHash = BuildHash + "Bcc: " + RemH.Bcc + vbCrLf
    If RemH.CC <> "" Then BuildHash = BuildHash + "CC: " + RemH.CC + vbCrLf
    If RemH.Newsgroups <> "" Then BuildHash = BuildHash + "Newsgroups: " + RemH.Newsgroups + vbCrLf
    If RemH.Hash <> "" Then BuildHash = BuildHash + RemH.Hash
    If RemH.MIMEVersion <> "" Then BuildHash = BuildHash + "MIME-Version: " + RemH.MIMEVersion + vbCrLf
    If RemH.MIMEContent <> "" Then BuildHash = BuildHash + RemH.MIMEContent
End Function

Private Function CleanHeaders(RemH As RemHType) As String
    If RemH.TestTo <> "" Then
        RemH.TestTo = Trim(Extract(RemH.TestTo, ","))
        ta = SubSearch("To: " + RemH.TestTo, CnfFiles(8), 1)
        If ta <> "" Or CleanAddress(RemH.TestTo) = "" Then RemH.TestTo = ""
        If RemH.TestTo = "" Then
            RemH = BlankRemH
            CleanHeaders = ""
            Exit Function
        End If
    End If
        
    msg = msg + CleanTo(RemH.AnonPostTo, "Newsgroups", 3)
    If RemH.AnonPostTo <> "" Then
        RemH.RemixTo = ""
        RemH.EncryptTo = ""
        RemH.RemailTo = ""
        RemH.AnonTo = ""
        If RemH.RandHop <> "" Then RemH.RandHop = "": TMsg = TMsg + "     WARNING: Rand-hop disabled with Anon-Post-To" + vbCrLf
        
        If RemH.Subject = "" Then RemH.Subject = "(No Subject)": TMsg = TMsg + "     WARNING: Subject required with Anon-Post-To (added)" + vbCrLf
        If RemH.Newsgroups <> "" Then TMsg = TMsg + "     WARNING: Extra Newsgroups header removed from Anon-Post-To message" + vbCrLf
        RemH.Newsgroups = ""
        If InStr(Cnf(6, 2), "@") <> 0 Then
            RemH.Newsgroups = RemH.AnonPostTo
            RemH.AnonTo = Cnf(6, 2)
        End If
    End If
    
    msg = msg + CleanTo(RemH.RemixTo, "Remix-To", 1)
    msg = msg + CleanTo(RemH.EncryptTo, "Encrypt-To", 2, RemH.Middle)
    
    'Nix Subject if esub not supported
    If RemH.EncryptSubject <> "" And Not ESUBSupport Then
        RemH.Subject = "(No Subject)"
        RemH.EncryptSubject = ""
        TMsg = TMsg + "     WARNING: Encrypt-Subject not supported - Subject removed" + vbCrLf
    End If
        
    If RemH.RemixTo <> "" Then
        RemH.AnonTo = ""
        RemH.RemailTo = ""
        RemH.EncryptTo = ""
    End If
    If RemH.EncryptTo <> "" Then
        RemH.AnonTo = ""
        RemH.RemailTo = ""
    End If
        
    If RemH.RandHop = "" And RemH.RemixTo = "" And RemH.EncryptTo = "" Then
        msg = msg + CleanTo(RemH.AnonTo, "To", 0, RemH.Middle)
        msg = msg + CleanTo(RemH.CC, "To", 0, RemH.Middle)
        msg = msg + CleanTo(RemH.Bcc, "To", 0, RemH.Middle)
        msg = msg + CleanTo(RemH.RemailTo, "To", 0, RemH.Middle)
        msg = msg + CleanTo(RemH.Newsgroups, "Newsgroups", 4)
        
        If RemH.RemailTo <> "" Then RemH.AnonTo = ""
        If RemH.AnonTo + RemH.AnonPostTo + RemH.RemixTo + RemH.EncryptTo + RemH.RemailTo = "" Then Exit Function
        
        'Parse From Header
        If RemH.From <> "" Then
            If Val(Cnf(1, 24)) = 4 Then
                RemH.From = ""
            Else
                If Cnf(1, 21) = "True" And RemH.AnonPostTo <> "" Then
                    'News post
                    If Val(Cnf(1, 24)) = 1 Or Val(Cnf(1, 24)) = 3 Then StripAddr = True
                Else
                    If Val(Cnf(1, 24)) = 2 Or Val(Cnf(1, 24)) = 3 Then RemH.From = ""
                    If Val(Cnf(1, 24)) = 1 Then StripAddr = True
                End If
                If InStr(RemH.From, "@") = 0 Then StripAddr = True
            End If
            If RemH.From = "" Then
                TMsg = TMsg + "     WARNING: From header stripped" + vbCrLf
            Else
                If StripAddr Then
                    x = InStr(RemH.From, "(")
                    If x <> 0 Then
                        FName = Extract(Mid(RemH.From, x + 1), ")")
                    Else
                        x = InStr(RemH.From, Chr(34))
                        If x <> 0 Then
                            FName = Extract(Mid(RemH.From, x + 1), Chr(34))
                        Else
                            FName = Extract(RemH.From, "<")
                        End If
                    End If
                    FName = Trim(FName)
                    If FName = "" Or InStr(FName, "@") <> 0 Or InStr(FName, ".") <> 0 Then
                        RemH.From = ""
                    Else
                        RemH.From = "Anonymous-Remailer@See.Comment.Header (" + FName + ")"
                    End If
                    If RemH.From = "" Then
                        TMsg = TMsg = "     WARNING: Bad From header (stripped)" + vbCrLf
                    Else
                        TMsg = TMsg + "     WARNING: From header modified" + vbCrLf
                    End If
                End If
            End If
        End If
    End If
    
    If RemH.AnonTo <> "" And RemH.AnonTo <> Cnf(1, 1) Then
        'Determine Transparent
        If InStr(RemH.AnonTo, ",") + InStr(RemH.AnonTo, " ") + InStr(RemH.AnonTo, "(") + InStr(RemH.AnonTo, "<") + InStr(RemH.AnonTo, Chr(34)) = 0 Then
            If Cnf(2, 8) = "True" Then
                If Type2(RemH.AnonTo) > 0 Then RemH.TransRemix = True: TMsg = TMsg + "Transparent Remix enabled" + vbCrLf
            Else
                If Cnf(2, 5) = "True" And InStr(1, CnfFiles(4), RemH.AnonTo, vbTextCompare) = 0 Then
                    rname = "": raddress = RemH.AnonTo
                    Remailer rname, raddress, 0, roptions, "", ""
                    If rname <> "" And InStr(roptions, " cpunk ") <> 0 Then
                        RemH.TransRePGP = True
                        TMsg = TMsg + "Transparent RePGP enabled" + vbCrLf
                    End If
                End If
            End If
        End If
    End If
    
    If InStr(Cnf(6, 2), "@") <> 0 Then RemH.AnonPostTo = ""
    CleanHeaders = msg
End Function

Private Function CleanTo(hdr As String, hdrname As String, Job As Byte, Optional Middle As Boolean) As String
    'Removes illegal destinations and sets Middle
    'Job 0  To, CC, Bcc, RemailTo
    'Job 1  Remix-To
    'Job 2  Encrypt-To
    'Job 3  Anon-Post-To
    'Job 4  Newsgroups
    Dim h As String, x As Integer, Y As Integer
    
    If hdr = "" Then Exit Function
    'Maximum addresses in header
    Select Case Job
    Case 1, 2: ToMax = Int(SVal(Cnf(2, 14)))
    Case 3, 4: ToMax = Int(SVal(Cnf(1, 25)))
    Case Else: ToMax = Int(SVal(Cnf(1, 16)))
    End Select
    If ToMax <= 0 Then ToMax = 1
    
    h = hdr + ","
    x = InStr(h, ","): Y = 1: t = 0
    Do While x <> 0
        a = Trim(Mid(h, Y, x - Y))
        If a <> "" Then
            'Maximum addresses in header
            If t = ToMax Then
                TMsg = TMsg + hdrname + ": " + a + ": Maximum addresses (" + Trim(Str(ToMax)) + ") exceeded - truncated" + vbCrLf
                Exit Do
            End If
            'Convert Short Name
            If Job <> 3 And Job <> 4 And InStr(a, "@") = 0 Then
                If LCase(a) <> "random" Or Job = 0 Then
                    b = a
                    Remailer b, raddress, 0, "", "", ""
                    If raddress = "" Then Remailer b, raddress, 1, "", "", ""
                    If raddress <> "" Then
                        TMsg = TMsg + hdrname + ": " + a + ": Expanded to " + raddress + vbCrLf
                        a = raddress
                    Else
                        b = a
                        t = Type2(b)
                        If t > 0 Then
                            TMsg = TMsg + hdrname + ": " + a + ": Expanded to " + b + vbCrLf
                            a = b
                        Else
                            If Job = 1 Or Job = 2 Then
                                TMsg = TMsg + hdrname + ": " + a + ": Invalid address - directive removed" + vbCrLf
                                hdr = ""
                                Exit Function
                            Else
                                TMsg = TMsg + hdrname + ": " + a + ": Invalid address removed" + vbCrLf
                                a = ""
                            End If
                        End If
                    End If
                End If
            End If
            'Valid Recipient?
            If Job < 3 And a <> "" And Not (Job > 0 And LCase(a) = "random") Then
                If CleanAddress(a) = "" Then
                    If Job = 1 Or Job = 2 Then
                        TMsg = TMsg + hdrname + ": " + a + ": Invalid address - directive removed" + vbCrLf
                        hdr = ""
                        Exit Function
                    Else
                        TMsg = TMsg + hdrname + ": " + a + ": Invalid address removed" + vbCrLf
                        a = ""
                    End If
                End If
            End If
            If a <> "" Then
                'Test Header
                ta = SubSearch(hdrname + ": " + a, CnfFiles(8), 1)
                If ta <> "" Then
                    'Dest Blocked
                    CleanTo = CleanTo + hdrname + ": " + a + ": " + LMsg(226) + vbCrLf
                    TMsg = TMsg + hdrname + ": " + a + ": Destination Blocked" + vbCrLf
                    a = ""
                Else
                    'Middle?
                    If (Job = 0 Or Job = 2) And Cnf(1, 4) = "True" Then
                        If (Job = 0 Or (Y = 1 And LCase(a) <> "random")) And LCase(a) <> LCase(Cnf(1, 1)) Then
                            ta = SubSearch(a, CnfFiles(7), 1)
                            If ta = "" Then
                                Middle = True
                                TMsg = TMsg + hdrname + ": " + a + ": Direct Destination Not Allowed - Middleman Enabled" + vbCrLf
                            End If
                        End If
                    End If
                    Select Case Job
                    Case 1
                        ' RemixTo
                        t = Type2(a)
                        If t < 1 And LCase(a) <> "random" Then
                            CleanTo = CleanTo + hdrname + ": " + a + ": " + LMsg(234) + vbCrLf
                            TMsg = TMsg + hdrname + ": " + a + ": Remix Destination Not Allowed - directive removed" + vbCrLf
                            If t = -1 Then CleanTo = CleanTo + "      " + LMsg(235) + vbCrLf: TMsg = TMsg + "      ERROR Unable to read Type2.lis" + vbCrLf
                            h2 = ""
                            Exit Do
                        End If
                    Case 2
                        ' EncryptTo
                        If LCase(a) <> "random" Then
                            'Recursive RePGP?
                            If Trim(Mid(h, x)) = "," Then
                                If InStr(1, CnfFiles(4), a, vbTextCompare) <> 0 Then
                                    CleanTo = CleanTo + hdrname + ": " + a + ": " + LMsg(236) + vbCrLf
                                    TMsg = TMsg + hdrname + ": " + a + ": RePGP Destination Not Allowed - directive removed" + vbCrLf
                                    h2 = ""
                                    Exit Do
                                End If
                            End If
                            'PGP remailer?
                            rname = "": raddress = a
                            Remailer rname, raddress, 0, roptions, rlatent, rup
                            If rname = "" Or InStr(roptions, " cpunk ") = 0 Or InStr(roptions, " pgp ") = 0 Then
                                CleanTo = CleanTo + hdrname + ": " + a + ": " + LMsg(236) + vbCrLf
                                TMsg = TMsg + hdrname + ": " + a + ": PGP Remailer Not Supported - directive removed" + vbCrLf
                                h2 = ""
                                Exit Do
                            End If
                        End If
                    Case 3
                        ' AnonPostTo
                        Select Case Val(Cnf(1, 22))
                        Case 0
                            'Block List
                            ta = SubSearch(a, CnfFiles(10), 1)
                            If ta <> "" Then
                                CleanTo = CleanTo + hdrname + ": " + a + ": " + LMsg(237) + vbCrLf
                                TMsg = TMsg + hdrname + ": " + a + ": Newsgroup Blocked" + vbCrLf
                                a = ""
                            End If
                        Case 1
                            'Allow List
                            ta = SubSearch(a, CnfFiles(10), 1)
                            If ta = "" Then
                                CleanTo = CleanTo + hdrname + ": " + a + ": " + LMsg(238) + vbCrLf
                                TMsg = TMsg + hdrname + ": " + a + ": Newsgroup Disallowed" + vbCrLf
                                a = ""
                            End If
                        End Select
                    End Select
                    If a <> "" Then
                        If h2 = "" Then h2 = a Else h2 = h2 + "," + a
                    End If
                    t = t + 1
                End If
            End If
        End If
        Y = x + 1
        x = InStr(x + 1, h, ",")
    Loop
    hdr = h2
End Function

Private Function ProcessPing(n, Src, Headers As String, Job) As String
    Dim PingDate As Date, rtype As Integer, rname As String, raddress As String
    Dim PingType As String, rname2 As String, raddress2 As String
    Dim RecvDate As Date, rtag As String, DateDiff As Double
    Dim tempdate As Date, h As Double, m As Double
    
    On Error GoTo PingError
    PingProcessed = True
    Line Input #n, a
    Line Input #n, PingType
    Input #n, rtype
    Input #n, PingDate
    Line Input #n, rname
    If Trim(rname) = "" Then GoTo PingError
    If PingType <> "Single" And PingType <> "Chain" Then GoTo PingError
    'Open Data file
    s = FreeFile
    fn = Cnf(1, 5) + "\Stats\MKSRecv.dat"
    If Dir(fn) = "" Then
        Open fn For Output As s
        Print #s, "RELIABLE_STAT_RECV"
        Print #s,
        Print #s, "Reliable MakeStats File"
        Print #s, "DO NOT EDIT"
        Print #s, "Doing so may cause serious problems."
        Print #s,
        Print #s,
        Print #s, "---Version"
        Print #s, Version
        Print #s, "---Recv"
    Else
        Open fn For Append As s
    End If
    'Resolve Date
    RecvDate = FileDateTime(Src)
    If Val(Cnf(8, 0)) = 0 Then
        x = InStr(Headers, vbCrLf + "Date: ")
        If x <> 0 Then
            d = Extract(Mid(Headers, x + 8), vbCrLf)
            tempdate = ResolveDate(d)
            If tempdate <> 0 Then RecvDate = tempdate
        End If
    End If
    DateDiff = RecvDate - PingDate
    Select Case PingType
    Case "Single"
        If rtype < 0 Or rtype > 1 Then GoTo PingError
        'Line Input #n, rtag
        Print #s, 0
        Write #s, PingDate
        Write #s, DateDiff
        Print #s, rtype
        Print #s, rname
        'Print #s, rtag
    Case "Chain"
        If rtype < 1 Or rtype > 4 Then GoTo PingError
        Line Input #n, rname2
        Print #s, rtype
        Write #s, PingDate
        Write #s, DateDiff
        Print #s, rname
        Print #s, rname2
    End Select
    Print #s,
    Close s: s = 0
    Close n: n = 0
    Job = ""
    ProcessPing = ""
Exit Function
PingError:
    ProcessPing = LMsg(336) + vbCrLf + "      " + Error
    Job = "Prob"
    CloseFile n
    CloseFile s
End Function

Private Sub Disposal(Src As String, Job, msg)
    On Error GoTo DisposalError
    src2 = PlainName(Src, 1)
    
    Select Case Job
    Case "Prob"
        Dst = Cnf(1, 5) + "\MAILPROB\" + src2
        Sess(2, 1) = Sess(2, 1) + PreMsg + "      " + LMsg(83) + vbCrLf + "      " + msg + " (" + Dst + ")" + vbCrLf
        Mgr(2).Errors = Mgr(2).Errors + 1
        SessUp (2)
        Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(83) + vbCrLf + "      " + msg + " (" + Dst + ")" + vbCrLf
        Mgr(0).Errors = Mgr(0).Errors + 1
        SessUp (0)
    Case "Defer"
        Dst = Cnf(1, 5) + "\MAILDFR\" + src2
        If frmMain!mnuVerbose.Checked Then
            Sess(2, 1) = Sess(2, 1) + PreMsg + "      " + msg + " (" + Dst + ")" + vbCrLf
            SessUp (2)
        End If
    Case "Plain"
        If Cnf(5, 0) = "True" Then
            If LCase(Right(src2, 4)) = ".rel" Then src2 = PlainName(src2, 2) + ".ML0"
            Dst = Cnf(1, 6) + "\" + src2
        End If
        If frmMain!mnuVerbose.Checked Then
            Sess(2, 1) = Sess(2, 1) + PreMsg + "      " + msg + " (" + Dst + ")" + vbCrLf
            SessUp (2)
        End If
    Case "Trash"
        Dst = Cnf(1, 5) + "\Trash\" + src2
        If msg <> "" Then
            Sess(2, 1) = Sess(2, 1) + PreMsg + "      " + LMsg(188) + vbCrLf + "      " + msg + " (" + Dst + ")" + vbCrLf
            Mgr(2).Warnings = Mgr(2).Warnings + 1
            SessUp (2)
            Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(188) + vbCrLf + "      " + msg + " (" + Dst + ")" + vbCrLf
            Mgr(0).Warnings = Mgr(0).Warnings + 1
            SessUp (0)
        End If
    Case Else
        'Delete
        If msg <> "" And frmMain!mnuVerbose.Checked Then
            Sess(2, 1) = Sess(2, 1) + PreMsg + "      " + msg + " (" + LMsg(38) + ")" + vbCrLf
            SessUp (2)
        End If
    End Select
    If Dst <> "" Then
        If Dir(Dst) <> "" Or LCase(Left(Src, 2)) <> LCase(Left(Dst, 2)) Then
            FileCopy Src, Dst
        Else
            Name Src As Dst
        End If
    End If
    If Job = "Prob" Or Job = "Trash" Then QueueProb
    DelFile Src
Exit Sub
DisposalError:
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(81) + vbCrLf + "      " + Error + vbCrLf
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    Sess(2, 1) = Sess(2, 1) + PreMsg + Format(Time, "short time") + " " + LMsg(81) + vbCrLf + "      " + Error + vbCrLf
    Mgr(2).Errors = Mgr(2).Errors + 1
    SessUp (2)
    QueueProb
End Sub

Public Function QueueMail(Src, Toh, Hash, Latent, TestTo As String, Job As Byte) As String
    Dim a As String
    
    On Error GoTo QueueError
    TMsg = TMsg + vbCrLf + "Your test message was processed successfully." + vbCrLf
    TMsg = TMsg + "Queue: "
    Select Case Job
    Case 0
        'CPunk
        If Toh = Cnf(1, 1) Then
            'Local mail
            Do
                MDst = Cnf(1, 5) + "\MAILIN\" + MakeTag + ".ML0"
            Loop Until Dir(MDst) = ""
            n = FreeFile
            Open MDst For Output As n
            Print #n, "From local@Reliable " + DateLine(1)
            Print #n, "To: "; Toh
            If Hash = "" Then Print #n, Else Print #n, Hash
            s = FreeFile
            Open Src For Input As s
            While Not EOF(s)
                Line Input #s, a
                Print #n, a
            Wend
            Close s: s = 0
            Close n: n = 0
            DelFile Src
            If TestTo <> "" Then
                TSrc = MDst
                TMsg = TMsg + "Message successfully queued for immediate internal mail transfer." + vbCrLf + "  (Your test message will not actually be sent.)" + vbCrLf
            End If
        Else
            Do
                MDst = Cnf(1, 5) + "\MAILOUT\" + MakeTag
            Loop Until Dir(MDst + ".*") = ""
            n = FreeFile
            Open MDst + ".Q0" For Output As n
            Print #n, "RELI_MAILOUT"
            sendtime = GetLatent(Latent)
            Print #n, sendtime
            Print #n,
            Print #n, "To: "; Toh
            Print #n, Hash
            Close n: n = 0
            If LCase(Left(Src, 2)) = LCase(Left(MDst, 2)) Then
                Name Src As MDst + ".Q1"
            Else
                FileCopy Src, MDst + ".Q1"
                DelFile Src
            End If
            If TestTo <> "" Then
                DelFile MDst + ".Q0"
                TSrc = MDst + ".Q1"
                TMsg = TMsg + "Message successfully queued for SMTP." + vbCrLf + "  (Your test message will not actually be sent.)" + vbCrLf + _
                 "Scheduled for sending at: " + Format(sendtime - gmtoffset, "dd-mmm-yy") + " " + Format(sendtime - gmtoffset, "short time") + " GMT" + vbCrLf
            Else
                'Update Index
                If Dir(Cnf(1, 5) + "\MAILOUT\Reliable.IDX") <> "" Then
                    n = FreeFile
                    Open Cnf(1, 5) + "\MAILOUT\Reliable.IDX" For Append As n
                    Print #n, PlainName(MDst, 2)
                    Print #n, sendtime
                    Close n: n = 0
                End If
            End If
        End If
    Case 1
        'Mix
        If Dir(Src) <> "" Then i = 0 Else i = 1
        Do
            If i = 0 Then fn = Src Else fn = Src + "." + Trim(Str(i))
            a = SDir(fn)
            If a <> "" Then
                Do
                    MDst = Cnf(1, 5) + "\MAILOUT\" + MakeTag
                Loop Until Dir(MDst + ".*") = ""
                s = FreeFile
                Open fn For Input As s
                If Not EOF(s) Then Line Input #s, Toh
                While Not EOF(s) And b <> "::"
                    Line Input #s, b
                Wend
                If Toh <> "To: " + Cnf(1, 1) Then
                    n = FreeFile
                    Open MDst + ".Q0" For Output As n
                    Print #n, "RELI_MAILOUT"
                    sendtime = GetLatent(Latent)
                    Print #n, sendtime
                    Print #n,
                    Print #n, Toh
                    Print #n, Hash
                    Close n: n = 0
                    n = FreeFile
                    Open MDst + ".Q1" For Output As n
                    Print #n, "::"
                    While Not EOF(s)
                        Line Input #s, b
                        Print #n, b
                    Wend
                    Close n: n = 0
                    If TestTo <> "" Then
                        DelFile MDst + ".Q0": DelFile MDst + ".Q1"
                        TMsg = TMsg + "Mixmaster part" + Str(i) + " successfully queued for SMTP at: " + Format(sendtime - gmtoffset, "dd-mmm-yy") + " " + Format(sendtime - gmtoffset, "short time") + " GMT" + vbCrLf + "  (Your test message will not actually be sent.)" + vbCrLf + Toh + vbCrLf
                    Else
                        'Update Index
                        If Dir(Cnf(1, 5) + "\MAILOUT\Reliable.IDX") <> "" Then
                            n = FreeFile
                            Open Cnf(1, 5) + "\MAILOUT\Reliable.IDX" For Append As n
                            Print #n, PlainName(MDst, 2)
                            Print #n, sendtime
                            Close n: n = 0
                        End If
                    End If
                Else
                    'Local mix
                    Do
                        MDst = Cnf(1, 5) + "\MAILIN\" + MakeTag + ".ML0"
                    Loop Until Dir(MDst) = ""
                    n = FreeFile
                    Open MDst For Output As n
                    Print #n, "From local@Reliable " + DateLine(1)
                    Print #n, Toh
                    If Hash = "" Then Print #n, Else Print #n, Hash
                    Print #n, "::"
                    While Not EOF(s)
                        Line Input #s, b
                        Print #n, b
                    Wend
                    Close n: n = 0
                    If TestTo <> "" Then
                        DelFile MDst
                        TMsg = TMsg + "Mixmaster part" + Str(i) + " successfully queued for immediate internal mail transfer" + vbCrLf + "  (Your test message will not actually be sent.)" + vbCrLf + Toh + vbCrLf
                    End If
                End If
                Close s: s = 0
                DelFile fn
            End If
            i = i + 1
        Loop Until a = "" Or i = 1
    Case 2
        'Post
        Do
            MDst = Cnf(1, 5) + "\NNTP\" + MakeTag
        Loop Until Dir(MDst + ".*") = ""
        n = FreeFile
        Open MDst + ".Q0" For Output As n
        Print #n, "RELI_NNTP"
        sendtime = GetLatent(Latent)
        Print #n, sendtime
        Print #n,
        Print #n, "Newsgroups: "; Toh
        Print #n, Hash
        Close n: n = 0
        If LCase(Left(Src, 2)) = LCase(Left(MDst, 2)) Then
            Name Src As MDst + ".Q1"
        Else
            FileCopy Src, MDst + ".Q1"
            DelFile Src
        End If
        If TestTo <> "" Then
            DelFile MDst + ".Q0"
            TSrc = MDst + ".Q1"
            TMsg = TMsg + "Message successfully queued for NNTP." + vbCrLf + "  (Your test message will not actually be posted.)" + vbCrLf + _
             "Scheduled for posting at: " + Format(sendtime - gmtoffset, "dd-mmm-yy") + " " + Format(sendtime - gmtoffset, "short time") + " GMT" + vbCrLf
        Else
            'Update Index
            If Dir(Cnf(1, 5) + "\NNTP\Reliable.IDX") <> "" Then
                n = FreeFile
                Open Cnf(1, 5) + "\NNTP\Reliable.IDX" For Append As n
                Print #n, PlainName(MDst, 2)
                Print #n, sendtime
                Close n: n = 0
            End If
        End If
    End Select
    QueueMail = ""
Exit Function
QueueError:
    QueueMail = LMsg(85) + vbCrLf + "      " + Error + vbCrLf
    TMsg = TMsg + "ERROR: A critical internal error occured queuing mail." + vbCrLf + Error + vbCrLf
    CloseFile n
    CloseFile s
    If MDst <> "" Then DelFile MDst + ".q*"
End Function

Private Sub QueueTest(Src As String, THash, TestTo As String, Key As String)
    On Error GoTo TestError
    
    If InStr(THash, "From: ") = 0 Then THash = THash + "From: " + Cnf(1, 19) + vbCrLf
    Dst = GetWork
    n = FreeFile
    Open Dst For Output As n
    Print #n, "This is an automated response to the test message you sent to "; Cnf(1, 0); "."
    Print #n, "Your test message results follow:"
    Print #n,
    Print #n, TMsg
    Print #n,
    s = FreeFile
    Open Src For Input As s
    a = "X"
    While Not EOF(s) And a <> ""
        Line Input #s, a
    Wend
    While Not EOF(s) And a = ""
        Line Input #s, a
    Wend
    If Trim(a) = "::" Then
        Print #n, "======================================================================"
        Print #n, "The first 20 lines of your original test message follow:"
        Print #n,
        Print #n, a
        For i = 1 To 20
            If Not EOF(s) Then Line Input #s, a: Print #n, a
        Next i
    End If
    Close s: s = 0
    Print #n,
    If TSrc <> "" Then
        Print #n, "======================================================================"
        Print #n, "The headers and first 15 lines of your final output message follow:"
        Print #n,
        s = FreeFile
        Open TSrc For Input As s
        Print #n, THash
        If Not EOF(s) Then Line Input #s, a
        If Left(a, 5) = "From " Then
            While Not EOF(s) And a <> ""
                Line Input #s, a
            Wend
            If Not EOF(s) Then Line Input #s, a
        End If
        For i = 1 To 15
            Print #n, a
            If Not EOF(s) Then Line Input #s, a Else Exit For
        Next i
        Close s: s = 0
        Print #n,
    End If
    Close n: n = 0
    If Key <> "" Then
        PGPDst = Encrypt(Dst, Key, 0, ErrMsg)
        DelFile Dst
        If PGPDst <> "" Then Dst = PGPDst Else Dst = ""
    End If
    DelFile TSrc
    Hash = "From: " + Cnf(1, 19) + vbCrLf
    If Dst <> "" Then
        If Cnf(1, 4) <> "True" Or Val(Cnf(1, 20)) = 0 Then
            'Send Direct
            ErrMsg = QueueMail(Dst, TestTo, Hash, "+0:00", "", 0)
        Else
            'Send Middle
            ErrMsg = SendMiddle(Dst, TestTo, "")
        End If
    End If
    If ErrMsg <> "" Then
        For i = 0 To 2 Step 2
            Sess(i, 1) = Sess(i, 1) + Format(Time, "short time") + " " + LMsg(86) + vbCrLf + "      " + ErrMsg + vbCrLf
            Mgr(i).Errors = Mgr(i).Errors + 1
        Next i
        SessUp (0)
    End If
    DelFile Dst
Exit Sub
TestError:
    For i = 0 To 2 Step 2
        Sess(i, 1) = Sess(i, 1) + Format(Time, "short time") + " " + LMsg(86) + vbCrLf + "      " + Error + vbCrLf
        Mgr(i).Errors = Mgr(i).Errors + 1
    Next i
    SessUp (0)
    CloseFile n
    CloseFile s
    DelFile Dst
    DelFile PGPDst
    DelFile TSrc
End Sub

Public Function SendMiddle(Src, FinalTo, Subj) As String
    On Error GoTo MiddleError
    Do
        MDst = Cnf(1, 5) + "\MAILIN\" + MakeTag + ".ML0"
    Loop Until Dir(MDst) = ""
    n = FreeFile
    Open MDst For Output As n
    Print #n, "From send.middle@Reliable "; DateLine(1)
    Print #n, "To: "; Cnf(1, 1)
    Print #n,
    Print #n, "::"
    If Val(Cnf(1, 20)) = 1 Then
        Print #n, "Remail-To: "; FinalTo
    Else
        Print #n, "Anon-To: "; FinalTo
    End If
    Print #n, "Latent-Time: +0:00"
    Print #n,
    If Subj <> "" Then Print #n, "##"; vbCrLf; "Subject: "; Subj; vbCrLf
    s = FreeFile
    Open Src For Input As s
    While Not EOF(s)
        Line Input #s, a
        Print #n, a
    Wend
    Close s: s = 0
    Close n: n = 0
Exit Function
MiddleError:
    SendMiddle = LMsg(84) + vbCrLf + "      " + Error + vbCrLf
    CloseFile n
    CloseFile s
    DelFile MDst
End Function

Private Sub Dummy(m)
    On Error GoTo DummyError
    CPunk = (Cnf(2, 0) = "True")
    CPunkNeedsMix = (Cnf(2, 0) = "True") And ((Cnf(2, 8) = "True") Or (Cnf(2, 9) = "True"))
    mix = (Cnf(3, 0) = "True") Or CPunkNeedsMix
    
    If CPunk And Not mix Then CCount = m: mcount = 0
    If CPunk And mix Then CCount = Int(Rnd(1) * (m + 1)): mcount = m - CCount
    If Not CPunk And mix Then mcount = m: CCount = 0
    
    For i = 1 To CCount
        RBDum = False
        If frmMain!chkSession(2).Value = 0 Then Exit Sub
        frmMain!barStat.SimpleText = LMsg(91) + Str(i) + " of" + Str(CCount) + "..."
        frmMain!barStat.Refresh
        If frmMain!mnuVerbose.Checked Then
            Sess(2, 1) = Sess(2, 1) + LMsg(91) + Str(i) + " of" + Str(CCount) + vbCrLf
            SessUp (2)
        End If
        Src = GetWork
        n = FreeFile
        Open Src For Output As n
        Print #n, "::"
        Print #n, "Null: auto-message@null"
        Print #n,
        Print #n, "Automatically generated cpunk dummy message."
        If Dir(ProgDir + "\Garbage.dat") = "" Then MakeGarbage
        g = FreeFile
        Open ProgDir + "\Garbage.dat" For Input As g
        If Int(Rnd(1) * 3) + 1 = 1 Then
            'Reply Block Dummy
            Close n: n = 0
            GDst = GetWork
            n = FreeFile
            Open GDst For Output As n
            RBDum = True
        End If
        gx = Int(Rnd(1) * 350) + 16
        If RBDum And (Int(Rnd(1) * 2) + 1 = 1) Then gx = 177 + (Int(Rnd(1) * 3) * 11) + Int(Rnd(1) * 3) 'For 10K fixedsize message
        For j = 1 To gx
            If Not EOF(g) Then Line Input #g, a: Print #n, a
        Next j
        Close g: g = 0
        Close n: n = 0
        PGPDst = RePGP(Src, Cnf(1, 1))
        DelFile Src
        If PGPDst <> "" Then
            If RBDum Then
                'Reply-Block Dummy
                PGPDst2 = Encrypt(GDst, MakeTag + MakeTag + MakeTag, 0, ErrMsg)
                DelFile GDst
                If PGPDst2 <> "" Then
                    n = FreeFile
                    Open PGPDst For Append As n
                    g = FreeFile
                    Open PGPDst2 For Input As g
                    Print #n,
                    Print #n, "**"; vbCrLf
                    Line Input #g, a: Print #n, a
                    Line Input #g, a
                    gx = Int(Rnd(1) * 10) + 1
                    Select Case gx
                    Case 1: Print #n, "Version: 2.6.2"
                    Case 2: Print #n, "Version: 2.6.3"
                    Case 3: Print #n, "Version: 2.6.3i"
                    Case Else: Print #n, "Version: N/A"
                    End Select
                    While Not EOF(g)
                        Line Input #g, a
                        Print #n, a
                    Wend
                    Close n: n = 0
                    Close g: g = 0
                    DelFile PGPDst2
                End If
            End If
            Src = PGPDst
            j = RandCount - 2: If j < 1 Then j = 1
            rtop = Int(Rnd(1) * j) + 1: If rtop > 6 Then rtop = 6
            a = ""
            For j = 1 To rtop
                a = a + "RANDOM,"
            Next j
            Rand = ResolveRandom(a, True, False, (Cnf(1, 4) = "True"), 10000)
            ErrMsg = ""
            If Rand <> "" Then
                etlast = Cnf(1, 1)
                Y = 1
                x = InStr(Y, Rand, ",")
                Do While x <> 0
                    et = Mid(Rand, Y, x - Y)
                    If et = "" Then Exit Do
                    Dst = CPunkMessage(Src, et, "Anon-To: " + etlast + vbCrLf, "", True, ErrMsg)
                    If Dst = "" Then Exit Do
                    etlast = et
                    DelFile Src
                    Src = Dst
                    Y = x + 1
                    x = InStr(Y, Rand, ",")
                Loop
                a = "+" + Trim(Str(Int(Rnd(1) * 6))) + ":" + Trim(Str(Int(Rnd(1) * 60)))
                If ErrMsg = "" Then ErrMsg = QueueMail(Src, etlast, "", a, "", 0)
            Else
                ErrMsg = LMsg(82)
            End If
            DelFile Src
        Else
            ErrMsg = LMsg(79)
        End If
        If ErrMsg <> "" Then
            Sess(2, 1) = Sess(2, 1) + "      " + LMsg(90) + vbCrLf + "      " + ErrMsg + vbCrLf
            Mgr(2).Errors = Mgr(2).Errors + 1
            SessUp (2)
            Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(90) + vbCrLf + "      " + ErrMsg + vbCrLf
            Mgr(0).Errors = Mgr(0).Errors + 1
            SessUp (0)
            Exit For
        End If
        If frmMain!chkSession(2).Value = 0 Then Exit Sub
        If (Date + Time - KeepDate(2)) * 24 * 60 > SVal(Cnf(5, 7)) And SVal(Cnf(5, 7)) <> 0 Then
            If frmMain!mnuVerbose.Checked Then
                Sess(2, 1) = Sess(2, 1) + LMsg(99) + vbCrLf
                SessUp (2)
            End If
            Exit Sub
        End If
        DoEvents
    Next i
    
    For i = 1 To mcount
        If frmMain!chkSession(2).Value = 0 Then Exit Sub
        frmMain!barStat.SimpleText = LMsg(92) + Str(i) + " of" + Str(mcount) + "..."
        frmMain!barStat.Refresh
        If frmMain!mnuVerbose.Checked Then
            Sess(2, 1) = Sess(2, 1) + LMsg(92) + Str(i) + " of" + Str(mcount) + vbCrLf
            SessUp (2)
        End If
        Src = GetWork
        n = FreeFile
        Open Src For Output As n
        Print #n, "Automatically generated mix dummy message."
        Close n: n = 0
        
        Rand = ""
        For t = 1 To Int(Rnd(1) * 5) + 1
            Rand = Rand + "0" + vbCrLf
        Next t
        t = Type2(Cnf(1, 1))
        If t < 1 Then t = 0
        Rand = Rand + Trim(Str(t)) + vbCrLf
        ErrMsg = ""
        Dst = MixMessage(Src, "Null: auto-message@null", "", Rand, ErrMsg)
        DelFile Src
        a = "+" + Trim(Str(Int(Rnd(1) * 6))) + ":" + Trim(Str(Int(Rnd(1) * 60)))
        If Dst <> "" Then ErrMsg = QueueMail(Dst, "", "", a, "", 1)
        DelFile Dst
        If ErrMsg <> "" Then
            Sess(2, 1) = Sess(2, 1) + "      " + LMsg(92) + vbCrLf + ErrMsg + vbCrLf
            Mgr(2).Errors = Mgr(2).Errors + 1
            SessUp (2)
            Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(90) + vbCrLf + "      " + ErrMsg + vbCrLf
            Mgr(0).Errors = Mgr(0).Errors + 1
            SessUp (0)
        End If
        If frmMain!chkSession(2).Value = 0 Then Exit Sub
        If (Date + Time - KeepDate(2)) * 24 * 60 > SVal(Cnf(5, 7)) And SVal(Cnf(5, 7)) <> 0 Then
            If frmMain!mnuVerbose.Checked Then
                Sess(2, 1) = Sess(2, 1) + LMsg(99) + vbCrLf
                SessUp (2)
            End If
            Exit Sub
        End If
    Next i
Exit Sub
DummyError:
    Sess(2, 1) = Sess(2, 1) + "      " + LMsg(96) + vbCrLf + Error + vbCrLf
    Mgr(2).Errors = Mgr(2).Errors + 1
    SessUp (2)
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(96) + vbCrLf + "      " + Error + vbCrLf
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    CloseFile n
    CloseFile g
    DelFile Src
    DelFile Dst
End Sub

Private Sub QuickSortFiles(x() As Integer, Start As Integer, Finish As Integer)
    Dim PosOfSplitter As Integer
    'Partition:
    Dim SplitPos As Integer, LeftPos As Integer
    Dim i As Integer, Splitter As Date, temp As Integer
    
    If Finish > Start Then
        'Begin Partition
        SplitPos = Start + Int((Finish - Start + 1) * Rnd)  'or  = (Start + Finish) / 2
        Splitter = Files(x(SplitPos)).FileDate
        temp = x(SplitPos): x(SplitPos) = x(Start): x(Start) = temp
        LeftPos = Start
        For i = Start + 1 To Finish
            If Files(x(i)).FileDate < Splitter Then
                LeftPos = LeftPos + 1
                temp = x(LeftPos): x(LeftPos) = x(i): x(i) = temp
            End If
        Next i
        temp = x(Start): x(Start) = x(LeftPos): x(LeftPos) = temp
        PosOfSplitter = LeftPos
        'End Partition
        QuickSortFiles x(), Start, PosOfSplitter - 1
        QuickSortFiles x(), PosOfSplitter + 1, Finish
    End If
End Sub

Private Sub MakeGarbage()
    Const radix64 = "jcDEqTGCXJMbgvr7H6OapPu9xUoV83de1Azf4LYFsKBklit+S5nmWIywZ2h/R0NQ"

    On Error GoTo GarbageError
    DelFile ProgDir + "\Garbage.dat"
    x = SVal(Cnf(2, 4)) + 10: If SVal(Cnf(2, 7)) > x Then x = SVal(Cnf(2, 7))
    If x < 50 Then x = 50
    n = FreeFile
    Open ProgDir + "\Garbage.dat" For Output As n
        For i = 1 To 16 * 50 'k
            For j = 1 To 62
                Print #n, Mid(radix64, Int(Rnd(1) * 64) + 1, 1);
            Next j
            Print #n,
            DoEvents
        Next i
    Close n: n = 0
Exit Sub
GarbageError:
    CloseFile n
End Sub

Public Function ResolveDate(ByVal d As String) As Date
    Dim tempdate As Date, Tmp(4) As String
    Const Months = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec "
    'Date: 7 Mar 1999 20:47:34 -0000

    On Error GoTo ResolveError
    ResolveDate = 0
    x = InStr(d, ",")
    If x <> 0 Then d = Mid(d, x + 1)
    d = Trim(d)
    'Break it up
    For i = 0 To 4
        x = InStr(d, " ")
        If x = 0 Then Tmp(i) = d: Exit For
        Tmp(i) = Left(d, x - 1)
        d = LTrim(Mid(d, x + 1))
    Next i
    'Replace Month with Local Language
    x = InStr(1, Months, Tmp(1) + " ", vbTextCompare)
    If x = 0 Or Tmp(0) = "" Or Tmp(1) = "" Or Tmp(2) = "" Then ResolveDate = 0: Exit Function
    Tmp(1) = Format(32874 + (((x - 1) / 4) * 32), "mmm")
    'Recompose
    d = ""
    For i = 0 To 3
        d = d + Tmp(i) + " "
    Next i
    d = Trim(d)
    tempdate = d
    
    'Adjust for Time Zone
    Tmp(4) = Trim(Extract(Tmp(4), "("))
    h = SVal(Left(Tmp(4), 3)) / 24
    m = SVal(Mid(Tmp(4), 4)) / 60 / 24: If h < 0 Then m = -m
    If tempdate <> 0 Then ResolveDate = tempdate - h - m + gmtoffset
Exit Function
ResolveError:
    ResolveDate = 0
End Function

Public Sub ProcessStart()
    Dim MailPath As String, FileX As Integer, FilesToRead As Integer
    Dim Dex() As Integer, Rand As String, RandCount As Integer, RandNeeded As Integer
    
    'Activate
    Mgr(2).Status = LMsg(88)
    TurnColor 2, True
    KeepDate(2) = Date + Time
    Mgr(2).LastRun = KeepDate(2)
    Mgr(0).LastRun = KeepDate(2)
    
    MailPath = Cnf(1, 5) + "\MAILIN\"
        
    'Display
    frmMain!barStat.SimpleText = LMsg(61)
    frmMain!barStat.Refresh
    If frmMain!mnuVerbose.Checked Then
        Sess(2, 1) = Sess(2, 1) + vbCrLf + Format(Time, "short time") + " " + LMsg(61) + vbCrLf
    End If
    SessUp (2)
    
    DoEvents
    
    'Check Sufficient Random
    If (Cnf(2, 6) = "True" Or Cnf(2, 5) = "True") Then RandNeeded = SVal(Cnf(2, 14)) - 1
    If RandNeeded > 3 Then RandNeeded = 3
    If SVal(Cnf(2, 10)) > RandNeeded Then RandNeeded = SVal(Cnf(2, 10))
    If RandNeeded > 5 Then RandNeeded = RandNeeded - 1
    If RandNeeded > 0 And Date + Time - KeepDate(26) > 1 / 24 Then
        Rand = GetRandom(0, "", True, False, False, 0, 0, "") 'PGP
        If Rand = "" Then
            RandCount = 0
        Else
            t = 0
            x = InStr(Rand, ",")
            While x <> 0
                t = t + 1
                x = InStr(x + 1, Rand, ",")
            Wend
            RandCount = t + 1
        End If
        If RandCount < RandNeeded Then
            Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(185) + vbCrLf
            Sess(2, 1) = Sess(2, 1) + Format(Time, "short time") + " " + LMsg(185) + vbCrLf
            Mgr(0).Warnings = Mgr(0).Warnings + 1
            Mgr(2).Warnings = Mgr(2).Warnings + 1
            SessUp (0)
            SessUp (2)
            KeepDate(26) = Date + Time
        End If
    End If
    
    'Refresh Garbage And GMT Calc Every 4 Hours
    If SDir(ProgDir + "\Garbage.DAT") <> "" Then
        If Date + Time - FileDateTime(ProgDir + "\Garbage.DAT") > 4 / 24 Then
            DelFile ProgDir + "\Garbage.DAT"
            gmtoffset = GetGMTOffset
        End If
    End If
    
Start:
    'Determine Load
    FilesInIn = FilesInDir(Cnf(1, 5) + "\MAILIN\*.*")
    Mgr(2).Load = FilesInIn
    SessUp (2)
    SessUp (0)
    HighLoad = (Mgr(0).Load > SVal(Cnf(1, 12)))
    
    'Look in Deferred
    DfrPath = Cnf(1, 5) + "\MAILDFR\"
    FilesInDfr = FilesInDir(DfrPath + "*.*")
    If FilesInDfr <> 0 Then
        ReDim Files(FilesInDfr + 5)
        t = 0
        a = Dir(DfrPath + "*.*")
        While a <> ""
            If Not HighLoad Or (SVal(Cnf(5, 3)) <> 0 And (Date + Time - FileDateTime(DfrPath + a)) * 24 * 60 > SVal(Cnf(5, 3))) Then
                Files(t).Filename = a: t = t + 1
            End If
            a = Dir
        Wend
        For i = 0 To t - 1
            'Moved Deferred Back to Queue
            DelFile MailPath + Files(i).Filename
            Name DfrPath + Files(i).Filename As MailPath + Files(i).Filename
        Next i
        If t > 0 Then Sess(2, 1) = Sess(2, 1) + Format(Time, "short time") + Str(t) + " " + LMsg(89) + vbCrLf
    End If
        
    'Read Dir
    FilesToRead = FilesInIn + 5: If FilesToRead > 1000 Then FilesToRead = 1000
    ReDim Files(FilesToRead)
    FileX = 0
    Files(FileX).Filename = Dir(MailPath + "*.*")
    If Files(FileX).Filename <> "" Then
        Do
            If MailPath + Files(FileX).Filename <> MailFile Then FileX = FileX + 1
            Files(FileX).Filename = Dir
        Loop Until Files(FileX).Filename = "" Or FileX = FilesToRead
        If Files(FileX).Filename = "" Then FileX = FileX - 1
    
        If FileX <> -1 Then
            ReDim Dex(FilesToRead)
            For i = 0 To FileX
                Files(i).FileDate = FileDateTime(MailPath + Files(i).Filename)
                Dex(i) = i
            Next i
            
            QuickSortFiles Dex(), 0, FileX
        
            For fx = 0 To FileX
                frmMain!barStat.SimpleText = LMsg(273) + " " + Files(Dex(fx)).Filename + " " + Str(fx + 1) + " of" + Str(FileX + 1) + "  (" + Format(Files(Dex(fx)).FileDate, "dd-mmm-yy") + " " + Format(Files(Dex(fx)).FileDate, "short time") + ")..."
                frmMain!barStat.Refresh
                If frmMain!mnuVerbose.Checked Then
                    Sess(2, 1) = Sess(2, 1) + Format(Time, "short time") + " " + Files(Dex(fx)).Filename + " " + Str(fx + 1) + " of" + Str(FileX + 1) + "  (" + Format(Files(Dex(fx)).FileDate, "dd-mmm-yy") + " " + Format(Files(Dex(fx)).FileDate, "short time") + ")" + vbCrLf
                    SessUp (2)
                    PreMsg = ""
                Else
                    PreMsg = Format(Time, "short time") + " " + Files(Dex(fx)).Filename + " " + Str(fx + 1) + " of" + Str(FileX + 1) + "  (" + Format(Files(Dex(fx)).FileDate, "dd-mmm-yy") + " " + Format(Files(Dex(fx)).FileDate, "short time") + ")" + vbCrLf
                End If
                Process (MailPath + Files(Dex(fx)).Filename)
                Mgr(2).Load = Mgr(2).Load - 1: If Mgr(2).Load < 0 Then Mgr(2).Load = 0
                Mgr(2).Counter = Mgr(2).Counter + 1
                SessUp (2)
                SessUp (0)
                DoEvents
                If frmMain!chkSession(2).Value = 0 Then GoTo Finish
                If (Date + Time - KeepDate(2)) * 24 * 60 > SVal(Cnf(5, 7)) And SVal(Cnf(5, 7)) <> 0 Then
                    Sess(2, 1) = Sess(2, 1) + LMsg(99) + vbCrLf
                    SessUp (2)
                    GoTo Finish
                End If
            Next fx
            
            'Check for more processing
            GoTo Start
        End If
    End If
    
    'Build Stats
    If PingProcessed Or RebuildStats Then
        RebuildStats = False
        PingProcessed = False
        If frmMain!mnuVerbose.Checked Then
            Sess(2, 1) = Sess(2, 1) + Format(Time, "short time") + " " + LMsg(343) + vbCrLf
            SessUp (2)
        End If
        frmMain!barStat.SimpleText = LMsg(343) + "...": frmMain!barStat.Refresh
        msg = BuildStats
        If msg <> "" Then
            Sess(0, 1) = Sess(0, 1) + msg
            Sess(2, 1) = Sess(2, 1) + msg
            Mgr(0).Errors = Mgr(0).Errors + 1
            Mgr(2).Errors = Mgr(2).Errors + 1
            SessUp (0)
            SessUp (2)
        End If
    End If
    
    'Generate Dummy Messages
    If Date + Time - KeepDate(13) >= 6 / 24 And SVal(Cnf(5, 4)) <> 0 Then
        x = Int(Abs(SVal(Cnf(5, 4)))): If x > 30 Then x = 30
        x = x + Int(Rnd(1) * 5)
        x = x - Int(Rnd(1) * 5)
        If x < 0 Then x = 0
        If x > 0 Then Dummy (x)
        KeepDate(13) = Date + Time
        WriteData
    End If
    
Finish:
    'Display
    If frmMain!mnuVerbose.Checked Then Sess(2, 1) = Sess(2, 1) + Format(Time, "short time") + " " + LMsg(95) + vbCrLf
    frmMain!barStat.SimpleText = ""
    frmMain!barStat.Refresh
    Mgr(2).Load = FilesInDir(Cnf(1, 5) + "\MAILIN\*.*")
    
    'Deactivate
    Erase Files
    Mgr(2).Status = LMsg(64)
    TurnColor 2, False
    SessUp (2)
    SessUp (0)
    SessionRunning = -1
    frmMain!tmrSession.Interval = 300
    frmMain!tmrSession.Enabled = True
End Sub

