Attribute VB_Name = "Prep"
'Copyright 1999 Potato Software.  All rights reserved.
'See MAIN.BAS for License.

Declare Function MD5 Lib "md5vb01.dll" (ByVal BufferIn As String, ByVal BufferOut As String) As Long

Public Static Function Type2(r) As Integer
    Dim Type2Date As Date, Type2DateLast As Date, TMax As Integer
    Dim Type2List() As String
    
    On Error GoTo Type2Error
    If InStr(Cnf(3, 9), "\") = 0 Then
        fn = Cnf(3, 2) + "\" + Cnf(3, 9)
    Else
        fn = Cnf(3, 9)
    End If
    If SDir(fn) = "" Then GoTo Type2Error
    Type2Date = FileDateTime(fn)
    If Type2DateLast <> Type2Date Or TMax = Empty Then
        n = FreeFile
        Open fn For Input As n
        TMax = 0
        While Not EOF(n)
            Line Input #n, a
            If Trim(a) <> "" Then TMax = TMax + 1
        Wend
        Close n: n = 0
        ReDim Type2List(TMax)
        
        t = 0
        n = FreeFile
        Open fn For Input As n
        Do While Not EOF(n)
            Line Input #n, a
            If Trim(a) <> "" Then
                t = t + 1
                Type2List(t) = a
            End If
        Loop
        Close n: n = 0
        Type2DateLast = Type2Date
    End If
    
    allr = "": nameonly = (InStr(r, "@") = 0)
    For i = 1 To TMax
        If r <> "" Then
            If nameonly Then
                If LCase(Extract(Type2List(i), " ")) = LCase(r) Then
                    x = InStr(Type2List(i), " ")
                    r = Trim(Extract(Mid(Type2List(i), x + 1), " "))
                    If InStr(r, "@") <> 0 Then Type2 = i Else Type2 = 0
                    Exit Function
                End If
            Else
                If InStr(Type2List(i), " " + r + " ") <> 0 Then Type2 = i: Exit Function
            End If
        Else
            allr = allr + Type2List(i) + vbCrLf
        End If
    Next i
    If r = "" Then r = allr
    Type2 = 0
Exit Function
Type2Error:
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(80) + vbCrLf
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    Type2 = -1
    CloseFile n
End Function

Public Function Type2Entry(entry, mname, maddress, mkeyid, mver, moptions) As Boolean
    Dim a As String, x As Long
    
    mname = "": maddress = "": mkeyid = "": moptions = "": mver = ""
    a = Trim(entry)
    For i = 1 To 5
        x = InStr(a, " "): If x = 0 Then x = Len(a) + 1
        b = Trim(Left(a, x - 1))
        Select Case i
        Case 1: mname = LCase(b)
        Case 2: maddress = b
        Case 3: mkeyid = b
        Case 4: mver = b
        Case 5: moptions = b
        End Select
        a = LTrim(Mid(a, x))
    Next i
    Type2Entry = mname <> "" And InStr(maddress, "@") <> 0 And mkeyid <> ""
End Function

Public Function AddMixKeys(keylistfile, pubkeyfile, Imperative As Boolean _
                           , Optional URL As String) As Integer
    'Adds one or more keys in pubkeyfile to pubring.mix and type2.lis
    'keylistfile contains the list of keys to be added
    'Set Imperative to unconditionally replace existing keys and not prompt
    Dim t2list As String, pubring As String
    
    If URL = "" Then URL = LMsg(287)
    On Error GoTo AddMixError
    If InStr(Cnf(3, 9), "\") = 0 Then
        t2 = Cnf(3, 2) + "\" + Cnf(3, 9)
    Else
        t2 = Cnf(3, 9)
    End If
    If t2 = "" Then t2 = "type2.lis"
    If InStr(Cnf(3, 10), "\") = 0 Then
        pm = Cnf(3, 2) + "\" + Cnf(3, 10)
    Else
        pm = Cnf(3, 10)
    End If
    If pm = "" Then pm = "pubring.mix"
    WorkPath = Cnf(1, 7)
    If SDir(t2) <> "" Then
        n = FreeFile
        Open t2 For Input As n
        t2list = vbCrLf + Input(LOF(n), n) + vbCrLf
        Close n: n = 0
    End If
    If SDir(pm) <> "" Then
        p = FreeFile
        Open pm For Input As p
        pubring = Input(LOF(p), p)
        Close p: p = 0
    End If
    t = 0
    n = FreeFile
    Open pubkeyfile For Input As n
    While Not EOF(n)
        Line Input #n, a
        a = Trim(a)
        If a = "-----Begin Mix Key-----" And Not EOF(n) Then
            Line Input #n, testkeyid
            testkeyid = Trim(testkeyid)
            p = FreeFile
            Open keylistfile For Input As p
            Do While Not EOF(p)
                Line Input #p, b
                b = Trim(b)
                If InStr(b, testkeyid) <> 0 Then
                    If Type2Entry(b, mname, maddress, mkeyid, mver, moptions) Then
                        'Key found in list
                        'Read Key
                        Key = b + vbCrLf + vbCrLf + a + vbCrLf + testkeyid + vbCrLf
                        Do While Not EOF(n)
                            Line Input #n, c
                            c = Trim(c)
                            If c = "" Then Exit Do
                            Key = Key + c + vbCrLf
                            If c = "-----End Mix Key-----" Then Exit Do
                        Loop
                        If c = "-----End Mix Key-----" Then
                            'In Original List?
                            If Not Imperative Then
                                x = InStr(1, t2list, vbCrLf + mname + " ", vbTextCompare)
                                If x <> 0 Then
                                    Y = InStr(pubring, "-----Begin Mix Key-----" + vbCrLf + mkeyid + vbCrLf)
                                    d = Extract(Mid(t2list, x + 2), vbCrLf)
                                    Type2Entry d, mname2, maddress2, mkeyid2, "", ""
                                    If LCase(maddress2) = LCase(maddress) And LCase(mkeyid2) = LCase(mkeyid) And Y <> 0 Then
                                        'Same
                                        ApproveX = 2 'No
                                    Else
                                        'Different
                                        If YesToAll Then
                                            ApproveX = 1
                                        Else
                                            ApproveX = MsgTime(LMsg(376) + vbCr + vbCr + d + vbCr + vbCr + LMsg(384) + vbCr + vbCr + b, 0, URL, 999, 2, 0, LMsg(418), LMsg(419), LMsg(420)) 'Yes, No, Yes To All
                                            If ApproveX = 3 Then ApproveX = 1: YesToAll = True
                                        End If
                                    End If
                                Else
                                    'New
                                    If YesToAll Then
                                        ApproveX = 1
                                    Else
                                        ApproveX = MsgTime(LMsg(243) + vbCr + vbCr + b, 0, URL, 999, 2, 0, LMsg(418), LMsg(419), LMsg(420)) 'Yes, No, Yes To All
                                        If ApproveX = 3 Then ApproveX = 1: YesToAll = True
                                    End If
                                End If
                            End If
                            If Imperative Or ApproveX = 1 Then
                                'Add Key
                                If AddSingleMixKey(Key, 0) Then
                                    t = t + 1
                                    If Imperative Then MsgBox LMsg(377) + vbCr + vbCr + Key, vbOKOnly, URL
                                End If
                            End If
                        End If
                    End If
                End If
            Loop
            Close p: p = 0
        End If
    Wend
    Close n: n = 0
    AddMixKeys = t
Exit Function
AddMixError:
    MsgBox LMsg(0) + vbCr + Error, vbCritical, LMsg(4)
    CloseFile (n)
    CloseFile (p)
    AddMixKeys = t
End Function

Public Function AddSingleMixKey(ByVal Key, Job As Byte) As Boolean
    'Job = 0  Add/Update key to type2.lis and pubring.mix
    '         First line of key must be type2 entry, blank line, mix key
    '         All unlisted keys are purged
    '    = 1  Remove key
    '         key contains remailer name
    '
    '         All unlisted keys are purged
    
    On Error GoTo AddMixError
    If InStr(Cnf(3, 9), "\") = 0 Then
        t2 = Cnf(3, 2) + "\" + Cnf(3, 9)
    Else
        t2 = Cnf(3, 9)
    End If
    If t2 = "" Then t2 = "type2.lis"
    If InStr(Cnf(3, 10), "\") = 0 Then
        pm = Cnf(3, 2) + "\" + Cnf(3, 10)
    Else
        pm = Cnf(3, 10)
    End If
    If pm = "" Then pm = "pubring.mix"
    WorkPath = Cnf(1, 7)
    AddSingleMixKey = False
    If SDir(pm) = "" Then
        n = FreeFile
        Open pm For Output As n
        Close n: n = 0
    End If
    If SDir(t2) = "" Then
        n = FreeFile
        Open t2 For Output As n
        Close n: n = 0
    End If
    tentry = Trim(Extract(Key, vbCrLf))
    If Not Type2Entry(tentry, mname, maddress, mkeyid, mver, moptions) Then
        If Job = 0 Then Exit Function
        mname = Key
        maddress = ""
    End If
    'Update Type2.lis
    n = FreeFile
    Open t2 For Input As n
    p = FreeFile
    Open WorkPath + "\type2_.tmj" For Output As p
    While Not EOF(n)
        Line Input #n, a
        a = Trim(a)
        If a <> "" And InStr(a, vbLf) = 0 Then
            If Type2Entry(a, mname2, maddress2, mkeyid2, "", "") Then
                If mname2 = mname Then
                    If Job = 0 Then
                        If maddress <> maddress2 Or mkeyid <> mkeyid2 Then
                            If MsgBox(LMsg(378) + vbCr + vbCr + a + vbCr + vbCr + LMsg(384) + vbCr + vbCr + tentry, vbExclamation + vbYesNo + vbDefaultButton2, LMsg(287)) = vbNo Then
                                Close n: n = 0
                                Close p: p = 0
                                DelFile WorkPath + "\type2_.tmj"
                                Exit Function
                            End If
                        End If
                        Print #p, tentry: allt = allt + tentry + vbCrLf
                    End If
                Else
                    Print #p, a: allt = allt + a + vbCrLf
                End If
            End If
        End If
    Wend
    If Job = 0 And InStr(allt, tentry + vbCrLf) = 0 Then
        Print #p, tentry: allt = allt + tentry + vbCrLf
    End If
    Close p: p = 0
    Close n: n = 0
    'Update Pubring/Mix
    n = FreeFile
    Open pm For Input As n
    p = FreeFile
    Open WorkPath + "\pubring_.tmj" For Output As p
    While Not EOF(n)
        Line Input #n, a
        If Trim(a) <> "" And InStr(a, vbLf) = 0 Then
            If Type2Entry(a, mname2, maddress2, mkeyid2, "", "") Then
                lastentry = Trim(a)
            Else
                If a = "-----Begin Mix Key-----" Then
                    If Not EOF(n) Then
                        Line Input #n, testkeyid
                        If testkeyid = mkeyid Then
                            If Job = 0 And Key <> "" Then
                                Print #p, Key
                                Key = ""
                                AddSingleMixKey = True
                            End If
                        Else
                            If InStr(allt, " " + testkeyid + " ") <> 0 Then
                                Type2Entry lastentry, "", "", mkeyid2, "", ""
                                If mkeyid2 <> testkeyid Then lastentry = ""
                                Print #p, lastentry; vbCrLf; vbCrLf; a; vbCrLf; testkeyid
                                Do While Not EOF(n)
                                    Line Input #n, a
                                    If a = "" Then Exit Do
                                    Print #p, a
                                    If a = "-----End Mix Key-----" Then Exit Do
                                Loop
                                Print #p,
                            End If
                        End If
                    End If
                End If
                lastentry = ""
            End If
        End If
    Wend
    If Job = 0 And Key <> "" Then Print #p, Key: AddSingleMixKey = True
    Close p: p = 0
    Close n: n = 0
    FileCopy WorkPath + "\type2_.tmj", t2
    DelFile WorkPath + "\type2_.tmj"
    FileCopy WorkPath + "\pubring_.tmj", pm
    DelFile WorkPath + "\pubring_.tmj"
Exit Function
AddMixError:
    MsgBox LMsg(0) + vbCr + Error, vbCritical, LMsg(4)
    CloseFile (n)
    CloseFile (p)
    DelFile WorkPath + "\type2_.tmj"
    DelFile WorkPath + "\pubring_.tmj"
    AddSingleMixKey = False
End Function

Public Sub ImportKeyFile(fn)
    Dim FileIn As String * 256
    Dim KeyProps As String * 32000
    Dim KeyPropsLen As Long
    Dim ErrorString As String * 256, i As Long
    
    If SDir(fn) = "" Then Exit Sub
    If Val(Cnf(1, 17)) = 0 Then
        'PGP 2.6.x
        If MsgBox(LMsg(388), vbYesNo + vbQuestion, LMsg(128)) = vbYes Then
            'Get signature keyid
            sk = SelectKey(LMsg(120), "")
            If sk = "" Then Exit Sub
            sk = " -u " + Extract(sk, "   ")
        End If
        ReliShell "pgp " + fn + sk, vbNormalFocus, "NUL"
    Else
        'PGP 5.x
        FileIn = fn + Chr(0)
        KeyProps = Chr(0)
        KeyPropsLen = 32000
        i = spgpKeyImportFile(FileIn, KeyProps, KeyPropsLen)
        If i <> 0 Then
            ErrorString = Chr(0)
            i = spgpGetErrorString(i, ErrorString)
            MsgBox LMsg(389) + vbCr + Extract(ErrorString, Chr(0)), vbOKOnly + vbCritical, LMsg(4)
            Exit Sub
        End If
    End If
End Sub

Public Function Encrypt(Src, Key, Job, ErrMsg, Optional ConvAlg As Long) As String
    ErrMsg = ""
    Key = Trim(Key)
    If Dir(Src) = "" Or Key = "" Then Encrypt = "": Exit Function
    Dst = PlainName(Src, 0) + PlainName(Src, 2) + ".asc"
    If Not DelFile(Dst) Then ErrMsg = LMsg(217): Encrypt = "": Exit Function
    If Val(Cnf(1, 17)) = 0 Then
        'PGP 2.6.x
        Select Case Job
        Case 0
            a = "pgp +bat -cat -z" + Chr(34) + Key + Chr(34) + " " + Src
        Case 1
            a = "pgp +bat -eat " + Src + " " + Chr(34) + Key + Chr(34)
        End Select
        
        If Len(a) > 115 Then
            ErrMsg = LMsg(216)
            Encrypt = ""
            Exit Function
        End If
        ReliShell a, Val(RData(1)), Dump
        
        If Dir(Dst) <> "" Then
            DelFile Dump
            Encrypt = Dst
        Else
            DelFile DOSDump
            DOSDump = Dump
            Encrypt = ""
        End If
    Else
        'PGP 5.x
        ' all strings must be of fixed length
        Dim CryptKeyID As String * 256, SignKeyID As String * 256
        Dim SignKeyPass As String * 256, IDEAPass As String * 256
        Dim comment As String * 256, FileIn As String * 256
        Dim FileOut  As String * 256, ErrorString As String * 256
        Dim i As Long
        
        If Job = 0 Then
            FileIn = Src & Chr(0)
            FileOut = Dst & Chr(0)
            CryptKeyID = "" & Chr(0)
            SignKeyID = "" & Chr(0)
            SignKeyPass = "" & Chr(0)
            IDEAPass = Left(Key, 255) & Chr(0)
            comment = Chr(0)
            If ConvAlg = 0 Then ConvAlg = 1
            ErrorString = Chr(0)
            i = spgpEncodeFile(FileIn, FileOut, 0, 0, 1, 1, ConvAlg, 1, 1, 0, CryptKeyID, SignKeyID, SignKeyPass, IDEAPass, comment) '20
        Else
            rkey = FindPGPKey(Key, True)
            If rkey = "" Then
                ErrMsg = LMsg(314) + " " + Key
                Encrypt = ""
                Exit Function
            End If
            FileIn = Src & Chr(0)
            FileOut = Dst & Chr(0)
            CryptKeyID = Extract(rkey, Chr(9)) & Chr(0)
            SignKeyID = "" & Chr(0)
            SignKeyPass = "" & Chr(0)
            IDEAPass = "" & Chr(0)
            comment = Chr(0)
            i = spgpEncodeFile(FileIn, FileOut, 1, 0, 1, 0, 1, 1, 1, 0, CryptKeyID, SignKeyID, SignKeyPass, IDEAPass, comment) '20
            If i <> 0 Then i = spgpGetErrorString(i, ErrorString): ErrMsg = Extract(ErrorString, Chr(0))
        End If
        If Dir(Dst) <> "" Then
            Encrypt = Dst
        Else
            Encrypt = ""
        End If
        DoEvents
    End If
End Function

Public Function PGPOK(n, p, EncOut) As Boolean
    Dim TempOK As Boolean
    'Copies p to n and checks for PGP integrity
    'Removes PGP headers
    'No local error trapping
        
    TempOK = False
    If EncOut Then
        If Not EOF(p) Then
            Line Input #p, a
            Print #n, a
        Else: a = ""
        End If
        TempOK = (a Like "-----BEGIN PGP *-----")
        If TempOK And Not EOF(p) Then
            'Headers
            Print #n, "Version: N/A"
            Line Input #p, a
            Do While (InStr(a, ":") <> 0 Or LTrim(a) = "") And Not EOF(p)
                Line Input #p, a
            Loop
            Print #n, vbCrLf; a
        End If
    End If
    While Not EOF(p)
        Line Input #p, a
        Print #n, a
    Wend
    If Not a Like "-----END PGP *-----" Then TempOK = False
    PGPOK = TempOK
End Function

Public Function Decrypt(Src, Passphrase) As String
    If Dir(Src) = "" Then Decrypt = "": Exit Function
    Dst = GetWork
    If Val(Cnf(1, 17)) = 0 Then
        'PGP 2.6.x
        If Passphrase <> "" Then
            ps = "-z" + Chr(34) + Passphrase + Chr(34) + " "
            psb = "-z" + Chr(34) + "***Passphrase***" + Chr(34) + " "
        End If
        
        ReliShell "pgp +bat " + ps + Src + " -o " + Dst, Val(RData(1)), Dump, "pgp +bat " + psb + Src + " -o " + Dst
        
        If Dir(Dst) <> "" Then
            DelFile Dump
            Decrypt = Dst
        Else
            DelFile DOSDump
            DOSDump = Dump
            Decrypt = ""
        End If
    Else
        'PGP 5.x
        ' all strings must be of fixed length
        Dim SigProps As String * 256
        Dim Pass As String * 256
        Dim FileIn As String * 256
        Dim FileOut As String * 256
        Dim i As Long
        Dim Sig As TSig_Data
        
        SigProps = "" & Chr(0)
        Pass = Left(Passphrase, 255) & Chr(0)
        FileIn = Src & Chr(0)
        FileOut = Dst & Chr(0)
        ErrorString = Chr(0)
        
        i = spgpDecodeFile(FileIn, FileOut, Pass, SigProps)
        'If i <> 0 Then i = spgpGetErrorString(i, ErrorString): ErrMsg = Extract(ErrorString, Chr(0))
        'i =  -11500 = Private Key not available
        If Dir(Dst) <> "" Then
            Decrypt = Dst
        Else
            Decrypt = ""
        End If
        DoEvents
    End If
End Function

Public Function CPunkMessage(Src, raddress, RemHead, HashHead, Encrypted As Boolean, ErrMsg) As String
    Dim Dst As String, ESFile As String, ns As Integer, nd As Integer, a As String
    
    On Error GoTo CPunkError
    If Dir(Src) = "" Or raddress = "" Or RemHead = "" Then CPunkMessage = "": Exit Function
        
    Dst = GetWork
    ns = FreeFile
    Open Src For Input As ns
    nd = FreeFile
    Open Dst For Output As nd
    Print #nd, "::"
    Print #nd, RemHead
    If HashHead <> "" Then Print #nd, "##": Print #nd, HashHead
    While Not EOF(ns)
        Line Input #ns, a
        Print #nd, a
    Wend
    Close ns: ns = 0
    Close nd: nd = 0
    If Encrypted Then
        ESFile = RePGP(Dst, raddress)
        DelFile Dst
        If ESFile = "" Then
            'Encryption error
            ErrMsg = LMsg(50) + ": " + raddress + vbCrLf
            CPunkMessage = ""
        Else
            CPunkMessage = ESFile
        End If
    Else
        CPunkMessage = Dst
    End If
Exit Function
CPunkError:
    ErrMsg = LMsg(49) + vbCrLf + "      " + Error + vbCrLf
    CPunkMessage = ""
    CloseFile nd
    CloseFile ns
    DelFile Dst
End Function

Public Function RePGP(Src, Key) As String
    On Error GoTo RePGPError
    PGPDst = Encrypt(Src, Key, 1, "")
    If PGPDst = "" Then
        RePGP = ""
    Else
        Dst = GetWork
        n = FreeFile
        Open Dst For Output As n
        Print #n, "::"
        Print #n, "Encrypted: PGP"; vbCrLf
        p = FreeFile
        Open PGPDst For Input As p
        EncGood = PGPOK(n, p, True)
        Close p: p = 0
        DelFile PGPDst
        Close n: n = 0
        If Not EncGood Then
            'Encrypt Failure
            DelFile Dst
            RePGP = ""
        Else
            'Encrypt Good
            RePGP = Dst
        End If
    End If
Exit Function
RePGPError:
    ErrMsg = LMsg(49) + vbCrLf + "      " + Error + vbCrLf
    RePGP = ""
    CloseFile n
    CloseFile p
    DelFile PGPDst
    DelFile Dst
End Function

Public Function MixMessage(Src, ToAddresses, Headers, Remailers, ErrMsg) As String
    Dim ToA As String, a As String, x As Integer, Y As Integer, Dst As String
    Dim MixCon As String, MultPart As Boolean
    
    If Dir(Src) = "" Or Remailers = "" Then MixMessage = "": ErrMsg = LMsg(51): Exit Function
    MixRun = GetWork
    
    n = FreeFile
    Open MixRun For Output As n
    ToA = ToAddresses + ","
    Y = 1
    x = InStr(Y, ToA, ",")
    While x <> 0
        a = Mid(ToA, Y, x - Y)
        If a <> "" Then Print #n, a
        Y = x + 1
        x = InStr(Y, ToA, ",")
    Wend
    Print #n,
    Print #n, Headers
    Print #n, Remailers
    Print #n, Src
    Print #n,
    Print #n,
    Print #n,
    Print #n,
    Print #n,
    Close n: n = 0

    Dst = GetWork
    Dst = Left(Dst, Len(Dst) - 4)
    DelFile (Dst)
    For i = 1 To 9
        DelFile Dst + "." + Trim(Str(i)) + "*"
    Next i
    a = "mixmaste -O " + Dst + " <" + MixRun
    ReliShell a, Val(RData(1)), Dump, "", Cnf(3, 1) + "\"

    DelFile MixRun
    MultPart = Dir(Dst) = ""
    If MultPart And Dir(Dst + ".1") = "" Then
        ErrMsg = LMsg(51) + vbCrLf
        DelFile DOSDump
        DOSDump = Dump
        MixMessage = ""
    Else
        DelFile Dump
        x = 1
        Do
            If MultPart Then fn = Dst + "." + Trim(Str(x)) Else fn = Dst
            If Dir(fn) = "" Then Exit Do
            If FileLen(fn) < 28800 Then
                'Insufficent Mix disk space detected
                If MultPart Then DelFile Dst + ".*" Else DelFile Dst
                ErrMsg = LMsg(186) + vbCrLf
                MixMessage = ""
                Exit Function
            End If
            x = x + 1
        Loop Until Not MultPart
        MixMessage = Dst
    End If
Exit Function
MixError:
    ErrMsg = LMsg(51) + vbCrLf + "      " + LMsg(49) + vbCrLf + "      " + Error + vbCrLf
    MixMessage = ""
    CloseFile n
    DelFile Dst
    DelFile MixCon
End Function

Public Function UnMixmaster(Src, ErrMsg) As String
    Dim Dst As String, Dst2 As String, MixFP As String
    
    On Error GoTo MixError
    MixFP = Cnf(3, 2)
    If SDir(MixFP + "\ma*.   ") <> "" Then
        If Not DelFile(MixFP + "\ma*.   ") Then
            'Error deleting messages
            ErrMsg = "      " + LMsg(52) + vbCrLf
            UnMixmaster = ""
            Exit Function
        End If
    End If
    ReliShell "mixmaste -R <" + Src, Val(RData(1)), Dump, "", Cnf(3, 1) + "\"
    Dst = SDir(MixFP + "\ma*.   ")
    If Dst = "" Then
        'Failure
        ErrMsg = LMsg(337)
        If Dump <> "" Then
            If SDir(Dump) <> "" Then
                n = FreeFile
                Open Dump For Input As n
                For i = 1 To 10
                    If Not EOF(n) Then Line Input #n, a
                Next i
                Close n: n = 0
                ErrMsg = a
            End If
        End If
        DelFile DOSDump
        DOSDump = Dump
        UnMixmaster = ""
    Else
        DelFile Dump
        Do
            Dst2 = MixFP + "\" + Left(MakeTag, 6) + ".rel"
        Loop Until SDir(Dst2) = ""
        Name MixFP + "\" + Dst As Dst2
        UnMixmaster = Dst2
    End If
    DelFile MixFP + "\tm*.   "
Exit Function
MixError:
    ErrMsg = "      " + LMsg(49) + vbCrLf + "      " + Error + vbCrLf
    UnMixmaster = ""
    CloseFile n
    DelFile MixFP + "\" + Dst
    DelFile MixFP + "\tm*.   "
End Function

Public Function ResolveRandom(ReList, PGP As Boolean, RePGP As Boolean, Middle As Boolean, Size As Long)
    'Returns ReList, reversed order, trailing "," with random remailers chosen
    'Nul return indicates insufficient remailers
    'RePGP - last remailer must support RePGP (if random)
    'Middle - First remailer must comply with dest allow (if random)
    Dim rl As String, x As Integer, Y As Integer, test As String, r As String
    Dim rlast(2) As String, Position As String
    
    rl = ReList + ","
    Y = 1
    x = InStr(rl, ",")
    While x <> 0
        r = Mid(rl, Y, x - Y)
        If r <> "" Then
            'Get Random
            If LCase(r) = "random" Then
                'Determine Position
                If Y = 1 Then
                    Position = "First"
                Else
                    If Mid(rl, x + 1) = "," Then Position = "Last" Else Position = ""
                End If
                'Look ahead
                test = Mid(rl, x + 1)
                t = 1
                z = InStr(test, ",")
                While z <> 0 And t < 3
                    z = InStr(z + 1, test, ",")
                    t = t + 1
                Wend
                If t > 1 Then If z = 0 Then test = Mid(rl, x + 1) Else test = Left(test, z)
                'Resolve
                r = GetRandom(1, Position, PGP, RePGP, Middle, Size, 0, rlast(2) + "," + rlast(1) + "," + rlast(0) + "," + test)
                If r = "" Then ResolveRandom = "": Exit Function
            End If
            'Place
            ResolveRandom = r + "," + ResolveRandom
            rlast(2) = rlast(1)
            rlast(1) = rlast(0)
            rlast(0) = r
        End If
        Y = x + 1
        x = InStr(Y, rl, ",")
    Wend
End Function

Public Function GetRandom(rh As Byte, Position As String, PGP As Boolean, RePGP As Boolean, Middle As Boolean, Size As Long, rtype, test) As String
    'If rh = 0 returns whole list else returns 1 remailer
    'Position = "First"; "Last"; or ""
    'PGP requires pgp
    'RePGP & "Last" & cpunk then choice limited to repgp capable
    'Middle & "First" then choice limited to dest allowed
    'Size - if klen exists and size exceeded remailer will not be chosen
    'If remailer in test it will not be chosen
    Dim Remailers(MaxRemailers) As String, klen As Long
    If rtype = 0 Then typer = " cpunk " Else typer = " mix "
    
    'Iterate through each remailer
    x = 0
    Do While RString(x) <> "" And RemX < MaxRemailers
        RemailerString RString(x), rname, raddress, ""
        Remailer rname, raddress, 0, roptions, rlatent, rup
        'Remailer found?
        If rname = "" Or raddress = "" Then GoTo Fail
        'Type?
        If InStr(1, roptions, typer, vbTextCompare) = 0 Then GoTo Fail
        'Trust?
        If InStr(roptions, " trust") = 0 Then
            'Latent?
            lt = Cnf(2, 12): If lt = "" Then lt = "99:99"
            If Trim(rlatent) = "" Then rlatent = "99:99"
            If LatentValue(rlatent) > LatentValue(lt) Then GoTo Fail
            'Rup?
            If Val(rup) < Val(Cnf(2, 11)) Then GoTo Fail
        End If
        'Test?
        If InStr(test, raddress) <> 0 Then GoTo Fail
        'Klen?
        k = InStr(roptions, " klen")
        If k <> 0 Then If Size + 2000 > Val(Extract(Mid(roptions, k + 5), " ")) * 1024 Then GoTo Fail
        'pgponly?
        If (rtype = 0) And Not (RePGP Or PGP) Then If InStr(1, roptions, " pgponly ", vbTextCompare) <> 0 Then GoTo Fail
        'Middle First?
        If Middle And Position = "First" Then If SubSearch(raddress, CnfFiles(7), 1) = "" Then GoTo Fail
        'RePGP Exclusion?
        If RePGP And Position = "Last" And rtype = 0 Then If InStr(1, CnfFiles(4), raddress, vbTextCompare) <> 0 Then GoTo Fail
        'Random Exclusion?
        If rtype = 0 And InStr(1, CnfFiles(3), raddress, vbTextCompare) <> 0 Then GoTo Fail
        'Middle Last?
        If Position = "Last" Then If InStr(1, roptions, "middle", vbTextCompare) <> 0 Then GoTo Fail
        'pgp?
        If (rtype = 0) And (RePGP Or PGP) Then If InStr(1, roptions, "pgp", vbTextCompare) = 0 Then GoTo Fail
        'Good
        Remailers(RemX) = raddress
        RemX = RemX + 1
Fail:
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
    
    If RemX = 0 Then GetRandom = "": Exit Function
    If rh = 0 Then
        If RemX > 0 Then
            GetRandom = Remailers(0)
            For i = 1 To RemX - 1
                GetRandom = GetRandom + "," + Remailers(i)
            Next i
        End If
        Exit Function
    End If
    
   GetRandom = Remailers(Int(Rnd(1) * RemX))
End Function

Public Function GetLatent(Latent) As Date
    If Latent = "" Then
        minl = LatentValue(Cnf(5, 5))
        maxl = LatentValue(Cnf(5, 6))
        If maxl < minl Then maxl = minl + 0.5
        l = (Rnd(1) * (maxl - minl)) + minl
        GetLatent = Date + Time + (l / 24)
    Else
        If Left(Latent, 1) = "+" Then
            l = LatentValue(Latent)
            If LCase(Right(Latent, 1)) = "r" Then l = (Rnd(1) * l)
            GetLatent = Date + Time + (l / 24)
        Else
            l = LatentValue(Latent)
            If l > 23.99 Then GetLatent = GetLatent(""): Exit Function
            h = Int(l)
            m = Int((l - Int(l)) * 60): If m > 59 Then m = 59
            hhmm = Right("0" + Trim(Str(h)), 2) + ":" + Right("0" + Trim(Str(m)), 2)
            gmt = Date + Time - gmtoffset
            t = LatentValue(Format(gmt, "short time")) / 24
            lt = LatentValue(hhmm) / 24
            If lt < t Then lt = lt + 1
            GetLatent = gmt - t + lt + gmtoffset
        End If
    End If
End Function

Public Function LatentValue(Latent) As Single
    Latent = Trim(Latent)
    If Latent = "" Then LatentValue = 0: Exit Function
    h = Abs(Int(Val(Latent)))
    x = InStr(Latent, ":")
    If x <> 0 Then m = Abs(Int(Val(Mid(Latent, x + 1)))) / 60
    If h > 99 Then h = 99
    If m * 60 > 99 Then m = 99 / 60
    LatentValue = h + m
End Function

Public Function TestPGP() As String
    Src = GetWork
    n = FreeFile
    Open Src For Output As n
    Print #n, "PGP Test Message"
    Close n: n = 0
    If Cnf(1, 1) = "" Then
        Pass = "test"
        PGPDst = Encrypt(Src, Pass, 0, ErrMsg)
    Else
        Pass = XCrypt("@@@" + RSS, RightWin)
        PGPDst = Encrypt(Src, Cnf(1, 1), 1, ErrMsg)
    End If
    If PGPDst = "" Then msg = 108: GoTo PGPError
    PGPDst2 = Decrypt(PGPDst, Pass)
    If PGPDst2 = "" Then msg = 109: GoTo PGPError
    DelFile PGPDst
    DelFile PGPDst2
    DelFile Src
    TestPGP = ""
Exit Function
PGPError:
    If msg = 0 Then
        TestPGP = LMsg(110) + vbCrLf + Error
    Else
        TestPGP = LMsg(msg) + vbCrLf + ErrMsg
    End If
    CloseFile n
    DelFile PGPDst
    DelFile PGPDst2
    DelFile Src
End Function

Public Function KeyFile(KFile As String) As String
    On Error GoTo ErrorKeyFile
    PubKeyX = 0
    ReDim PubKeys(MaxPubKeys)
    If KFile <> "" Then pubkeyfile = ""
    
    If KFile = "" Then
        ReliShell "pgp +verbose=1 -kv > " + Cnf(1, 7) + "\KeyRing.rel", Val(RData(1)), "NUL"
    Else
        ReliShell "pgp +verbose=1 -kv " + KFile + " > " + Cnf(1, 7) + "\KeyRing.rel", Val(RData(1)), "NUL"
    End If
    
    If SDir(Cnf(1, 7) + "\Keyring.rel") = "" Then
        pubkeyfile = ""
        PubKeyX = 0
        KeyFile = LMsg(111) + vbCr: Exit Function
    Else
        n = FreeFile
        Open Cnf(1, 7) + "\Keyring.rel" For Input As n
        While Not EOF(n) And PubKeyX < MaxPubKeys
            Line Input #n, a
            'Get Ring Pathname
            If NewKeyFile = "" And InStr(a, "'") > 1 Then
                x = InStr(a, "'")
                If x <> 0 And x <> Len(a) Then NewKeyFile = Extract(Mid(a, x + 1), "'")
            End If
            b = LCase(Left(a, 3))
            If b = "pub" Or b = "sec" Or b = Chr(246) + "ff" Or b = Chr(148) + "ff" Or b = "prv" Then
                PubKeys(PubKeyX) = a
                PubKeyX = PubKeyX + 1
            End If
        Wend
        If NewKeyFile = "" Then
            NewKeyFile = "::NoAuto::"
        Else
            If SDir(NewKeyFile) = "" Then NewKeyFile = ""
        End If
        If PubKeyX = 0 Then
            NewKeyFile = "::NoAuto::"
            KeyFile = LMsg(112) + vbCr
            Exit Function
        End If
        If KFile = "" Then
            If PubKeyX <> 0 And NewKeyFile <> "::NoAuto::" Then PubKeyDate = FileDateTime(NewKeyFile)
            pubkeyfile = NewKeyFile
        End If
        If NewKeyFile = "::NoAuto::" Then NewKeyFile = "???"
        Close n: n = 0
        DelFile Cnf(1, 7) + "\Keyring.rel"
    End If
    KeyFile = ""
Exit Function
ErrorKeyFile:
    pubkeyfile = ""
    PubKeyX = 0
    KeyFile = LMsg(113) + vbCr + Error + vbCr
    CloseFile n
    DelFile Cnf(1, 7) + "\Keyring.rel"
End Function

Public Sub Crypt(Job As Integer, Source As Integer, Dest As Integer)
    On Error GoTo ErrorCrypt
    Dim a As String
    q = Chr(34)
    Select Case Job
    Case 0
        JobMsg = LMsg(124) '"Decrypt"
    Case 1
        JobMsg = LMsg(125) '"Encrypt"
    Case 2
        JobMsg = LMsg(126) '"Sign"
    Case 3
        JobMsg = LMsg(127) '"Encrypt and Sign"
    Case 4
        JobMsg = LMsg(128) '"Add Key"
    Case 5
        JobMsg = LMsg(129) '"Certify Key"
    Case Else
        Exit Sub
    End Select
    
    If Source = 0 Then
        JobMsg = JobMsg + " " + LMsg(130) 'Clipboard
        dsw = "w"
    Else
        If Job <> 5 Then JobMsg = JobMsg + " " + LMsg(131) 'File"
    End If
    
    If Job < 4 Then
        Select Case Dest
        Case 0
            JobMsg = JobMsg + " " + LMsg(132) 'To Clipboard"
            dsw = "at" + dsw
        Case 1
            JobMsg = JobMsg + " " + LMsg(133) 'To ASCII File"
            dsw = "at" + dsw
        Case 2
            JobMsg = JobMsg + " " + LMsg(134)  'To Binary File
        Case Else
            Exit Sub
        End Select
        If Job = 2 And Dest < 2 Then dsw = dsw + " +clearsig=on"
    End If
    
    'Prepare Source
    If Job <> 5 Then
        If Source = 0 Then
            a = Clipboard.GetText
            If ((Job = 0 Or Job = 4) And InStr(a, "-----BEGIN PGP") = 0) Or a = "" Then MsgBox LMsg(135), vbInformation, LMsg(136): Exit Sub
            If Job > 0 And Job < 4 Then
                'Please verify clipboard contents
                If MsgBox(LMsg(114) + vbCrLf + vbCrLf + Left(a, 300), vbQuestion + vbOKCancel, LMsg(115)) = vbCancel Then Exit Sub
            End If
            srcfile = Cnf(1, 7) + "\REL_MSG.asc"
            n = FreeFile
            Open srcfile For Output As n
            Print #n, a;
            Close n: n = 0
        Else
            frmMain!CommonDialog1.Filter = "All Files (*.*)|*.*"
            frmMain!CommonDialog1.FilterIndex = 1
            frmMain!CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNFileMustExist
            frmMain!CommonDialog1.DialogTitle = LMsg(116) + " - " + JobMsg 'Open source file
            frmMain!CommonDialog1.InitDir = CryptPathS
            frmMain!CommonDialog1.CancelError = True
            On Error GoTo CancelDialog
            frmMain!CommonDialog1.Action = 1
            On Error GoTo ErrorCrypt
            srcfile = frmMain!CommonDialog1.Filename
            If Trim(srcfile) = "" Then Exit Sub
            CryptPathS = PlainName(srcfile, 0)
        End If
    End If
    
    'Prepare Dest
    If Job <> 4 And Job <> 5 Then
        If Dest = 0 Then
            dstfile = Cnf(1, 7) + "\REL_MSG.rel"
        Else
            frmMain!CommonDialog1.Filter = "All Files (*.*)|*.*"
            frmMain!CommonDialog1.FilterIndex = 1
            frmMain!CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNPathMustExist
            frmMain!CommonDialog1.DialogTitle = LMsg(117) + " - " + JobMsg 'Open dest file
            frmMain!CommonDialog1.InitDir = CryptPathD
            frmMain!CommonDialog1.CancelError = True
            On Error GoTo CancelDialog
            frmMain!CommonDialog1.Action = 1
            On Error GoTo ErrorCrypt
            dstfile = frmMain!CommonDialog1.Filename
            If Trim(dstfile) = "" Then Exit Sub
            CryptPathD = PlainName(dstfile, 0)
        End If
    End If
    
    'Get UserIDs
    If Job = 1 Or Job = 3 Then
        'Select Recipient's Keys
        encID = Extract(SelectKey(LMsg(118) + " - " + JobMsg), "   ")
        If Trim(encID) = "" Then Exit Sub
    End If
    
    If Job = 5 Then
        'Select Key To Be Certified
        encID = Extract(SelectKey(LMsg(119) + " - " + JobMsg), " ")
        If Trim(encID) = "" Then Exit Sub
    End If
    
    If Job = 2 Or Job = 3 Or Job = 5 Then
        'Select Key For Signature
        sigID = Extract(SelectKey(LMsg(120) + " - " + JobMsg), " ")
        If Trim(sigID) = "" Then Exit Sub
    End If
    
    If Job = 4 Then
        'Select Key For Certification Sig (Optional)
        sigID = Extract(SelectKey(LMsg(121) + " - " + JobMsg), " ")
    End If
    
    'Set PGP Command
    Select Case Job
    Case 0
        PComm = q + srcfile + q + " -o " + q + dstfile + q
    Case 1
        If LCase(encID) = "-c" Then
            PComm = "-c" + dsw + " " + q + srcfile + q + " -o " + q + dstfile + q
        Else
            PComm = "-e" + dsw + " " + q + srcfile + q + " " + encID + " -o " + q + dstfile + q
        End If
    Case 3
        If LCase(encID) = "-c" Then
            PComm = "-sc" + dsw + " " + q + srcfile + q + " -u " + sigID + " -o " + q + dstfile + q
        Else
            PComm = "-se" + dsw + " " + q + srcfile + q + " " + encID + " -u " + sigID + " -o " + q + dstfile + q
        End If
    Case 2
        PComm = "-s" + dsw + " " + q + srcfile + q + " -u " + sigID + " -o " + q + dstfile + q
    Case 4
        PComm = "-ka " + q + srcfile + q
        If Trim(sigID) <> "" Then PComm = "-ka " + q + srcfile + q + " -u " + sigID
    Case 5
        PComm = "-ks " + encID + " -u " + sigID
    End Select

    frmMain.MousePointer = 11
    ReliShell "pgp " + PComm, vbNormalFocus, "NUL"
    frmMain.MousePointer = 0
    
    'Finish
    If Job < 4 Then
        If Dir(dstfile) = "" Then
            MsgBox LMsg(122), vbCritical, LMsg(123)
        Else
            If Dest = 0 Then
                n = FreeFile
                Open dstfile For Input As n
                x = LOF(n): If x > 400000 Then x = 400000
                a = Input(x, n)
                Close n: n = 0
                Clipboard.Clear
                Clipboard.SetText a
                DelFile dstfile
            End If
        End If
        
        If Source = 0 And Dir(srcfile) <> "" And Job <> 0 Then DelFile (srcfile)
        If Source = 0 And Dir(srcfile) <> "" And Job = 0 Then DelFile srcfile
    Else
        If Source = 0 And Job <> 5 Then DelFile srcfile
    End If
Exit Sub
CancelDialog:
Exit Sub
ErrorCrypt:
    MsgBox LMsg(0) + vbCrLf + Error, vbCritical, JobMsg + " Error"
    DOSTag = ""
    CloseFile n
End Sub

Public Function PGPKey(ByVal a, Optional DelKey As Boolean)
    On Error GoTo ErrorPGPKey
    If a = "" Then PGPKey = "": Exit Function
    a = Left(a, 90)
    x = InStr(a, "(")
    If x <> 0 Then
        XKeyFile = " " + Trim(Extract(Right(a, Len(a) - x), ")"))
        a = Trim(Left(a, x - 1))
    End If
    If Not DelKey Then
        ReliShell "pgp +bat -kxa " + a + " " + Cnf(1, 7) + "\RELKey" + XKeyFile, vbMinimizedFocus, "NUL"
    Else
        ReliShell "pgp -kr " + a + XKeyFile, vbNormalFocus, "NUL"
    End If
    If Not DelKey Then
        If SDir(Cnf(1, 7) + "\RELKey.asc") <> "" Then
            n = FreeFile
            Open Cnf(1, 7) + "\RELKey.asc" For Input As n
            a = Input(LOF(n), n)
            Close n: n = 0
            DelFile Cnf(1, 7) + "\RELKey.asc"
            PGPKey = a
        Else
            PGPKey = ""
        End If
    Else
        PGPKey = ""
    End If
Exit Function
ErrorPGPKey:
    MsgBox LMsg(137), vbCritical, LMsg(138)
    CloseFile n
    DOSTag = ""
End Function

Public Sub CopyKey(Index As Integer)
    If Index = 0 Then
        b = Extract(SelectKey(LMsg(139)), " ") 'Select Key To Extract
    Else
        b = Extract(SelectKey(LMsg(140)), " ") 'Select Key To Delete
    End If
    If b = "" Then Exit Sub
    If pubkeyfile = "" Then
        x = InStr(frmKeys!lblKeys.Caption, "Keyring: ")
        If x <> 0 Then a = Extract(Mid(frmKeys!lblKeys.Caption, x + 9), "   ")
        If a <> "" And a <> "???" Then b = b + " (" + a + ")"
    End If
    a = PGPKey(b, Index = 1)
    If Index = 0 Then
        Clipboard.Clear
        Clipboard.SetText a
    End If
End Sub

Public Function SelectKey(Title As String, Optional ByVal Address As String) As String
    x = InStr(Address, "<")
    If x <> 0 Then Address = Extract(Mid(Address, x + 1), ">")
    frmKeys!cmdOK(1).Visible = Not (Title = LMsg(141)) 'View Keyring
    frmKeys.Caption = Title
    frmKeys.Tag = Address
    frmKeys.Show (1)
    SelectKey = frmKeys.Tag
    If RData(2) = "True" Then Unload frmKeys
End Function

Public Static Function BlockMessage(OrigFrom) As String
    Dim Blocked(100) As String, BlockX As Byte, Started As Date
    Dim TotalSent As Integer
    
    On Error GoTo BlockError
    If BlockX = Empty Or (Date + Time - Started) * 24 > 1 Then Started = Date + Time: TotalSent = 0
    
    ta = SubSearch("To: " + OrigFrom, CnfFiles(8), 1)
    If ta <> "" Or CleanAddress(OrigFrom) = "" Then BlockMessage = "": Exit Function
    
    For i = 0 To 100
        If LCase(Blocked(i)) = LCase(OrigFrom) Then BlockMessage = "": Exit Function
    Next i
    BlockX = BlockX + 1
    If BlockX > 101 Then BlockX = 1
    Blocked(BlockX - 1) = OrigFrom
    
    If TotalSent > 2 Then BlockMessage = "": Exit Function
     
    If Cnf(1, 4) <> "True" Or Val(Cnf(1, 20)) = 0 Then
        Do
            MDst = Cnf(1, 5) + "\MAILOUT\" + MakeTag
        Loop Until Dir(MDst + ".*") = ""
        n = FreeFile
        Open MDst + ".Q0" For Output As n
        Print #n, "RELI_MAILOUT"
        Print #n, Date + Time
        Print #n,
        Print #n, "To: "; OrigFrom
        Print #n, "From: "; Cnf(1, 19)
        If Cnf(1, 3) = "True" And Cnf(1, 2) <> "" Then Print #n, "Reply-To: "; Cnf(1, 2)
        Print #n, "Subject: Your remailer message to "; Cnf(1, 0)
        Print #n,
        Close n: n = 0
        n = FreeFile
        Open MDst + ".Q1" For Output As n
    Else
        MDst = GetWork
        n = FreeFile
        Open MDst For Output As n
    End If
    Print #n, "This is an automatically generated reply to a message you sent to the "; Cnf(1, 0)
    Print #n, "remailer.  Your message was not remailed because you are blocked from sending"
    Print #n, "mail to this remailer.  In some cases a block may result from a misconfiguration"
    Print #n, "or a similarity between your headers and those of someone who has misused the"
    Print #n, "remailer.  If you believe this block to be in error, please contact the remailer"
    Print #n, "administrator."
    Print #n,
    If Cnf(1, 3) = "True" And Cnf(1, 2) <> "" Then
        Print #n, Cnf(1, 2)
    End If
    Close n: n = 0
    If Cnf(1, 4) = "True" And Val(Cnf(1, 20)) <> 0 Then
        ErrMsg = SendMiddle(MDst, OrigFrom, "Your remailer message to " + Cnf(1, 0))
        DelFile MDst
    End If
    TotalSent = TotalSent + 1
    BlockMessage = ""
Exit Function
BlockError:
    BlockMessage = LMsg(215)
    CloseFile n
End Function

Public Function PrepareConf() As String
    On Error GoTo ConfError
    Dst = GetWork
    n = FreeFile
    Open Dst For Output As n
    Print #n, "Remailer-Type: Reliable v"; Version
    Print #n, "Generated: "; DateLine(0)
    Print #n,
    Print #n, MakeString
    Print #n,
    Print #n,
    Print #n, "GENERAL"
    CfPrint n, "Middleman:", Cnf(1, 4)
    CfPrint n, "Maximum Message Size:", Cnf(1, 14) + " bytes"
    CfPrint n, "Addresses In Header Maximum:", Cnf(1, 16)
    CfPrint n, "Crosspost Maximum:", Cnf(1, 25)
    Select Case Val(Cnf(1, 24))
    Case 0
        a = "On all messages and posts; name and address"
    Case 1
        a = "On all messages and posts; name only"
    Case 2
        a = "On Anon-Post-To posts only; name and address"
    Case 3
        a = "On Anon-Post-To posts only; name only"
    Case 4
        a = "Never"
    Case Else
        a = "N/A"
    End Select
    CfPrint n, "From Header Allowed:", a
    If Cnf(1, 15) = "True" Then CfPrint n, "Messages Received Last Week:", Trim(Str(Int((WeekStats + 9) / 10) * 10))
    If Cnf(1, 3) = "True" And Cnf(1, 2) <> "" Then CfPrint n, "Admin Contact:", Cnf(1, 2)
    Print #n,
    Print #n,
    Print #n, "FEATURES"
    CfPrint n, "CPunk Messages Accepted (cpunk):", Cnf(2, 0)
    CfPrint n, "CPunk PGP Encryption Required (pgponly):", Cnf(2, 2)
    CfPrint n, "Latent-Time Supported (latent):", Cnf(2, 3)
    CfPrint n, "Encrypt-Key Supported (ek):", Cnf(2, 13)
    CfPrint n, "Encrypt-3DES and Encrypt-CAST Supported (ekx):", (Cnf(2, 13) = "True") And (Val(Cnf(1, 17)) <> 0)
    CfPrint n, "Encrypt-Subject Supported (esub):", ESUBSupport
    CfPrint n, "Test-To Supported (test):", True
    CfPrint n, "Inflate Maximum (inflt):", Cnf(2, 4) + "k"
    CfPrint n, "Rand-Hop Maximum (rhop):", Cnf(2, 10)
    CfPrint n, "Max-Size, Max-Count, Max-Date Supported (max):", True
    CfPrint n, "Extended Directive Features (ext):", True
    CfPrint n, "Chained Remailers Maximum (ext):", Cnf(2, 14)
    If Cnf(2, 5) = "True" Then
        a = "Transparent and Explicit (repgp)"
    Else
        If Cnf(2, 6) = "True" Then a = "Explicit Only (repgp2)" Else a = "None"
    End If
    CfPrint n, "RePGP Support:", a
    If Cnf(2, 8) = "True" Then
        a = "Transparent and Explicit (remix)"
    Else
        If Cnf(2, 9) = "True" Then a = "Explicit Only (remix2)" Else a = "None"
    End If
    CfPrint n, "Remix Support:", a
    If Cnf(2, 8) = "False" And Cnf(2, 9) = "True" Then
        CfPrint n, "High Load Remix2 Deferral:", Cnf(5, 2)
    End If
    CfPrint n, "Large Message Deferral:", (Cnf(5, 1) = "True") Or (Cnf(4, 10) = "True")
    CfPrint n, "Message Deferral Maximum:", Cnf(5, 3) + " minutes"
    CfPrint n, "Random CPunk Uptime% Minimum:", Cnf(2, 11)
    CfPrint n, "Random CPunk Latency Maximum:", Cnf(2, 12)
    CfPrint n, "Refresh Stats Time:", Cnf(7, 5)
    Print #n,
    Print #n,
    Print #n, "MIXMASTER"
    CfPrint n, "Mixmaster Messages Accepted (mix):", Cnf(3, 0)
    If Cnf(3, 0) <> "False" Then
        CfPrint n, "Directives Accepted in Mixmaster Headers (hybrid):", True
        CfPrint n, "Packet ID Log Enabled:", Cnf(3, 4)
    End If
    CfPrint n, "MINREL:", Cnf(3, 12)
    CfPrint n, "MAXLAT:", Cnf(3, 13)
    Print #n,
    Print #n,
    Print #n, "PROCESSING"
    If Val(Cnf(1, 17)) = 0 Then a = "PGP 2.6.x" Else a = "PGP 5.5.x/6.x"
    CfPrint n, "PGP Version: ", a
    CfPrint n, "Dummy Traffic Generation:", (Val(Cnf(5, 4)) > 0)
    CfPrint n, "Message Reordering (reord):", (LatentValue(Cnf(5, 6)) >= 3 / 60) And (LatentValue(Cnf(5, 6)) - LatentValue(Cnf(5, 5)) >= 3 / 60)
    CfPrint n, "Replay Cache:", (Val(Cnf(4, 15)) > 0)
    Print #n,
    Print #n,
    Print #n, "NEWS"
    CfPrint n, "Anon-Post-To Supported (post):", (Cnf(1, 21) = "True" And Cnf(6, 2) <> "")
    If (Cnf(1, 21) = "True" And Cnf(6, 2) <> "") Then
        If InStr(Cnf(6, 2), "@") <> 0 Then
            CfPrint n, "News Posting Route (mail2news):", Cnf(6, 2)
        Else
            CfPrint n, "News Posting Route:", "NNTP"
        End If
    End If
    Select Case Val(Cnf(1, 23))
    Case 0
        a = "Anon-Post-To posts containing a custom From header"
    Case 1
        a = "Anon-Post-To and mail2news posts containing a custom From header"
    Case 2
        a = "All Anon-Post-To posts"
    Case 3
        a = "All Anon-Post-To and mail2news posts"
    Case 4
        a = "None"
    Case Else
        a = "N/A"
    End Select
    CfPrint n, "News Signature Added To:", a
    Select Case Val(Cnf(1, 22))
    Case 0
        a = "ANON-POST-TO - BLOCKED NEWSGROUPS"
    Case 1
        a = "ANON-POST-TO - ALLOWED NEWSGROUPS"
    Case Else
        a = ""
    End Select
    Print #n,
    Print #n,
    If (Cnf(1, 21) = "True" And Cnf(6, 2) <> "" And a <> "") Then
        Print #n, a
        If CnfFiles(10) <> vbCrLf Then Print #n, CnfFiles(10) Else Print #n, "[List Empty]"; vbCrLf
        Print #n,
    End If
    Print #n, "STRIPPED HEADERS (Outgoing)"
    If CnfFiles(9) <> vbCrLf Then Print #n, CnfFiles(9) Else Print #n, "[List Empty]"; vbCrLf
    Print #n,
    Print #n, "SUPPORTED CPUNK (TYPE I) REMAILERS"
    'Every Remailer Key
    x = 0
    Do While RString(x) <> ""
        RemailerString RString(x), rname, raddress, roptions
        If rname = "" Or raddress = "" Then
            Print #n, "ERROR: Reading capability string"
        Else
            If InStr(roptions, " cpunk ") <> 0 And InStr(raddress, "@") <> 0 Then
                If InStr(roptions, "pgp") <> 0 Then
                    rkey = FindPGPKey(raddress, True)
                    If rkey = "" Then
                        Print #n, "ERROR: Unable to find key for "; rname
                    Else
                        Print #n, rkey
                    End If
                Else
                    Print #n, raddress; "  [PGP not supported]"
                End If
           End If
        End If
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
    If x = 0 Then Print #n, "[List Empty]"
    Print #n,
    Print #n,
    If (Cnf(2, 5) = "True" Or Cnf(2, 6) = "True") And LTrim(Replace(CnfFiles(4), vbCrLf, "")) <> "" Then
        Print #n, "NON-REPGP REMAILERS"
        Print #n, "[These remailers may not be used at the end of Encrypt-To chains.]"
        Print #n, CnfFiles(4)
        Print #n,
    End If
    If (((Cnf(2, 0) = "True") And ((Cnf(2, 8) = "True")) Or (Cnf(2, 9) = "True")) Or Cnf(3, 0) = "True") Then
        Print #n, "SUPPORTED MIXMASTER (TYPE II) REMAILERS"
        a = ""
        x = Type2(a)
        If x <> 0 Then
            Print #n, "ERROR: An error ocurred reading type2.lis"
        Else
            If a <> "" Then Print #n, a Else Print #n, "[List Empty]"; vbCrLf
        End If
        Print #n,
    End If
    Print #n, "RANDOM CPUNK REMAILERS (Active List)"
    Print #n, "[Stats Updated: "; RemStats(0, 0); "]"
    a = GetRandom(0, "", True, False, False, 0, 0, "")
    If a <> "" Then a = a + "," Else Print #n, "[List Empty]"
    Y = 1
    x = InStr(a, ",")
    While x <> 0
        r = Mid(a, Y, x - Y)
        If r <> "" Then
             raddress = "": rname = ""
             If InStr(r, "@") <> 0 Then
                 raddress = r
             Else
                 rname = r
             End If
             Remailer rname, raddress, 0, roptions, rlatent, rup
             Print #n, Left(rname + String(12, " "), 11); "   "; rlatent; "   "; rup; "%   "; raddress
        End If
        Y = x + 1
        x = InStr(Y, a, ",")
    Wend
    Print #n,
#If 0 Then
    Print #n,
    For i = 0 To 1
        If i = 0 Then Print #n, "ACTIVE CPUNK STATS" Else Print #n, "ACTIVE MIX STATS"
        If RemStats(i, 0) = "" Then
            Print #n, "[List Empty]"
        Else
            For j = 0 To MaxRemailers
                If RemStats(i, j) <> "" Then Print #n, RemStats(i, j) Else Exit For
            Next j
        End If
        Print #n,
        Print #n,
    Next i
#End If
    Print #n,
    Print #n, "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
    Print #n, "For the help file to this remailer, send a message with subject:"
    Print #n, "remailer-help"
    Print #n, "For the PGP and/or Mixmaster keys to this remailer, send a message with subject:"
    Print #n, "remailer-key"
    Close n: n = 0
    PrepareConf = Dst
Exit Function
ConfError:
    PrepareConf = ""
    CloseFile n
    DelFile Dst
End Function

Public Sub CfPrint(n, hdr, hval)
    Print #n, "    "; hdr;
    If Len(hval) + Len(hdr) + 3 > 70 Then
        Print #n, vbCrLf; "        "; hval
    Else
        Print #n, "   "; hval
        'Print #n, String(36 - Len(hdr), " "); hval
    End If
End Sub

Public Function MakeString(Optional OtherCap As String) As String
    Dim a As String
    
    a = "$remailer{" + Chr(34) + Trim(LCase(Cnf(1, 0))) + Chr(34) + "} = " + Chr(34) + "<" + Trim(Cnf(1, 1)) + ">"
    If Cnf(2, 0) = "True" Then a = a + " cpunk"
    If Cnf(3, 0) = "True" Then a = a + " mix hybrid"
    If Cnf(1, 4) = "True" Then a = a + " middle"
    a = a + " pgp"
    If Cnf(2, 2) = "True" And Cnf(2, 0) = "True" Then a = a + " pgponly"
    If Cnf(2, 3) = "True" Then a = a + " latent"
    If Cnf(2, 13) = "True" Then
        a = a + " ek"
        If Val(Cnf(1, 17)) <> 0 Then a = a + " ekx"
    End If
    If ESUBSupport Then a = a + " esub"
    a = a + " cut hash"
    If Cnf(1, 21) = "True" And Cnf(6, 2) <> "" Then a = a + " post"
    If Cnf(2, 5) = "True" Then
        a = a + " repgp"
    Else
        If Cnf(2, 6) = "True" Then a = a + " repgp2"
    End If
    If Cnf(2, 8) = "True" Then
        a = a + " remix"
    Else
        If Cnf(2, 9) = "True" Then a = a + " remix2"
    End If
    If (LatentValue(Cnf(5, 6)) >= 3 / 60) And (LatentValue(Cnf(5, 6)) - LatentValue(Cnf(5, 5)) >= 3 / 60) Then a = a + " reord"
    a = a + " ext"
    a = a + " max test"
    If Val(Cnf(2, 4)) > 0 Then a = a + " inflt" + Trim(Str(Int(Val(Cnf(2, 4)))))
    If Val(Cnf(2, 10)) > 0 Then a = a + " rhop" + Trim(Str(Int(Val(Cnf(2, 10)))))
    a = a + " klen" + Trim(Str(Int((Val(Cnf(1, 14)) / 1024) + 0.499)))
    If OtherCap <> "" Then a = a + " " + OtherCap
    a = a + Chr(34) + ";"
    MakeString = a
End Function

Public Function XCrypt(ByVal intext As String, ByVal Key As Double) As String
    Dim xkey As Long, outtext As String, mask As Byte, CMode As Byte
        
    If Left(intext, 3) = "@@@" Then
        CMode = 0
        intext = Mid(intext, 4)
    Else: CMode = 1
    End If
    If intext = "" Or Key = 0 Then XCrypt = "": Exit Function
    If CMode = 1 Then 'Encrypt
        'Calc Checksum
        intext = intext + Chr(XHash(Left(intext, 100)) Mod 255)
        xkey = (Int(Rnd(1) * 65535) + 65535) Mod 65535
    Else
        xkey = Val("&H" + Left(intext, 4))
        If xkey < 0 Then xkey = xkey + 65536
        intext = Mid(intext, 5)
    End If
    
    mask = (Key + xkey) Mod 255
    
    For i = 1 To Len(intext) Step Abs(CMode - 2)
        If CMode = 1 Then
            x = Asc(Mid(intext, i, 1))
        Else
            x = Val("&H" + Mid(intext, i, 2))
        End If
        c = x Xor mask
        If CMode = 1 Then
            outtext = outtext + Right("0" + Hex(c), 2)
        Else
            outtext = outtext + Chr(c)
        End If
        
        'rotate password
        Key = Key + Int(100 * Abs(Sin(Key)))
        idx = idx + 1
        
        If CMode = 0 Then x = c Else x = Asc(Mid(intext, i, 1))
        mask = ((Key + x * idx) + xkey) Mod 255
    Next i
    If CMode = 0 Then
        chksum = Asc(Right(outtext, 1))
        outtext = Left(outtext, Len(outtext) - 1)
        If XHash(Left(outtext, 100)) Mod 255 <> chksum Then outtext = ""
    Else
        outtext = "@@@" + Right("000" + Hex(xkey), 4) + outtext
    End If
    XCrypt = outtext
    intext = String(Len(intext), "@")
    outtext = String(Len(outtext), "@")
End Function

Public Function XHash(Password As String) As Long
    Dim n As Long, i As Integer
    For i = 1 To Len(Password)
        n = n + i * Asc(Mid(Password, i, 1))
    Next i
    Hash = n + Val(Right(Password, 4))
End Function

Public Function CleanAddress(ByVal Addr) As String
    Dim d(1) As String * 1, d2(1) As String * 1, x As Integer, Y As Integer
    
    'Remove (Name) and "Name"
    d(0) = "(": d2(0) = ")"
    d(1) = Chr(34): d2(1) = Chr(34)
    For i = 0 To 1
        x = InStr(Addr, d(i))
        While x <> 0
            Y = InStr(x + 1, Addr, d2(i))
            If Y = 0 And i = 0 Then Y = InStr(x, Addr, " ")
            If Y = 0 Then Addr = Left(Addr, x - 1) Else Addr = Left(Addr, x - 1) + Mid(Addr, Y + 1)
            x = InStr(Addr, d(i))
        Wend
    Next i
    
    x = InStr(Addr, "@")
    If x = 0 Then CleanAddress = "": Exit Function
    For i = x - 1 To 1 Step -1
        a = Mid(Addr, i, 1)
        If a = " " Or a = "<" Or a = "," Or a = ")" Then i = i + 1: Exit For
    Next i
    If i = 0 Then Let i = 1
    Addr = Extract(Extract(Extract(Extract(Mid(Addr, i), " "), ","), ">"), ")")
    x = InStr(Addr, "@")
    If InStr(x, Addr, ".") = 0 Then Addr = ""
    If InStr(Addr, ";") <> 0 Then Addr = ""
    CleanAddress = Addr
End Function

