// PSESUB32.cpp : Defines the entry point for the DLL application.
/****************************************************************************
  This file is part of the PSESUB32 DLL
  Copyright (C) 1999  Potato Software

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (License.txt) for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

/*	Compile notes:  (VC6++)
	If you're wise you will disable precompiled headers in Project|Settings
	for at least each of the C files, or for the entire project, (both
	Settings For: Win32	Debug and Win32 Release).

	I get 12 warnings from idea.c involving MUL:
		C4244: '=' : conversion from 'unsigned long ' to 'unsigned short ', possible loss of data

	rp  30 Aug 99
*/



#include "stdafx.h"
#include "PSESUB32.h"
extern "C" {
	#include "idea.h"
	#include "md5.h"
}
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/timeb.h>

//Set DLL version here 255 chars max
char *PSESUB32VersionString = "1.0.0";

// Entry
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

/*	Exported Encrypt Subject Function
	Encrypts subject with key (Hashes subject and hashes key and encrypts)
	This code is based on code from the Freedom Remailer and modified for use in 
	PSESUB32.  The original encrypt_sub() function was borrowed from
	Andy Dustman's Encrypt-Subject patch to Matt Ghio's remailer distribution.
	Other changes and code were: Copyright (C) 1997-1998  Johannes Kroeger 
	(hanne@squirrel.owl.de)  */
int PSESUB32_API __stdcall psEncryptSubject(const unsigned char *subject, const unsigned char *key, unsigned char *encsubject)
{
	struct _timeb timebuffer;
	struct MD5Context subjkeyDigest, subjectDigest;
	struct IdeaCfbContext subjcontext;
	unsigned char subjIDEAkey[16], subjPT[16];
	unsigned char subjCT[24];	// Includes IV.
	unsigned char hexrand[9];

	// Check for valid parameters
	if (strlen((const char *) subject) * strlen((const char *) key) == 0) return -1;

	// Hash key
	MD5Init (&subjkeyDigest);
	MD5Update (&subjkeyDigest, key, strlen ((const char *) key));
	MD5Final (subjIDEAkey, &subjkeyDigest);

	// Hash Subject
	MD5Init (&subjectDigest);
	MD5Update (&subjectDigest, subject, strlen ((const char *) subject));
	MD5Final (subjPT, &subjectDigest);

	//Reset RNG
	_ftime( &timebuffer );
 	srand((unsigned)time( NULL )+timebuffer.millitm );
	// Encrypt
	ideaCfbInit (&subjcontext, subjIDEAkey);
	for (int i = 0; i < 8; i++)	hexrand[i] = rand();
	memcpy (subjCT, hexrand, 8);
	memcpy (subjCT + 8, subjPT, 16);
	ideaCfbEncrypt (&subjcontext, subjCT, subjCT, 24);
	ideaCfbDestroy (&subjcontext);
	printbytes(subjCT, encsubject, 24);
	return 0;
}

/*	Exported Test Subject Function
	Tests for match between subject and encsubject
	Returns 0 if matched
	This code is based on the TestCr32 code by Steve "I Hate C, and it
	Shows" Heller <felixnon@wolfenet.com>, which was based on the Freedom
	remailer.*/
int PSESUB32_API __stdcall psTestSubject(const unsigned char *encsubject,
							   const unsigned char *subject,
							   const unsigned char *key)
{
	struct MD5Context subjkeyDigest, subjectDigest ;
	struct IdeaCfbContext subjcontext;
	unsigned char subjIDEAkey[16], subjPT[16] ;
	unsigned char subjPT2[24], subjHx[33], subjHx2[33], subjCT[24] ; /* includes IV */

	// Check for valid parameters
	if ((strlen((const char *)subject) * strlen((const char *)key) == 0) 
		|| (strlen((char *)encsubject) != 48)) 
		return -1;

	// Hash the key
	MD5Init(&subjkeyDigest);
	MD5Update(&subjkeyDigest,key, strlen((const char *)key));
	MD5Final(subjIDEAkey, &subjkeyDigest);

	// Hash the subject
	MD5Init(&subjectDigest);
	MD5Update(&subjectDigest, subject, strlen((const char *)subject));
	MD5Final(subjPT, &subjectDigest);

	// Get the hash of the subject in string of hex digits
	printbytes(subjPT, subjHx, 16);

	// Translate text hex-string back to bytes
	scanbytes((const char *)encsubject, subjCT, 24);

	// Decrypt
	ideaCfbInit(&subjcontext, subjIDEAkey);
	ideaCfbDecrypt(&subjcontext, subjCT, subjPT2, 24);
	ideaCfbDestroy(&subjcontext);

	// Get the hash the decrypted subject in string of hex digits
	printbytes(subjPT2 + 8, subjHx2, 16);

	return memcmp(subjHx, subjHx2, 33);
}

/*	Exported MD5 Hash Function
	Not required for encrypt-subject functions; provided for general use */
int PSESUB32_API __stdcall psMD5Hash(const unsigned char *databuffer, 
						   unsigned char *hash)
{
	struct MD5Context databufferDigest;
	unsigned char dataPT[16];

	MD5Init(&databufferDigest);
	MD5Update(&databufferDigest, databuffer, strlen((const char *)databuffer));
	MD5Final(dataPT, &databufferDigest);

	printbytes(dataPT, hash, 16);

	return 0;
}

/*	Convert bytes to hex characters  */
void printbytes(const unsigned char* bytes, unsigned char* hexstring,
				const int count)
{
  int i;
  char tempstring[2];

  strcpy((char *)hexstring, "");

  for (i = 0; i < count; i++) {
    sprintf(tempstring, "%2.2hx", *(bytes + i));
    strcat ((char *)hexstring, tempstring);
  }
  return;
}

/*	Convert hex characters to bytes  */
void scanbytes(const char* buf, unsigned char* bytes, const int count)
{
  int i;
  char s[]="0xxx" ;

  for (i = 0; i < count; i++) {
    s[2] = *(buf + 2*i) ;
    s[3] = *(buf + 2*i + 1) ;
    *(bytes + i) = (unsigned char) strtol(s, NULL, 16);
  }
  return;
}

/*	Exported Version Function
	Tells user the DLL's version number/string  */
int PSESUB32_API __stdcall psEsub32DLLVersion(char *versionstring)
{
	strcpy (versionstring, PSESUB32VersionString);
	return 0;
}

