Attribute VB_Name = "Main"
'   IMPORTANT - READ THIS LICENSE
'
'   Reliable is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License Version 2.
'
'   Please see LICENSE.TXT for the terms and conditions of the license.
'
'   Reliable, Copyright 1999 Potato Software
'
'
'
' Recommended compiler: Microsoft Visual Basic 6.0 SP3 (v5.0SP3 ok)
' Reliable requires a licensed copy of Catalyst SocketTools 2.1 or later (3.1)
' <http://www.catalyst.com/>; SPGP.DLL v2.2.2 or later and MDVB01.DLL, copyright 1999
' S.R. Heller; and Netmaster's FastNet ActiveX controls
' <http://www.netmastersllc.com/home/>



Public Const IDE = False          'Set to False to compile
Public Const Version = "1.0.5"   'Add your version designator here
Public Const LangVersion = "L19"
Public Lang As String
Public ESUBSupport As Boolean

Public Const MaxConfItem = 30
Public Const MaxRemailers = 200

Public ProgDir As String, BrandNew As Boolean
Public LMsg() As String
Public Cnf(8, MaxConfItem) As String
Public CnfFiles(12) As String

Public Const MaxDataItem = 80
Public RData(MaxDataItem) As String
Public Sess(8, 1) As String
Public KeepDate(30) As Date
Public SessionLast As Integer
Public SessionRunning As Integer
Public SessionStart As Integer
Public TimerCheck As Date
Public AlarmReset As Byte, AlarmLast As Date

Public RSS As String
Public LeftWin As Double, RightWin As Double
Public gmtoffset As Double

Public ValidCpunk As Boolean, ValidMix As Boolean

Public RString(MaxRemailers) As String
Public RemStats(1, MaxRemailers) As String
Public StatsMode As String

'PGP 2.6.x  PubKeys holds all PGP UserIDs
'PGP 5.x    PubKeys holds Active List (preferred encryption keys)
Public PubKeys() As String, PubKeyX As Integer
Public pubkeyfile As String, PubKeyDate As Date
Public Const MaxPubKeys = 1000
Public CheckDupeFlag As Boolean

Public MailFile As String, DOSDump As String, DOSTag As String, DOSFocus As Integer
Public HighLoad As Boolean

Public FingerUser As String, PageText As String, FingerConnecting As Boolean

Public Type FilesType
    Filename As String
    FileDate As Date
End Type

Public Type MgrType
    Status As String
    Load As Integer
    LastRun As Date
    Counter As Double
    Errors As Double
    Warnings As Double
End Type

Public Mgr(7) As MgrType

Public Function GetWork() As String
    Do
        GetWork = Cnf(1, 7) + "\" + Left(MakeTag, 6) + ".rel"
    Loop Until Dir(GetWork) = ""
End Function

Public Sub WriteData()
    For i = 0 To 30
        If i < 18 Then
            RData(11 + i) = KeepDate(i)
        Else
            RData(33 + i) = KeepDate(i)
        End If
    Next i
    
    n = FreeFile
    Open ProgDir + "\Reliable.dat" For Output As n
    Print #n, "RELIABLE_DATA"
    Print #n,
    Print #n, "Reliable Data File"
    Print #n, "DO NOT EDIT"
    Print #n, "This file is not designed to be edited by the remailer operator."
    Print #n, "Doing so may cause serious problems."
    Print #n,
    Print #n,
    Print #n, "---Updated"
    Print #n, Format(Date, "dd-mmm-yy"); " "; Format(Time, "long time")
    Print #n,
    Print #n, "---Version"
    Print #n, Version
    Print #n,
    
    'RData
    RData(43) = XCrypt(RData(43), LeftWin)
    RData(44) = XCrypt(RData(44), LeftWin)
    WriteArray n, RData(), "RData", MaxDataItem, -1, False
    RData(43) = XCrypt(RData(43), LeftWin)
    RData(44) = XCrypt(RData(44), LeftWin)
    Print #n,
    
    If PubKeyX <> 0 And pubkeyfile <> "" And Val(Cnf(1, 17)) = 0 Then
        Print #n, "---Keys"
        Print #n, pubkeyfile
        Write #n, PubKeyDate
        Print #n, PubKeyX
        Print #n,
        For i = 0 To PubKeyX - 1
            Print #n, PubKeys(i)
        Next i
        Print #n,
    End If
    
    Print #n,
    Close n: n = 0
Exit Sub
WriteError:
    MsgBox LMsg(102) + vbCr + ProgDir + "\Reliable.dat" + vbCr + vbCr + Error, vbCritical, LMsg(103)
    CloseFile n
End Sub

Public Sub ReadData()
    Dim Now As Date
    
    On Error GoTo ReadError
    If SDir(ProgDir + "\Reliable.dat") = "" Then Exit Sub
    pubkeyfile = "": PubKeyX = 0
    BrandNew = False
    n = FreeFile
    Open ProgDir + "\Reliable.dat" For Input As n
    Line Input #n, a
    If a <> "RELIABLE_DATA" Then Close n: n = 0: Exit Sub
    While Not EOF(n)
        Line Input #n, a
        Select Case a
        Case "---BrandNew"
            BrandNew = True
        Case "---Version"
            DataVersion = a
        Case "---Cnf"   '1.0.g and prior
            Line Input #n, a
            x = Val(a)
            For j = 0 To x
                If j <= MaxDataItem Then Line Input #n, RData(j)
            Next j
            DelFile ProgDir + "\Stats.dat"
        Case "-=-RData"
            ReadArray n, RData(), MaxDataItem, -1
        Case "---Keys"
            If Val(Cnf(1, 17)) = 0 Then
                Line Input #n, pubkeyfile
                Input #n, PubKeyDate
                Input #n, PubKeyX
                Line Input #n, a
                ReDim PubKeys(PubKeyX)
                For i = 0 To PubKeyX - 1
                    Line Input #n, PubKeys(i)
                    If PubKeys(i) = "" Then PubKeyX = 0: Exit For
                Next i
            End If
        End Select
    Wend
    Close n: n = 0
    
    RData(43) = XCrypt(RData(43), LeftWin)
    RData(44) = XCrypt(RData(44), LeftWin)
    On Error Resume Next
    Now = Date + Time
    For i = 0 To 30
        If i < 18 Then
            KeepDate(i) = RData(11 + i)
        Else
            KeepDate(i) = RData(33 + i)
        End If
        If KeepDate(i) > Now Then KeepDate(i) = 0
    Next i
Exit Sub
ReadError:
    MsgBox LMsg(104) + vbCr + ProgDir + "\Reliable.dat" + vbCr + vbCr + Error, vbCritical, LMsg(103)
    CloseFile n
End Sub

Public Function WriteConfig() As Boolean
    On Error Resume Next
    If SDir(ProgDir + "\Config.dat") <> "" Then
        FileCopy ProgDir + "\Config.dat", ProgDir + "\Config.bak"
    End If
    On Error GoTo WriteError
    n = FreeFile
    Open ProgDir + "\Config.dat" For Output As n
    Print #n, "RELIABLE_CONFIG"
    Print #n,
    Print #n, "Reliable Configuration File"
    Print #n, "DO NOT EDIT"
    Print #n, "This file is not designed to be edited by the remailer operator."
    Print #n, "Doing so may cause serious problems."
    Print #n,
    Print #n,
    Print #n, "---Updated"
    Print #n, Format(Date, "dd-mmm-yy"); " "; Format(Time, "long time")
    Print #n,
    Print #n, "---Version"
    Print #n, Version
    Print #n,
    
    Cnf(4, 2) = XCrypt(Cnf(4, 2), LeftWin)
    Cnf(4, 4) = XCrypt(Cnf(4, 4), LeftWin)
    Cnf(6, 4) = XCrypt(Cnf(6, 4), LeftWin)
    Cnf(6, 5) = XCrypt(Cnf(6, 5), LeftWin)
    Cnf(8, 4) = XCrypt(Cnf(8, 4), LeftWin)
    Cnf(8, 2) = XCrypt(Cnf(8, 2), LeftWin)
    
    WriteArray n, Cnf(), "Cnf", 8, MaxConfItem, False
    
    Cnf(4, 2) = XCrypt(Cnf(4, 2), LeftWin)
    Cnf(4, 4) = XCrypt(Cnf(4, 4), LeftWin)
    Cnf(6, 4) = XCrypt(Cnf(6, 4), LeftWin)
    Cnf(6, 5) = XCrypt(Cnf(6, 5), LeftWin)
    Cnf(8, 4) = XCrypt(Cnf(8, 4), LeftWin)
    Cnf(8, 2) = XCrypt(Cnf(8, 2), LeftWin)
    
    Print #n,
    Close n: n = 0
    WriteConfig = True
Exit Function
WriteError:
    MsgBox LMsg(8) + vbCr + ProgDir + "\Config.dat" + vbCr + vbCr + Error, vbCritical, LMsg(7)
    WriteConfig = False
    CloseFile n
End Function

Public Function ReadConfig() As Boolean
    On Error GoTo ReadError
    If SDir(ProgDir + "\Config.dat") = "" Then msg = 6: GoTo ReadError
    n = FreeFile
    Open ProgDir + "\Config.dat" For Input As n
    Line Input #n, a
    If a <> "RELIABLE_CONFIG" Then msg = 9: GoTo ReadError
    While Not EOF(n)
        Line Input #n, a
        Select Case a
        Case "---Version"
            Line Input #n, a
            ConfigVersion = a
        Case "-=-Cnf"
            ReadArray n, Cnf(), 8, MaxConfItem
        Case "---Cnf" 'Version 1.0.g and prior
            Line Input #n, a
            x = Val(a)
            For i = 1 To 8
                For j = 0 To x
                    If j <= MaxConfItem Then Line Input #n, Cnf(i, j)
            Next j, i
            Cnf(7, 0) = "http://www.drule.org/remailer/rlist2.html" + vbCrLf + _
                        "http://poohcentral.serversystems.net/remailer/cpunkv2.html" + vbCrLf + _
                        "http://anon.efga.org:8080/Remailers/TypeIList" + vbCrLf + _
                        "http://www.publius.net/rlist" + vbCrLf + _
                        "http://poohcentral.serversystems.net/remailer/cpunk.html" + vbCrLf + _
                        "rlist@anon.efga.org" + vbCrLf + _
                        "rlist@publius.net" + vbCrLf + _
                        "rlist@ anon.lcs.mit.edu" + vbCrLf
            Cnf(7, 1) = "http://www.drule.org/remailer/pgpkeys.asc" + vbCrLf + _
                        "http://www.drule.org/remailer/dhkeys.asc" + vbCrLf + _
                        "http://anon.efga.org:8080/Remailers/pubring.asc" + vbCrLf + _
                        "remailer-keys@anon.lcs.mit.edu" + vbCrLf
            Cnf(7, 2) = "http://www.drule.org/remailer/mlist2.html" + vbCrLf + _
                        "http://anon.efga.org:8080/Remailers/TypeIIList" + vbCrLf + _
                        "http://www.replay.com/remailer/finger.txt" + vbCrLf + _
                        "mlist@anon.lcs.mit.edu" + vbCrLf + _
                        "mlist@anon.efga.org" + vbCrLf
            Cnf(7, 3) = "http://www.drule.org/remailer/type2.lis ; http://www.drule.org/remailer/pubring.mix" + vbCrLf + _
                        "http://anon.efga.org:8080/Remailers/type2.list ; http://anon.efga.org:8080/Remailers/pubring.mix" + vbCrLf + _
                        "type2-list@anon.lcs.mit.edu ; pubring-mix@anon.lcs.mit.edu" + vbCrLf + _
                        "http://www.privacy.nb.ca/remailer/type2.list ; http://www.privacy.nb.ca/remailer/pubring.mix" + vbCrLf + _
                        "http://www.publius.net/type2.list ; http://www.publius.net/pubring.mix" + vbCrLf
            Cnf(7, 4) = ""
            Cnf(7, 5) = Trim(Str(Int(SVal(Cnf(7, 5))))) + ":00"
            For i = 29 To 31
                RData(i) = ""
            Next i
            'Version Adjustments
            'Adjust 1.0.c and prior for MD5 Hash
            If Val(ConfigVersion) < 1 Or ConfigVersion = "1.0.a" Or ConfigVersion = "1.0.b" Or ConfigVersion = "1.0.c" Then Cnf(4, 15) = "0"
            'Adjust 1.0.d and prior for RePGP Exclusion
            If Val(ConfigVersion) < 1 Or ConfigVersion = "1.0.a" Or ConfigVersion = "1.0.b" Or ConfigVersion = "1.0.c" Or ConfigVersion = "1.0.d" Then DelFile ProgDir + "\config4.dat"
            'Adjust 1.0.f and prior for Mixmaster and MD5
            If Val(ConfigVersion) < 1 Or ConfigVersion = "1.0.a" Or ConfigVersion = "1.0.b" Or ConfigVersion = "1.0.c" Or ConfigVersion = "1.0.d" Or ConfigVersion = "1.0.e" Then
                Cnf(3, 6) = "168"
                Cnf(3, 15) = ""
                DelFile ProgDir + "\md5sum.exe"
            End If
            'Adjust 1.0.g and prior for News Crosspost maximum
            If Val(ConfigVersion) < 1 Or ConfigVersion = "1.0.a" Or ConfigVersion = "1.0.b" Or ConfigVersion = "1.0.c" Or ConfigVersion = "1.0.d" Or ConfigVersion = "1.0.e" Or ConfigVersion = "1.0.f" Then
                Cnf(1, 25) = "10"
            End If
        End Select
    Wend
    Close n: n = 0

    'Adjust 1.0.1 and prior for Random Exclusion
    If Left(ConfigVersion, 3) = "1.0" And Val(Mid(ConfigVersion, 5, 1)) < 2 Then
        DelFile ProgDir + "\config3.dat"
    End If
    'Adjust 1.0.3 and prior for preferred alg and network timeout
    If Val(ConfigVersion) < 1 Or Val(Mid(ConfigVersion, 5, 1)) < 4 Then
        Cnf(1, 26) = "1"
        Cnf(1, 27) = "60"
    End If
    'Adjust 1.0.4 and prior for Message-ID Domain
    If Val(ConfigVersion) < 1 Or Val(Mid(ConfigVersion, 5, 1)) < 5 Then
        Cnf(6, 6) = "anonymous.poster"
    End If
    
    'Permanent section
    Cnf(4, 2) = XCrypt(Cnf(4, 2), LeftWin)
    Cnf(4, 4) = XCrypt(Cnf(4, 4), LeftWin)
    Cnf(6, 4) = XCrypt(Cnf(6, 4), LeftWin)
    Cnf(6, 5) = XCrypt(Cnf(6, 5), LeftWin)
    Cnf(8, 4) = XCrypt(Cnf(8, 4), LeftWin)
    Cnf(8, 2) = XCrypt(Cnf(8, 2), LeftWin)
    
    ReadConfig = True
Exit Function
ReadError:
    MsgBox LMsg(msg) + vbCr + ProgDir + "\Config.dat" + vbCr + vbCr + Error, vbCritical, LMsg(5)
    ReadConfig = False
    CloseFile n
End Function

Public Sub ReadFiles(Job As Byte)
    On Error GoTo ReadError
    
    If SDir(ProgDir + "\config2.dat") <> "" Then
        Erase RString
        n = FreeFile
        Open ProgDir + "\config2" + ".dat" For Input As n
        x = 0
        While Not EOF(n) And x <= MaxRemailers
            Line Input #n, a
            If Left(Trim(a), 9) = "$remailer" Then RString(x) = Trim(a): x = x + 1
        Wend
        Close n: n = 0
    End If
    
    For i = 2 To 12
        Select Case i
        Case 2
            'remcaps NOP
        Case Else
            fn = ProgDir + "\config" + Trim(Str(i)) + ".dat"
            If SDir(fn) <> "" Then
                n = FreeFile
                Open fn For Input As n
                x = LOF(n): If x > 31000 Then x = 30997
                CnfFiles(i) = Input(x, n)
                If i > 4 And i < 11 And i <> 9 Then CnfFiles(i) = LCase(CnfFiles(i))
                Close n: n = 0
                If Right(CnfFiles(i), 2) <> vbCrLf Then CnfFiles(i) = CnfFiles(i) + vbCrLf
            End If
        End Select
    Next i

    If Job = 0 And SDir(ProgDir + "\stats.dat") <> "" Then
        Erase RemStats
        n = FreeFile: j = -1
        Open ProgDir + "\stats.dat" For Input As n
        While Not EOF(n)
            Line Input #n, a
            Sess(5, 1) = Sess(5, 1) + a + vbCrLf
            If j <> -1 And a <> "" And x <= MaxRemailers Then
                RemStats(j, x) = a
                x = x + 1
            End If
            If a = "Cypherpunk Stats" Then j = 0: x = 0
            If a = "Mixmaster Stats" Then j = 1: x = 0
            If a = "" Then j = -1
        Wend
        Close n: n = 0
        SessUp (5)
    End If
Exit Sub
ReadError:
    Sess(0, 0) = Sess(0, 0) + Format(Time, "short time") + " " + LMsg(20) + vbCrLf + "     " + Error + vbCrLf
    SessUp (0)
    CloseFile n
End Sub

Public Function CheckConfig() As String
    Dim ValidPaths As Boolean, ValidMix As Boolean, ValidMakeStats As Boolean
    Dim CPunkNeedsMix As Boolean, ValidPGPRing As Boolean
    Dim ValidName As Boolean
        
    On Error GoTo ErrorCheck
    frmMain.MousePointer = 11
    ValidPaths = True: x = 0
    For i = 5 To 7
        Cnf(1, i) = NoSlash(Trim(Cnf(1, i)))
        If Cnf(1, i) = "" Then
            ValidPaths = False
        Else
            If Not CreateDir(Cnf(1, i)) Then ValidPaths = False
        End If
    Next i
    If ValidPaths Then
        If Not CreateDir(Cnf(1, 5) + "\MAILIN") Then ValidPaths = False
        If Not CreateDir(Cnf(1, 5) + "\MAILOUT") Then ValidPaths = False
        If Not CreateDir(Cnf(1, 5) + "\MAILDFR") Then ValidPaths = False
        If Not CreateDir(Cnf(1, 5) + "\MAILPROB") Then ValidPaths = False
        If Not CreateDir(Cnf(1, 5) + "\Trash") Then ValidPaths = False
        If Not CreateDir(Cnf(1, 5) + "\NNTP") Then ValidPaths = False
        If Not CreateDir(Cnf(1, 5) + "\Stats") Then ValidPaths = False
        If LCase(GetShortName(Cnf(1, 5))) <> LCase(Cnf(1, 5)) Then msg = msg + LMsg(266) + vbCrLf: ValidPaths = False
        If LCase(GetShortName(Cnf(1, 7))) <> LCase(Cnf(1, 7)) Then msg = msg + LMsg(267) + vbCrLf: ValidPaths = False
    End If

    If Not ValidPaths Then msg = msg + LMsg(14) + vbCrLf

    ValidName = Cnf(1, 0) <> "" And InStr(Cnf(1, 0), " ") = 0 And Len(Cnf(1, 0)) < 13 And Cnf(1, 1) <> "" And Cnf(1, 1) = CleanAddress(Cnf(1, 1)) And CleanAddress(Cnf(1, 19)) <> ""
    If Not ValidName Then msg = msg + LMsg(60) + vbCrLf
    Cnf(6, 3) = CleanAddress(Cnf(6, 3))

    For i = 8 To 11
        Cnf(1, i) = Left(Cnf(1, i), 70)
    Next i
    
    CPunkNeedsMix = ((Cnf(2, 0) = "True") And ((Cnf(2, 8) = "True")) Or (Cnf(2, 9) = "True")) Or (Cnf(8, 10) = "True")
        
    'ValidMix ?
    ValidMix = True
    If Cnf(3, 0) = "True" Or CPunkNeedsMix Then
        'Environment
        Cnf(3, 2) = NoSlash(Environ("mixpath"))
        If Cnf(3, 2) = "" Then Cnf(3, 2) = Cnf(3, 1)
        If Cnf(3, 1) <> "" And Cnf(3, 2) <> "" Then
            Cnf(3, 1) = NoSlash(Cnf(3, 1))
            Cnf(3, 2) = NoSlash(Cnf(3, 2))
            If Not CreateDir(Cnf(3, 1)) Or Not CreateDir(Cnf(3, 2)) Then
                ValidMix = False
            Else
                If SDir(Cnf(3, 1) + "\mixmaste.exe") = "" Then ValidMix = False
                
                If Cnf(3, 9) = "" Then Cnf(3, 9) = "type2.lis"
                If Cnf(3, 10) = "" Then Cnf(3, 10) = "pubring.mix"
                If Cnf(3, 14) = "" Then Cnf(3, 14) = "secring.mix"
                If Cnf(3, 11) = "" Then Cnf(3, 11) = "mixmaste.htm"
                'type2.lis
                If InStr(Cnf(3, 9), "\") = 0 Then
                    fn = Cnf(3, 2) + "\" + Cnf(3, 9)
                Else
                    fn = Cnf(3, 9)
                End If
                If SDir(fn) = "" Then ValidMix = False
                
                'pubring.mix
                If InStr(Cnf(3, 10), "\") = 0 Then
                    fn = Cnf(3, 2) + "\" + Cnf(3, 10)
                Else
                    fn = Cnf(3, 10)
                End If
        
                If SDir(fn) = "" Then ValidMix = False
                
                'secring.mix
                If InStr(Cnf(3, 14), "\") = 0 Then
                    fn = Cnf(3, 2) + "\" + Cnf(3, 14)
                Else
                    fn = Cnf(3, 14)
                End If
                
                If SDir(fn) = "" And Cnf(3, 0) = "True" Then ValidMix = False
            
            End If
        Else
            ValidMix = False
        End If
        If ValidMix = False Then
            msg = msg + LMsg(11) + vbCrLf
        Else
            If SDir(Cnf(3, 2) + "\mixrand.bin") = "" Then
                ReliShell "mixmaste -X", vbNormalFocus, "NUL", "", Cnf(3, 1) + "\"
                If SDir(Cnf(3, 2) + "\mixrand.bin") = "" Then msg = msg + LMsg(151) + vbCrLf: ValidMix = False
            End If
            a = CheckMixRing
            If a <> "" Then msg = msg + a: ValidMix = False
        End If
    End If
    
   'PGP
    ValidPGPRing = True
    If Val(Cnf(1, 17)) = 0 Then
        'PGP 2.6.x
        pgppath = NoSlash(Environ("PGPPATH"))
        If pgppath = "" Then
            msg = msg + LMsg(168) + vbCrLf
            ValidPGPRing = False
        Else
            If SDir(pgppath + "\config.txt") = "" Then
                msg = msg + LMsg(169) + ": " + pgppath + "\config.txt" + vbCrLf
                ValidPGPRing = False
            Else
                a = PGPConfig(pgppath)
                If a <> "" Then msg = msg + a: ValidPGPRing = False
            End If
            pth = Trim(Environ("PATH"))
            If InStr(1, pth + ";", pgppath + ";", vbTextCompare) = 0 And InStr(1, pth + ";", pgppath + "\;", vbTextCompare) = 0 Then
                msg = msg + LMsg(356) + vbCrLf
                ValidPGPRing = False
            Else
                a = CheckPGPRing
                If a <> "" Then msg = msg + a: ValidPGPRing = False
            End If
        End If
    Else
        a = CheckPGPRing
        If a <> "" Then msg = msg + a: ValidPGPRing = False
    End If
    
    'Set PGP menus
    pgp2 = (Val(Cnf(1, 17)) = 0)
    frmMain!mnuCopyKey(0).Visible = pgp2
    frmMain!mnuCopyKey(1).Visible = pgp2
    frmMain!mnuCertKey.Visible = pgp2
    frmMain!mnuPGPClipboard.Visible = pgp2
    frmMain!mnuPGPFile.Visible = pgp2
    frmMain!mnuGenerate(0).Visible = pgp2
    frmMain!sepToolsPGP.Visible = pgp2
        
    'Check Random Exclusion and RePGP
    For i = 3 To 4
        If Right(CnfFiles(i), 2) <> vbCrLf Then CnfFiles(i) = CnfFiles(i) + vbCrLf
        Y = 1
        x = InStr(CnfFiles(i), vbCrLf)
        While x <> 0
            r = Trim(Mid(CnfFiles(i), Y, x - Y))
            If r <> "" Then
                If InStr(r, "@") = 0 Or InStr(r, " ") <> 0 Then rname = r Else raddress = r
                Remailer rname, raddress, 0, roptions, rlatent, rup
                If rname = "" Then msg = msg + LMsg(148 + (94 * (i - 3))) + ":" + vbCrLf + "      " + r + vbCrLf
                If (InStr(r, "@") = 0 Or InStr(r, " ") <> 0) And rname <> "" Then
                    CnfFiles(i) = Left(CnfFiles(i), Y - 1) + raddress + Mid(CnfFiles(i), x)
                    x = InStr(Y, CnfFiles(i), vbCrLf)
                    n = FreeFile
                    Open ProgDir + "\config" + Trim(Str(i)) + ".DAT" For Output As n
                    Print #n, CnfFiles(i);
                    Close n: n = 0
                End If
            End If
            Y = x + 2
            x = InStr(Y, CnfFiles(i), vbCrLf)
        Wend
    Next i
    
    'MakeStats Check
    If Val(Cnf(8, 7)) < 2 Then Cnf(8, 7) = "2"
    If CleanAddress(Cnf(8, 8)) = "" Then Cnf(8, 8) = ""
    ValidMakeStats = True
    If Cnf(8, 10) = "True" And Not ValidMix Then ValidMakeStats = False
    If Cnf(8, 9) <> "True" And Cnf(8, 10) <> "True" And Cnf(8, 11) <> "True" Then ValidMakeStats = False
    
    'FTP Stats Check
    Cnf(8, 5) = Replace(Cnf(8, 5), "\", "/")
    If Val(Cnf(8, 6)) < 5 Then Cnf(8, 6) = "5" 'Min Time Between
    ValidFTP = False
    For lx = 15 To 24
        If Cnf(8, lx) <> "" Then ValidFTP = True
    Next lx
    If Cnf(8, 3) = "" Or Cnf(8, 4) = "" Or Cnf(8, 2) = "" Then ValidFTP = False
    
    'News Route Check
    ValidNews = Cnf(1, 21) = "True"
    If ValidNews Then
        If InStr(Cnf(6, 2), "@") = 0 Then
            If InStr(Cnf(6, 2), ".") = 0 Or InStr(Cnf(6, 2), " ") <> 0 Then ValidNews = False
        Else
            If CleanAddress(Cnf(6, 2)) = "" Then ValidNews = False
        End If
        If Not ValidNews Then msg = LMsg(341) + vbCrLf
    End If
    
    'Network timeout
    If SVal(Cnf(1, 27)) < 1 Then Cnf(1, 27) = "60" Else Cnf(1, 27) = Trim(Str(Int(SVal(Cnf(1, 27)))))
    
    'Process
    frmMain!chkSession(2).Enabled = (msg = "")
    
    'Retrieve
    frmMain!chkSession(1).Enabled = (Cnf(4, 2) <> "" And Cnf(4, 3) <> "" And Cnf(4, 4) <> "" And ValidPaths)

    'Send
    frmMain!chkSession(3).Enabled = ((Cnf(6, 1) <> "") And ValidPaths And ValidName)
    
    'NNTP
    frmMain!chkSession(4).Enabled = ValidPaths And ValidNews And ValidName And (InStr(Cnf(6, 2), "@") = 0)
    
    'Down Stats
    frmMain!chkSession(5).Enabled = (Cnf(7, 0) <> "" Or Cnf(7, 2) <> "")
    If LatentValue(Cnf(7, 5)) < 0.25 Then Cnf(7, 5) = "0:15" 'Refresh Stats Time
    
    'Make Stats
    frmMain!chkSession(6).Enabled = (ValidMakeStats And ValidPaths And ValidName And ValidPGPRing And (Cnf(6, 1) <> ""))
    
    'FTP Stats
    frmMain!chkSession(7).Enabled = ValidPaths And ValidFTP

    frmMain.MousePointer = 0
    CheckConfig = msg
Exit Function
ErrorCheck:
    frmMain.MousePointer = 0
    Err.Raise Err.Number
End Function

Public Function WriteMixCon() As String
    On Error GoTo WriteError
    
    If Not ((Cnf(3, 0) = "True") Or ((Cnf(2, 0) = "True") And ((Cnf(2, 8) = "True") Or (Cnf(2, 9) = "True")))) Then WriteMixCon = "": Exit Function
    
    WriteMixCon = LMsg(55)
    MixFP = Cnf(3, 2)
    MixCon = MixFP + "\mixmaste.con"
    
    DelFile MixFP + "\mixmaste.bak"
    If SDir(MixCon) <> "" Then Name MixCon As MixFP + "\mixmaste.bak"
    
    n = FreeFile
    Open MixCon For Output As n
    Print #n, "# This mixmaste.con file was automatically generated by Reliable"
    Print #n, "# Generated: "; DateLine(1)
    Print #n, "#"
    Print #n, "# Do not edit this file directly.  Change the configuration options"
    Print #n, "# in Reliable."
    Print #n, "# See the end of this file for space to add additional options."
    Print #n,
    If Cnf(3, 7) <> "" Then Print #n, "CHAIN "; Cnf(3, 7)
    Print #n, "MINREL "; Cnf(3, 12)
    Print #n, "MAXLAT "; Trim(Extract(Cnf(3, 13), ":"))
    Print #n, "DISTANCE "; Cnf(3, 8)
    Print #n, "REMAILERLIST "; Cnf(3, 9)
    Print #n, "PUBRING "; Cnf(3, 10)
    Print #n, "SECRING "; Cnf(3, 14)
    Print #n, "RELLIST "; Cnf(3, 11)
    Print #n, "VERBOSE 1"
    Print #n, "ERRSTDOUT 1"
    Print #n, "SOURCEBLOCK source.blo"
    Print #n, "DESTBLOCK destinat.blo"
    Print #n, "REMAILERADDR "; Cnf(1, 1)
    Print #n, "SHORTNAME "; Cnf(1, 0)
    Print #n, "POOLSIZE 0"
    Print #n, "RATE 100"
    Print #n, "IDLOG "; Cnf(3, 3)
    Print #n, "IDEXP "; Cnf(3, 5)
    Print #n, "PACKETEXP "; Cnf(3, 6)
    Print #n,
    Print #n,
    Print #n, "######################################################################"
    Print #n, "# End Reliable Auto-Configuration"
    Print #n, "# Add any additional options below:"
    Print #n,
    Print #n,
    
    If SDir(MixFP + "\mixmaste.bak") <> "" Then
        nold = FreeFile
        Open MixFP + "\mixmaste.bak" For Input As nold
        a = ""
        While Not EOF(nold) And a <> "# Add any additional options below:"
            Line Input #nold, a
        Wend
        a = ""
        While Not EOF(nold) And a = ""
            Line Input #nold, a
        Wend
        If a <> "" Then Print #n, a
        While Not EOF(nold)
            Line Input #nold, a
            Print #n, a
        Wend
        Close nold: nold = 0
    End If
    Close n: n = 0
    
    WriteMixCon = LMsg(56)
    idlog = Cnf(3, 3): If InStr(idlog, "\") = 0 Then idlog = MixFP + "\" + idlog
    If Cnf(3, 4) <> "False" Then
        If SDir(idlog) = "" Then
            n = FreeFile
            Open idlog For Output As n
            Close n: n = 0
        End If
    Else
        DelFile idlog
    End If
    
    WriteMixCon = LMsg(150)
    n = FreeFile
    Open Cnf(3, 2) + "\destinat.blo" For Output As n
    Print #n, "# Blocked destination addresses"
    Print #n, "# When using Reliable leave this file blank"
    Print #n,
    Close n: n = 0
    n = FreeFile
    Open Cnf(3, 2) + "\source.blo" For Output As n
    Print #n, "# Blocked source addresses"
    Print #n, "# When using Reliable leave this file blank"
    Print #n,
    Close n: n = 0
    
    WriteMixCon = ""
Exit Function
WriteError:
    frmMain!chkSession(2).Enabled = False
    frmMain!chkSession(2).Value = 0
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + WriteMixCon + vbCrLf
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    CloseFile n
End Function

Private Function PGPConfig(pgppath) As String
    Dim NeedUpdate As Boolean
    
    On Error GoTo ConfigError
    n = FreeFile
    Open pgppath + "\config.txt" For Input As n
    NeedUpdate = True
    Do While Not EOF(n)
        Line Input #n, a
        If LCase(Left(Trim(a), 10)) = "armorlines" Then
            If LCase(Replace(a, " ", "")) = "armorlines=0" Then NeedUpdate = False: Exit Do
        End If
    Loop
    Close n: n = 0
    If NeedUpdate Then
        If MsgBox(LMsg(170), vbYesNo, LMsg(10)) = vbNo Then PGPConfig = LMsg(176) + vbCrLf: Exit Function
        n = FreeFile
        Open pgppath + "\config.txt" For Input As n
        p = FreeFile
        Open pgppath + "\config_.tmp" For Output As p
        While Not EOF(n)
            Line Input #n, a
            If LCase(Left(Trim(a), 10)) = "armorlines" Then
                Print #p, "Armorlines = 0"
                NeedUpdate = False
            Else
                Print #p, a
            End If
        Wend
        If NeedUpdate Then Print #p, "Armorlines = 0"
        Close p: p = 0
        Close n: n = 0
        FileCopy pgppath + "\config_.tmp", pgppath + "\config.txt"
        DelFile pgppath + "\config_.tmp"
    End If
    PGPConfig = ""
Exit Function
ConfigError:
    PGPConfig = LMsg(176) + vbCrLf + Error + vbCrLf
    CloseFile n
End Function

Public Function CheckPGPRing() As String
    Dim FullCheck As String
    
    On Error GoTo CheckPGPError
    If Val(Cnf(1, 17)) = 0 Then
        'PGP 2.6.x
        If pubkeyfile <> "" And pubkeyfile <> "::NoAuto::" And PubKeyX <> 0 Then
            If SDir(pubkeyfile) <> "" Then
                If FileDateTime(pubkeyfile) <> PubKeyDate Then msg = KeyFile("")
            Else
                msg = KeyFile("")
            End If
        Else
            msg = KeyFile("")
        End If
    Else
        'PGP 5.x
        If PubKeyX <> 0 Or pubkeyfile <> "" Then CheckDupeFlag = True
        pubkeyfile = "": PubKeyX = 0
        
        Dim tempkey(MaxPubKeys) As String, tempkeyX As Integer
        Dim BufferOut As String * 32000, BufferOutLen As Long
        Dim i, Count As Long
            
        'Read Keys
        BufferOut = "" & Chr(0)
        BufferOutLen = 32000
        i = spgpKeyRingID(BufferOut, BufferOutLen)
        Count = CountCRLF(BufferOut)
        Call ChopKeyProps(BufferOut, Count)
    End If
    
    'Every Remailer Key
    x = 0: msg2 = "": allr = ""
    Do While RString(x) <> ""
        RemailerString RString(x), rname, raddress, roptions
        If rname = "" Or raddress = "" Then
            msg = msg + LMsg(241) + ": " + RString(x) + vbCrLf
        Else
            If InStr(allr, vbCr + rname + vbCr) <> 0 Then msg = msg + LMsg(410) + ": " + rname + vbCrLf
            allr = allr + vbCr + rname + vbCr
            If InStr(roptions, " pgp ") <> 0 And InStr(roptions, " cpunk ") <> 0 Then
            If CheckDupeFlag Then FullCheck = "YES" Else FullCheck = ""
                If FindPGPKey(raddress, False, FullCheck) = "" Then msg2 = msg2 + "     " + raddress + vbCrLf
                msg = msg + FullCheck
            End If
        End If
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
    If msg2 <> "" Then msg = msg + LMsg(142) + vbCrLf + msg2
    CheckDupeFlag = False
    CheckPGPRing = msg
Exit Function
CheckPGPError:
    CheckPGPRing = LMsg(286) + " " + pubkeyfile + ": " + Error + vbCrLf
    pubkeyfile = "": PubKeyX = 0
    CheckDupeFlag = True
End Function

Public Function FindPGPKey(searchkey, Optional AlgPreference As Boolean, _
                            Optional FullCheck As String) As String
    'Set FullCheck to non-empty for full feedback
    Dim searchkey2 As String
    Dim foundkey As String, founddate As String, kdate As String
    Dim foundrsa As Long, founddsa As Long
    Dim Found As Boolean, DoFull As Boolean, DoneCheck As Boolean
    
    If Len(Trim(searchkey)) < 3 Then FindPGPKey = "": Exit Function
    If FullCheck <> "" Then DoFull = True: FullCheck = ""
    'Prepare alt search key for nym keys which don't have both addresses in
    'primary UserID
    If LCase(searchkey) Like "send@*.*" Then _
      searchkey2 = "config" + Mid(searchkey, InStr(searchkey, "@"))
    If LCase(searchkey) Like "config@*.*" Then _
      searchkey2 = "send" + Mid(searchkey, InStr(searchkey, "@"))
    'Scan Keys
    If Val(Cnf(1, 17)) = 0 Then
        'PGP 2.6.x
        For i = 0 To PubKeyX - 1
            x = InStr(1, PubKeys(i), "/")
            If x <> 0 Then
                a = "0x" + Mid(PubKeys(i), x + 1, 8) + vbTab
            Else
                a = "": x = -20
            End If
            a = a + Mid(PubKeys(i), x + 21)
            Found = InStr(1, a, searchkey, vbTextCompare) <> 0
            If Not Found Then If searchkey2 <> "" Then Found = InStr(1, PubKeys(i), searchkey2, vbTextCompare) <> 0
            If Found Then
                'Get Key Date
                kdate = LTrim(PubKeys(i))
                kdate = LTrim(Mid(kdate, InStr(kdate, " ") + 1))
                kdate = Extract(LTrim(Mid(kdate, InStr(kdate, " ") + 1)), " ")
                If Len(kdate) <> 10 Or Not (Left(kdate, 2) = "19" Or Left(kdate, 2) = "20") Then kdate = ""
                If DoFull And foundkey <> "" And Not DoneCheck Then If LCase(searchkey) <> LCase(Cnf(1, 1)) Then FullCheck = FullCheck + LMsg(425) + " " + searchkey + vbCrLf: DoneCheck = True
                If foundkey = "" Or kdate > founddate Then
                    foundkey = searchkey
                    founddate = kdate
                End If
            End If
        Next i
    Else
        'PGP 5.x
        For i = 0 To KeyArrayCount - 1
            Found = InStr(1, KeyArray(i).KeyID + vbTab + Chr(34) + KeyArray(i).UserID, searchkey, vbTextCompare) <> 0
            If Not Found Then If searchkey2 <> "" Then Found = InStr(1, KeyArray(i).KeyID + vbTab + Chr(34) + KeyArray(i).UserID, searchkey2, vbTextCompare) <> 0
            If Found Then
                If AlgPreference Or DoFull Then
                    If KeyArray(i).KeyAlgorithm = "" Then
                        'Get Key Properties
                        Dim j As Long
                        Dim BufferIn As String * 256, BufferOut As String * 2048
                        Dim Key As TKey_Data
                        BufferOut = Chr(0)
                        BufferIn = KeyArray(i).KeyID + Chr(0)
                        j = spgpKeyProps(BufferIn, BufferOut, 2048)
                        If j = 0 Then KeyArray(i) = ParseKeyData(BufferOut)
                    End If
                    If DoFull Then
                        If KeyArray(i).KeyAlgorithm = "RSA" Then foundrsa = foundrsa + 1
                        If KeyArray(i).KeyAlgorithm = "DSA" Then founddsa = founddsa + 1
                    End If
                    If foundkey = "" Or Not AlgPreference Or KeyArray(i).KeyAlgorithm = "" Or ((Val(Cnf(1, 26)) = 0 And KeyArray(i).KeyAlgorithm = "RSA") Or (Val(Cnf(1, 26)) <> 0 And KeyArray(i).KeyAlgorithm <> "RSA")) Then
                        foundkey = KeyArray(i).KeyID & vbTab & Chr(34) & KeyArray(i).UserID & Chr(34)
                        If Not DoFull And (Not AlgPreference Or KeyArray(i).KeyAlgorithm = "" Or ((Val(Cnf(1, 26)) = 0 And KeyArray(i).KeyAlgorithm = "RSA") Or (Val(Cnf(1, 26)) <> 0 And KeyArray(i).KeyAlgorithm <> "RSA"))) Then Exit For
                    End If
                Else
                    foundkey = KeyArray(i).KeyID & vbTab & Chr(34) & KeyArray(i).UserID & Chr(34)
                    Exit For
                End If
            End If
        Next i
        If DoFull And LCase(searchkey) <> LCase(Cnf(1, 1)) Then
            If foundrsa > 1 Then FullCheck = FullCheck + LMsg(426) + " " + searchkey + vbCrLf
            If founddsa > 1 Then FullCheck = FullCheck + LMsg(427) + " " + searchkey + vbCrLf
        End If
    End If
    FindPGPKey = foundkey
End Function

Public Function CheckMixRing() As String
    Dim pubring As String
    
    'pubring.mix
    If InStr(Cnf(3, 10), "\") = 0 Then
        fn = Cnf(3, 2) + "\" + Cnf(3, 10)
    Else
        fn = Cnf(3, 10)
    End If
    p = FreeFile
    Open fn For Input As p
    pubring = Input(LOF(p), p)
    Close p: p = 0
    'type2.lis
    If InStr(Cnf(3, 9), "\") = 0 Then
        fn = Cnf(3, 2) + "\" + Cnf(3, 9)
    Else
        fn = Cnf(3, 9)
    End If
    l = FreeFile
    Open fn For Input As l
    While Not EOF(l)
        Line Input #l, b
        a = LTrim(b)
        If a <> "" Then
            'Check for key
            If Type2Entry(a, mname, maddress, mkeyid, "", "") Then
                If InStr(pubring, "-----Begin Mix Key-----" + vbCrLf + mkeyid + vbCrLf) = 0 Then _
                 CheckMixRing = CheckMixRing + "     " + b + vbCrLf
                allL = allL + maddress + vbCr
            End If
        End If
    Wend
    Close l: l = 0
    If CheckMixRing <> "" Then CheckMixRing = LMsg(143) + vbCrLf + CheckMixRing
    'Check every remailer key
    a = ""
    For x = 0 To MaxRemailers
        If RString(x) = "" Then Exit For
        RemailerString RString(x), rname, raddress, roptions
        If InStr(roptions, " mix ") <> 0 And InStr(1, allL, raddress, vbTextCompare) = 0 Then
            a = a + "     " + rname + " <" + raddress + ">" + vbCrLf
        End If
    Next x
    If a <> "" Then CheckMixRing = CheckMixRing + LMsg(409) + ":" + vbCrLf + a
    If Cnf(1, 1) <> "" And Cnf(3, 0) = "True" Then
        If Type2(Cnf(1, 1)) < 1 Then
            CheckMixRing = CheckMixRing + LMsg(144) + vbCr
        Else
            x = InStr(pubring, Cnf(1, 1))
            If x <> 0 Then
                x = InStr(x, pubring, " ") + 1
                MixKey = Extract(Mid(pubring, x), " ")
                    
                'secring.mix
                If InStr(Cnf(3, 14), "\") = 0 Then
                    ring = Cnf(3, 2) + "\" + Cnf(3, 14)
                Else
                    ring = Cnf(3, 14)
                End If
                Found = False
                p = FreeFile
                Open ring For Input As p
                Do While Not EOF(p)
                    Line Input #p, b
                    If InStr(b, MixKey) <> 0 Then Found = True: Exit Do
                Loop
                Close p: p = 0
                If Not Found Then CheckMixRing = CheckMixRing + LMsg(146) + vbCr
            End If
        End If
    End If
End Function

Public Sub Remailer(rname, raddress, rtype, roptions, rlatent, rup)
    roptions = "": rlatent = "": rup = ""
    If rname = "" And raddress = "" Then Exit Sub
    If rtype <> 0 And rtype <> 1 Then rtype = 0
    rname = LCase(rname)
    'Search Remailers
    x = 0: Found = False
    Do While RString(x) <> ""
        RemailerString RString(x), rname2, raddress2, roptions2
        If rname <> "" Then
            If rname = rname2 Then Found = True: Exit Do
        Else
            If raddress = raddress2 Then Found = True: Exit Do
        End If
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
    If Not Found Then rname = "": raddress = "": Exit Sub
    roptions = roptions2: raddress = raddress2: rname = rname2
    'Search Stats
    x = 1
    Do While RemStats(rtype, x) <> ""
        If InStr(1, RemStats(rtype, x), rname, vbTextCompare) = 1 Then
            'piratech     CB9C3?????62  11:05   +++++?????++  100.0%
            '123456789012345678901234567890123456789012345678901234567890
            rlatent = Mid(RemStats(rtype, x), 28, 5)
            rup = Mid(RemStats(rtype, x), 50, 5)
            Exit Sub
        End If
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
End Sub

Public Sub RemailerString(r, rname, raddress, roptions)
    rname = "": raddress = "": roptions = ""
    a = Trim(r)
    If LCase(Left(a, 9)) <> "$remailer" Or InStr(a, "{") = 0 Or InStr(a, "=") = 0 Then rname = "": raddress = "": roptions = "": Exit Sub
    If InStr(a, "&quot;") <> 0 Then a = Replace(a, "&quot;", Chr(34))
    x = InStr(a, "=")
    rname = Mid(a, 10, x - 10)
    rname = Replace(rname, "{", "")
    rname = Replace(rname, "}", "")
    rname = Replace(rname, "'", "")
    rname = Replace(rname, Chr(34), "")
    rname = Trim(LCase(rname))
    b = Mid(a, x + 1)
    If InStr(b, "&lt;") <> 0 Then b = Replace(b, "&lt;", "<")
    If InStr(b, "&gt;") <> 0 Then b = Replace(b, "&gt;", ">")
    x = InStr(b, "<")
    Y = InStr(b, ">")
    If x * Y = 0 Then raddress = "": rname = "": roptions = "": Exit Sub
    raddress = Trim(Mid(b, x + 1, Y - x - 1))
    roptions = Mid(b, Y + 1)
    roptions = Replace(roptions, ";", "")
    roptions = Replace(roptions, "'", "")
    roptions = " " + Replace(roptions, Chr(34), "") + " "
End Sub

Public Function SubSearch(full, test, SearchStyle As Byte) As String
    Dim x As Integer, Y As Integer, a As String, ts As String
    Dim tst As String, lfull As String
    'test contains a vbcrlf delineated list of substrings
    'full contains the full text to be searched
    
    lfull = LCase(full)
    If InStr(test, "[[]") = 0 Then
        If InStr(test, "[") <> 0 Then test = Replace(test, "[", "[[]")
    End If
    If Right(test, 2) <> vbCrLf Then test = test + vbCrLf
    On Error Resume Next 'For invalid search pattern in ts
    Y = 1
    x = InStr(test, vbCrLf)
    While x <> 0
        ts = Trim(Mid(test, Y, x - Y))
        If ts <> "" Then
            If SearchStyle = 0 Then
                'Multi line search
                ts = "*" + ts + "*"
            Else
                'Single line search
                While Left(ts, 1) = "^"
                    ts = Mid(ts, 2)
                Wend
            End If
            If InStr(ts, "^") <> 0 Then ts = Replace(ts, "^", vbCrLf)
            If (lfull Like ts) Then
                If InStr(ts, "[[]") <> 0 Then ts = Replace(ts, "[[]", "[")
                SubSearch = ts
                Exit Function
            End If
        End If
        Y = x + 2
        x = InStr(x + 1, test, vbCrLf)
    Wend
    SubSearch = ""
End Function

Public Sub SessUp(x)
    tb = frmMain!tabMan.SelectedItem.Index - 1
    
    If Len(Sess(x, 0)) > 10000 Then Sess(x, 0) = "[...] " + Right(Sess(x, 0), 10000)
    If Len(Sess(x, 1)) > 20000 Then Sess(x, 1) = "[...] " + Right(Sess(x, 1), 20000)
    If x = 0 Then
        frmMain!imgError(0).Visible = Mgr(0).Errors > 0
        frmMain!imgError(1).Visible = Mgr(0).Warnings > 0
        For i = 0 To 3
            If frmMain!imgError(i).Visible Then frmMain.Icon = frmMain!imgError(i).Picture: Exit For
        Next i
        If i = 4 Then frmMain.Icon = frmMain!cmdMan(0).Picture
        If i > 1 Then
            AlarmReset = 0
            AlarmLast = 0
        End If
        SoundAlarm
        'Determine Load  Ret/Process/Send/NNTP
        Mgr(0).Load = 0
        Mgr(0).Counter = 0
        For i = 1 To 4
            If Mgr(i).Load > Mgr(0).Load And frmMain!chkSession(i).Value = 1 Then Mgr(0).Load = Mgr(i).Load
            Mgr(0).Counter = Mgr(0).Counter + Mgr(i).Counter
        Next i
    End If
    If tb = x Then
        If x <> 5 And x <> 8 Then
            loadperc = Trim(Str(Mgr(x).Load))
            If Val(Cnf(1, 12)) <> 0 Then loadperc = loadperc + "  (" + Trim(Str(Int((Mgr(x).Load / Val(Cnf(1, 12)) * 100)))) + "%)"
            If Mgr(x).LastRun = 0 Then Last = "N/A" Else Last = Format(Mgr(x).LastRun, "dd-mmm-yy") + " " + Format(Mgr(x).LastRun, "short time")
            a = Left(Left(LMsg(1), 11) + ":           ", 12) + Mgr(x).Status + vbCrLf + _
                Left(Left(LMsg(2), 11) + ":           ", 12) + loadperc + vbCrLf + _
                Left(Left(LMsg(3), 11) + ":           ", 12) + Last + vbCrLf + _
                Left(Left(LMsg(4), 11) + ":           ", 12) + Trim(Str(Mgr(x).Counter)) + vbCrLf + _
                Left(Left(LMsg(53), 11) + ":           ", 12) + Trim(Str(Mgr(x).Errors)) + vbCrLf + _
                Left(Left(LMsg(54), 11) + ":           ", 12) + Trim(Str(Mgr(x).Warnings)) + vbCrLf + vbCrLf
            frmMain!txtMan(0).Text = a
            frmMain!txtMan(1).Text = Sess(x, 1)
            frmMain!txtMan(1).SelStart = Len(Sess(x, 1))
        Else
            frmMain!txtMan(0).Text = Sess(x, 0)
            frmMain!txtMan(1).Text = Sess(x, 1)
            frmMain!txtMan(0).SelStart = Len(Sess(x, 0))
        End If
    End If
End Sub

Public Sub QueueProb()
    Trash = FilesInDir(Cnf(1, 5) + "\Trash\*.*")
    Prob = FilesInDir(Cnf(1, 5) + "\MAILPROB\*.*")
    frmMain!cmdFolder(0).Caption = Trim(Str(Prob))
    frmMain!cmdFolder(1).Caption = Trim(Str(Trash))
    frmMain!cmdFolder(0).Visible = Prob > 0
    frmMain!cmdFolder(1).Visible = Trash > 0
    CPunkNeedsMix = ((Cnf(2, 0) = "True") And ((Cnf(2, 8) = "True")) Or (Cnf(2, 9) = "True")) Or (Cnf(8, 10) = "True")
    frmMain!imgError(3).Visible = (RData(29) + RData(30) <> "") Or (Date + Time - KeepDate(28) > 7) Or (Date + Time - KeepDate(29) > 7 And (Cnf(3, 0) = "True" Or CPunkNeedsMix))
    frmMain!imgError(2).Visible = SDir(Cnf(1, 5) + "\MAILOUT\Errors\*.Q*") <> "" Or SDir(Cnf(1, 5) + "\NNTP\Errors\*.Q*") <> ""
End Sub

Public Sub SoundAlarm()
    If frmMain!imgError(0).Visible Then sa = "error.wav" Else If frmMain!imgError(1).Visible Then sa = "warning.wav"
    If sa <> "" And frmMain!mnuAlarm.Enabled And RData(38) = "True" And AlarmReset = 0 And (Date + Time - AlarmLast) * 60 * 60 * 24 > 57 Then
        frmMain!MM1.Wait = False
        frmMain!MM1.Filename = ProgDir + "\" + sa
        frmMain!MM1.Command = "sound"
        AlarmLast = Date + Time
    End If
End Sub

Public Sub ReliShell(a, ByVal Style As Integer, Dump, Optional DispLine As String, Optional StartIn As String)
    On Error GoTo ShellError
    
    While DOSTag <> ""
        DoEvents
    Wend
    ChDrive Left(ProgDir, 1): ChDir ProgDir
    If Dir("relidos.exe") = "" Or Dir("relidos.pif") = "" Then
        Sess(0, 1) = Sess(0, 1) + LMsg(47) + vbCrLf
        Mgr(0).Errors = Mgr(0).Errors + 1
        SessUp (0)
        frmMain!chkSession(2).Value = 0
        frmMain!chkSession(2).Enabled = False
        frmMain!chkSession(6).Value = 0
        frmMain!chkSession(6).Enabled = False
        Exit Sub
    End If
    
    If Dump <> "NUL" Then
        Do
            Dump = Cnf(1, 7) + "\" + Left(MakeTag, 4) + ".rel"
        Loop Until Dir(Dump) = ""
        
        n = FreeFile
        Open Dump For Output As n
        Print #n, DateLine(1)
        Print #n, "DOS Command:"
        If DispLine <> "" Then Print #n, DispLine Else Print #n, a
        Print #n,
        Print #n,
        Print #n, "[Note: No output may indicate a missing program file"
        Print #n, "or environment variable.]"
        Print #n,
        Print #n, "Output:"
        Close n: n = 0
    End If
        
    DOSTag = Left(MakeTag, 4)
    DelFile DOSTag + ".TAG"
    If Style = vbNormalFocus Then c = "P" Else c = "D"
    If DispLine <> "" Then c = LCase(c)
    If Dump = "NUL" Then
        sh = c + DOSTag + a
    Else
        sh = c + DOSTag + a + ">>" + Dump
    End If
    If StartIn <> "" Then sh = ":" + StartIn + "::" + sh
    sh = "relidos " + sh
    If Len(sh) <= 128 Then
        Shell sh, Style
    Else
        DOSTag = "": Dump = ""
        Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(216) + vbCrLf
        Mgr(0).Errors = Mgr(0).Errors + 1
        SessUp (0)
        Exit Sub
    End If
    frmMain!tmrDOS.Tag = ""
    frmMain!tmrDOS.Enabled = True
    While frmMain!tmrDOS.Enabled
        DoEvents
    Wend
    DelFile DOSTag + ".TAG"
    If frmMain!tmrDOS.Tag = "TIMEOUT" And Dump <> "NUL" Then DelFile Dump
    DOSTag = ""
Exit Sub
ShellError:
    frmMain!tmrDOS.Enabled = False
    DOSTag = ""
    Sess(0, 1) = Sess(0, 1) + Format(Time, "short time") + " " + LMsg(48) + vbCrLf + "      " + Error + vbCrLf
    Mgr(0).Errors = Mgr(0).Errors + 1
    SessUp (0)
    CloseFile n
End Sub

Public Sub TurnColor(x, state As Boolean)
    If state Then col = &HFF& Else col = &H80000012
    frmMain!chkSession(x).ForeColor = col
    frmMain!chkSession(x).FontBold = state
    If x = 0 Then Exit Sub
    If state And frmMain!mnuFocus.Checked Then frmMain!tabMan.Tabs(x + 1).Selected = True
    For i = 1 To 7
        If frmMain!chkSession(i).FontBold Then
            TurnColor 0, True
            If Mgr(0).Status <> LMsg(88) Then Mgr(0).Status = LMsg(88): SessUp (0)
            Exit Sub
        End If
    Next i
    TurnColor 0, False
    If Mgr(0).Status <> LMsg(64) Then Mgr(0).Status = LMsg(64): SessUp (0)
End Sub

Public Function MsgTime(msg, ico, Title, Buttons, ByVal DefButton As Byte, Delay, _
Optional ByVal ButtonText1 As String, Optional ByVal ButtonText2 As String, _
Optional ByVal ButtonText3 As String, Optional ByVal CheckText As String, Optional CheckValue As Byte, _
Optional Attended As Boolean) _
As Byte
    
    If ButtonText1 = "" Then
        Select Case Buttons
        Case vbYesNo: ButtonText1 = "&Yes": ButtonText2 = "&No": ButtonText3 = ""
        Case vbYesNoCancel: ButtonText1 = "&Yes": ButtonText2 = "&No": ButtonText3 = "&Cancel"
        Case vbOKOnly: ButtonText1 = "&OK": ButtonText2 = "": ButtonText3 = ""
        Case vbOKCancel: ButtonText1 = "&OK": ButtonText2 = "&Cancel": ButtonText3 = ""
        Case vbRetryCancel: ButtonText1 = "&Retry": ButtonText2 = "&Cancel": ButtonText3 = ""
        Case vbAbortRetryIgnore: ButtonText1 = "&Abort": ButtonText2 = "&Retry": ButtonText3 = "&Ignore"
        End Select
    End If
    frmMsgTime!cmdTime(0).Caption = ButtonText1
    frmMsgTime!cmdTime(1).Caption = ButtonText2
    frmMsgTime!cmdTime(2).Caption = ButtonText3
    frmMsgTime!cmdTime(0).Visible = ButtonText1 <> ""
    frmMsgTime!cmdTime(1).Visible = ButtonText2 <> ""
    frmMsgTime!cmdTime(2).Visible = ButtonText3 <> ""
    If ButtonText2 = "" And ButtonText3 = "" Then
        frmMsgTime!cmdTime(0).Left = 2040
        If DefButton > 1 Then DefButton = 1
    Else
        If ButtonText3 = "" Then
            frmMsgTime!cmdTime(0).Left = 960
            frmMsgTime!cmdTime(1).Left = 3120
            If DefButton > 2 Then DefButton = 2
        Else
            frmMsgTime!cmdTime(0).Left = 240
            frmMsgTime!cmdTime(1).Left = 2040
            If DefButton > 3 Then DefButton = 3
        End If
    End If
    If CheckText <> "" Then frmMsgTime!chkTime.Caption = CheckText
    
    frmMsgTime!chkTime.Visible = CheckText <> ""
    frmMsgTime!chkTime.Value = CheckValue
        
    On Error Resume Next
    frmMsgTime!lblMsg.FontSize = SVal(Cnf(0, 5)) + 8
    frmMsgTime!chkTime.FontSize = SVal(Cnf(0, 5)) + 8
    On Error GoTo 0
    If InStr(msg, vbCrLf) = 0 And Len(msg) < 50 Then
        frmMsgTime!lblMsg.Alignment = 2
        frmMsgTime!lblMsg.Caption = vbCrLf + vbCrLf + msg
    Else
        frmMsgTime!lblMsg.Alignment = 0
        frmMsgTime!lblMsg.Caption = msg
    End If
    frmMsgTime!lblMsg.Width = 5892
    frmMsgTime.Caption = Title
    frmMsgTime.Tag = Str(DefButton - 1)
    
    If Delay <> 0 Then frmMsgTime!tmrTime.Tag = Str(Delay + 1)
    frmMsgTime!tmrTime.Interval = 50
    frmMsgTime!tmrTime.Enabled = Delay <> 0
    
    frmMsgTime.Show 1
    If frmMsgTime.Tag = "" Then
        MsgTime = DefButton - 1
    Else
        CheckValue = frmMsgTime!chkTime.Value
        Attended = frmMsgTime!cmdTime(0).Tag = "True"
        MsgTime = Val(frmMsgTime.Tag) + 1
    End If
    Unload frmMsgTime
    DoEvents
End Function

Public Function MultiBox(Prompt, Title, Optional Default As String, Optional ListMode As Boolean, Optional h As Long, Optional w As Long) As String
    Dim temp(300) As String
    If ListMode Then
        x = ParseString(Default, temp(), 300, False)
        For i = 0 To x
            frmMultiBox!lstInput.AddItem temp(i)
        Next i
        If frmMultiBox!lstInput.ListCount <> 0 Then frmMultiBox!lstInput.Selected(0) = True
        frmMultiBox!lstInput.Visible = True
    Else
        frmMultiBox!txtInput.Text = Default
        frmMultiBox!lstInput.Visible = False
    End If
    frmMultiBox.Caption = Title
    frmMultiBox!lblMsg.Caption = Prompt
    If h <> 0 Then frmMultiBox.Height = h
    If w <> 0 Then frmMultiBox.Width = w
    frmMultiBox.Show 1
    MultiBox = frmMultiBox!txtInput.Text
    h = frmMultiBox.Height
    w = frmMultiBox.Width
    Unload frmMultiBox
End Function

