Attribute VB_Name = "SPGP2"
' NOTES
' When calling a Delphi/ObjectPascal DLL from VB, strings must be declared
' "ByVal" and must be of fixed length. In my experience, they must also be
' manually null-terminated, e.g., MyString = 'privacy' & Chr(0), though only
' one of my sources confirms this. At any rate, this project won't execute
' properly on my computer without the final null (in fact it GPFs violently
' without it).

Option Explicit
'*****************
' data structure for signature information
Type TSig_Data
    Status As String
    UserID As String
    keyid As String
    DateTimeStr As String
    DateTimeInt As Long
    Checked As Boolean
    Verified As Boolean
    KeyValidity As String
    KeyRevoked As Boolean
    KeyDisabled As Boolean
    KeyExpired As Boolean
End Type
' 1st data structure for key information
Type TKey_Data
    Private As Boolean
    keyid As String
    UserID As String
    Bits As String
    DateTimeStr As String
    DateTimeInt As String
    Fingerprint As String
    KeyAlgorithm As String
    Trust As String
    Validity As String
End Type

Global KeyArray() As TKey_Data
Public KeyArrayCount As Long


Public Function ParseSigData(SigProps As String) As TSig_Data
    ' (takes as an argument the tab-delimited string produced by
    ' decode/decodefile functions & parses it to populate a TSig_Data structure)
    Dim Sig As TSig_Data
    Dim sp As String, b As String, y As Long, x As Long, i As Byte
        
    sp = Trim(Extract(Extract(SigProps, vbCrLf), Chr(0))) + vbTab
    y = 1
    For i = 1 To 11
        x = InStr(y, sp, vbTab)
        If x = 0 Then Exit For
        b = Trim(Mid(sp, y, x - y))
        y = x + 1
        Select Case i
        Case 1 'Status
            Select Case b
            Case "0": Sig.Status = "SIGNED_GOOD"
            Case "1": Sig.Status = "SIGNED_NOT": Exit For
            Case "2": Sig.Status = "SIGNED_BAD"
            Case "3": Sig.Status = "SIGNED_NO_KEY"
            Case Else: Sig.Status = "SIGNED_NOT": Exit For
            End Select
        Case 2 'UserID
            Sig.UserID = b
        Case 3 'KeyID
            Sig.keyid = b
        Case 4 'Date and Time string
            Sig.DateTimeStr = b
        Case 5 'Date and Time seconds
            Sig.DateTimeInt = b
        Case 6 'Signature Checked
            Sig.Checked = b = "1"
        Case 7 'Signature Verified
            Sig.Verified = b = "1"
        Case 8 'Key Validity
            Select Case b
            Case "0": Sig.KeyValidity = "Unknown"
            Case "1": Sig.KeyValidity = "Invalid"
            Case "2": Sig.KeyValidity = "Marginal"
            Case "3": Sig.KeyValidity = "Complete"
            Case Else: Sig.KeyValidity = "Unknown"
            End Select
        Case 9 'Key Revoked
            Sig.KeyRevoked = b = "1"
        Case 10 'Key Disabled
            Sig.KeyDisabled = b = "1"
        Case 11 'Key Expired
            Sig.KeyExpired = b = "1"
        End Select
    Next i
    ParseSigData = Sig
End Function


Public Function ParseKeyData(KeyProps As String) As TKey_Data
    Dim kp As String, b As String, x As Long, y As Long, i As Byte
    Dim Key As TKey_Data
    
    kp = Trim(Extract(Extract(KeyProps, vbCrLf), Chr(0))) + vbTab
    If Len(kp) < 5 Then Exit Function
    
    y = 1
    For i = 1 To 10
        x = InStr(y, kp, vbTab)
        If x = 0 Then Exit For
        b = Trim(Mid(kp, y, x - y))
        y = x + 1
        Select Case i
        Case 1 'Private
            Key.Private = b = "1"
        Case 2 'KeyID
            Key.keyid = b
        Case 3 'UserID
            Key.UserID = b
        Case 4 'Size
            Key.Bits = b
        Case 5 'Date
            Key.DateTimeStr = b
        Case 6 'UTC Date
            Key.DateTimeInt = b
        Case 7 'Fingerprint
            Key.Fingerprint = b
        Case 8 'Trust
            Select Case b
            Case "0": b = "Undefined"
            Case "1": b = "Unknown"
            Case "2": b = "Never"
            Case "5": b = "Marginal"
            Case "6": b = "Complete"
            Case "7": b = "Ultimate"
            Case Else: b = "Unknown"
            End Select
            Key.Trust = b
        Case 9 'Validity
            Select Case b
            Case "1": b = "Invalid"
            Case "2": b = "Marginal"
            Case "3": b = "Complete"
            Case Else: b = "Unknown"
            End Select
            Key.Validity = b
        Case 10 'Algorithm
            Select Case b
            Case "1": b = "RSA"
            Case "2": b = "RSAEncryptOnly"
            Case "3": b = "RSASignOnly"
            Case "4": b = "ElGamal"
            Case "5": b = "DSA"
            Case Else: b = "Invalid"
            End Select
            Key.KeyAlgorithm = b
        End Select
        y = x + 1
    Next i
    ParseKeyData = Key
End Function


Public Sub ChopKeyProps(KeyProps As String, Count As Long)
    ' whack the keyring string into smaller strings,
    ' push data into global array for later use
    Dim x As Long, y As Long, u As Long, v As Long, j As Byte
    Dim i As Long, b As String, c As String
    
    ReDim KeyArray(Count) As TKey_Data

    'Break into lines
    i = 0
    y = 1
    x = InStr(KeyProps, vbCrLf)
    While x <> 0 And i < Count
        b = Mid(KeyProps, y, x - y) + vbTab
        'Get props from line
        v = 1
        For j = 1 To 3
            u = InStr(v, b, vbTab)
            If u = 0 Then Exit For
            c = Trim(Mid(b, v, u - v))
            v = u + 1
            Select Case j
            Case 1 'Private
                KeyArray(i).Private = c = "1"
            Case 2 'KeyID
                KeyArray(i).keyid = c
            Case 3 'UserID
                KeyArray(i).UserID = c
            End Select
        Next j
        i = i + 1
        y = x + 2
        x = InStr(y, KeyProps, vbCrLf)
    Wend
    KeyArrayCount = i
End Sub


Public Function CountCRLF(KeyProps As String) As Integer
    Dim x As Long, y As Long, Count As Long
    
    y = 1
    x = InStr(KeyProps, vbCrLf)
    While x <> 0
        Count = Count + 1
        y = x + 2
        x = InStr(y, KeyProps, vbCrLf)
    Wend
    CountCRLF = Count
End Function

