VERSION 5.00
Begin VB.Form frmKeyRing 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "PGP Keyring"
   ClientHeight    =   6480
   ClientLeft      =   48
   ClientTop       =   372
   ClientWidth     =   7764
   Icon            =   "keyring.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   540
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   647
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdCopyKey 
      Caption         =   "&Delete Key"
      Enabled         =   0   'False
      Height          =   372
      Index           =   1
      Left            =   2100
      TabIndex        =   21
      Top             =   3900
      Width           =   1752
   End
   Begin VB.CommandButton cmdCopyKey 
      Caption         =   "Copy &Key"
      Enabled         =   0   'False
      Height          =   372
      Index           =   0
      Left            =   120
      TabIndex        =   20
      Top             =   3900
      Width           =   1752
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "&Cancel"
      Height          =   372
      Left            =   5580
      TabIndex        =   18
      Top             =   6060
      Visible         =   0   'False
      Width           =   1812
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Height          =   372
      Left            =   2880
      TabIndex        =   17
      Top             =   6060
      Width           =   1812
   End
   Begin VB.CheckBox ckExportPrivate 
      Caption         =   "Export Signatures && Private Keys"
      Height          =   252
      Left            =   4260
      TabIndex        =   15
      Top             =   4116
      Width           =   3372
   End
   Begin VB.Frame Frame1 
      Caption         =   "Key Properties"
      Height          =   1575
      Left            =   120
      TabIndex        =   1
      Top             =   4380
      Width           =   7512
      Begin VB.TextBox edCreated 
         Height          =   285
         Left            =   1080
         Locked          =   -1  'True
         TabIndex        =   16
         Top             =   720
         Width           =   4452
      End
      Begin VB.TextBox edValidity 
         Height          =   285
         Left            =   6480
         Locked          =   -1  'True
         TabIndex        =   12
         Top             =   1080
         Width           =   855
      End
      Begin VB.TextBox edTrust 
         Height          =   285
         Left            =   4680
         Locked          =   -1  'True
         TabIndex        =   11
         Top             =   1080
         Width           =   855
      End
      Begin VB.TextBox edPrivate 
         Height          =   285
         Left            =   6480
         Locked          =   -1  'True
         TabIndex        =   9
         Top             =   360
         Width           =   855
      End
      Begin VB.TextBox edBits 
         Height          =   285
         Left            =   2940
         Locked          =   -1  'True
         TabIndex        =   7
         Top             =   1080
         Width           =   855
      End
      Begin VB.TextBox edAlg 
         Height          =   285
         Left            =   1080
         Locked          =   -1  'True
         TabIndex        =   4
         Top             =   1080
         Width           =   855
      End
      Begin VB.TextBox edFingerprint 
         Height          =   285
         Left            =   1080
         Locked          =   -1  'True
         TabIndex        =   2
         Top             =   360
         Width           =   4452
      End
      Begin VB.Label lblValidity 
         Caption         =   "Validity:"
         Height          =   252
         Left            =   5700
         TabIndex        =   14
         Top             =   1140
         Width           =   732
      End
      Begin VB.Label lblTrust 
         Caption         =   "Trust:"
         Height          =   252
         Left            =   3900
         TabIndex        =   13
         Top             =   1140
         Width           =   552
      End
      Begin VB.Label lblCreated 
         Caption         =   "Created:"
         Height          =   252
         Left            =   120
         TabIndex        =   10
         Top             =   780
         Width           =   852
      End
      Begin VB.Label lblPrivate 
         Caption         =   "Type:"
         Height          =   252
         Left            =   5820
         TabIndex        =   8
         Top             =   420
         Width           =   852
      End
      Begin VB.Label lblKeySize 
         Caption         =   "Key Size:"
         Height          =   252
         Left            =   2040
         TabIndex        =   6
         Top             =   1140
         Width           =   852
      End
      Begin VB.Label lblAlgorithm 
         Caption         =   "Algorithm:"
         Height          =   252
         Left            =   120
         TabIndex        =   5
         Top             =   1140
         Width           =   852
      End
      Begin VB.Label lblFingerprint 
         Caption         =   "Fingerprint:"
         Height          =   252
         Left            =   120
         TabIndex        =   3
         Top             =   420
         Width           =   912
      End
   End
   Begin VB.ListBox List1 
      Height          =   3696
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   0
      Top             =   120
      Width           =   7512
   End
   Begin VB.Label lblMultiple 
      Caption         =   "(Hold down Control to select multiple keys)"
      Height          =   252
      Left            =   4080
      TabIndex        =   19
      Top             =   3900
      Width           =   3552
   End
   Begin VB.Menu mnuKey 
      Caption         =   "Key"
      Visible         =   0   'False
      Begin VB.Menu mnuCopyKey 
         Caption         =   "&Copy Key"
         Index           =   0
      End
      Begin VB.Menu mnuCopyKey 
         Caption         =   "&Delete Key"
         Index           =   1
      End
      Begin VB.Menu mnuFindKey 
         Caption         =   "&Find Key   [Ctrl+F]"
         Index           =   0
      End
      Begin VB.Menu mnuFindKey 
         Caption         =   "Find &Next   [Ctrl+G]"
         Index           =   1
      End
   End
End
Attribute VB_Name = "frmKeyRing"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Copyright 1999 Potato Software.   See MAIN.BAS and LICENSE.TXT.

Option Explicit
Dim FindString As String

Private Sub cmdCancel_Click()
    Unload Me
End Sub

Private Sub cmdOK_Click()
    Dim i As Long, x As Integer, Y As Integer, a As String
    Dim kids As String, uids As String
    
    a = ""
    For i = 0 To List1.ListCount - 1
        If List1.Selected(i) Then
            Y = InStr(List1.List(i), vbTab)
            kids = kids + " " + Left(List1.List(i), Y - 1)
            uids = uids + " " + Chr(34) + Mid(List1.List(i), Y + 1) + Chr(34)
            x = x + 1
        End If
    Next i
    a = Trim(Trim(kids) + "   " + Trim(uids))
    Me.Tag = a
    Me.Hide
End Sub

' extract the Key ID from the selected list item
' call keyprops to get the key's properties
Private Sub List1_Click()
    Dim i As Long
    cmdCopyKey(0).Enabled = List1.ListIndex <> -1
    cmdCopyKey(1).Enabled = List1.ListIndex <> -1
    mnuCopyKey(0).Enabled = List1.ListIndex <> -1
    mnuCopyKey(1).Enabled = List1.ListIndex <> -1
    Dim BufferIn As String * 1024, BufferOut As String * 8192  '1024
    Dim Key As TKey_Data
    BufferOut = BufferOut & Chr(0)
    
    ' first 10 characters will be the key id (0x12345678)
    BufferIn = Mid(List1.List(List1.ListIndex), 1, 10)
    
    ' keyprops takes either key id(s) or user id(s)
    ' and returns the key's properties
    i = spgpKeyProps(BufferIn, BufferOut, 8192) '1024
    
    ' parse the returned property-string into a TKey_Data record
    Key = ParseKeyData(BufferOut)
    edFingerprint.Text = Key.Fingerprint
    edAlg.Text = Mid(Key.KeyAlgorithm, InStr(Key.KeyAlgorithm, "_") + 1)
    edBits.Text = Key.Bits
    
    If Key.Private = True Then
        edPrivate = "Private"
    Else
        edPrivate = "Public"
    End If
  
    edCreated.Text = Key.DateTimeStr
    edTrust.Text = Mid(Key.Trust, InStr(Key.Trust, "_") + 1)
    edValidity.Text = Mid(Key.Validity, InStr(Key.Validity, "_") + 1)
  
    If SecretOnly Then
        For i = 0 To List1.ListCount - 1
            If i <> List1.ListIndex And List1.Selected(i) Then List1.Selected(i) = False
        Next i
    End If
End Sub

Private Sub List1_DblClick()
    cmdOK_Click
End Sub

Private Sub Form_Activate()
    Dim i As Long
    
    If Me.Tag <> "" Then
        For i = 0 To List1.ListCount - 1
            If InStr(1, List1.List(i), Me.Tag, vbTextCompare) <> 0 Then
                List1.ListIndex = i
                List1.Selected(i) = True
                List1_Click
            Else
                List1.Selected(i) = False
            End If
        Next i
        Me.Tag = ""
    End If
End Sub

Private Sub Form_Load()
    Dim i As Long, j As Long
    Dim Count As Long
    Dim xID() As String
    
    If Me.WindowState = 0 Then
        Me.Left = Val(PData(21))
        Me.Top = Val(PData(22))
    End If
        
    'Refresh Keys
    PData(16) = ""
    ReadPGPKeys
    
    For i = 0 To KeyArrayCount - 1
        If KeyArray(i).KeyID <> "" Then
            If KeyArray(i).Private Or Not SecretOnly Then
                List1.AddItem KeyArray(i).KeyID & vbTab & KeyArray(i).UserID
            End If
        End If
    Next i
    If List1.ListCount <> 0 Then List1.ListIndex = 0
    lblMultiple.Visible = Not SecretOnly
End Sub

Private Sub Form_Unload(Cancel As Integer)
    If Me.WindowState = 0 Then
        PData(21) = Str(Me.Left)
        PData(22) = Str(Me.Top)
    End If
End Sub

Private Sub mnuCopyKey_Click(Index As Integer)
    cmdCopyKey_Click (Index)
End Sub

Private Sub cmdCopyKey_Click(Index As Integer)
    Dim i As Long, a As String, j As Integer, sc As Long, x As Long
    Dim BufferIn As String * 256
    Dim BufferOut As String * 16384
    Dim Key As TKey_Data

    On Error GoTo CopyError
    
    List1.SetFocus
    If List1.ListIndex = -1 Then Exit Sub
    sc = List1.SelCount
    
    If sc = 0 Then Exit Sub
    
    If Index = 1 Then
        If sc = 1 Then
            If MsgBox(LMsg(580) + vbCrLf + vbCrLf + List1.List(List1.ListIndex), vbOKCancel, LMsg(95)) = vbCancel Then Exit Sub
        Else
            If MsgBox(LMsg(341) + Str(List1.SelCount) + " " + LMsg(582), vbOKCancel, LMsg(95)) = vbCancel Then Exit Sub
        End If
    End If
    
    For j = 0 To List1.ListCount - 1
        If List1.Selected(j) Then
            BufferIn = Mid(List1.List(j), 1, 10) + Chr(0)
            If Index = 0 Then
                'Copy Keys
                BufferOut = Chr(0)
                i = spgpKeyExport(BufferIn, BufferOut, 16384, ckExportPrivate.Value, 0)
                
                If i = 0 Then
                    a = a + Replace(List1.List(j), vbTab, "   ") + vbCrLf + Extract(BufferOut, Chr(0)) + vbCrLf + vbCrLf
                    x = x + 1
                Else
                    MsgBox LMsg(0) + " [" + Trim(Str(i)) + "]", vbCritical + vbOKOnly, LMsg(28)
                    Exit For
                End If
            Else
                'Delete Keys
                i = spgpkeyremove(BufferIn)
                If i <> 0 Then
                    If i = -11995 Then
                        BufferIn = LMsg(581) + Chr(0)
                    Else
                        BufferIn = Chr(0)
                        i = spgpGetErrorString(i, BufferIn)
                    End If
                    MsgBox LMsg(0) + vbCr + Extract(BufferIn, Chr(0)), vbCritical
                    Exit For
                End If
            End If
        End If
    Next j
    
    If Index = 0 Then
        Clipboard.Clear
        Clipboard.SetText a
        If sc = 1 Then
            If ckExportPrivate.Value = 1 Then
                a = vbCr + vbCr + LMsg(571)
                i = vbExclamation
            Else
                a = ""
                i = 0
            End If
            MsgBox LMsg(27) + ":" + vbCr + vbCr + List1.List(List1.ListIndex) + a, i, LMsg(28)
        Else
            MsgBox Str(x) + " " + LMsg(584), 0, LMsg(28)
        End If
    Else
        List1.Clear
        cmdCopyKey(0).Enabled = False
        cmdCopyKey(1).Enabled = False
        mnuCopyKey(0).Enabled = False
        mnuCopyKey(1).Enabled = False
        edFingerprint.Text = ""
        edPrivate.Text = ""
        edTrust.Text = ""
        edValidity.Text = ""
        edBits.Text = ""
        edAlg.Text = ""
        edCreated.Text = ""
        Form_Load
    End If
Exit Sub
CopyError:
    MsgBox LMsg(0) + vbCr + Error, vbCritical
End Sub

Private Sub List1_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyDelete Then
        cmdCopyKey_Click (1)
    ElseIf KeyCode = vbKeyC And Shift = 2 Then
        cmdCopyKey_Click (0)
    End If
End Sub

Private Sub List1_MouseDown(Button As Integer, Shift As Integer, x As Single, Y As Single)
    If Button = vbRightButton Then
        Me.PopupMenu mnuKey
    End If
End Sub

Private Sub mnuFindKey_Click(Index As Integer)
    Dim a As String, x As Long, startx As Long
    If List1.ListCount = 0 Then Exit Sub
    If Index = 0 Or FindString = "" Then
        a = InputBox(LMsg(92), LMsg(583), FindString)
        If a = "" Then Exit Sub
        FindString = a
    End If
    For x = 0 To List1.ListCount - 1
        List1.Selected(x) = 0
    Next x
    cmdCopyKey(0).Enabled = False
    cmdCopyKey(1).Enabled = False
    mnuCopyKey(0).Enabled = False
    mnuCopyKey(1).Enabled = False
    edFingerprint.Text = ""
    edPrivate.Text = ""
    edTrust.Text = ""
    edValidity.Text = ""
    edBits.Text = ""
    edAlg.Text = ""
    edCreated.Text = ""
    x = List1.ListIndex
    startx = x
    Do
        x = x + 1
        If x > List1.ListCount - 1 Then x = 0
        If InStr(1, List1.List(x), FindString, vbTextCompare) <> 0 Then
            List1.ListIndex = x
            List1.Selected(x) = True
            Exit Sub
        End If
    Loop Until x = startx
    Beep
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    If Shift = 2 Then
        If KeyCode = vbKeyF Then mnuFindKey_Click (0): KeyCode = 0
        If KeyCode = vbKeyG Then mnuFindKey_Click (1): KeyCode = 0
    End If
End Sub


