Attribute VB_Name = "Standard"
'Copyright 1999 Potato Software.   See MAIN.BAS and LICENSE.TXT.

Public Const EndPart = "=====_End_Part_====="

Declare Function GetShortPathName Lib "kernel32" _
   Alias "GetShortPathNameA" (ByVal lpszLongPath As String, _
   ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long

Public Function NoSlash(a)
    If Right(Trim(a), 1) = "\" Then
        NoSlash = Left(Trim(a), Len(Trim(a)) - 1)
    Else
        NoSlash = Trim(a)
    End If
End Function

Public Function Extract(a, b) As String
    x = InStr(a, b)
    If x = 0 Then
        Extract = a
    Else
        Extract = Left(a, x - 1)
    End If
End Function

Public Function Replace(a, b, c) As String
    Dim d As String
    
    d = a
    lnb = Len(b)
    lnc = Len(c)
    
    If lnb = 0 Or b = c Then Replace = a: Exit Function
    
    x = InStr(d, b)
    While x <> 0
        d = Left(d, x - 1) + c + Mid(d, x + lnb)
        x = x + lnc
        x = InStr(x, d, b)
    Wend
    Replace = d
End Function

Public Function PlainName(ByVal Pathname As String, Job As Integer) As String
    a = Pathname
    While InStr(a, "\") <> 0
        a = Right(a, Len(a) - InStr(a, "\"))
    Wend
    y = 0
    Do
        x = InStr(y + 1, a, ".")
        If x <> 0 Then y = x
    Loop Until x = 0
    Select Case Job
    Case 0 'Returns Path (Includes trailing slash)
        PlainName = Left(Pathname, Len(Pathname) - Len(a))
    Case 1 'Returns Filename
        PlainName = a
    Case 2 'Returns Name
        If y = 0 Then
            PlainName = a
        Else
            PlainName = Mid(a, 1, y - 1)
        End If
    Case 3 'Returns Extension
        If y = 0 Then
            PlainName = ""
        Else
            PlainName = Mid(a, y + 1)
        End If
    End Select
End Function

Public Function MakeTag(Optional x As Byte) As String
    Const b = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"
    If x = 0 Then x = 8
    For i = 1 To x
        a = a + Mid(b, Int(Rnd(1) * 36) + 1, 1)
    Next i
    MakeTag = a
End Function

Public Function GetWork(Optional WorkPath As String) As String
    If WorkPath = "" Then WorkPath = PData(10)
    Do
        a = WorkPath + "\" + MakeTag(6) + ".tmj"
    Loop Until SDir(a) = ""
    GetWork = a
End Function

Public Function SDir(target, Optional attr As VbFileAttribute) As String
    'Stable Dir  (Will never return error)   No FindNext capability
    If target = "" Then SDir = "": Exit Function
    On Error Resume Next
    SDir = ""
    SDir = Dir(target, attr)
End Function

Public Function SVal(a) As Double
    'Stable Val  (Will never return error)
    SVal = 0
    On Error Resume Next
    SVal = Val(a)
End Function

Public Function DelFile(a) As Boolean
    If a = "" Or SDir(a) = "" Then DelFile = True: Exit Function
    On Error Resume Next
    Kill a
    DelFile = (SDir(a) = "")
End Function

Public Sub CloseFile(n)
    'Will never return error
    If n = 0 Then Exit Sub
    On Error Resume Next
    Close n
End Sub

Public Function DateLine(Job As Byte, Optional ByVal dt As Date) As String
    Dim h As Double, t As Double
    
    If Job = 2 Then
        'Tue 8 Dec 1998 10:02:51 GMT  (English)
        a = DateLine(0, dt)
        b = "   "
        Select Case Val(Format(dt - gmtoffset, "w"))
        Case 1: b = "Sun"
        Case 2: b = "Mon"
        Case 3: b = "Tue"
        Case 4: b = "Wed"
        Case 5: b = "Thu"
        Case 6: b = "Fri"
        Case 7: b = "Sat"
        End Select
        DateLine = b + " " + Left(a, Len(a) - 5) + "GMT"
        Exit Function
    End If
    
    If dt = 0 Then dt = SafeTime
    If Job = 0 Then dt = dt - gmtoffset
    Select Case Val(Format(dt, "mm"))
    Case 1: m = "Jan"
    Case 2: m = "Feb"
    Case 3: m = "Mar"
    Case 4: m = "Apr"
    Case 5: m = "May"
    Case 6: m = "Jun"
    Case 7: m = "Jul"
    Case 8: m = "Aug"
    Case 9: m = "Sep"
    Case 10: m = "Oct"
    Case 11: m = "Nov"
    Case 12: m = "Dec"
    End Select
    
    If Job = 0 Then
        '1 Oct 1998 01:20:00 -0000  (English)
        DateLine = Format(dt, "d") + " " + m + " " + Format(dt, "yyyy hh:nn:ss") + " -0000"
    Else
        'Tue Oct 27 20:20:00 1998
        DateLine = Format(dt, "ddd mmm dd hh:nn:ss yyyy")
    End If
End Function

Public Function CreateDir(ByVal PN As String) As Boolean
    If Trim(PN) = "" Then CreateDir = False: Exit Function
Try:
    On Error GoTo ErrorCreate
    PN = NoSlash(PN)
    If IsDir(PN) Then CreateDir = True: Exit Function
    On Error GoTo ErrorCreate
    MkDir PN
    If Not IsDir(PN) Then GoTo ErrorCreate
    CreateDir = True
Exit Function
ErrorCreate:
    Resume ErrorCreate2
ErrorCreate2:
    If MsgTime(LMsg(26) + " " + PN + vbCr, 0, LMsg(4), vbRetryCancel, 2, 90) = 1 Then GoTo Try
    CreateDir = False
End Function
   
Public Function IsDir(d) As Boolean
    IsDir = False
    On Error Resume Next
    IsDir = (GetAttr(Trim(d)) And vbDirectory) <> 0
End Function

Public Function GetShortName(ByVal sLongFileName As String) As String
    Dim lRetVal As Long, sShortPathName As String, iLen As Integer
    'Set up buffer area for API function call return
    sShortPathName = Space(255)
    iLen = Len(sShortPathName)

    'Call the function
    lRetVal = GetShortPathName(sLongFileName, sShortPathName, iLen)
    'Strip away unwanted characters.
    GetShortName = Left(sShortPathName, lRetVal)
End Function

Public Function DateVal(a) As Date
    'Converts String or Number to Date with no error on failure
    On Error Resume Next
    DateVal = 0
    DateVal = a
End Function

Public Sub WriteArray(n, Ary() As String, AryName As String, Xmax, Ymax, BlankTerm As Boolean)
    'Ymax = -1 if only single dim array
        
    Print #n, "-=-"; AryName
    If Ymax <> -1 Then Print #n, Ymax
    If Ymax = -1 Then ytop = 0 Else ytop = Ymax
    For x = 0 To Xmax
        For y = 0 To ytop
            If Ymax = -1 Then a = Ary(x) Else a = Ary(x, y)
            If BlankTerm And y = 0 Then
                If a = "" Then Print #n, EndPart; vbCrLf: Exit Sub
            End If
            If InStr(a, "&&") <> 0 Then a = Replace(a, "&&", "===AMPAMP===")
            If InStr(a, vbCrLf) <> 0 Then a = Replace(a, vbCrLf, "&&")
            Print #n, a
    Next y, x
    Print #n, EndPart; vbCrLf
End Sub

Public Function ReadArray(n, Ary() As String, Xmax, Ymax) As Long
    'Ymax = -1 if only single dim array

    If Ymax <> -1 Then
        Line Input #n, a
        YmaxIn = Val(a)
    Else
        YmaxIn = 0
    End If
    While Not EOF(n) And Not Done
        For y = 0 To YmaxIn
            Line Input #n, a
            If a = EndPart Then
                a = ""
                Done = True
                Exit For
            End If
            If InStr(a, "&&") <> 0 Then a = Replace(a, "&&", vbCrLf)
            If InStr(a, "===AMPAMP===") <> 0 Then a = Replace(a, "===AMPAMP===", "&&")
            If x <= Xmax Then
                If Ymax = -1 Then
                    Ary(x) = a
                Else
                    If y <= Ymax Then Ary(x, y) = a
                End If
                ReadArray = x
            End If
            If Done Then Exit For
        Next y
        x = x + 1
    Wend
End Function

Public Function ParseString(g, Ary() As String, Xmax, Optional KeepBlanks As Boolean) As Long
    'Takes crlf delineated string g and returns array of lines
    Dim a As String, x As Long, y As Long, z As Long

    g = RTrim(g)
    If g = "" Then ParseString = -1: Exit Function
    If Right(g, 2) <> vbCrLf Then g = g + vbCrLf

    y = 1: x = 0
    z = InStr(g, vbCrLf)
    While z <> 0 And x <= Xmax
        Ary(x) = Mid(g, y, z - y)
        If Trim(Ary(x)) <> "" Or KeepBlanks Then x = x + 1
        y = z + 2
        z = InStr(y, g, vbCrLf)
    Wend
    ParseString = x - 1
End Function

Public Function OpenDialog(FPath, FName, OpenTitle, OpenFlags, FilterString, FilterX, ob As Object) As String
    'Flags = cdlOFNHideReadOnly + cdlOFNFileMustExist
    'Filter = "Message Books (*.BK)|*.BK|Template (*.TBK)|*.TBK|Replay Books (*.BK_)|*.BK_|All Files (*.*)|*.*"
    ob!CommonDialog1.DialogTitle = OpenTitle
    ob!CommonDialog1.Filter = FilterString
    ob!CommonDialog1.FilterIndex = FilterX
    ob!CommonDialog1.Flags = OpenFlags
    ob!CommonDialog1.InitDir = FPath
    ob!CommonDialog1.Filename = FName
    ob!CommonDialog1.CancelError = True
    On Error GoTo CancelOpen
    ob!CommonDialog1.Action = 1
    OpenDialog = ob!CommonDialog1.Filename
Exit Function
CancelOpen:
    OpenDialog = ""
End Function

Public Function SaveDialog(FPath, FName, SaveTitle, SaveFlags, FilterString, FilterX, ob As Object) As String
    'Flags = cdlOFNHideReadOnly + cdlOFNPathMustExist + cdlOFNNoReadOnlyReturn
    ob!CommonDialog1.DialogTitle = SaveTitle
    ob!CommonDialog1.Filter = FilterString
    ob!CommonDialog1.FilterIndex = FilterX
    ob!CommonDialog1.Flags = SaveFlags
    ob!CommonDialog1.InitDir = FPath
    ob!CommonDialog1.Filename = FName
    ob!CommonDialog1.CancelError = True
    On Error GoTo CancelSave
    ob!CommonDialog1.Action = 2
    SaveDialog = ob!CommonDialog1.Filename
Exit Function
CancelSave:
    SaveDialog = ""
End Function

Public Function ResolveDate(ByVal d As String) As Date
    Dim tempdate As Date, Tmp(4) As String
    Const Months = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec "
    'Date: Mon, 7 Mar 1999 20:47:34 -0000

    On Error GoTo ResolveError
    ResolveDate = 0
    x = InStr(d, ",")
    If x <> 0 Then d = Mid(d, x + 1)
    d = Trim(d)
    'Break it up
    For i = 0 To 4
        x = InStr(d, " ")
        If x = 0 Then Tmp(i) = d: Exit For
        Tmp(i) = Left(d, x - 1)
        d = LTrim(Mid(d, x + 1))
    Next i
    'Replace Month with Local Language
    x = InStr(1, Months, Tmp(1) + " ", vbTextCompare)
    If x = 0 Or Tmp(0) = "" Or Tmp(1) = "" Or Tmp(2) = "" Then ResolveDate = 0: Exit Function
    Tmp(1) = Format(32874 + (((x - 1) / 4) * 32), "mmm")
    'Recompose
    d = ""
    For i = 0 To 3
        d = d + Tmp(i) + " "
    Next i
    d = Trim(d)
    tempdate = d
    
    'Adjust for Time Zone
    Tmp(4) = Trim(Extract(Tmp(4), "("))
    h = SVal(Left(Tmp(4), 3)) / 24
    m = SVal(Mid(Tmp(4), 4)) / 60 / 24: If h < 0 Then m = -m
    If tempdate <> 0 Then ResolveDate = tempdate - h - m + gmtoffset
Exit Function
ResolveError:
    ResolveDate = 0
End Function

