Attribute VB_Name = "Shell_Wait"
Option Explicit
    
Private Type STARTUPINFO
    cb As Long
    lpReserved As Long
    lpDesktop As Long
    lpTitle As Long
    dwX As Long
    dwY As Long
    dwXSize As Long
    dwYSize As Long
    dwXCountChars As Long
    dwYCountChars As Long
    dwFillAttribute As Long
    dwFlags As Long
    ' wShowWindow As Integer ' VB pads integers so we use bytes instead
    bytShowWindow1 As Byte
    bytShowWindow2 As Byte
    ' cbReserved2 As Integer
    bytReserved21 As Byte
    bytReserved22 As Byte
    lpReserved2 As Long
    hStdInput As Long
    hStdOutput As Long
    hStdError As Long
End Type
Private Type SECURITY_ATTRIBUTES
    nLength As Long
    lpSecurityDescriptor As Long
    bInheritHandle As Long
End Type
Private Type PROCESS_INFORMATION
    hProcess As Long
    hThread As Long
    dwProcessID As Long
    dwThreadID As Long
End Type
' note: lpProcessAttributes and lpThreadAttributes are normally
' defined as SECURITY_ATTRIBUTES - this example uses AS ANY in order
' to be able to pass "ByVal 0&" to use all defaults
Private Declare Function CreateProcess Lib "kernel32" Alias "CreateProcessA" _
  (ByVal lpApplicationName As String, ByVal lpCommandLine As String, _
  lpProcessAttributes As Any, lpThreadAttributes As Any, _
  ByVal bInheritHandles As Long, ByVal dwCreationFlags As Long, lpEnvironment As Any, _
  ByVal lpCurrentDirectory As String, lpStartupInfo As STARTUPINFO, _
  lpProcessInformation As PROCESS_INFORMATION) As Long

Private Const INFINITE = -1
Private Const STARTF_USESHOWWINDOW = &H1
Private Const STARTF_USESIZE = &H2
Private Const STARTF_USEPOSITION = &H4
Private Const STARTF_USECOUNTCHARS = &H8
Private Const STARTF_USEFILLATTRIBUTE = &H10
Private Const STARTF_RUNFULLSCREEN = &H20
Private Const STARTF_FORCEONFEEDBACK = &H40
Private Const STARTF_FORCEOFFFEEDBACK = &H80
Private Const STARTF_USESTDHANDLES = &H100
Private Const STARTF_USEHOTKEY = &H200
    
Private Declare Function GetExitCodeProcess Lib "kernel32" _
  (ByVal hProcess As Long, lpExitCode As Long) As Long
Private Declare Function WaitForSingleObject Lib "kernel32" _
  (ByVal hHandle As Long, ByVal dwMilliseconds As Long) As Long

Function ShellWait(ByVal CommandLine As String, _
  ByVal ShowWindow As Long, Optional TimeOut As Long, _
  Optional ExitCode As Long) As Long
    'Note: Cannot use piping or redirection (|<>) in commandline
    Dim hTask As Long
    Dim lExitCode As Long
    Dim udtSI As STARTUPINFO
    Dim udtPI As PROCESS_INFORMATION
    Dim x As Long
    ShellWait = False
    On Error Resume Next
    If TimeOut = 0 Then TimeOut = INFINITE
    udtSI.cb = LenB(udtSI)
    udtSI.dwFlags = STARTF_USESHOWWINDOW
    udtSI.bytShowWindow1 = ShowWindow And 255
    udtSI.bytShowWindow2 = (ShowWindow \ 256) And 255
    hTask = CreateProcess(vbNullString, CommandLine, ByVal 0&, _
      ByVal 0&, False, 0, ByVal 0&, vbNullString, udtSI, udtPI)
    If Err.Number <> 0 Then Exit Function
    Call WaitForSingleObject(udtPI.hProcess, TimeOut)
    x = GetExitCodeProcess(udtPI.hProcess, lExitCode)
    ExitCode = lExitCode
    ShellWait = True
End Function
