Attribute VB_Name = "Shared"
'Copyright 1999 Potato Software.   See MAIN.BAS and LICENSE.TXT.

Public Const ConfigGlobal = 0
Public Const ConfigRetrieval = 1
Public Const ConfigBooks = 2
Public Const ConfigRemailers = 3
Public Const ConfigStats = 4
Public Const ConfigSendProf = 6
Public Const ConfigRetProf = 7
Public Const ConfigNewsProf = 8
Public Const ConfigNyms = 9
Public Const ConfigCheck = 11
Public DontRepeat As String
Public QBusyTag(10) As String

'_____________________________________________________________
'WINDOW FUNCTIONS
Public Sub ShowWindow(Index As Integer)
    Dim a As String
    
    Select Case Index
    Case 0  'Explore
        frmMain.Show: frmMain!tabMain.Tabs(1).Selected = True
        If frmMain.WindowState <> 2 Then frmMain.WindowState = 0
    Case 1  'Queue
        frmMain.Show: frmMain!tabMain.Tabs(2).Selected = True
        If frmMain.WindowState <> 2 Then frmMain.WindowState = 0
    Case 2  'Log
        frmMain.Show: frmMain!tabMain.Tabs(3).Selected = True
        If frmMain.WindowState <> 2 Then frmMain.WindowState = 0
    Case 3  'View Mail
        frmViewer.Show
        If frmViewer.WindowState <> 2 Then frmViewer.WindowState = 0
    Case 4  'Stats Browser
        If BrowserLoaded Then
            frmWeb.Show
            If frmWeb.WindowState <> 2 Then frmWeb.WindowState = 0
        Else
            CallBrowser 0, ""
        End If
    End Select
End Sub

Public Sub ShowConfig(Index As Integer, Optional TabX As Integer)
    Select Case Index
    Case 0: frmCfGlobal.Show  'Global
    Case 1: frmCfRet.Show     'Retrieval Config
    Case 2  'Books Config
        If TabX <> 0 Then frmCfBook!tabOpt.Tabs(TabX).Selected = True
        frmCfBook.Show
    Case 3  'Remailers Config
        If TabX <> 0 Then frmCfRmlr!tabRmlr.Tabs(TabX).Selected = True
        frmCfRmlr.Show
    Case 4  'Stats Config
        frmCfStats.Show
    Case 5  '-
    Case 6, 7, 8 'Send, Retrieval, News Profiles
        If Index < 8 Then Index = Abs(Index - 7) Else Index = 2
        frmCfProf.Tag = Str(Index)
        frmCfProf.Show
    Case 9  'Nym Accounts Registry
        frmCfNym.Show
    Case 10 'Addresses
        frmAdds.Show
        If frmAdds.WindowState <> 2 Then frmAdds.WindowState = 0
    Case 11 '-
    Case 12 'Check Configuration
        If CheckConfig("", True, True) Then MsgBox LMsg(400), vbInformation, LMsg(101)
    End Select
End Sub

Public Sub ShowHelp(Index As Integer, Optional Topic As String, Optional SubFile As String)
    Select Case Index
    Case 0  'User's Manual
        CallBrowser 5, Topic, SubFile
    Case 1  'Beginner's Guide
        hlp = ProgDir + "\JBNB-" + PData(0) + ".htm"
        If SDir(hlp) = "" Then hlp = ProgDir + "\JBNB-en.htm"
        CallBrowser 0, hlp
    Case 2  'Troubleshooting Guide
        hlp = ProgDir + "\JBNT-" + PData(0) + ".htm"
        If SDir(hlp) = "" Then hlp = ProgDir + "\JBNT-en.htm"
        CallBrowser 0, hlp
    Case 3  'Remailer Manual
        hlp = ProgDir + "\JBNR-" + PData(0) + ".htm"
        If SDir(hlp) = "" Then hlp = ProgDir + "\JBNR-en.htm"
        CallBrowser 0, hlp
    Case 8  'Default Browser
        hlp = ProgDir + "\JBNH" + SubFile + "-" + PData(0) + ".htm"
        If SDir(hlp) = "" Then hlp = ProgDir + "\JBNH" + SubFile + "-en.htm"
        If SDir(hlp) = "" Then MsgBox hlp, vbCritical, LMsg(66): Exit Sub
        OpenSpec hlp, False
    End Select
End Sub

Public Sub CallBrowser(Job, Resource, Optional SubFile As String)
    Select Case Job
    Case 0  'LoadURL
        frmWeb.Show
        If frmWeb.WindowState <> 2 Then frmWeb.WindowState = 0
        If Resource = "" And SDir(ProgDir + "\Stats\Stats.htm") <> "" Then frmWeb!tmrLoad.Tag = ProgDir + "\Stats\Stats.htm" Else frmWeb!tmrLoad.Tag = Resource
        frmWeb!tmrLoad.Enabled = True
    Case 1  'Refresh Stats
        BrowserJob = ":::RefreshStats:::"
        If BrowserLoaded Then
            frmWeb.Show
            If frmWeb.WindowState <> 2 Then frmWeb.WindowState = 0
        Else
            Load frmWeb
            If Not frmWeb.Visible Then Unload frmWeb
            Unload frmWeb
        End If
    Case 2, 3, 4 'Update CPunk/Mix/Both Keys
        If Job = 2 Then BrowserJob = ":::UpdateCPunkKeys:::"
        If Job = 3 Then BrowserJob = ":::UpdateMixKeys:::"
        If Job = 4 Then BrowserJob = ":::UpdateBothKeys:::"
        If BrowserLoaded Then
            frmWeb.Show
            If frmWeb.WindowState <> 2 Then frmWeb.WindowState = 0
        Else
            Load frmWeb
            If Not frmWeb.Visible Then Unload frmWeb
            Unload frmWeb
        End If
    Case 5  'Load Help
        hlp = ProgDir + "\JBNH" + SubFile + "-" + PData(0) + ".htm"
        If SDir(hlp) = "" Then hlp = ProgDir + "\JBNH" + SubFile + "-en.htm"
        If SDir(hlp) = "" Then MsgBox hlp, vbCritical, LMsg(66): Exit Sub
        If Resource <> "" Then hlp = hlp + Resource
        frmWeb.Show
        If frmWeb.WindowState <> 2 Then frmWeb.WindowState = 0
        frmWeb!tmrLoad.Tag = hlp
        frmWeb!tmrLoad.Enabled = True
    End Select
End Sub

Public Sub GlobalKeyDown(KeyCode As Integer, Shift As Integer)
    Select Case Shift
    Case 0
        Select Case KeyCode
        Case vbKeyF2: frmMain!tabMain.Tabs(1).Selected = True: KeyCode = 0
        Case vbKeyF3: frmMain!tabMain.Tabs(2).Selected = True: KeyCode = 0
        Case vbKeyF4: frmMain!tabMain.Tabs(3).Selected = True: KeyCode = 0
        Case vbKeyF5: ShowWindow (3): KeyCode = 0
        Case vbKeyF6: ShowWindow (4): KeyCode = 0
        Case vbKeyF8: AbortConnection: KeyCode = 0
        End Select
    End Select
End Sub

Public Sub UpdateBooks(Upd)
    On Error Resume Next
    For i = 0 To 9
        If MsgBookName(i) <> "" Then
            MsgBook(i)!tmrReload.Tag = MsgBook(i)!tmrReload.Tag + Upd
            MsgBook(i)!tmrReload.Enabled = True
        End If
        If NymBookName(i) <> "" Then
            NymBook(i)!tmrReload.Tag = NymBook(i)!tmrReload.Tag + Upd
            NymBook(i)!tmrReload.Enabled = True
        End If
    Next i
End Sub


'_________________________________________________________
'REMAILER EDITOR FUNCTIONS
Public Function RemDisp(ByVal rn As String, rd, Optional MidMix As Boolean) As String
    'Returns a single line of the remailer list
    
    Dim temp(100) As String
    
    rn = Extract(LTrim(rn), " ")
    If MidMix Then RemDisp = rn: Exit Function
    
    x = ParseString(Extract(rd, "%%%%Garbage:"), temp(), 100, False)
    For i = 0 To x
        y = InStr(temp(i), ":")
        If y <> 0 Then
            b = Trim(Left(temp(i), y - 1))
            c = Trim(Mid(temp(i), y + 1))
            If c <> "" Then
                Select Case LCase(b)
                Case "latent-time"
                    LatentTime = c
                Case "encrypt-key"
                    EncryptKey = c
                Case "inflate"
                    Inflate = c
                Case "rand-hop"
                    RandHop = c
                Case Else
                    alld = alld + "   ;" + temp(i)
                End Select
            End If
        End If
    Next i
    If LCase(alld) = "   ;anon-to: $final   ;anon-to: $next" Or LCase(alld) = "   ;anon-to: $next" Then alld = ""
    x = InStr(rd, "%%%%Garbage:")
    If x <> 0 Then If Trim(Mid(rd, x + 12)) <> "" Then alld = alld + "   ;Garbage: " + Trim(Mid(rd, x + 12))
    If Inflate <> "" Then alld = "   ;Inflate: " + Inflate + alld
    If RandHop <> "" Then alld = "   ;Rand-Hop: " + RandHop + alld
    If EncryptKey <> "" Then alld = "   ;Encrypt-Key: " + EncryptKey + alld
    If LatentTime <> "" Then alld = "   ;Latent-Time: " + LatentTime + alld
    If Len(rn) < 12 Then rn = Left(rn + String(12, " "), 12)
    RemDisp = rn + " " + alld
End Function

Public Sub ShowRemData(Him As Object, rd, rtype)
    'Displays data in the remailer editor
    
    Dim state As Boolean, MidMix As Boolean
    
    x = Him!lstRemailers.ListIndex
    MidMix = ((rtype = 1) And (x <> Him!lstRemailers.ListCount - 2))
    state = (Him!lstRemailers.List(x) <> "")
    Him!txtRemEdit.Enabled = state
    Him!cboGarbage.Enabled = state And Not MidMix
    Him!txtHeaders(2).Enabled = state And Not MidMix
    Him!cboHeaders(2).Enabled = state And Not MidMix
    Him!txtCaps.Enabled = state
    Him!cmdRemEdit(1).Enabled = state And Not MidMix
    Him!cmdRemEdit(2).Enabled = state And Not MidMix
    Him!lblGarbage.Enabled = state And Not MidMix
    If Not state Then
        Him!txtRemEdit.Text = ""
        Him!cboGarbage.Text = ""
        Him!txtHeaders(2).Text = ""
        Him!txtCaps.Text = ""
        Him!fraRemEdit.Caption = "[ - ]"
        Him!lstRemailers.Tag = ""
        Him!lstRemailers.SetFocus
    Else
        ShowRemailer Him, x, rtype
        Him!txtHeaders(2).Text = Extract(rd, "%%%%Garbage:")
        y = InStr(rd, "%%%%Garbage:")
        If y <> 0 Then Him!cboGarbage.Text = Mid(rd, y + 12) Else Him!cboGarbage.Text = ""
        If Not MidMix Then
            Him!txtHeaders(2).SelLength = 0
            Him!txtHeaders(2).SelStart = 0
            Him!txtHeaders(2).SetFocus
        End If
        Him!lstRemailers.Tag = Str(x)
    End If
End Sub

Public Sub ShowRemailer(Him As Object, ByVal x, ByVal rtype As Integer)
    'Displays data of the remailer in the remailer editor
    
    Dim temp(16) As String, rstringx As String
    
    Rmlr = Extract(Him!lstRemailers.List(x), " ")
    If InStr(Rmlr, "@") = 0 Then rname = Rmlr Else raddress = Rmlr
    Select Case LCase(rname)
    Case "auto", "random"
        Him!txtRemEdit.Text = Rmlr
        If rtype = 0 Then
            Him!txtCaps.Text = "Min Up%: " + Cnf(1, 10) + vbCrLf + "Max Latent: " + Cnf(1, 11) + vbCrLf + "Min Dist: " + Cnf(1, 12) + vbCrLf
        Else
            Him!txtCaps.Text = "Min Up%: " + Cnf(1, 17) + vbCrLf + "Max Latent: " + Cnf(1, 16) + vbCrLf + "Min Dist: " + Cnf(1, 18) + vbCrLf
        End If
        Him!fraRemEdit.Caption = "[" + rname + "]  " + "(" + Trim(Str(x + 1)) + " of" + Str(Him!lstRemailers.ListCount - 1) + ")"
        Exit Sub
    Case "nym-server"
        On Error Resume Next
        raddress = "config@" + Mid(Him!cboNym.Text, InStr(Him!cboNym.Text, "@") + 1)
        On Error GoTo 0
        'Him!fraRemEdit.Caption = "[" + rname + "]"
        rname = ""
        rtype = -1
    Case Else
        Him!txtRemEdit.Text = Rmlr
        For i = 0 To Him!cboRemailer.ListCount - 1
            If Extract(Him!cboRemailer.List(i), " ") = Rmlr Then Him!txtRemEdit.Text = Him!cboRemailer.List(i): Exit For
        Next i
    End Select
    If raddress <> "" Then r = raddress Else r = rname
    If Not Remailer(r, rtype, rname, raddress, roptions, lathist, rlatent, uphist, rup, rstringx, rstats) Then
        'Not found
        Him!txtCaps.Text = LMsg(73)
        Him!fraRemEdit.Caption = "[" + Rmlr + "]  " + "(" + Trim(Str(x + 1)) + " of" + Str(Him!lstRemailers.ListCount - 1) + ")"
    Else
        Him!fraRemEdit.Caption = "[" + UCase(Left(rname, 1)) + Mid(rname, 2) + "]  " + "(" + Trim(Str(x + 1)) + " of" + Str(Him!lstRemailers.ListCount - 1) + ")"
        If rstats = "" Then rstats = rname + String(55 - Len(rname), " ")
        Him!txtRemEdit.Text = rstats + "  " + GetRopts(roptions, rtype) + vbCrLf + "$remailer{" + Chr(34) + rname + Chr(34) + "} = " + Chr(34) + "<" + raddress + "> " + SortROpts(roptions, 0) + Chr(34) + ";"
        Him!txtCaps.Text = SortROpts(roptions, 1)
    End If
End Sub

Public Function SortROpts(roptions, Job) As String
    Dim r As String
    Dim Ocpunk As String, Omix As String, Ohybrid As String
    Dim Omiddle As String, Opgp As String, Opgponly As String
    Dim Olatent  As String, Oek As String, Ocut  As String
    Dim Ohash As String, Opost As String, Orepgp As String
    Dim Oremix As String, Oreord As String, Oext As String
    Dim Omax As String, Otest As String, Oinflt As String
    Dim Orhop As String, Oesub As String, Oklen As String
    Dim Oekx As String
    Dim other As String

    z = 1
    Do
        x = InStr(z, roptions, " ")
        If x <> 0 Then
            a = Trim(LCase(Mid(roptions, z, x - z)))
            If a <> "" Then
                'DPRHGOXATLEUIN1
                Select Case a
                Case "cpunk": Ocpunk = a + " "
                Case "mix": Omix = a + " "
                Case "pgp": Opgp = a + " "
                Case "hash": Ohash = a + " "
                Case "reord": Oreord = a + " "
                Case "middle": Omiddle = a + " "
                Case "post": Opost = a + " "
                Case "remix": Oremix = a + " "
                Case "remix2": If Oremix = "" Then Oremix = a + " "
                Case "hybrid": Ohybrid = a + " "
                Case "repgp": Orepgp = a + " "
                Case "repgp2": If Orepgp = "" Then Orepgp = a + " "
                Case "pgponly": Opgponly = a + " "
                Case "ext": Oext = a + " "
                Case "max": Omax = a + " "
                Case "test": Otest = a + " "
                Case "latent": Olatent = a + " "
                Case "cut": Ocut = a + " "
                Case "ek": Oek = a + " "
                Case "ekx": Oekx = a + " "
                Case "esub": Oesub = a + " "
                Case "?": Oq = a + " "
                Case Else
                    If Left(a, 5) = "inflt" Then Oinflt = a + " ": a = ""
                    If Left(a, 4) = "rhop" Then
                        If Left(a, 5) = "rhops" Then a = "rhop" + Mid(a, 6)
                        Orhop = a + " ": a = ""
                    End If
                    If Left(a, 4) = "klen" Then Oklen = a + " ": a = ""
                    If a <> "" Then
                        If Job = 0 Then
                            other = other + a + " "
                        Else
                            other = other + a + vbCrLf
                        End If
                    End If
                End Select
            End If
        End If
        z = x + 1
    Loop Until x = 0
    If Job = 0 Then
        'DPRHGOXATLEUIN1
        s = " "
        '$remailer{"Example"} = "<example@address.com> cpunk* mix* hybrid* middle* pgp*
        'pgponly* latent* ek* cut hash post* repgp* repgp2* remix* remix2* reord* ext max test
        'inflt#* rhop#* klen#";
        r = Ocpunk + Omix + Ohybrid + Omiddle + Opgp + Opgponly + Olatent + _
            Oek + Oekx + Oesub + Ocut + Ohash + Opost + Orepgp + Oremix + Oreord + Oext + _
            Omax + Otest + Oinflt + Orhop + Oklen + other
    Else
        r = Ocpunk + Omix + Ohybrid + vbCrLf + Omiddle + Opost + vbCrLf + Orepgp + Oremix + vbCrLf + Oext + _
            Omax + Otest + vbCrLf + Oinflt + Orhop + vbCrLf + Oklen + vbCrLf + Oreord + vbCrLf + Opgp + Opgponly + vbCrLf + _
            Olatent + Ocut + vbCrLf + Oek + Oekx + Oesub + vbCrLf + Ohash + vbCrLf + Replace(Trim(other), " ", vbCrLf)
    End If
    SortROpts = Trim(r)
End Function

Public Sub UpRemData(Him, rd As String)
    'Updates data with contents of remailer editor
    
    If Him!lstRemailers.Tag = "" Then Exit Sub
    x = Val(Him!lstRemailers.Tag)
    If Him!lstRemailers.List(x) = "" Then Exit Sub
    rd = Him!txtHeaders(2).Text
    If Right(rd, 2) <> vbCrLf Then If rd <> "" Then rd = rd + vbCrLf
    If Him!cboGarbage.Text <> "" Then rd = rd + "%%%%Garbage:" + Trim(Him!cboGarbage.Text)
    Him!lstRemailers.List(x) = RemDisp(Him!lstRemailers.List(x), rd, Not Him!txtHeaders(2).Enabled)
End Sub

Public Sub AddHeader(rd, h)
    'Adds a directive to rd
        
    x = InStr(h, ":"): If x = 0 Then Exit Sub
    z = InStr(rd, "%%%%Garbage:")
    If z <> 0 Then
        rd2 = Left(rd, z - 1): g = Mid(rd, z)
    Else
        rd2 = rd
    End If
    a = Trim(Left(h, x - 1))
    b = Trim(Mid(h, x + 1))
    x = InStr(1, rd2, a + ":", vbTextCompare)
    If x = 0 Then
        If Right(rd2, 2) <> vbCrLf And rd2 <> "" Then rd2 = rd2 + vbCrLf
        rd2 = rd2 + a + ": " + b + vbCrLf
    Else
        y = InStr(x, rd2, vbCrLf): If y = 0 Then y = Len(rd2) + 1
        rd2 = Left(rd2, x - 1) + a + ": " + b + Mid(rd2, y)
        x = InStr(x + 1, rd2, a + ":", vbTextCompare)
        While x <> 0
            y = InStr(x, rd2, vbCrLf): If y = 0 Then y = Len(rd2) + 1
            rd2 = Left(rd2, x - 1) + Mid(rd2, y + 2)
            x = InStr(x + 1, rd2, a + ":", vbTextCompare)
        Wend
    End If
    rd = rd2 + g
End Sub


'____________________________________________________________
'SHARED BOOK FUNCTIONS
Public Sub GetRemailers(cbo1 As Object, BookRType As Byte)
    Dim temp() As String
    
    cbo1.Clear
    cbo1.AddItem "AUTO"
    'Add Stats Remailers
    x = 1
    Do While RemStats(BookRType, x) <> ""
        r = Extract(RemStats(BookRType, x), " ")
        If Remailer(r, BookRType, rname, raddress, roptions, lathist, rlatent, uphist, rup) Then
            If (BookRType = 0 And InStr(roptions, " cpunk ") <> 0 And InStr(roptions, " pgp ") <> 0 And InStr(roptions, " newnym ") = 0) Or BookRType = 1 Then
                ro = GetRopts(roptions, BookRType)
                a = Left(UCase(Left(rname, 1)) + Mid(rname, 2) + String(12, " "), 12) + " "
                If Trim(uphist) = "" Or Val(Cnf(2, 8)) = 0 Then a = a + lathist + " "
                a = a + rlatent + " "
                If Trim(uphist) <> "" And Val(Cnf(2, 8)) <> 0 Then a = a + uphist + " "
                a = a + Left(rup, 3) + " " + ro
                cbo1.AddItem a
                allr = allr + rname + "%"
            End If
        End If
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
    'Add Non-Stats
    If BookRType = 0 Then
        x = 0
        Do While RString(x) <> ""
            RemailerString RString(x), rname, raddress, roptions
            If rname <> "" And raddress <> "" Then
                If (InStr(roptions, " pgp ") <> 0 And InStr(roptions, " cpunk ") <> 0) And InStr(1, allr, rname + "%", vbTextCompare) = 0 Then
                    cbo1.AddItem Left(UCase(Left(rname, 1)) + Mid(rname, 2) + String(36, " "), 36) + GetRopts(roptions, 0)
                End If
            End If
            x = x + 1: If x > MaxRemailers Then Exit Do
        Loop
    Else
        ReDim temp(MaxRemailers)
        x = Type2(tlist, "", "", "", "")
        x = ParseString(tlist, temp(), MaxRemailers, False)
        For i = 0 To x
            rname = LCase(Extract(Trim(temp(i)), " "))
            If rname <> "" And InStr(1, allr, rname + "%", vbTextCompare) = 0 Then _
             cbo1.AddItem Left(UCase(Left(rname, 1)) + Mid(rname, 2) + String(36, " "), 36) + GetRopts(roptions, 1)
        Next i
        Erase temp
    End If
    If BookRType = 1 Then cbo1.AddItem "RANDOM"
End Sub

Public Function GetRopts(roptions, rtype) As String
    'DPRHGOXATLeUIN1  Stats V2.c
    'DPRHGXATeUIN1
    If InStr(roptions, " middle ") <> 0 Then ro = "D" Else ro = " "
    If InStr(roptions, " post ") <> 0 Then ro = ro + "P" Else ro = ro + " "
    If InStr(roptions, " remix ") <> 0 Then
        ro = ro + "R"
    Else
        If InStr(roptions, " remix2 ") <> 0 Then
            ro = ro + "2"
        Else
            If InStr(roptions, " mix ") <> 0 Then ro = ro + "M" Else ro = ro + " "
        End If
    End If
    If InStr(roptions, " hybrid ") <> 0 Then ro = ro + "H" Else ro = ro + " "
    If InStr(roptions, " repgp ") <> 0 Then
        ro = ro + "G"
    Else
        If InStr(roptions, " repgp2 ") <> 0 Then ro = ro + "2" Else ro = ro + " "
    End If
    If InStr(roptions, " ext ") <> 0 Then ro = ro + "X" Else ro = ro + " "
    If InStr(roptions, " max ") <> 0 Then ro = ro + "A" Else ro = ro + " "
    If InStr(roptions, " test ") <> 0 Then ro = ro + "T" Else ro = ro + " "
    If InStr(roptions, " ek") <> 0 Then
        If InStr(roptions, " ekx ") <> 0 Then ro = ro + "E" Else ro = ro + "e"
    Else: ro = ro + " "
    End If
    If InStr(roptions, " esub") <> 0 Then ro = ro + "U" Else ro = ro + " "
    If InStr(roptions, " inflt") <> 0 Then ro = ro + "I" Else ro = ro + " "
    If InStr(roptions, " rhop") <> 0 Then ro = ro + "N" Else ro = ro + " "
    y = InStr(roptions, " klen")
    If y <> 0 Then
        klen = Int(Abs(Val(Mid(roptions, y + 5))) / 100)
        If klen > 9 Then klen = 9
        ro = ro + Trim(Str(klen))
    Else
        ro = ro + " "
    End If
    GetRopts = ro
End Function

Public Function SplitLines(g, maxlinelen, ErrMsg, Optional newquote As String, Optional fn As String) As String
    Dim oldquote As String, Found As Boolean
    Dim sol As Long, eol As Long
    Dim linelen As Integer, linelen2 As Integer, n As Integer
    Dim oldquotelen As Integer, newquotelen As Integer
    Dim longlinelen As Long
    
    On Error GoTo SplitError
    'Clean g
    If Right(g, 2) <> vbCrLf Then g = g + vbCrLf
    If InStr(g, Chr(0)) <> 0 Then g = Replace(g, Chr(0), " ")
    If InStr(g, Chr(26)) <> 0 Then g = Replace(g, Chr(26), " ")
    'Open output file
    If fn = "" Then fn = GetWork
    n = FreeFile
    Open fn For Output As n
    'Prep
    newquotelen = Len(newquote)
    linelen = maxlinelen - newquotelen
    If maxlinelen > 80 Then longlinelen = maxlinelen Else longlinelen = 80
    oldquote = ""
    sol = 1
    eol = InStr(g, vbCrLf)
    While eol <> 0
        'Find oldquote characters
        If Mid(g, sol, 1) Like "[>,:,|,%,&,#]" Then
            For i = sol + 1 To sol + linelen - 10
                If Not Mid(g, i, 1) Like "[>,:,|,%,&,#, ]" Then oldquote = Mid(g, sol, i - sol): Exit For
            Next i
            linelen2 = longlinelen - newquotelen
        Else
            'No oldquote
            oldquote = ""
            If newquotelen <> 0 Then
                linelen2 = longlinelen - newquotelen
            ElseIf Mid(g, sol, 7) = "http://" Or Mid(g, sol, 6) = "ftp://" Then
                linelen2 = longlinelen
            Else
                linelen2 = linelen
            End If
        End If
        
        If eol - sol > linelen2 Then
            'Line is too long
            'Find space
            Found = False
            oldquotelen = Len(oldquote)
            For i = sol + linelen To sol + oldquotelen Step -1
                If Mid(g, i, 1) = " " Then
                    'Space found
                    Print #n, newquote; RTrim(Mid(g, sol, i - sol))
                    sol = i + 1
                    Found = True
                    Exit For
                End If
            Next i
            If Not Found Then
                'No space found
                Print #n, newquote; Mid(g, sol, linelen)
                sol = sol + linelen
            End If
            'Trim spaces from right side of next line
            Do While Mid(g, sol, 1) = " "
                sol = sol + 1
            Loop
            'If LF was at break, trim
            If Mid(g, sol, 2) = vbCrLf Then sol = sol + 2
            'Add oldquote characters to next line
            If oldquote <> "" And Mid(g, sol, 2) <> vbCrLf Then
                g = Left(g, sol - 1) + oldquote + Mid(g, sol)
            End If
        Else
            'Short line
            Print #n, newquote; Mid(g, sol, eol - sol)
            sol = eol + 2
        End If
        'Find end of next line
        eol = InStr(sol, g, vbCrLf)
    Wend
    Close n: n = 0
    ErrMsg = ""
    SplitLines = fn
Exit Function
SplitError:
    SplitLines = ""
    ErrMsg = Error
    CloseFile n
    DelFile fn
End Function

Public Function JoinLines(g, Optional Reformat As Boolean) As String
    'Returns joined string
    y = 1
    x = InStr(g, vbCrLf)
    While x <> 0
        a = LTrim(Mid(g, y, x - y))
        'Handle leading quote characters
        If Left(a, 1) Like "[>,:,|,%,&,#]" Then
            i = 2
            Do While Mid(a, i, 1) Like "[>,:,|,%,&,#, ]"
                i = i + 1
            Loop
            If Reformat Then
                If JoinLines = "" And oldquote = "" Then
                    oldquote = Left(a, i - 1)
                    If Right(oldquote, 1) = " " Then oldquote = RTrim(oldquote) + " "
                End If
                a = Mid(a, i)
            Else
                newquote = Left(a, i - 1)
                If Trim(newquote) <> Trim(oldquote) Then
                    If JoinLines <> "" Then JoinLines = JoinLines + vbCrLf
                Else
                    a = Mid(a, i)
                End If
                oldquote = newquote
            End If
        Else
            If Not Reformat Then
                If oldquote <> "" Then If JoinLines <> "" Then JoinLines = JoinLines + vbCrLf
                oldquote = ""
            End If
        End If
        
        'Blank line
        If Trim(a) = "" Then
            a = ""
            If Right(JoinLines, 2) <> vbCrLf And JoinLines <> "" Then JoinLines = JoinLines + vbCrLf
        End If
        'Add text
        If Right(JoinLines, 2) <> vbCrLf And JoinLines <> "" And a <> "" Then
            JoinLines = JoinLines + " " + Trim(a)
        Else
            If Reformat Then
                JoinLines = JoinLines + oldquote + a
            Else
                JoinLines = JoinLines + a
            End If
        End If
        'Complete blank line
        If a = "" And JoinLines <> "" Then JoinLines = JoinLines + vbCrLf
        
        'Find next CRLF
        y = x + 2
        x = InStr(y, g, vbCrLf)
        'Trailing text
        If x = 0 Then
            a = LTrim(Mid(g, y))
            If Right(JoinLines, 2) <> vbCrLf And JoinLines <> "" And a <> "" Then
                JoinLines = JoinLines + " " + a
            Else
                JoinLines = JoinLines + a
            End If
            If Not Reformat Then
                If Right(g, 2) = vbCrLf And Left(Right(g, 4), 2) <> vbCrLf Then
                    JoinLines = JoinLines + vbCrLf
                End If
            Else
                If Right(JoinLines, 2) <> vbCrLf Then JoinLines = JoinLines + vbCrLf
            End If
        End If
    Wend
End Function

Public Sub LoadKeyList(ob As Object, Prv As Boolean, Fresh As Boolean)
    Dim xID() As String
    
    temp = ob.Text
    ob.Clear
    'Read Keys
    If Fresh Then ReadPGPKeys
    If Val(PData(12)) = 0 Then
        '2.6.x keys
        ReDim xID(Val(PData(14)))
        y = 0
        For i = 0 To Val(PData(14)) - 1
            x = InStr(PubKeys(i), "/")
            If x <> 0 Then
                KID = Extract(Mid(PubKeys(i), x + 1), " ")
                x = InStr(x + Len(KID) + 2, PubKeys(i), " ")
                If x <> 0 Then uid = Chr(34) + Trim(Mid(PubKeys(i), x + 1)) + Chr(34) Else uid = ""
                ob.AddItem uid
                ob.ItemData(ob.NewIndex) = y
                xID(y) = "0x" + Trim(KID) + "   " + uid
                y = y + 1
            End If
        Next i
    Else
        '5.5.x keys
        ReDim xID(KeyArrayCount): y = 0
        For i = 0 To KeyArrayCount - 1 'UBound(KeyArray())
            If (Not Prv) Or KeyArray(i).Private = True Then
                If KeyArray(i).keyid <> "" Then
                    ob.AddItem Chr(34) + KeyArray(i).UserID + Chr(34)
                    ob.ItemData(ob.NewIndex) = y
                    xID(y) = KeyArray(i).keyid + "   " + Chr(34) + KeyArray(i).UserID + Chr(34)
                    y = y + 1
                End If
            End If
        Next i
    End If
    For i = 0 To ob.ListCount - 1
        ob.List(i) = xID(ob.ItemData(i))
    Next i
    Erase xID
    ob.Text = temp
End Sub

Public Function GetSignPass(KID) As String
    For i = 0 To MaxNyms
        If KeyPass(i, 0) = "" Then Exit For
        If InStr(1, KeyPass(i, 0), KID, vbTextCompare) <> 0 Then GetSignPass = XCrypt("@@@" + KeyPass(i, 1), LeftWin): Exit Function
    Next i
    
    If Val(PData(12)) = 0 Then a = LMsg(160) + ".  " + LMsg(161) Else a = LMsg(160) + ":"
    b = FindPGPKey(KID)
    If b = "" Then b = KID
    frmPass!lblDirections.Caption = a + vbCrLf + vbCrLf + b
    frmPass.Show 1
    GetSignPass = frmPass!txtPass.Text
    frmPass!txtPass.Text = String(Len(frmPass!txtPass.Text), "@")
    Unload frmPass
End Function

Public Function GetDirect(r, ByVal rd As String, rtype, rnum, _
ByVal gNext As String, ByVal gFinal As String, AutoMode As Boolean, _
ByVal Warn As Boolean, MsgLen As Long, d, Garbage, Max As MaxType, _
Optional Previous As Boolean, Optional RBNum As Integer, _
Optional RemixMode As Byte, Optional Dummy As Boolean) As Boolean
    Dim drt(200) As String, x As Long, y As Long, z As Double, maxlat As Double
    Dim temp(50) As String, Indirect As Boolean, Found As Boolean
    Dim rn As String
    
    d = "": Garbage = "": MsgLen = 0: Max.GotMax = False
    If RBNum <> 0 Then rn = Trim(Str(RBNum)) + ", "
    rn = rn + Trim(Str(rnum))
    rn = " [" + rn + "] "
    If LCase(r) <> "auto" And LCase(r) <> "random" Then
        Found = Remailer(r, rtype, rname, raddress, roptions, lathist, rlatent, uphist, rup, "", rstats)
        If rtype <> 2 Then
            'Remailer found?
            If Not Found And Not Previous Then
                If AutoMode Then GetDirect = False: Exit Function
                If rtype = 1 Or raddress = "" Then
                    MsgBox rname + " " + LMsg(165), vbCritical, LMsg(176)
                    GetDirect = False
                    Exit Function
                End If
                If RemixMode > 0 And Warn Then _
                 If MsgBox(r + rn + LMsg(261) + vbCr + vbCr + "(" + LMsg(260) + ".)", vbExclamation + vbOKCancel, LMsg(148)) = vbCancel Then GetDirect = False: Exit Function
            Else
                If AutoMode And Not Previous Then
                    'Check never list
                    If InStr(1, Cnf(1, 13), rname + vbCrLf, vbTextCompare) <> 0 Or InStr(1, Cnf(1, 13), raddress + vbCrLf, vbTextCompare) <> 0 Then GetDirect = False: Exit Function
                    'Check limit list
                    If Val(Cnf(1, 0)) = 4 Then If InStr(1, Cnf(1, 14), rname + vbCrLf, vbTextCompare) = 0 And InStr(1, Cnf(1, 14), raddress + vbCrLf, vbTextCompare) = 0 Then GetDirect = False: Exit Function
                End If
                'Check Remix Compliant
                If RemixMode > 0 And Not Previous Then
                    If InStr(roptions, " mix ") = 0 Or (RemixMode = 1 And InStr(roptions, " remix ") + InStr(roptions, " remix2 ") = 0) Then
                        If AutoMode Then
                            If rname = AutoTest Then Debug.Print "==="; AutoTest, rn + "Non-Remix-Compliant"
                            GetDirect = False
                            Exit Function
                        Else
                            If Warn Then If MsgBox(rname + rn + LMsg(261), vbExclamation + vbOKCancel, LMsg(148)) = vbCancel Then GetDirect = False: Exit Function
                        End If
                    End If
                End If
            End If
        Else
            'Nym-server
            Found = False
            Warn = False
        End If
    End If
    'Find next
    If LCase(gNext) = "auto" Or LCase(gNext) = "random" Then
        nextname = "auto"
        nextaddress = "auto@auto.auto"
    Else
        Remailer gNext, rtype, nextname, nextaddress, nextoptions, "", "", "", ""
        gNext = nextaddress
    End If
    
    'Post?
    If (InStr(1, gFinal, "Post:", vbTextCompare) = 1 Or InStr(1, gFinal, "Post-To:", vbTextCompare) = 1 Or InStr(1, gFinal, "Anon-Post-To:", vbTextCompare) = 1) Then
        If InStr(1, gFinal, "Post:", vbTextCompare) = 1 And Found And ((Val(Cnf(2, 5)) = 1 And Warn) Or AutoMode) And InStr(roptions, " post ") = 0 Then
            If Not AutoMode Then
                If Warn And InStr(DontRepeat, w + "%%%" + rname) = 0 Then If MsgBox(rname + " " + LMsg(173) + " post", vbInformation + vbOKCancel, LMsg(168)) = vbCancel Then GetDirect = False: Exit Function
                DontRepeat = DontRepeat + w + "%%%" + rname
            Else
                If Not Previous Then
                    If rname = AutoTest Then Debug.Print "==="; AutoTest, rn + "No Post Support"
                    GetDirect = False
                    Exit Function
                End If
            End If
        End If
        If InStr(1, gFinal, "Post:", vbTextCompare) <> 1 Then rd = gFinal + vbCrLf + rd
        gFinal = ""
    End If
    
    'Middle?
    If InStr(roptions, " middle ") <> 0 And Warn And Not AutoMode And Not Previous And Val(Cnf(2, 9)) = 1 And gNext = "" Then
        If MsgBox(rname + rn + LMsg(557), vbExclamation + vbOKCancel, LMsg(148)) = vbCancel Then GetDirect = False: Exit Function
    End If
    
    'Find Directives
    x = ParseString(rd, drt(), 200, False)
    For i = 0 To x
        y = InStr(drt(i), ":")
        If y <> 0 Then
            'Analyze directive
            a = Trim(Left(drt(i), y - 1))
            b = Mid(drt(i), y + 1)
            b = Replace(b, "$next", gNext)
            b = Replace(b, "$Next", gNext)
            b = Replace(b, "$NEXT", gNext)
            b = Replace(b, "$final", gFinal)
            b = Replace(b, "$Final", gFinal)
            b = Replace(b, "$FINAL", gFinal)
            b = LTrim(b)
            If b <> "" Then
                If Found And ((Val(Cnf(2, 5)) = 1 And Warn) Or AutoMode) And Not Dummy Then
                    'Check Capabilities
                    w = ""
                    Select Case LCase(a)
                    Case "latent", "latent-time"
                        If InStr(roptions, " latent ") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "%%%%garbage"
                        If (InStr(roptions, " cut ") = 0 Or (rtype = 1 And InStr(roptions, " hybrid ") = 0)) And Not Previous Then w = LMsg(173) + " " + LMsg(434)
                    Case "cutmarks"
                        If InStr(roptions, " cut ") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "encrypt-key", "encrypt-idea"
                        If InStr(roptions, " ek ") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "encrypt-3des", "encrypt-des", "encrypt-cast", "encrypt-cast5"
                        If InStr(roptions, " ekx ") = 0 And Not Previous Then w = LMsg(173) + " " + a + " (ekx)"
                    Case "remix-to"
                        If InStr(roptions, " remix ") + InStr(roptions, " remix2 ") = 0 And Not Previous Then w = rname + rn + LMsg(173) + " " + a + vbCrLf
                        If InStr(b, ",") <> 0 And InStr(roptions, " ext ") = 0 And Not Previous Then w = w + rname + rn + LMsg(187) + " (ext)" + vbCrLf
                        If BadMachine(rname, ".remix", rtype + 1) And Not Previous Then
                            w = w + rname + rn + LMsg(171) + vbCrLf
                        End If
                        'Check for valid mix and remix targets
                        c = Replace(Mid(b, InStr(b, ";") + 1), ",", vbCrLf)
                        z = ParseString(c, temp(), 50, False)
                        lastxname = rname
                        For j = 0 To z
                            c = LCase(Trim(temp(j)))
                            If c <> "" And c <> "random" Then
                                If Remailer(c, -1, xname, "", xoptions, "", "", "", "") Then
                                    If InStr(xoptions, " mix ") = 0 Or (j = z And (InStr(xoptions, " cpunk ") = 0 Or BadMachine(".remix", xname, 1))) Or BadMachine(lastxname, xname, 2) Then
                                        w = w + rname + rn + ": " + xname + " " + LMsg(167) + vbCrLf
                                    End If
                                End If
                                lastxname = xname
                            End If
                            If j = z And ((c <> nextname And c <> nextaddress) Or c = "random" Or gNext = "") Then _
                             w = w + rname + rn + LMsg(414) + "  [" + a + "]" + vbCrLf
                            If (c = "random" Or InStr(c, "@") = 0) And c <> "auto" And InStr(roptions, " ext ") = 0 And Not Previous Then w = w + rname + rn + LMsg(188) + " " + a + "  (ext)" + vbCrLf
                        Next j
                    Case "encrypt-to"
                        If InStr(roptions, " repgp ") + InStr(roptions, " repgp2 ") = 0 And Not Previous Then w = w + rname + rn + LMsg(173) + " " + a + vbCrLf
                        If InStr(b, ",") <> 0 And InStr(roptions, " ext ") = 0 And Not Previous Then w = w + rname + rn + LMsg(187) + " (ext)" + vbCrLf
                        If BadMachine(rname, ".repgp", rtype + 1) And Not Previous Then
                            w = w + rname + rn + LMsg(172) + vbCrLf
                        End If
                        'Check for valid repgp targets
                        c = Replace(Mid(b, InStr(b, ";") + 1), ",", vbCrLf)
                        z = ParseString(c, temp(), 50, False)
                        lastxname = rname
                        For j = 0 To z
                            c = LCase(Trim(temp(j)))
                            If c <> "" And c <> "random" Then
                                If Remailer(c, -1, xname, "", xoptions, "", "", "", "") Then
                                    If InStr(xoptions, " pgp ") = 0 Or InStr(xoptions, " cpunk ") = 0 Or (j = z And BadMachine(".repgp", xname, 1)) Or BadMachine(lastxname, xname, 1) Or (j = z And BadMachine(".repgp", xname, 1)) Or BadMachine(lastxname, xname, 1) Then
                                        w = w + rname + rn + ": " + xname + " " + LMsg(170) + vbCrLf
                                    End If
                                End If
                                If j = z And ((c <> nextname And c <> nextaddress) Or c = "random" Or gNext = "") Then _
                                 w = w + rname + rn + LMsg(414) + "  [" + a + "]" + vbCrLf
                                lastxname = xname
                            End If
                            If (c = "random" Or InStr(c, "@") = 0) And c <> "auto" And InStr(roptions, " ext ") = 0 And Not Previous And InStr(w, rname + rn + LMsg(188) + " (ext)") = 0 Then w = w + rname + rn + LMsg(188) + " (ext)" + vbCrLf
                        Next j
                    Case "anon-post-to", "post-to"
                        If InStr(roptions, " post ") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "test-to"
                        If InStr(roptions, " test ") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "anon-to", "remail-to", "request-remailing-to"
                        If gNext <> "" And InStr(1, b, nextaddress, vbTextCompare) = 0 And LCase(b) <> nextname Then _
                         w = LMsg(414) + "  [" + a + "]"
                        If w = "" And InStr(b, "@") = 0 And LCase(b) <> "auto" And InStr(roptions, " ext ") = 0 And Not Previous Then w = LMsg(188) + " " + a + " (ext)"
                    Case "encrypt-subject"
                        If InStr(roptions, " esub ") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "rand-hop", "rhop", "randhop"
                        If InStr(roptions, " rhop") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "inflate"
                        If InStr(roptions, " inflt") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    Case "maxdate", "max-date", "maxsize", "max-size", "maxcount", "max-count"
                        If InStr(roptions, " max ") = 0 And Not Previous Then w = LMsg(173) + " " + a
                    End Select
                    'Issue Warning
                    If w <> "" Then
                        If Not AutoMode Then
                            If InStr(w, vbCrLf) = 0 Then w = rname + rn + w
                            If InStr(DontRepeat, w + "%%%") = 0 Then If MsgBox(w + vbCr + vbCr + GetRopts(roptions, rtype) + vbCr + SortROpts(roptions, 0), vbInformation + vbOKCancel, LMsg(168)) = vbCancel Then GetDirect = False: Exit Function
                            DontRepeat = DontRepeat + w + "%%%"
                        Else
                            If rname = AutoTest Then Debug.Print "==="; AutoTest, rn + w
                            GetDirect = False
                            Exit Function
                        End If
                    End If
                End If
                'Add directive
                c = LCase(a)
                If ((c = "remix-to" Or c = "encrypt-to") And InStr(b, ",") <> 0) Or c = "rand-hop" Or c = "rhop" Or c = "randhop" Then Indirect = True
                If c = "%%%%garbage" Then
                    Garbage = b
                Else
                    If c = "test-to" Then
                        TestTo = a + ": " + b + vbCrLf
                    Else
                        If c = "anon-to" Or c = "null" Or c = "remail-to" Or c = "encrypt-to" Or c = "remix-to" Or c = "request-remailing-to" Or c = "post-to" Or c = "anon-post-to" Then
                            destdirect = destdirect + 1
                            d = a + ": " + b + vbCrLf + d
                        Else
                            d = d + a + ": " + b + vbCrLf
                        End If
                    End If
                End If
            End If
        End If
    Next i
    d = TestTo + d
    
    'Add Garbage Cutmarks
    If Val(Garbage) > 0 And InStr(1, vbCrLf + d, vbCrLf + "cutmarks:", vbTextCompare) = 0 And Not Previous Then
        d = d + "Cutmarks: -----BEGIN GARBAGE-----" + vbCrLf
    End If
    
    'Destinations
    w = ""
    If destdirect > 1 And Found Then If InStr(roptions, " ext ") = 0 And Not Previous Then w = LMsg(186) + " (ext)"
    If destdirect = 0 And rtype = 0 And Not Previous Then w = LMsg(178)
    If Found And rtype = 1 And InStr(roptions, " hybrid ") = 0 And Not Previous And d <> "" Then w = LMsg(190)
        
    
    'Issue Warning
    If w <> "" Then
        If Not AutoMode Then
            If Warn And InStr(DontRepeat, w + "%%%" + rname) = 0 Then If MsgBox(rname + rn + w, vbInformation + vbOKCancel, LMsg(168)) = vbCancel Then GetDirect = False: Exit Function
            DontRepeat = DontRepeat + w + "%%%" + rname
        Else
            If rname = AutoTest Then Debug.Print "==="; AutoTest, rn + w
            GetDirect = False
            Exit Function
        End If
    End If
    
    'Add Max
    If Max.NeedMax And Found And InStr(roptions, " max ") <> 0 Then
        If Max.MaxSize <> "" Then _
         If InStr(1, vbCrLf + d, vbCrLf + "maxsize: ", vbTextCompare) + InStr(1, vbCrLf + d, vbCrLf + "max-size: ", vbTextCompare) = 0 Then _
          d = d + "Max-Size: " + Max.MaxSize + vbCrLf
        If Max.MaxCount <> "" Then _
         If InStr(1, vbCrLf + d, vbCrLf + "maxcount: ", vbTextCompare) + InStr(1, vbCrLf + d, vbCrLf + "max-count: ", vbTextCompare) = 0 Then _
          d = d + "Max-Count: " + Max.MaxCount + vbCrLf
        If InStr(1, vbCrLf + d, vbCrLf + "maxdate: ", vbTextCompare) + InStr(1, vbCrLf + d, vbCrLf + "max-date: ", vbTextCompare) = 0 Then
            If Max.MaxHours <> 0 Then
                d = d + "Max-Date: " + DateLine(0, SafeTime + (Max.MaxHours + Rnd(1) * 7) / 24) + vbCrLf
            Else
                If Max.MaxDate <> "" Then _
                 d = d + "Max-Date: " + Max.MaxDate + vbCrLf
            End If
        End If
        Max.GotMax = True
    End If
    
    'Bad Chain?
    If Found And nextname <> "" And Not Indirect Then
        If rtype = 2 Then x = 1 Else x = rtype + 1
        If BadMachine(rname, nextname, x) Then
            If Not AutoMode Then
                If Warn Then If MsgBox(rname + rn + LMsg(169) + " " + nextname, vbInformation + vbOKCancel, LMsg(168)) = vbCancel Then GetDirect = False: Exit Function
            Else
                If rname = AutoTest Then Debug.Print "==="; AutoTest, rname + rn + LMsg(169) + " " + nextname
                GetDirect = False
                Exit Function
            End If
        End If
    End If
    'Find maximum message length
    x = InStr(roptions, " klen")
    If x <> 0 Then MsgLen = Val(Mid(roptions, x + 5)) * 1024
    
    'Stats warning
    If Found And (AutoMode Or (Val(Cnf(2, 7)) <> 0 And Warn)) And Not Previous Then
        If rtype = 0 Then
            maxlat = LatentValue(Cnf(1, 11))
            minup = Val(Cnf(1, 10))
        Else
            maxlat = LatentValue(Cnf(1, 16))
            minup = Val(Cnf(1, 17))
        End If
        w = ""
        'Latency
        If AutoMode Or Trim(rlatent) <> "" Then
            BadList = False
            If Val(Cnf(1, 0)) = 2 Or Val(Cnf(1, 0)) = 3 Then
                If InStr(1, Cnf(1, 14), rname + vbCrLf, vbTextCompare) <> 0 Or InStr(1, Cnf(1, 14), raddress + vbCrLf, vbTextCompare) <> 0 Then BadList = True
            End If
            z = LatentValue(Left(rlatent, 5))
            If z * maxlat <> 0 And z > maxlat And Not BadList Then w = LMsg(175)
        End If
        'Uptime
        If AutoMode Or Trim(rup) <> "" Then
            BadList = False
            If Val(Cnf(1, 0)) = 1 Or Val(Cnf(1, 0)) = 3 Then
                If InStr(1, Cnf(1, 14), rname + vbCrLf, vbTextCompare) <> 0 Or InStr(1, Cnf(1, 14), raddress + vbCrLf, vbTextCompare) <> 0 Then BadList = True
            End If
            If Val(rup) < minup And Not BadList Then w = LMsg(175)
        End If
        'Consider History
        If Val(Cnf(1, 2)) = 1 Then
            If Trim(uphist) <> "" Then
                BadList = False
                If Val(Cnf(1, 0)) = 1 Or Val(Cnf(1, 0)) = 3 Then
                    If InStr(1, Cnf(1, 14), rname + vbCrLf, vbTextCompare) <> 0 Or InStr(1, Cnf(1, 14), raddress + vbCrLf, vbTextCompare) <> 0 Then BadList = True
                End If
                If Not BadList And Not (Right(uphist, 1) = "+" Or Mid(uphist, 11, 1) = "+" Or (Mid(uphist, 10, 1) = "+" And Val(Mid(uphist, 11, 1)) <> 0)) Then w = LMsg(175)
            Else
                If Trim(lathist) <> "" Then
                    BadList = False
                    If Val(Cnf(1, 0)) = 2 Or Val(Cnf(1, 0)) = 3 Then
                        If InStr(1, Cnf(1, 14), rname + vbCrLf, vbTextCompare) <> 0 Or InStr(1, Cnf(1, 14), raddress + vbCrLf, vbTextCompare) <> 0 Then BadList = True
                    End If
                    If Right(lathist, 2) = "??" And Not BadList Then w = LMsg(175)
                End If
            End If
        End If
        'Issue Warning
        If w <> "" Then
            If Not AutoMode Then
                If InStr(DontRepeat, w + "%%%" + rname) = 0 Then If MsgBox(rname + rn + w + vbCr + vbCr + LMsg(407) + ":" + Mid(RemStats(rtype, 0), InStr(RemStats(rtype, 0), ":") + 1) + vbCr + vbCr + rstats, vbInformation + vbOKCancel, LMsg(410)) = vbCancel Then GetDirect = False: Exit Function
                DontRepeat = DontRepeat + w + "%%%" + rname
            Else
                If rname = AutoTest Then Debug.Print "==="; AutoTest, rn + w
                GetDirect = False
                Exit Function
            End If
        End If
    End If
    GetDirect = True
End Function

Public Function BadMachine(rname1, rname2, infotype) As Boolean
    x = InStr(1, PData(42), "Groups of remailers sharing a machine or operator:", vbTextCompare)
    y = InStr(1, PData(42), "Broken type-I remailer chains:", vbTextCompare)
    z = InStr(1, PData(42), "Broken type-II remailer chains:", vbTextCompare)
    BadMachine = False
    If infotype > 2 Then Exit Function
    a = PData(42)
    Select Case infotype
    Case 0
        If x = 0 Then Exit Function
        If y > x Then a = Left(a, y - 1)
        If z > x Then a = Left(a, z - 1)
        a = Mid(a, x)
    Case 1
        If y = 0 Then Exit Function
        If x > y Then a = Left(a, x - 1)
        If z > y Then a = Left(a, z - 1)
        a = Mid(a, y)
    Case 2
        If z = 0 Then Exit Function
        If x > z Then a = Left(a, x - 1)
        If y > z Then a = Left(a, y - 1)
        a = Mid(a, z)
    End Select
    BadMachine = (InStr(1, a, "(" + rname1 + " " + rname2 + ")", vbTextCompare) <> 0) Or _
                 (InStr(1, a, "(* " + rname2 + ")", vbTextCompare) <> 0) Or _
                 (InStr(1, a, "(" + rname1 + " *", vbTextCompare) <> 0)
End Function

Public Function GetRandom(Rmlr() As String, RemDirect() As String, _
RCount, rtype, gFinal, MsgLen, MaxDirect, RemixComp As Boolean, _
Optional Dummy As Boolean) As Integer
    Dim gNext As String, r As String, x As Long
    Dim rlist(MaxRemailers) As String, AllCount As Integer
    Dim temp(MaxRemailers) As String, rd As String
    Dim MsgLenMax As Long, Max As MaxType, GotMaxDirect As Boolean
    Dim RemixMode As Byte
    
    If InStr(1, gFinal, "Post:", vbTextCompare) = 1 And rtype = 1 Then post = True
        
    'Get list of all remailers
    If rtype = 1 Then
        r = ""
        Type2 r, "", "", "", ""
        AllCount = ParseString(r, rlist(), MaxRemailers, False) + 1
        For i = 0 To AllCount - 1
            rlist(i) = Trim(Extract(rlist(i), " "))
        Next i
    Else
        x = 0: Found = False
        Do While RString(x) <> ""
            BadList = False
            RemailerString RString(x), rname, raddress, roptions
            If InStr(roptions, " cpunk ") <> 0 And InStr(roptions, " pgp ") <> 0 Then
                rlist(AllCount) = rname
                AllCount = AllCount + 1
            End If
            x = x + 1: If x > MaxRemailers Then Exit Do
        Loop
    End If
    
    'Eliminate invalid remailers due to stats and lists
    If rtype = 0 Then rd = "Anon-To: auto@auto.auto" + vbCrLf Else rd = ""
    For i = 0 To AllCount - 1
        rlist(i) = Trim(Extract(rlist(i), " "))
        If rlist(i) <> "" Then
            If Not GetDirect(rlist(i), rd, rtype, 0, "", "", True, False, MsgLenMax, d, Garbage, Max, False, 0, 0, Dummy) Then
                rlist(i) = ""
            End If
            If rtype = 0 And MsgLenMax <> 0 And MsgLen + Val(Garbage) * 1024 + 5000 > MsgLenMax Then rlist(i) = ""
        End If
    Next i
    
    'Show Only
    If RCount = 0 Then
        If rtype = 0 Then a = "Cypherpunk" Else a = "Mixmaster"
        b = ""
        For i = 0 To AllCount - 1
            If rlist(i) <> "" Then b = b + "     " + UCase(Left(rlist(i), 1)) + Mid(rlist(i), 2) + vbCrLf
        Next i
        If MsgBox(a + ":" + vbCr + vbCr + b + vbCr + LMsg(269), vbInformation + vbYesNo + vbDefaultButton2, LMsg(242)) = vbYes Then
            Clipboard.Clear
            Clipboard.SetText b
        End If
        GetRandom = -1
        Exit Function
    End If
    
    'Max
    GotMaxDirect = False
    If MaxDirect Then
        For i = 0 To RCount - 1
            If LCase(Rmlr(i)) <> "auto" And LCase(Rmlr(i)) <> "random" Then
                If Remailer(Rmlr(i), rtype, rname, raddress, roptions, "", "", "", "") Then
                    If InStr(roptions, " max ") <> 0 Then GotMaxDirect = True: Exit For
                End If
            End If
        Next i
    End If
    
    'Fill Autos
    gPrev = "": dPrev = ""
    For i = 0 To RCount - 1
        If LCase(Rmlr(i)) = "auto" Then
            Autox = Autox + 1
            'Get list of valid remailer choices
            If i = RCount - 1 Then
                tempfinal = gFinal
                gNext = ""
                rd = RemDirect(i)
            Else
                tempfinal = ""
                gNext = Rmlr(i + 1)
                If rtype = 1 Then rd = "" Else rd = RemDirect(i)
            End If
            'Max
            If MaxDirect And Not GotMaxDirect And (rtype = 0) Then rd = rd + vbCrLf + "Max-Size: 1000" + vbCrLf
            rx = 0: Erase temp
            For j = 0 To AllCount - 1
                If rlist(j) <> "" Then
                    Remailer rlist(j), rtype, rname, raddress, roptions, "", "", "", ""
                    'Check distance
                    If rtype = 0 Then x = 12 Else x = 18
                    x = Int(Abs(Val(Cnf(1, x))))
                    y1 = i - x: If y1 < 0 Then y1 = 0
                    y2 = i + x: If y2 > RCount - 1 Then y2 = RCount - 1
                    For k = y1 To y2
                        If k <> i And (LCase(Rmlr(k)) = rname Or LCase(Rmlr(k)) = raddress) Then Exit For
                    Next k
                    Good = (k = y2 + 1)
                    'Check End of Chain
                    If i = RCount - 1 Then
                        'Middle
                        If InStr(roptions, " middle ") <> 0 Then Good = False
                        'Mix Post
                        If rtype = 1 And post And InStr(roptions, " post ") = 0 Then Good = False
                    End If
                    If Good Then
                        If RemixComp Then
                            If i = RCount - 1 Then RemixMode = 2 Else RemixMode = 1
                        End If
                        'Check remailer with directives
                        If GetDirect(rlist(j), rd, rtype, 0, gNext, tempfinal, True, False, MsgLenMax, d, Garbage, Max, False, 0, RemixMode, Dummy) Then
                            'Check Mix Msg Length
                            If rtype = 1 And i = RCount - 1 And MsgLenMax <> 0 And MsgLen + Val(Garbage) * 1024 + 8192 > MsgLenMax Then Good = False
                            'Check previous remailer
                            If i <> 0 And Good Then
                                If rtype = 1 Then rdprev = "" Else rdprev = RemDirect(i - 1)
                                If Not GetDirect(Rmlr(i - 1), rdprev, rtype, 0, rlist(j), "", True, False, MsgLenMax, d, Garbage, Max, True, 0, 0, Dummy) Then Good = False
                            End If
                            'Good
                            If Good Then
                                temp(rx) = rlist(j)
                                rx = rx + 1
                            End If
                        End If
                    End If
                End If
            Next j
            If rx = 0 Then
                'Insufficient remailers
                GetRandom = i + 1 'Autox
                Exit Function
            Else
                'Choose random
                For j = 0 To 2: x = Rnd(1): Next j
                x = Int(Rnd(1) * (rx))
                Rmlr(i) = temp(x)
                If MaxDirect Then GotMaxDirect = True
                Debug.Print "*";
            End If
        End If
        Debug.Print i, Rmlr(i)
    Next i
    
    GetRandom = -1
End Function


'____________________________________________________________
'SHARED MAIL FUNCTIONS
Public Function QueMail(Src, ToA, Hdrs, BookName, MsgType, Prof, QTag As String, QNum As Integer, Optional TempQ As Boolean) As String
    OrigQNum = QNum
    If QTag = "" Then
        Do
            QTag = MakeTag(4)
        Loop Until SDir(Cnf(0, 1) + "\" + QTag + "*.*") = ""
    End If
    If TempQ Then
        q = ".T"
    Else
        q = ".Q"
        QBusyTag(10) = QTag
    End If
    If Prof = 15 Then ProfName = "UNIX" Else ProfName = UserProf(15 + Prof, 1)
    If ProfName = "" Then ProfName = Trim(Str(Prof + 1))
    If MsgType = 0 Then
        'Queue Plain Message
        QNum = QNum + 1
        MDst = Cnf(0, 1) + "\" + QTag + Right("000" + Trim(Str(QNum)), 4)
        n = FreeFile
        Open MDst + q + "0" For Output As n
        Print #n, "JBN2_QMAIL"
        Write #n, SafeTime
        Print #n, ProfName
        Print #n, BookName
        Print #n,
        Print #n,
        Print #n,
        Print #n,
        Print #n,
        Print #n, "To: "; ToA
        Print #n, Hdrs
        Close n: n = 0
        FileCopy Src, MDst + q + "1"
        DelFile Src
    Else
        'Queue Mixmaster Packets
        If Dir(Src) <> "" Then i = 0 Else i = 1
        Do
            If i = 0 Then fn = Src Else fn = Src + "." + Trim(Str(i))
            a = SDir(fn)
            If a <> "" Then
                'Read To address
                s = FreeFile
                Open fn For Input As s
                If Not EOF(s) Then Line Input #s, Toh
                While Not EOF(s) And b <> "::"
                    Line Input #s, b
                Wend
                If Left(Toh, 4) <> "To: " Or b <> "::" Then
                    'Bad Mix
                    Msg = LMsg(284): GoTo QError
                Else
                    QNum = QNum + 1
                    'Write header file
                    MDst = Cnf(0, 1) + "\" + QTag + Right("000" + Trim(Str(QNum)), 4)
                    n = FreeFile
                    Open MDst + q + "0" For Output As n
                    Print #n, "JBN2_QMAIL"
                    Write #n, SafeTime
                    Print #n, ProfName
                    Print #n, BookName
                    Print #n,
                    Print #n,
                    Print #n,
                    Print #n,
                    Print #n,
                    Print #n, Toh
                    Print #n, Hdrs
                    Close n: n = 0
                    'Write body
                    n = FreeFile
                    Open MDst + q + "1" For Output As n
                    Print #n, "::"
                    While Not EOF(s)
                        Line Input #s, b
                        Print #n, b
                    Wend
                    Close s: s = 0
                    Close n: n = 0
                    DelFile fn
                End If
            End If
            i = i + 1
        Loop Until a = "" Or i = 1
    End If
    QBusyTag(10) = ""
    QueMail = ""
Exit Function
QError:
    ErrMsg = Error
    CloseFile n
    CloseFile s
    DelFile Src
    DelFile Src + ".*"
    If MDst <> "" Then DelFile MDst + ".*"
    QNum = OrigQNum
    QBusyTag(10) = ""
    QueMail = LMsg(285) + vbCr + Msg + ErrMsg
End Function

Public Sub ViewQueMsg(basefn, ext, Prof)
    On Error GoTo ViewError
    If SDir(basefn + "." + ext + "0") <> "" And SDir(basefn + "." + ext + "1") <> "" Then
        'Read Headers
        n = FreeFile
        Open basefn + "." + ext + "0" For Input As n
        x = LOF(n): If x > 30000 Then x = 30000
        a = Input(x, n)
        Close n: n = 0
        x = InStr(a, vbCrLf + "To: ")
        Hdrs = Mid(a, x + 2)
        'Preview
        y = PreviewMsg(LMsg(309), Prof, "", -1, True, Hdrs, basefn + "." + ext + "1", False, 1)
    Else
        MsgBox LMsg(405), vbExclamation, LMsg(66)
    End If
Exit Sub
ViewError:
    MsgBox LMsg(0) + vbCr + Error, vbCritical, LMsg(4)
    CloseFile n
End Sub

Public Function FindRB(RBTag, RBNum, RBX, RBY, _
                FullRead As Boolean, Optional Block As String, _
                Optional RBPos As Long)
    RBNum = ""
    RBX = -1
    RBY = -1
    RBPos = -1
    x = InStr(RBTagLocation, RBTag)
    If x <> 0 Then
        a = Extract(Mid(RBTagLocation, x), vbCrLf)
        x = InStr(a, "#")
        If x <> 0 Then
            RBNum = Extract(Mid(a, x), "%")
        Else
            RBNum = ""
        End If
        x = InStr(a, "%")
        If x <> 0 Then
            RBX = SVal(Extract(Mid(a, x + 1), "$"))
        Else
            RBX = -1
        End If
        x = InStr(a, "$")
        If x <> 0 Then
            RBY = SVal(Extract(Mid(a, x + 1), "^"))
        Else
            RBY = -1
        End If
        x = InStr(a, "^")
        If x <> 0 Then
            RBPos = SVal(Mid(a, x + 1))
        Else
            RBPos = -1
        End If
        If Mid(Nyms(RBX, RBY), RBPos, Len(RBTag)) <> RBTag Then RBX = -1: RBY = -1
    End If
    If RBX = -1 Or RBY = -1 Or RBPos = -1 Then RBX = -1: RBY = -1: RBPos = -1
    RBNum = ""
    RBX = -1
    RBY = -1
    RBPos = -1
    For j = 0 To MaxNyms
        If Nyms(j, 0) = "" Then Exit For
        For k = 1 To 2
            If InStr(Nyms(j, k), RBTag) <> 0 Then
                y = 1
                x = InStr(Nyms(j, k), RBTag)
                While x <> 0
                    u = x - 20: If u < 1 Then u = 1
                    If InStr(1, Replace(Mid(Nyms(j, k), u, 30), " ", ""), "tag:" + RBTag, vbTextCompare) <> 0 Then
                        'Found tag
                        a = Trim(Extract(Mid(Nyms(j, k), x), vbCrLf))
                        RBX = j: RBY = k: RBPos = x
                        x = InStr(a, "#")
                        If x <> 0 Then RBNum = Mid(a, x)
                        Exit For
                    End If
                    y = x + 1
                    x = InStr(y, Nyms(j, k), RBTag)
                Wend
            End If
        Next k
        If RBX <> -1 Then Exit For
    Next j
    If RBX <> -1 Then
        RBTagLocation = RBTagLocation + RBTag + RBEnum + "%" + Trim(Str(RBX)) + "$" + Trim(Str(RBY)) + "^" + Trim(Str(RBPos)) + vbCrLf
    End If
    If FullRead Then
        If RBX = -1 Then
            Block = ""
        Else
            z = InStr(RBPos, Nyms(RBX, RBY), "---block", vbTextCompare)
            k = InStr(RBPos, Nyms(RBX, RBY), "---endblock", vbTextCompare)
            If (k < z Or z = 0) And k <> 0 Then z = k
            If z = 0 Then z = Len(Nyms(RBX, RBY)) + 1
            Block = Mid(Nyms(RBX, RBY), RBPos, z - RBPos)
        End If
    End If
    NymDataBusy = False
End Function

Public Sub TestMail(f, PGPFlag, SPAMFlag, MultiFlag)
    Dim Fltr(300) As String, a As String
    
    PGPFlag = False
    SPAMFlag = False
    MultiFlag = False
    x = ParseString(Cnf(4, 2), Fltr(), 300, False)
    On Error GoTo ErrorTestMail
    n = FreeFile
    Open f For Input As n
    l = LOF(n): If l > 4096 Then l = 4096
    a = LCase(Input(l, n))
    Close n: n = 0
    For i = 0 To x
        fs = "*" + LCase(Fltr(i)) + "*"
        If InStr(fs, "[") <> 0 Then Replace fs, "[", "[[]"
        If InStr(fs, "^") <> 0 Then Replace fs, "^", vbCrLf
        If a Like fs Then SPAMFlag = True: Exit For
    Next i
    If InStr(1, a, BeginPGP, vbTextCompare) + InStr(1, a, BeginSig, vbTextCompare) <> 0 Then PGPFlag = True
    If InStr(a, vbCrLf + "content-type: message/partial") Then MultiFlag = True
Exit Sub
ErrorTestMail:
    CloseFile n
End Sub
