' scr.bas											16Jan00 01:15
' Compiler: PowerBasic 3.00c
' Copyright (c) 2000 Potato Software        See Scribble.htm for GNU license


$cpu 80286
$string 32
$stack 16384
$option cntlbreak off
$error stack off
$error overflow off
$error numeric off    'causes hang if on
$error bounds off

DEFLNG A-Z

shared DOSMode, FDR$, outflag, errm$

ver$ = "0.9.1"

%wipekeep = 0
%wipedel = 1
%wipetip = 2
%maxfiles = 30

$include "const.inc"

'Data
fcount = 0
outflag = 1
wipeflag = %wipedel
recurseflag = 0
folderflag = 0
allflag = 0
passcount = 7
a$         = "===DB==="
dbSwitch$  = "/7                                  "    'Default Switches


dim c$(1), pth$(%maxfiles)
c$(0) = dbSwitch$
c$(1) = command$
	
FDR$ = string$(512, 0)  'FindData Record need 317 bytes at least


'Preamble
open "cons:" for output as 1
on error goto ErrorTrap

'Randomize
for i = 1 to len(c$(1))
	x = x + asc(mid$(c$(1), i, 1)) * i / 100
next i
randomize (timer + x)

'Get DOS Mode
a$ = curdir$
if GetShortName$ (a$) <> "" then DOSMode = 1

'Parse Command Line
if ltrim$(c$(1)) = "" then goto Help
for i = 0 to 1
	c$(i) = c$(i) + " "
	if instr(lcase$(c$(i)), "/k") <> 0 and instr(lcase$(c$(i)), "/t") <> 0 then
		print #1, "Parameters invalid: Cannot combine /K and /T switches"
		close
		system
	end if
	do
		c$(i) = ltrim$(c$(i))
		x = instr(c$(i), " ")
		y = instr(2, c$(i), "/")
		if y < x and y <> 0 then x = y
		if x = 0 then exit do
		a$ = left$(c$(i), x - 1)
		if left$(a$, 1) = chr$(34) then
			x = instr(2, c$(i), chr$(34)) + 1
			if x = 1 then x = len(c$(i)) + 2
			a$ = ltrim$(rtrim$(mid$(c$(i), 2, x - 3)))
		end if
		c$(i) = mid$(c$(i), x)
		if left$(a$, 1) = "/" then
			select case ucase$(mid$(a$, 2, 1))
			case "?"
Help:
				print #1, "Scribble  v"; ver$; "    (c) 2000 Potato Software    See Scribble.htm for license"
				print #1, "To wipe files...
				print #1, "Usage: SCRIBBLE [/n] [/A] [/K|/T] [/S] [/R] [/F] [/L:listfile] [filespec1]
				print #1, "                [filespec2] ..."
				print #1, spc(7); "filespecs  Pathnames of file(s) to be wiped, wildcards ok"
				print #1, spc(7); "/n         n = number of times to wipe each file  (default"; str$(passcount); ")"
				print #1, spc(7); "/A         Wipe system and read-only files too"
				print #1, spc(7); "/K         Keep files after wiping (for swap files, etc)"
				print #1, spc(7); "/T         Wipe tips (file slack) only (do not wipe files)"
				print #1, spc(7); "/R         Recurse folders  (be careful!)"
				print #1, spc(7); "/F         Remove empty folders"
				print #1, spc(7); "/L         Specifies text file containing list of files to be wiped,"
				print #1, spc(7); "           one per line"
				print #1, spc(7); "/S         Silent mode (no output)"
				print #1, ""
				print #1, "To wipe free space on a drive..."
				print #1, "Usage: SCRIBBLE [/n] [/K|/T] [/S] /E drive
				print #1, spc(7); "/E         Wipe free space on drive
				print #1, spc(7); "drive      Drive (such as D:) to wipe free space on"
				print #1, spc(7); "/n         n = number of times to wipe  (default"; str$(passcount); ")"
				print #1, spc(7); "/K         Keep temp files after wiping"
				print #1, spc(7); "/T         Also wipe all file tips (file slack) on drive"
				print #1, spc(7); "/S         Silent mode (no output)"
				print #1, ""
				close
				system
			case "K": wipeflag = %wipekeep
			case "T": wipeflag = %wipetip
			case "S": outflag = 0
			case "R": recurseflag = 1
			case "F": folderflag = 1
			case "A": allflag = 1
			case "L"
				listfile$ = ltrim$(mid$(a$, 3), ANY ": ")
			case "E"
				freeflag = 1
			case else
				x = int(abs(val(mid$(a$, 2))))
				if x > 0 then 
					passcount = x
				else
					print #1, "Invalid parameter: "; a$
					beep
					end
				end if
			end select
		elseif a$ <> "" and pthcount < %maxfiles then
			pth$(pthcount) = a$
			incr pthcount
		end if
	loop
next i

if freeflag = 1 then
	'Wipe Free Space
	pth$(0) = noslash$(pth$(0))
	if pthcount <> 1 or len(pth$(0)) <> 2 or right$(pth$(0), 1) <> ":" then
		print #1, "Invalid drive specification"
		beep
		end
	end if
	pth$(0) = ucase$(left$(pth$(0), 2))
	if outflag = 1 then
		print #1, spc(59); "Scribble v"; ver$
		a$ = "Wiping free space on drive " + pth$(0) + "  (" + ltrim$(str$(passcount)) + ")"
		if wipeflag = %wipekeep then 
			a$ = a$ + " [K]"
		elseif wipeflag = %wipetip then 
			a$ = a$ + " [T]"
		end if
		print #1, a$; spc(57 - len(a$) - len(ver$)); "[ Press ESC to Abort ]"
	end if

	'Generate Files
	errm$ = "Write error"
	redim bf$(500)
	if wipeflag = %wipetip then wipetipflag = 1: wipeflag = %wipedel
	if outflag = 1 then print #1, "  Creating <1GB segments"
	x = BigFile(pth$(0), wipeflag, bf$())
	if x = -1 or x = 0 then goto ErrorBye
	if passcount > 1 then
		if outflag = 1 then print #1, "  Wiping segments"
		for i = 0 to x - 1
			j = WipeFile(bf$(i), passcount - 1, wipeflag)
	  		if j = 1 then exit for
	  	next i
	else
		j = 0
	end if
	if wipeflag <> %wipekeep then
		on error resume next
		for i = 0 to x - 1
			kill bf$(i)
	  	next i
	  	on error goto ErrorTrap
	end if
  	if j = 1 then goto ErrorBye
  	if wipetipflag = 1 then
  		allflag = 1
		if outflag =1 then print #1, "  Wiping file tips on drive "; pth$(0)
		j = rewipe (pth$(0) + "\*.*", 1, %wipetip, 0)
  		if j = -1 then goto ErrorBye
  	end if
  	if outflag =1 then print #1, "Done."
else
	if outflag = 1 then
		print #1, spc(59); "Scribble v"; ver$
		select case wipeflag
		case %wipekeep: a$ = "  Wiping and keeping"
		case %wipedel: a$ = "  Wiping"
		case %wipetip: a$ = "  Wiping tips"
		end select
		a$ = a$ + "  (" + ltrim$(str$(passcount)) + ")"
		if recurseflag = 1 or allflag = 1 or folderflag = 1 then
			a$ = a$ + " ["
			if allflag = 1 then a$ = a$ + "A"
			if recurseflag = 1 then a$ = a$ + "R"
			if folderflag = 1 then a$ = a$ + "F"
			a$ = a$ + "]"
		end if
		print #1, a$; spc(57 - len(a$) - len(ver$)); "[ Press ESC to Abort ]"
	end if


	for i = 0 to 1
		if (i = 0 and pthcount <> 0) or (i = 1 and listfile$ <> "") then
			'Init
			if i = 0 then
				px = 0
			else
				if DOSMode = 1 then
					lf$ = GetShortName$(listfile$)
				else
					if dir$(listfile$) = "" then lf$ = "" else lf$ = listfile$
				end if
				if lf$ <> "" then
					lfn = OpenFile(lf$, "r", errm$)
					if lfn = 0 then lf$ = ""
				end if
				if lf$ = "" then
					print #1, "Cannot read list file: "; listfile$
					beep
				end if
			end if
			if i = 0 or (i = 1 and lf$ <> "") then
				do
					if i = 0 then
						p$ = pth$(px)
						incr px
					else
						p$ = ""
						do while not eof(lfn) and ltrim$(p$) = ""
							line input #lfn, p$
						loop
					end if
	
					if p$ <> "" then
						x = rewipe (p$, recurseflag, wipeflag, folderflag)
						if x = -1 then goto ErrorBye
						incr fcount, x
					end if
				loop until (i = 0 and px = pthcount) or p$ = ""
				if i = 1 then close lfn
			end if
		end if
	next i

	
	if outflag = 1 then
		print #1, " "; str$(fcount); " item"; left$("s", abs(fcount - 1)); " wiped"
	end if
end if


Done:
print #1, ""
a$ = FindLong$(chr$(4), 0, 0, l$, Att?)   'Close Find File Handle
close
end


ErrorTrap:
	errm$ = ErrMsg$ (err, eradr)
	resume ErrorBye
ErrorBye:
	if errm$ = "" then errm$ = ErrMsg$ (0, 0)
	print #1, "Fatal Error: "; errm$
	print #1, ""
goto Done




FUNCTION ReWipe(pathname$, recurse, wipemode, removedir)
	shared outflag, allflag, passcount
	
	redim fil$(0)
	
	d$ = plainname$(pathname$, 0)
	'Wipe files
	if allflag = 1 then
		'              ?xADVSHR
		AttAllow? = &b11100111 
	else
		AttAllow? = &b11100010
	end if
	x = GetDir(pathname$, AttAllow?, 0, fil$())
	for i = 0 to x - 1
		y = wipefile(fil$(i), passcount, wipemode)
		if y = 1 then rewipe = -1: exit function
		if y = 0 then incr fcount
	next i
	
	'Dummy Entries
	if fcount > 0 and wipemode <> %wipetip then Dummies d$, fcount + 2

	'Recurse sub
	if recurse <> 0 then
		'             ?xADVSHR
		AttAllow? = &b11110111
		AttReq?   = &b00010000
		ddcount = GetDir(d$ + "*.*", AttAllow?, AttReq?, fil$())
		for i = 0 to ddcount - 1
			x = rewipe (fil$(i) + "\" + plainname$(pathname$, 1), 1, wipemode, removedir)
			if x = -1 then rewipe = -1: exit function
			incr fcount, x
		next i
	end if
				
	'Remove Dir
	if removedir <> 0 and not (len(d$) = 3 and right$(d$, 2) = ":\")  and FindLong$(noslash$(d$), 255, 0, l$, Att?) <> "" and noslash$(d$) <> "" then 
		if DOSMode = 0 then
			sp$ = noslash$(d$)
		else
			sp$ = noslash$(GetShortName$(noslash$(d$)))
			if sp$ = "" then rewipe = -1: exit function
		end if
		Att? = attrib(noslash$(sp$))
		if (allflag = 0 or (Att? and &b00000101) = 0) and ((Att? and %Dmask) <> 0) then
			'Directory empty?
			'             ?xADVSHR
			AttAllow? = &b11110111
			ddcount = 0
			s$ = FindLong$(d$ + "*.*", AttAllow?, 0, l$, Att?)
			do while s$ <> ""
				if not ((Att? and %Dmask) <> 0 and (s$ = "." or s$ = "..")) then incr ddcount: exit do
				s$ = FindLong$("", AttAllow?, AttReq?, l$, Att?)
			loop
			if ddcount = 0 then
				'Remove Dir
				if outflag = 1 then print #1, "    "; d$
				attrib noslash$(sp$), %Dmask
				do
					a$ = plainname$(noslash$(d$), 0) + maketag$(8 + (DOSMode * 120)) + ".TMP"
				loop until FindLong$(a$, 255, 0, l$, Att?) = ""
				if RenameLong(noslash$(d$), a$) <> 0 then rewipe = -1: exit function
				if DOSMode = 1 then
					s$ = GetShortName$(a$)
					if s$ = "" then rewipe = -1: exit function
				else
					s$ = a$
				end if
				'Write Disk Buffers
				reg %AX, &h0D00
				call interrupt &h21
				rmdir s$
				incr fcount
				Dummies plainname$(noslash$(d$), 0), 2
			end if
		end if
	end if
	rewipe = fcount
END FUNCTION


FUNCTION WipeFile(pathname$, wipecount, wipemode)
	'wipemode = 
	'%wipekeep
	'%wipedel
	'%wipetip
	'Returns:  0 ok; 1 = error; 2 = access denied
	shared outflag
	
	bufflen?? = 32768
	dim buff??(16384)   'Word Unsigned Int
	buffseg?? = varseg (buff??(0))
	buffoff?? = varptr (buff??(0))

	on local error goto ErrorWipeFile1
	if outflag = 1 then print #1, "    "; pathname$; " ";
	
	if DOSMode = 1 then
		sp$ = GetShortName$(pathname$)
	else
		sp$ = pathname$
	end if

	copyto$ = sp$ + chr$(0)
	toseg?? = strseg (copyto$)
	tooff?? = strptr (copyto$)

	'Save/Clear Attributes
	on local error resume next
	Att? = attrib(sp$)
	attrib sp$, 0
	on local error goto ErrorWipeFile1

	'Open File
	tohandle?? = -1
	gosub OpenFileReadWrite
	if errcode& <> 0 then 
		if outflag = 1 then print #1, spc(10); "- %%%  ACCESS DENIED  %%%"
		WipeFile = 2
		on local error resume next
		attrib sp$, Att?
		exit function
	end if
	
	'Get Date
	if wipemode = %wipetip then
		handle?? = tohandle??
		gosub GetFileDate
	end if

	'Get Length
	seekh?? = 0
	seekl?? = 0
	seekorigin = 2  'end
	gosub FileSeek
	if errcode& <> 0 then goto ErrorWipeFile
	flenl?? = seekl??
	flenh?? = seekh??
	flen&& = seekl?? + (seekh?? * 65536)
	if flen&& > 2147483646 then errm$ = "File too big": goto ErrorWipeFile2

' print #1, flen&&
	'Wipe File
	for i = 1 to wipecount
		'Seek
		if wipemode = %wipekeep or wipemode = %wipedel then
			'Seek Start
			seekl?? = 0
			seekh?? = 0
			seekorigin = 0
		else
			'Seek Original End
			seekl?? = flenl??
			seekh?? = flenh??
			seekorigin = 0
		end if
		gosub FileSeek
		if errcode& <> 0 then goto ErrorWipeFile

		'Start Pass
		fp&& = 0
		wcount = 99
		do
			'Randomize Buffer
			if wcount > 20 then
				for j?? = 0 to 16384
					buff??(j??) = int(rnd(1) * 65536)
'''' TESTONLY buff??(j??) = asc(ltrim$(str$(i))) + 256 * asc(ltrim$(str$(i)))
				next j??
				wcount = 0
			end if

			if wipemode = %wipetip then exit do
			
			'Wipe Data
			if inkey$ = chr$(27) then Abort = 1: exit for
			if bufflen?? > flen&& - fp&& then
				wbytes?? = flen&& - fp&&
			else
				wbytes?? = bufflen??
			end if
			'gosub WriteFile
					reg %AX, &h4000
					reg %BX, tohandle??
					reg %CX, wbytes??
					reg %DX, buffoff??
					reg %DS, buffseg??
					call interrupt &h21
					if (reg(%FLAGS) and 1) = 0 then
						errcode& = 0
						byteswrit?? = reg(%AX)
					else
						errcode& = -reg(%AX)
					end if
' print #1, "Write "; i, fp&&, wbytes??, byteswrit??, errcode&
			if errcode& <> 0 or byteswrit?? <> wbytes?? then errm$ = "Write error": goto ErrorWipeFile2
			incr fp&&, byteswrit??
			incr wcount
		loop until fp&& = flen&&

		if inkey$ = chr$(27) then Abort = 1: exit for

		'Wipe 32K file tip
		wbytes?? = 512 - (flen&& mod 512)
		for j?? = 1 to 64
			'gosub WriteFile
					reg %AX, &h4000
					reg %BX, tohandle??
					reg %CX, wbytes??
					reg %DX, buffoff?? + (512 * (j?? - 1))
					reg %DS, buffseg??
					call interrupt &h21
					if (reg(%FLAGS) and 1) = 0 then
						errcode& = 0
						byteswrit?? = reg(%AX)
					else
						errcode& = -reg(%AX)
					end if
' print #1, "WriteTip "; j??, wbytes??, byteswrit??, errcode&
			if errcode& <> 0 or byteswrit?? <> wbytes?? then exit for
			wbytes?? = 512
		next j??

		'Write Disk Buffers
		reg %AX, &h0D00
		call interrupt &h21
' shell "copy " + pathname$ + " " + plainname$(pathname$, 0) + plainname$(pathname$, 2) + ltrim$(str$(i))
		if outflag = 1 then print #1, ".";
 	next i

	'Seek New End
	if wipemode = %wipedel and Abort = 0 then
		'Seek Start
		seekl?? = 0
		seekh?? = 0
	else
		'Seek Original End
		seekl?? = flenl??
		seekh?? = flenh??
	end if
	seekorigin = 0
	gosub FileSeek
	if errcode& <> 0 then goto ErrorWipeFile

	'Truncate file
	wbytes?? = 0
	gosub WriteFile
	if errcode& <> 0 then goto ErrorWipeFile

	if wipemode = %wipedel and Abort = 0 then
		'Set Date to 1/1/1980
		handle?? = tohandle??
		DOSFileTime = 0
		DOSFileDate = 1
		gosub SetFileDate
	elseif wipemode = %wipetip or Abort = 1 then
		'Set Date to Original
		handle?? = tohandle??
		gosub SetFileDate
	end if

	'Close File
	handle?? = tohandle??
	tohandle?? = -1
	gosub CloseFile
	if errcode& <> 0 then goto ErrorWipeFile

	if wipemode = %wipedel and Abort = 0 then
		'Rename File
		do
			a$ = plainname$(noslash$(sp$), 0) + maketag$(8 + (DOSMode * 120)) + ".TMP"
		loop until FindLong$(a$, 255, 0, l$, Att?) = ""
		if RenameLong(noslash$(sp$), a$) <> 0 then errm$ = "Error renaming file " + sp$: goto ErrorWipeFile2

		'Write Disk Buffers
		reg %AX, &h0D00
		call interrupt &h21
		if DeleteLong(a$) <> 0 then errm$ = "Error deleting file " + a$: goto ErrorWipeFile2
	else
		'Restore attributes
		attrib sp$, Att?
	end if
	if Abort = 1 then errm$ = "User aborted": goto ErrorWipeFile2
	if outflag = 1 then print #1, ""
	wipefile = 0
exit function
ErrorWipeFile1:
	errm$ = ErrMsg$(err, eradr)
	resume ErrorWipeFile2
ErrorWipeFile:
	errm$ = ErrMsg$(errcode&, 0)
ErrorWipeFile2:
	if tohandle?? <> -1 then
		'Close File
		handle?? = tohandle??
		tohandle?? = -1
		gosub CloseFile
	end if
	if outflag = 1 then print #1, ""
	wipefile = 1
exit function

OpenFileReadWrite:
	'INT 21 - DOS 2+ - "OPEN" - OPEN EXISTING FILE
	'AH = 3Dh
	'AL = access and sharing modes (see #01402)
	'DS:DX -> ASCIZ filename
	'CL = attribute mask of files to look for (server call only)
	'Return: CF clear if successful
	'    AX = file handle
	'  	 CF set on error
	'    AX = error code (01h,02h,03h,04h,05h,0Ch,56h) (see #01680 at AH=59h)
	reg %AX, &h3D02
	reg %DX, tooff??
	reg %DS, toseg??
	reg %CX, 0
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
		tohandle?? = reg(%AX)
	else
		errcode& = -reg(%AX)
		tohandle?? = -1
	end if
return		    		    

FileSeek:
	'INT 21 - DOS 2+ - "LSEEK" - SET CURRENT FILE POSITION
	'	AH = 42h
	'	AL = origin of move
	'	    00h start of file
	'	    01h current file position
	'	    02h end of file
	'	BX = file handle
	'	CX:DX = (signed) offset from origin of new file position
	'Return: CF clear if successful
	'	    DX:AX = new file position in bytes from start of file
	'	CF set on error
	'	    AX = error code (01h,06h) (see #01680 at AH=59h/BX=0000h)
	reg %AX, &h4200 + seekorigin
	reg %BX, tohandle??
	reg %CX, seekh??
	reg %DX, seekl??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
		seekl?? = reg(%AX)
		seekh?? = reg(%DX)
	else
		errcode& = -reg(%AX)
	end if
return

WriteFile:		'(wbytes)
	'INT 21 - DOS 2+ - "WRITE" - WRITE TO FILE OR DEVICE
	'	AH = 40h
	'	BX = file handle
	'	CX = number of bytes to write
	'	DS:DX -> data to write
	'Return: CF clear if successful
	'	    AX = number of bytes actually written
	'	CF set on error
	'	    AX = error code (05h,06h) (see #01680 at AH=59h/BX=0000h)
	'Notes:	if CX is zero, no data is written, and the file is truncated or
	'	  extended to the current position
	'	data is written beginning at the current file position, and the file
	'	  position is updated after a successful write
	'	for FAT32 drives, the file must have been opened with AX=6C00h with
	'	  the "extended size" flag in order to expand the file beyond 2GB;
	'	  otherwise the write will fail with error code 0005h (access denied)
	'	the usual cause for AX < CX on return is a full disk
	'BUG:	a write of zero bytes will appear to succeed when it actually failed
	'	  if the write is extending the file and there is not enough disk
	'	  space for the expanded file (DOS 5.0-6.0); one should therefore check
	'	  whether the file was in fact extended by seeking to 0 bytes from
	'	  the end of the file (INT 21/AX=4202h/CX=0000h/DX=0000h)
	'	under the FlashTek X-32 DOS extender, the pointer is in DS:EDX
	reg %AX, &h4000
	reg %BX, tohandle??
	reg %CX, wbytes??
	reg %DX, buffoff??
	reg %DS, buffseg??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
		byteswrit?? = reg(%AX)
	else
		errcode& = -reg(%AX)
	end if
return

CloseFile:		'(handle)
	reg %AX, &h3E00
	reg %BX, handle??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
	else
		errcode& = -reg (%AX)
	end if
return

SetFileDate:     '(handle, DOSFileTime, DOSFileDate)
	'INT 21 - DOS 2+ - SET FILE'S LAST-WRITTEN DATE AND TIME
	'    AX = 5701h
	'    BX = file handle
	'    CX = new time (see #01665)
	'    DX = new date (see #01666)
	'Return: CF clear if successful
	'    CF set on error
	'        AX = error code (01h,06h) (see #01680)
	reg %AX, &h5701
	reg %BX, handle??
	reg %CX, DOSFileTime
	reg %DX, DOSFileDate
	call interrupt &h21
return

GetFileDate:    '(handle)
	'INT 21 - DOS 2+ - GET FILE'S LAST-WRITTEN DATE AND TIME
	'    AX = 5700h
	'    BX = file handle
	'Return: CF clear if successful
	'        CX = file's time (see #01665)
	'        DX = file's date (see #01666)
	'    CF set on error
	'        AX = error code (01h,06h) (see #01680)
	reg %AX, &h5700
	reg %BX, handle??
	call interrupt &h21
	if (reg (%FLAGS) and 1) = 0 then
		DOSFileTime = reg(%CX)
		DOSFIleDate = reg(%DX)
	else
		DOSFileTime = 0
		DOSFileDate = 1
	end if
return
END FUNCTION


SUB Dummies(dpath$, d)
	'Create And Delete d Dummy Directory Entries
	redim df$(d)
	for i = 0 to d - 1
		do
			a$ = plainname$(noslash$(dpath$), 0) + maketag$(8 + (DOSMode * 120)) + ".TMP"
		loop until FindLong$(a$, 255, 0, l$, Att?) = ""
		copyto$ = a$ + chr$(0)
		toseg?? = strseg (copyto$)
		tooff?? = strptr (copyto$)
		gosub OpenFileWrite
		if errcode& = 0 then
			df$(dcount) = a$
			incr dcount
			'Set Date 1/1/80
				reg %AX, &h5701
				reg %BX, tohandle??
				reg %CX, 0
				reg %DX, 1
				call interrupt &h21
			handle?? = tohandle??
			gosub CloseFile2
		end if
	next i
	'Delete files
	for i = 0 to dcount -1
		DeleteLong df$(i)
	next i
exit sub
OpenFileWrite:
	if DOSMode = 0 then
		'Create File
		reg %AX, &h3C00
		reg %CX, 0			'Attributes
		reg %DX, tooff??
		reg %DS, toseg??
	else
		reg %AX, &h716C
	              'x01xx000ISSS?AAA
	    reg %BX, &b0010000010100001
		reg %CX, 0
		reg %DX, &b10010  'Create and truncate
		reg %DS, toseg??
		reg %SI, tooff??
		reg %DI, 1
	end if
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
		tohandle?? = reg(%AX)
	else
		errcode& = -reg(%AX)
	end if
return
CloseFile2:		'(handle)
	reg %AX, &h3E00
	reg %BX, handle??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
	else
		errcode& = -reg (%AX)
	end if
return
END SUB


FUNCTION BigFile(dpath$, wipeflag, fil$())
	on local error goto ErrorBigFile1
	bufflen?? = 32768
	dim buff??(16384)
	buffseg?? = varseg (buff??(0))
	buffoff?? = varptr (buff??(0))

	fs&& =  FreeSpaceLong&& (noslash$(dpath$), secperclu???, bytpersec???, availclu???)
	if fs&& = -1 or bytpersec??? = 0 then bytpersec??? = 512

	do
		do
			a$ = noslash$(dpath$) + "\" + maketag$(8) + ".FRE"
		loop until dir$(a$) = ""
		copyto$ = a$ + chr$(0)
		toseg?? = strseg (copyto$)
		tooff?? = strptr (copyto$)

		if outflag = 1 then print #1, "    "; a$; " ";
		
		'Create File
		gosub CreateFile
		if errcode& <> 0 then goto ErrorBigFile

		fil$(filcount) = a$	
		incr filcount 
		
		'Write Data
		wcount = 9999
		fp&& = 0
		fs&& = int(1073741824 / bytpersec???) * bytpersec???
		blen?? = bufflen??
		do
			if wcount > 312 then   'Display a dot and refresh data every 10M
				'Randomize Buffer
				for j?? = 0 to 16384
					buff??(j??) = int(rnd(1) * 65536)
				next j??
				if outflag = 1 then print #1, ".";
				wcount = 0
			end if
			if blen?? > fs&& - fp&& and blen?? <> 512 then
				wbytes?? = fs&& - fp&&
			else
				wbytes?? = blen??
			end if
' print "Write "; fp&&, wbytes??
			'gosub WriteFile
					reg %AX, &h4000
					reg %BX, tohandle??
					reg %CX, wbytes??
					reg %DX, buffoff??
					reg %DS, buffseg??
					call interrupt &h21
					if (reg(%FLAGS) and 1) = 0 then
						errcode& = 0
						byteswrit?? = reg(%AX)
					else
						errcode& = -reg(%AX)
					end if
			if errcode& <> 0 then errm$ = "Write error": goto ErrorBigFile2
			if byteswrit?? <> wbytes?? or byteswrit?? = 0 then
				if blen?? = 512 then
					isdone = 1
					exit do
				else
					blen?? = 512
				end if
			end if
			incr fp&&, byteswrit??
			if blen?? <> 512 then incr wcount
			if inkey$ = chr$(27) then
				errm$ = "User aborted"
				goto ErrorBigFile2
			end if
		loop until fp&& = fs&&

		'Close File
		gosub CloseFile3
		if errcode& <> 0 then goto ErrorBigFile
		if outflag = 1 then print #1, ""
	loop until isdone = 1
	BigFile = filcount
exit function
ErrorBigFile1:
	errm$ = ErrMsg$(err, eradr)
	resume ErrorBigFile2
ErrorBigFile:
	errm$ = ErrMsg$(errcode&, 0)
ErrorBigFile2:
	if tohandle?? <> -1 then
		'Close File
		gosub CloseFile3
	end if
	if outflag = 1 then print #1, ""
	BigFile = -1
	if wipeflag <> %wipekeep then
		on local error resume next
		for i = 0 to filcount - 1
			kill fil$(i)
		next i
	end if
exit function
CreateFile:
	reg %AX, &h3C00
	reg %CX, 0			'Attributes
	reg %DX, tooff??
	reg %DS, toseg??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
		tohandle?? = reg(%AX)
	else
		errcode& = -reg(%AX)
	end if
return
CloseFile3:		'(handle)
	reg %AX, &h3E00
	reg %BX, tohandle??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
	else
		errcode& = -reg (%AX)
	end if
return
END FUNCTION


FUNCTION FreeSpaceLong&& (drive$, secperclu???, bytpersec???, availclu???)
	'Gets free space;  (over 2GB doesn't work right)
	'Uses compression estimates
	'Returns free bytes if ok, -1 if error

	on local error resume next
	if DOSMode = 0 then
		REG %AX, &h3600
		REG %DX, asc(ucase$(left$(drive$, 1))) - 64 	'DL = drive (C=3)
		call interrupt &h21
		secperclu1?? = REG (%AX)
		availclu1?? = REG (%BX)
		bytpersec1?? = REG (%CX)
		cluperdrv?? = REG (%DX)

		secperclu??? = secperclu1??
		availclu??? = availclu1??
		bytpersec??? = bytpersec1??
		FreeSpaceLong&& = secperclu??? * bytpersec??? * availclu???
	else
		drv$ = ucase$(extract$ (drive$, ":")) + ":\" + chr$(0)
	
		'Set up data
		drvoff?? = STRPTR (drv$)
		drvseg?? = STRSEG (drv$)
	
		BUFF$ = string$(256, 0)  'Buffer needs 44 bytes at least
		BUFFoff?? = STRPTR (BUFF$)
		BUFFseg?? = STRSEG (BUFF$)
	
		'INT 21 - Windows95 - FAT32 - GET EXTENDED FREE SPACE ON DRIVE
		'	AX = 7303h
		'	DS:DX -> ASCIZ string for drive ("C:\" or "\\SERVER\Share")
		'	ES:DI -> buffer for extended free space structure (see #01789)
		'	CX = length of buffer for extended free space
		'Return: CF clear if successful
		'	    ES:DI buffer filled
		'	CF set on error
		'	    AX = error code
		'Notes:	this function reportedly returns a maximum of 2GB free space even on
		'	  an FAT32 partition larger than 2GB under some versions of Win95,
		'	  apparently by limiting the number of reported free clusters to no
		'	  more than 64K
		'	on DOS versions which do not support the FAT32 calls, this function
		'	  returns CF clear/AL=00h (which is the DOS v1+ method for reporting
		'	  unimplemented functions)
		'Format of extended free space structure:
		'Offset	Size	Description	(Table 01789)
		' 00h	WORD	(ret) size of returned structure
		' 02h	WORD	(call) structure version (0000h)
		'		(ret) actual structure version (0000h)
		' 04h	DWORD	number of sectors per cluster (with adjustment for compression)
		' 08h	DWORD	number of bytes per sector
		' 0Ch	DWORD	number of available clusters
		' 10h	DWORD	total number of clusters on the drive
		' 14h	DWORD	number of physical sectors available on the drive, without
		'		  adjustment for compression
		' 18h	DWORD	total number of physical sectors on the drive, without
		'		  adjustment for compression
		' 1Ch	DWORD	number of available allocation units, without adjustment
		'		  for compression
		' 20h	DWORD	total allocation units, without adjustment for compression
		' 24h  8 BYTEs	reserved
	
		reg %AX, &h7303
		reg %DS, drvseg??
		reg %DX, drvoff??
		reg %ES, BUFFseg??
		reg %DI, BUFFoff??
		reg %CX, &hFF
		call interrupt &h21
		if (reg(%FLAGS) and 1) = 0 then 
			def seg = BUFFseg??
			secperclu??? = peekl(BUFFoff?? + &h04)
			bytpersec??? = peekl(BUFFoff?? + &h08)
			availclu??? = peekl(BUFFoff?? + &h0C)
			FreeSpaceLong&& = secperclu??? * bytpersec??? * availclu???
		else 
			FreeSpaceLong&& = -1
		end if
	end if
END FUNCTION


FUNCTION GetDir(pathname$, AttAllow?, AttReq?, fil$())
	'Count Files
	fc = 0
	d$ = plainname$(pathname$, 0)
	s$ = FindLong$(pathname$, AttAllow?, AttReq?, l$, Att?)
	while s$ <> ""
		if (Att? and AttReq?) = AttReq? and (Att? and not(AttAllow?)) = 0 and not ((Att? and %Dmask) <> 0 and (s$ = "." or s$ = "..")) then incr fc
		s$ = FindLong$("", AttAllow?, AttReq?, l$, Att?)
	wend
	redim fil$(fc)
	s$ = FindLong$(pathname$, AttAllow?, AttReq?, l$, Att?)
	do while s$ <> ""
		if (Att? and AttReq?) = AttReq? and (Att? and not(AttAllow?)) = 0 and not ((Att? and %Dmask) <> 0 and (s$ = "." or s$ = "..")) then
			fil$(fx) = d$ + l$
			incr fx
			if fx = fc then exit do
		end if
		s$ = FindLong$("", AttAllow?, AttReq?, l$, Att?)
	loop
	GetDir = fx
END FUNCTION


FUNCTION FindLong$(pathname$, AttAllow?, AttReq?, LongName$, Att?)
	'Should call with pathname$ = chr$(4) when done
	'Warning:  Ignores bits 0 and 5  (R and A)
	static ffhandle??
	shared FDR$

	'Set up data
	FDRoff?? = STRPTR (FDR$)
	FDRseg?? = STRSEG (FDR$)
	if DOSMode = 0 then
		if pathname$ <> "" then
			'SetDTA				21h set DTA Address
			REG %AX, &h1A00
			REG %DX, FDRoff??
			REG %DS, FDRseg??
			call interrupt &h21
		end if
		'GetDTA
		REG %AX, &h2F00
		call interrupt &h21
		DTAoff?? = REG (%BX)
		DTAseg?? = REG (%ES)
		def seg = DTAseg??
	end if
	errcode& = 0

	if pathname$ <> "" then
		if pathname$ = chr$(4) then
			'Close Search Handle
			errcode& = -1
		else
			'Find First
			if DOSMode = 1 and ffhandle?? <> 0 then gosub FindCloseLong
			ffhandle?? = 0
			f$ = pathname$ + chr$(0)
			Foff?? = STRPTR (f$)
			Fseg?? = STRSEG (f$)
			gosub FindFirstLong
		end if
	else
		'Find Next
		if ffhandle?? = 0 and DOSMode = 1 then
			errcode& = -1
		else
			gosub FindNextLong
		end if
	end if
	if errcode& <> 0 then
		s$ = ""
		l$ = ""
		if DOSMode = 1 and ffhandle?? <> 0 then gosub FindCloseLong
		ffhandle?? = 0
	else
		gosub ReadFDR
	end if
	FindLong$ = s$
	LongName$ = l$
exit function			
FindFirstLong:
	if DOSMode = 0 then
		REG %AX, &h4E00
		REG %CX, AttAllow?
		REG %DX, Foff??
		REG %DS, Fseg??
		call interrupt &h21
		errcode& = REG (%AX)
	else
		'INT 21 - Windows95 - LONG FILENAME - FIND FIRST MATCHING FILE
		'    AX = 714Eh
		'    CL = allowable-attributes mask (see #01420 at AX=4301h)  ?xADVSHR
		'          (bits 0 and 5 ignored)
		'    CH = required-attributes mask (see #01420)
		'    SI = date/time format (see #01778)
		'    DS:DX -> ASCIZ filespec (both "*" and "*.*" match any filename)
		'    ES:DI -> FindData record (see #01779)
		'Return: CF clear if successful
		'        AX = filefind handle (needed to continue search)
		'        CX = Unicode conversion flags (see #01780)
		'    CF set on error
		'        AX = error code
		'        7100h if function not supported
		reg %AX, &h714E
		reg %CX, ((AttReq? * 256) + AttAllow?)
		reg %SI, &h0001
		reg %DS, Fseg??
		reg %DX, Foff??
		reg %ES, FDRseg??
		reg %DI, FDRoff??	
		call interrupt &h21
		if (reg(%FLAGS) and 1) = 0 then
			errcode& = 0
			ffhandle?? = reg(%AX)
		else
			errcode& = reg(%AX)
		end if
	end if
return

FindNextLong:
	if DOSMode = 0 then
		REG %AX, &h4F00
		call interrupt &h21
		errcode& = REG (%AX)
	else
		'INT 21 - Windows95 - LONG FILENAME - FIND NEXT MATCHING FILE
		'    AX = 714Fh
		'    BX = filefind handle (from AX=714Eh)
		'    SI = date/time format (see #01778)
		'    ES:DI -> buffer for FindData record (see #01779)
		'Return: CF clear if successful
		'        AH = 4Fh (undocumented)
		'        AL destroyed (becomes low byte of filefind handle in Win95B)
		'        CX = Unicode conversion flags (see #01780)
		'    CF set on error
		'        AX = error code
		'        7100h if function not supported
		reg %AX, &h714F
		reg %BX, ffhandle??
		reg %SI, &h0001
		reg %ES, FDRseg??
		reg %DI, FDRoff??
		call interrupt &h21
		if (reg(%FLAGS) and 1) = 0 then
			errcode& = 0
		else
			errcode& = reg(%AX)
		end if
	end if
return

ReadFDR:
	if DOSMode = 0 then
		'Read DTA
		s$ = extract$(PEEK$(DTAoff?? + 30, 12),CHR$(0))
		l$ = s$
		Att? = PEEK(DTAoff?? + 21)
		'ModTime% = PEEKI(DTAoff?? + 22)
		'ModDate% = PEEKI(DTAoff?? + 24)
		'fs&& = PEEKL(DTAoff?? + 26)
		'CreatedTime% = 0
		'CreatedDate% = 0
		'LastTime% = 0
		'LastDate% = 0
	else
		'Format of Windows95 long filename FindData record:
		'Offset  Size    Description (Table 01779)
		' 00h    DWORD   file attributes
		'        bits 0-6 standard DOS attributes (see #01420 at INT 21/AX=4301h)
		'        bit 8: temporary file
		' 04h    QWORD   file creation time (number of 100ns intervals since 1/1/1601)
		' 0Ch    QWORD   last access time
		' 14h    QWORD   last modification time
		' 1Ch    DWORD   file size (high 32 bits)
		' 20h    DWORD   file size (low 32 bits)
		' 24h  8 BYTEs   reserved (apparently unused)
		' 2Ch 260 BYTEs  ASCIZ full filename
		'130h 14 BYTEs   ASCIZ short filename (for backward compatibility)
		'Note:   under Windows95B, the ASCIZ short filename will be the empty string
		'      if the directory does not contain a long filename entry for the
		'      file; in that case, the application should use the full filename
		def seg = FDRseg??
		'AHSR
		Att? = peek(FDRoff??)  'peeki(FDRoff??)
		'CreatedTime% = peeki(FDRoff?? + &h04)
		'CreatedDate% = peeki(FDRoff?? + &h06)
		'LastTime% =    peeki(FDRoff?? + &h0C)
		'LastDate% =    peeki(FDRoff?? + &h0E)
		'ModTime% =     peeki(FDRoff?? + &h14)
		'ModDate% =     peeki(FDRoff?? + &h16)
		'FileSizeH??? =   peekL(FDRoff?? + &h1C)
		'FileSizeL??? =   peekL(FDRoff?? + &h20)
		l$ = extract$(peek$(FDRoff?? + &h2C, 260), chr$(0))
		s$ = extract$(peek$(FDRoff?? + &h130, 14), chr$(0))
		if s$ = "" then s$ = l$
		'fs&& = (FileSizeH??? * (2^32)) + FileSizeL???
	end if
return

FindCloseLong:
'	INT 21 - Windows95 - LONG FILENAME - "FindClose" - TERMINATE DIRECTORY SEARCH
'	    AX = 71A1h
'	    BX = filefind handle (from AX=714Eh)
'	Return: CF clear if successful
'	    CF set on error
'	       AX = error code
'	        7100h if function not supported
'	Notes:  this function must be called after starting a search with AX=714Eh,
'	      to indicate that the search handle returned by that function will
'	      no longer be used
'	    this function is only available when IFSMgr is running, not under bare
'	      MS-DOS 7
	reg %AX, &h71A1
	reg %BX, ffhandle??
	call interrupt &h21
return
END FUNCTION


FUNCTION GetShortName$ (pathname$)
	'Return DOS 8.3 filename of pathname$ or "" if error

	'Set up data
	f$ = pathname$ + chr$(0)
	Foff?? = STRPTR (f$)
	Fseg?? = STRSEG (f$)

	BUFF$ = string$(256, 0)  'Buffer needs 128 bytes at least
	BUFFoff?? = STRPTR (BUFF$)
	BUFFseg?? = STRSEG (BUFF$)

'	INT 21 - Windows95 - LONG FILENAME - GET SHORT (8.3) FILENAME FOR FILE
'	    AX = 7160h
'	    CL = 01h
'	    CH = SUBST expansion flag
'	        00h return a path containing true path for a SUBSTed drive letter
'	        80h return a path containing the SUBSTed drive letter
'	    DS:SI -> ASCIZ long filename or path
'	    ES:DI -> 67-byte (possibly 128-byte) buffer for short filename
'	Return: CF set on error
'	        AX = error code
'	        02h invalid component in directory path or drive letter only
'	        03h malformed path or invalid drive letter
'	        ES:DI buffer unchanged
'	    CF clear if successful
'	        ES:DI buffer filled with equivalent short filename (full path,
'	          even if relative path given, and all uppercase)
	reg %AX, &h7160
	reg %CX, &h8001
	reg %DS, Fseg??
	reg %SI, Foff??
	reg %ES, BUFFseg??
	reg %DI, BUFFoff??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		errcode& = 0
		GetShortName$ = extract$(BUFF$, chr$(0))
	else
		GetShortName$ = ""
	end if
END FUNCTION


FUNCTION RenameLong (pathname1$, pathname2$)
	'Renames file or dir with Win95 long pathname
	'May be renamed to different path but not across disks
	'Returns 0 if ok

	if DOSMode = 0 then RenameLong = ShortDOS (0, pathname1$, pathname2$): exit function
	
	'Set up data
	f1$ = pathname1$ + chr$(0)
	F1off?? = STRPTR (f1$)
	F1seg?? = STRSEG (f1$)
	f2$ = pathname2$ + chr$(0)
	F2off?? = STRPTR (f2$)
	F2seg?? = STRSEG (f2$)

'	INT 21 - Windows95 - LONG FILENAME - RENAME FILE
'		AX = 7156h
'		DS:DX -> ASCIZ old file or directory name (long names allowed)
'		ES:DI -> ASCIZ new name (long names allowed)
'	Return: CF clear if successful
'		CF set on error
'		    AX = error code
'			7100h if function not supported
'	Note:	the file may be renamed into a different directory, but not across
'		  disks
	reg %AX, &h7156
	reg %DS, F1seg??
	reg %DX, F1off??
	reg %ES, F2seg??
	reg %DI, F2off??
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		RenameLong = 0
	else
		RenameLong = -reg(%AX)
	end if
END FUNCTION


FUNCTION DeleteLong (filename$)
	'Deletes single file with Win95 long pathname
	'Returns 0 if ok, 1 if error

	if DOSMode = 0 then DeleteLong = ShortDOS (1, filename$, ""): exit function

	'Set up data
	f$ = filename$ + chr$(0)
	Foff?? = STRPTR (f$)
	Fseg?? = STRSEG (f$)

'	INT 21 - Windows95 - LONG FILENAME - DELETE FILE
'		AX = 7141h
'		DS:DX -> ASCIZ long name of file to delete
'		SI = wildcard and attributes flag
'			0000h wildcards are not allowed, and search attributes are
'				ignored
'			0001h wildcards are allowed, and only files with matching
'				names and attributes are deleted
'		CL = search attributes
'		CH = must-match attributes
'	Return: CF clear if successful
'		CF set on error
'		    AX = error code (see #01680)
'			7100h if function not supported
'	Note:	for compatibility with DOS versions prior to v7.00, the carry flag
'		  should be set on call to ensure that it is set on exit
	reg %AX, &h7141
	reg %DS, Fseg??
	reg %DX, Foff??
	reg %SI, &h0000
	call interrupt &h21
	if (reg(%FLAGS) and 1) = 0 then
		DeleteLong = 0
	else
		DeleteLong = -reg(%AX)
	end if
END FUNCTION


FUNCTION OpenFile (pathname$, opentype$, e$)
	on local error goto ErrorOpen
	n = freefile
	select case opentype$
	case "w": open pathname$ for output as n
	case "a": open pathname$ for append as n
	case "r": open pathname$ for input as n
	case "b": open pathname$ for binary as n
	case else
		n = 0
		e$ = ErrMsg$(0, 0)
	end select
	OpenFile = n
exit function
ErrorOpen:
	e$ = ErrMsg$(err, eradr)
	OpenFile = 0
	resume ErrorOpen2
ErrorOpen2:
END FUNCTION


FUNCTION PlainName$ (Pathname$, Job)
	a$ = Pathname$
	while instr(a$, "\") <> 0
		a$ = right$(a$, len(a$) - instr(a$, "\"))
	wend
	y = 0
	do
		x = instr(y + 1, a$, ".")
		if x <> 0 then y = x
	loop until x = 0
	select case job
	case 0 'Returns Path (includes trailing slash)
		Plainname$ = left$(pathname$, len(pathname$) - len(a$))
	case 1 'Returns Filename
		Plainname$ = a$
	case 2 'Returns Name
		if y = 0 then
			Plainname$ = a$
		else
			Plainname$ = mid$(a$, 1, y - 1)
		end if
	case 3 'Returns Extension
		if y = 0 then
			Plainname$ = ""
		else
			Plainname$ = mid$(a$, y + 1)
		end if
	end select
END FUNCTION


FUNCTION MakeTag$ (ln)
	b$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"
	for i = 1 to ln
		a$ = a$ + mid$(b$, int(rnd(1) * 36) + 1, 1)
	next i
	MakeTag$ = a$
END FUNCTION


FUNCTION NoSlash$ (a$)
	a$ = ltrim$(rtrim$(a$))
	NoSlash$ = rtrim$ (a$, "\")
END FUNCTION


FUNCTION ErrMsg$ (errnum&, erraddress)
	'Negative errnum& indicates DOS extended error code
	'Positive errnum& is PB error code
	select case errnum&
	case 7, 14, 201, -8
		a$ = "Out of memory"
	case 53, -2
		a$ = "File not found"
	case 76, -3
		a$ = "Path not found"
	case 70, -5, -32, -33
		a$ = "Permission denied"
	case 75, -82
		a$ = "Path/File access error"
	case 74
		a$ = "Rename across disks"
	case 72, -26
		a$ = "Disk media error"
	case 71, -21
		a$ = "Drive not ready"
	case 61
		a$ = "Disk full"
	case -29, -30
		a$ = "Read/Write fault"
	case -19
		a$ = "Disk write-protected"
	case -15
		a$ = "Invalid drive"
	case -&h7100
		a$ = "Function not supported"
	case else
		a$ = "Undescribed error " + ltrim$(str$(errnum&))
	end select
	if erraddress <> 0 and errnum& > 0 then a$ = a$ + " @" + ltrim$(str$(erraddress))
	ErrMsg$ = a$
END FUNCTION


FUNCTION ShortDOS (Job, p1$, p2$)
	on local error goto ErrorShortDOS
	select case Job
	case 0
		name p1$ as p2$
	case 1
		kill p1$
	case 2
		mkdir p1$
	case 3
		chdir p1$
	end select
	ShortDOS = 0
exit function
ErrorShortDOS:
	ShortDOS = err
	resume ErrorShortDOS2
ErrorShortDOS2:
END FUNCTION


$if 0
print "..."
do
	b$ = inkey$
loop until b$ <> ""	
$endif
