Attribute VB_Name = "Prep"
'Copyright 1999 Potato Software.   See MAIN.BAS and LICENSE.TXT.

Public Function Remailer(r, rtype, rname, raddress, roptions, lathist, rlatent, uphist, rup, Optional rstringx, Optional rstats) As Boolean
    Dim rname2 As String, raddress2 As String, roptions2 As String
    Dim Found As Boolean
    'rtype = 0 cpunk
    '        1 mix
    '        else don't care (no stats returned)
    
    rname = "": raddress = "": roptions = "": rstats = ""
    rlatent = "": rup = "": lathist = "": uphist = "": rstringx = ""
    Remailer = False
    r = Trim(r)
    If r = "" Then Exit Function
    If InStr(r, "@") <> 0 Then raddress = r Else rname = LCase(r)
    
    'Search Type2.lis
    If rtype <> 0 Then
        r2 = r
        x = Type2(r2, rname2, raddress2, rkey, roptions2)
        If x <> 0 Then
            rname = rname2: raddress = raddress2: roptions = roptions2
            Found2 = True
        End If
    End If
    
    'Search Remailer Strings
    x = 0: Found = False
    Do While RString(x) <> ""
        RemailerString RString(x), rname2, raddress2, roptions2
        If (rtype = 0 And InStr(roptions2, " cpunk ") <> 0) Or (rtype = 1 And InStr(roptions2, " mix ") <> 0) Or (rtype <> 0 And rtype <> 1) Then
            If rname <> "" Then
                If rname = rname2 Then Found = True: Exit Do
            Else
                If LCase(raddress) = LCase(raddress2) Then Found = True: Exit Do
            End If
        End If
        x = x + 1: If x > MaxRemailers Then Exit Do
    Loop
    If Found And Not Found2 Then
        rname = rname2
        raddress = raddress2
    End If
    If Found Then
        roptions = roptions2
        rstringx = RString(x)
    End If
    Remailer = (rtype <> 1 And Found) Or Found2

    'Search Stats
    If rname <> "" And (Found Or Found2) Then
        rt = rtype: If rt <> 0 And rt <> 1 Then rt = 0
        x = 1
        Do While RemStats(rt, x) <> ""
            If InStr(1, RemStats(rt, x), rname, vbTextCompare) = 1 Then
                'NNNNNNNNNNNN LLLLLLLLLLLL  99:99   UUUUUUUUUUUU  %%%%%%%
                '123456789012345678901234567890123456789012345678901234567890
                rlatent = Mid(RemStats(rt, x), 28, 5)
                rup = Extract(Mid(RemStats(rt, x), 50, 6), "%")
                lathist = Mid(RemStats(rt, x), 14, 12)
                uphist = Mid(RemStats(rt, x), 36, 12)
                rstats = RemStats(rt, x)
                Exit Function
            End If
            x = x + 1: If x > MaxRemailers Then Exit Do
        Loop
    End If
End Function

Public Sub RemailerString(r, rname, raddress, roptions)
    a = Trim(r)
    If LCase(Left(a, 9)) <> "$remailer" Or InStr(a, "{") = 0 Or InStr(a, "=") = 0 Then rname = "": raddress = "": roptions = "": Exit Sub
    If InStr(a, "&quot;") <> 0 Then a = Replace(a, "&quot;", Chr(34))
    x = InStr(a, "=")
    rname = Mid(a, 10, x - 10)
    rname = Replace(rname, "{", "")
    rname = Replace(rname, "}", "")
    rname = Replace(rname, "'", "")
    rname = Replace(rname, Chr(34), "")
    rname = Trim(LCase(rname))
    b = Mid(a, x + 1)
    If InStr(b, "&lt;") <> 0 Then b = Replace(b, "&lt;", "<")
    If InStr(b, "&gt;") <> 0 Then b = Replace(b, "&gt;", ">")
    x = InStr(b, "<")
    Y = InStr(b, ">")
    If x * Y = 0 Then raddress = "": rname = "": roptions = "": Exit Sub
    raddress = Trim(Mid(b, x + 1, Y - x - 1))
    roptions = LCase(Mid(b, Y + 1))
    roptions = Replace(roptions, ";", "")
    roptions = Replace(roptions, "'", "")
    roptions = " " + Replace(roptions, Chr(34), "") + " "
End Sub


'________________________________________________________________
'MIXMASTER KEY FUNCTIONS
Public Static Function Type2(r, rname, raddress, rkey, roptions, Optional rver As String) As Integer
    Dim Type2Date As Date, Type2DateLast As Date, TMax As Integer
    Dim Type2List() As String
    'Returns 0 not found
    '        # postion in type2.lis
    
    On Error GoTo Type2Error
    rname = "": raddress = "": rkey = "": roptions = "": rver = ""
    
    If Cnf(1, 15) = "" Then Type2 = 0: Exit Function
    mixpath = Cnf(1, 19)
    If mixpath = "" Then mixpath = Cnf(1, 15)
    t2 = Cnf(1, 20)
    If InStr(t2, "\") = 0 Then t2 = mixpath + "\" + t2
    If SDir(t2) = "" Then Type2 = 0: Exit Function 'GoTo Type2Error
    Type2Date = FileDateTime(t2)
    If Type2DateLast <> Type2Date Or TMax = Empty Then
        n = FreeFile
        Open t2 For Input As n
        TMax = 0
        While Not EOF(n)
            Line Input #n, a
            If Trim(a) <> "" Then TMax = TMax + 1
        Wend
        Close n: n = 0
        ReDim Type2List(TMax)
        
        t = 0
        n = FreeFile
        Open t2 For Input As n
        Do While Not EOF(n)
            Line Input #n, a
            If Trim(a) <> "" Then
                t = t + 1
                Type2List(t) = a
            End If
        Loop
        Close n: n = 0
        Type2DateLast = Type2Date
    End If
    
    allr = "": nameonly = (InStr(r, "@") = 0)
    For i = 1 To TMax
        If r <> "" Then
            If (nameonly And LCase(Extract(Type2List(i), " ")) = LCase(r)) Or _
             ((Not nameonly) And InStr(Type2List(i), " " + r + " ") <> 0) Then
                If Type2Entry(Type2List(i), rname, raddress, rkey, rver, moptions) Then
                    roptions = " mix "
                    If InStr(moptions, "M") <> 0 Then roptions = roptions + "middle "
                    If InStr(moptions, "N") <> 0 Then roptions = roptions + "post "
                    Type2 = i
                    Exit Function
                End If
            End If
        Else
            allr = allr + Type2List(i) + vbCrLf
        End If
    Next i
    If r = "" Then r = allr
    rname = "": raddress = "": rkey = "": roptions = "": rver = ""
    Type2 = 0
Exit Function
Type2Error:
    MsgBox LMsg(15) + vbCr + Error, vbCritical, LMsg(4)
    rname = "": raddress = "": rkey = "": roptions = ""
    Type2 = 0
    Type2DateLast = 0
    CloseFile n
End Function

Public Function Type2Entry(entry, mname, maddress, mkeyid, mver, moptions) As Boolean
    Dim a As String, x As Long
    
    mname = "": maddress = "": mkeyid = "": moptions = "": mver = ""
    a = Trim(entry)
    For i = 1 To 5
        x = InStr(a, " "): If x = 0 Then x = Len(a) + 1
        b = Trim(Left(a, x - 1))
        Select Case i
        Case 1: mname = LCase(b)
        Case 2: maddress = b
        Case 3: mkeyid = b
        Case 4: mver = b
        Case 5: moptions = b
        End Select
        a = LTrim(Mid(a, x))
    Next i
    Type2Entry = mname <> "" And InStr(maddress, "@") <> 0 And mkeyid <> ""
End Function

Public Function AddMixKeys(keylistfile, pubkeyfile, t2, pm, WorkPath, Imperative As Boolean, Optional URL As String) As Integer
    'Adds one or more keys in pubkeyfile to pubring.mix and type2.lis
    'keylistfile contains the list of keys to be added
    'Set Imperative to unconditionally replace existing keys and not prompt
    Dim t2list As String
        
    If URL = "" Then URL = LMsg(181)
    On Error GoTo AddMixError
    If SDir(t2) <> "" Then
        n = FreeFile
        Open t2 For Input As n
        t2list = vbCrLf + Input(LOF(n), n) + vbCrLf
        Close n: n = 0
    End If
    If SDir(pm) <> "" Then
        p = FreeFile
        Open pm For Input As p
        pubring = Input(LOF(p), p)
        Close p: p = 0
    End If
    t = 0
    YesToAll = False
    n = FreeFile
    Open pubkeyfile For Input As n
    While Not EOF(n)
        Line Input #n, a
        a = Trim(a)
        If a = "-----Begin Mix Key-----" And Not EOF(n) Then
            Line Input #n, testkeyid
            testkeyid = Trim(testkeyid)
            p = FreeFile
            Open keylistfile For Input As p
            Do While Not EOF(p)
                Line Input #p, b
                b = Trim(b)
                If InStr(b, testkeyid) <> 0 Then
                    If Type2Entry(b, mname, maddress, mkeyid, mver, moptions) Then
                        'Key found in list
                        'Read Key
                        Key = b + vbCrLf + vbCrLf + a + vbCrLf + testkeyid + vbCrLf
                        Do While Not EOF(n)
                            Line Input #n, c
                            c = Trim(c)
                            If c = "" Then Exit Do
                            Key = Key + c + vbCrLf
                            If c = "-----End Mix Key-----" Then Exit Do
                        Loop
                        If c = "-----End Mix Key-----" Then
                            'In Original List?
                            If Not Imperative Then
                                x = InStr(1, t2list, vbCrLf + mname + " ", vbTextCompare)
                                If x <> 0 Then
                                    Y = InStr(pubring, "-----Begin Mix Key-----" + vbCrLf + mkeyid + vbCrLf)
                                    d = Extract(Mid(t2list, x + 2), vbCrLf)
                                    Type2Entry d, mname2, maddress2, mkeyid2, "", ""
                                    If LCase(maddress2) = LCase(maddress) And LCase(mkeyid2) = LCase(mkeyid) And Y <> 0 Then
                                        'Same
                                        ApproveX = 2 'No
                                    Else
                                        'Different
                                        If YesToAll Then
                                            ApproveX = 1
                                        Else
                                            ApproveX = MsgTime(LMsg(388) + vbCr + vbCr + d + vbCr + vbCr + LMsg(180) + vbCr + vbCr + b, 0, URL, 999, 2, 0, "&Yes", "&No", "Yes To &All")
                                            If ApproveX = 3 Then ApproveX = 1: YesToAll = True
                                        End If
                                    End If
                                Else
                                    'New
                                    If YesToAll Then
                                        ApproveX = 1
                                    Else
                                        ApproveX = MsgTime(LMsg(182) + vbCr + vbCr + b, 0, URL, 999, 2, 0, "&Yes", "&No", "Yes To &All")
                                        If ApproveX = 3 Then ApproveX = 1: YesToAll = True
                                    End If
                                End If
                            End If
                            If Imperative Or ApproveX = 1 Then
                                'Add Key
                                If AddSingleMixKey(Key, t2, pm, WorkPath, 0) Then
                                    t = t + 1
                                    If Imperative Then MsgBox LMsg(183) + vbCr + vbCr + Key, vbOKOnly, URL
                                End If
                            End If
                        End If
                    End If
                End If
            Loop
            Close p: p = 0
        End If
    Wend
    Close n: n = 0
    AddMixKeys = t
Exit Function
AddMixError:
    MsgBox LMsg(17) + vbCr + Error, vbCritical, LMsg(4)
    CloseFile (n)
    CloseFile (p)
    AddMixKeys = t
End Function

Public Function AddSingleMixKey(ByVal Key, t2, pm, WorkPath, Job As Byte) As Boolean
    'Job = 0  Add/Update key to type2.lis and pubring.mix
    '         First line of key must be type2 entry, blank line, mix key
    '         All unlisted keys are purged
    '    = 1  Remove key
    '         key contains remailer t2 entry
    '
    '         All unlisted keys are purged
    
    On Error GoTo AddMixError
    AddSingleMixKey = False
    If SDir(pm) = "" Then
        n = FreeFile
        Open pm For Output As n
        Close n: n = 0
    End If
    If SDir(t2) = "" Then
        n = FreeFile
        Open t2 For Output As n
        Close n: n = 0
    End If
    tentry = Trim(Extract(Key, vbCrLf))
    If Not Type2Entry(tentry, mname, maddress, mkeyid, mver, moptions) Then Exit Function
    'Update Type2.lis
    n = FreeFile
    Open t2 For Input As n
    p = FreeFile
    Open WorkPath + "\type2_.tmj" For Output As p
    While Not EOF(n)
        Line Input #n, a
        a = Trim(a)
        If a <> "" And InStr(a, vbLf) = 0 Then
            If Type2Entry(a, mname2, maddress2, mkeyid2, "", "") Then
                If mname2 = mname Then
                    If Job = 0 Then
                        Print #p, tentry: allt = allt + tentry + vbCrLf
                    End If
                Else
                    Print #p, a: allt = allt + a + vbCrLf
                End If
            End If
        End If
    Wend
    If Job = 0 And InStr(allt, tentry + vbCrLf) = 0 Then
        Print #p, tentry: allt = allt + tentry + vbCrLf
    End If
    Close p: p = 0
    Close n: n = 0
    'Update Pubring/Mix
    n = FreeFile
    Open pm For Input As n
    p = FreeFile
    Open WorkPath + "\pubring_.tmj" For Output As p
    While Not EOF(n)
        Line Input #n, a
        If Trim(a) <> "" And InStr(a, vbLf) = 0 Then
            If Type2Entry(a, mname2, maddress2, mkeyid2, "", "") Then
                lastentry = Trim(a)
            Else
                If a = "-----Begin Mix Key-----" Then
                    If Not EOF(n) Then
                        Line Input #n, testkeyid
                        If testkeyid = mkeyid Then
                            If Job = 0 And Key <> "" Then
                                Print #p, Key
                                Key = ""
                                AddSingleMixKey = True
                            End If
                        Else
                            If InStr(allt, " " + testkeyid + " ") <> 0 Then
                                Type2Entry lastentry, "", "", mkeyid2, "", ""
                                If mkeyid2 <> testkeyid Then lastentry = ""
                                Print #p, lastentry; vbCrLf; vbCrLf; a; vbCrLf; testkeyid
                                Do While Not EOF(n)
                                    Line Input #n, a
                                    If a = "" Then Exit Do
                                    Print #p, a
                                    If a = "-----End Mix Key-----" Then Exit Do
                                Loop
                                Print #p,
                            End If
                        End If
                    End If
                End If
                lastentry = ""
            End If
        End If
    Wend
    If Job = 0 And Key <> "" Then Print #p, Key: AddSingleMixKey = True
    Close p: p = 0
    Close n: n = 0
    FileCopy WorkPath + "\type2_.tmj", t2
    DelFile WorkPath + "\type2_.tmj"
    FileCopy WorkPath + "\pubring_.tmj", pm
    DelFile WorkPath + "\pubring_.tmj"
Exit Function
AddMixError:
    MsgBox LMsg(17) + vbCr + Error, vbCritical, LMsg(4)
    CloseFile (n)
    CloseFile (p)
    DelFile WorkPath + "\type2_.tmj"
    DelFile WorkPath + "\pubring_.tmj"
    AddSingleMixKey = False
End Function


'_________________________________________________________
'PGP KEY FUNCTIONS
Public Function ReadPGPKeys()
        If Val(PData(12)) = 0 Then
        '2.6.x keys
        If PData(16) <> "" And PData(16) <> "::NoAuto::" And Val(PData(14)) <> 0 Then
            If SDir(PData(16)) <> "" Then
                If FileDateTime(PData(16)) <> DateVal(PData(15)) Then Msg = KeyFile("")
            Else
                Msg = KeyFile("")
            End If
        Else
            Msg = KeyFile("")
        End If
        If Msg <> "" Then MsgBox Msg, vbCritical
    Else
        '5/6 keys
        PData(16) = ""

        Dim BufferOut As String * 32000, BufferOutLen As Long
        Dim ErrorString As String * 256
        Dim Count As Long
        Dim i As Long, j As Long
        
        BufferOut = Chr(0)
        BufferOutLen = 32000
        i = spgpKeyRingID(BufferOut, BufferOutLen)
        If i <> 0 Then
            'Error
            If i < 0 Then
                'Get Error String
                ErrorString = Chr(0)
                j = spgpGetErrorString(i, ErrorString)
            Else
                'Too many keys
                ErrorString = LMsg(562) + Chr(0)
            End If
            'Show error
            MsgBox LMsg(549) + vbCr + Extract(ErrorString, Chr(0)) + vbCr + Str(i), vbCritical
            KeyArrayCount = 0
        Else
            'Fill KeyArray and KeyArrayCount
            Count = CountCRLF(BufferOut)
            Call ChopKeyProps(BufferOut, Count)
        End If
    End If
Exit Function
ErrorReadPGPKeys:
    MsgBox LMsg(549) + vbCr + Error, vbCritical
    CloseFile n
End Function

Public Function KeyFile(KFile As String) As String
    On Error GoTo ErrorKeyFile
    PData(14) = "0"
    ReDim PubKeys(MaxPubKeys)
    If KFile <> "" Then PData(16) = ""
    
    If KFile = "" Then
        DOSShell "pgp +verbose=1 -kv > " + PData(10) + "\KeyRing.tmj", Val(PData(13)), "NUL"
    Else
        DOSShell "pgp +verbose=1 -kv " + KFile + " > " + PData(10) + "\KeyRing.tmj", Val(PData(13)), "NUL"
    End If
    
    If SDir(PData(10) + "\Keyring.tmj") = "" Then
        PData(16) = ""
        PData(14) = "0"
        KeyFile = LMsg(32) + vbCrLf: Exit Function
    Else
        pubx = 0
        n = FreeFile
        Open PData(10) + "\Keyring.tmj" For Input As n
        While Not EOF(n) And pubx < MaxPubKeys
            Line Input #n, a
            'Get Ring Pathname
            If NewKeyFile = "" And InStr(a, "'") > 1 Then
                x = InStr(a, "'")
                If x <> 0 And x <> Len(a) Then NewKeyFile = Extract(Mid(a, x + 1), "'")
            End If
            b = LCase(Left(a, 3))
            If b = "pub" Or b = "sec" Or b = Chr(246) + "ff" Or b = Chr(148) + "ff" Or b = "prv" Then
                PubKeys(pubx) = a
                pubx = pubx + 1
            End If
        Wend
        PData(14) = Str(pubx)
        If NewKeyFile = "" Then
            NewKeyFile = "::NoAuto::"
        Else
            If Dir(NewKeyFile) = "" Then NewKeyFile = ""
        End If
        If Val(PData(14)) = 0 Then
            NewKeyFile = "::NoAuto::"
            KeyFile = LMsg(33)
            Exit Function
        End If
        If KFile = "" Then
            If Val(PData(14)) <> 0 And NewKeyFile <> "::NoAuto::" Then PData(15) = FileDateTime(NewKeyFile)
            PData(16) = NewKeyFile
        End If
        If NewKeyFile = "::NoAuto::" Then NewKeyFile = "???"
        Close n: n = 0
        DelFile PData(10) + "\Keyring.tmj"
    End If
    KeyFile = ""
Exit Function
ErrorKeyFile:
    PData(16) = ""
    PData(14) = "0"
    KeyFile = LMsg(34) + vbCr + Error
    CloseFile n
    DelFile PData(10) + "\Keyring.tmj"
End Function

Public Function PGPKey(ByVal a, ErrMsg, Optional DelKey As Boolean) As String
    On Error GoTo ErrorPGPKey
    ErrMsg = ""
    If a = "" Then PGPKey = "": Exit Function
    If Val(PData(12)) = 0 Then
        'PGP 2.6.x
        a = Left(Extract(a, "   "), 90)
        x = InStr(a, "(")
        If x <> 0 Then
            XKeyFile = " " + Trim(Extract(Right(a, Len(a) - x), ")"))
            a = Trim(Left(a, x - 1))
        End If
        If LCase(Left(a, 2)) = "0x" Then a = Extract(a, " ")
        If Not DelKey Then
            sh = "pgp +bat -kxa " + a + " " + PData(10) + "\JBNKey" + XKeyFile
            DOSShell sh, Val(PData(13)), Dump
        Else
            sh = "pgp -kr " + a + XKeyFile
            DOSShell sh, 99, "NUL"
        End If
        If Not DelKey And SDir(PData(10) + "\JBNKey.asc") <> "" Then
            n = FreeFile
            Open PData(10) + "\JBNKey.asc" For Input As n
            a = Input(LOF(n), n)
            Close n: n = 0
            DelFile PData(10) + "\JBNKey.asc"
            DelFile Dump
            PGPKey = a   'Mid(a, InStr(a, "-----BEGIN"))
        Else
            If Dump <> "" And Dump <> "NUL" Then
                frmDOSError.Tag = Dump
                frmDOSError!lblMsg.Caption = LMsg(442) + vbCr + sh
                frmDOSError.Show 1
                DelFile Dump
            End If
            ErrMsg = LMsg(252)
            PGPKey = ""
        End If
    Else
        'PGP 5.5.x
        ' keyexport takes either key id(s) or user id(s)
        ' and returns the key
        Dim BufferIn As String * 1024
        Dim BufferOut As String * 16384
        Dim Key As TKey_Data, i As Long, KeyID As String
        
        KeyID = Extract(a, "   ")
        If LCase(Left(KeyID, 2)) <> "0x" Then KeyID = Left(CleanAddress(KeyID), 1023)
        BufferIn = KeyID + Chr(0)
        If KeyID <> "" Then i = spgpKeyExport(BufferIn, BufferOut, 16384, False, 1) Else i = -1

        If i = 0 And InStr(BufferOut, "-----BEGIN PGP") <> 0 Then
            PGPKey = Extract(BufferOut, Chr(0))
        Else
            ErrMsg = LMsg(253) + " " + a
            GoTo ErrorPGPKey
        End If
    End If
Exit Function
ErrorPGPKey:
    If ErrMsg = "" Then ErrMsg = LMsg(252) + vbCr + Error
    CloseFile n
    PGPKey = ""
End Function

#If False Then     '''''''''''''''''''''''''''''
Public Sub CopyKey(Index As Integer)
    If Index = 0 Then
        b = Extract(SelectKey(LMsg(139)), " ") 'Select Key To Extract
    Else
        b = Extract(SelectKey(LMsg(140)), " ") 'Select Key To Delete
    End If
    If b = "" Then Exit Sub
    If PData(16) = "" Then
        x = InStr(frmKeys!lblKeys.Caption, "Keyring: ")
        If x <> 0 Then a = Extract(Mid(frmKeys!lblKeys.Caption, x + 9), "   ")
        If a <> "" And a <> "???" Then b = b + " (" + a + ")"
    End If
    a = PGPKey(b, Index = 1)
    If Index = 0 Then
        Clipboard.Clear
        Clipboard.SetText a
    End If
End Sub
#End If

Public Function SelectKey(Title As String, Optional ByVal Address As String) As String
    If Val(PData(12)) = 0 Then
        '2.6.x
        frmKeys!cmdOK(1).Visible = Not (Title = LMsg(141)) 'View Keyring
        frmKeys.Caption = Title
        frmKeys.Tag = Address
        frmKeys.Show (1)
        SelectKey = frmKeys.Tag
    Else
        '5.5.x
        frmKeyRing.Caption = Title
        frmKeyRing.Tag = Address
        frmKeyRing.Show (1)
        SelectKey = frmKeyRing.Tag
        Unload frmKeyRing
    End If
End Function

Public Function FindPGPKey(searchkey, Optional AlgPreference As Boolean, _
                            Optional FullCheck As String) As String
    'Set FullCheck to non-empty for full feedback
    Dim searchkey2 As String
    Dim foundkey As String, founddate As String, kdate As String
    Dim foundrsa As Long, founddsa As Long
    Dim Found As Boolean, DoFull As Boolean, DoneCheck As Boolean
    
    If FullCheck <> "" Then DoFull = True: FullCheck = ""
    'Prepare alt search key for nym keys which don't have both addresses in
    'primary UserID
    If LCase(searchkey) Like "send@*.*" Then _
      searchkey2 = "config" + Mid(searchkey, InStr(searchkey, "@"))
    If LCase(searchkey) Like "config@*.*" Then _
      searchkey2 = "send" + Mid(searchkey, InStr(searchkey, "@"))
    'Scan Keys
    If Val(PData(12)) = 0 Then
        'PGP 2.6.x
        For i = 0 To Val(PData(14)) - 1
            x = InStr(1, PubKeys(i), "/")
            If x <> 0 Then
                a = "0x" + Mid(PubKeys(i), x + 1, 8) + vbTab
            Else
                a = "": x = -20
            End If
            a = a + Mid(PubKeys(i), x + 21)
            Found = InStr(1, a, searchkey, vbTextCompare) <> 0
            If Not Found Then If searchkey2 <> "" Then Found = InStr(1, PubKeys(i), searchkey2, vbTextCompare) <> 0
            If Found Then
                'Get Key Date
                kdate = LTrim(PubKeys(i))
                kdate = LTrim(Mid(kdate, InStr(kdate, " ") + 1))
                kdate = Extract(LTrim(Mid(kdate, InStr(kdate, " ") + 1)), " ")
                If Len(kdate) <> 10 Or Not (Left(kdate, 2) = "19" Or Left(kdate, 2) = "20") Then kdate = ""
                If foundkey = "" Or kdate > founddate Then
                    If DoFull And foundkey <> "" And Not DoneCheck Then FullCheck = FullCheck + LMsg(577) + " " + searchkey + vbCrLf: DoneCheck = True
                    foundkey = PubKeys(i)
                    founddate = kdate
                End If
            End If
        Next i
    Else
        'PGP 5.x
        For i = 0 To KeyArrayCount - 1
            Found = InStr(1, KeyArray(i).KeyID + vbTab + Chr(34) + KeyArray(i).UserID, searchkey, vbTextCompare) <> 0
            If Not Found Then If searchkey2 <> "" Then Found = InStr(1, KeyArray(i).KeyID + vbTab + Chr(34) + KeyArray(i).UserID, searchkey2, vbTextCompare) <> 0
            If Found Then
                If AlgPreference Or DoFull Then
                    If KeyArray(i).KeyAlgorithm = "" Then
                        'Get Key Properties
                        Dim j As Long
                        Dim BufferIn As String * 256, BufferOut As String * 2048
                        Dim Key As TKey_Data
                        BufferOut = Chr(0)
                        BufferIn = KeyArray(i).KeyID + Chr(0)
                        j = spgpKeyProps(BufferIn, BufferOut, 2048)
                        If j = 0 Then KeyArray(i) = ParseKeyData(BufferOut)
                    End If
                    If DoFull Then
                        If KeyArray(i).KeyAlgorithm = "RSA" Then foundrsa = foundrsa + 1
                        If KeyArray(i).KeyAlgorithm = "DSA" Then founddsa = founddsa + 1
                    End If
                    If foundkey = "" Or Not AlgPreference Or KeyArray(i).KeyAlgorithm = "" Or ((Val(Cnf(0, 6)) = 0 And KeyArray(i).KeyAlgorithm = "RSA") Or (Val(Cnf(0, 6)) <> 0 And KeyArray(i).KeyAlgorithm <> "RSA")) Then
                        foundkey = KeyArray(i).KeyID & "   " & Chr(34) & KeyArray(i).UserID & Chr(34)
                        If Not DoFull And (Not AlgPreference Or KeyArray(i).KeyAlgorithm = "" Or ((Val(Cnf(0, 6)) = 0 And KeyArray(i).KeyAlgorithm = "RSA") Or (Val(Cnf(0, 6)) <> 0 And KeyArray(i).KeyAlgorithm <> "RSA"))) Then Exit For
                    End If
                Else
                    foundkey = KeyArray(i).KeyID & "   " & Chr(34) & KeyArray(i).UserID & Chr(34)
                    Exit For
                End If
            End If
        Next i
        If DoFull Then
            If foundrsa > 1 Then FullCheck = FullCheck + LMsg(578) + " " + searchkey + vbCrLf
            If founddsa > 1 Then FullCheck = FullCheck + LMsg(579) + " " + searchkey + vbCrLf
        End If
    End If
    FindPGPKey = foundkey
End Function

Public Sub ImportKeyFile(fn)
    Dim FileIn As String * 256
    Dim KeyProps As String * 16384
    Dim KeyPropsLen As Long
    Dim ErrorString As String * 256
    Dim i As Long
    
    If SDir(fn) = "" Then Exit Sub
    If Val(PData(12)) = 0 Then
        'PGP 2.6.x
        If MsgBox(LMsg(381), vbYesNo + vbQuestion, LMsg(382)) = vbYes Then
            'Get signature keyid
            sk = SelectKey(LMsg(383), "")
            If sk = "" Then Exit Sub
            sk = " -u " + Extract(sk, "   ")
        End If
        DOSShell "pgp " + fn + sk, vbNormalFocus, "NUL"
    Else
        'PGP 5.x
        FileIn = fn + Chr(0)
        KeyProps = Chr(0)
        KeyPropsLen = 16384
        i = spgpKeyImportFile(FileIn, KeyProps, KeyPropsLen)
        If i <> 0 Then
            If i = -11995 Then
                ErrorString = LMsg(581) + Chr(0)
            Else
                ErrorString = Chr(0)
                i = spgpGetErrorString(i, ErrorString)
            End If
            MsgBox LMsg(384) + vbCr + Extract(ErrorString, Chr(0)), vbCritical, LMsg(382)
            Exit Sub
        End If
    End If
End Sub


Public Sub ClipKey()
    'Add Key From Clipboard
    On Error Resume Next
    a = Replace(Clipboard.GetText, "- -----", "-----")
    If InStr(a, "-----BEGIN PGP") <> 0 Then
        On Error GoTo ClipKeyError
        fn = GetWork
        n = FreeFile
        Open fn For Output As n
        Print #n, a
        Close n: n = 0
        'PGP
        ImportKeyFile (fn)
        DelFile fn
        MsgBox LMsg(386), vbInformation, LMsg(382)
        If Not CheckingConfig Then CheckConfig "Remailers", True, True
    Else
        While Left(a, 2) = vbCrLf
            a = Mid(a, 3)
        Wend
        While Right(a, 2) = vbCrLf
            a = Left(a, Len(a) - 2)
        Wend
        If InStr(Extract(a, vbCrLf), "@") <> 0 And a Like "*@*" + vbCrLf + "-----Begin Mix Key-----" + vbCrLf + "*" + "-----End Mix Key-----" Then
            a = Extract(a, vbCrLf) + vbCrLf + vbCrLf + Mid(a, InStr(a, "-----Begin Mix Key-----")) + vbCrLf
            mixpath = Cnf(1, 19)
            If mixpath = "" Then mixpath = Cnf(1, 15)
            t2 = Cnf(1, 20)
            If InStr(t2, "\") = 0 Then t2 = mixpath + "\" + t2
            pm = Cnf(1, 21)
            If InStr(pm, "\") = 0 Then pm = mixpath + "\" + pm
            If AddSingleMixKey(a, t2, pm, PData(10), 0) Then MsgBox LMsg(564), vbInformation Else MsgBox LMsg(565), vbExclamation
        Else
            'No key found
            MsgBox LMsg(563), vbInformation
        End If
    End If
Exit Sub
ClipKeyError:
    MsgBox LMsg(0) + vbCr + Error, vbCritical
    CloseFile n
    DelFile fn
End Sub

'________________________________________________________________
'PGP FUNCTIONS
Public Function Encrypt(Src, ByVal Key As String, Job, ErrMsg, _
Optional SignKey As String, Optional SignPass As String, _
Optional ClearSign As Boolean, Optional NoArmor As Boolean) As String
    Dim z As String, DispLine As String, Wait As Byte
    
    ErrMsg = ""
    SignKey = Trim(SignKey)
    If NoArmor Then
        Dst = PlainName(Src, 0) + PlainName(Src, 2) + ".pgp"
    Else
        Dst = PlainName(Src, 0) + PlainName(Src, 2) + ".asc"
    End If
    If Not DelFile(Dst) Then ErrMsg = LMsg(21): Encrypt = "": Exit Function
    If Dir(Src) = "" Then Encrypt = "": Exit Function
    If Val(PData(12)) = 0 Then
        'PGP 2.6.x
        Style = Val(PData(13)): Wait = 0: Dump = ""
        Select Case Job
        Case 0
            'Conv Encrypt
            If NoArmor Then pgpcommand = "-c " Else pgpcommand = "-cat "
            If Trim(Key) = "" Then
                a = "pgp " + pgpcommand + Src
                DispLine = a
                Style = 99
                Dump = "NUL"
                Wait = 2
            Else
                a = "pgp +bat " + pgpcommand + "-z" + Chr(34) + Key + Chr(34) + " " + Src
                DispLine = "pgp +bat " + pgpcommand + "-z***Passphrase*** " + Src
            End If
        Case 1
            'Public Key Encrypt
            If Trim(Key) = "" And SignKey = "" Then Encrypt = "": Exit Function
            Key = Trim(Key)
            If InStr(Key, " ") = 0 And LCase(Left(Key, 2)) <> "0x" And Key <> "" Then
                rkey = FindPGPKey(Key)
                If rkey <> "" Then
                    a = Extract(Mid(rkey, InStr(rkey, "/") + 1), " ")
                    If Len(a) = 8 And InStr(a, "/") = 0 And InStr(a, " ") = 0 Then Key = "0x" + a
                End If
            End If
            If InStr(SignKey, " ") = 0 And LCase(Left(SignKey, 2)) <> "0x" And SignKey <> "" Then
                rkey = FindPGPKey(SignKey)
                If rkey <> "" Then
                    a = Extract(Mid(rkey, InStr(rkey, "/") + 1), " ")
                    If Len(a) = 8 And InStr(a, "/") = 0 And InStr(a, " ") = 0 Then SignKey = "0x" + a
                End If
            End If
            z = SignPass
            If z = Chr(4) + "NONE" Then z = ""
            If z <> "" Then z = "-z" + Chr(34) + z + Chr(34) + " "
            If Key <> "" And SignKey <> "" Then
                'Encrypt/Sign
                If NoArmor Then pgpcommand = "-se " Else pgpcommand = "-seat "
                If z <> "" Or z = Chr(4) + "NONE" Then
                    'Send Pass
                    a = "pgp +bat " + pgpcommand + z + Src + " " + Key + " -u " + SignKey
                    DispLine = "pgp +bat " + pgpcommand + "-z" + Chr(34) + "***Passphrase***" + Chr(34) + " " + Src + " " + Key + " -u " + SignKey
                Else
                    'No Pass/Window
                    a = "pgp " + pgpcommand + Src + " " + Key + " -u " + SignKey
                    DispLine = a
                    Style = 99
                    Dump = "NUL"
                    Wait = 2
                End If
            Else
                If Key <> "" Then
                    'Encrypt
                    If NoArmor Then pgpcommand = "-e " Else pgpcommand = "-eat "
                    a = "pgp +bat " + pgpcommand + Src + " " + Key
                    DispLine = a
                Else
                    'Sign
                    If NoArmor Then pgpcommand = "+clearsig=off -s " Else pgpcommand = "+clearsig=on -sat "
                    If z <> "" Or z = Chr(4) + "NONE" Then
                        'Send Pass
                        a = "pgp +bat " + pgpcommand + z + Src + " -u " + SignKey
                        DispLine = "pgp +bat " + pgpcommand + "-z" + Chr(34) + "***Passphrase***" + Chr(34) + " " + Src + " -u " + SignKey
                    Else
                        'No Pass/Window
                        a = "pgp " + pgpcommand + Src + " -u " + SignKey
                        DispLine = a
                        Style = 99
                        Dump = "NUL"
                        Wait = 2
                    End If
                End If
            End If
            z = String(Len(z), "@")
        End Select
        
        If Len(a) > 115 Then
            ErrMsg = LMsg(22)
            Encrypt = ""
            Exit Function
        End If
        
        If SignKey <> "" And Val(Cnf(2, 6)) = 1 Then AlterTime (True)
        DOSShell a, Style, Dump, DispLine, "", Wait
        AlterTime (False)
        
        If Dir(Dst) <> "" Then
            DelFile Dump
            Encrypt = Dst
        Else
            If Dump <> "" And Dump <> "NUL" Then
                DelFile DOSDump
                DOSDump = Dump
                frmDOSError.Tag = DOSDump
                frmDOSError!lblMsg.Caption = LMsg(442) + vbCr + DispLine
                frmDOSError.Show 1
            End If
            ErrMsg = LMsg(164)
            Encrypt = ""
        End If
    Else
        'PGP 5.x
        ' all strings must be of fixed length
        Dim CryptKeyID As String * 256, SignKeyID As String * 256
        Dim SignKeyPass As String * 256, IDEAPass As String * 256
        Dim comment As String * 256, FileIn As String * 256
        Dim FileOut  As String * 256, ErrorString As String * 256
        Dim xSign As Long, xEncrypt As Long, xClear As Long
        Dim xArmor As Long
        Dim i As Long

        If Trim(Key) = "" And SignKey = "" Then Encrypt = "": Exit Function
        If NoArmor Then xArmor = 0 Else xArmor = 1
        If Job = 0 Then
            'Conv Encrypt
            FileIn = Src & Chr(0)
            FileOut = Dst & Chr(0)
            CryptKeyID = "" & Chr(0)
            SignKeyID = "" & Chr(0)
            SignKeyPass = "" & Chr(0)
            IDEAPass = Left(Key, 255) & Chr(0)
            comment = "" & Chr(0)
            ErrorString = Chr(0)
            i = spgpEncodeFile(FileIn, FileOut, 0, 0, 1, 1, 1, xArmor, xArmor, 0, CryptKeyID, SignKeyID, SignKeyPass, IDEAPass, comment)
        Else
            'Public Key Encrypt
            Key = Trim(Key)
            If InStr(Key, " ") = 0 And LCase(Left(Key, 2)) <> "0x" And Key <> "" Then
                rkey = FindPGPKey(Key, True)
                If rkey <> "" Then
                    a = Extract(rkey, "   ")
                    If Left(a, 2) = "0x" Then Key = a
                End If
            Else
                Key = Replace(Key, " ", ",")
            End If
            If InStr(SignKey, " ") = 0 And LCase(Left(SignKey, 2)) <> "0x" And SignKey <> "" Then
                rkey = FindPGPKey(SignKey)
                If rkey <> "" Then
                    a = Extract(rkey, " ")
                    If Left(a, 2) = "0x" Then SignKey = a
                End If
            End If
            If Key <> "" Then
                If LCase(Left(Key, 2)) <> "0x" Then
                    Key = CleanAddress(Key)
                    If Key = "" Then Abort = True Else Key = "<" + Key + ">"
                End If
            End If
            If SignKey <> "" Then
                If LCase(Left(SignKey, 2)) <> "0x" Then
                    SignKey = CleanAddress(SignKey)
                    If SignKey = "" Then Abort = True Else Key = "<" + SignKey + ">"
                End If
            End If
            FileIn = Src & Chr(0)
            FileOut = Dst & Chr(0)
            CryptKeyID = Key & Chr(0)
            SignKeyID = SignKey & Chr(0)
            comment = Chr(0)
            If SignPass <> Chr(4) + "NONE" Then
                SignKeyPass = SignPass & Chr(0)
            Else
                SignKeyPass = Chr(0)
            End If
            IDEAPass = "" & Chr(0)
            If SignKey = "" Then xSign = 0 Else xSign = 1
            If Key = "" Then xEncrypt = 0 Else xEncrypt = 1
            If ClearSign And Key = "" And SignKey <> "" Then xClear = 1 Else xClear = 0
            If Abort Then
                ErrMsg = ""
            Else
                If SignKey <> "" And Val(Cnf(2, 6)) = 1 Then AlterTime (True)
                On Error Resume Next
                i = spgpEncodeFile(FileIn, FileOut, xEncrypt, xSign, 1, 0, 1, xArmor, xArmor, xClear, CryptKeyID, SignKeyID, SignKeyPass, IDEAPass, comment)
                On Error GoTo 0
                AlterTime (False)
                Select Case i
                    Case 0
                    Case -12000    'v10     -1 for v20
                        'Key not available
                        ErrMsg = LMsg(194)
                    Case Else
                        i = spgpGetErrorString(i, ErrorString)
                        ErrMsg = Extract(ErrorString, Chr(0))
                End Select
            End If
        End If
        If SDir(Dst) <> "" Then
            Encrypt = Dst
        Else
            ErrMsg = LMsg(164) + vbCrLf + ErrMsg
            Encrypt = ""
        End If
    End If
    Key = String(Len(Key), "@")
End Function

Public Function PGPOK(n, p, EncOut) As Boolean
    Dim TempOK As Boolean, FirstLines As Boolean, ClearSig As Boolean
    'Copies p to n and checks for PGP integrity
    'Removes PGP headers
    'No local error trapping
        
    TempOK = False
    If EncOut Then
        If Not EOF(p) Then
            Line Input #p, a
            Print #n, a
        Else: a = ""
        End If
        'Clearsig?
        If a = "-----BEGIN PGP SIGNED MESSAGE-----" Then
            'Remove headers and parse signed text
            ClearSig = True
            FirstLines = True
            While Not EOF(p) And a <> "-----BEGIN PGP SIGNATURE-----"
                Line Input #p, a
                If FirstLines Then
                    If a = "" Then Print #n, a: FirstLines = False
                Else
                    Print #n, a
                End If
            Wend
        End If
        TempOK = (a Like "-----BEGIN PGP *-----")
        If TempOK And Not EOF(p) Then
            'Headers
            Line Input #p, a
            Do While (InStr(a, ":") <> 0 Or LTrim(a) = "") And Not EOF(p)
                If LCase(Left(LTrim(a), 8)) = "version:" Then
                    If Trim(Cnf(0, 14)) = "" Then
                        If ClearSig Then
                            Print #n, "Version: N/A"
                        Else
                            For i = 0 To 6: x = Int(Rnd(1) * 6) + 1: Next i
                            Select Case x
                            Case 1: Print #n, "Version: 2.6.2"
                            Case 2: Print #n, "Version: 2.6.3"
                            Case 3: Print #n, "Version: 2.6.3i"
                            Case Else
                                Print #n, "Version: N/A"
                            End Select
                        End If
                    Else
                        Print #n, "Version: "; Left(LTrim(Cnf(0, 14)), 70)
                    End If
                End If
                Line Input #p, a
            Loop
            Print #n, vbCrLf; a
        End If
    End If
    While Not EOF(p)
        Line Input #p, a
        Print #n, a
    Wend
    If Not a Like "-----END PGP *-----" Then TempOK = False
    PGPOK = TempOK
End Function

Public Function Decrypt(Src, Passphrase, Optional ErrCode As Long, _
                        Optional SigProps As String) As String
    ErrCode = 0: ErrMsg = ""
    If Dir(Src) = "" Then Decrypt = "": Exit Function
    Dst = GetWork
    If Val(PData(12)) = 0 Then
        'PGP 2.6.x
        If Passphrase <> "" Or Passphrase = Chr(4) + "NONE" Then
            If Passphrase <> Chr(4) + "NONE" Then
                ps = "-z" + Chr(34) + Passphrase + Chr(34) + " "
            Else
                ps = ""
            End If
            psb = "-z" + Chr(34) + "***Passphrase***" + Chr(34) + " "
            Style = Val(PData(13))
            If Left(SigProps, 7) = "Decrypt" Then Wait = 2 Else Wait = 0
        Else
            Style = 99
            Wait = 2
        End If
        
        DOSShell "pgp +bat " + ps + Src + " -o " + Dst, Style, "NUL", "pgp +bat " + psb + Src + " -o " + Dst, "", Wait
        
        If Dir(Dst) <> "" Then
            Decrypt = Dst
        Else
            Decrypt = ""
        End If
    Else
        'PGP 5.x
        ' all strings must be of fixed length
        Dim SigProps2 As String * 256
        Dim Pass As String * 256
        Dim FileIn As String * 256
        Dim FileOut As String * 256
        Dim i As Long
        
        SigProps2 = "" & Chr(0)
        If Passphrase <> Chr(4) + "NONE" Then
            Pass = Left(Passphrase, 255) & Chr(0)
        Else
            Pass = Chr(0)
        End If
        FileIn = Src & Chr(0)
        FileOut = Dst & Chr(0)
        
        i = spgpDecodeFile(FileIn, FileOut, Pass, SigProps2)
        'ErrCode =  -11500 = Private Key not available
        If Dir(Dst) <> "" And i = 0 Then
            SigProps = SigProps2
            Decrypt = Dst
        Else
            DelFile Dst
            ErrCode = i
            SigProps = ""
            Decrypt = ""
        End If
        DoEvents
    End If
End Function

Public Function TestPGP(UserID, Pass) As String
    Src = GetWork
    n = FreeFile
    Open Src For Output As n
    Print #n, "PGP Test Message"
    Close n: n = 0
    PGPDst = Encrypt(Src, UserID, 1, ErrMsg)
    If PGPDst = "" Then Msg = 141: GoTo PGPError
    PGPDst2 = Decrypt(PGPDst, Pass)
    If PGPDst2 = "" Then Msg = 142: GoTo PGPError
    DelFile PGPDst
    DelFile PGPDst2
    DelFile Src
    TestPGP = ""
Exit Function
PGPError:
    If Msg = 0 Then
        TestPGP = LMsg(143) + vbCrLf + Error
    Else
        TestPGP = LMsg(Msg) + vbCrLf + ErrMsg
    End If
    CloseFile n
    DelFile PGPDst
    DelFile PGPDst2
    DelFile Src
End Function

Public Sub QueueDec(f)
    'Queues file for decryption by DecryptMesssages
    While DecQBusy: DoEvents: Wend
    DecQBusy = True
    For i = 0 To DecQCount - 1
        If DecQ(i) = f Then DecQBusy = False: Exit Sub
    Next i
    If MaxDecQ = 0 Or DecQCount > MaxDecQ Then
        MaxDecQ = MaxDecQ + 20
        ReDim Preserve DecQ(MaxDecQ)
    End If
    DecQ(DecQCount) = f
    DecQCount = DecQCount + 1
    DecQBusy = False
    If Not Decrypting Then Stat StatMain, Trim(Str(DecQCount)) + " " + LMsg(475)
End Sub

#If False Then   '''''''''''''''''''''''
Public Sub Crypt(Job As Integer, Source As Integer, Dest As Integer)
    On Error GoTo ErrorCrypt
    Dim a As String
    q = Chr(34)
    Select Case Job
    Case 0
        JobMsg = LMsg(124) '"Decrypt"
    Case 1
        JobMsg = LMsg(125) '"Encrypt"
    Case 2
        JobMsg = LMsg(126) '"Sign"
    Case 3
        JobMsg = LMsg(127) '"Encrypt and Sign"
    Case 4
        JobMsg = LMsg(128) '"Add Key"
    Case 5
        JobMsg = LMsg(129) '"Certify Key"
    Case Else
        Exit Sub
    End Select
    
    If Source = 0 Then
        JobMsg = JobMsg + " " + LMsg(130) 'Clipboard
        dsw = "w"
    Else
        If Job <> 5 Then JobMsg = JobMsg + " " + LMsg(131) 'File"
    End If
    
    If Job < 4 Then
        Select Case Dest
        Case 0
            JobMsg = JobMsg + " " + LMsg(132) 'To Clipboard"
            dsw = "at" + dsw
        Case 1
            JobMsg = JobMsg + " " + LMsg(133) 'To ASCII File"
            dsw = "at" + dsw
        Case 2
            JobMsg = JobMsg + " " + LMsg(134)  'To Binary File
        Case Else
            Exit Sub
        End Select
        If Job = 2 And Dest < 2 Then dsw = dsw + " +clearsig=on"
    End If
    
    'Prepare Source
    If Job <> 5 Then
        If Source = 0 Then
            a = Clipboard.GetText
            If ((Job = 0 Or Job = 4) And InStr(a, "-----BEGIN PGP") = 0) Or a = "" Then MsgBox LMsg(135), vbInformation, LMsg(136): Exit Sub
            If Job > 0 And Job < 4 Then
                'Please verify clipboard contents
                If MsgBox(LMsg(114) + vbCrLf + vbCrLf + Left(a, 300), vbQuestion + vbOKCancel, LMsg(115)) = vbCancel Then Exit Sub
            End If
            srcfile = PData(10) + "\REL_MSG.asc" ''''''''''''''''
            n = FreeFile
            Open srcfile For Output As n
            Print #n, a;
            Close n: n = 0
        Else
            frmMain!CommonDialog1.Filter = "All Files (*.*)|*.*"
            frmMain!CommonDialog1.FilterIndex = 1
            frmMain!CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNFileMustExist
            frmMain!CommonDialog1.DialogTitle = LMsg(116) + " - " + JobMsg 'Open source file
            frmMain!CommonDialog1.InitDir = CryptPathS
            frmMain!CommonDialog1.CancelError = True
            On Error GoTo CancelDialog
            frmMain!CommonDialog1.Action = 1
            On Error GoTo ErrorCrypt
            srcfile = frmMain!CommonDialog1.Filename
            If Trim(srcfile) = "" Then Exit Sub
            CryptPathS = PlainName(srcfile, 0)
        End If
    End If
    
    'Prepare Dest
    If Job <> 4 And Job <> 5 Then
        If Dest = 0 Then
            dstfile = PData(10) + "\REL_MSG.rel" '''''''''''''
        Else
            frmMain!CommonDialog1.Filter = "All Files (*.*)|*.*"
            frmMain!CommonDialog1.FilterIndex = 1
            frmMain!CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNPathMustExist
            frmMain!CommonDialog1.DialogTitle = LMsg(117) + " - " + JobMsg 'Open dest file
            frmMain!CommonDialog1.InitDir = CryptPathD
            frmMain!CommonDialog1.CancelError = True
            On Error GoTo CancelDialog
            frmMain!CommonDialog1.Action = 1
            On Error GoTo ErrorCrypt
            dstfile = frmMain!CommonDialog1.Filename
            If Trim(dstfile) = "" Then Exit Sub
            CryptPathD = PlainName(dstfile, 0)
        End If
    End If
    
    'Get UserIDs
    If Job = 1 Or Job = 3 Then
        'Select Recipient's Keys
        encID = Extract(SelectKey(LMsg(118) + " - " + JobMsg), "   ")
        If Trim(encID) = "" Then Exit Sub
    End If
    
    If Job = 5 Then
        'Select Key To Be Certified
        encID = Extract(SelectKey(LMsg(119) + " - " + JobMsg), " ")
        If Trim(encID) = "" Then Exit Sub
    End If
    
    If Job = 2 Or Job = 3 Or Job = 5 Then
        'Select Key For Signature
        sigID = Extract(SelectKey(LMsg(120) + " - " + JobMsg), " ")
        If Trim(sigID) = "" Then Exit Sub
    End If
    
    If Job = 4 Then
        'Select Key For Certification Sig (Optional)
        sigID = Extract(SelectKey(LMsg(121) + " - " + JobMsg), " ")
    End If
    
    'Set PGP Command
    Select Case Job
    Case 0
        PComm = q + srcfile + q + " -o " + q + dstfile + q
    Case 1
        If LCase(encID) = "-c" Then
            PComm = "-c" + dsw + " " + q + srcfile + q + " -o " + q + dstfile + q
        Else
            PComm = "-e" + dsw + " " + q + srcfile + q + " " + encID + " -o " + q + dstfile + q
        End If
    Case 3
        If LCase(encID) = "-c" Then
            PComm = "-sc" + dsw + " " + q + srcfile + q + " -u " + sigID + " -o " + q + dstfile + q
        Else
            PComm = "-se" + dsw + " " + q + srcfile + q + " " + encID + " -u " + sigID + " -o " + q + dstfile + q
        End If
    Case 2
        PComm = "-s" + dsw + " " + q + srcfile + q + " -u " + sigID + " -o " + q + dstfile + q
    Case 4
        PComm = "-ka " + q + srcfile + q
        If Trim(sigID) <> "" Then PComm = "-ka " + q + srcfile + q + " -u " + sigID
    Case 5
        PComm = "-ks " + encID + " -u " + sigID
    End Select

    frmMain.MousePointer = 11
    DOSShell "pgp " + PComm, vbNormalFocus, "NUL"
    frmMain.MousePointer = 0
    
    'Finish
    If Job < 4 Then
        If Dir(dstfile) = "" Then
            MsgBox LMsg(122), vbCritical, LMsg(123)
        Else
            If Dest = 0 Then
                n = FreeFile
                Open dstfile For Input As n
                x = LOF(n): If x > 400000 Then x = 400000
                a = Input(x, n)
                Close n: n = 0
                Clipboard.Clear
                Clipboard.SetText a
                DelFile dstfile
            End If
        End If
        
        If Source = 0 And Dir(srcfile) <> "" And Job <> 0 Then DelFile (srcfile)
        If Source = 0 And Dir(srcfile) <> "" And Job = 0 Then DelFile srcfile
    Else
        If Source = 0 And Job <> 5 Then DelFile srcfile
    End If
Exit Sub
CancelDialog:
Exit Sub
ErrorCrypt:
    MsgBox LMsg(0) + vbCrLf + Error, vbCritical, JobMsg + " Error"
    DOSTag = ""
    CloseFile n
End Sub
#End If

'________________________________________________________________
'MESSAGE FUNCTIONS
Public Function CPunkMessage(Src, raddress, ByVal RemHead As String, _
HashHead, Encrypted As Boolean, Garbage, ErrMsg, _
Optional WorkPath As String, Optional PrevFile As String, _
Optional ReplyBlock As Boolean) As String
    Dim Dst As String, ESFile As String, ns As Integer, nd As Integer, a As String
    Dim x As Single
    
    On Error GoTo CPunkError
    If Dir(Src) = "" Or raddress = "" Or RemHead = "" Then CPunkMessage = "": Exit Function
    
    If WorkPath = "" Then WorkPath = PData(10)
    
    'Create CPunk
    Dst = GetWork(WorkPath)
    ns = FreeFile
    Open Src For Input As ns
    nd = FreeFile
    Open Dst For Output As nd
    Print #nd, "::"
    Print #nd, RemHead
    If HashHead <> "" Then Print #nd, "##": Print #nd, HashHead
    While Not EOF(ns)
        Line Input #ns, a
        Print #nd, a
    Wend
    If Val(Garbage) <> 0 Then AddGarbage nd, Garbage
    Close ns: ns = 0
    If ReplyBlock And InStr(1, vbCrLf + RemHead, "encrypt-key:", vbTextCompare) + InStr(1, vbCrLf + RemHead, "encryptkey:", vbTextCompare) <> 0 Then _
     Print #nd, vbCrLf; "**"; vbCrLf
    Close nd: nd = 0
    If Encrypted Then
        ESFile = RePGP(Dst, raddress, WorkPath)
        If PrevFile = "" Then DelFile Dst Else PrevFile = Dst
        If ESFile = "" Then
            'Encryption error
            ErrMsg = LMsg(24) + ": " + raddress
            DelFile PrevFile
            PrevFile = ""
            CPunkMessage = ""
        Else
            CPunkMessage = ESFile
        End If
    Else
        CPunkMessage = Dst
        PrevFile = Dst
    End If
Exit Function
CPunkError:
    ErrMsg = LMsg(25) + vbCrLf + Error
    CPunkMessage = ""
    CloseFile nd
    CloseFile ns
    DelFile Dst
    PrevFile = ""
End Function

Public Function RePGP(Src, Key, Optional WorkPath As String) As String
    On Error GoTo RePGPError
    If WorkPath = "" Then WorkPath = PData(10)
    PGPDst = Encrypt(Src, Key, 1, "")
    If PGPDst = "" Then
        RePGP = ""
    Else
        Dst = GetWork(WorkPath)
        n = FreeFile
        Open Dst For Output As n
        Print #n, "::"
        Print #n, "Encrypted: PGP"; vbCrLf
        p = FreeFile
        Open PGPDst For Input As p
        EncOK = PGPOK(n, p, True)
        Close p: p = 0
        DelFile PGPDst
        Close n: n = 0
        If Not EncOK Then
            RePGP = ""
        Else
            RePGP = Dst
        End If
    End If
Exit Function
RePGPError:
    ErrMsg = LMsg(25) + vbCrLf + Error
    RePGP = ""
    CloseFile n
    CloseFile p
    DelFile PGPDst
    DelFile Dst
End Function

Public Function MixMessage(Src, ToAddresses, Headers, Remailers, WorkPath As String, ErrMsg, Chains As Byte) As String
    Dim ToA As String, a As String, x As Integer, Y As Integer, Dst As String
    Dim MixCon As String
    
    If Dir(Src) = "" Or Remailers = "" Then MixMessage = "": ErrMsg = LMsg(166): Exit Function
    MixRun = GetWork(WorkPath)
    
    n = FreeFile
    Open MixRun For Output As n
    If Trim(LCase(Left(ToAddresses, 5))) = "post:" Then
        ToA = Replace(ToAddresses, " ", "")
        Print #n, "Post: " + Mid(ToA, 6)
    Else
        ToA = ToAddresses + ","
        Y = 1
        x = InStr(Y, ToA, ",")
        While x <> 0
            a = Mid(ToA, Y, x - Y)
            If a <> "" Then Print #n, a
            Y = x + 1
            x = InStr(Y, ToA, ",")
        Wend
    End If
    Print #n,
    Print #n, Headers
    Print #n, Remailers
    Print #n, Src
    Print #n,
    Print #n,
    Print #n,
    Print #n,
    Print #n,
    Close n: n = 0

    Dst = GetWork(WorkPath)
    Dst = Left(Dst, Len(Dst) - 4)
    DelFile (Dst)
    For i = 1 To 9
        DelFile Dst + "." + Trim(Str(i)) + "*"
    Next i
    
    If Chains < 2 Then a = "" Else a = "-n " + Trim(Str(Chains)) + " "
    a = "mixmaste " + a + "-O " + Dst + " <" + MixRun
    DOSShell a, Val(PData(13)), Dump, a, Cnf(1, 15)

    DelFile MixRun
    If Dir(Dst) = "" And Dir(Dst + ".1") = "" Then
        ErrMsg = LMsg(166)
        DelFile DOSDump
        DOSDump = Dump
        frmDOSError.Tag = DOSDump
        frmDOSError!lblMsg.Caption = LMsg(442) + vbCr + a
        frmDOSError.Show 1
        MixMessage = ""
    Else
        DelFile Dump
        MixMessage = Dst
    End If
Exit Function
MixError:
    ErrMsg = LMsg(166) + vbCrLf + Error
    MixMessage = ""
    CloseFile n
    DelFile Dst
    DelFile MixCon
End Function

Public Sub AddGarbage(n, Garbage)
    Dim x As Double
    
    x = Val(Garbage) * 1024
    If x <> 0 Then
        If x > 512000 Then x = 512000
        If InStr(1, Garbage, "r", vbTextCompare) <> 0 Then x = (x / 2) + Rnd(1) * (x / 2)
        Print #n, vbCrLf; "-----BEGIN GARBAGE-----"
        For i = 1 To 16 * (x / 1024) '16*k
            For j = 1 To 62
                Print #n, Mid(Radix64, Int(Rnd(1) * 64) + 1, 1);
            Next j
            Print #n,
        Next i
        Print #n, "-----END GARBAGE-----"
    End If
End Sub

Public Function ChainMsg(Src, ToAddresses, Rmlr() As String, _
rd() As String, RCount, ByVal BookRType, Hdrs, ByVal WorkPath As String, _
Warn As Boolean, Prevu As Boolean, Parts, Him As Object, Max As MaxType, _
ErrMsg, RemixComp As Boolean, Optional ByVal Chains As Byte, _
Optional RBNum As Integer, Optional NymLog As String) As String
    Dim gFinal As String, gNext As String, MsgLen As Long, d As String
    Dim h As String, cSrc As String, PrevFile As String
    Dim SrcLen As Long, NymChain As Byte, GotMaxDirect As Boolean
    Dim RemixMode As Byte
    
    gFinal = ToAddresses
    If BookRType = 1 Then
        'Mixmaster
        On Error Resume Next
        Him!lblStat.Caption = LMsg(219) + Parts: Him!lblStat.Refresh
        On Error GoTo 0
        r = "": r2 = ""
        For i = 0 To RCount - 1
            If LCase(Rmlr(i)) <> "random" Then
                'Check remailer and get directives
                If i = RCount - 1 Then
                    a = rd(RCount - 1)
                    tempfinal = gFinal
                    tempnext = ""
                Else
                    a = ""
                    tempfinal = ""
                    tempnext = Rmlr(i + 1)
                End If
                x = Type2(Rmlr(i), rname, "", "", "")
                If x = 0 Or Not GetDirect(Rmlr(i), a, BookRType, i + 1, tempnext, tempfinal, False, Warn, MsgLen, d, Garbage, Max) Then
                    DelFile Src
                    ChainMsg = "": ErrMsg = ""
                    Exit Function
                End If
            Else
                x = 0
            End If
            r = r + Trim(Str(x)) + vbCrLf
            r2 = r2 + Rmlr(i) + vbCrLf
        Next i
        If InStr(1, gFinal, "post:", vbTextCompare) = 0 Then h = "To: " Else h = ""
        h = h + gFinal + vbCrLf + Hdrs + d
        'Add Garbage
        If Val(Garbage) <> 0 Then
            n = FreeFile
            Open Src For Append As n
            AddGarbage n, Garbage
            Close n: n = 0
        End If
        'If Him!chkQue(0).Value = 0 Then
        '    'Abort
        '    DelFile Src
        '    ErrMsg = LMsg(207)
        '    ChainMsg = ""
        '    Exit Function
        'End If
        'Check Message Size
        If FileLen(Src) + 1024 > MsgLen And MsgLen <> 0 And Val(Cnf(2, 5)) = 1 Then _
         If MsgBox(LMsg(174) + " " + rname + vbCr + vbCr + LMsg(198) + ":" + Str(FileLen(Src) + 1024) + vbCr + LMsg(220) + ":" + Str(MsgLen), vbInformation + vbOKCancel, LMsg(168)) = vbCancel Then DelFile Src: ChainMsg = "": ErrMsg = "": Exit Function
        'Show Preview
        If Prevu Then
            b = LMsg(205)
            a = LMsg(197) + " " + b
            x = Type2(Rmlr(0), rname, raddress, "", "")
            x = PreviewMsg(a, b + "   " + Parts, r2, 1, False, h, Src, False)
            Him.MousePointer = 13
            Him.Refresh
            If x = -1 Or x = 2 Then DelFile Src: ChainMsg = "": ErrMsg = "": Exit Function
            If x = 1 Then Prevu = False
        End If
        'Create mix message(s)
        Dst = MixMessage(Src, ToAddresses, Hdrs + d, r, WorkPath, ErrMsg, Chains)
        DelFile Src
        ChainMsg = Dst
    Else
        'Create CPunk chain
        gNext = "": NymLog = ""
        cSrc = Src
        For i = RCount - 1 To 0 Step -1
            On Error Resume Next
            Him!lblStat.Caption = "": Him!lblStat.Refresh
            Him!lblStat.Caption = LMsg(215) + Str(Abs(i - RCount)) + "/" + Trim(Str(RCount)) + "..." + Parts: Him!lblStat.Refresh
            On Error GoTo 0
            'Check remailer and get directives
            If i = RCount - 1 Then tempfinal = gFinal Else tempfinal = ""
            'Remix Compliant
            If RemixComp Then
                If i = RCount - 1 Then RemixMode = 2 Else RemixMode = 1
            End If
            If RBNum <> 0 And i = 0 Then NymChain = 2 Else NymChain = 0
            If Not GetDirect(Rmlr(i), rd(i), NymChain, i + 1, gNext, tempfinal, False, Warn, MsgLen, d, Garbage, Max, False, RBNum, RemixMode) Then
                DelFile cSrc
                ChainMsg = "": ErrMsg = ""
                Exit Function
            End If
            If Max.GotMax Then GotMaxDirect = True
            Remailer Rmlr(i), NymChain, rname, raddress, "", "", "", "", ""
            'Create message
            If i = RCount - 1 Then h = Hdrs Else h = ""
            If Prevu Then PrevFile = "XXXX____.tmj" Else PrevFile = ""
            'Write NymLog
            If rname = "" Then a = "" Else a = " (" + rname + ")"
            If NymChain = 0 Then r = "To: " + raddress + a + vbCrLf Else r = "To: [" + LMsg(283) + " " + raddress + a + "]" + vbCrLf
            a = vbTab + r + vbTab + vbTab + _
                Replace(d, vbCrLf, vbCrLf + vbTab + vbTab)
            If h <> "" Then a = a + "##" + vbCrLf + vbTab + vbTab + Replace(h, vbCrLf, vbCrLf + vbTab + vbTab)
            NymLog = a + vbCrLf + NymLog
            
            Dst = CPunkMessage(cSrc, raddress, d, h, (NymChain = 0), Garbage, ErrMsg, WorkPath, PrevFile, RBNum <> 0)
            If Dst = "" Then DelFile cSrc: ChainMsg = "": Exit Function
            SrcLen = FileLen(cSrc) + Val(Garbage) * 1024
            If FileLen(Dst) > SrcLen Then SrcLen = FileLen(Dst)
            If Not Prevu Or cSrc <> PrevFile Then DelFile cSrc
            cSrc = Dst
            'If Him!chkQue(0).Value = 0 Then
            '    'Abort
            '    DelFile cSrc
            '    ErrMsg = LMsg(207)
            '    ChainMsg = ""
            '    Exit Function
            'End If
            'Check Message Size
            If MsgLen <> 0 And Val(Cnf(2, 5)) = 1 Then
                If SrcLen + 1024 > MsgLen Then _
                 If MsgBox(LMsg(174) + " " + rname + vbCr + vbCr + LMsg(198) + ":" + Str(SrcLen + 1024) + vbCr + LMsg(220) + ":" + Str(MsgLen), vbInformation + vbOKCancel, LMsg(168)) = vbCancel Then DelFile cSrc: ChainMsg = "": ErrMsg = "": Exit Function
            End If
            'Show Preview
            If Prevu Then
                b = Trim(Str(Abs(i - RCount))) + "/" + Trim(Str(RCount))
                a = LMsg(197) + " " + b
                x = PreviewMsg(a, b + "   " + Parts, Rmlr(i) + vbCrLf, NymChain, False, r, PrevFile, False)
                Him.MousePointer = 13
                Him.Refresh
                If PrevFile <> cSrc Then DelFile PrevFile
                If x = -1 Or x = 2 Then DelFile cSrc: ChainMsg = "": ErrMsg = "": Exit Function
                If x = 1 Then Prevu = False
            End If
            gNext = raddress
        Next i
        Max.GotMax = GotMaxDirect
        ChainMsg = cSrc
    End If
End Function

Public Function PreviewMsg(Title, Stage, r, rtype, FinishOnly As Boolean, Hdrs, Pfile, MixTo As Boolean, Optional Job As Byte) As Integer
    'Job 0  Message Creation
    'Job 1  View Queued Mail Message
    'Job 2  View Decryption Stage
    Dim temp(MaxChain) As String, rs As String, rst As String
    'Dim blen as Long, hlen as long
    
    'Set Window Title
    Select Case rtype
    Case 0
        frmPreview.Caption = LMsg(196) + " Cypherpunk - [" + Title + "]"
    Case 1
        frmPreview.Caption = LMsg(196) + " Mixmaster - [" + Title + "]"
    Case Else
        frmPreview.Caption = LMsg(196) + " " + Title
    End Select
    'Show Lengths
    hlen = Len(Hdrs)
    If SDir(Pfile) <> "" And Pfile <> "" Then blen = FileLen(Pfile)
    'Show Remailers
    x = ParseString(r, temp(), MaxChain, False)
    For i = 0 To x
        If Remailer(temp(i), rtype, rname, raddress, roptions, lathist, rlatent, uphist, rup, rstringx, rstats) Then
            rs = rs + rstringx + vbCrLf
            If rstats = "" Then rstats = temp(i)
            rst = rst + rstats + vbCrLf
        Else
            rst = rst + temp(i) + vbCrLf
        End If
    Next i
    If x > 0 Then rs = rst + vbCrLf + rs Else rs = rst + rs
    'Stage or Profile Label
    If Job = 1 Then x = 306 Else x = 197
    If Job <> 2 Then
        frmPreview!txtInfo.Text = Left(LMsg(x) + ":          ", 10) + " " + Stage + vbCrLf + _
         Left(LMsg(198) + ":          ", 10) + " " + LMsg(199) + "=" + Trim(Str(hlen)) + "   " + _
         LMsg(200) + "=" + Trim(Str(blen)) + "   " + _
         LMsg(201) + "=" + Trim(Str(hlen + blen + 2)) + "  (" + Trim(Str(Int((hlen + blen + 2) / 1024 + 0.999))) + "k)" + vbCrLf + rs
    Else
        frmPreview!txtInfo.Text = Left(LMsg(x) + ":          ", 10) + " " + Stage + "    (" + Trim(Str(Int(blen / 1024 + 0.999))) + "k)" + vbCrLf + Hdrs
    End If
    'Buttons
    frmPreview!cmdPreview(0).Enabled = Not FinishOnly And Job <> 1
    frmPreview!cmdPreview(1).Enabled = Job <> 1
    If Job = 1 Then frmPreview!cmdPreview(2).Caption = LMsg(308) Else frmPreview!cmdPreview(2).Caption = LMsg(307)
    frmPreview!txtHeaders.Text = Hdrs
    frmPreview!cmdOpen.Tag = Pfile
    If Job <> 2 Then
        If Not FinishOnly Then x = 203 Else x = 204
        If rtype <> 1 Then
            frmPreview!lblBody.Caption = LMsg(200) + ":   (" + LMsg(x) + ")"
        Else
            frmPreview!lblBody.Caption = LMsg(200) + ":"
        End If
        frmPreview!rtbBody.Top = 2700
        frmPreview!lblHeaders.Caption = LMsg(199) + ":"
    Else
        frmPreview!rtbBody.Top = frmPreview!txtHeaders.Top
        frmPreview!lblHeaders.Caption = LMsg(469) + ":"
    End If
    On Error GoTo LoadError:
    frmPreview!rtbBody.LoadFile Pfile
    On Error Resume Next
    If MixTo Then
        x = InStr(frmPreview!rtbBody.Text, vbCrLf + vbCrLf)
        If x <> 0 Then
            frmPreview!txtHeaders.Text = Left(frmPreview!rtbBody.Text, x + 1) + frmPreview!txtHeaders.Text
            frmPreview!rtbBody.Text = Mid(frmPreview!rtbBody.Text, x + 4)
        End If
    End If
    frmPreview!cmdOpen.Enabled = Pfile <> ""
    frmPreview!cmdPreview(0).Tag = "2"
    frmPreview.Tag = "Loaded"
    frmPreview.Show 1
    PreviewMsg = Val(frmPreview!cmdPreview(0).Tag)
    frmPreview.Tag = ""
Exit Function
LoadError:
    MsgBox LMsg(0) + vbCr + Error, vbCritical, LMsg(4)
    Resume Next
End Function
    
    
'__________________________________________________________
'COMPUTATION AND PARSING
Public Function LatentValue(Latent) As Single
    Latent = Trim(Latent)
    If Latent = "" Then LatentValue = 0: Exit Function
    h = Abs(Int(Val(Latent)))
    x = InStr(Latent, ":")
    If x <> 0 Then m = Abs(Int(Val(Mid(Latent, x + 1)))) / 60
    If h > 99 Then h = 99
    If m * 60 > 99 Then m = 99 / 60
    LatentValue = h + m
End Function

Public Function XCrypt(ByVal intext As String, ByVal Key As Double) As String
    Dim xkey As Long, outtext As String, mask As Byte, CMode As Byte
        
    If Left(intext, 3) = "@@@" Then
        CMode = 0
        intext = Mid(intext, 4)
    Else: CMode = 1
    End If
    If intext = "" Or Key = 0 Then XCrypt = "": Exit Function
    If CMode = 1 Then 'Encrypt
        'Calc Checksum
        intext = intext + Chr(XHash(Left(intext, 100)) Mod 255)
        xkey = (Int(Rnd(1) * 65535) + 65535) Mod 65535
    Else
        xkey = Val("&H" + Left(intext, 4))
        If xkey < 0 Then xkey = xkey + 65536
        intext = Mid(intext, 5)
    End If
    
    mask = (Key + xkey) Mod 255
    
    For i = 1 To Len(intext) Step Abs(CMode - 2)
        If CMode = 1 Then
            x = Asc(Mid(intext, i, 1))
        Else
            x = Val("&H" + Mid(intext, i, 2))
        End If
        c = x Xor mask
        If CMode = 1 Then
            outtext = outtext + Right("0" + Hex(c), 2)
        Else
            outtext = outtext + Chr(c)
        End If
        
        'rotate password
        Key = Key + Int(100 * Abs(Sin(Key)))
        idx = idx + 1
        
        If CMode = 0 Then x = c Else x = Asc(Mid(intext, i, 1))
        mask = ((Key + x * idx) + xkey) Mod 255
    Next i
    If CMode = 0 Then
        chksum = Asc(Right(outtext, 1))
        outtext = Left(outtext, Len(outtext) - 1)
        If XHash(Left(outtext, 100)) Mod 255 <> chksum Then outtext = ""
    Else
        outtext = "@@@" + Right("000" + Hex(xkey), 4) + outtext
    End If
    XCrypt = outtext
End Function

Public Function XHash(Password As String) As Long
    Dim n As Long, i As Integer
    For i = 1 To Len(Password)
        n = n + i * Asc(Mid(Password, i, 1))
    Next i
    Hash = n + Val(Right(Password, 4))
End Function

Public Function CleanAddress(ByVal Addr) As String
    Dim d(1) As String * 1, d2(1) As String * 1, x As Integer, Y As Integer
    
    'Remove (Name) and "Name"
    d(0) = "(": d2(0) = ")"
    d(1) = Chr(34): d2(1) = Chr(34)
    For i = 0 To 1
        x = InStr(Addr, d(i))
        While x <> 0
            Y = InStr(x + 1, Addr, d2(i))
            If Y = 0 And i = 0 Then Y = InStr(x, Addr, " ")
            If Y = 0 Then Addr = Left(Addr, x - 1) Else Addr = Left(Addr, x - 1) + Mid(Addr, Y + 1)
            x = InStr(Addr, d(i))
        Wend
    Next i
    
    x = InStr(Addr, "@")
    If x = 0 Then CleanAddress = "": Exit Function
    For i = x - 1 To 1 Step -1
        a = Mid(Addr, i, 1)
        If a = " " Or a = "<" Or a = "," Or a = ")" Then i = i + 1: Exit For
    Next i
    If i = 0 Then Let i = 1
    Addr = Extract(Extract(Extract(Extract(Mid(Addr, i), " "), ","), ">"), ")")
    x = InStr(Addr, "@")
    If InStr(x, Addr, ".") = 0 Then Addr = ""
    CleanAddress = Addr
End Function


'________________________________________________________________
'CONFIG CHECKING FUNCTIONS
Public Function ProgBusy(Job)
    If CheckingConfig Then ProgBusy = True: Exit Function
    bb = False
    For i = 0 To 9
        If BookBusy(0, i) Or BookBusy(1, i) Then bb = True: Exit For
    Next i
    Select Case Job
    Case "": ProgBusy = NetBusy Or bb Or StatsBusy
    Case "Global": ProgBusy = NetBusy Or bb
    Case "Send": ProgBusy = SendingMail Or bb
    Case "Retrieval": ProgBusy = CheckingMail
    Case "News": ProgBusy = GetNewsLoaded
    Case "Remailers": ProgBusy = StatsBusy Or bb
    Case "Stats": ProgBusy = StatsBusy
    Case "Nyms": ProgBusy = bb
    Case Else: ProgBusy = False
    End Select
End Function

Public Function CheckConfig(Job, Optional NoSave As Boolean, _
                Optional FullPGPCheck As Boolean) As Boolean
    Dim ESubVersion As String * 256
    
    CheckingConfig = True
    frmMain.MousePointer = 11
Start:
    MissingCPunkKeys = False
    MissingMixKeys = False
    Msg = ""
    'Update Program Data
    Cnf(0, 0) = NoSlash(Cnf(0, 0))
    Cnf(0, 1) = NoSlash(Cnf(0, 1))
    If Cnf(0, 0) = "" Then Cnf(0, 0) = Left(ProgDir, 1) + ":\TMP"
    If Cnf(0, 1) = "" Then Cnf(0, 1) = ProgDir + "\Queue"
    If Trim(Cnf(0, 2)) = "" Then Cnf(0, 2) = "zapfile /9"
    PData(10) = Cnf(0, 0) '10 Last Global Work Folder
    PData(11) = Cnf(0, 2) '11 Last Wipe Files With
    PData(12) = Cnf(0, 3) '12 Last PGP Version
    PData(13) = Cnf(0, 4) '13 Last DOS Mode

    'Global
    If Job = "Global" Or Job = "Remailers" Or Job = "" Then
        Upd = "R"
        If Not CreateDir(PData(10)) Then Msg = LMsg(35) + ": " + PData(10) + vbCrLf
        If Len(PData(10)) > 7 Then Msg = Msg + LMsg(36) + vbCrLf
        Cnf(0, 1) = NoSlash(Cnf(0, 1))
        If Not CreateDir(Cnf(0, 1)) Then Msg = Msg + LMsg(60) + vbCrLf
        
        'PGP
        If Val(PData(12)) = 0 Then
            'PGP 2.6.x
            pgppath = NoSlash(Environ("PGPPATH"))
            If pgppath = "" Then
                Msg = Msg + LMsg(39) + "  " + LMsg(41) + vbCrLf
            Else
                If SDir(pgppath + "\config.txt") = "" Then
                    Msg = Msg + LMsg(42) + ": " + pgppath + "\config.txt" + vbCrLf
                Else
                    Msg = Msg + PGPConfig(pgppath)
                End If
                pth = Trim(Environ("PATH"))
                If InStr(1, pth + ";", pgppath + ";", vbTextCompare) = 0 And InStr(1, pth + ";", pgppath + "\;", vbTextCompare) = 0 Then
                    Msg = Msg + LMsg(40) + "  " + LMsg(41) + vbCrLf
                Else
                    Msg = Msg + CheckPGPRing(MissingCPunkKeys, FullPGPCheck)
                End If
            End If
        Else
            Msg = Msg + CheckPGPRing(MissingCPunkKeys, FullPGPCheck)
        End If
    
        'Mixmaster
        Cnf(1, 15) = NoSlash(Cnf(1, 15))
        Cnf(1, 19) = NoSlash(Cnf(1, 19))
        'Files
        If Cnf(1, 20) = "" Then Cnf(1, 20) = "type2.lis"
        If Cnf(1, 21) = "" Then Cnf(1, 21) = "pubring.mix"
        If Cnf(1, 22) = "" Then Cnf(1, 22) = "mixmaste.htm"
        'Environment and Check
        If Cnf(1, 15) <> "" Then
            b = Environ("MIXPATH")
            If b <> "" Then
                If Cnf(1, 19) <> "" Then
                    Cnf(1, 19) = b
                Else
                    If LCase(Cnf(1, 15)) <> LCase(b) Then Cnf(1, 19) = b
                End If
            End If
            Msg = Msg + CheckMix(MissingMixKeys)
        End If
    End If
    
    'Remailers
    If Job = "Remailers" Or Job = "" Then
        Upd = "R"
        Cnf(1, 10) = Trim(Str(Abs(Val(Cnf(1, 10)))))
        Cnf(1, 12) = Trim(Str(Abs(Int(Val(Cnf(1, 12))))))
        Cnf(1, 17) = Trim(Str(Abs(Val(Cnf(1, 17)))))
    End If
    
    'Retrieval
    If Job = "Retrieval" Or Job = "" Then
        Upd = "P"
        b = LMsg(56) 'Retrieval
        For i = 0 To 14
            If Val(UserProf(i, 0)) = 1 Then
                msg2 = ""
                If UserProf(i, 3) <> "False" Then
                    'Folder
                    If UserProf(i, 10) <> "" Then If Not CreateDir(UserProf(i, 10)) Then msg2 = msg2 + "     " + LMsg(48) + ": " + UserProf(i, 10) + vbCrLf
                Else
                    'File
                    If UserProf(i, 10) = "" Or PlainName(UserProf(i, 10), 0) = "" Or Not CreateDir(PlainName(UserProf(i, 10), 0)) Then msg2 = msg2 + "     " + LMsg(48) + ": " + UserProf(i, 10) + vbCrLf
                End If
                If UserProf(i, 6) = "" Or UserProf(i, 7) = "" Then msg2 = msg2 + "     " + LMsg(49) + vbCrLf
                For j = 9 To 16 Step 7
                    UserProf(i, j) = Trim(Str(Abs(SVal(UserProf(i, j)))))
                Next j
                If SVal(UserProf(i, 9)) < 5 Then UserProf(i, 9) = "5"
                If SVal(UserProf(i, 16)) <= 0 Then UserProf(i, 16) = "": UserProf(i, 15) = "0"
                a = UserProf(i, 5): If a = "" Then a = Str(i + 1)
                If msg2 <> "" Then UserProf(i, 0) = "": Msg = Msg + LMsg(50) + " " + b + "|" + a + ":" + vbCrLf + msg2
            End If
        Next i
    End If
    
    'Send
    If Job = "Send" Or Job = "" Then
        Upd = "P"
        b = LMsg(57) 'Send
        ValidSend = False
        For i = 15 To 29
            If Val(UserProf(i, 0)) = 1 Then
                msg2 = ""
                If InStr(1, UserProf(i, 3), "From:", vbTextCompare) = 1 Then UserProf(i, 3) = Trim(Mid(UserProf(i, 3), 6))
                If InStr(1, UserProf(i, 4), "Reply-To:", vbTextCompare) = 1 Then UserProf(i, 4) = Trim(Mid(UserProf(i, 4), 10))
                If UserProf(i, 2) = "" Then msg2 = msg2 + "     " + LMsg(51) + vbCrLf
                If CleanAddress(UserProf(i, 3)) = "" Then msg2 = msg2 + "     " + LMsg(52) + vbCrLf
                If Trim(UserProf(i, 4)) <> "" And CleanAddress(UserProf(i, 4)) = "" Then msg2 = msg2 + "     " + LMsg(404) + vbCrLf
                If Trim(UserProf(i, 5)) <> "" And CleanAddress(UserProf(i, 5)) = "" Then msg2 = msg2 + "     " + LMsg(53) + vbCrLf
                a = UserProf(i, 1): If a = "" Then a = Str(i - 14)
                If msg2 <> "" Then UserProf(i, 0) = "": Msg = Msg + LMsg(50) + " " + b + "|" + a + ":" + vbCrLf + msg2
                If Val(UserProf(i, 0)) = 1 Then ValidSend = True
            End If
        Next i
        If Val(UserProf(30, 0)) = 1 Then
            msg2 = ""
            If UserProf(30, 3) = "" Then msg2 = msg2 + "     " + LMsg(54) + vbCrLf
            If UserProf(30, 4) = "" Then
                 msg2 = msg2 + "     " + LMsg(48) + vbCrLf
            Else
                If UserProf(30, 1) = "True" Then If Not CreateDir(UserProf(30, 4)) Then msg2 = msg2 + "     " + LMsg(48) + vbCrLf
            End If
            If UserProf(30, 5) = "" Then msg2 = msg2 + "     " + LMsg(52) + vbCrLf
            If msg2 <> "" Then UserProf(30, 0) = "": Msg = Msg + LMsg(50) + " UNIX:" + vbCrLf + msg2
            If Val(UserProf(30, 0)) = 1 Then ValidSend = True
        End If
        frmMain!chkSend.Enabled = ValidSend
        If Not ValidSend Then frmMain!chkSend.Value = 0
    End If

    'News
    If Job = "News" Or Job = "" Then
        Upd = "P"
        b = LMsg(58) 'News
        For i = 31 To 45
            If Val(UserProf(i, 0)) = 1 Then
                msg2 = ""
                If UserProf(i, 3) <> "False" Then
                    'Folder
                    If UserProf(i, 10) <> "" Then If Not CreateDir(UserProf(i, 10)) Then msg2 = msg2 + "     " + LMsg(48) + ": " + UserProf(i, 10) + vbCrLf
                Else
                    'File
                    If UserProf(i, 10) = "" Or PlainName(UserProf(i, 10), 0) = "" Or Not CreateDir(PlainName(UserProf(i, 10), 0)) Then msg2 = msg2 + "     " + LMsg(48) + ": " + UserProf(i, 10) + vbCrLf
                End If
                If UserProf(i, 6) = "" Then msg2 = msg2 + "     " + LMsg(49) + vbCrLf
                UserProf(i, 9) = Trim(Str(Abs(Val(UserProf(i, 9)))))
                If Val(UserProf(i, 9)) < 5 Then UserProf(i, 9) = "5"
                If Trim(Replace(UserProf(i, 11), vbCrLf, "")) = "" Or InStr(UserProf(i, 11), "*") + InStr(UserProf(i, 11), ",") <> 0 Then msg2 = msg2 + "     " + LMsg(544) + vbCrLf
                a = UserProf(i, 5): If a = "" Then a = Str(i + 1)
                'Esub
                If InStr(1, UserProf(i, 12) + UserProf(i, 13), "esub:", vbTextCompare) <> 0 And Not TestedEsub Then
                    'Test for ESUB support
                    On Error Resume Next
                    ESubVersion = Chr(0)
                    psEsub32DLLVersion (ESubVersion)
                    On Error GoTo 0
                    If Left(ESubVersion, 1) = Chr(0) Then msgesub = LMsg(552) + vbCrLf
                    TestedEsub = True
                End If
                If msg2 <> "" Then UserProf(i, 0) = "": Msg = Msg + LMsg(50) + " " + b + "|" + a + ":" + vbCrLf + msg2
            End If
        Next i
        If msgesub <> "" Then Msg = Msg + msgesub
    End If
    
    'Addresses
    If Job = "Addresses" Or Job = "" Then
        Upd = "A"
    End If
        
    'Books
    If Job = "Books" Or Job = "" Then Upd = "HR"
    
    'Stats
    If Job = "Stats" Or Job = "" Then
        Cnf(3, 19) = NoSlash(Cnf(3, 19))
        If Not CreateDir(Cnf(3, 19)) Then Msg = Msg + LMsg(365) + ": " + Cnf(3, 19) + vbCrLf
        If LCase(Cnf(3, 19)) = LCase(PData(10)) Then Msg = Msg + LMsg(366) + vbCrLf
        If Val(Cnf(3, 18)) < 1 Then Cnf(3, 18) = "1"
    End If
    
    'Retrieval Config
    If Job = "Ret" Or Job = "" Then
        Upd = ""
        Cnf(4, 0) = NoSlash(Cnf(4, 0))
        Cnf(4, 1) = NoSlash(Cnf(4, 1))
        If Not CreateDir(Cnf(4, 0) + "\") Or Not CreateDir(Cnf(4, 0) + "\Inbox") Then Msg = Msg + LMsg(472) + vbCrLf
        If SDir(Cnf(4, 1) + "\*.TBK") = "" Then Msg = Msg + LMsg(473) + vbCrLf
    End If
        
    'Write
    If Not NoSave Then SaveConfig
    'Display
    If Msg <> "" Then MsgBox LMsg(59) + ":" + vbCrLf + vbCrLf + Msg, vbExclamation, LMsg(101)
    'Update
    If Job = "Global" Then Upd = "RKF": MainLoadList ("Fonts")
    If Job = "" Then Upd = "X"
    UpdateBooks (Upd)
    If (Job = "" Or Job = "Stats") And BrowserLoaded Then frmWeb!tmrLoad.Tag = ":::Reload:::":  frmWeb!tmrLoad.Enabled = True
    If Job = "Ret" And ViewerLoaded Then frmViewer!tmrUpdate.Tag = "R":  frmViewer!tmrUpdate.Enabled = True
    If Job = "" And (MissingCPunkKeys Or MissingMixKeys) Then Msg = "X"
    CheckConfig = Msg = ""
    frmMain.MousePointer = 0
    CheckingConfig = False
End Function

Public Function PendingConfig() As Boolean
    For i = 0 To 5
        If PendingCfg(i) Then PendingConfig = True: Exit Function
    Next i
PendingConfig = False
End Function

Private Function PGPConfig(pgppath) As String
    Dim NeedUpdate As Boolean, FoundAL As Boolean
    Dim Tmp(2) As String
    
    On Error GoTo ConfigError
    FoundAL = False
    n = FreeFile
    Open pgppath + "\config.txt" For Input As n
    Do While Not EOF(n)
        Line Input #n, a
        If InStr(a, "=") <> 0 Then
            b = LCase(Extract(Extract(LTrim(a), "="), " "))
            Select Case b
            Case "armorlines"
                If LCase(Replace(a, " ", "")) <> "armorlines=0" Then NeedUpdate = True
                FoundAL = True
            Case "encrypttoself"
                If InStr(1, Replace(a, " ", ""), "=off", vbTextCompare) = 0 Then NeedUpdate = True
            End Select
        End If
    Loop
    Close n: n = 0
    If NeedUpdate Or Not FoundAL Then
        Tmp(0) = "Armorlines = 0"
        Tmp(1) = "MyName = YouForgotToSpecifySignID"
        Tmp(2) = "EncryptToSelf = OFF"
        If MsgBox(LMsg(44), vbYesNo, LMsg(6)) = vbNo Then PGPConfig = LMsg(43) + vbCrLf: Exit Function
        n = FreeFile
        Open pgppath + "\config.txt" For Input As n
        p = FreeFile
        Open pgppath + "\config_.tmj" For Output As p
        While Not EOF(n)
            Line Input #n, a
            b = LCase(Extract(Extract(LTrim(a), "="), " "))
            Select Case b
            Case "armorlines"
                Print #p, Tmp(0): Tmp(0) = ""
            Case "myname"
                Print #p, Tmp(1): Tmp(1) = ""
            Case "encrypttoself"
                Print #p, Tmp(2): Tmp(2) = ""
            Case Else
                Print #p, a
            End Select
        Wend
        For i = 0 To 2
            If Tmp(i) <> "" Then Print #p, Tmp(i)
        Next i
        Close p: p = 0
        Close n: n = 0
        FileCopy pgppath + "\config_.tmj", pgppath + "\config.txt"
        DelFile pgppath + "\config_.tmj"
    End If
    PGPConfig = ""
Exit Function
ConfigError:
    PGPConfig = LMsg(43) + vbCrLf + Error + vbCrLf
    CloseFile n
    CloseFile p
End Function

Public Function CheckPGPRing(MissingCPunkKeys, FullPGPCheck As Boolean) As String
    Dim CheckValue As Byte
    Dim sKeyID As String * 1024, i As Long
    Dim FullCheck As String
    
Start:
    MissingCPunkKeys = False
    On Error GoTo CheckPGPError
    ReadPGPKeys
    If Val(PData(12)) <> 0 Then
        'PGP 5.x
        ReDim tempkey(MaxPubKeys) As String
        Dim tempkeyX As Long
            
        'Clean Active List
        tempkeyX = 0
        For i = 0 To PubKeyX - 1
            tkeyid = Extract(PubKeys(i), vbTab)
            tuserid = Mid(PubKeys(i), Len(tkeyid) + 2)
            If tkeyid <> "" And tuserid <> "" Then
                Found = -1
                For j = 0 To KeyArrayCount - 1
                    If tkeyid = KeyArray(j).KeyID Then Found = j: Exit For
                Next j
                If Found <> -1 Then
                    If KeyArray(Found).UserID = tuserid Then tempkey(tempkeyX) = PubKeys(i): tempkeyX = tempkeyX + 1
                End If
            End If
        Next i
        If tempkeyX <> 0 Then
            ReDim PubKeys(tempkeyX - 1)
            For i = 0 To tempkeyX - 1
                PubKeys(i) = tempkey(i)
            Next i
        End If
        PData(14) = Str(tempkeyX)
    End If
    
    'Every Remailer Key
    If Msg = "" Then
        x = 0: Y = 0: msg2 = "": msg3 = "": AllNames = vbCr
        Do While RString(x) <> ""
            RemailerString RString(x), rname, raddress, roptions
            If rname = "" Or raddress = "" Then
                'Bad string
                msg3 = msg3 + LMsg(37) + ":" + vbCrLf + "      " + RString(x) + vbCrLf
            Else
                If InStr(AllNames, vbCr + rname + vbCr) <> 0 Then msg3 = msg3 + LMsg(412) + " " + rname + vbCrLf Else AllNames = AllNames + rname + vbCr
                If ((InStr(roptions, " pgp ") <> 0 And InStr(roptions, " cpunk ") <> 0) Or InStr(roptions, " newnym ") <> 0) And InStr(PData(43), raddress + vbCrLf) = 0 Then
                    If FullPGPCheck Or Val(PData(12)) = 0 Then FullCheck = "X" Else FullCheck = ""
                    If FindPGPKey(raddress, False, FullCheck) = "" Then
                        If Val(PData(12)) <> 0 Then
                            If LCase(Left(raddress, 2)) = "0x" And Len(raddress) = 10 Then
                                sKeyID = raddress + Chr(0)
                            Else
                                sKeyID = "<" + Left(raddress, 1020) + ">" + Chr(0)
                            End If
                            i = spgpKeyIsOnRing(sKeyID)
                        Else
                            i = 1
                        End If
                        If Y <> 2 And i <> 0 Then
                            'Inform user of Missing key
                            CheckValue = 0
                            If (RASConnected Or PData(54) = "True") And Not UpdatingKeys Then a = "Get &Keys" Else a = ""
                            Y = MsgTime(LMsg(184) + vbCr + vbCr + rname + " <" + raddress + ">", 0, LMsg(18), 999, 1, 0, "&OK", "OK To &All", a, LMsg(185), CheckValue)
                            If CheckValue = 1 Then
                                'Add key to No Warnings
                                PData(43) = PData(43) + raddress + vbCrLf
                            Else
                                MissingCPunkKeys = True
                            End If
                            If Y = 3 Then
                                'Get Keys
                                CallBrowser 2, ""
                                GoTo Start
                            End If
                        End If
                    Else
                        msg2 = msg2 + FullCheck
                    End If
                End If
            End If
            x = x + 1: If x > MaxRemailers Then Exit Do
        Loop
        Msg = msg3 + msg2
    End If
    If Msg <> "" Then CheckPGPRing = Msg Else CheckPGPRing = ""
Exit Function
CheckPGPError:
    CheckPGPRing = LMsg(32) + " " + PData(16) + vbCrLf
    PData(16) = "": PData(14) = "0"
End Function

Public Function CheckMix(MissingMixKeys) As String
    Dim pubring As String, a As String, mixtmp(10) As String
    
    a = Cnf(1, 15) + "\mixmaste.exe"
    mixpath = Cnf(1, 19)
    If mixpath = "" Then mixpath = Cnf(1, 15)
    t2 = Cnf(1, 20)
    If InStr(t2, "\") = 0 Then t2 = mixpath + "\" + t2
    pm = Cnf(1, 21)
    If InStr(pm, "\") = 0 Then pm = mixpath + "\" + pm
    If SDir(a) = "" Then Msg = Msg + LMsg(45) + ": " + a + vbCrLf
    'MixRand
    If SDir(mixpath + "\mixrand.bin") = "" Then
        DOSShell "mixmaste -X", 99, "NUL", "", Cnf(1, 15), 2
        If SDir(mixpath + "\mixrand.bin") = "" Then Msg = Msg + LMsg(435) + vbCrLf
    End If
Start:
    MissingMixKeys = False
    If SDir(t2) = "" Then Msg = Msg + LMsg(45) + ": " + t2 + vbCrLf
    If SDir(pm) = "" Then Msg = Msg + LMsg(45) + ": " + pm + vbCrLf
    If Msg = "" Then
        Y = 0
        p = FreeFile
        Open pm For Input As p
        pubring = Input(LOF(p), p)
        Close p: p = 0
        l = FreeFile
        Open t2 For Input As l
        While Not EOF(l)
            Line Input #l, b
            a = LTrim(b)
            If a <> "" Then
                'Check for cap string
                Remailer Extract(a, " "), -1, rname, raddress, roptions, lathist, rlatent, uphist, rup, rstringx
                If rstringx = "" Then
                    'Make cap string
                    e = Extract(LTrim(Mid(a, InStr(a, " ") + 1)), " ")
                    If InStr(e, "@") <> 0 Then
                        ro = Right(a, 9)
                        ropt = "mix"
                        If InStr(ro, "N") <> 0 Then ropt = ropt + " post"
                        If InStr(ro, "M") <> 0 Then ropt = ropt + " middle"
                        '$remailer{"xxxxxxx"} = "<xxxxxx@xxxxxx.net> cpunk mix middle pgp latent ek cut hash ksub post repgp2 remix2 reord test rhop3 inflt10 klen293";
                        rstringx = "$remailer{" + Chr(34) + rname + Chr(34) + "} = " + Chr(34) + "<" + e + "> " + ropt + Chr(34) + ";"
                        x = 0
                        Do While RString(x) <> ""
                            x = x + 1: If x > MaxRemailers Then Exit Do
                        Loop
                        If x <= MaxRemailers Then RString(x) = rstringx
                    End If
                End If
                'Check for key
                For i = 1 To 2
                    a = LTrim(Mid(a, InStr(a, " ") + 1))
                Next i
                a = Extract(a, " ")
                If InStr(pubring, "-----Begin Mix Key-----" _
                   + vbCrLf + a + vbCrLf) = 0 Then _
                   Msg = Msg + Trim(b) + vbCrLf
            End If
        Wend
        Close l: l = 0
        If Msg <> "" Then
            'Inform user of Missing key
            CheckValue = 0
            If (RASConnected Or PData(54) = "True") And Not UpdatingKeys Then a = "Get &Keys" Else a = ""
            Y = MsgTime(LMsg(46) + vbCr + vbCr + Msg, 0, LMsg(18), 999, 1, 0, "&OK", a, "")
            Msg = ""
            If Y = 2 Then
                'Get Keys
                CallBrowser 3, ""
                GoTo Start
            End If
            MissingMixKeys = True
        End If
        
        If Val(Cnf(1, 3)) = 1 Then
            'Maintain Mixmaste.con
            If SDir(mixpath + "\mixmaste.con") = "" Then
                Msg = Msg + LMsg(45) + ": " + mixpath + "\mixmaste.con" + vbCrLf
            Else
                mixtmp(0) = "MINREL " + Cnf(1, 17)
                mixtmp(1) = "MAXLAT " + Cnf(1, 16)
                mixtmp(2) = "DISTANCE " + Cnf(1, 18)
                mixtmp(3) = "REMAILERLIST " + Cnf(1, 20)
                mixtmp(4) = "PUBRING " + Cnf(1, 21)
                mixtmp(5) = "RELLIST " + Cnf(1, 22)
                mixtmp(6) = "VERBOSE 1"
                mixtmp(7) = "ERRSTDOUT 1"
                n = FreeFile
                Open mixpath + "\mixmaste.con" For Input As n
                p = FreeFile
                Open mixpath + "\mixcon_.tmj" For Output As p
                While Not EOF(n)
                    Line Input #n, a
                    b = Extract(UCase(LTrim(a)), " ")
                    Select Case b
                    Case "MINREL"
                        Print #p, mixtmp(0): mixtmp(0) = ""
                    Case "MAXLAT"
                        Print #p, mixtmp(1): mixtmp(1) = ""
                    Case "DISTANCE"
                        Print #p, mixtmp(2): mixtmp(2) = ""
                    Case "REMAILERLIST"
                        Print #p, mixtmp(3): mixtmp(3) = ""
                    Case "PUBRING"
                        Print #p, mixtmp(4): mixtmp(4) = ""
                    Case "RELLIST"
                        Print #p, mixtmp(5): mixtmp(5) = ""
                    Case "VERBOSE"
                        Print #p, mixtmp(6): mixtmp(6) = ""
                    Case "ERRSTDOUT"
                        Print #p, mixtmp(7): mixtmp(7) = ""
                    Case Else
                        Print #p, a
                    End Select
                Wend
                Close n: n = 0
                For i = 0 To 7
                    If mixtmp(i) <> "" Then Print #p, mixtmp(i)
                Next i
                Close p: p = 0
                FileCopy mixpath + "\mixcon_.tmj", mixpath + "\mixmaste.con"
                DelFile mixpath + "\mixcon_.tmj"
            End If
        End If
    End If
    CheckMix = Msg
Exit Function
MixError:
    CheckMix = LMsg(47) + vbCrLf
    CloseFile p
    CloseFile l
End Function

Public Function ConvertEOL(f, ErrMsg, Optional ByVal BinaryMode As Boolean) As String
    'Converts Lf to CrLf and converts chr(0) and chr(26) to spaces
    'If file is Cr only, converts to CrLf
    Dim a As String
    
    ErrMsg = ""
Start:
    On Error GoTo ConvertError
    f2 = GetWork
    n = FreeFile
    If BinaryMode Then
        Open f For Binary As n
    Else
        Open f For Input As n
    End If
    p = FreeFile
    Open f2 For Output As p
    While Seek(n) <= LOF(n)
        'Read chunk
        x = LOF(n) - Seek(n) + 1: If x > 10000 Then x = 10000
        If Not BinaryMode Then On Error GoTo InputError
        a = Input(x, n)
        On Error GoTo ConvertError
        'Clean binary data
        a = Replace(a, Chr(0), " ")
        a = Replace(a, Chr(26), " ")
        'Cr only? - Change to Lf
        If InStr(a, vbLf) = 0 Then
            a = Replace(a, vbCr, vbLf)
        End If
        'Need to clean Cr?
        StripCr = InStr(a, vbCr) <> 0
        'Parse
        Y = 1
        x = InStr(a, vbLf)
        While x <> 0
            If StripCr Then
                Print #p, Extract(Mid(a, Y, x - Y), vbCr)
            Else
                Print #p, Mid(a, Y, x - Y)
            End If
            Y = x + 1
            x = InStr(Y, a, vbLf)
        Wend
        Print #p, Extract(Mid(a, Y), vbCr);
    Wend
    Close p: p = 0
    Close n: n = 0
    ConvertEOL = f2
Exit Function
ConvertError:
    ErrMsg = Error
    CloseFile n
    CloseFile p
    DelFile f2
    ConvertEOL = ""
Exit Function
InputError:
    errnum = Err.Number
    Resume InputError2
InputError2:
    If errnum = 62 And Not BinaryMode Then
        CloseFile n: n = 0
        CloseFile p: p = 0
        DelFile f2: f2 = ""
        BinaryMode = True
        GoTo Start
    Else
        GoTo ConvertError
    End If
End Function

Public Function BinFile(fn) As Boolean
    Dim bin As Boolean, xErr As Long, x As Long, Y As Long

    bin = False
    n = FreeFile
    Open fn For Input As n
    On Error GoTo BinError
    Do
        x = LOF(n) - Seek(n) + 1: If x > 16384 Then x = 16384
        a = Input(x, n): Y = Y + x
        If a Like "*[" + BinChars + "]*" Then bin = True
    Loop Until LOF(n) - Seek(n) + 1 <= 0 Or bin Or Y > 65535
    Close n: n = 0
    BinFile = bin
Exit Function
BinError:
    xErr = Err.Number
    CloseFile n
    If xErr = 62 Then BinFile = True Else Err.Raise xErr
End Function

