Attribute VB_Name = "Main"
'   IMPORTANT - READ THIS LICENSE
'
'   Jack B. Nymble v2 is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License Version 2.
'
'   Please see LICENSE.TXT for the terms and conditions of the license.
'
'   Jack B. Nymble v2, Copyright 1999 Potato Software
'
'
'
' Recommended compiler: Microsoft Visual Basic 6.0 SP3 (v5.0SP3 also ok)
' JBN2 requires a licensed copy of Catalyst SocketTools 2.1 or later (3.1)
' <http://www.catalyst.com/>; SPGP.DLL v2.2.3.2 or later, copyright 1999
' S.R. Heller  <http://www.oz.net/~srheller/privacy/pgp/spgp/spgp.htm>;
' Netmaster's FastNet ActiveX controls (freeware,
' formerly MS Internet control pack) <http://www.netmastersllc.com/home/>;
' and devSoft IPWorks <http://www.dev-soft.com/>  (Only Netcod35.ocx is
' used from this package for MIME support)

'Compile Notes:
'   When compiling with any devSoft component, the following is recommended
'   to avoid erroneous licensing pop-up screens on users' systems:
'   1) Delete the Netcod35 control from Main.frm
'   2) Remove the component from Project|Components
'   3) Save the project
'   4) Close VB.  Delete temp files from C:\Windows\Temp
'   5) Open VB, add the netcod35 component and add to main.frm
'   6) Save and compile.  (Do not run in the IDE before compiling)
'   Generally this procedure must be performed before every compile.
'   For best results also add the TypeLib license key (in your registry)
'   to destination.
'
'Netmaster NNTPCT.OCX Deploy Info:
'   Add files to destination computer in this order:
'   MSVCRT40.DLL
'   NMORENU.DLL
'   NMSCKN.DLL
'   NMOCOD.DLL   (Register!)
'   NNTPCT.OCX   (Register!)
'   Also MFC42 support which includes MFC42.DLL and MSVCRT.DLL
'   Add this key to destination computer:
'   HKEY_CLASSES_ROOT\Licenses\86c3e880-5595-11cf-96e7-0080c7c3c284 = lieuqkjdgoqpnntpct


Public Const IDE = False  'Set to False to compile
Public Const Version = "2.1.4"    'Add your version indicator here
Public Const LangVersion = "L12"
Public LMsg() As String, LeftWin As Double, RightWin As Double
Public ProgDir As String, DataDir As String, BrandNew As Boolean
Public Const NextPart = "=============================================Next_Part==="
Public Const Radix64 = "jcDEqTGCXJMbgvr7H6OapPu9xUoV83de1Azf4LYFsKBklit+S5nmWIywZ2h/R0NQ"
Public Const BeginPGP = "-----BEGIN PGP MESSAGE-----"
Public Const EndPGP = "-----END PGP MESSAGE-----"
Public Const BeginSig = "-----BEGIN PGP SIGNED MESSAGE-----"
Public Const EndSig = "-----END PGP SIGNATURE-----"
Public BinChars As String
Public gmtoffset As Double, AlterDate As Double, BadTime As Boolean
Public AutoTest As String

'Program And Config Data
Public Const MaxPData = 175
Public PData(MaxPData) As String
Public Const MaxCnf = 8
Public Const MaxCnfItem = 40
Public Cnf(MaxCnf, MaxCnfItem) As String
Public Const MaxProfile = 45  ' POP 0-14; SMTP 15-30, NNTP 31-45
Public Const MaxProfileItem = 16
Public UserProf(MaxProfile, MaxProfileItem) As String
Public Const MaxAddr = 1000
Public Addr(MaxAddr) As String, AddrCount As Integer
Public Const MaxNyms = 200
Public Nyms(MaxNyms, 3) As String
Public KeyPass(MaxNyms, 1) As String
Public Const MaxBookmarks = 200
Public Bookmarks(200, 1) As String
Public SecurePass As String

Public Const SessionTop = 6
Public SessionStart As Integer, Session(SessionTop) As Integer
Public AbortSession As Boolean
Public Const MaxKeepDate = 50
Public KeepDate(MaxKeepDate) As Date
Public ConfigEdit As Boolean, NetBusy As Boolean, DummyBusy As Boolean
Public IEstablished As Boolean
Public BrowserLoaded As Boolean, BrowserJob As String, WebAbort As Boolean
Public CheckingConfig As Boolean, PendingCfg(6) As Boolean
Public UpdatingKeys As Boolean, StatsBusy As Boolean
Public EncoderBusy As Boolean
Public NARLoaded As Boolean
Public GlobalCancel As Integer
Public CheckNewsAll As Boolean, AbortRetrieve As Boolean, CheckingMail As Boolean
Public GetNewsLoaded As Boolean
Public NewMessages As Long
Public NymDataBusy As Boolean, RBTagLocation As String
Public ViewerLoaded As Boolean, ViewerCurBox As String
Public StatMain As String, StatDec As String, ErrorSummary As String

'Decryption
Public DecQ() As String
Public DecQCount As Long, MaxDecQ As Long, DecQBusy As Boolean
Public Decrypting As Boolean, ReserveMailFile As String
Public CancelDecrypt As Boolean, ReserveDecFile As String

'Remailer Data
Public Const MaxRemailers = 300
Public Const MaxChain = 50
Public RString(MaxRemailers) As String
Public RemStats(1, MaxRemailers) As String

'PGP Data
'PGP 2.6.x  PubKeys holds all PGP UserIDs
'PGP 5.x    PubKeys empty
Public PubKeys() As String
Public Const MaxPubKeys = 1000
Public SecretOnly As Boolean

'DOS Data
Public DOSDump As String, DOSTag As String

'Window Data
Public MsgBook(9) As frmBook, MsgBookName(9) As String
Public NymBook(9) As frmNBook, NymBookName(9) As String
Public BookBusy(1, 9) As Boolean

'Finger
Public FingerUser As String, FingerConnecting As Boolean, FingerText As String

Public Type MaxType
    NeedMax As Boolean
    MaxSize As String
    MaxCount As String
    MaxDate As String
    MaxHours As Double
    GotMax As Boolean
End Type

Public Sub WriteData()
    Dim temp() As String
    
    PData(10) = Cnf(0, 0) '10 Last Global Work Folder
    PData(11) = Cnf(0, 2) '11 Last Wipe Files With
    PData(12) = Cnf(0, 3) '12 Last PGP Version
    PData(13) = Cnf(0, 4) '13 Last DOS Mode
    
    'Clean No Key Warnings
    ReDim temp(MaxRemailers)
    x = ParseString(PData(43), temp(), MaxRemailers, False)
    For i = 0 To x
        If Remailer(temp(i), -1, "", "", "", "", "", "", "") Then
            a = a + temp(i) + vbCrLf
        End If
    Next i
    PData(43) = a
    
    n = FreeFile
    Open DataDir + "\JBNData.tmj" For Output As n
    Print #n, "NYMBLE_DATA"
    Print #n,
    Print #n, "Jack B. Nymble Program Data File"
    Print #n, "DO NOT EDIT"
    Print #n, "This file is not designed to be edited."
    Print #n, "Doing so may cause serious problems."
    Print #n,
    Print #n,
    Print #n, "---Updated"
    Write #n, SafeTime
    Print #n,
    Print #n, "---Version"
    Print #n, Version
    Print #n,
    WriteArray n, PData(), "PData", MaxPData, -1, False
    WriteArray n, RString(), "RString", MaxRemailers, -1, True
    WriteArray n, RemStats(), "RemStats", 1, MaxRemailers, True
    If Val(PData(12)) = 0 Then _
     WriteArray n, PubKeys(), "PubKeys", Val(PData(14)) - 1, -1, True
    'KeepDate
    ReDim temp(MaxKeepDate)
    For i = 0 To MaxKeepDate
        temp(i) = KeepDate(i)
    Next i
    WriteArray n, temp(), "KeepDate", MaxKeepDate, -1, False
    Print #n,
    Close n: n = 0
    FileCopy DataDir + "\JBNData.tmj", DataDir + "\JBNData.DAT"
    DelFile DataDir + "\JBNData.tmj"
Exit Sub
WriteError:
    MsgBox LMsg(3) + " " + DataDir + "\JBNData.DAT" + vbCr + Error, vbCritical, LMsg(4)
    CloseFile n
End Sub

Public Sub ReadData()
    Dim temp() As String
    
    On Error GoTo ReadError
    If SDir(DataDir + "\JBNData.DAT") = "" Then Exit Sub
    BrandNew = False
    Erase PData
    n = FreeFile
    Open DataDir + "\JBNData.DAT" For Input As n
    Line Input #n, a
    If a <> "NYMBLE_DATA" Then Close n: Exit Sub
    While Not EOF(n)
        Line Input #n, a
        Select Case a
        Case "---BrandNew"
            BrandNew = True
        Case "---Version"
            DataVersion = a
        Case "-=-PData"
            ReadArray n, PData(), MaxPData, -1
        Case "-=-RString"
            ReadArray n, RString(), MaxRemailers, -1
        Case "-=-RemStats"
            ReadArray n, RemStats(), 1, MaxRemailers
        Case "-=-PubKeys"
            ReDim PubKeys(Val(PData(14)))
            ReadArray n, PubKeys(), Val(PData(14)), -1
        Case "-=-KeepDate"
            ReDim temp(MaxKeepDate)
            ReadArray n, temp(), MaxKeepDate, -1
        End Select
    Wend
    Close n: n = 0
    On Error Resume Next
    For i = 0 To MaxKeepDate
        KeepDate(i) = temp(i)
    Next i
Exit Sub
ReadError:
    MsgBox "An error occured reading program data file " + DataDir + "\JBNData.DAT", vbCritical, "Read Error"
    CloseFile n
End Sub

Public Function WriteConfig(fn) As String
    On Error GoTo WriteError
    n = FreeFile
    Open fn For Output As n
    Print #n, "JBN_CONFIG"
    Print #n,
    Print #n, "Jack B. Nymble User Configuration File"
    Print #n, "DO NOT EDIT"
    Print #n, "This file is not designed to be edited."
    Print #n, "Doing so may cause serious problems."
    Print #n,
    Print #n,
    Print #n, "---Updated"
    Write #n, SafeTime
    Print #n,
    Print #n, "---Version"
    Print #n, Version
    Print #n,
    'Cnf Data
    Cnf(0, 11) = XCrypt(Cnf(0, 11), LeftWin)
    WriteArray n, Cnf(), "Cnf", MaxCnf, MaxCnfItem, False
    Cnf(0, 11) = XCrypt(Cnf(0, 11), LeftWin)
    'UserProf
    For i = 0 To 45
        If i = 15 Then i = 31
        UserProf(i, 8) = XCrypt(UserProf(i, 8), LeftWin)
    Next i
    WriteArray n, UserProf, "UserProf", MaxProfile, MaxProfileItem, False
    For i = 0 To 45
        If i = 15 Then i = 31
        UserProf(i, 8) = XCrypt(UserProf(i, 8), LeftWin)
    Next i
    WriteArray n, Addr(), "Addr", AddrCount - 1, -1, False
    WriteArray n, Nyms(), "Nyms", MaxNyms, 3, True
    WriteArray n, KeyPass(), "KeyPass", MaxNyms, 1, True
    WriteArray n, Bookmarks(), "Bookmarks", MaxBookmarks, 1, True
    Print #n,
    Close n: n = 0
    WriteConfig = ""
Exit Function
WriteError:
    WriteConfig = LMsg(1) + " " + fn + vbCr + Error
    CloseFile n
End Function

Public Function ReadConfig(fn) As String
    On Error GoTo ReadError
    If SDir(fn) = "" Then ReadConfig = "": Exit Function
    Erase Cnf, UserProf, Addr, Nyms, KeyPass
    n = FreeFile
    Open fn For Input As n
    Line Input #n, a
    If a <> "JBN_CONFIG" Then ReadConfig = "": Exit Function
    While Not EOF(n)
        Line Input #n, a
        Select Case a
        Case "---Version"
            Line Input #n, a
            ConfigVersion = a
        Case "-=-Cnf"
            ReadArray n, Cnf(), MaxCnf, MaxCnfItem
            Cnf(0, 11) = XCrypt(Cnf(0, 11), LeftWin)
        Case "-=-UserProf"
            ReadArray n, UserProf(), MaxProfile, MaxProfileItem
            For i = 0 To 45
                If i = 15 Then i = 31
                UserProf(i, 8) = XCrypt(UserProf(i, 8), LeftWin)
            Next i
        Case "-=-Addr"
            AddrCount = ReadArray(n, Addr(), MaxAddr, -1) + 1
        Case "-=-Nyms"
            ReadArray n, Nyms(), MaxNyms, 3
        Case "-=-KeyPass"
            ReadArray n, KeyPass(), MaxNyms, 1
        Case "-=-Bookmarks"
            ReadArray n, Bookmarks(), MaxBookmarks, 1
        End Select
    Wend
    Close n: n = 0
    
    'Version Adjustments
    If SVal(ConfigVersion) < 2.1 Then  '2.0.x
        'Stats changes
        Cnf(3, 20) = Cnf(3, 11) + vbCrLf + Cnf(3, 20)
        Cnf(3, 23) = Cnf(3, 12) + vbCrLf + Cnf(3, 23)
        Cnf(3, 11) = ""
        Cnf(3, 12) = ""
        'Queue Column width changes
        PData(44) = "73"
        PData(45) = "86"
        PData(46) = "75"
        PData(47) = "90"
        PData(48) = "88"
        PData(49) = "49"
        PData(50) = "115"
        PData(51) = "72"
        On Error Resume Next
        For i = 1 To 8
            SendMessage frmMain!lstQ.hwnd, LVM_SETCOLUMNWIDTH, i - 1, Val(PData(43 + i))
        Next i
        On Error GoTo ReadError
        'Additions
        Cnf(4, 0) = ProgDir + "\Mail"
        Cnf(4, 1) = ProgDir + "\Books"
        Cnf(4, 3) = Replace("config@Nym.Alias.net Nym&&send@Nym.Alias.net Nym&&confirm@redneck Redneck&&send@redneck Redneck&&Squirrel.owl.de Squirrel&&remail.obscura Mix&&nobody@Replay Replay&&hr13.zedz Hr13&&mix@anon.lcs Lcs&&remailer.ch Swiss&&anon@anon.efga Cracker&&nobody@nowhere.to Nowhere&&nightmare@uni Nitemare&&nobody@neuropa.net Gretchen&&remailer@flashmail.com Flash&&jsbach@idirect.ca Jsbach&&", "&&", vbCrLf) 'From alias
        Cnf(4, 8) = "ddd dd mmm yy h:nna/p"
        Cnf(4, 12) = "1"
        Cnf(4, 13) = "1"
        Cnf(4, 14) = "1"
        Cnf(4, 15) = "0"
        Cnf(4, 16) = "1"
    
        'View Mail Window Size / Columns
        PData(147) = "178"
        PData(148) = "123"
        PData(149) = "154"
        PData(150) = "155"
        PData(151) = "31"
        PData(153) = "6" ' Viewer  lstMail.SortKey
        PData(154) = "1" ' Viewer  lstMail.SortOrder
        PData(160) = "True"
        PData(161) = "864"
        PData(162) = "396"
        PData(163) = "10020"
        PData(164) = "8268"
        PData(165) = "0"
        Cnf(4, 18) = "1"
    ElseIf ConfigVersion = "2.1.a" Then  '2.1.a
        If PData(122) <> "False" Then Cnf(4, 18) = "1"
        PData(122) = ""
    End If
    If SVal(ConfigVersion) < 2.1 Or ConfigVersion = "2.1.a" Or ConfigVersion = "2.1.b" Or ConfigVersion = "2.1.c" Then    '<2.1.c
        If InStr(1, Cnf(2, 21), "Encrypt-Subject:", vbTextCompare) = 0 Then
            x = InStr(1, Cnf(2, 21), "Encrypt-Key:", vbTextCompare)
            If x = 0 Then x = Len(Cnf(2, 21)) + 1
            Cnf(2, 21) = Left(Cnf(2, 21), x - 1) + "Encrypt-Subject: " + vbCrLf + Mid(Cnf(2, 21), x)
        End If
    End If
    If Cnf(2, 9) = "" Then Cnf(2, 9) = "1" 'Middleman warning added 2.1.f
    If SVal(ConfigVersion) < 2.1 Or ConfigVersion = "2.1.a" Or ConfigVersion = "2.1.b" Or ConfigVersion = "2.1.c" Or ConfigVersion = "2.1.d" Or ConfigVersion = "2.1.e" Then    '<2.1.f
        If InStr(1, Cnf(2, 21), "Encrypt-3DES:", vbTextCompare) = 0 Then
            x = InStr(1, Cnf(2, 21), "Encrypt-Key:", vbTextCompare)
            If x = 0 Then x = Len(Cnf(2, 21)) + 1
            Cnf(2, 21) = Left(Cnf(2, 21), x - 1) + "Encrypt-3DES: " + vbCrLf + "Encrypt-CAST: " + vbCrLf + Mid(Cnf(2, 21), x)
        End If
    End If
    If SVal(ConfigVersion) < 2.1 Or (SVal(ConfigVersion) = 2.1 And SVal(Mid(ConfigVersion, 5, 1)) = 0) Then
        '<2.1.1  Added Double-click opens full option
        Cnf(2, 10) = "1"
    End If
    If SVal(ConfigVersion) < 2.1 Or (SVal(ConfigVersion) = 2.1 And SVal(Mid(ConfigVersion, 5, 1)) < 2) Then
        '<2.1.2  Added Reply heading
        Cnf(2, 28) = "On $date, $from wrote:"
        Cnf(2, 29) = Cnf(2, 28)
    End If
    
    
    'Update Program Data
    PData(10) = Cnf(0, 0) '10 Last Global Work Folder
    PData(11) = Cnf(0, 2) '11 Last Wipe Files With
    PData(12) = Cnf(0, 3) '12 Last PGP Version
    PData(13) = Cnf(0, 4) '13 Last DOS Mode
    
    ReadConfig = ""
Exit Function
ReadError:
    ReadConfig = LMsg(2) + " " + fn + vbCr + Error
    CloseFile n
End Function

Public Sub SaveConfig()
    On Error GoTo SaveError
Start:
    WriteData
    'Write Config to temp file
    If PData(68) = "True" Then
        If SecurePass = "" Then
            MsgBox LMsg(331), vbCritical, LMsg(6)
            PData(68) = "False"
            Exit Sub
        End If
        fn = GetWork
    Else
        fn = DataDir + "\JBNConf.tmj"
    End If
    Msg = WriteConfig(fn)
    If PData(68) = "True" Then
        'Encrypt
        If Msg = "" Then Dst = Encrypt(fn, XCrypt("@@@" + SecurePass, RightWin), 0, ErrMsg, "", "", False)
        WipeFile fn
        If Dst = "" Then
            'Failure.  Disable Secure Mode?
            If MsgBox(LMsg(1) + vbCr + vbCr + ErrMsg + vbCr + vbCr + LMsg(332), vbCritical + vbYesNo + vbDefaultButton2, LMsg(334)) = vbYes Then
                PData(68) = "False": SecurePass = ""
                GoTo Start
            End If
        Else
            FileCopy Dst, DataDir + "\JBNConf.asc"
        End If
        DelFile Dst
        WipeFile DataDir + "\JBNConf.DAT"
        WipeFile DataDir + "\JBNConf.tmj"
    Else
        If Msg <> "" Then
            MsgBox Msg, vbCritical, LMsg(4)
            If PData(68) = "True" Then WipeFile fn Else DelFile fn
            fn = ""
        Else
            FileCopy fn, DataDir + "\JBNConf.DAT"
            DelFile fn
        End If
    End If
Exit Sub
SaveError:
    If PData(68) = "True" Then WipeFile fn
    MsgBox LMsg(1) + vbCr + DataDir + "\JBNConf.DAT" + vbCr + vbCr + Error, vbCritical, LMsg(4)
End Sub

Public Function SubSearch(Full, test, SearchStyle As Byte) As String
    Dim x As Integer, Y As Integer, a As String, ts As String, tst As String
    'test contains a vbcrlf delineated list of substrings
    'full contains the full text to be searched
    
    If InStr(test, "[[]") = 0 Then
        If InStr(test, "[") <> 0 Then test = Replace(test, "[", "[[]")
    End If
    If Right(test, 2) <> vbCrLf Then test = test + vbCrLf
    On Error Resume Next 'For invalid search pattern in ts
    Y = 1
    x = InStr(test, vbCrLf)
    While x <> 0
        ts = Trim(Mid(test, Y, x - Y))
        If ts <> "" Then
            If SearchStyle = 0 Then
                'Multi line search
                ts = "*" + ts + "*"
            Else
                'Single line search
                While Left(ts, 1) = "^"
                    ts = Mid(ts, 2)
                Wend
            End If
            If InStr(ts, "^") <> 0 Then ts = Replace(ts, "^", vbCrLf)
            If (Full Like ts) Then
                If InStr(ts, "[[]") <> 0 Then ts = Replace(ts, "[[]", "[")
                SubSearch = ts
                Exit Function
            End If
        End If
        Y = x + 2
        x = InStr(x + 1, test, vbCrLf)
    Wend
    SubSearch = ""
End Function

Public Sub DOSShell(CommLine, Style, Dump, Optional DispLine As String, Optional ByVal StartIn As String, Optional ByVal Wait As Byte)
    'Wait = 0: 5 minute timeout (halts all functions)
    '       1: no wait
    '       2: Tag Wait 5 min timeout
    
    On Error GoTo ShellError
    If Style = vbNormalFocus Then Wait = 2
    If Wait = 2 Then
        While DOSTag <> ""
            DoEvents
        Wend
        DOSTag = MakeTag(5)
    End If
    
    If Dir(ProgDir + "\jbn2dos.exe") = "" Or Dir(ProgDir + "\jbn2dos.pif") = "" Then
        MsgBox LMsg(68), vbCritical, LMsg(66)
        Exit Sub
    End If
    
    If Dump <> "NUL" And Wait <> 1 Then
        Do
            Dump = PData(10) + "\" + MakeTag(4) + ".tmj"
        Loop Until Dir(Dump) = ""
        
        n = FreeFile
        Open Dump For Output As n
        Print #n, Dump; "     "; Format(Date + Time, "dd mmm yyyy hh:nn:ss")
        Print #n, "DOS Path: ";
        If StartIn = "" Then Print #n, ProgDir Else Print #n, StartIn
        Print #n, "DOS Command:"
        If DispLine <> "" Then Print #n, DispLine Else Print #n, CommLine
        Print #n,
        Print #n,
        Print #n, "Output:"
        Close n: n = 0
    End If
        
    If Style = vbNormalFocus Then c = "P" Else c = "D"
    If Style > vbMinimizedNoFocus Then Style = vbNormalFocus
    If DispLine <> "" Then c = LCase(c)
    If Wait = 2 Then c = "T" + DOSTag + c
    If Dump = "NUL" Or Wait = 1 Then
        sh = c + CommLine
        Dump = ""
    Else
        sh = c + CommLine + ">>" + Dump
    End If
    If StartIn <> "" Then
        StartIn = NoSlash(StartIn)
        If Len(StartIn) = 2 And Right(StartIn, 1) = ":" Then StartIn = StartIn + "\"
        sh = ":" + StartIn + "::" + sh
    End If
    sh = "jbn2dos " + sh
    ChDrive Left(ProgDir, 1): ChDir ProgDir
    If Len(sh) <= 128 Then
        If Wait = 0 Then
            ShellWait sh, Style, 300000
        Else
            Shell sh, Style
        End If
    Else
        Dump = ""
        MsgBox LMsg(22) + vbCrLf + vbCrLf + DispLine, vbCritical, LMsg(69)
        Exit Sub
    End If
    If Wait = 2 Then
        frmMain!tmrDOS.Tag = ""
        frmMain!tmrDOS.Enabled = True
        While frmMain!tmrDOS.Enabled
            DoEvents
        Wend
        DelFile DOSTag + ".TAG"
        If frmMain!tmrDOS.Tag = "TIMEOUT" And Dump <> "NUL" Then DelFile Dump
        DOSTag = ""
    End If
Exit Sub
ShellError:
    If Wait = 2 Then
        frmMain!tmrDOS.Enabled = False
        DOSTag = ""
    End If
    MsgBox LMsg(0) + vbCr + Error, vbCritical, LMsg(69)
End Sub

Public Function MultiBox(Prompt, Title, Optional Default As String, Optional ListMode As Boolean, Optional h As Long, Optional w As Long) As String
    Dim temp(300) As String
    If ListMode Then
        x = ParseString(Default, temp(), 300, False)
        For i = 0 To x
            frmMultiBox!lstInput.AddItem temp(i)
        Next i
        If frmMultiBox!lstInput.ListCount <> 0 Then frmMultiBox!lstInput.Selected(0) = True
        frmMultiBox!lstInput.Visible = True
    Else
        frmMultiBox!txtInput.Text = Default
        frmMultiBox!lstInput.Visible = False
    End If
    frmMultiBox.Caption = Title
    frmMultiBox!lblMsg.Caption = Prompt
    If h <> 0 Then frmMultiBox.Height = h
    If w <> 0 Then frmMultiBox.Width = w
    frmMultiBox.Show 1
    MultiBox = frmMultiBox!txtInput.Text
    h = frmMultiBox.Height
    w = frmMultiBox.Width
    Unload frmMultiBox
End Function

Public Function SelectFolder(StartIn, Title, SelectList, Optional ByVal Msg As String) As String
    Dim Tmp(10) As String
    
    x = ParseString(SelectList, Tmp(), 20, False)
    For i = 0 To x
        frmFolder!cboFolder.AddItem Tmp(i)
    Next i
    
    frmFolder.Caption = Title
    If Msg <> "" Then frmFolder!lblFolder.Caption = Msg
    frmFolder!cboFolder.Text = StartIn
    frmFolder.Show 1
    SelectFolder = NoSlash(frmFolder!cboFolder.Text)
    Unload frmFolder
    If SelectFolder <> "" Then
        sl = SelectFolder + vbCrLf
        For i = 0 To x
            If LCase(Tmp(i)) <> LCase(SelectFolder) Then sl = sl + Tmp(i) + vbCrLf
        Next i
        SelectList = sl
        StartIn = SelectFolder
    End If
End Function



Public Function OpenSpec(ByVal fn, NewWindow As Boolean) As Boolean
    On Error GoTo OpenError
    OpenSpec = False
    If Left(fn, 1) = Chr(34) Then fn = Extract(Mid(fn, 2), Chr(34))
    If IsDir(fn) Then
        Shell "EXPLORER.EXE /n,/e," + fn, vbNormalFocus
        OpenSpec = True
        Exit Function
    Else
        If SDir(NoSlash(fn)) = "" Then Exit Function
    End If
    ext = LCase(PlainName(fn, 3))
    Select Case ext
    Case "bk", "tbk"
        For i = 0 To 9
            If LCase(MsgBookName(i)) = LCase(fn) Then Exit For
        Next i
        If i < 10 Then
            'Already open
            MsgBook(i).Show
        Else
            'New
            For i = 0 To 9
                If (NewWindow And MsgBookName(i) = "") Or ((Not NewWindow) And MsgBookName(i) <> "") Then Exit For
            Next i
            If i = 10 And NewWindow Then
                'Too many books open error
                MsgBox LMsg(71), vbCritical, LMsg(4)
                OpenSpec = True
                Exit Function
            End If
            If NewWindow Or i = 10 Then
                If i = 10 Then i = 0
                MsgBookName(i) = fn
                Set MsgBook(i) = New frmBook
                MsgBook(i).Tag = Str(i)
                'Locate window
                MsgBook(i).Show
            Else
                'Trigger book i reload
                MsgBook(i)!cboNym.Tag = fn
                MsgBook(i)!tmrReload.Tag = MsgBook(i)!tmrReload.Tag + "L"
                MsgBook(i)!tmrReload.Enabled = True
            End If
        End If
    Case "nbk"
        For i = 0 To 9
            If LCase(NymBookName(i)) = LCase(fn) Then Exit For
        Next i
        If i < 10 Then
            'Already open
            NymBook(i).Show
        Else
            'New
            For i = 0 To 9
                If (NewWindow And NymBookName(i) = "") Or ((Not NewWindow) And NymBookName(i) <> "") Then Exit For
            Next i
            If i = 10 And NewWindow Then
                'Too many books open error
                MsgBox LMsg(71), vbCritical, LMsg(4)
                OpenSpec = True
                Exit Function
            End If
            If NewWindow Or i = 10 Then
                If i = 10 Then i = 0
                NymBookName(i) = fn
                Set NymBook(i) = New frmNBook
                NymBook(i).Tag = Str(i)
                'Locate window
                NymBook(i).Show
            Else
                'Trigger book i reload
                NymBook(i)!cboNym.Tag = fn
                NymBook(i)!tmrReload.Tag = NymBook(i)!tmrReload.Tag + "L"
                NymBook(i)!tmrReload.Enabled = True
            End If
        End If
    Case "q0", "q1", "t0", "t1"
        'Mail message
        a = UCase(Extract(Extract(ext, "0"), "1"))
        ViewQueMsg PlainName(fn, 0) + PlainName(fn, 2), a, "[" + PlainName(fn, 0) + PlainName(fn, 2) + "]"
    Case Else
        If ext Like "_*" Then
            'Replay file
            If SDir(PlainName(fn, 0) + PlainName(fn, 2) + ".BK") <> "" Then
                OpenSpec = OpenSpec(PlainName(fn, 0) + PlainName(fn, 2) + ".BK", False)
                Exit Function
            Else
                'Assoc book not found
                MsgBox LMsg(72), vbCritical, LMsg(66)
            End If
        Else
            'Open API
            ret = ShellExecute(frmMain.hwnd, "Open", fn, "", PlainName(fn, 0), 1)
        End If
    End Select
    OpenSpec = True
Exit Function
OpenError:
    MsgBox LMsg(0) + vbCr + Error, vbCritical, LMsg(67)
End Function

Public Function MsgTime(Msg, ico, Title, Buttons, ByVal DefButton As Byte, Delay, _
Optional ByVal ButtonText1 As String, Optional ByVal ButtonText2 As String, _
Optional ByVal ButtonText3 As String, Optional ByVal CheckText As String, Optional CheckValue As Byte, _
Optional Attended As Boolean) _
As Byte
    
    If ButtonText1 = "" Then
        Select Case Buttons
        Case vbYesNo: ButtonText1 = "&Yes": ButtonText2 = "&No": ButtonText3 = ""
        Case vbYesNoCancel: ButtonText1 = "&Yes": ButtonText2 = "&No": ButtonText3 = "&Cancel"
        Case vbOKOnly: ButtonText1 = "&OK": ButtonText2 = "": ButtonText3 = ""
        Case vbOKCancel: ButtonText1 = "&OK": ButtonText2 = "&Cancel": ButtonText3 = ""
        Case vbRetryCancel: ButtonText1 = "&Retry": ButtonText2 = "&Cancel": ButtonText3 = ""
        Case vbAbortRetryIgnore: ButtonText1 = "&Abort": ButtonText2 = "&Retry": ButtonText3 = "&Ignore"
        End Select
    End If
    frmMsgTime!cmdTime(0).Caption = ButtonText1
    frmMsgTime!cmdTime(1).Caption = ButtonText2
    frmMsgTime!cmdTime(2).Caption = ButtonText3
    frmMsgTime!cmdTime(0).Visible = ButtonText1 <> ""
    frmMsgTime!cmdTime(1).Visible = ButtonText2 <> ""
    frmMsgTime!cmdTime(2).Visible = ButtonText3 <> ""
    If ButtonText2 = "" And ButtonText3 = "" Then
        frmMsgTime!cmdTime(0).Left = 2040
        If DefButton > 1 Then DefButton = 1
    Else
        If ButtonText3 = "" Then
            frmMsgTime!cmdTime(0).Left = 960
            frmMsgTime!cmdTime(1).Left = 3120
            If DefButton > 2 Then DefButton = 2
        Else
            frmMsgTime!cmdTime(0).Left = 240
            frmMsgTime!cmdTime(1).Left = 2040
            If DefButton > 3 Then DefButton = 3
        End If
    End If
    If CheckText <> "" Then frmMsgTime!chkTime.Caption = CheckText
    
    frmMsgTime!chkTime.Visible = CheckText <> ""
    frmMsgTime!chkTime.Value = CheckValue
        
    On Error Resume Next
    frmMsgTime!lblMsg.FontSize = SVal(Cnf(0, 5)) + 8
    frmMsgTime!chkTime.FontSize = SVal(Cnf(0, 5)) + 8
    On Error GoTo 0
    If InStr(Msg, vbCrLf) = 0 And Len(Msg) < 50 Then frmMsgTime!lblMsg.Width = 10 Else frmMsgTime!lblMsg.Width = 5892
    frmMsgTime!lblMsg.Caption = Msg
    frmMsgTime.Caption = Title
    frmMsgTime.Tag = Str(DefButton - 1)
    
    If Delay <> 0 Then frmMsgTime!tmrTime.Tag = Str(Delay + 1)
    frmMsgTime!tmrTime.Interval = 50
    frmMsgTime!tmrTime.Enabled = Delay <> 0
    
    frmMsgTime.Show 1
    If frmMsgTime.Tag = "" Then
        MsgTime = DefButton - 1
    Else
        CheckValue = frmMsgTime!chkTime.Value
        Attended = frmMsgTime!cmdTime(0).Tag = "True"
        MsgTime = Val(frmMsgTime.Tag) + 1
    End If
    Unload frmMsgTime
    DoEvents
End Function

Public Sub MsgLog(Msg, Job, Optional PopUp As Boolean, Optional StatError As Boolean)
    Dim CheckValue As Byte, Attended As Boolean
            
    'Job 0: Que/SMTP
    'Job 1: Stats Refresh
    XMsg = vbCrLf + Format(Time, "hh:nn ") + Msg
    If Len(frmMain!txtLog.Text) + Len(XMsg) > 30000 Then
        frmMain!txtLog.Text = "[...] " + Mid(frmMain!txtLog.Text, 2000)
    End If
    frmMain!txtLog.Text = frmMain!txtLog.Text + XMsg
    frmMain!txtLog.SelStart = Len(frmMain!txtLog.Text)
    If PData(30 + Job) <> "False" And PopUp Then
        'Pop-Up Error
        Select Case Job
        Case 0: a = LMsg(293)  'Queue
        Case 1: a = LMsg(370)  'Stats
        Case 2: a = LMsg(449)  'Mail Retrieval
        Case 3: a = LMsg(461)  'News Retrieval
        Case 4: a = LMsg(318)  'General
        Case 5: a = LMsg(375)  'Pop up caps
        End Select
        CheckValue = 0
        x = MsgTime(Msg, 0, a, vbOKOnly, 1, 30, "", "", "", LMsg(292), CheckValue, Attended)
        If CheckValue = 1 Then frmMain!mnuPopUp(Index).Checked = False: PData(30 + Index) = "False"
    End If
    If StatError And Not Attended Then
        ErrorSummary = Right(ErrorSummary + XMsg, 30000)
        frmMain!PictureError.Visible = True
        frmMain!PictureError.ZOrder
    End If
    If frmMain!PictureError.Visible Then Stat StatMain, StatDec
End Sub

Public Sub Stat(Main As String, Dec As String)
    If Main = "" And NewMessages <> 0 Then Main = Str(NewMessages) + " " + LMsg(456) + "."
    If Main <> "" Then
        frmMain!barStat.SimpleText = Main
    Else
        frmMain!barStat.SimpleText = Dec
    End If
    frmMain!barStat.Refresh
    If ViewerLoaded Then
        frmViewer!lblStat(0).Caption = Main
        frmViewer!lblStat(1).Caption = Dec
        frmViewer!lblStat(0).Refresh
        frmViewer!lblStat(1).Refresh
    End If
    StatMain = Main
    StatDec = Dec
    'Set Main Icon
    If NetBusy Or StatsBusy Then
        img = "Net"
    ElseIf Decrypting And DecQCount <> 0 Then
        img = "Dec"
    ElseIf frmMain!PictureError.Visible Then
        img = "Error"
    Else
        img = "Main"
    End If
    If NewMessages <> 0 Then img = img + "Flag"
    Select Case img
    Case "Main": frmMain.Icon = frmMain!barStat.DragIcon
    Case "MainFlag": frmMain.Icon = frmMain!barStat.MouseIcon
    Case "Dec": frmMain.Icon = frmMain!cboRecent.DragIcon
    Case "DecFlag": frmMain.Icon = frmMain!cboRecent.MouseIcon
    Case "Error": frmMain.Icon = frmMain!cmdOpen.DragIcon
    Case "ErrorFlag": frmMain.Icon = frmMain!cmdOpen.MouseIcon
    Case "Net": frmMain.Icon = frmMain!barProgress.DragIcon
    Case "NetFlag": frmMain.Icon = frmMain!barProgress.MouseIcon
    End Select
End Sub

Public Sub StartSession(x)
    frmMain!tmrSession.Enabled = False
    SessionStart = x
    If x <> -1 Then Session(x) = 1
    frmMain!tmrSession.Interval = 100
    frmMain!tmrSession.Enabled = True
End Sub

Public Function RASConnected() As Boolean
    RASConnected = True
    On Error Resume Next
    RASConnected = (frmMain!Dialer1.Connected And frmMain!Dialer1.state = 8192) Or (PData(53) = "False")
End Function

Public Function DialRAS(Establish As Boolean) As Boolean
    Dim dt As Date, Tmp(50) As String

    DialRAS = False
    If Not Establish Then
        On Error Resume Next
        frmMain!Dialer1.Disconnect
        KeepDate(16) = SafeTime
        Exit Function
    End If
        
    If SafeTime - KeepDate(16) < SVal(Cnf(0, 12)) / 24 / 60 Then Exit Function
    
    If frmMain!Dialer1.Connected Then
        If frmMain!Dialer1.state = 8193 Then  '8193 = disconnected
            On Error Resume Next
            frmMain!Dialer1.Disconnect
            'Press Reconnect
            AppActivate "Connected to": SendKeys "{ENTER}"
            DoEvents
        Else
            Exit Function
        End If
    End If
    If Cnf(0, 10) = "" Then Exit Function
    On Error GoTo RASError
    xentry = -1
    IEstablished = False
    For i = 0 To frmMain!Dialer1.PhoneBookEntries - 1
        If frmMain!Dialer1.PhoneBookEntry(i) = Cnf(0, 10) Then xentry = i: Exit For
    Next i
    If xentry = -1 Then Cnf(0, 10) = "": Exit Function
    frmMain!Dialer1.PhoneEntry = frmMain!Dialer1.PhoneBookEntry(xentry)
    x = ParseString(Cnf(0, 11), Tmp(), 50, True)
    For i = 0 To x
        If LCase(Tmp(i)) = LCase(Cnf(0, 10)) And i + 2 <= x Then
            frmMain!Dialer1.UserName = Tmp(i + 1)
            frmMain!Dialer1.Password = Tmp(i + 2)
            Exit For
        End If
    Next i
    If i = x + 1 Then Exit Function
    frmMain!tmrSession.Enabled = False
    frmMain.MousePointer = 13
    Stat LMsg(312) + " " + frmMain!Dialer1.PhoneEntry + "...", StatDec
    frmMain!Dialer1.Tag = "Trying"
    frmMain!Dialer1.TimeOut = 180
    If Not frmMain!Dialer1.Connected Then frmMain!Dialer1.Connect Else frmMain!Dialer1.Tag = "Waiting"
Start:
    dt = SafeTime
    While Not (frmMain!Dialer1.Tag = "Waiting" And frmMain!Dialer1.state = 8192) And frmMain!Dialer1.state <> 8193 And frmMain!Dialer1.Tag <> "Connect" And frmMain!Dialer1.Tag <> "Timeout" And (SafeTime - dt) < 200 / 24 / 60 / 60
        DoEvents
    Wend
    If frmMain!Dialer1.Connected And frmMain!Dialer1.state = 8192 Then '8192 = Connected
        Stat LMsg(313), StatDec
        MsgLog LMsg(313) + ": " + frmMain!Dialer1.PhoneEntry, 4
        IEstablished = True
        DialRAS = True
        'Start Apps
        x = ParseString(Cnf(0, 13), Tmp(), 50, False)
        For i = 0 To x
            If SDir(Tmp(i)) <> "" Then OpenSpec Tmp(i), True
            DoEvents
        Next i
    Else
        Stat LMsg(314), StatDec
        MsgLog LMsg(314) + ": " + frmMain!Dialer1.PhoneEntry, 4
        frmMain!Dialer1.Disconnect
    End If
    frmMain!Dialer1.Tag = ""
    KeepDate(16) = SafeTime
    frmMain!tmrSession.Enabled = True
    frmMain.MousePointer = 0
Exit Function
RASError:
    frmMain!Dialer1.Tag = ""
    KeepDate(16) = SafeTime
    Stat LMsg(314), StatDec
    MsgLog LMsg(314) + ": " + frmMain!Dialer1.PhoneEntry, 4
    frmMain!tmrSession.Enabled = True
End Function

Public Function GetConvPass(Msg) As String
    Dim CPass As String
    
    frmPass!lblDirections.Caption = Msg
    frmPass.Show 1
    CPass = frmPass!txtPass.Text
    frmPass!txtPass.Text = String(Len(frmPass!txtPass.Text), "@")
    Unload frmPass
    If Trim(CPass) = "" Then CPass = ""
    GetConvPass = CPass
    CPass = String(Len(CPass), "@")
End Function

Public Sub WipeFile(fn)
Start:
    If SDir(fn) <> "" And fn <> "" Then
        f2 = GetShortName(fn)
        If f2 <> "" Then DOSShell PData(11) + " " + f2, vbHide, "NUL"
        If SDir(fn) <> "" Then If MsgBox(LMsg(330) + " " + fn, vbCritical + vbRetryCancel, LMsg(4)) = vbRetry Then GoTo Start
    End If
End Sub

Public Sub AlterTime(state)
    Dim Now As Double, MoveNow As Double
    If state Then
        BadTime = True
        Now = Date + Time
        MoveNow = Date + gmtoffset
        AlterDate = MoveNow - Now
        Date = Format(MoveNow, "short date")
        Time = Format(MoveNow + 1 / 24 / 60 / 60, "hh:nn:ss")
    Else
        BadTime = False
        If AlterDate <> -1 Then
            Now = Date + Time - AlterDate
            Date = Format(Now, "short date")
            Time = Format(Now + 1 / 24 / 60 / 60, "hh:nn:ss")
            AlterDate = -1
        End If
    End If
End Sub

Public Function SafeTime() As Date
    While BadTime: DoEvents: Wend
    SafeTime = Date + Time
End Function

Public Sub MainLoadList(Job As String)
    Dim Tmp(100) As String
    
    If Job = "Patterns" Or Job = "" Then
        temp0 = frmMain!cboPattern(0).Text
        temp1 = frmMain!cboPattern(1).Text
        If PData(69) = "" Then PData(69) = _
            "Templates (*.TBK; *.NBK; *.TXT)" + vbCrLf + _
            "Messages (*.BK; *.txt)" + _
            "Mixture (*.TBK; *.BK; *.NBK; *.TXT)" + vbCrLf + _
            "Nym Books (*.NBK)" + vbCrLf + _
            "Replay Files (*._*)" + vbCrLf + _
            "Outgoing Mail (*.Q0; *.Q1)" + vbCrLf + _
            "All (*.*)" + vbCrLf
        frmMain!cboPattern(0).Clear
        frmMain!cboPattern(1).Clear
        x = ParseString(PData(69), Tmp(), 100, False)
        For i = 0 To x
            frmMain!cboPattern(0).AddItem Tmp(i)
            frmMain!cboPattern(1).AddItem Tmp(i)
        Next i
        frmMain!cboPattern(0).Text = temp0
        frmMain!cboPattern(1).Text = temp1
    End If
    
    If Job = "Recent" Or Job = "" Then
        frmMain!cboRecent.Clear
        If PData(72) <> "" Then frmMain!cboRecent.AddItem PData(72)
        x = ParseString(PData(73), Tmp(), 100, False)
        For i = 0 To x
            If Tmp(i) <> PData(72) Then frmMain!cboRecent.AddItem Tmp(i)
        Next i
    End If

    If Job = "Fonts" Or Job = "" Then
        On Error Resume Next
        x = SVal(Cnf(0, 5)) + 8
        For i = 0 To 1
            frmMain!filExplore(i).FontSize = x
            frmMain!cboPattern(i).FontSize = x
        Next i
        frmMain!dirExplore.FontSize = x
        frmMain!drvExplore.FontSize = x
        frmMain!cboRecent.FontSize = x
        frmMain!txtLog.FontSize = x
        frmMain!lstQ.Font.Size = x
    End If
End Sub

Public Sub AbortConnection()
    On Error Resume Next
    'SMTP
    frmMain!cmdAbort.Tag = "True"
    frmMain!SmtpClient1.Cancel
    frmMain!SmtpClient1.Disconnect
    frmMain!SmtpClient1.Reset
    If SendingMail Then frmMain!chkSend.Value = 0
    'Pop
    AbortRetrieve = True
    frmMain!PopClient1.Cancel
    frmMain!PopClient1.Disconnect
    'News
    If GetNewsLoaded Then
        frmGetNews!NNTP1.Cancel
        frmGetNews!NNTP1.Quit
    End If
    'Web
    If BrowserLoaded Then
        frmWeb!WebClient1.Cancel
        frmWeb!WebClient1.Action = 6
        WebAbort = True
        frmWeb!WebClient1.AutoLoad = False
        frmWeb!barStat.Tag = "": frmWeb!barStat.SimpleText = "": frmWeb.MousePointer = 0
    End If
    frmMain!tmrSession.Enabled = False
    frmMain!tmrSession.Interval = 60000
    SessionStart = -1
    AbortSession = True
    frmMain!tmrSession.Enabled = True
    Stat LMsg(301), StatDec
End Sub

