VERSION 5.00
Begin VB.Form frmDecrypt 
   BorderStyle     =   0  'None
   Caption         =   "Decrypt"
   ClientHeight    =   2496
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3744
   LinkTopic       =   "Form1"
   ScaleHeight     =   2496
   ScaleWidth      =   3744
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Visible         =   0   'False
   Begin VB.Timer tmrDecrypt 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   300
      Top             =   240
   End
End
Attribute VB_Name = "frmDecrypt"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Copyright 1999 Potato Software.   See MAIN.BAS and LICENSE.TXT.

Private Sub DecryptMessages()
    Dim Finished As Boolean
    Dim InboxFolder As String, MultipartFolder As String
    Dim tempblock As String, RBPos As Long
    Dim XNymDate As Date
    'Passphrases
    Const MaxBlock = 2000
    Dim Priority() As Integer
    Dim TagDate(MaxBlock) As Date
    Dim CPass() As String, CMax As Long
    Dim CHist() As Byte
    Dim TagFolder(MaxBlock, 1) As String
    Dim UpdateRB() As Boolean
    Dim BlockCount As Integer
    Const LinesPerBlock = 75
    Dim Block(LinesPerBlock) As String
    Dim BlockDate As Date, HighDate As Date
    Dim Secret(MaxNyms) As Boolean
    'PGP
    Dim SigProps As String * 256
    Dim Sig As TSig_Data
    'SPGP
    Dim PGPErrCode As Long, ErrMsg As String, PGPErrMsg As String * 512
    Dim FileIn As String * 256
    Dim BufferOut As String * 8192, BufferOutLen As Long
    Dim PGPType As Long
    Dim efftotal As Double, effcount As Long
    BufferOutLen = 8192
    BeginPGP2 = "- " + BeginPGP
    EndPGP2 = "- " + EndPGP
    
Start:
    InboxFolder = Cnf(4, 0) + "\Inbox"
    MultipartFolder = Cnf(4, 0) + "\Multi"
    DecView = PData(169) = "True"
    CancelDecrypt = False
    
    'Check for valid folders
    BadDir = False
    If Not CreateDir(InboxFolder) Then
        BadDir = True
    Else
        If Not CreateDir(MultipartFolder) Or _
        Not CreateDir(Cnf(4, 0) + "\Trash") Or _
        Not CreateDir(Cnf(4, 0) + "\Trash\Multi") _
        Or Not CreateDir(Cnf(4, 0) + "\Trash\Spam") Or _
        Not CreateDir(Cnf(4, 0) + "\Trash\Duplicates") Then BadDir = True
    End If
    If BadDir Then
        MsgLog LMsg(528), 4, True, True
        DecQCount = 0
        Exit Sub
    End If
    
    BlockCount = 0
    CMax = 5
    ReDim CPass(MaxBlock, CMax)
    ReDim CHist(MaxBlock, CMax)
    If DecQCount <> 0 Then
        'Get Conventional Passphrases
        On Error GoTo ErrorPass
        While NymDataBusy: DoEvents: Wend
        NymDataBusy = True
        For j = 1 To 2
            For i = 0 To MaxNyms
                If Nyms(i, 0) = "" Then Exit For
                y = 1
                If Nyms(i, j) <> "" And InStr(1, Nyms(i, j), "---block", vbTextCompare) = 0 Then Nyms(i, j) = "---block" + vbCrLf + Nyms(i, j)
                x = InStr(1, Nyms(i, j), "---block", vbTextCompare)
                Do While x <> 0 And BlockCount <= MaxBlock
                    'Get block
                    CCount = 0
                    z = InStr(x + 8, Nyms(i, j), "---block", vbTextCompare)
                    If z = 0 Then z = InStr(x + 8, Nyms(i, j), "---endblock", vbTextCompare)
                    If z = 0 Then z = Len(Nyms(i, j)) + 1
                    tempblock = Mid(Nyms(i, j), x, z - x)
                    t = ParseString(tempblock, Block(), LinesPerBlock, False)
                    For k = 1 To t
                        u = InStr(Block(k), ":")
                        If (Left(Block(k), 1) = " " Or Left(Block(k), 1) = vbTab) And u <> 0 Then
                            b = Trim(Mid(Block(k), u + 1))
                            Select Case LCase(Replace(Trim(Left(Block(k), u - 1)), vbTab, ""))
                            Case "tag": TagFolder(BlockCount, 0) = Extract(b, " ")
                            Case "folder": TagFolder(BlockCount, 1) = b
                            Case "file": TagFolder(BlockCount, 1) = "file:" + b
                            Case "created", "used"
                                If TagDate(BlockCount) = 0 Or DateVal(b) > TagDate(BlockCount) Then TagDate(BlockCount) = DateVal(b)
                            End Select
                        Else
                            'Add passphrase
                            If CCount > CMax Then
                                CMax = CMax + 10
                                ReDim Preserve CPass(MaxBlock, CMax)
                                ReDim CHist(MaxBlock, CMax)
                            End If
                            CPass(BlockCount, CCount) = Block(k)
                            CCount = CCount + 1
                        End If
                    Next k
                    BlockCount = BlockCount + 1
                    y = z
                    x = InStr(y, Nyms(i, j), "---block", vbTextCompare)
                Loop
                DoEvents
            Next i
        Next j
        NymDataBusy = False
        Erase Block
    End If
    
    If BlockCount <> 0 Then ReDim UpdateRB(BlockCount - 1)
    Do While DecQCount <> 0
        While DecQBusy: DoEvents: Wend
        DecQBusy = True
        decfile = DecQ(0)
        For i = 0 To DecQCount - 2
            DecQ(i) = DecQ(i + 1)
        Next i
        DecQCount = DecQCount - 1
        DecQBusy = False
        'Decrypt File
        If SDir(decfile) <> "" And UCase(decfile) <> UCase(ReserveMailFile) Then
            ReserveDecFile = decfile
            On Error GoTo ErrorDecrypt
            'Update Display
            If effcount = 0 Then b = "" Else b = "   Efficiency:" + Str(Int((efftotal / effcount) * 100)) + "%"
            Stat StatMain, LMsg(474) + Str(DecQCount + 1) + b
            'Reset History
            ReDim CHist(BlockCount, CMax)
            'Determine Priorities based on date
            ReDim Priority(BlockCount)
            For i = 0 To BlockCount - 1
                Priority(i) = i
            Next i
            If BlockCount <> 0 Then QuickSortBlocks 0, BlockCount - 1, TagDate(), Priority()
            
            curfile = decfile
            'Initialize
            RBTag = "Unknown"
            RBDecDone = False
            NymMsgID = ""
            Finished = False
            MIMEMulti = False
            InHeaders = True
            secretcount = 0
            convcount = 0
            Stage = 0
            SkipDecView = False
            NoPGP = True
            crb = -1: cpx = -1
            AssembledFrom = ""
            pgpkeylist = ""
            ShowPassphrase = ""
            'Parse
            While Not Finished
                n = FreeFile
                Open curfile For Input As n
                newfile = GetWork(PData(10))
                n2 = FreeFile
                Open newfile For Output As n2
                Finished = True
                firsttext = True
                failpgp = False
                ShowPassphrase = ""
                pgpkeylist = ""
                ActionTaken = ""
                Do While Not EOF(n)
                    Line Input #n, a
                    If Len(a) <> 0 Then ax = Asc(Left(a, 1)) Else ax = 0: InHeaders = False
                    Select Case ax
                    Case 42       '*
                        If a = "**" And firsttext Then GoTo NextLine
                    Case 77       'M
                        If LCase(Left(a, 11)) = "message-id:" And RBDecDone Then
                            If NymMsgID = "" Then NymMsgID = Trim(Mid(a, 12))
                        End If
                    Case 82       'R
                        If Left(a, 14) = "ReplyBlockTag:" Then
                            'ReplyBlockTag
                            RBTag = Trim(Mid(a, 15))
                            GoTo NextLine
                        ElseIf Left(a, 10) = "RBRcvEnum:" Then
                            'RBRcvEnum   JBN1 old reply-block compat
                            RBTag = "user@dcv" + Trim(Str(convcount)) + ".RBE." + Trim(Mid(a, 11)) + ".Decrypt"
                            GoTo NextLine
                        End If
                    Case 70       'F
                        'Assembled Multi-part, keep From line
                        If firsttext Then
                            If curfile = decfile And _
                               a Like "From *@JBN2.Assembled*:*" Then _
                               AssembledFrom = a
                        End If
                    Case 33       '!
                        If Left(a, 15) = "!Decrypt Error!" Then failpgp = True
                    Case 61       '=
                        If a Like "=*BEGIN *" And NoPGP Then a = "=!FALSE!=   " + a
                    Case 45       '-
                        'Garbage
                        If Not MIMEMulti And a = "-----BEGIN GARBAGE-----" Then
                            While Not EOF(n) And a <> "-----END GARBAGE-----"
                                Line Input #n, a
                            Wend
                            ActionTaken = ActionTaken + "   " + "Garbage section removed"
                            GoTo NextLine
                        End If
                        'PGP Message
                        If (a = BeginPGP Or a = BeginPGP2 Or (a = BeginSig And Val(PData(12)) <> 0)) And Not failpgp And Not MIMEMulti Then
                            ErrMsg = ""
                            secretkeyids = "": secretkey = -1: firstsecretkeyid = ""
                            Erase Secret
                            pgpkeylist = ""
                            ActionTaken = ActionTaken + "   " + "PGP message decoded"
                            If a = BeginPGP Then
                                pgpendline = EndPGP
                            ElseIf a = BeginPGP2 Then
                                a = BeginPGP
                                pgpendline = EndPGP
                            Else
                                pgpendline = EndSig
                            End If
                            pgpstartline = a
                            pgpseek = Seek(n)
                            pgpfile = GetWork(PData(10))
                            n3 = FreeFile
                            Open pgpfile For Output As n3
                            Print #n3, a
                            blankfound = False: FirstLine = True: firstpgptext = ""
                            getfirstline = Val(PData(12)) = 0  'PGP 2.6.x
                            Do While Not EOF(n)
                                Line Input #n, b
                                If b = EndPGP2 Then If pgpendline = EndPGP Then b = EndPGP
                                Print #n3, b
                                If getfirstline Then
                                   'PGP 2.6.x
                                    If b = "" Then
                                        blankfound = True
                                    Else
                                        If blankfound And FirstLine Then
                                            FirstLine = False
                                            firstpgptext = b
                                        End If
                                    End If
                                End If
                                If b = pgpendline Then Exit Do
                            Loop
                            Close n3: n3 = 0
                            DoEvents
                            'ANALYZE
                            If b <> pgpendline Then
                                'Incomplete message
                                ErrMsg = "Incomplete PGP message"
                            Else
                                If a = BeginPGP Then
                                    'Analyze Encrypted Message
                                    If Val(PData(12)) = 0 Then
                                        'PGP 2.6.x
                                        PGPType = PGPEncType(firstpgptext, secretkeyids)
                                        firstsecretkeyid = secretkeyids
                                    Else
                                        'PGP 5+
                                        FileIn = pgpfile + Chr(0)
                                        PGPType = spgpAnalyzeFileEx(FileIn, BufferOut, BufferOutLen)
                                        'Encrypted = 0
                                        'SIGNED = 1
                                        'Detached Signature = 2
                                        'Key = 3
                                        'Unknown = 4
                                        'Conventional Encryption = 5
                                        'Encrypted Key Not Avail = 6
                                        If PGPType < 0 Or PGPType > 6 Then
                                            'Error
                                            ErrMsg = "Message analyzation failed [" + Trim(Str(PGPType)) + "]"
                                        Else
                                            If PGPType = 0 Or PGPType = 1 Or PGPType = 5 Then
                                                If PGPType = 0 Then
                                                    'PK Encrypted
                                                    'Bufferout returns:
                                                    'Keys_Unknown: 0
                                                    'Keys_Known: 2
                                                    '0xDE4353E3   0xDDEE33DE
                                                    ReDim buffline(3) As String
                                                    b = Extract(BufferOut, Chr(0))
'Debug.Print "buffer:"
'Debug.Print "{"; b; "}"
                                                    x = ParseString(b, buffline(), 3, True)
                                                    'Keys_Unknown: 1
                                                    buffline(0) = Mid(buffline(0), 14)
                                                    'Keys_Known: 1
                                                    buffline(1) = Mid(buffline(1), 12)
                                                    'Known Key list
                                                    secretkeyids = buffline(2)
#If 0 Then  'This code should be avoided with SPGP 2.2.3.2 and later
                                                        '!!!  This code is modified to compensate for a bug in some versions of SPGP
                                                    If SVal(buffline(1)) > 0 And InStr(buffline(2), vbTab) + InStr(buffline(3), vbTab) <> 0 Then
                                                        'Probably SPGP < 2.2.3.1 or => 2.2.3.2
                                                        If buffline(3) <> "" Then secretkeyids = buffline(3) Else secretkeyids = buffline(2)
                                                    Else
                                                        'SPGP 2.2.3.1 Bug Workaround
                                                        secretkeyids = ""
                                                        For i = 2 To x
                                                            If i - 1 > SVal(buffline(1)) Or buffline(i) = "" Then Exit For
                                                            secretkeyids = secretkeyids + buffline(i) + vbTab
                                                        Next i
                                                    End If
#End If
                                                    'Unknown Key list (count)
                                                    If Val(buffline(0)) = 0 Then
                                                        keysunknown = ""
                                                    Else
                                                        keysunknown = "UNKNOWN-KEYS: " + Trim(buffline(0)) + vbCrLf
                                                    End If
'Debug.Print "secretkeyids: "; secretkeyids
'Debug.Print "keysunknown: "; keysunknown
                                                    firstsecretkeyid = Extract(secretkeyids, vbTab)
                                                    If secretkeyids = "" Then ErrMsg = "Private key not available"
                                                    'Get pretty output of known and unknown keys
                                                    pgpkeylist = ""
                                                    keylist = secretkeyids
                                                    If keylist <> "" Then
                                                        keylist = keylist + vbTab
                                                        y = 1
                                                        x = InStr(keylist, vbTab)
                                                        Do While x <> 0
                                                            c = Trim(Mid(keylist, y, x - y))
                                                            If c <> "" Then
                                                                b = FindPGPKey(c)
                                                                If b = "" Then b = c
                                                                pgpkeylist = pgpkeylist + "Key: " + b + vbCrLf
                                                            End If
                                                            y = x + 1
                                                            x = InStr(y, keylist, vbTab)
                                                        Loop
                                                    End If
                                                    pgpkeylist = pgpkeylist + keysunknown
'Debug.Print "pgpkeylist:"
'Debug.Print "{"; pgpkeylist; "}"
'Debug.Print
                                                Else
                                                    'Conv etc
                                                    PGPType = 5
                                                    pgpkeylist = ""
                                                End If
                                            Else
                                                'Error
                                                If PGPType = 6 Then
                                                    ErrMsg = "Private key not available"
                                                Else
                                                    If PGPType = 4 Then
                                                        'Unknown
                                                    Else
                                                        ErrMsg = "Unsupported"
                                                    End If
                                                End If
                                            End If
                                        End If
                                    End If
                                Else
                                    PGPType = 1  'ClearSigned
                                End If
                            End If
                            
                            'Decode Message
                            attempt = 1
                            pgpattempts = 0
                            triedblank = False
                            secretkey = -1
                            pgpoutfile = "": pgpoutfile2 = ""
                            'Convert Failed Conventional History to Tried
                            For i = 0 To BlockCount - 1
                                For j = 0 To CMax
                                    If CHist(i, j) = 2 Then CHist(i, j) = 1
                                Next j
                            Next i
                            
                            Do While ErrMsg = "" And attempt <> 0 And Not CancelDecrypt
                                'Select Passphrase
                                If PGPType = 0 Then
                                    'PK Encrypted
                                    'Find likely passphrase
                                    If secretkeyids <> "" Then
                                        secretkeyids = secretkeyids + vbTab
                                        y = 1
                                        x = InStr(secretkeyids, vbTab)
                                        Do While x <> 0
                                            c = Trim(Mid(secretkeyids, y, x - y))
                                            If c <> "" Then
                                                For i = 0 To MaxNyms
                                                    If KeyPass(i, 0) = "" Then Exit For
                                                    If InStr(1, KeyPass(i, 0), c, vbTextCompare) <> 0 Then secretkey = i: Exit Do
                                                Next i
                                            End If
                                            y = x + 1
                                            x = InStr(y, secretkeyids, vbTab)
                                        Loop
                                        secretkeyids = ""
                                    Else
                                        secretkey = -1
                                    End If
                                    If secretkey = -1 Then
                                        'Select random secret-key passphrase
                                        For i = 0 To MaxNyms
                                            If KeyPass(i, 0) = "" Then Exit For
                                            If Not Secret(i) Then secretkey = i: Exit For
                                        Next i
                                    Else
                                        firstsecretkeyid = ""
                                    End If
                                    If secretkey = -1 Then
                                        'No secret key passphrases left to try
                                        If Not triedblank Then
                                            'If first attempt try no passphrase
                                            Pass = ""
                                            triedblank = True
                                        Else
                                            If Val(Cnf(4, 14)) = 1 And firstsecretkeyid <> "" Then
                                                'Prompt for passphrase
                                                Pass = GetSignPass(firstsecretkeyid)
                                                firstsecretkeyid = ""
                                            Else
                                                ErrMsg = "Private key decryption failed"
                                                Pass = ""
                                            End If
                                        End If
                                    Else
                                        Pass = XCrypt("@@@" + KeyPass(secretkey, 1), LeftWin)
                                        Secret(secretkey) = True
                                    End If
                                ElseIf PGPType = 5 Then
                                    'Conv
                                    'Get conventional passphrase
                                    If crb <> -1 And cpx <> -1 And cpx + 1 < CMax Then
                                        'Known reply-block
                                        If CPass(crb, cpx + 1) <> "" And CHist(crb, cpx + 1) < 2 Then cpx = cpx + 1 Else crb = -1: cpx = -1
                                    Else
                                        crb = -1: cpx = -1
                                    End If
                                    If crb = -1 Then
                                        'Choose random
                                        For desperate = 0 To 2
                                            '0 first only
                                            '1 untried only
                                            '2 previously used
                                            For j = 0 To CMax
                                                If desperate = 0 And j = 1 Then Exit For
                                                For i = 0 To BlockCount - 1
                                                    If CHist(Priority(i), j) = 0 Or (CHist(Priority(i), j) = 1 And desperate = 2) Then _
                                                      If CPass(Priority(i), j) <> "" Then crb = Priority(i): cpx = j: Exit For
                                                Next i
                                                If crb <> -1 Then Exit For 'If i <> BlockCount Then Exit For
                                            Next j
                                            If crb <> -1 Then Exit For
                                        Next desperate
                                    End If
                                    DoEvents
                                    If crb = -1 Then
                                        'All conventional tried
                                        ErrMsg = "Conventional decryption failed"
                                    Else
                                        Pass = CPass(crb, cpx)
                                    End If
                                Else
                                    Pass = "NULL"
                                End If
                            
                                If ErrMsg = "" Then
                                    'Attempt decode
                                    DoEvents
                                    If Val(PData(12)) = 0 Then SigProps = "Decrypt"
                                    pgpoutfile = Decrypt(pgpfile, Pass, PGPErrCode, SigProps)
                                    DoEvents
                                    pgpattempts = pgpattempts + 1
                                    If pgpoutfile = "" Then
                                        'Decryption failed
                                        'Select Case PGPErrCode
                                            'Exit error conditions here set ErrMsg
                                            ''''''''
                                        'End Select
                                        If PGPType = 5 Then CHist(crb, cpx) = 2: crb = -1: cpx = -1 'failed
                                        attempt = attempt + 1
                                        If PGPType = 7 Then
                                            ErrMsg = "Newer version of PGP required"
                                        ElseIf PGPType <> 5 And PGPType <> 0 Then
                                            ErrMsg = "Decryption failure"
                                        End If
                                    Else
                                        'Succeeded
                                        If PGPType = 5 Then
                                            CHist(crb, cpx) = 1 'succeeded
                                            TagDate(crb) = SafeTime
                                            ShowPassphrase = Pass
                                        Else
                                            If secretkey <> -1 Then ShowPassphrase = KeyPass(secretkey, 0)
                                        End If
                                        attempt = 0
                                        'Check output for binary and get first line
                                        n3 = FreeFile
                                        Open pgpoutfile For Binary As n3
                                        x = 2048: If x > LOF(n3) Then x = LOF(n3)
                                        c = Input(x, n3)
                                        Close n3: n3 = 0
                                        firstpgptext = Extract(c, vbCrLf)
                                        DoEvents
                                        If Val(Cnf(4, 15)) = 0 Then
                                            'Binary PGP?
                                            Bincount = 0
                                            For i = 1 To Len(c)
                                                If InStr(1, BinChars, Mid(c, i, 1), vbBinaryCompare) <> 0 Then Bincount = Bincount + 1
                                            Next i
                                            If Bincount / Len(c) > 0.3 Then
                                               'Mostly Binary PGP Attachment
                                                ErrMsg = "Binary attachment"
                                            End If
                                        End If
                                    End If
                                    If ErrMsg = "" And attempt = 0 Then
                                        'Convert EOL and Invalid characters
                                        DoEvents
                                        pgpoutfile2 = ConvertEOL(pgpoutfile, ErrMsg)
                                        DelFile pgpoutfile: pgpoutfile = ""
                                        DoEvents
                                    End If
                                    If ErrMsg = "" And attempt = 0 Then
                                        'Scan For Headers
                                        If Not RBDecDone Then
                                            x = 0
                                            n3 = FreeFile
                                            Open pgpoutfile2 For Input As n3
                                            Do While Not EOF(n3) And x < 200
                                                Line Input #n3, c
                                                If Left(c, 14) = "ReplyBlockTag:" Then RBTag = Trim(Mid(c, 15)): c = ""
                                                If Left(c, 10) = "RBRcvEnum:" Then RBTag = "user@dcv" + Trim(Str(convcount)) + ".RBE." + Trim(Mid(c, 11)) + ".Decrypt": c = ""
                                                If c <> "" And c <> "**" Then Exit Do
                                                x = x + 1
                                            Loop
                                            x = 0: Found = False
                                            Do
                                                If LCase(Left(c, 3)) = "to:" Or LCase(Left(c, 5)) = "from:" Then Found = True
                                                If InStr(1, c, "content-type: message/partial", vbTextCompare) = 1 Then Found = True: MIMEMulti = True
                                                x = x + 1
                                                If EOF(n3) Then Exit Do
                                                Line Input #n3, c
                                            Loop Until Found Or x > 200 Or c = ""
                                            Close n3: n3 = 0
                                        End If
                                        DoEvents
                                        'Write message
                                        Sig.Status = "SIGNED_NOT"
                                        If Val(PData(12)) <> 0 Then
                                            'PGP 5+  Sig Props
                                            Sig = ParseSigData(SigProps)
                                        End If
                                        If (PGPType = 0 Or PGPType = 5) And Not RBDecDone And Found Then
                                            'Clean Reply-block message
                                            Close n2: n2 = 0
                                            DelFile newfile
                                            newfile = GetWork(PData(10))
                                            n2 = FreeFile
                                            Open newfile For Output As n2
                                            If PGPType = 0 Then xsecretcount = 1 Else xsecretcount = 0
                                            If AssembledFrom = "" Then
                                                If PGPType = 5 Then xconvcount = 1 Else xconvcount = 0
                                                Print #n2, "From " + RBTag + "." + Trim(Str(convcount + xconvcount)) + "&" + Trim(Str(secretcount + xsecretcount)) + "@JBN2.Decrypt" + " " + DateLine(1)
                                            Else
                                                x = InStr(AssembledFrom, "&")
                                                If x <> 0 And InStr(AssembledFrom, "@") > x Then AssembledFrom = Left(AssembledFrom, x) + Trim(Str(secretcount + xsecretcount)) + Mid(AssembledFrom, InStr(AssembledFrom, "@"))
                                                Print #n2, AssembledFrom
                                            End If
                                            RBPGP = "JBN2-"
                                            RBDecDone = True
                                        Else
                                            RBPGP = ""
                                        End If
                                        If Not MIMEMulti Then
                                            'Add PGP headers
                                            If PGPType = 5 Then
                                                pgpstartline = Replace(pgpstartline, "PGP", "CONVENTIONAL")
                                                pgpendline = Replace(pgpendline, "PGP", "CONVENTIONAL")
                                            ElseIf Val(PData(12)) <> 0 And Sig.Status = "SIGNED_NOT" Then
                                                pgpstartline = Replace(pgpstartline, "PGP", "UNSIGNED PGP")
                                            End If
                                            If RBPGP = "" Then Print #n2, Replace(pgpstartline, "-", "=")
                                            If Val(PData(12)) <> 0 Then
                                                c = pgpkeylist
                                                If RBPGP <> "" And c <> "" Then
                                                    c = RBPGP + Replace(Left(c, Len(c) - 2), vbCrLf, vbCrLf + RBPGP) + vbCrLf
                                                End If
                                                If Sig.Status <> "SIGNED_NOT" Then
                                                    c = c + RBPGP + "Signature: " + Sig.keyid + " " + Sig.UserID + vbCrLf + RBPGP + "Date: " + Sig.DateTimeStr + vbCrLf + RBPGP + "Status: "
                                                    If Sig.Verified Then
                                                        c = c + "OK  (" + Sig.KeyValidity + ")"
                                                    Else
                                                        c = c + "INVALID  (" + Sig.KeyValidity + ")"
                                                        If Sig.KeyDisabled Then c = c + "  [Key Disabled]"
                                                        If Sig.KeyExpired Then c = c + "  [Key Expired]"
                                                        If Sig.KeyRevoked Then c = c + "  [Key Revoked]"
                                                    End If
                                                    c = c + vbCrLf
                                                End If
                                                If c <> "" Then Print #n2, c;
                                            End If
                                            If RBPGP = "" Then Print #n2, ""
                                        End If
                                        'Write body
                                        Found = RBPGP = ""
                                        If RBPGP = "" Or Val(Cnf(4, 16)) + Val(Cnf(4, 17)) = 0 Then AckCount = 999 Else AckCount = 0
                                        AckDate = ""
                                        AckUniqueID = ""
                                        n3 = FreeFile
                                        Open pgpoutfile2 For Input As n3
                                        While Not EOF(n3)
                                            Line Input #n3, c
                                            'Detect false ====
                                            If Left(c, 1) = "=" Then
                                                If c Like "=*BEGIN *" Then c = "!FALSE!   " + c
                                            End If
                                            If Not Found Then
                                                'Catch Unique ID
                                                If LCase(c) Like "received: * with unique id *" Then AckUniqueID = Extract(Trim(Mid(c, InStr(1, c, "unique id", vbTextCompare) + 9)), " ")
                                                'Detect ReplyBlockTag
                                                If Not (c = "" Or c = "**" Or Left(c, 14) = "ReplyBlockTag:" Or Left(c, 10) = "RBRcvEnum:") Then Print #n2, c: Found = True
                                            Else
                                                'Write line
                                                Print #n2, c
                                                'Process Acksend
                                                If AckCount < 25 Then
                                                    If Left(c, 6) = "Date: " Then
                                                        AckDate = c
                                                    ElseIf AckDate <> "" Then
                                                        If InStr(c, "under your pseudonym:") <> 0 Then
                                                            If InStr(1, a, "not remailed", vbTextCompare) = 0 Then a = "Ack-" Else a = "!!!NAK-"
                                                            AckString = a + AckDate + vbCrLf
                                                            NymMsgID = AckUniqueID
                                                            If Val(Cnf(4, 16)) = 1 Then
                                                                'Update AckSend.TXT
                                                                ackseek = Seek(n3)
                                                                AckCount = 0
                                                                Do While Not EOF(n3) And AckCount < 30
                                                                    Line Input #n3, c
                                                                    If InStr(c, ":") <> 0 Then AckString = AckString + c + vbCrLf
                                                                    AckCount = AckCount + 1
                                                                Loop
                                                                Seek #n3, ackseek
                                                                RepeatAck = False
                                                                On Error Resume Next
                                                                If SDir(InboxFolder + "\AckSend.txt") <> "" Then
                                                                    n4 = FreeFile
                                                                    Open InboxFolder + "\AckSend.txt" For Input As n4
                                                                    Do While Not EOF(n4)
                                                                        Line Input #n4, c
                                                                        If c = a + AckDate Then RepeatAck = True: Exit Do
                                                                    Loop
                                                                    Close n4: n4 = 0
                                                                End If
                                                                If Not RepeatAck Then
                                                                    n4 = FreeFile
                                                                    Open InboxFolder + "\AckSend.txt" For Append As n4
                                                                    Print #n4, vbCrLf; AckString
                                                                    Close n4: n4 = 0
                                                                End If
                                                                On Error GoTo ErrorDecrypt
                                                            End If
                                                            AckCount = 99
                                                        End If
                                                    End If
                                                    AckCount = AckCount + 1
                                                End If
                                            End If
                                        Wend
                                        DoEvents
                                        If Not MIMEMulti Then Print #n2, Replace(pgpendline, "-", "=")
                                        Close n3: n3 = 0
                                    End If
                                End If
                            Loop
                            DelFile pgpfile: pgpfile = ""
                            DelFile pgpoutfile: pgpoutfile = ""
                            DelFile pgpoutfile2: pgpoutfile2 = ""
                            ActionTaken = ActionTaken + " [" + Trim(Str(pgpattempts)) + " attempts]"
                            If CancelDecrypt Then ErrMsg = "User cancelled"
                            If ErrMsg <> "" Then
                                'Can't Decode Message
                                a = "!Decrypt Error!  " + ErrMsg + vbCrLf + a
                                Seek #n, pgpseek
                            Else
                                If PGPType = 0 Then secretcount = secretcount + 1
                                If PGPType = 5 Then convcount = convcount + 1
                                Finished = RBPGP <> "" And MIMEMulti
                                firsttext = False
                                NoPGP = False
                                'Update Display
                                If pgpattempts <> 0 Then
                                    efftotal = efftotal + (1 / pgpattempts)
                                    effcount = effcount + 1
                                    b = "   Efficiency:" + Str(Int((efftotal / effcount) * 100)) + "%"
                                End If
                                Stat StatMain, LMsg(474) + Str(DecQCount + 1) + b
                                
                                If RBPGP = "" Then GoTo NextLine Else Exit Do
                            End If
                        End If
                    Case 67, 99    'c
                        'Multipart MIME
                        If InHeaders And InStr(1, a, "content-type: message/partial", vbTextCompare) = 1 Then MIMEMulti = True
                    End Select
                    If firsttext Then
                        If Trim(a) <> "" Then
                            firsttext = False
                            If Not LCase(a) Like "from *@*.*" Then Print #n2, "From " + RBTag + "." + Trim(Str(convcount)) + "&" + Trim(Str(secretcount)) + "@JBN2.Decrypt" + " " + DateLine(1)
                            If InStr(a, ": ") = 0 And Not LCase(a) Like "from *@*.*" Then
                                Print #n2, "From: ???"
                                Print #n2, "Subject: ---Decrypted Message---"; vbCrLf
                            End If
                        Else
                            GoTo NextLine
                        End If
                    End If
                    Print #n2, a
NextLine:
                    failpgp = False
                Loop
                Close n: n = 0
                Close n2: n2 = 0
                If curfile <> decfile Then DelFile curfile
                curfile = newfile: newfile = ""
                Stage = Stage + 1
                DoEvents
                If DecView And Not SkipDecView Then
                    'View Decrypt
                    If ShowPassphrase <> "" Then ShowPassphrase = "Decryption Key Used: " + ShowPassphrase
                    If ActionTaken <> "" Then ShowPassphrase = ShowPassphrase + vbCrLf + "Action Taken: " + Trim(ActionTaken)
                    If RBTag <> "Unknown" Then ShowPassphrase = ShowPassphrase + vbCrLf + "Reply Block Tag: " + RBTag
                    If pgpkeylist <> "" Then ShowPassphrase = ShowPassphrase + vbCrLf + "Encryption Info:" + vbCrLf + pgpkeylist
                    y = PreviewMsg("Decryption", Trim(Str(Stage)), "", -1, Finished, ShowPassphrase, curfile, False, 2)
                    Select Case y
                    Case 1: SkipDecView = True 'Finish
                    Case 2: MIMEMulti = False: GoTo NextMessage  'Cancel
                    End Select
                    DoEvents
                End If
            Wend
            'Copy final output
            'Determine destination
            outfile = ""
            If LCase(PlainName(decfile, 3)) <> "tmj" Then
                outfolder = NoSlash(PlainName(decfile, 0))
            Else
                outfolder = InboxFolder
            End If
            If MIMEMulti Then
                'Multipart
                outfolder = MultipartFolder
                outfile = ""
            ElseIf RBTag <> "Unknown" Then
                For i = 0 To BlockCount - 1
                    If TagFolder(i, 0) = RBTag Then
                        If Left(TagFolder(i, 1), 5) = "file:" Then
                            outfile = Mid(TagFolder(i, 1), 6)
                        ElseIf TagFolder(i, 1) <> "" Then
                            outfolder = NoSlash(TagFolder(i, 1))
                        End If
                        UpdateRB(i) = True
                        Exit For
                    End If
                Next i
            End If
            If Not MIMEMulti And NymMsgID <> "" And Val(Cnf(4, 17)) = 1 Then
                'Trash Nym Duplicates
                FoundNymMsgID = (InStr(AllNymMsgID, NymMsgID + vbCrLf) <> 0)
                If Not FoundNymMsgID Then
                    XNymFile = Cnf(4, 0) + "\JBN2NYM"
                    If SDir(XNymFile + ".IDX") <> "" Then
                        n2 = 0
                        n = FreeFile
                        Open XNymFile + ".IDX" For Input As n
                        If SafeTime - KeepDate(19) > 1 Then
                            'Clean XNym Daily
                            n2 = FreeFile
                            Open XNymFile + ".TMP" For Output As n2
                            Print #n2, "---"
                        End If
                        If Not EOF(n) Then Line Input #n, a
                        While Not EOF(n)
                            XNymDate = 0
                            On Error Resume Next
                            Input #n, XNymDate
                            On Error GoTo ErrorDecrypt
                            GoodXNym = SafeTime - XNymDate < 30  '30 days
                            If GoodXNym And n2 <> 0 Then Write #n2, XNymDate
                            a = "X"
                            Do While Not EOF(n)
                                Line Input #n, a
                                If GoodXNym And n2 <> 0 Then Print #n2, a
                                If a <> "---" Then
                                    If a = NymMsgID Then FoundNymMsgID = True: If n2 = 0 Then Exit Do
                                Else
                                    Exit Do
                                End If
                            Loop
                        Wend
                        Close n: n = 0
                        If n2 <> 0 Then
                            Close n2: n2 = 0
                            If DelFile(XNymFile + ".IDX") Then Name XNymFile + ".TMP" As XNymFile + ".IDX": KeepDate(19) = SafeTime
                        End If
                        DoEvents
                    End If
                End If
                If FoundNymMsgID Then
                    outfolder = Cnf(4, 0) + "\Trash\Duplicates"
                    outfile = ""
                Else
                    AllNymMsgID = AllNymMsgID + NymMsgID + vbCrLf
                End If
            End If
            If Cnf(4, 2) <> "" Then
                'Anti-SPAM
                TestMail curfile, False, SPAMFlag, False
                If SPAMFlag Then outfolder = Cnf(4, 0) + "\Trash\Spam": outfile = ""
            End If
            If Not CreateDir(outfolder) Then outfolder = InboxFolder
            If outfile = "" Then
                'Save to folder
                outfile = outfolder + "\" + PlainName(decfile, 2) + ".ML1"
                FileCopy curfile, outfile
                'Update New IDX if saved to folder
                On Error Resume Next
                n = FreeFile
                Open outfolder + "\JBN2NEW.IDX" For Append As n
                Print #n, outfile
                Close n: n = 0
                On Error GoTo ErrorDecrypt
                'Move original
                If LCase(PlainName(decfile, 0)) <> LCase(PlainName(outfile, 0)) And LCase(PlainName(decfile, 3)) <> "tmj" Then
                    FileCopy decfile, PlainName(outfile, 0) + PlainName(decfile, 1)
                    DelFile decfile
                End If
                'Alert View Mail Window
                If LCase(outfolder) = LCase(ViewerCurBox) And ViewerLoaded Then
                    frmViewer!tmrUpdate.Tag = frmViewer!tmrUpdate.Tag + "F"
                    frmViewer!tmrUpdate.Enabled = True
                End If
            Else
                'Append File
                n = FreeFile
                Open curfile For Input As n
                n2 = FreeFile
                Open outfile For Append As n2
                While Not EOF(n)
                    Line Input #n, a
                    Print #n2, a
                Wend
                Print #n2, vbCrLf
                Close n: n = 0
                Close n2: n2 = 0
            End If
NextMessage:
            If curfile <> decfile Then DelFile curfile
            If LCase(PlainName(decfile, 3)) = "tmj" Then DelFile decfile
        End If
        ReserveDecFile = ""
        DoEvents
    Loop
    
    'Update Nym Message IDs
    On Error GoTo ErrorIDUpdate
    If AllNymMsgID <> "" Then
        n = FreeFile
        Open Cnf(4, 0) + "\JBN2NYM.IDX" For Append As n
        Print #n, "---"
        Write #n, SafeTime
        Print #n, AllNymMsgID;
        Close n: n = 0
    End If
    
    'Update RB Used Dates
StartUpdateRB:
    On Error GoTo ErrorNymUpdate
    Found = False
    While NymDataBusy: DoEvents: Wend
    NymDataBusy = True
    For k = 0 To BlockCount - 1
        If UpdateRB(k) Then
            RBTag = TagFolder(k, 0)
            'Find reply-block
            RBTagLocation = ""
            FindRB RBTag, "", RBX, RBY, True, tempblock, RBPos
            If RBX <> -1 Then
                'Found
                u = InStr(1, tempblock, "used:", vbTextCompare)
                If u <> 0 Then
                    t = InStr(u, tempblock, vbCrLf)
                    If t <> 0 Then
                        newblock = Left(tempblock, u + 4) + Space(4) + Format(SafeTime, "dd-mmm-yyyy hh:nn") + Mid(tempblock, t)
                        Nyms(RBX, RBY) = Left(Nyms(RBX, RBY), RBPos - 1) + newblock + Mid(Nyms(RBX, RBY), RBPos + Len(tempblock))
                        Found = True
                    End If
                End If
            End If
        End If
    Next k
    DoEvents
Finish:
    On Error GoTo 0
    RBTagLocation = ""
    NymDataBusy = False
    If Found Then SaveConfig
    If Not CancelDecrypt Then RecombineMulti
    If DecQCount <> 0 Then GoTo Start
    'Alert View Mail Window
    If ViewerLoaded Then
        frmViewer!tmrUpdate.Tag = frmViewer!tmrUpdate.Tag + "D"
        frmViewer!tmrUpdate.Enabled = True
    End If
    Stat StatMain, ""
Exit Sub
ErrorPass:
    NymDataBusy = False
    RBTagLocation = ""
    DecQCount = 0
    MsgLog LMsg(530) + vbCrLf + Space(6) + Error, 4, True, True
Exit Sub
ErrorDecrypt:
    ErrMsg = Error
    Resume ErrorDecrypt2
ErrorDecrypt2:
    CloseFile n: n = 0
    CloseFile n2: n2 = 0
    CloseFile n3: n3 = 0
    CloseFile n4: n4 = 0
    DelFile newfile
    DelFile pgpfile: pgpfile = ""
    DelFile pgpoutfile: pgpoutfile = ""
    DelFile pgpoutfile2: pgpoutfile2 = ""
    MsgLog LMsg(531) + vbCrLf + Space(6) + ErrMsg + vbCrLf, 4, True, True
    GoTo NextMessage
ErrorNymUpdate:
    NymDataBusy = False
    MsgLog LMsg(532) + vbCrLf + Space(6) + Error, 4, True, True
    Resume Finish
ErrorIDUpdate:
    ErrM = Error
    Resume ErrorIDUpdate2
ErrorIDUpdate2:
    MsgLog LMsg(555) + vbCrLf + Space(6) + ErrM, 4, True, True
    CloseFile n
    GoTo StartUpdateRB
End Sub

Private Function PGPEncType(PGPLine, keyid) As Integer
    'Determines packet type of PGP 2.6.x messages
    'Returns 0  PK encrypted
    '        7  PK encrypted w/ DH
    '        5  Conventional
    '        4  unknown
    Dim PGPByte(12) As Byte, j As Integer, i As Integer
    keyid = ""
    If Len(PGPLine) < 16 Then PGPType = 4: Exit Function
    For i = 1 To 16 Step 4
        four = Mid(PGPLine, i, 4)
        Call ThreeByte(four, PGPByte(t + 1), PGPByte(t + 2), PGPByte(t + 3))
        t = t + 3
    Next i
    x = PGPByte(1) And 252  '11111100
    Select Case x
    Case 132, 168  ' Is = "10000100", Is = "10101000"    Secret Key
        keyid = "0x"
        'Length of Packet Length    RFC 2440: 4.2.1
        Select Case (PGPByte(1) And 3)
        Case 0: lol = 2
        Case 1: lol = 3
        Case 2: lol = 5
        Case Else: lol = 2
        End Select
        For i = 6 To 9
            keyid = keyid + Right("0" + Hex(PGPByte(i + lol)), 2)
        Next i
        If x = 168 Then PGPEncType = 7 Else PGPEncType = 0
    Case 160, 172  'Is = "10100000", "10101100" 'Compressed, Literal
        PGPEncType = 4  'Compressed, Literal
    Case Is = 164   '"10100100"
        PGPEncType = 5  'Conventional
    Case Else
        PGPEncType = 4  'Unknown
    End Select
End Function

Private Sub ThreeByte(four, B1, b2, b3)
    'Take four radix64 characters in four and output 3 octet bytes
    '+--first octet--+-second octet--+--third octet--+
    '|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|
    '+-----------+---+-------+-------+---+-----------+
    '|5 4 3 2 1 0|5 4 3 2 1 0|5 4 3 2 1 0|5 4 3 2 1 0|
    '+--1.index--+--2.index--+--3.index--+--4.index--+

    Const Radix64Val = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
    four = Left(four + "====", 4)
    For i = 1 To 4
        idx = 0
        For j = 0 To 63
            If Mid(Radix64Val, j + 1, 1) = Mid(four, i, 1) Then idx = j: Exit For
        Next j
        t = idx: a = ""
        For j = 5 To 0 Step -1
            If t >= 2 ^ j Then
                a = a + "1"
                t = t - 2 ^ j
            Else
                a = a + "0"
            End If
        Next j
        b = b + a
    Next i
    For i = 1 To 17 Step 8
        oc = 0
        For j = 7 To 0 Step -1
            oc = oc + Val(Mid(b, i + 7 - j, 1)) * 2 ^ j
        Next j
        If i = 1 Then B1 = oc
        If i = 9 Then b2 = oc
        If i = 17 Then b3 = oc
    Next i
End Sub

Private Sub QuickSortBlocks(Start As Integer, Finish As Integer, MainArray() As Date, TagArray() As Integer)
    Dim PosOfSplitter As Integer
    'Partition:
    Dim SplitPos As Integer, LeftPos As Integer
    Dim i As Integer, Splitter As Date, temp As Integer
    
    If Finish > Start Then
        'Begin Partition
        SplitPos = Start + Int((Finish - Start + 1) * Rnd)
        Splitter = MainArray(TagArray(SplitPos))
        temp = TagArray(SplitPos): TagArray(SplitPos) = TagArray(Start): TagArray(Start) = temp
        LeftPos = Start
        For i = Start + 1 To Finish
            If MainArray(TagArray(i)) > Splitter Then
                LeftPos = LeftPos + 1
                temp = TagArray(LeftPos): TagArray(LeftPos) = TagArray(i): TagArray(i) = temp
            End If
        Next i
        temp = TagArray(Start): TagArray(Start) = TagArray(LeftPos): TagArray(LeftPos) = temp
        PosOfSplitter = LeftPos
        'End Partition
        QuickSortBlocks Start, PosOfSplitter - 1, MainArray(), TagArray()
        QuickSortBlocks PosOfSplitter + 1, Finish, MainArray(), TagArray()
        DoEvents
    End If
End Sub

Private Sub tmrDecrypt_Timer()
    tmrDecrypt.Enabled = False
    DecryptMessages
    Unload Me
End Sub

Private Sub Form_Load()
    tmrDecrypt.Enabled = True
End Sub

Private Sub RecombineMulti()
    Dim InboxFolder As String, MultipartFolder As String
    Dim FileList() As String
    Dim PartId() As String, PartFile() As Integer, PartTotal() As Integer
    Dim temp(2) As String, Blk As String
    InboxFolder = Cnf(4, 0) + "\Inbox"
    MultipartFolder = Cnf(4, 0) + "\Multi"
    
    'Check for valid folders
    BadDir = False
    If Not CreateDir(InboxFolder) Then
        BadDir = True
    Else
        If Not CreateDir(MultipartFolder) Or _
        Not CreateDir(Cnf(4, 0) + "\Trash") Or _
        Not CreateDir(Cnf(4, 0) + "\Trash\Multi") Or _
        Not CreateDir(Cnf(4, 0) + "\Trash\Spam") Then BadDir = True
    End If
    If BadDir Then
        MsgLog LMsg(528), 4, True, True
        Exit Sub
    End If
    
    On Error GoTo ErrorScanMulti
    'Get FileList
    MaxFile = 50
    ReDim FileList(MaxFile)
    a = SDir(MultipartFolder + "\*.ML*")
    While a <> "" And numfiles < 32000
        If numfiles > MaxFile Then MaxFile = MaxFile + 50: ReDim Preserve FileList(MaxFile)
        FileList(numfiles) = a
        numfiles = numfiles + 1
        a = Dir
    Wend
    If numfiles = 0 Then Exit Sub
    maxpart = 20
    ReDim PartId(numfiles), PartFile(numfiles, maxpart), PartTotal(numfiles)
    'Get Ids, Totals, and PartFiles
    numids = 0
    For i = 0 To numfiles - 1
        bad = SDir(MultipartFolder + "\" + FileList(i)) = ""
        If UCase(PlainName(FileList(i), 3)) = "ML0" Then
            If Dir(MultipartFolder + "\" + PlainName(FileList(i), 2) + ".ML1") <> "" Then bad = True
        End If
        If Not bad Then
            n = FreeFile
            Open MultipartFolder + "\" + FileList(i) For Input As n
            x = 0: ParseState = 0
            While Not EOF(n) And x < 200 And Not bad And ParseState < 2
                Line Input #n, a
                If ParseState = 0 Then     'Whitespace before headers
                    If a <> "" Then ParseState = 1
                ElseIf ParseState = 1 Then 'Headers
                    If a = "" Then ParseState = 2
                End If
                If InStr(1, a, "content-type: message/partial", vbTextCompare) = 1 Then
                    'Content-type: message/partial; id="bBByqbro_FTrEP"; number=1; total=2
                    For j = 0 To 2
                        Select Case j
                        Case 0: b = "id="
                        Case 1: b = "number="
                        Case 2: b = "total="
                        End Select
                        y = InStr(1, a, b, vbTextCompare)
                        If y = 0 Then bad = True
                        temp(j) = Replace(Trim(Extract(Mid(a, y + Len(b)), ";")), Chr(34), "")
                    Next j
                    msgnumber = SVal(temp(1))
                    msgtotal = SVal(temp(2))
                    If Not bad And temp(0) <> "" And msgnumber > 0 And msgtotal >= msgnumber Then
                        'search for id
                        For j = 0 To numids - 1
                            If PartId(j) = temp(0) Then
                                'found
                                If msgnumber > PartTotal(j) Then
                                    bad = True
                                Else
                                    PartFile(j, msgnumber - 1) = i
                                End If
                                Exit For
                            End If
                        Next j
                        If j = numids Then
                            'not found, create new entry
                            PartId(numids) = temp(0)
                            PartTotal(numids) = msgtotal
                            If msgtotal - 1 > maxpart Then maxpart = msgtotal - 1: ReDim Preserve PartFile(numfiles, maxpart)
                            For j = 0 To maxpart
                                PartFile(numids, j) = -1
                            Next j
                            PartFile(numids, msgnumber - 1) = i
                            numids = numids + 1
                        End If
                    Else: bad = True
                    End If
                End If
                x = x + 1
            Wend
            Close n: n = 0
        End If
        DoEvents
    Next i
    
    On Error GoTo ErrorAssembly
    'Assemble complete messages
    For i = 0 To numids - 1
        For j = 0 To PartTotal(i) - 1
            If PartFile(i, j) = -1 Then Exit For
        Next j
        If j = PartTotal(i) Then
            Stat StatMain, LMsg(476)
            RBTag = ""
            PGPFlag = False
            newfile = GetWork(PData(10))
            n2 = FreeFile
            Open newfile For Output As n2
            For j = 0 To PartTotal(i) - 1
                f = MultipartFolder + "\" + FileList(PartFile(i, j))
                If SDir(f) = "" Then
                    'File is now missing, cancel
                    Close n2: n2 = 0
                    DelFile newfile
                    GoTo NextId
                Else
                    n = FreeFile
                    Open f For Input As n
                    ParseState = 0
                    Do While Not EOF(n) And ParseState < 3
                        Line Input #n, a
                        If ParseState = 0 Then      'Whitespace before headers
                            If a <> "" Then ParseState = 1
                        ElseIf ParseState = 1 Then  'Headers
                            If a = "" Then ParseState = 2
                            If InStr(1, a, "Subject: Partial Message", vbTextCompare) = 1 Then a = "Subject: ---Assembled [" + Trim(Str(PartTotal(i))) + " parts]---"
                        ElseIf ParseState = 2 Then  'Whitespace after headers
                            If a <> "" Then ParseState = 3  'Text After headers
                        End If
                        If j = 0 And ParseState > 0 Then
                            'First Part, keep headers
                            If ParseState = 1 Then
                                If a Like "From *@JBN2.Decrypt *:*" Then
                                    RBTag = Trim(Extract(Mid(a, 6), "."))
                                    x = InStr(a, "@JBN2.Decrypt")
                                    a = Left(a, x) + "JBN2.Assembled " + DateLine(1)
                                End If
                                If InStr(1, a, "content-type: message/partial", _
                                  vbTextCompare) = 0 Then Print #n2, a
                            ElseIf ParseState = 3 Then
                                If InStr(1, a, "content-type:", vbTextCompare) <> 0 Then
                                    Do
                                        Print #n2, a
                                        If Not EOF(n) Then Line Input #n, a Else a = ""
                                    Loop Until a = ""
                                    DoEvents
                                    Print #n2, a
                                    While Not EOF(n) And a = ""
                                        Line Input #n, a
                                    Wend
                                    DoEvents
                                Else
                                    Print #n2, ""
                                End If
                            End If
                        End If
                    Loop
                    'Write body with no trailing blanks
                    Print #n2, a
                    If a = BeginPGP Or a = BeginSig Then PGPFlag = True
                    blanklines = ""
                    While Not EOF(n)
                        Line Input #n, a
                        If a = "" Then
                            blanklines = blanklines + vbCrLf
                        Else
                            Print #n2, blanklines; a
                            blanklines = ""
                            If Not PGPFlag Then If a = BeginPGP Or a = BeginSig Then PGPFlag = True
                        End If
                    Wend
                    Close n: n = 0
                    DoEvents
                End If
            Next j
            Close n2: n2 = 0
            'Write output
            outfolder = ""
            If RBTag <> "" Then
                'Find folder for Reply-block message
                While NymDataBusy: DoEvents: Wend
                NymDataBusy = True
                FindRB RBTag, RBNum, RBX, RBY, True, Blk
                If RBX <> -1 Then
                    x = InStr(1, Blk, "folder:", vbTextCompare)
                    If x <> 0 Then
                        outfolder = NoSlash(Trim(Extract(Mid(Blk, x + 7), vbCrLf)))
                    End If
                End If
                NymDataBusy = False
            End If
            If outfolder = "" Then outfolder = InboxFolder
            Do
                outfile = outfolder + "\" + MakeTag(8)
            Loop Until SDir(outfile + ".*") = ""
            outfile = outfile + ".ML0"
            FileCopy newfile, outfile
            DelFile newfile: newfile = ""
            'Move originals to trash
            For j = 0 To PartTotal(i) - 1
                f = MultipartFolder + "\" + PlainName(FileList(PartFile(i, j)), 2)
                For k = 0 To 1
                    If Dir(f + ".ML" + Trim(Str(k))) <> "" Then
                        FileCopy f + ".ML" + Trim(Str(k)), Cnf(4, 0) + "\Trash\Multi\" + PlainName(FileList(PartFile(i, j)), 2) + ".ML" + Trim(Str(k))
                        DelFile f + ".ML" + Trim(Str(k))
                    End If
                Next k
                DoEvents
            Next j
            'Queue for decryption
            If Val(Cnf(4, 12)) = 1 And (PGPFlag Or Val(Cnf(4, 13)) = 0) Then QueueDec outfile
        End If
NextId:
    Next i
Exit Sub
ErrorScanMulti:
    ErrMsg = Error
    CloseFile n
    MsgLog LMsg(533) + vbCrLf + Space(6) + ErrMsg, 4, True, True
Exit Sub
ErrorAssembly:
    ErrMsg = Error
    CloseFile n
    CloseFile n2
    DelFile newfile
    MsgLog LMsg(534) + vbCrLf + Space(6) + ErrMsg, 4, True, True
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Decrypting = False
End Sub
