Attribute VB_Name = "API"
'Copyright 1999 Potato Software.   See MAIN.BAS and LICENSE.TXT.

'API Function and Constant Declarations
Option Explicit

Public Const REG_SZ As Long = 1
Public Const REG_DWORD As Long = 4

Public Const HKEY_CLASSES_ROOT = &H80000000
Public Const HKEY_CURRENT_USER = &H80000001
Public Const HKEY_LOCAL_MACHINE = &H80000002
Public Const HKEY_USERS = &H80000003

Public Const ERROR_NONE = 0
Public Const ERROR_BADDB = 1
Public Const ERROR_BADKEY = 2
Public Const ERROR_CANTOPEN = 3
Public Const ERROR_CANTREAD = 4
Public Const ERROR_CANTWRITE = 5
Public Const ERROR_OUTOFMEMORY = 6
Public Const ERROR_ARENA_TRASHED = 7
Public Const ERROR_ACCESS_DENIED = 8
Public Const ERROR_INVALID_PARAMETERS = 87
Public Const ERROR_NO_MORE_ITEMS = 259

Public Const KEY_ALL_ACCESS = &H3F

Public Const REG_OPTION_NON_VOLATILE = 0

Declare Function RegCloseKey Lib "advapi32.dll" _
(ByVal hKey As Long) As Long
'Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias _
'"RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, _
'ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions _
'As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes _
'As Long, phkResult As Long, lpdwDisposition As Long) As Long
Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias _
"RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, _
ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As _
Long) As Long
Declare Function RegQueryValueExString Lib "advapi32.dll" Alias _
"RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
String, ByVal lpReserved As Long, lpType As Long, ByVal lpData _
As String, lpcbData As Long) As Long
Declare Function RegQueryValueExLong Lib "advapi32.dll" Alias _
"RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
String, ByVal lpReserved As Long, lpType As Long, lpData As _
Long, lpcbData As Long) As Long
Declare Function RegQueryValueExNULL Lib "advapi32.dll" Alias _
"RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
String, ByVal lpReserved As Long, lpType As Long, ByVal lpData _
As Long, lpcbData As Long) As Long
'Declare Function RegSetValueExString Lib "advapi32.dll" Alias _
'"RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, _
'ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As _
'String, ByVal cbData As Long) As Long
'Declare Function RegSetValueExLong Lib "advapi32.dll" Alias _
'"RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, _
'ByVal Reserved As Long, ByVal dwType As Long, lpValue As Long, _
'ByVal cbData As Long) As Long

Public Declare Function ShellExecute Lib "shell32.dll" Alias _
    "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As _
    String, ByVal lpFile As String, ByVal lpParameters As String, _
    ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
'   Usage:  ret = ShellExecute(Me.hwnd, "Open", Label1.Caption, "", App.Path, 1)

'For Bug Fix to ListView Width property
'MSKB Article ID: Q179988
Public Declare Function SendMessage Lib "user32" Alias "SendMessageA" ( _
          ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, _
          ByVal lParam As Long) As Long
Public Const LVM_FIRST = &H1000
Public Const LVM_GETCOLUMNWIDTH = LVM_FIRST + 29
Public Const LVM_SETCOLUMNWIDTH = LVM_FIRST + 30


'TIME ZONE INFORMATION
Private Type SYSTEMTIME
        wYear As Integer
        wMonth As Integer
        wDayOfWeek As Integer
        wDay As Integer
        wHour As Integer
        wMinute As Integer
        wSecond As Integer
        wMilliseconds As Integer
End Type
Declare Sub GetSystemTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)
Declare Sub GetLocalTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)

Public Function GetGMTOffset() As Double
    Const Months = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec "
    Dim SysTime As SYSTEMTIME
    Dim LocTime As SYSTEMTIME
    Dim u As String, l As String
    GetSystemTime SysTime
    GetLocalTime LocTime
    u = Trim(Str(SysTime.wDay)) + " " + Mid(Months, (SysTime.wMonth) * 4 - 3, 4) + Trim(Str(SysTime.wYear)) + " " + Trim(Str(SysTime.wHour)) + ":" + Trim(Str(SysTime.wMinute))
    l = Trim(Str(LocTime.wDay)) + " " + Mid(Months, (LocTime.wMonth) * 4 - 3, 4) + Trim(Str(LocTime.wYear)) + " " + Trim(Str(LocTime.wHour)) + ":" + Trim(Str(LocTime.wMinute))
    GetGMTOffset = (ResolveDate(l) - ResolveDate(u))
End Function

'SetValueEx and QueryValueEx Wrapper Functions:
#If False Then
Public Function SetValueEx(ByVal hKey As Long, sValueName As String, _
   lType As Long, vValue As Variant) As Long
   Dim lValue As Long
   Dim sValue As String
   Select Case lType
       Case REG_SZ
           sValue = vValue & Chr$(0)
           SetValueEx = RegSetValueExString(hKey, sValueName, 0&, _
                                          lType, sValue, Len(sValue))
       Case REG_DWORD
           lValue = vValue
           SetValueEx = RegSetValueExLong(hKey, sValueName, 0&, _
           lType, lValue, 4)
   End Select
End Function
#End If

Private Function QueryValueEx(ByVal lhKey As Long, ByVal szValueName As _
String, vValue As Variant) As Long
    Dim cch As Long
    Dim lrc As Long
    Dim lType As Long
    Dim lValue As Long
    Dim sValue As String

    On Error GoTo QueryValueExError

    ' Determine the size and type of data to be read
    lrc = RegQueryValueExNULL(lhKey, szValueName, 0&, lType, 0&, cch)
    If lrc <> ERROR_NONE Then Error 5

    Select Case lType
        ' For strings
        Case REG_SZ:
            sValue = String(cch, 0)
            lrc = RegQueryValueExString(lhKey, szValueName, 0&, lType, sValue, cch)
            If lrc = ERROR_NONE Then
                vValue = Left$(sValue, cch - 1)
            Else
                vValue = Empty
            End If
        ' For DWORDS
        Case REG_DWORD:
            lrc = RegQueryValueExLong(lhKey, szValueName, 0&, lType, _
            lValue, cch)
            If lrc = ERROR_NONE Then vValue = lValue
        Case Else
            'all other data types not supported
            lrc = -1
    End Select

QueryValueExExit:
    QueryValueEx = lrc
Exit Function
QueryValueExError:
    Resume QueryValueExExit
End Function

'---------------------------------------------------------------------

Public Function QueryValueROOT(sKeyName As String, sValueName As String, _
Optional HKEYROOT As Long) As String
'My Variation of QueryValue
' Call with sValueName set to "" for default value
    Dim lRetVal As Long         'result of the API functions
    Dim hKey As Long         'handle of opened key
    Dim vValue As Variant      'setting of queried value
    
    If HKEYROOT = 0 Then HKEYROOT = HKEY_CLASSES_ROOT
    lRetVal = RegOpenKeyEx(HKEYROOT, sKeyName, 0&, _
    KEY_ALL_ACCESS, hKey)
    lRetVal = QueryValueEx(hKey, sValueName, vValue)
    QueryValueROOT = vValue
    RegCloseKey (hKey)
End Function

Public Function OpenFileAPI(Filename) As String
    Dim extkey As String, progval As String, ext As String, extval As String
    Dim a As String, i As Byte
    
    On Error GoTo OpenError
    ext = PlainName(Filename, 3)
    While InStr(ext, ".") <> 0
        ext = Mid(ext, InStr(ext, ".") + 1)
    Wend
    extval = QueryValueROOT("." + ext, "")
    If extval = "" Then
        progval = QueryValueROOT("unknown\shell\openas\command", "")
    Else
        progval = QueryValueROOT(extval + "\shell\open\command", "")
    End If
    If progval <> "" Then
        If InStr(progval, "%1") = 0 Then progval = progval + " %1"
        If InStr(progval, Chr(34) + "%1") <> 0 Then
            a = Replace(progval, "%1", Filename)
        Else
            a = Replace(progval, "%1", Chr(34) + Filename + Chr(34))
        End If
        For i = 2 To 9
            a = Replace(a, "%" + Trim(Str(i)), "")
        Next i
        OpenFileAPI = a
    Else
        OpenFileAPI = ""
    End If
Exit Function
OpenError:
    OpenFileAPI = ""
End Function



