Attribute VB_Name = "spgp"
'SPGP.BAS
'version 2.2, 14 July 99
'added functions spgpKeySign, spgpKeySigRemove, spgpKeyPropUserID,
'spgpKeyPropSig, spgpKeyRingToFile
'--------------------------------------------------------
'version 2.1.1.0, 7 June 99
'added functions spgpDetachedSigCreate & spgpDetachedSigVerify
'added function spgpKeyRingCount
'added default hash for signing, and related global constant
'--------------------------------------------------------
'version 2.1.0.0, 1 June 99
'added function spgpVersion
'added functions spgpAnalyzeEx, spgpAnalyzeFileEx & related Constants
'fixed keyimportfile, again
'pursuant to the above, added 'ByRef' to As Long params where needed
'introduced confusing new version numbering, just what we need
'--------------------------------------------------------
'version 2.0e, 7 Mar 99
'added Preferences functions and constants
'--------------------------------------------------------
'version 2.0, 21 Feb 99
'now supports PGP 6.x
'added ciphering algorithms
'fixed keyimportfile broken in 1.1
'abbreviated keyprops in keyimport functions
'changed some key/signature properties to global constants
'keyexport functions can use compatible-format mode
'--------------------------------------------------------
'version 1.1, 4 Feb 99
'fixed armor/clearsigning problem
'primary Key ID no longer required
'added hashing algorithms
'added spgpAnalyzeFile()
'--------------------------------------------------------
'
' note that while some of these constants have the same name as
' variables found in the pgp *.h files, they do not all have the same
' values -- these are not meant to be translations of those files!

'public key algorithms
Global Const PGPPublicKeyAlgorithm_Invalid = 0 'this (0) may not be correct, but how to test it? anyone got an invalid algorithm laying around?
Global Const PGPPublicKeyAlgorithm_RSA = 1
Global Const PGPPublicKeyAlgorithm_RSAEncryptOnly = 2
Global Const PGPPublicKeyAlgorithm_RSASignOnly = 3
Global Const PGPPublicKeyAlgorithm_ElGamal = 4 'A.K.A. Diffie-Hellman
Global Const PGPPublicKeyAlgorithm_DSA = 5

'symmetric ciphers
Global Const PGPCipherAlgorithm_IDEA = 1
Global Const PGPCipherAlgorithm_3DES = 2
Global Const PGPCipherAlgorithm_CAST5 = 3

'hashing algorithms
Global Const PGPHashAlgorithm_Default = 0
Global Const PGPHashAlgorithm_MD5 = 1
Global Const PGPHashAlgorithm_SHA = 2
Global Const PGPHashAlgorithm_RIPEMD160 = 3
Global Const PGPHashAlgorithm_SHADouble = 4 ' not available in PGP 6

'trust levels
Global Const PGPKeyTrust_Undefined = 0
Global Const PGPKeyTrust_Unknown = 1
Global Const PGPKeyTrust_Never = 2
Global Const PGPKeyTrust_Marginal = 5
Global Const PGPKeyTrust_Complete = 6
Global Const PGPKeyTrust_Ultimate = 7

'validity levels
Global Const PGPValidity_Unknown = 0
Global Const PGPValidity_Invalid = 1
Global Const PGPValidity_Marginal = 2
Global Const PGPValidity_Complete = 3

'analysis results
Global Const PGPAnalyze_Encrypted = 0            ' Encrypted message
Global Const PGPAnalyze_Signed = 1               ' Signed message
Global Const PGPAnalyze_DetachedSignature = 2    ' Detached signature
Global Const PGPAnalyze_Key = 3                  ' Key data
Global Const PGPAnalyze_Unknown = 4              ' Non-pgp message
' these are for spgpAnalyzeEx only
Global Const PGPAnalyze_EncryptedConventional = 5 ' Like it says
Global Const PGPAnalyze_EncryptedNoKeys = 6      ' Key-encrypted to keys not on local ring

'signature status
Global Const SIGNED_GOOD = 0
Global Const SIGNED_NOT = 1
Global Const SIGNED_BAD = 2
Global Const SIGNED_NO_KEY = 3

'preferences
Global Const PGPPref_PublicKeyring = 0
Global Const PGPPref_PrivateKeyring = 1
Global Const PGPPref_RandomSeedFile = 2
Global Const PGPPref_DefaultKeyID = 3   'not supported (encoded?)

' function names exported from the dll are case-sensitive.
' encrypt/decrypt
Declare Function spgpEncode Lib "spgp.dll" Alias "spgpencode" (ByVal BufferIn As String, ByVal BufferOut As String, ByVal BufferOutLen As Long, ByVal Encrypt As Long, ByVal Sign As Long, ByVal SignAlg As Long, ByVal Conventional As Long, ByVal ConventionalAlg As Long, ByVal Armor As Long, ByVal TextMode As Long, ByVal Clear As Long, ByVal CryptKeyID As String, ByVal SignKeyID As String, ByVal SignKeyPass As String, ByVal ConventionalPass As String, ByVal comment As String) As Long
Declare Function spgpEncodeFile Lib "spgp.dll" Alias "spgpencodefile" (ByVal FileIn As String, ByVal FileOut As String, ByVal Encrypt As Long, ByVal Sign As Long, ByVal SignAlg As Long, ByVal Conventional As Long, ByVal ConventionalAlg As Long, ByVal Armor As Long, ByVal TextMode As Long, ByVal Clear As Long, ByVal CryptKeyID As String, ByVal SignKeyID As String, ByVal SignKeyPass As String, ByVal ConventionalPass As String, ByVal comment As String) As Long

Declare Function spgpDecode Lib "spgp.dll" Alias "spgpdecode" (ByVal BufferIn As String, ByVal BufferOut As String, ByVal BufferOutLen As Long, ByVal Pass As String, ByVal SigProps As String) As Long
Declare Function spgpDecodeFile Lib "spgp.dll" Alias "spgpdecodefile" (ByVal FileIn As String, ByVal FileOut As String, ByVal Pass As String, ByVal SigProps As String) As Long

' key import/export
Declare Function spgpKeyExport Lib "spgp.dll" Alias "spgpkeyexport" (ByVal KeyID As String, ByVal BufferOut As String, ByVal BufferOutLen As Long, ByVal ExportPrivate As Long, ByVal ExportCompatible As Long) As Long
Declare Function spgpKeyExportFile Lib "spgp.dll" Alias "spgpkeyexportfile" (ByVal KeyID As String, ByVal FileOut As String, ByVal ExportPrivate As Long, ByVal ExportCompatible As Long) As Long
Declare Function spgpKeyImport Lib "spgp.dll" Alias "spgpkeyimport" (ByVal BufferIn As String, ByVal KeyProps As String, ByVal KeyPropsLen As Long) As Long
Declare Function spgpKeyImportFile Lib "spgp.dll" Alias "spgpkeyimportfile" (ByVal FileIn As String, ByVal KeyProps As String, ByVal KeyPropsLen As Long) As Long
'was Declare Function spgpKeyImportFile Lib "spgp.dll" Alias "spgpkeyimportfile" (ByVal FileIn As String, ByVal KeyProps As String, KeyPropsLen As Long) As Long
'Declare Function spgpKeyImportFileX Lib "spgp.dll" Alias "spgpkeyimportfilex" (ByVal PrefsFile As String, ByVal FileIn As String, ByVal KeyProps As String, ByVal KeyPropsLen As Long) As Long
Declare Function spgpkeyremove Lib "spgp.dll" (ByVal KeyID As String) As Long

' key properties
Declare Function spgpKeyProps Lib "spgp.dll" Alias "spgpkeyprops" (ByVal KeyID As String, ByVal KeyProps As String, ByVal KeyPropsLen As Long) As Long
Declare Function spgpKeyRingID Lib "spgp.dll" Alias "spgpkeyringid" (ByVal BufferOut As String, ByVal BufferOutLen As Long) As Long
Declare Function spgpKeyRingCount Lib "spgp.dll" Alias "spgpkeyringcount" () As Long
Declare Function spgpKeyRingToFile Lib "spgp.dll" Alias "spgpkeyringtofile" (ByVal FileOut As String) As Long
Declare Function spgpKeyPropUserID Lib "spgp.dll" Alias "spgpkeypropuserid" (ByVal KeyID As String, ByVal BufferOut As String, ByVal BufferOutLen As Long) As Long
Declare Function spgpKeyPropSig Lib "spgp.dll" Alias "spgpkeypropsig" (ByVal UserID As String, ByVal BufferOut As String, ByVal BufferOutLen As Long) As Long

' error strings
Declare Function spgpGetErrorString Lib "spgp.dll" Alias "spgpgeterrorstring" (ByVal theError As Long, ByVal BufferOut As String) As Long

' analyze
Declare Function spgpAnalyze Lib "spgp.dll" Alias "spgpanalyze" (ByVal BufferIn As String) As Long
Declare Function spgpAnalyzeFile Lib "spgp.dll" Alias "spgpanalyzefile" (ByVal FileIn As String) As Long
Declare Function spgpAnalyzeEx Lib "spgp.dll" Alias "spgpanalyzeex" (ByVal BufferIn As String, ByVal BufferOut As String, ByVal BufferOutLen As Long) As Long
Declare Function spgpAnalyzeFileEx Lib "spgp.dll" Alias "spgpanalyzefileex" (ByVal FileIn As String, ByVal BufferOut As String, ByVal BufferOutLen As Long) As Long

' misc
Declare Function spgpKeyIsOnRing Lib "spgp.dll" Alias "spgpkeyisonring" (ByVal KeyID As String) As Long
Declare Function spgpSetPreference Lib "spgp.dll" Alias "spgpsetpreference" (ByVal Preference As Long, ByVal BufferIn As String) As Long
Declare Function spgpGetPreference Lib "spgp.dll" Alias "spgpgetpreference" (ByVal Preference As Long, ByVal BufferOut As String) As Long
Declare Function spgpVersion Lib "spgp.dll" Alias "spgpversion" () As Long

' signatures
Declare Function spgpDetachedSigCreate Lib "spgp.dll" Alias "spgpdetachedsigcreate" (ByVal FileIn As String, ByVal SigFile As String, ByVal SignKeyID As String, ByVal SignKeyPass As String, ByVal comment As String, ByVal SignAlg As Long, ByVal Armor As Long) As Long
Declare Function spgpDetachedSigVerify Lib "spgp.dll" Alias "spgpdetachedsigverify" (ByVal SigFile As String, ByVal SignedFile As String, ByVal SigProps As String) As Long
Declare Function spgpKeySigRemove Lib "spgp.dll" Alias "spgpkeysigremove" (ByVal KeyHexID As String, ByVal UserID As String, ByVal SignKeyID As String) As Long
Declare Function spgpKeySign Lib "spgp.dll" Alias "spgpkeysign" (ByVal KeyHexID As String, ByVal UserID As String, ByVal SignKeyID As String, ByVal SignKeyPass As String, ByVal Expires As Long, ByVal Exportable As Long, ByVal Trust As Long, ByVal Validity As Long) As Long


