/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.io.DataNotValidIOException;
import freenet.support.io.DiscontinueInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VerifyingInputStream
extends DiscontinueInputStream {
    protected long dataLength;
    protected long bytesRead;
    protected boolean finished = false;
    protected boolean stripControls = false;
    protected boolean allRead = false;

    public VerifyingInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.dataLength = l;
    }

    public void stripControls(boolean bl) {
        this.stripControls = bl;
    }

    public int read() throws IOException, DataNotValidIOException {
        if (this.finished) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            ++this.bytesRead;
            if (this.bytesRead == this.dataLength) {
                this.finished = true;
            } else if (this.bytesRead == this.dataLength - 1L) {
                this.allRead = true;
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        int n3;
        if (this.finished) {
            return -1;
        }
        if (this.allRead) {
            int n4 = this.read();
            if (n4 == -1) {
                return -1;
            }
            byArray[n] = (byte)n4;
            return 1;
        }
        if ((long)n2 > this.dataLength - this.bytesRead - 1L) {
            n2 = (int)(this.dataLength - this.bytesRead - 1L);
        }
        if ((n3 = this.in.read(byArray, n, n2)) != -1) {
            this.bytesRead += (long)n3;
            if (this.bytesRead == this.dataLength - 1L) {
                this.allRead = true;
            }
        }
        return n3;
    }

    public int available() throws IOException {
        int n = super.available();
        return this.allRead ? (n == 0 ? 0 : 1) : (int)Math.min((long)n, this.stripControls ? this.dataLength - this.bytesRead - 1L : this.dataLength - this.bytesRead);
    }

    public void discontinue() throws IOException {
        if (this.in instanceof DiscontinueInputStream) {
            ((DiscontinueInputStream)this.in).discontinue();
        } else {
            this.close();
        }
    }
}

