/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Comparator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Fields {
    private static Logger logger = Logger.getLogger(Fields.class.getName());

    public static void main(String[] stringArray) {
        System.out.println(Long.toHexString(Fields.stringToLong(stringArray[0])));
        System.out.println(Long.toHexString(Long.parseLong(stringArray[0], 16)));
    }

    public static final long stringToLong(String string) throws NumberFormatException {
        return Fields.hexToLong(string);
    }

    public static final String longToString(long l) {
        return Fields.longToHex(l);
    }

    public static final long hexToLong(String string) throws NumberFormatException {
        int n = string.length();
        if (n > 16) {
            throw new NumberFormatException();
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l <<= 4;
            int n2 = Character.digit(string.charAt(i), 16);
            if (n2 < 0) {
                throw new NumberFormatException();
            }
            l |= (long)n2;
        }
        return l;
    }

    public static final int hexToInt(String string) throws NumberFormatException {
        int n = string.length();
        if (n > 16) {
            throw new NumberFormatException();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 4;
            int n3 = Character.digit(string.charAt(i), 16);
            if (n3 < 0) {
                throw new NumberFormatException();
            }
            n2 |= n3;
        }
        return n2;
    }

    public static final String longToHex(long l) {
        StringBuffer stringBuffer = new StringBuffer(17);
        Fields.longToHex(l, stringBuffer);
        return stringBuffer.toString();
    }

    public static final void longToHex(long l, StringBuffer stringBuffer) {
        do {
            stringBuffer.append(Character.forDigit((int)l & 0xF, 16));
        } while ((l >>>= 4) != 0L);
        stringBuffer.reverse();
    }

    public static final String intToHex(int n) {
        StringBuffer stringBuffer = new StringBuffer(9);
        do {
            stringBuffer.append(Character.forDigit(n & 0xF, 16));
        } while ((n >>>= 4) != 0);
        return stringBuffer.reverse().toString();
    }

    public static final boolean stringToBool(String string, boolean bl) {
        return bl ? !string.equalsIgnoreCase("false") : string.equalsIgnoreCase("true");
    }

    public static final String boolToString(boolean bl) {
        return bl ? "true" : "false";
    }

    public static final byte[] hexToBytes(String string) {
        return Fields.hexToBytes(string, 0);
    }

    public static final byte[] hexToBytes(String string, int n) {
        byte[] byArray = new byte[n + (1 + string.length()) / 2];
        Fields.hexToBytes(string, byArray, n);
        return byArray;
    }

    public static final void hexToBytes(String string, byte[] byArray, int n) throws NumberFormatException, IndexOutOfBoundsException {
        if (string.length() % 2 != 0) {
            string = '0' + string;
        }
        if (byArray.length < n + string.length() / 2) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < string.length(); ++i) {
            byte by = (byte)Character.digit(string.charAt(i), 16);
            if (by < 0) {
                throw new NumberFormatException();
            }
            byArray[n + i / 2] = i % 2 == 0 ? (byte)(by << 4) : (byte)(byArray[n + i / 2] | by);
        }
    }

    public static final String bytesToHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        Fields.bytesToHexAppend(byArray, n, n2, stringBuffer);
        return stringBuffer.toString();
    }

    public static final void bytesToHexAppend(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        for (int i = n; i < n + n2 && i < byArray.length; ++i) {
            stringBuffer.append(Character.forDigit(byArray[i] >>> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[i] & 0xF, 16));
        }
    }

    public static final String bytesToHex(byte[] byArray) {
        return Fields.bytesToHex(byArray, 0, byArray.length);
    }

    public static final String[] commaList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public static final String commaList(String[] stringArray) {
        return Fields.textList(stringArray, ',');
    }

    public static final String textList(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static final long[] numberList(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        long[] lArray = new long[stringTokenizer.countTokens()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Fields.stringToLong(stringTokenizer.nextToken());
        }
        return lArray;
    }

    public static final String numberList(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer(lArray.length * 18);
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(Fields.longToString(lArray[i]));
            if (i == lArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public static final long dateTime(String string) throws NumberFormatException {
        int n = string.indexOf(45);
        if (!(n == -1 && string.length() == 8 || n == 8 && string.length() == 17)) {
            throw new NumberFormatException("Date time: " + string + " not correct.");
        }
        int n2 = Integer.parseInt(string.substring(0, 4));
        int n3 = Integer.parseInt(string.substring(4, 6));
        int n4 = Integer.parseInt(string.substring(6, 8));
        int n5 = n == -1 ? 0 : Integer.parseInt(string.substring(9, 11));
        int n6 = n == -1 ? 0 : Integer.parseInt(string.substring(12, 14));
        int n7 = n == -1 ? 0 : Integer.parseInt(string.substring(15, 17));
        try {
            return new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7).getTime().getTime();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in dateTime(String date)", exception);
            throw new NumberFormatException("Invalid date " + string + ": " + exception);
        }
    }

    public static final String secToDateTime(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        String string = simpleDateFormat.format(new Date(l * 1000L));
        if (string.endsWith("-00:00:00")) {
            string = string.substring(0, 8);
        }
        return string;
    }

    public static final int compareBytes(byte[] byArray, byte[] byArray2) {
        int n = Math.max(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (i == byArray.length) {
                return i == byArray2.length ? 0 : -1;
            }
            if (i == byArray2.length) {
                return 1;
            }
            if ((0xFF & byArray[i]) > (0xFF & byArray2[i])) {
                return 1;
            }
            if ((0xFF & byArray[i]) >= (0xFF & byArray2[i])) continue;
            return -1;
        }
        return 0;
    }

    public static final int compareBytes(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (i + n == byArray.length) {
                return i + n2 == byArray2.length ? 0 : -1;
            }
            if (i + n2 == byArray2.length) {
                return 1;
            }
            if ((0xFF & byArray[i + n]) > (0xFF & byArray2[i + n2])) {
                return 1;
            }
            if ((0xFF & byArray[i + n]) >= (0xFF & byArray2[i + n2])) continue;
            return -1;
        }
        return 0;
    }

    public static final boolean byteArrayEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean byteArrayEqual(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[i + n] == byArray2[i + n2]) continue;
            return false;
        }
        return true;
    }

    public static final int hashCode(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            int n2 = byArray[i] & 0xFF;
            n ^= n2 << ((i & 3) << 3);
        }
        return n;
    }

    public static final long longHashCode(byte[] byArray) {
        long l = 0L;
        for (int i = byArray.length - 1; i >= 0; --i) {
            int n = byArray[i] & 0xFF;
            l ^= (long)n << ((i & 7) << 3);
        }
        return l;
    }

    public static final class ByteArrayComparator
    implements Comparator {
        public final int compare(Object object, Object object2) {
            return ByteArrayComparator.compare((byte[])object, (byte[])object2);
        }

        public static final int compare(byte[] byArray, byte[] byArray2) {
            return Fields.compareBytes(byArray, byArray2);
        }
    }

    public static final class StringLengthComparator
    implements Comparator {
        public final int compare(Object object, Object object2) {
            return StringLengthComparator.compare((String)object, (String)object2);
        }

        public static final int compare(String string, String string2) {
            return string.length() == string2.length() ? 0 : (string.length() > string2.length() ? 1 : -1);
        }
    }

    public static final class StringComparator
    implements Comparator {
        public final int compare(Object object, Object object2) {
            return StringComparator.compare((String)object, (String)object2);
        }

        public static final int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    }
}

