/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.Key;
import freenet.KeyException;
import freenet.Storables;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.io.DataNotValidIOException;
import freenet.support.io.VerifyingInputStream;
import java.io.InputStream;

public class CHK
extends Key {
    public static int keyNumber = 770;

    public CHK(byte[] byArray) throws KeyException {
        super(byArray);
        if (this.val.length != 23 || (this.val[21] & 0xFF) != (keyNumber >> 8 & 0xFF) || (this.val[22] & 0xFF) != (keyNumber & 0xFF)) {
            throw new KeyException("Byte array does not contain a CHK");
        }
    }

    public CHK(Storables storables, int n) throws KeyException {
        super(20, n, keyNumber);
        if (!storables.isLegalForCHK()) {
            throw new KeyException("illegal Storables");
        }
        Digest digest = SHA1.getInstance();
        storables.hashUpdate(digest);
        System.arraycopy(digest.digest(), 0, this.val, 0, 20);
    }

    public VerifyingInputStream verifyStream(InputStream inputStream, Storables storables, long l) throws DataNotValidIOException {
        if (!storables.isLegalForCHK()) {
            throw new DataNotValidIOException(132);
        }
        byte by = this.val[20];
        long l2 = storables.getPartSize();
        long l3 = CHK.getDataLength(l, l2);
        if (by < 10 || by > 62 || (long)(1 << by) != l3 || l2 != CHK.getPartSize(l3)) {
            throw new DataNotValidIOException(132);
        }
        Digest digest = SHA1.getInstance();
        storables.hashUpdate(digest);
        if (!Util.byteArrayEqual(digest.digest(), this.val, 0, 20)) {
            throw new DataNotValidIOException(132);
        }
        return super.verifyStream(inputStream, storables, l);
    }
}

