/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt.ciphers;

import freenet.crypt.BlockCipher;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Twofish_Algorithm;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Twofish
implements BlockCipher {
    private static Logger logger = Logger.getLogger(Twofish.class.getName());
    private Object sessionKey;
    private int keysize;

    public Twofish(Integer n) throws UnsupportedCipherException {
        this((int)n);
    }

    public Twofish(int n) throws UnsupportedCipherException {
        if (n != 64 && n != 128 && n != 192 && n != 256) {
            throw new UnsupportedCipherException("Invalid keysize");
        }
        this.keysize = n;
    }

    public Twofish() {
        this.keysize = 128;
    }

    public final int getBlockSize() {
        return 128;
    }

    public final int getKeySize() {
        return this.keysize;
    }

    public final void initialize(byte[] byArray) {
        try {
            byte[] byArray2 = new byte[this.keysize >> 3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            this.sessionKey = Twofish_Algorithm.makeKey(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.log(Level.SEVERE, "Exception thrown in initialize(byte[] key)", invalidKeyException);
        }
    }

    public final void encipher(byte[] byArray, byte[] byArray2) {
        Twofish_Algorithm.blockEncrypt(byArray, byArray2, 0, this.sessionKey);
    }

    public final void decipher(byte[] byArray, byte[] byArray2) {
        Twofish_Algorithm.blockDecrypt(byArray, byArray2, 0, this.sessionKey);
    }
}

