/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt.ciphers;

import freenet.crypt.BlockCipher;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael_Algorithm;
import freenet.support.Fields;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Rijndael
implements BlockCipher {
    private static Logger logger = Logger.getLogger(Rijndael.class.getName());
    private Object sessionKey;
    private int keysize;
    private int blocksize;

    public Rijndael(Integer n) throws UnsupportedCipherException {
        this((int)n);
    }

    public Rijndael(int n) throws UnsupportedCipherException {
        this(n, 128);
    }

    public Rijndael(int n, int n2) throws UnsupportedCipherException {
        if (n != 128 && n != 192 && n != 256) {
            throw new UnsupportedCipherException("Invalid keysize");
        }
        if (n2 != 128 && n2 != 192 && n2 != 256) {
            throw new UnsupportedCipherException("Invalid blocksize");
        }
        this.keysize = n;
        this.blocksize = n2;
    }

    public Rijndael() {
        this.keysize = 128;
        this.blocksize = 128;
    }

    public final int getBlockSize() {
        return this.blocksize;
    }

    public final int getKeySize() {
        return this.keysize;
    }

    public final void initialize(byte[] byArray) {
        try {
            byte[] byArray2 = new byte[this.keysize >> 3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            this.sessionKey = Rijndael_Algorithm.makeKey(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.log(Level.SEVERE, "Exception thrown in initialize(byte[] key)", invalidKeyException);
        }
    }

    public final void encipher(byte[] byArray, byte[] byArray2) {
        Rijndael_Algorithm.blockEncrypt(byArray, byArray2, 0, this.sessionKey);
    }

    public final void decipher(byte[] byArray, byte[] byArray2) {
        Rijndael_Algorithm.blockDecrypt(byArray, byArray2, 0, this.sessionKey);
    }

    public static void main(String[] stringArray) throws UnsupportedCipherException {
        System.out.println("KEYSIZE=128\n");
        Rijndael.monteCarlo(128);
        System.out.println("=========================\n");
        System.out.println("KEYSIZE=192\n");
        Rijndael.monteCarlo(192);
        System.out.println("=========================\n");
        System.out.println("KEYSIZE=256\n");
        Rijndael.monteCarlo(256);
    }

    static void monteCarlo(int n) throws UnsupportedCipherException {
        Rijndael rijndael = new Rijndael(n);
        int n2 = n / 8;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[n2];
        for (int i = 0; i < 400; ++i) {
            int n3;
            System.out.println("I=" + i);
            System.out.println("KEY=" + Fields.bytesToHex(byArray4, 0, n2));
            System.out.println("PT=" + Fields.bytesToHex(byArray, 0, 16));
            rijndael.initialize(byArray4);
            for (n3 = 0; n3 < 10000; ++n3) {
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                rijndael.encipher(byArray, byArray2);
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            }
            System.out.println("CT=" + Fields.bytesToHex(byArray2, 0, 16));
            for (n3 = 0; n3 < n2; ++n3) {
                if (n == 192) {
                    if (n3 < 8) {
                        int n4 = n3;
                        byArray4[n4] = (byte)(byArray4[n4] ^ byArray3[8 + n3]);
                        continue;
                    }
                    int n5 = n3;
                    byArray4[n5] = (byte)(byArray4[n5] ^ byArray2[n3 - 8]);
                    continue;
                }
                if (n == 256) {
                    if (n3 < 16) {
                        int n6 = n3;
                        byArray4[n6] = (byte)(byArray4[n6] ^ byArray3[n3]);
                        continue;
                    }
                    int n7 = n3;
                    byArray4[n7] = (byte)(byArray4[n7] ^ byArray2[n3 - 16]);
                    continue;
                }
                int n8 = n3;
                byArray4[n8] = (byte)(byArray4[n8] ^ byArray2[n3]);
            }
            if (n == 192) {
                for (n3 = 0; n3 < 8; ++n3) {
                    int n9 = n3 + 16;
                    byArray4[n9] = (byte)(byArray4[n9] ^ byArray3[n3 + 8]);
                }
            } else if (n == 256) {
                for (n3 = 0; n3 < 16; ++n3) {
                    int n10 = n3 + 16;
                    byArray4[n10] = (byte)(byArray4[n10] ^ byArray3[n3]);
                }
            }
            System.out.println();
        }
    }
}

