/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.Digest;
import freenet.crypt.JavaSHA1;
import freenet.crypt.SHA1;
import freenet.crypt.ciphers.Rijndael;
import freenet.crypt.ciphers.Twofish;
import freenet.support.Bucket;
import freenet.support.Fields;
import freenet.support.Loader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static Logger logger = Logger.getLogger(Util.class.getName());
    protected static final int BUFFER_SIZE = 32768;
    public static final BigInteger ONE;
    public static final BigInteger ZERO;
    public static final BigInteger TWO;
    private static Digest ctx;
    public static byte[] ZERO_ARRAY;

    public static byte[] stringToBytes(String string) throws NumberFormatException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i * 2] = (byte)(cArray[i] >> 8 & 0xFF);
            byArray[i * 2 + 1] = (byte)cArray[i];
        }
        return byArray;
    }

    public static byte[] hexToBytes(String string) throws NumberFormatException {
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (!(c >= 'a' && c <= 'f' || c >= '0' && c <= '9')) {
                throw new NumberFormatException();
            }
            byte by = (byte)(c >= 'a' && c <= 'f' ? c - 97 + 10 : c - 48);
            if (i % 2 == 0) {
                byArray[i / 2] = (byte)(by << 4);
                continue;
            }
            byArray[(i - 1) / 2] = (byte)(byArray[(i - 1) / 2] | by);
        }
        return byArray;
    }

    public static void fillByteArrayFromInts(int[] nArray, byte[] byArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            byArray[n++] = (byte)(nArray[i] >> 24);
            byArray[n++] = (byte)(nArray[i] >> 16);
            byArray[n++] = (byte)(nArray[i] >> 8);
            byArray[n++] = (byte)nArray[i];
        }
    }

    public static void fillByteArrayFromLongs(long[] lArray, byte[] byArray) {
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            byArray[n++] = (byte)(lArray[i] >> 56);
            byArray[n++] = (byte)(lArray[i] >> 48);
            byArray[n++] = (byte)(lArray[i] >> 40);
            byArray[n++] = (byte)(lArray[i] >> 32);
            byArray[n++] = (byte)(lArray[i] >> 24);
            byArray[n++] = (byte)(lArray[i] >> 16);
            byArray[n++] = (byte)(lArray[i] >> 8);
            byArray[n++] = (byte)lArray[i];
        }
    }

    public static void fillIntArrayFromBytes(byte[] byArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length << 2; i += 4) {
            nArray[n++] = byArray[i] + byArray[i + 1] << 8 + byArray[i + 2] << 16 + byArray[i + 3] << 24;
        }
    }

    public static void fillLongArrayFromBytes(byte[] byArray, long[] lArray) {
        int n = 0;
        for (int i = 0; i < lArray.length << 3; i += 8) {
            lArray[n++] = (long)byArray[i] + ((long)byArray[i + 1] << 8) + ((long)byArray[i + 2] << 16) + ((long)byArray[i + 3] << 24) + ((long)byArray[i + 4] << 32) + ((long)byArray[i + 5] << 40) + ((long)byArray[i + 6] << 48) + ((long)byArray[i + 7] << 56);
        }
    }

    public static boolean byteArrayEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        return Util.byteArrayEqual(byArray, byArray2, 0, byArray.length);
    }

    public static boolean byteArrayEqual(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n + n2;
        if (byArray.length < n3 || byArray2.length < n3) {
            return false;
        }
        for (int i = n; i < n3; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] MPIbytes(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        byte[] byArray = new byte[2 + (n + 8 >> 3)];
        System.arraycopy(bigInteger.toByteArray(), 0, byArray, 2, byArray.length - 2);
        byArray[0] = (byte)(n >> 8);
        byArray[1] = (byte)n;
        return byArray;
    }

    public static void writeMPI(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        outputStream.write(Util.MPIbytes(bigInteger));
    }

    public static BigInteger readMPI(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == -1 || n2 == -1) {
            throw new EOFException();
        }
        byte[] byArray = new byte[(n << 8) + n2 + 8 >> 3];
        Util.readFully(inputStream, byArray, 0, byArray.length);
        return new BigInteger(byArray);
    }

    public static BigInteger generateLargeRandom(int n, int n2, Random random) {
        int n3;
        if (n == n2) {
            return new BigInteger(n, random);
        }
        while ((n3 = (random.nextInt() & Integer.MAX_VALUE) % n2) < n) {
        }
        BigInteger bigInteger = new BigInteger(n3, random);
        return bigInteger;
    }

    public static BigInteger byteArrayToMPI(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static byte[] hashBytes(Digest digest, byte[] byArray) {
        return Util.hashBytes(digest, byArray, 0, byArray.length);
    }

    public static byte[] hashBytes(Digest digest, byte[] byArray, int n, int n2) {
        digest.update(byArray, n, n2);
        return digest.digest();
    }

    public static byte[] hashString(Digest digest, String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            digest.update(byArray, 0, byArray.length);
            return digest.digest();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in hashString(Digest d, String s)", exception);
            return null;
        }
    }

    public static byte[] hashFile(Digest digest, File file) throws IOException, FileNotFoundException {
        byte[] byArray = new byte[65536];
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        do {
            if ((n = fileInputStream.read(byArray)) <= 0) continue;
            digest.update(byArray, 0, n);
        } while (n != -1);
        return digest.digest();
    }

    public static byte[] hashStream(Digest digest, InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[65536];
        int n = 0;
        do {
            int n2;
            if ((n = inputStream.read(byArray, 0, n2 = l > 65536L ? 65536 : (int)l)) <= 0) continue;
            digest.update(byArray, 0, n);
        } while (n != -1 && (l -= (long)n) > 0L);
        return digest.digest();
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        int n2 = Math.max(byArray.length, byArray2.length);
        byte[] byArray3 = new byte[n2];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeKey(byte[] byArray, byte[] byArray2, int n, int n2) {
        Digest digest = ctx;
        synchronized (digest) {
            ctx.digest();
            int n3 = 0;
            while (n2 > 0) {
                int n4;
                ++n3;
                for (n4 = 0; n4 < n3; ++n4) {
                    ctx.update((byte)0);
                }
                ctx.update(byArray, 0, byArray.length);
                if (n2 > 20) {
                    ctx.digest(true, byArray2, n);
                    n4 = 20;
                } else {
                    byte[] byArray3 = ctx.digest();
                    n4 = Math.min(n2, byArray3.length);
                    System.arraycopy(byArray3, 0, byArray2, n, n4);
                }
                n += n4;
                n2 -= n4;
            }
        }
        Util.wipe(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeKey(Bucket bucket, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[32768];
        Digest digest = ctx;
        synchronized (digest) {
            ctx.digest();
            int n3 = 0;
            while (n2 > 0) {
                int n4;
                ++n3;
                for (n4 = 0; n4 < n3; ++n4) {
                    ctx.update((byte)0);
                }
                InputStream inputStream = bucket.getInputStream();
                n4 = 0;
                while ((n4 = inputStream.read(byArray2)) > 0) {
                    ctx.update(byArray2, 0, byArray2.length);
                }
                inputStream.close();
                if (n2 > ctx.digestSize() >> 3) {
                    ctx.digest(true, byArray, n);
                    n4 = ctx.digestSize() >> 3;
                } else {
                    byte[] byArray3 = ctx.digest();
                    n4 = Math.min(n2, byArray3.length);
                    System.arraycopy(byArray3, 0, byArray, n, n4);
                }
                n += n4;
                n2 -= n4;
            }
        }
        Util.wipe(byArray2);
    }

    public static BlockCipher getCipherByName(String string) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + string);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in getCipherByName(String name)", exception);
            return null;
        }
    }

    public static BlockCipher getCipherByName(String string, int n) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + string, new Class[]{Integer.class}, new Object[]{new Integer(n)});
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in getCipherByName(String name, int keySize)", exception);
            return null;
        }
    }

    public static Digest getDigestByName(String string) {
        try {
            return (Digest)Loader.getInstance("freenet.crypt." + string);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in getDigestByName(String name)", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0 || stringArray[0].equals("write")) {
            Util.writeMPI(new BigInteger("9"), System.out);
            Util.writeMPI(new BigInteger("1234567890123456789"), System.out);
            Util.writeMPI(new BigInteger("100200300400500600700800900"), System.out);
        } else if (stringArray[0].equals("read")) {
            System.out.println("9");
            System.out.println(Util.readMPI(System.in));
            System.out.println("1234567890123456789");
            System.out.println(Util.readMPI(System.in));
            System.out.println("100200300400500600700800900");
            System.out.println(Util.readMPI(System.in));
        } else if (stringArray[0].equals("write-mpi")) {
            Util.writeMPI(new BigInteger(stringArray[1]), System.out);
        } else if (stringArray[0].equals("read-mpi")) {
            System.err.println(Util.readMPI(System.in));
        } else if (stringArray[0].equals("keygen")) {
            byte[] byArray = Util.readMPI(System.in).toByteArray();
            byte[] byArray2 = new byte[stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 16];
            Util.makeKey(byArray, byArray2, 0, byArray2.length);
            System.err.println(Fields.bytesToHex(byArray2, 0, byArray2.length));
        } else if (stringArray[0].equals("shatest")) {
            Digest digest = ctx;
            synchronized (digest) {
                ctx.digest();
                ctx.update((byte)97);
                ctx.update((byte)98);
                ctx.update((byte)99);
                byte[] byArray = ctx.digest();
                System.err.println(Fields.bytesToHex(byArray, 0, byArray.length));
            }
        }
    }

    public static void wipe(byte[] byArray) {
        System.arraycopy(ZERO_ARRAY, 0, byArray, 0, byArray.length);
    }

    public static int log2(long l) {
        int n;
        for (n = 0; n < 63 && (long)(1 << n) < l; ++n) {
        }
        return n;
    }

    public static void rollingHashPad(OutputStream outputStream, long l, SHA1 sHA1) throws IOException {
        byte[] byArray = new byte[sHA1.digestSize() >> 3];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (l > 0L) {
            sHA1.digest(false, byArray, 0);
            sHA1.update(byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (l < (long)byteArrayOutputStream.size()) {
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                outputStream.write(byArray2, 0, (int)l);
                l = 0L;
                continue;
            }
            byteArrayOutputStream.writeTo(outputStream);
            l -= (long)byteArrayOutputStream.size();
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        Util.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 != -1) continue;
            throw new EOFException();
        }
    }

    static {
        SHA1.class.toString();
        JavaSHA1.class.toString();
        Twofish.class.toString();
        Rijndael.class.toString();
        ONE = BigInteger.valueOf(1L);
        ZERO = BigInteger.valueOf(0L);
        TWO = BigInteger.valueOf(2L);
        ctx = SHA1.getInstance();
        ZERO_ARRAY = new byte[16384];
    }
}

