/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Digest;
import freenet.crypt.JavaSHA1;
import freenet.support.Fields;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public final class SHA1
implements Digest {
    protected static boolean alwaysThisOne = false;
    private int[] state = new int[5];
    private long count = 0L;
    private boolean digestValid = false;
    private byte[] digestBits;
    private boolean NSA = true;
    private int[] block = new int[16];
    private int blockIndex;
    private int[] dd = new int[5];

    public static Digest getInstance(boolean bl) {
        if (alwaysThisOne) {
            bl = true;
        }
        if (bl) {
            return new SHA1();
        }
        try {
            return new JavaSHA1();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            alwaysThisOne = true;
            return new SHA1();
        }
        catch (Exception exception) {
            return new SHA1();
        }
    }

    public static Digest getInstance() {
        return SHA1.getInstance(false);
    }

    public final int digestSize() {
        return 160;
    }

    public final void extract(int[] nArray, int n) {
        for (int i = 0; i < 5; ++i) {
            nArray[i + n] = this.digestBits[4 * i + 0] << 24 & 0xFF000000 | this.digestBits[4 * i + 1] << 16 & 0xFF0000 | this.digestBits[4 * i + 2] << 8 & 0xFF00 | this.digestBits[4 * i + 3] & 0xFF;
        }
    }

    public SHA1(boolean bl) {
        this.NSA = bl;
        this.init();
    }

    public SHA1() {
        this(true);
    }

    private final int rol(int n, int n2) {
        int n3 = n << n2 | n >>> 32 - n2;
        return n3;
    }

    private final int blk0(int n) {
        this.block[n] = this.rol(this.block[n], 24) & 0xFF00FF00 | this.rol(this.block[n], 8) & 0xFF00FF;
        return this.block[n];
    }

    private final int blk(int n) {
        this.block[n & 0xF] = this.block[n + 13 & 0xF] ^ this.block[n + 8 & 0xF] ^ this.block[n + 2 & 0xF] ^ this.block[n & 0xF];
        if (this.NSA) {
            this.block[n & 0xF] = this.rol(this.block[n & 0xF], 1);
        }
        return this.block[n & 0xF];
    }

    private final void R0(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.blk0(n6) + 1518500249 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R1(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.blk(n6) + 1518500249 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R2(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.blk(n6) + 1859775393 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R3(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + (((nArray[n2] | nArray[n3]) & nArray[n4] | nArray[n2] & nArray[n3]) + this.blk(n6) + -1894007588 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R4(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.blk(n6) + -899497514 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void transform() {
        this.dd[0] = this.state[0];
        this.dd[1] = this.state[1];
        this.dd[2] = this.state[2];
        this.dd[3] = this.state[3];
        this.dd[4] = this.state[4];
        this.R0(this.dd, 0, 1, 2, 3, 4, 0);
        this.R0(this.dd, 4, 0, 1, 2, 3, 1);
        this.R0(this.dd, 3, 4, 0, 1, 2, 2);
        this.R0(this.dd, 2, 3, 4, 0, 1, 3);
        this.R0(this.dd, 1, 2, 3, 4, 0, 4);
        this.R0(this.dd, 0, 1, 2, 3, 4, 5);
        this.R0(this.dd, 4, 0, 1, 2, 3, 6);
        this.R0(this.dd, 3, 4, 0, 1, 2, 7);
        this.R0(this.dd, 2, 3, 4, 0, 1, 8);
        this.R0(this.dd, 1, 2, 3, 4, 0, 9);
        this.R0(this.dd, 0, 1, 2, 3, 4, 10);
        this.R0(this.dd, 4, 0, 1, 2, 3, 11);
        this.R0(this.dd, 3, 4, 0, 1, 2, 12);
        this.R0(this.dd, 2, 3, 4, 0, 1, 13);
        this.R0(this.dd, 1, 2, 3, 4, 0, 14);
        this.R0(this.dd, 0, 1, 2, 3, 4, 15);
        this.R1(this.dd, 4, 0, 1, 2, 3, 16);
        this.R1(this.dd, 3, 4, 0, 1, 2, 17);
        this.R1(this.dd, 2, 3, 4, 0, 1, 18);
        this.R1(this.dd, 1, 2, 3, 4, 0, 19);
        this.R2(this.dd, 0, 1, 2, 3, 4, 20);
        this.R2(this.dd, 4, 0, 1, 2, 3, 21);
        this.R2(this.dd, 3, 4, 0, 1, 2, 22);
        this.R2(this.dd, 2, 3, 4, 0, 1, 23);
        this.R2(this.dd, 1, 2, 3, 4, 0, 24);
        this.R2(this.dd, 0, 1, 2, 3, 4, 25);
        this.R2(this.dd, 4, 0, 1, 2, 3, 26);
        this.R2(this.dd, 3, 4, 0, 1, 2, 27);
        this.R2(this.dd, 2, 3, 4, 0, 1, 28);
        this.R2(this.dd, 1, 2, 3, 4, 0, 29);
        this.R2(this.dd, 0, 1, 2, 3, 4, 30);
        this.R2(this.dd, 4, 0, 1, 2, 3, 31);
        this.R2(this.dd, 3, 4, 0, 1, 2, 32);
        this.R2(this.dd, 2, 3, 4, 0, 1, 33);
        this.R2(this.dd, 1, 2, 3, 4, 0, 34);
        this.R2(this.dd, 0, 1, 2, 3, 4, 35);
        this.R2(this.dd, 4, 0, 1, 2, 3, 36);
        this.R2(this.dd, 3, 4, 0, 1, 2, 37);
        this.R2(this.dd, 2, 3, 4, 0, 1, 38);
        this.R2(this.dd, 1, 2, 3, 4, 0, 39);
        this.R3(this.dd, 0, 1, 2, 3, 4, 40);
        this.R3(this.dd, 4, 0, 1, 2, 3, 41);
        this.R3(this.dd, 3, 4, 0, 1, 2, 42);
        this.R3(this.dd, 2, 3, 4, 0, 1, 43);
        this.R3(this.dd, 1, 2, 3, 4, 0, 44);
        this.R3(this.dd, 0, 1, 2, 3, 4, 45);
        this.R3(this.dd, 4, 0, 1, 2, 3, 46);
        this.R3(this.dd, 3, 4, 0, 1, 2, 47);
        this.R3(this.dd, 2, 3, 4, 0, 1, 48);
        this.R3(this.dd, 1, 2, 3, 4, 0, 49);
        this.R3(this.dd, 0, 1, 2, 3, 4, 50);
        this.R3(this.dd, 4, 0, 1, 2, 3, 51);
        this.R3(this.dd, 3, 4, 0, 1, 2, 52);
        this.R3(this.dd, 2, 3, 4, 0, 1, 53);
        this.R3(this.dd, 1, 2, 3, 4, 0, 54);
        this.R3(this.dd, 0, 1, 2, 3, 4, 55);
        this.R3(this.dd, 4, 0, 1, 2, 3, 56);
        this.R3(this.dd, 3, 4, 0, 1, 2, 57);
        this.R3(this.dd, 2, 3, 4, 0, 1, 58);
        this.R3(this.dd, 1, 2, 3, 4, 0, 59);
        this.R4(this.dd, 0, 1, 2, 3, 4, 60);
        this.R4(this.dd, 4, 0, 1, 2, 3, 61);
        this.R4(this.dd, 3, 4, 0, 1, 2, 62);
        this.R4(this.dd, 2, 3, 4, 0, 1, 63);
        this.R4(this.dd, 1, 2, 3, 4, 0, 64);
        this.R4(this.dd, 0, 1, 2, 3, 4, 65);
        this.R4(this.dd, 4, 0, 1, 2, 3, 66);
        this.R4(this.dd, 3, 4, 0, 1, 2, 67);
        this.R4(this.dd, 2, 3, 4, 0, 1, 68);
        this.R4(this.dd, 1, 2, 3, 4, 0, 69);
        this.R4(this.dd, 0, 1, 2, 3, 4, 70);
        this.R4(this.dd, 4, 0, 1, 2, 3, 71);
        this.R4(this.dd, 3, 4, 0, 1, 2, 72);
        this.R4(this.dd, 2, 3, 4, 0, 1, 73);
        this.R4(this.dd, 1, 2, 3, 4, 0, 74);
        this.R4(this.dd, 0, 1, 2, 3, 4, 75);
        this.R4(this.dd, 4, 0, 1, 2, 3, 76);
        this.R4(this.dd, 3, 4, 0, 1, 2, 77);
        this.R4(this.dd, 2, 3, 4, 0, 1, 78);
        this.R4(this.dd, 1, 2, 3, 4, 0, 79);
        this.state[0] = this.state[0] + this.dd[0];
        this.state[1] = this.state[1] + this.dd[1];
        this.state[2] = this.state[2] + this.dd[2];
        this.state[3] = this.state[3] + this.dd[3];
        this.state[4] = this.state[4] + this.dd[4];
    }

    public final void frob() {
        this.count = 0L;
        this.state[4] = 0;
        this.state[3] = 0;
        this.state[2] = 0;
        this.state[1] = 0;
        this.state[0] = 0;
    }

    protected final void init() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        this.count = 0L;
        this.digestBits = new byte[20];
        this.digestValid = false;
        this.blockIndex = 0;
    }

    public final void update(byte by) {
        int n = (this.blockIndex & 3) << 3;
        this.count += 8L;
        int n2 = this.blockIndex >> 2;
        this.block[n2] = this.block[n2] & ~(255 << n);
        int n3 = this.blockIndex >> 2;
        this.block[n3] = this.block[n3] | (by & 0xFF) << n;
        ++this.blockIndex;
        if (this.blockIndex == 64) {
            this.transform();
            this.blockIndex = 0;
        }
    }

    public final void update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.update(byArray[n + i]);
        }
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final void digest(boolean bl, byte[] byArray, int n) {
        this.finish();
        System.arraycopy(this.digestBits, 0, byArray, n, this.digestBits.length);
        if (bl) {
            this.init();
        }
    }

    public final byte[] digest(boolean bl) {
        byte[] byArray = new byte[20];
        this.digest(bl, byArray, 0);
        return byArray;
    }

    public final byte[] digest() {
        return this.digest(true);
    }

    protected final void finish() {
        int n;
        byte[] byArray = new byte[8];
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(this.count >>> (7 - n << 3) & 0xFFL);
        }
        this.update((byte)-128);
        while (this.blockIndex != 56) {
            this.update((byte)0);
        }
        for (n = 0; n < 8; ++n) {
            this.update(byArray[n]);
        }
        for (n = 0; n < 20; ++n) {
            this.digestBits[n] = (byte)(this.state[n >> 2] >>> (3 - (n & 3) << 3) & 0xFF);
        }
        this.digestValid = true;
    }

    protected String digout() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            char c = (char)(this.digestBits[i] >>> 4 & 0xF);
            char c2 = (char)(this.digestBits[i] & 0xF);
            c = (char)(c > '\t' ? 65 + (c - 10) : 48 + c);
            c2 = (char)(c2 > '\t' ? 65 + (c2 - 10) : 48 + c2);
            stringBuffer.append(c);
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        SHA1.SHAselfTest();
        SHA1.SHAbenchTest();
    }

    public static void SHAbenchTest() {
        Digest digest;
        try {
            digest = new JavaSHA1();
            SHA1.genericBenchTest(digest);
            try {
                JavaSHA1 javaSHA1 = (JavaSHA1)digest.clone();
                System.err.println("Cloned successfully");
                SHA1.genericBenchTest(javaSHA1);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.err.println("Couldn't clone");
            }
        }
        catch (Exception exception) {
            System.err.println("Couldn't run benchmark for JavaSHA1");
        }
        digest = new SHA1(true);
        SHA1.genericBenchTest(digest);
    }

    public static void genericBenchTest(Digest digest) {
        System.out.println("\nBegin benchmark");
        long l = 4096L;
        long l2 = 100000L;
        byte[] byArray = SHA1.createDummyData((int)l);
        long l3 = System.currentTimeMillis();
        int n = 0;
        while ((long)n < l2) {
            digest.update(byArray);
            ++n;
        }
        long l4 = System.currentTimeMillis();
        byte[] byArray2 = digest.digest();
        long l5 = System.currentTimeMillis();
        long l6 = l4 - l3;
        long l7 = 0L;
        long l8 = 0L;
        if (l6 > 0L) {
            l7 = l * l2 * 1000L / l6;
            l8 = l2 / l6;
        }
        System.out.println("SHA update " + l2 + " times for the same data block of size " + l + " bytes:");
        System.out.println(l6 + "ms [" + l7 + "bytes/second, " + l8 + "updates/ms]\n");
        l2 = 1000L;
        byte[][] byArrayArray = new byte[(int)l2][];
        int n2 = 0;
        while ((long)n2 < l2) {
            byArrayArray[n2] = SHA1.createDummyData((int)l);
            ++n2;
        }
        long l9 = System.currentTimeMillis();
        int n3 = 0;
        while ((long)n3 < l2) {
            digest.update(byArrayArray[n3]);
            ++n3;
        }
        long l10 = System.currentTimeMillis();
        byArray2 = digest.digest();
        l5 = System.currentTimeMillis();
        l6 = l10 - l9;
        l7 = 0L;
        l8 = 0L;
        if (l6 > 0L) {
            l7 = l * l2 * 1000L / l6;
            l8 = l2 / l6;
        }
        System.out.println("SHA update " + l2 + " times for different data blocks of size " + l + " bytes:");
        System.out.println(l6 + "ms [" + l7 + "bytes/second, " + l8 + "ms/update]");
        System.out.println("\nEnd benchmark");
    }

    private static byte[] createDummyData(int n) {
        Random random = new Random();
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        return byArray;
    }

    public static void SHAselfTest() {
        Digest digest;
        System.err.println("Testing JavaSHA1:");
        try {
            digest = new JavaSHA1();
            SHA1.SHAselfTest(digest);
        }
        catch (Exception exception) {
            System.err.println("Caught exception " + exception + " trying to test JavaSHA1");
        }
        System.err.println("Testing SHA1:");
        digest = new SHA1(true);
        SHA1.SHAselfTest(digest);
    }

    public static void SHAselfTest(Digest digest) {
        int n;
        System.out.println("SHA-1 Test PROGRAM.");
        System.out.println("This code runs the test vectors through the code.");
        System.out.println("First test is 'abc'");
        String string = "abc";
        digest.update((byte)97);
        digest.update((byte)98);
        digest.update((byte)99);
        System.out.println(Fields.bytesToHex(digest.digest()).toUpperCase());
        System.out.println("A9993E364706816ABA3E25717850C26C9CD0D89D");
        System.out.println("Next Test is 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'");
        string = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
        for (n = 0; n < string.length(); ++n) {
            digest.update((byte)string.charAt(n));
        }
        System.out.println(Fields.bytesToHex(digest.digest()).toUpperCase());
        System.out.println("84983E441C3BD26EBAAE4AA1F95129E5E54670F1");
        long l = 0L - System.currentTimeMillis();
        System.out.println("Last test is 1 million 'a' characters.");
        for (n = 0; n < 1000000; ++n) {
            digest.update((byte)97);
        }
        System.out.println(Fields.bytesToHex(digest.digest()).toUpperCase());
        System.out.println("34AA973CD4C4DAA4F61EEB2BDBAD27316534016F");
        double d = (double)(l += System.currentTimeMillis()) / 1000.0;
        System.out.println(" done, elapsed time = " + d);
    }
}

