/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.EntropySource;
import freenet.crypt.RandomSource;
import freenet.crypt.Yarrow;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RandStream
extends RandomSource {
    private RandomSource fallBack;
    protected DataInputStream stream;
    static final int[][] bitTable = new int[][]{{0, 0}, {1, 1}, {1, 3}, {1, 7}, {1, 15}, {1, 31}, {1, 63}, {1, 127}, {1, 255}, {2, 511}, {2, 1023}, {2, 2047}, {2, 4095}, {2, 8191}, {2, 16383}, {2, Short.MAX_VALUE}, {2, 65535}, {3, 131071}, {3, 262143}, {3, 524287}, {3, 1048575}, {3, 0x1FFFFF}, {3, 0x3FFFFF}, {3, 0x7FFFFF}, {3, 0xFFFFFF}, {4, 0x1FFFFFF}, {4, 0x3FFFFFF}, {4, 0x7FFFFFF}, {4, 0xFFFFFFF}, {4, 0x1FFFFFFF}, {4, 0x3FFFFFFF}, {4, Integer.MAX_VALUE}, {4, -1}};

    public RandStream() {
    }

    public RandStream(InputStream inputStream) {
        this(inputStream, new Yarrow());
    }

    public RandStream(InputStream inputStream, RandomSource randomSource) {
        this.stream = new DataInputStream(inputStream);
        this.fallBack = randomSource;
    }

    protected int next(int n) {
        int[] nArray = bitTable[n];
        byte[] byArray = new byte[nArray[0]];
        try {
            this.stream.readFully(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n2 = byArray[0];
        if (nArray[0] == 4) {
            n2 += (byArray[1] << 24) + (byArray[2] << 16) + (byArray[3] << 8);
        } else if (nArray[0] == 3) {
            n2 += (byArray[1] << 16) + (byArray[2] << 8);
        } else if (nArray[0] == 2) {
            n2 += byArray[2] << 8;
        }
        return n2 & nArray[1];
    }

    public void nextBytes(byte[] byArray) {
        try {
            this.stream.readFully(byArray);
        }
        catch (Exception exception) {
            this.fallBack.nextBytes(byArray);
        }
    }

    public int nextInt() {
        try {
            return this.stream.readInt();
        }
        catch (Exception exception) {
            return this.fallBack.nextInt();
        }
    }

    public long nextLong() {
        try {
            return this.stream.readLong();
        }
        catch (Exception exception) {
            return this.fallBack.nextLong();
        }
    }

    public float nextFloat() {
        try {
            return this.stream.readFloat();
        }
        catch (Exception exception) {
            return this.fallBack.nextFloat();
        }
    }

    public double nextDouble() {
        try {
            return this.stream.readDouble();
        }
        catch (Exception exception) {
            return this.fallBack.nextDouble();
        }
    }

    public int acceptEntropy(EntropySource entropySource, long l, int n) {
        return n;
    }

    public int acceptTimerEntropy(EntropySource entropySource) {
        return 32;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

