/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Digest;
import freenet.crypt.DigestFactory;
import freenet.support.Bucket;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public class ProgressiveHashOutputStream
extends OutputStream {
    private Bucket b;
    private OutputStream out;
    private boolean closed = false;
    private DigestFactory df;
    private Digest ctx;
    private Stack digests;
    private int digSize;
    private long partSize;
    private long written = 0L;
    private long totalLength = -1L;
    private byte[] initialDigest;
    private Stack dvals;

    public ProgressiveHashOutputStream(long l, DigestFactory digestFactory, Bucket bucket) throws IOException {
        if (l <= 0L) {
            throw new IllegalArgumentException("partSize must be > 0");
        }
        bucket.resetWrite();
        this.b = bucket;
        this.out = new BufferedOutputStream(bucket.getOutputStream());
        this.df = digestFactory;
        this.ctx = digestFactory.getInstance();
        this.partSize = l;
        this.digests = new Stack();
        this.digSize = this.ctx.digestSize() >> 3;
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (this.written == this.partSize) {
            this.nextDigest();
        }
        this.out.write(n);
        this.ctx.update((byte)n);
        ++this.written;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        while (n2 > 0) {
            int n3 = (int)Math.min((long)n2, this.partSize - this.written);
            if (n3 == 0) {
                this.nextDigest();
                continue;
            }
            this.out.write(byArray, n, n3);
            this.ctx.update(byArray, n, n3);
            this.written += (long)n3;
            n += n3;
            n2 -= n3;
        }
    }

    private void nextDigest() {
        this.digests.push(this.ctx);
        this.ctx = this.df.getInstance();
        this.written = 0L;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.out.close();
        this.closed = true;
        this.dvals = new Stack();
        while (!this.digests.empty()) {
            byte[] byArray = this.ctx.digest();
            this.ctx = (Digest)this.digests.pop();
            this.ctx.update(byArray);
            this.dvals.push(byArray);
        }
        this.initialDigest = this.ctx.digest();
        int n = (int)((this.b.size() - 1L) / this.partSize);
        long l = this.b.size() - (long)n * this.partSize;
        this.totalLength = (long)n * (this.partSize + 21L) + l + 1L;
    }

    public byte[] getInitialDigest() {
        return this.initialDigest;
    }

    public long getLength() {
        return this.totalLength;
    }

    public InputStream getInputStream() throws IOException {
        return this.closed ? new InterleaveInputStream(this.b.getInputStream(), this.b.size()) : null;
    }

    protected class InterleaveInputStream
    extends FilterInputStream {
        private byte[] digestBuf;
        private long pos;
        private long length;

        public InterleaveInputStream(InputStream inputStream, long l) throws IOException {
            super(inputStream);
            this.length = l;
            this.pos = 0L;
            this.digestBuf = new byte[ProgressiveHashOutputStream.this.digSize + 1];
            this.digestBuf[((ProgressiveHashOutputStream)ProgressiveHashOutputStream.this).digSize] = 0;
        }

        public int read() throws IOException {
            if (this.pos > 0L && (this.pos == ProgressiveHashOutputStream.this.partSize || this.length == 0L)) {
                this.next();
            }
            if (this.pos < 0L) {
                return this.digestBuf[this.digestBuf.length + (int)this.pos++] & 0xFF;
            }
            if (this.length == 0L) {
                return -1;
            }
            int n = this.in.read();
            if (n != -1) {
                ++this.pos;
                --this.length;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 <= 0) {
                return 0;
            }
            if (this.pos > 0L && (this.pos == ProgressiveHashOutputStream.this.partSize || this.length == 0L)) {
                this.next();
            }
            if (this.pos < 0L) {
                int n3 = Math.min(n2, 0 - (int)this.pos);
                System.arraycopy(this.digestBuf, this.digestBuf.length + (int)this.pos, byArray, n, n3);
                this.pos += (long)n3;
                return n3;
            }
            if (this.length == 0L) {
                return -1;
            }
            n2 = (int)Math.min((long)n2, Math.min(ProgressiveHashOutputStream.this.partSize - this.pos, this.length));
            int n4 = this.in.read(byArray, n, n2);
            this.pos += (long)n4;
            this.length -= (long)n4;
            return n4;
        }

        private void next() {
            if (!ProgressiveHashOutputStream.this.dvals.empty()) {
                System.arraycopy((byte[])ProgressiveHashOutputStream.this.dvals.pop(), 0, this.digestBuf, 0, ProgressiveHashOutputStream.this.digSize);
                this.pos = -1 - ProgressiveHashOutputStream.this.digSize;
            } else {
                this.pos = -1L;
            }
        }

        public int available() throws IOException {
            return this.pos < 0L ? 0 - (int)this.pos : (int)Math.min((long)super.available(), ProgressiveHashOutputStream.this.partSize - this.pos);
        }
    }
}

