/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Digest;
import freenet.crypt.ProgressiveHashOutputStream;
import freenet.crypt.SHA1;
import freenet.crypt.SHA1Factory;
import freenet.crypt.Util;
import freenet.support.Bucket;
import freenet.support.FileBucket;
import freenet.support.io.DataNotValidIOException;
import freenet.support.io.VerifyingInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressiveHashInputStream
extends VerifyingInputStream {
    private long partSize;
    private long pos = 0L;
    private Digest ctx;
    private int ds;
    private byte[] expectedHash;
    private byte[] controlBuf;
    private DataNotValidIOException dnv;

    public static void main(String[] stringArray) throws Exception {
        int n;
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = Long.parseLong(stringArray[1]);
        ProgressiveHashOutputStream progressiveHashOutputStream = new ProgressiveHashOutputStream(l, new SHA1Factory(), (Bucket)new FileBucket());
        byte[] byArray = new byte[4096];
        for (long i = file.length(); i > 0L; i -= (long)n) {
            n = fileInputStream.read(byArray, 0, (int)Math.min(i, (long)byArray.length));
            if (n == -1) {
                throw new EOFException("EOF while reading input file");
            }
            progressiveHashOutputStream.write(byArray, 0, n);
        }
        progressiveHashOutputStream.close();
        byte[] byArray2 = progressiveHashOutputStream.getInitialDigest();
        for (int i = 0; i < byArray2.length; ++i) {
            System.err.print((byArray2[i] & 0xFF) + " ");
        }
        long l2 = progressiveHashOutputStream.getLength();
        System.err.println();
        System.err.println("TotalLength = " + l2);
        InputStream inputStream = progressiveHashOutputStream.getInputStream();
        ProgressiveHashInputStream progressiveHashInputStream = new ProgressiveHashInputStream(inputStream, l, l2, SHA1.getInstance(), byArray2);
        progressiveHashInputStream.stripControls(stringArray.length < 3 || Integer.parseInt(stringArray[2]) == 0);
        int n2 = progressiveHashInputStream.read(byArray);
        while (n2 > 0) {
            System.out.write(byArray, 0, n2);
            n2 = progressiveHashInputStream.read(byArray);
        }
    }

    public ProgressiveHashInputStream(InputStream inputStream, long l, long l2, Digest digest, byte[] byArray) throws DataNotValidIOException {
        super(inputStream, l2);
        this.ds = digest.digestSize() >> 3;
        int n = (int)(l2 / (l + (long)this.ds + 1L));
        long l3 = l2 - (long)n * (l + (long)this.ds + 1L);
        if (l2 < 2L || l3 < 2L || l <= 0L || l > l2 - 1L || l3 > l + 1L) {
            throw new DataNotValidIOException(132);
        }
        this.partSize = l;
        this.ctx = digest;
        this.expectedHash = new byte[this.ds];
        this.controlBuf = new byte[this.ds + 1];
        System.arraycopy(byArray, 0, this.expectedHash, 0, this.ds);
    }

    public int read() throws DataNotValidIOException, IOException {
        if (this.dnv != null) {
            throw this.dnv;
        }
        if (this.pos < 0L) {
            return this.controlBuf[this.controlBuf.length + (int)this.pos] & 0xFF;
        }
        int n = super.read();
        if (n == -1) {
            return -1;
        }
        this.ctx.update((byte)n);
        ++this.pos;
        if (this.pos == this.partSize || this.allRead) {
            this.readControlBytes();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws DataNotValidIOException, IOException {
        if (this.dnv != null) {
            throw this.dnv;
        }
        if (n2 <= 0) {
            return 0;
        }
        if (this.pos < 0L) {
            int n3 = Math.min(n2, 0 - (int)this.pos);
            System.arraycopy(this.controlBuf, this.controlBuf.length + (int)this.pos, byArray, n, n3);
            this.pos += (long)n3;
            return n3;
        }
        int n4 = super.read(byArray, n, n2 = (int)Math.min((long)n2, this.partSize - this.pos));
        if (n4 == -1) {
            return -1;
        }
        this.ctx.update(byArray, n, n4);
        this.pos += (long)n4;
        if (this.pos == this.partSize || this.allRead) {
            this.readControlBytes();
        }
        return n4;
    }

    private void readControlBytes() throws DataNotValidIOException, IOException {
        int n;
        this.pos = this.stripControls ? 0 : 0 - n;
        int n2 = 0;
        for (n = this.allRead ? 1 : this.ds + 1; n > 0; --n) {
            n2 = super.read();
            if (n2 == -1) {
                throw new EOFException("EOF while reading control bytes");
            }
            this.controlBuf[this.controlBuf.length - n] = (byte)n2;
            if (n == 1) continue;
            this.ctx.update((byte)n2);
        }
        if (n2 != 0 || !Util.byteArrayEqual(this.ctx.digest(), this.expectedHash)) {
            this.dnv = new DataNotValidIOException(n2 == 0 ? 129 : n2);
            throw this.dnv;
        }
        System.arraycopy(this.controlBuf, 0, this.expectedHash, 0, this.ds);
    }

    public void finish() throws DataNotValidIOException, IOException {
        this.finished = true;
    }
}

