/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.RandomSource;
import freenet.crypt.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PCFBMode {
    private BlockCipher c;
    private byte[] feedback_register;
    private int registerPointer;

    public PCFBMode(BlockCipher blockCipher) {
        this.c = blockCipher;
        this.feedback_register = new byte[blockCipher.getBlockSize() >> 3];
        this.registerPointer = this.feedback_register.length;
    }

    public PCFBMode(BlockCipher blockCipher, byte[] byArray) {
        this(blockCipher);
        System.arraycopy(byArray, 0, this.feedback_register, 0, this.feedback_register.length);
    }

    public final void reset(byte[] byArray) {
        System.arraycopy(byArray, 0, this.feedback_register, 0, this.feedback_register.length);
        this.registerPointer = this.feedback_register.length;
    }

    public void writeIV(RandomSource randomSource, OutputStream outputStream) throws IOException {
        randomSource.nextBytes(this.feedback_register);
        outputStream.write(this.feedback_register);
    }

    public void readIV(InputStream inputStream) throws IOException {
        Util.readFully(inputStream, this.feedback_register);
    }

    public int lengthIV() {
        return this.feedback_register.length;
    }

    public int decipher(int n) {
        if (this.registerPointer == this.feedback_register.length) {
            this.refillBuffer();
        }
        int n2 = (this.feedback_register[this.registerPointer] ^ (byte)n) & 0xFF;
        this.feedback_register[this.registerPointer++] = (byte)n;
        return n2;
    }

    public byte[] blockDecipher(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            if (this.registerPointer == this.feedback_register.length) {
                this.refillBuffer();
            }
            int n3 = Math.min(n2, this.feedback_register.length - this.registerPointer);
            int n4 = n;
            while (n4 < n + n3) {
                byte by = byArray[n4];
                int n5 = n4++;
                byArray[n5] = (byte)(byArray[n5] ^ this.feedback_register[this.registerPointer]);
                this.feedback_register[this.registerPointer++] = by;
            }
            n += n3;
            n2 -= n3;
        }
        return byArray;
    }

    public int encipher(int n) {
        if (this.registerPointer == this.feedback_register.length) {
            this.refillBuffer();
        }
        int n2 = this.registerPointer;
        this.feedback_register[n2] = (byte)(this.feedback_register[n2] ^ (byte)n);
        return this.feedback_register[this.registerPointer++] & 0xFF;
    }

    public byte[] blockEncipher(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            if (this.registerPointer == this.feedback_register.length) {
                this.refillBuffer();
            }
            int n3 = Math.min(n2, this.feedback_register.length - this.registerPointer);
            for (int i = n; i < n + n3; ++i) {
                int n4 = this.registerPointer++;
                byte by = (byte)(this.feedback_register[n4] ^ byArray[i]);
                this.feedback_register[n4] = by;
                byArray[i] = by;
            }
            n += n3;
            n2 -= n3;
        }
        return byArray;
    }

    private void refillBuffer() {
        this.c.encipher(this.feedback_register, this.feedback_register);
        this.registerPointer = 0;
    }
}

