/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoElement;
import freenet.crypt.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class DSASignature
implements CryptoElement,
Serializable {
    private final BigInteger r;
    private final BigInteger s;

    public DSASignature(InputStream inputStream) throws IOException {
        this.r = Util.readMPI(inputStream);
        this.s = Util.readMPI(inputStream);
    }

    public DSASignature(String string) throws NumberFormatException {
        int n = string.indexOf(44);
        if (n <= 0) {
            throw new NumberFormatException("DSA Signatures have two values");
        }
        this.r = new BigInteger(string.substring(0, n), 16);
        this.s = new BigInteger(string.substring(n + 1), 16);
    }

    public static DSASignature read(InputStream inputStream) throws IOException {
        BigInteger bigInteger = Util.readMPI(inputStream);
        BigInteger bigInteger2 = Util.readMPI(inputStream);
        return new DSASignature(bigInteger, bigInteger2);
    }

    public void write(OutputStream outputStream) throws IOException {
        Util.writeMPI(this.r, outputStream);
        Util.writeMPI(this.s, outputStream);
    }

    public String writeAsField() {
        return this.toString();
    }

    public DSASignature(BigInteger bigInteger, BigInteger bigInteger2) {
        this.r = bigInteger;
        this.s = bigInteger2;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public String toString() {
        return this.r.toString(16) + "," + this.s.toString(16);
    }
}

