/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.Util;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAPublicKey
extends CryptoKey {
    protected final BigInteger y;
    protected final DSAGroup group;

    public DSAPublicKey(DSAGroup dSAGroup, BigInteger bigInteger) {
        this.y = bigInteger;
        this.group = dSAGroup;
    }

    public DSAPublicKey(DSAGroup dSAGroup, DSAPrivateKey dSAPrivateKey) {
        this(dSAGroup, dSAGroup.getG().modPow(dSAPrivateKey.getX(), dSAGroup.getP()));
    }

    public BigInteger getY() {
        return this.y;
    }

    public BigInteger getP() {
        return this.group.getP();
    }

    public BigInteger getQ() {
        return this.group.getQ();
    }

    public BigInteger getG() {
        return this.group.getG();
    }

    public String keyType() {
        return "DSA.p";
    }

    public DSAGroup getGroup() {
        return this.group;
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = this.writeWithoutGroup(outputStream);
        this.group.write(outputStream);
    }

    public void writeForWireWithoutGroup(OutputStream outputStream) throws IOException {
        Util.writeMPI(this.y, outputStream);
    }

    public void writeForWire(OutputStream outputStream) throws IOException {
        Util.writeMPI(this.y, outputStream);
        this.group.writeForWire(outputStream);
    }

    public DataOutputStream writeWithoutGroup(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = this.write(outputStream, this.getClass().getName());
        Util.writeMPI(this.y, dataOutputStream);
        return dataOutputStream;
    }

    public static CryptoKey read(InputStream inputStream) throws IOException {
        BigInteger bigInteger = Util.readMPI(inputStream);
        DSAGroup dSAGroup = (DSAGroup)CryptoKey.read(inputStream);
        return new DSAPublicKey(dSAGroup, bigInteger);
    }

    public int keyId() {
        return this.y.intValue();
    }

    public String writeAsField() {
        return this.y.toString(16);
    }

    public byte[] asBytes() {
        byte[] byArray = this.group.asBytes();
        byte[] byArray2 = Util.MPIbytes(this.y);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.y});
    }

    public boolean equals(DSAPublicKey dSAPublicKey) {
        return this.y.equals(dSAPublicKey.y) && this.group.equals(dSAPublicKey.group);
    }

    public boolean equals(Object object) {
        return object instanceof DSAPublicKey && this.y.equals(((DSAPublicKey)object).y) && this.group.equals(((DSAPublicKey)object).group);
    }

    public int compareTo(Object object) {
        if (object instanceof DSAPublicKey) {
            return this.getY().compareTo(((DSAPublicKey)object).getY());
        }
        return -1;
    }
}

