/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.crypt.Util;
import freenet.crypt.Yarrow;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;

public class DSAPrivateKey
extends CryptoKey {
    private final BigInteger x;

    public DSAPrivateKey(BigInteger bigInteger) {
        this.x = bigInteger;
    }

    public DSAPrivateKey(DSAGroup dSAGroup, Random random) {
        BigInteger bigInteger;
        while ((bigInteger = new BigInteger(160, random)).compareTo(dSAGroup.getQ()) > -1) {
        }
        this.x = bigInteger;
    }

    public String keyType() {
        return "DSA.s";
    }

    public BigInteger getX() {
        return this.x;
    }

    public static CryptoKey read(InputStream inputStream) throws IOException {
        return new DSAPrivateKey(Util.readMPI(inputStream));
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = this.write(outputStream, this.getClass().getName());
        Util.writeMPI(this.x, outputStream);
    }

    public String writeAsField() {
        return this.x.toString(16);
    }

    public byte[] asBytes() {
        return Util.MPIbytes(this.x);
    }

    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.x});
    }

    public static void main(String[] stringArray) throws Exception {
        Yarrow yarrow = new Yarrow();
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(Global.DSAgroupC, yarrow);
        DSAPublicKey dSAPublicKey = new DSAPublicKey(Global.DSAgroupC, dSAPrivateKey);
        dSAPrivateKey.write(System.out);
    }
}

