/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.Global;
import freenet.crypt.Util;
import freenet.crypt.Yarrow;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class DSAGroup
extends CryptoKey {
    private static Logger logger = Logger.getLogger(DSAGroup.class.getName());
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private String pAsHexString;
    private String gAsHexString;
    private String qAsHexString;
    static BigInteger[] smallPrimes = new BigInteger[]{BigInteger.valueOf(3L), BigInteger.valueOf(5L), BigInteger.valueOf(7L), BigInteger.valueOf(11L), BigInteger.valueOf(13L), BigInteger.valueOf(17L), BigInteger.valueOf(19L), BigInteger.valueOf(23L), BigInteger.valueOf(29L)};
    static boolean multithread = true;

    public DSAGroup(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = bigInteger;
        this.q = bigInteger2;
        this.g = bigInteger3;
        this.updateCachedHexStrings();
    }

    private void updateCachedHexStrings() {
        this.pAsHexString = this.p.toString(16);
        this.qAsHexString = this.q.toString(16);
        this.gAsHexString = this.g.toString(16);
    }

    public static CryptoKey read(InputStream inputStream) throws IOException {
        BigInteger bigInteger = Util.readMPI(inputStream);
        BigInteger bigInteger2 = Util.readMPI(inputStream);
        BigInteger bigInteger3 = Util.readMPI(inputStream);
        return new DSAGroup(bigInteger, bigInteger2, bigInteger3);
    }

    public void writeForWire(OutputStream outputStream) throws IOException {
        Util.writeMPI(this.p, outputStream);
        Util.writeMPI(this.q, outputStream);
        Util.writeMPI(this.g, outputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = this.write(outputStream, this.getClass().getName());
        this.writeForWire(outputStream);
    }

    public String writeAsField() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pAsHexString).append(',');
        stringBuffer.append(this.qAsHexString).append(',');
        stringBuffer.append(this.gAsHexString);
        return stringBuffer.toString();
    }

    public static DSAGroup readFromField(String string) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 3) {
            throw new NumberFormatException();
        }
        BigInteger bigInteger3 = new BigInteger(stringTokenizer.nextToken(), 16);
        DSAGroup dSAGroup = new DSAGroup(bigInteger3, bigInteger2 = new BigInteger(stringTokenizer.nextToken(), 16), bigInteger = new BigInteger(stringTokenizer.nextToken(), 16));
        return dSAGroup.equals(Global.DSAgroupA) ? Global.DSAgroupA : (dSAGroup.equals(Global.DSAgroupB) ? Global.DSAgroupB : (dSAGroup.equals(Global.DSAgroupC) ? Global.DSAgroupC : dSAGroup));
    }

    public String keyType() {
        return "DSA.g-" + this.p.bitLength();
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public String getPAsHexString() {
        return this.pAsHexString;
    }

    public String getQAsHexString() {
        return this.qAsHexString;
    }

    public String getGAsHexString() {
        return this.gAsHexString;
    }

    public byte[] fingerprint() {
        BigInteger[] bigIntegerArray = new BigInteger[]{this.p, this.q, this.g};
        return this.fingerprint(bigIntegerArray);
    }

    public static BigInteger makePrime(int n, int n2, Random random) {
        BigInteger bigInteger;
        while (!DSAGroup.isPrime(bigInteger = new BigInteger(n, random).setBit(0).setBit(n - 1), n2)) {
        }
        return bigInteger;
    }

    public static boolean isPrime(BigInteger bigInteger, int n) {
        for (int i = 0; i < smallPrimes.length; ++i) {
            if (!bigInteger.mod(smallPrimes[i]).equals(Util.ZERO)) continue;
            return false;
        }
        return bigInteger.isProbablePrime(80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSAGroup generate(int n, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        Object object;
        BigInteger bigInteger4;
        int n2 = 0;
        QG qG = null;
        if (multithread) {
            qG = new QG(random);
            qG.start();
        }
        do {
            if (n2++ % 15 == 0) {
                logger.finer(".");
            }
            if (multithread) {
                while (qG.qs.size() < 1) {
                    try {
                        object = qG;
                        synchronized (object) {
                            qG.wait(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                bigInteger2 = (BigInteger)qG.qs.elementAt(0);
                qG.qs.removeElementAt(0);
                object = qG;
                synchronized (object) {
                    qG.notify();
                }
            } else {
                bigInteger2 = DSAGroup.makePrime(160, 80, random);
            }
        } while (!DSAGroup.isPrime(bigInteger4 = ((BigInteger)(object = new BigInteger(n, random).setBit(n - 1))).subtract((bigInteger3 = ((BigInteger)object).mod(bigInteger2.multiply(Util.TWO))).subtract(Util.ONE)), 80));
        qG.qs.trimToSize();
        object = bigInteger4.subtract(Util.ONE);
        do {
            if (n2++ % 5 == 0) {
                logger.finer("+");
            }
            bigInteger3 = new BigInteger(160, random);
            bigInteger = bigInteger3.modPow(((BigInteger)object).divide(bigInteger2), bigInteger4);
        } while (bigInteger3.compareTo(bigInteger4.subtract(Util.ONE)) != -1 || bigInteger3.compareTo(Util.ONE) < 1 || bigInteger.compareTo(Util.ONE) == 0 || bigInteger.bitLength() != n);
        return new DSAGroup(bigInteger4, bigInteger2, bigInteger);
    }

    public static boolean testGroup(DSAGroup dSAGroup) {
        BigInteger bigInteger = dSAGroup.getP();
        BigInteger bigInteger2 = dSAGroup.getQ();
        BigInteger bigInteger3 = dSAGroup.getG();
        BigInteger bigInteger4 = bigInteger.subtract(Util.ONE);
        boolean bl = bigInteger.bitLength() <= 1024 && bigInteger.bitLength() >= 512 && bigInteger.bitLength() % 64 == 0 && bigInteger2.bitLength() == 160 && bigInteger2.compareTo(bigInteger) == -1 && DSAGroup.isPrime(bigInteger, 80) && DSAGroup.isPrime(bigInteger2, 80) && bigInteger4.mod(bigInteger2).equals(Util.ZERO) && bigInteger3.compareTo(Util.ONE) == 1 && !bigInteger3.equals(bigInteger4.modPow(bigInteger4.divide(bigInteger2), bigInteger));
        return bl;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray[0].equals("test")) {
            System.out.print("GroupA: ");
            System.out.println(DSAGroup.testGroup(Global.DSAgroupA));
            System.out.print("GroupB: ");
            System.out.println(DSAGroup.testGroup(Global.DSAgroupB));
            System.out.print("GroupC: ");
            System.out.println(DSAGroup.testGroup(Global.DSAgroupC));
        } else {
            DSAGroup dSAGroup = DSAGroup.generate(Integer.parseInt(stringArray[0]), new Yarrow("/dev/urandom", "SHA1", "Rijndael"));
            System.err.print("\nVerifying group: ");
            System.err.println(DSAGroup.testGroup(dSAGroup) ? "passed" : "failed");
            dSAGroup.write(System.out);
        }
    }

    public byte[] asBytes() {
        byte[] byArray = Util.MPIbytes(this.p);
        byte[] byArray2 = Util.MPIbytes(this.q);
        byte[] byArray3 = Util.MPIbytes(this.g);
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    public boolean equals(Object object) {
        return object instanceof DSAGroup && this.p.equals(((DSAGroup)object).p) && this.q.equals(((DSAGroup)object).q) && this.g.equals(((DSAGroup)object).g);
    }

    public boolean equals(DSAGroup dSAGroup) {
        return this.p.equals(dSAGroup.p) && this.q.equals(dSAGroup.q) && this.g.equals(dSAGroup.g);
    }

    public void destroy() {
        this.g = null;
        this.q = null;
        this.p = null;
    }

    static class QG
    extends Thread {
        public Vector qs = new Vector();
        protected Random r;

        public QG(Random random) {
            this.setDaemon(true);
            this.r = random;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: while (true) {
                this.qs.addElement(DSAGroup.makePrime(160, 80, this.r));
                QG qG = this;
                synchronized (qG) {
                    this.notifyAll();
                }
                while (true) {
                    if (this.qs.size() < 3) continue block8;
                    qG = this;
                    synchronized (qG) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
        }
    }
}

