/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DSASignature;
import freenet.crypt.Util;
import freenet.crypt.Yarrow;
import java.math.BigInteger;
import java.util.Random;

public class DSA {
    public static DSASignature sign(DSAGroup dSAGroup, DSAPrivateKey dSAPrivateKey, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = dSAGroup.getG().modPow(bigInteger, dSAGroup.getP()).mod(dSAGroup.getQ());
        BigInteger bigInteger4 = bigInteger.modInverse(dSAGroup.getQ());
        return DSA.sign(dSAGroup, dSAPrivateKey, bigInteger3, bigInteger4, bigInteger2);
    }

    public static DSASignature sign(DSAGroup dSAGroup, DSAPrivateKey dSAPrivateKey, BigInteger bigInteger, Random random) {
        BigInteger bigInteger2;
        while ((bigInteger2 = new BigInteger(160, random)).compareTo(dSAGroup.getQ()) > -1 || bigInteger2.compareTo(Util.ZERO) == 0) {
        }
        return DSA.sign(dSAGroup, dSAPrivateKey, bigInteger2, bigInteger);
    }

    public static BigInteger[][] signaturePrecalculate(DSAGroup dSAGroup, int n, Random random) {
        BigInteger[][] bigIntegerArray = new BigInteger[n][2];
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger;
            while ((bigInteger = new BigInteger(160, random)).compareTo(dSAGroup.getQ()) > -1 || bigInteger.compareTo(Util.ZERO) == 0) {
            }
            bigIntegerArray[i][0] = dSAGroup.getG().modPow(bigInteger, dSAGroup.getP());
            bigIntegerArray[i][1] = bigInteger.modInverse(dSAGroup.getQ());
        }
        return bigIntegerArray;
    }

    public static DSASignature sign(DSAGroup dSAGroup, DSAPrivateKey dSAPrivateKey, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger3.add(dSAPrivateKey.getX().multiply(bigInteger)).mod(dSAGroup.getQ());
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger4).mod(dSAGroup.getQ());
        return new DSASignature(bigInteger, bigInteger5);
    }

    public static boolean verify(DSAPublicKey dSAPublicKey, DSASignature dSASignature, BigInteger bigInteger) {
        BigInteger bigInteger2 = dSASignature.getS().modInverse(dSAPublicKey.getQ());
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2).mod(dSAPublicKey.getQ());
        BigInteger bigInteger4 = dSASignature.getR().multiply(bigInteger2).mod(dSAPublicKey.getQ());
        BigInteger bigInteger5 = dSAPublicKey.getG().modPow(bigInteger3, dSAPublicKey.getP());
        BigInteger bigInteger6 = dSAPublicKey.getY().modPow(bigInteger4, dSAPublicKey.getP());
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6).mod(dSAPublicKey.getP()).mod(dSAPublicKey.getQ());
        return bigInteger7.equals(dSASignature.getR());
    }

    public static void main(String[] stringArray) throws Exception {
        DSAGroup dSAGroup = DSAGroup.readFromField(stringArray[0]);
        Yarrow yarrow = new Yarrow();
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(dSAGroup, yarrow);
        DSAPublicKey dSAPublicKey = new DSAPublicKey(dSAGroup, dSAPrivateKey);
        DSASignature dSASignature = DSA.sign(dSAGroup, dSAPrivateKey, Util.ZERO, yarrow);
        System.err.println(DSA.verify(dSAPublicKey, dSASignature, Util.ZERO));
    }
}

