/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class DHGroup
extends CryptoKey {
    public final BigInteger p;
    public final BigInteger g;

    public DHGroup(BigInteger bigInteger, BigInteger bigInteger2) {
        this.p = bigInteger;
        this.g = bigInteger2;
    }

    public void write(OutputStream outputStream) throws IOException {
        super.write(new DataOutputStream(outputStream), this.getClass().getName());
    }

    public String writeAsField() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.p.toString(16)).append(',');
        stringBuffer.append(this.g.toString(16));
        return stringBuffer.toString();
    }

    public static CryptoKey readFromField(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        BigInteger bigInteger = Util.byteArrayToMPI(Util.hexToBytes(stringTokenizer.nextToken()));
        BigInteger bigInteger2 = Util.byteArrayToMPI(Util.hexToBytes(stringTokenizer.nextToken()));
        return new DHGroup(bigInteger, bigInteger2);
    }

    public static CryptoKey read(DataInputStream dataInputStream) throws IOException {
        BigInteger bigInteger = Util.readMPI(dataInputStream);
        BigInteger bigInteger2 = Util.readMPI(dataInputStream);
        return new DHGroup(bigInteger, bigInteger2);
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public String keyType() {
        return "DHG-" + this.p.bitLength();
    }

    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.p, this.g});
    }

    public byte[] asBytes() {
        byte[] byArray = Util.MPIbytes(this.p);
        byte[] byArray2 = Util.MPIbytes(this.g);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

