/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoElement;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.Fields;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CryptoKey
implements CryptoElement,
Serializable {
    protected static final Digest shactx = SHA1.getInstance();
    private static Logger logger = Logger.getLogger(CryptoKey.class.getName());

    CryptoKey() {
    }

    public static CryptoKey read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = dataInputStream.readUTF();
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("read", InputStream.class);
            CryptoKey cryptoKey = null;
            cryptoKey = (CryptoKey)method.invoke(null, dataInputStream);
            return cryptoKey;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in read(InputStream i)", exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            return null;
        }
    }

    public abstract void write(OutputStream var1) throws IOException;

    public abstract String keyType();

    public abstract byte[] fingerprint();

    public abstract byte[] asBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] fingerprint(BigInteger[] bigIntegerArray) {
        Digest digest = shactx;
        synchronized (digest) {
            for (int i = 0; i < bigIntegerArray.length; ++i) {
                byte[] byArray = Util.MPIbytes(bigIntegerArray[i]);
                shactx.update(byArray, 0, byArray.length);
            }
            return shactx.digest();
        }
    }

    public String verboseToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString()).append('\t').append(this.fingerprintToString());
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.keyType()).append('/');
        stringBuffer.append(Fields.bytesToHex(this.fingerprint(), 16, 4));
        return stringBuffer.toString();
    }

    protected DataOutputStream write(OutputStream outputStream, String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeUTF(string);
        return dataOutputStream;
    }

    public String fingerprintToString() {
        byte[] byArray = this.fingerprint();
        String string = Fields.bytesToHex(byArray, 0, byArray.length);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, 4)).append(' ');
        stringBuffer.append(string.substring(4, 8)).append(' ');
        stringBuffer.append(string.substring(8, 12)).append(' ');
        stringBuffer.append(string.substring(12, 16)).append(' ');
        stringBuffer.append(string.substring(16, 20)).append("  ");
        stringBuffer.append(string.substring(20, 24)).append(' ');
        stringBuffer.append(string.substring(24, 28)).append(' ');
        stringBuffer.append(string.substring(28, 32)).append(' ');
        stringBuffer.append(string.substring(32, 36)).append(' ');
        stringBuffer.append(string.substring(36, 40));
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        while (true) {
            CryptoKey cryptoKey = CryptoKey.read(System.in);
            System.err.println("-+ " + cryptoKey.verboseToString());
        }
    }
}

