/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.PCFBMode;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream
extends FilterInputStream {
    private final PCFBMode ctx;
    private boolean needIV = false;

    public CipherInputStream(BlockCipher blockCipher, InputStream inputStream) throws IOException {
        this(new PCFBMode(blockCipher), inputStream);
    }

    public CipherInputStream(BlockCipher blockCipher, InputStream inputStream, boolean bl) throws IOException {
        this(new PCFBMode(blockCipher), inputStream);
        if (bl) {
            this.ctx.readIV(this.in);
        }
    }

    public CipherInputStream(BlockCipher blockCipher, InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        this(new PCFBMode(blockCipher), inputStream);
        if (bl && bl2) {
            this.needIV = true;
        } else if (bl) {
            this.ctx.readIV(this.in);
        }
    }

    public CipherInputStream(BlockCipher blockCipher, InputStream inputStream, byte[] byArray) throws IOException {
        this(new PCFBMode(blockCipher, byArray), inputStream);
    }

    public CipherInputStream(PCFBMode pCFBMode, InputStream inputStream) throws IOException {
        super(inputStream);
        this.ctx = pCFBMode;
    }

    public int read() throws IOException {
        int n;
        if (this.needIV) {
            this.ctx.readIV(this.in);
            this.needIV = false;
        }
        return (n = this.in.read()) == -1 ? -1 : this.ctx.decipher(n);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.needIV) {
            this.ctx.readIV(this.in);
            this.needIV = false;
        }
        if ((n3 = this.in.read(byArray, n, n2)) != -1) {
            this.ctx.blockDecipher(byArray, n, n3);
            return n3;
        }
        return -1;
    }

    public int available() throws IOException {
        int n = this.in.available();
        return this.needIV ? Math.max(0, n - this.ctx.lengthIV()) : n;
    }
}

