/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.FieldSet;
import freenet.client.Base64;
import freenet.client.IllegalBase64Exception;
import freenet.support.Fields;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class FreenetURI {
    private static Logger logger = Logger.getLogger(FreenetURI.class.getName());
    private String keyType;
    private String docName;
    private String[] metaStr;
    private byte[] routingKey;
    private byte[] cryptoKey;
    private FieldSet metaInfo;

    public FreenetURI(String string, String string2) {
        this(string, string2, (String[])null, null, null, null);
    }

    public FreenetURI(String string, String string2, byte[] byArray, byte[] byArray2) {
        this(string, string2, (String[])null, null, byArray, byArray2);
    }

    public FreenetURI(String string, String string2, String string3, FieldSet fieldSet, byte[] byArray, byte[] byArray2) {
        String[] stringArray;
        if (string3 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
        }
        this(string, string2, stringArray, fieldSet, byArray, byArray2);
    }

    public FreenetURI(String string, String string2, String[] stringArray, FieldSet fieldSet, byte[] byArray, byte[] byArray2) {
        this.keyType = string.trim().toUpperCase();
        this.docName = string2;
        this.metaStr = stringArray;
        this.metaInfo = fieldSet;
        this.routingKey = byArray;
        this.cryptoKey = byArray2;
    }

    public FreenetURI(String string) throws MalformedURLException {
        int n;
        int n2 = string.indexOf(58);
        if (n2 != -1 && !string.substring(0, n2).equalsIgnoreCase("freenet")) {
            throw new MalformedURLException("Invalid scheme for Freenet URI");
        }
        int n3 = string.indexOf(64);
        if (n3 == -1) {
            this.keyType = "KSK";
            n3 = n2;
        } else {
            this.keyType = string.substring(n2 + 1, n3).toUpperCase().trim();
        }
        string = string.substring(n3 + 1);
        Vector<String> vector = new Vector<String>();
        while ((n = string.lastIndexOf("//")) != -1) {
            String string2 = FreenetURI.urlDecode(string.substring(n + "//".length()));
            if (string2 != null) {
                vector.addElement(FreenetURI.urlDecode(string2));
            }
            string = string.substring(0, n);
        }
        if (!vector.isEmpty()) {
            this.metaStr = new String[vector.size()];
            for (int i = 0; i < this.metaStr.length; ++i) {
                this.metaStr[i] = (String)vector.elementAt(this.metaStr.length - 1 - i);
            }
        }
        if ("KSK".equals(this.keyType)) {
            this.docName = FreenetURI.urlDecode(string);
            return;
        }
        int n4 = string.indexOf(47);
        if (n4 != -1) {
            this.docName = FreenetURI.urlDecode(string.substring(n4 + 1));
            string = string.substring(0, n4);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            this.routingKey = Base64.decode(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(61) == -1) {
                this.cryptoKey = Base64.decode(string3);
                string3 = stringTokenizer.nextToken();
            }
            this.metaInfo = new FieldSet();
            while (true) {
                int n5;
                if ((n5 = string3.indexOf(61)) == -1) {
                    throw new MalformedURLException("URI meta-info must be of the form n1=v1[,n2=v2,...]");
                }
                String string4 = FreenetURI.urlDecode(string3.substring(0, n5));
                String string5 = FreenetURI.urlDecode(string3.substring(n5 + 1));
                this.metaInfo.put(string4, string5);
                string3 = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.metaInfo != null && this.metaInfo.isEmpty()) {
                this.metaInfo = null;
            }
        }
        catch (IllegalBase64Exception illegalBase64Exception) {
            try {
                throw new MalformedURLException("Invalid Base64 quantity: " + illegalBase64Exception);
            }
            catch (Throwable throwable) {
                if (this.metaInfo != null && this.metaInfo.isEmpty()) {
                    this.metaInfo = null;
                }
                throw throwable;
            }
        }
    }

    public void decompose() {
        String string = this.routingKey == null ? "none" : Fields.bytesToHex(this.routingKey, 0, this.routingKey.length);
        String string2 = this.cryptoKey == null ? "none" : Fields.bytesToHex(this.cryptoKey, 0, this.cryptoKey.length);
        StringBuffer stringBuffer = new StringBuffer(this + "\n" + "Key type   : " + this.keyType + "\n" + "Routing key: " + string + "\n" + "Crypto key : " + string2 + "\n" + "Doc name   : " + (this.docName == null ? "none" : this.docName) + "\n" + "Meta strings:");
        if (this.metaStr == null) {
            stringBuffer.append("none\n");
        } else {
            for (int i = 0; i < this.metaStr.length; ++i) {
                stringBuffer.append(this.metaStr[i]);
                if (i == this.metaStr.length - 1) {
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("Meta info  : " + (this.metaInfo == null ? "none" : "" + this.metaInfo));
        logger.fine(stringBuffer.toString());
    }

    public String getGuessableKey() {
        return this.getDocName();
    }

    public String getDocName() {
        return this.docName;
    }

    public String getMetaString() {
        return this.metaStr == null || this.metaStr.length == 0 ? null : this.metaStr[0];
    }

    public String[] getAllMetaStrings() {
        return this.metaStr;
    }

    public FieldSet getMetaInfo() {
        return this.metaInfo;
    }

    public byte[] getKeyVal() {
        return this.getRoutingKey();
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public FreenetURI popMetaString() {
        String[] stringArray = null;
        if (this.metaStr != null && this.metaStr.length > 1) {
            stringArray = new String[this.metaStr.length - 1];
            System.arraycopy(this.metaStr, 1, stringArray, 0, stringArray.length);
        }
        return this.setMetaString(stringArray);
    }

    public FreenetURI addMetaStrings(String[] stringArray) {
        if (this.metaStr == null) {
            return this.setMetaString(stringArray);
        }
        String[] stringArray2 = new String[this.metaStr.length + stringArray.length];
        System.arraycopy(this.metaStr, 0, stringArray2, 0, this.metaStr.length);
        System.arraycopy(stringArray, 0, stringArray2, this.metaStr.length, stringArray.length);
        return this.setMetaString(stringArray);
    }

    public FreenetURI setDocName(String string) {
        return new FreenetURI(this.keyType, string, this.metaStr, this.metaInfo, this.routingKey, this.cryptoKey);
    }

    public FreenetURI setMetaString(String[] stringArray) {
        return new FreenetURI(this.keyType, this.docName, stringArray, this.metaInfo, this.routingKey, this.cryptoKey);
    }

    protected static String urlDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '+') {
                stringBuffer.append(' ');
                continue;
            }
            if (string.charAt(i) == '%') {
                int n = Integer.parseInt(string.substring(i + 1, i + 3), 16);
                stringBuffer.append((char)n);
                i += 2;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    protected static String urlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') {
                stringBuffer.append('+');
                continue;
            }
            if (string.charAt(i) > '\u0080' || string.charAt(i) < ',') {
                stringBuffer.append('%').append(Integer.toString(string.charAt(i), 16));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = bl ? new StringBuffer("freenet:") : new StringBuffer();
        stringBuffer.append(this.keyType);
        stringBuffer.append('@');
        if (!"KSK".equals(this.keyType)) {
            if (this.routingKey != null) {
                stringBuffer.append(Base64.encode(this.routingKey));
            }
            if (this.cryptoKey != null) {
                stringBuffer.append(',').append(Base64.encode(this.cryptoKey));
            }
            if (this.metaInfo != null) {
                Enumeration enumeration = this.metaInfo.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = this.metaInfo.get(string);
                    stringBuffer.append(',');
                    stringBuffer.append(FreenetURI.urlEncode(string));
                    stringBuffer.append('=');
                    stringBuffer.append(FreenetURI.urlEncode(string2));
                }
            }
            if (this.docName != null) {
                stringBuffer.append('/');
            }
        }
        if (this.docName != null) {
            stringBuffer.append(FreenetURI.urlEncode(this.docName));
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                stringBuffer.append("//" + FreenetURI.urlEncode(this.metaStr[i]));
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        new FreenetURI(stringArray[0]).decompose();
    }
}

