/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.crypt.BlockCipher;
import freenet.crypt.CipherInputStream;
import freenet.crypt.CipherOutputStream;
import freenet.crypt.DecipherOutputStream;
import freenet.crypt.EncipherInputStream;
import freenet.crypt.PCFBMode;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.io.DataNotValidIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class Document {
    public static final int DOC_BAD_HEADER = 193;
    public static final int DOC_BAD_KEY = 194;
    public static final int DOC_UNKNOWN_CIPHER = 195;
    public static final int DOC_BAD_LENGTH = 196;
    public static final int DOC_BAD_STORABLES = 197;
    protected long length;
    protected long metaLength;
    protected byte[] header;
    protected byte[] cryptoKey;
    protected PCFBMode ctx;

    public static final String getTextForDNV(int n) {
        switch (n) {
            case 193: {
                return "DOC_BAD_HEADER";
            }
            case 194: {
                return "DOC_BAD_KEY";
            }
            case 195: {
                return "DOC_UNKNOWN_CIPHER";
            }
            case 196: {
                return "DOC_BAD_LENGTH";
            }
            case 197: {
                return "DOC_BAD_STORABLES";
            }
        }
        return null;
    }

    protected static int fieldSize(long l) {
        int n = Util.log2(l + 1L) + 7 >> 3;
        return n == 0 ? 1 : n;
    }

    public Document(BlockCipher blockCipher, byte[] byArray, long l, long l2) throws IOException {
        if (l < 0L || Util.log2(l) > 62) {
            throw new IllegalArgumentException("length out of bounds");
        }
        if (l2 < 0L || l2 > l) {
            throw new IllegalArgumentException("metadata length out of bounds");
        }
        if (l + l2 <= 0L) {
            throw new IllegalArgumentException("completely empty insert");
        }
        this.cryptoKey = byArray;
        this.length = l;
        this.metaLength = l2;
        blockCipher.initialize(byArray);
        this.ctx = new PCFBMode(blockCipher);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.fillHeader(byteArrayOutputStream, Util.hashBytes(new SHA1(), byArray));
        this.fillHeader(byteArrayOutputStream, l);
        this.fillHeader(byteArrayOutputStream, l2);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        int n = (1 << Util.log2(byteArrayOutputStream.size())) - byteArrayOutputStream.size();
        if (n > 0) {
            SHA1 sHA1 = new SHA1();
            sHA1.update(byteArrayOutputStream.toByteArray());
            Util.rollingHashPad(byteArrayOutputStream, n, sHA1);
        }
        this.header = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < this.header.length; ++i) {
            this.header[i] = (byte)this.ctx.encipher(this.header[i]);
        }
    }

    protected void fillHeader(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) throws IOException {
        byteArrayOutputStream.write(0xFF & byArray.length >> 8);
        byteArrayOutputStream.write(0xFF & byArray.length);
        byteArrayOutputStream.write(byArray);
    }

    protected void fillHeader(ByteArrayOutputStream byteArrayOutputStream, long l) throws IOException {
        int n = Document.fieldSize(l);
        byteArrayOutputStream.write(0xFF & n >> 8);
        byteArrayOutputStream.write(0xFF & n);
        for (int i = 8 * (n - 1); i >= 0; i -= 8) {
            byteArrayOutputStream.write((int)(0xFFL & l >> i));
        }
    }

    public Document(BlockCipher blockCipher, byte[] byArray, byte[] byArray2) throws DataNotValidIOException {
        if (byArray2.length != 1 << Util.log2(byArray2.length)) {
            throw new DataNotValidIOException(193);
        }
        this.header = byArray2;
        this.cryptoKey = byArray;
        blockCipher.initialize(byArray);
        this.ctx = new PCFBMode(blockCipher);
        Vector<byte[]> vector = new Vector<byte[]>();
        try {
            int n;
            int n2 = 0;
            while (n2 < byArray2.length && (n = (byte)this.ctx.decipher(byArray2[n2++]) << 8 | (byte)this.ctx.decipher(byArray2[n2++])) > 0) {
                byte[] byArray3 = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray3[i] = (byte)this.ctx.decipher(byArray2[n2++]);
                }
                vector.addElement(byArray3);
            }
            while (n2 < byArray2.length) {
                this.ctx.decipher(byArray2[n2++]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DataNotValidIOException(193);
        }
        if (vector.size() < 1) {
            throw new DataNotValidIOException(194);
        }
        byte[] byArray4 = (byte[])vector.elementAt(0);
        if (byArray4 == null || !Util.byteArrayEqual(byArray4, Util.hashBytes(new SHA1(), byArray))) {
            throw new DataNotValidIOException(194);
        }
        if (vector.size() < 3) {
            throw new DataNotValidIOException(193);
        }
        byArray4 = (byte[])vector.elementAt(1);
        if (byArray4 == null) {
            throw new DataNotValidIOException(193);
        }
        this.length = new BigInteger(1, byArray4).longValue();
        if (this.length <= 0L || Util.log2(this.length) > 62 || Document.fieldSize(this.length) != byArray4.length) {
            throw new DataNotValidIOException(193);
        }
        byArray4 = (byte[])vector.elementAt(2);
        if (byArray4 == null) {
            throw new DataNotValidIOException(193);
        }
        this.metaLength = new BigInteger(1, byArray4).longValue();
        if (this.metaLength < 0L || this.metaLength > this.length || Document.fieldSize(this.metaLength) != byArray4.length) {
            throw new DataNotValidIOException(193);
        }
    }

    public byte[] getDocumentHeader() {
        return this.header;
    }

    public boolean hasMetadata() {
        return this.metaLength != 0L;
    }

    public long length() {
        return this.length;
    }

    public long metadataLength() {
        return this.metaLength;
    }

    public long dataLength() {
        return this.length - this.metaLength;
    }

    public OutputStream decipheringOutputStream(OutputStream outputStream) throws IOException {
        return new DecipherOutputStream(outputStream, this.ctx);
    }

    public OutputStream encipheringOutputStream(OutputStream outputStream) throws IOException {
        return new CipherOutputStream(this.ctx, outputStream);
    }

    public InputStream decipheringInputStream(InputStream inputStream) throws IOException {
        return new CipherInputStream(this.ctx, inputStream);
    }

    public InputStream encipheringInputStream(InputStream inputStream) throws IOException {
        return new EncipherInputStream(inputStream, this.ctx);
    }
}

