/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.Key;
import freenet.KeyException;
import freenet.client.AbstractClientKey;
import freenet.client.ClientKey;
import freenet.client.FreenetURI;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.keys.CHK;
import freenet.support.Bucket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Random;

public class ClientCHK
extends AbstractClientKey {
    private byte[] cryptoKey;
    private CHK chk;

    public static ClientKey createFromInsertURI(Random random, FreenetURI freenetURI) throws KeyException {
        return new ClientCHK();
    }

    public static ClientKey createFromRequestURI(FreenetURI freenetURI) throws KeyException {
        if (freenetURI.getRoutingKey() == null) {
            throw new KeyException("Unspecified routing key");
        }
        if (freenetURI.getCryptoKey() == null) {
            throw new KeyException("Unspecified encryption key");
        }
        return new ClientCHK(freenetURI.getRoutingKey(), freenetURI.getCryptoKey());
    }

    public ClientCHK() {
    }

    public ClientCHK(byte[] byArray, byte[] byArray2) {
        this(new CHK(byArray), byArray2);
    }

    public ClientCHK(CHK cHK, byte[] byArray) {
        this.chk = cHK;
        this.cryptoKey = byArray;
    }

    public String keyType() {
        return "CHK";
    }

    public Key getKey() {
        return this.chk;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    private void makeCryptoKey(InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[4096];
        Digest digest = SHA1.getInstance();
        while (l > 0L) {
            int n = inputStream.read(byArray, 0, l < (long)byArray.length ? (int)l : byArray.length);
            if (n > 0) {
                digest.update(byArray, 0, n);
                l -= (long)n;
                continue;
            }
            if (n != -1) continue;
            throw new EOFException();
        }
        byte[] byArray2 = digest.digest();
        this.cryptoKey = new byte[this.cipher.getKeySize() >> 3];
        Util.makeKey(byArray2, this.cryptoKey, 0, this.cryptoKey.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream encode(Bucket bucket, long l, Bucket bucket2) throws KeyException, IOException {
        InputStream inputStream = bucket.getInputStream();
        InputStream inputStream2 = bucket.getInputStream();
        try {
            this.makeCryptoKey(inputStream, bucket.size());
            InputStream inputStream3 = super.encode(inputStream2, bucket.size(), l, bucket2);
            this.chk = new CHK(this.storables, Util.log2(this.getPaddedLength()));
            InputStream inputStream4 = inputStream3;
            return inputStream4;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream encode(Bucket bucket, Bucket bucket2, Bucket bucket3) throws KeyException, IOException {
        InputStream inputStream;
        InputStream inputStream2 = null;
        InputStream inputStream3 = null;
        try {
            inputStream2 = bucket.getInputStream();
            inputStream3 = bucket2.getInputStream();
            this.makeCryptoKey(new SequenceInputStream(inputStream2, inputStream3), bucket.size() + bucket2.size());
        }
        finally {
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream3.close();
            }
            catch (IOException iOException) {}
        }
        try {
            inputStream2 = bucket.getInputStream();
            inputStream3 = bucket2.getInputStream();
            inputStream = super.encode(new SequenceInputStream(inputStream2, inputStream3), bucket.size() + bucket2.size(), bucket.size(), bucket3);
        }
        finally {
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream3.close();
            }
            catch (IOException iOException) {}
        }
        this.chk = new CHK(this.storables, Util.log2(this.getPaddedLength()));
        return inputStream;
    }
}

