/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.Key;
import freenet.KeyException;
import freenet.Storables;
import freenet.client.ClientCHK;
import freenet.client.ClientKey;
import freenet.client.Document;
import freenet.client.FreenetURI;
import freenet.crypt.BlockCipher;
import freenet.crypt.ProgressiveHashOutputStream;
import freenet.crypt.SHA1;
import freenet.crypt.SHA1Factory;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.Util;
import freenet.support.Bucket;
import freenet.support.io.DataNotValidIOException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;

public abstract class AbstractClientKey
implements ClientKey {
    public static final String DEFAULT_CIPHER = "Twofish";
    protected String cipherName;
    protected BlockCipher cipher;
    protected Document doc;
    protected Storables storables;

    public static ClientKey createFromInsertURI(Random random, FreenetURI freenetURI) throws KeyException {
        return AbstractClientKey.createClientKey(freenetURI.getKeyType(), "createFromInsertURI", new Class[]{Random.class, FreenetURI.class}, new Object[]{random, freenetURI});
    }

    public static ClientKey createFromRequestURI(FreenetURI freenetURI) throws KeyException {
        return AbstractClientKey.createClientKey(freenetURI.getKeyType(), "createFromRequestURI", new Class[]{FreenetURI.class}, new Object[]{freenetURI});
    }

    private static ClientKey createClientKey(String string, String string2, Class[] classArray, Object[] objectArray) throws KeyException {
        try {
            Class<?> clazz = Class.forName("freenet.client.Client" + string);
            if (!AbstractClientKey.class.isAssignableFrom(clazz)) {
                throw new ClassNotFoundException();
            }
            return (ClientKey)clazz.getDeclaredMethod(string2, classArray).invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new KeyException("Unknown keytype");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof KeyException) {
                throw (KeyException)invocationTargetException.getTargetException();
            }
            throw new KeyException(invocationTargetException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KeyException("Key not constructable from URI");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KeyException("Illegal access");
        }
    }

    protected AbstractClientKey() throws KeyException {
        try {
            this.setCipher(DEFAULT_CIPHER);
        }
        catch (UnsupportedCipherException unsupportedCipherException) {
            throw new KeyException("" + unsupportedCipherException);
        }
    }

    public void setCipher(String string) throws UnsupportedCipherException {
        BlockCipher blockCipher;
        if (string == null) {
            string = DEFAULT_CIPHER;
        }
        if ((blockCipher = Util.getCipherByName(string)) == null) {
            throw new UnsupportedCipherException("Unsupported cipher " + string);
        }
        this.cipherName = string;
        this.cipher = blockCipher;
    }

    public String getCipher() {
        return this.cipherName;
    }

    protected InputStream encode(InputStream inputStream, long l, long l2, Bucket bucket) throws IOException {
        this.doc = new Document(this.cipher, this.getCryptoKey(), l, l2);
        long l3 = this.getPartSize();
        long l4 = this.getPaddedLength() - l;
        ProgressiveHashOutputStream progressiveHashOutputStream = new ProgressiveHashOutputStream(l3, new SHA1Factory(), bucket);
        SHA1 sHA1 = new SHA1();
        OutputStream outputStream = this.doc.encipheringOutputStream(progressiveHashOutputStream);
        byte[] byArray = new byte[4096];
        while (l > 0L) {
            int n = inputStream.read(byArray, 0, l < (long)byArray.length ? (int)l : byArray.length);
            if (n > 0) {
                sHA1.update(byArray, 0, n);
                outputStream.write(byArray, 0, n);
                l -= (long)n;
                continue;
            }
            if (n != -1) continue;
            throw new EOFException();
        }
        Util.rollingHashPad(outputStream, l4, sHA1);
        outputStream.flush();
        progressiveHashOutputStream.close();
        this.storables = new Storables();
        this.storables.setSymmetricCipher(this.cipherName);
        this.storables.setPartSize(l3);
        this.storables.setDocumentHeader(this.doc.getDocumentHeader());
        this.storables.setInitialDigest(progressiveHashOutputStream.getInitialDigest());
        return progressiveHashOutputStream.getInputStream();
    }

    public Document decode(Storables storables, long l) throws KeyException, DataNotValidIOException {
        String string = storables.getSymmetricCipher();
        byte[] byArray = storables.getDocumentHeader();
        if (string == null || byArray == null) {
            throw new DataNotValidIOException(197);
        }
        try {
            this.setCipher(string);
        }
        catch (UnsupportedCipherException unsupportedCipherException) {
            throw new DataNotValidIOException(195);
        }
        this.doc = new Document(this.cipher, this.getCryptoKey(), byArray);
        if (l != this.getTotalLength()) {
            DataNotValidIOException dataNotValidIOException = new DataNotValidIOException(196);
            throw dataNotValidIOException;
        }
        this.storables = storables;
        return this.doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Storables getStorables() {
        return this.storables;
    }

    public long getPlainLength() {
        return this.doc == null ? 0L : this.doc.length();
    }

    public long getPaddedLength() {
        return this.getPaddedLength(this.getPlainLength());
    }

    public long getPaddedLength(long l) {
        return Math.max(1024, 1 << Util.log2(l));
    }

    public long getTotalLength() {
        return this.getTotalLength(this.getPaddedLength(), this.getPartSize());
    }

    public long getTotalLength(long l) {
        return this.getTotalLength(this.getPaddedLength(l), this.getPartSize(l));
    }

    public long getTotalLength(long l, long l2) {
        return Key.getTransmissionLength(l, l2);
    }

    public long getPartSize() {
        return this.getPartSize(this.getPaddedLength());
    }

    public long getPartSize(long l) {
        return Key.getPartSize(l);
    }

    public int getControlLength() {
        return Key.getControlLength();
    }

    public String getDocumentName() {
        return null;
    }

    public String toString() {
        return this.getURI() == null ? "new " + this.keyType() : this.getURI().toString();
    }

    public FreenetURI getURI() {
        return this.getKey() == null || this.getCryptoKey() == null ? null : new FreenetURI(this.keyType(), this.getDocumentName(), this.getKey().getVal(), this.getCryptoKey());
    }

    public abstract String keyType();

    public abstract byte[] getCryptoKey() throws KeyException;

    public abstract InputStream encode(Bucket var1, long var2, Bucket var4) throws KeyException, IOException;

    public abstract InputStream encode(Bucket var1, Bucket var2, Bucket var3) throws KeyException, IOException;

    public abstract Key getKey();

    static {
        ClientCHK.class.toString();
    }
}

