/*
 * Decompiled with CFR 0.152.
 */
package freenet;

import freenet.FieldSet;
import freenet.crypt.DSA;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DSASignature;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.Fields;
import java.math.BigInteger;
import java.util.Random;

public class Storables
extends FieldSet {
    public static final String PREFIX = "Storable";
    private static final String[] ypqgS = new String[]{"y", "p", "q", "g"};

    public Storables() {
    }

    private Storables(FieldSet fieldSet) {
        super(fieldSet);
    }

    public static Storables readFrom(FieldSet fieldSet) {
        FieldSet fieldSet2 = fieldSet.getSet(PREFIX);
        return fieldSet2 == null ? null : new Storables(fieldSet2);
    }

    public void addTo(FieldSet fieldSet) {
        fieldSet.put(PREFIX, this);
    }

    public boolean isLegalForCHK() {
        return this.size() == 4 && this.getPartSize() > 0L && this.getInitialDigest() != null && this.getSymmetricCipher() != null && this.getDocumentHeader() != null;
    }

    public boolean isLegalForSVK() {
        if (this.size() != 6 && (this.size() != 7 || this.getDocumentName() == null)) {
            return false;
        }
        return this.getPartSize() > 0L && this.getInitialDigest() != null && this.getSymmetricCipher() != null && this.getDocumentHeader() != null && this.getPublicKey() != null && this.getSignature() != null;
    }

    public void sign(Random random, DSAPrivateKey dSAPrivateKey, DSAGroup dSAGroup) {
        this.setPublicKey(new DSAPublicKey(dSAGroup, dSAPrivateKey));
        Digest digest = SHA1.getInstance();
        this.hashUpdate(digest, new String[]{"Signature"});
        BigInteger bigInteger = Util.generateLargeRandom(80, 160, random);
        BigInteger bigInteger2 = Util.byteArrayToMPI(digest.digest());
        this.setSignature(DSA.sign(dSAGroup, dSAPrivateKey, bigInteger, bigInteger2));
    }

    public boolean verifies() {
        Digest digest = SHA1.getInstance();
        this.hashUpdate(digest, new String[]{"Signature"});
        BigInteger bigInteger = Util.byteArrayToMPI(digest.digest());
        return DSA.verify(this.getPublicKey(), this.getSignature(), bigInteger);
    }

    public long getPartSize() {
        try {
            return Math.max(0L, Long.parseLong(this.get("Part-size"), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public void setPartSize(long l) {
        this.put("Part-size", Long.toHexString(Math.max(0L, l)));
    }

    public byte[] getInitialDigest() {
        String string = this.get("Initial-digest");
        return string == null ? null : Fields.hexToBytes(string);
    }

    public void setInitialDigest(byte[] byArray) {
        this.put("Initial-digest", Fields.bytesToHex(byArray));
    }

    public String getSymmetricCipher() {
        return this.get("Symmetric-cipher");
    }

    public void setSymmetricCipher(String string) {
        this.put("Symmetric-cipher", string);
    }

    public byte[] getDocumentHeader() {
        String string = this.get("Document-header");
        return string == null ? null : Fields.hexToBytes(string);
    }

    public void setDocumentHeader(byte[] byArray) {
        this.put("Document-header", Fields.bytesToHex(byArray));
    }

    public DSAPublicKey getPublicKey() {
        FieldSet fieldSet = this.getSet("Public-key");
        if (fieldSet == null) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[4];
        for (int i = 0; i < 4; ++i) {
            String string = fieldSet.get(ypqgS[i]);
            if (string == null) {
                return null;
            }
            bigIntegerArray[i] = new BigInteger(string, 16);
        }
        return new DSAPublicKey(new DSAGroup(bigIntegerArray[1], bigIntegerArray[2], bigIntegerArray[3]), bigIntegerArray[0]);
    }

    public void setPublicKey(DSAPublicKey dSAPublicKey) {
        FieldSet fieldSet = new FieldSet();
        fieldSet.put("y", dSAPublicKey.getY().toString(16));
        fieldSet.put("p", dSAPublicKey.getP().toString(16));
        fieldSet.put("q", dSAPublicKey.getQ().toString(16));
        fieldSet.put("g", dSAPublicKey.getG().toString(16));
        this.put("Public-key", fieldSet);
    }

    public byte[] getDocumentName() {
        String string = this.get("Document-name");
        return string == null ? null : Fields.hexToBytes(string);
    }

    public void setDocumentName(byte[] byArray) {
        this.put("Document-name", Fields.bytesToHex(byArray));
    }

    public DSASignature getSignature() {
        String string = this.get("Signature");
        return string == null ? null : new DSASignature(string);
    }

    public void setSignature(DSASignature dSASignature) {
        this.put("Signature", dSASignature.toString());
    }
}

