/*
 * Decompiled with CFR 0.152.
 */
package freenet;

import freenet.KeyException;
import freenet.Storables;
import freenet.crypt.ProgressiveHashInputStream;
import freenet.crypt.SHA1;
import freenet.support.Fields;
import freenet.support.Measurable;
import freenet.support.io.DataNotValidIOException;
import freenet.support.io.VerifyingInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class Key
implements Measurable {
    public static final Key NIL = new Key(new byte[0]);
    public static final int LOG2_MAXSIZE = 62;
    public static final int LOG2_MINSIZE = 10;
    private static final Hashtable keytypes = new Hashtable();
    protected byte[] val;

    public static void addKeyType(int n, Class clazz) throws KeyException {
        if (!Key.class.isAssignableFrom(clazz)) {
            throw new KeyException("Not a subclass of Key");
        }
        try {
            Constructor constructor = clazz.getConstructor(byte[].class);
            keytypes.put(new Integer(n), constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KeyException("Not constructable from a byte array");
        }
    }

    public static Key readKey(String string) throws KeyException {
        byte[] byArray;
        try {
            byArray = Fields.hexToBytes(string);
        }
        catch (RuntimeException runtimeException) {
            throw new KeyException("Key string is not legal hexadecimal");
        }
        return Key.readKey(byArray);
    }

    public static Key readKey(byte[] byArray) throws KeyException {
        Integer n = new Integer(byArray[byArray.length - 2] << 8 | byArray[byArray.length - 1]);
        Constructor constructor = (Constructor)keytypes.get(n);
        if (constructor != null) {
            try {
                return (Key)constructor.newInstance(new Object[]{byArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException() instanceof KeyException ? (KeyException)invocationTargetException.getTargetException() : new KeyException(invocationTargetException.getTargetException().toString());
            }
            catch (Exception exception) {
                throw new KeyException(exception.toString());
            }
        }
        if (n != 0) {
            // empty if block
        }
        return new Key(byArray);
    }

    public static final int getControlLength() {
        return 21;
    }

    public static final long getTransmissionLength(long l, long l2) {
        if (l < 0L || l2 <= 0L) {
            return 0L;
        }
        int n = (int)((l - 1L) / l2);
        long l3 = l - (long)n * l2;
        return (long)n * (l2 + (long)Key.getControlLength()) + l3 + 1L;
    }

    public static final long getDataLength(long l, long l2) {
        if (l < 0L || l2 < 0L) {
            return 0L;
        }
        int n = (int)(l / (l2 + (long)Key.getControlLength()));
        long l3 = l - (long)n * (l2 + (long)Key.getControlLength());
        return (long)n * l2 + l3 - 1L;
    }

    public static final long getPartSize(long l) {
        return Math.max(l >> 7, Math.min(l, 16384L));
    }

    public final long getExpectedTransmissionLength() {
        long l = this.getExpectedDataLength();
        return l == -1L ? -1L : Key.getTransmissionLength(l, Key.getPartSize(l));
    }

    public final long getExpectedDataLength() {
        return this.val.length - 3 >= 0 ? (long)(1 << this.val[this.val.length - 3]) : -1L;
    }

    public Key(byte[] byArray) {
        this.val = byArray;
    }

    public Key(byte[] byArray, int n, int n2) {
        this(byArray.length, n, n2);
        System.arraycopy(byArray, 0, this.val, 0, byArray.length);
    }

    protected Key(int n, int n2, int n3) {
        this.val = new byte[n + 3];
        this.val[this.val.length - 3] = (byte)(0xFF & n2);
        this.val[this.val.length - 2] = (byte)(0xFF & n3 >> 8);
        this.val[this.val.length - 1] = (byte)(0xFF & n3);
    }

    public Key(String string) throws NumberFormatException {
        this(Fields.hexToBytes(string));
    }

    public VerifyingInputStream verifyStream(InputStream inputStream, Storables storables, long l) throws DataNotValidIOException {
        return new ProgressiveHashInputStream(inputStream, storables.getPartSize(), l, SHA1.getInstance(), storables.getInitialDigest());
    }

    private static final int at(byte[] byArray, int n) {
        return (n < byArray.length ? byArray[n] : (byte)0) & 0xFF;
    }

    public final int compareTo(Object object) {
        return this.compareTo((Key)object);
    }

    public final int compareTo(Key key) {
        int n = Math.max(this.val.length, key.val.length);
        for (int i = 0; i < n; ++i) {
            if (Key.at(this.val, i) < Key.at(key.val, i)) {
                return -1;
            }
            if (Key.at(this.val, i) <= Key.at(key.val, i)) continue;
            return 1;
        }
        return 0;
    }

    public final int compareTo(Object object, Object object2) {
        return this.compareTo((Key)object, (Key)object2);
    }

    public final int compareTo(Key key, Key key2) {
        int n = key.compareTo(key2);
        if (n < 0) {
            if (this.compareTo(key2) > 0) {
                return 1;
            }
            if (this.compareTo(key) > 0) {
                return this.compareToSorted(key, key2);
            }
            return -1;
        }
        if (n > 0) {
            if (this.compareTo(key) > 0) {
                return -1;
            }
            if (this.compareTo(key2) > 0) {
                return -1 * this.compareToSorted(key2, key);
            }
            return 1;
        }
        return 0;
    }

    public final int compareToSorted(Object object, Object object2) {
        return this.compareToSorted((Key)object, (Key)object2);
    }

    public final int compareToSorted(Key key, Key key2) {
        int n = Math.max(this.val.length, Math.max(key.val.length, key2.val.length));
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if ((n2 += Key.at(this.val, i) - Key.at(key.val, i) - (Key.at(key2.val, i) - Key.at(this.val, i))) < -1) {
                return -1;
            }
            if (n2 > 1) {
                return 1;
            }
            n2 *= 256;
        }
        return n2;
    }

    public final boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public final int hashCode() {
        return Fields.hashCode(this.val);
    }

    public final String toString() {
        return Fields.bytesToHex(this.val);
    }

    public final byte[] getVal() {
        return this.val;
    }

    public final int length() {
        return this.val.length;
    }

    public static void main(String[] stringArray) {
        System.out.println("Until we figure out a standardized testing system,");
        System.out.println("edit the source and uncomment whatever you want to test.");
    }
}

