/*
 * Decompiled with CFR 0.152.
 */
package freenet;

import freenet.crypt.Digest;
import freenet.support.Fields;
import freenet.support.io.ReadInputStream;
import freenet.support.io.WriteOutputStream;
import freenet.support.sort.ArraySorter;
import freenet.support.sort.QuickSorter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldSet {
    private static Logger logger = Logger.getLogger(FieldSet.class.getName());
    public static final byte HASH_SUBSET = -3;
    public static final byte HASH_EQUALS = -2;
    public static final byte HASH_NEWLINE = -1;
    public static final long MAX_PARSE_SIZE = 524288L;
    protected final Hashtable fields;
    private static final Filter voidF = new VoidFilter();

    public FieldSet() {
        this.fields = new Hashtable();
    }

    public FieldSet(ReadInputStream readInputStream) throws IOException {
        this();
        this.parseFields(readInputStream);
    }

    protected FieldSet(FieldSet fieldSet) {
        this.fields = fieldSet.fields;
    }

    public String get(String string) {
        Object v = this.fields.get(string);
        if (v == null || !(v instanceof String)) {
            return null;
        }
        String string2 = (String)this.fields.get(string);
        return string2;
    }

    public FieldSet getSet(String string) {
        Object v = this.fields.get(string);
        if (v == null || !(v instanceof FieldSet)) {
            return null;
        }
        return (FieldSet)v;
    }

    public FieldSet makeSet(String string) {
        Object object = this.fields.get(string);
        if (object == null) {
            object = this.newFieldSet();
            this.fields.put(string, object);
        }
        if (!(object instanceof FieldSet)) {
            return null;
        }
        return (FieldSet)object;
    }

    public final Object remove(String string) {
        return this.fields.remove(string);
    }

    public final void clearElements() {
        Enumeration enumeration = this.fields.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.fields.get(k);
            if (!(v instanceof FieldSet)) {
                this.fields.remove(k);
                continue;
            }
            ((FieldSet)v).clearElements();
        }
    }

    public final void put(String string, String string2) {
        this.fields.put(string, string2);
    }

    public final void put(String string, FieldSet fieldSet) {
        this.fields.put(string, fieldSet);
    }

    public final void add(String string, String string2) {
        this.put(string, string2);
    }

    public final void add(String string, FieldSet fieldSet) {
        this.put(string, fieldSet);
    }

    public final boolean isString(String string) {
        return this.fields.get(string) != null && this.fields.get(string) instanceof String;
    }

    public final boolean isSet(String string) {
        return this.fields.get(string) != null && this.fields.get(string) instanceof FieldSet;
    }

    public final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public final Enumeration keys() {
        return this.fields.keys();
    }

    public final Enumeration elements() {
        return this.fields.elements();
    }

    public final int size() {
        return this.fields.size();
    }

    public boolean containsKey(String string) {
        return this.fields.containsKey(string);
    }

    public final void clear() {
        this.fields.clear();
    }

    public final void writeFields(WriteOutputStream writeOutputStream) throws IOException {
        this.writeFields(writeOutputStream, "End", '\n', '=', '.');
    }

    public final void writeFields(WriteOutputStream writeOutputStream, String string) throws IOException {
        this.writeFields(writeOutputStream, string, '\n', '=', '.');
    }

    public final void writeFields(WriteOutputStream writeOutputStream, String string, char c, char c2, char c3) throws IOException {
        this.inWriteFields(writeOutputStream, "", c, '\u0000', c2, c3, false);
        writeOutputStream.writeUTF(string, c);
    }

    public final void writeFields(WriteOutputStream writeOutputStream, String string, char c, char c2, char c3, char c4) throws IOException {
        this.inWriteFields(writeOutputStream, "", c, c2, c3, c4, true);
    }

    private void inWriteFields(WriteOutputStream writeOutputStream, String string, char c, char c2, char c3, char c4, boolean bl) throws IOException {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (this.isSet(string2)) {
                this.getSet(string2).inWriteFields(writeOutputStream, string + string2 + c4, c, c2, c3, c4, bl);
                continue;
            }
            if (!this.isString(string2)) continue;
            writeOutputStream.writeUTF(string);
            writeOutputStream.writeUTF(string2, c3);
            if (bl) {
                writeOutputStream.writeUTF(this.get(string2), c, c2);
                continue;
            }
            writeOutputStream.writeUTF(this.get(string2), c);
        }
    }

    public final String parseFields(ReadInputStream readInputStream) throws IOException {
        return this.parseFields(readInputStream, '\n', '\r', '=', '.');
    }

    public final String parseFields(ReadInputStream readInputStream, char c, char c2, char c3) throws IOException {
        return this.privParse(readInputStream, c, '\u0000', c2, c3, false, voidF, voidF);
    }

    public final String parseFields(ReadInputStream readInputStream, char c, char c2, char c3, char c4) throws IOException {
        return this.privParse(readInputStream, c, c2, c3, c4, true, voidF, voidF);
    }

    public final String parseFields(ReadInputStream readInputStream, char c, char c2, char c3, char c4, Filter filter, Filter filter2) throws IOException {
        return this.privParse(readInputStream, c, c2, c3, c4, true, filter, filter2);
    }

    public final String parseFields(ReadInputStream readInputStream, char c, char c2, char c3, Filter filter, Filter filter2) throws IOException {
        return this.privParse(readInputStream, c, '\u0000', c2, c3, false, filter, filter2);
    }

    private String privParse(ReadInputStream readInputStream, char c, char c2, char c3, char c4, boolean bl, Filter filter, Filter filter2) throws IOException {
        String string;
        block3: {
            long l = 0L;
            do {
                try {
                    string = bl ? readInputStream.readToEOF(c, c2) : readInputStream.readToEOF(c);
                }
                catch (EOFException eOFException) {
                    return null;
                }
                l += (long)string.length();
                int n = string.indexOf(c3);
                if (n < 0) break block3;
                String string2 = string.substring(0, n);
                String string3 = filter2.filter(string.substring(n + 1));
                this.readField(string2, string3, c4, filter);
            } while (l <= 524288L);
            throw new IOException("Message too large");
        }
        return string;
    }

    private final byte[] getStringBytes(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.SEVERE, "Exception thrown in getStringBytes(String c)", unsupportedEncodingException);
            return null;
        }
    }

    public final void hashUpdate(Digest digest) {
        this.hashUpdate(digest, new String[0]);
    }

    public final void hashUpdate(Digest digest, String[] stringArray) {
        this.hashUpdate(digest, stringArray, new byte[0]);
    }

    private void hashUpdate(Digest digest, String[] stringArray, byte[] byArray) {
        Object[] objectArray = new String[this.size()];
        int n = 0;
        Enumeration enumeration = this.keys();
        block0: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(string)) continue block0;
            }
            objectArray[n++] = string;
        }
        QuickSorter.quickSort(new ArraySorter(objectArray, new Fields.StringComparator(), 0, n));
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = this.getStringBytes((String)objectArray[i]);
            Object v = this.fields.get(objectArray[i]);
            if (v instanceof FieldSet) {
                byte[] byArray3 = new byte[byArray.length + byArray2.length + 1];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                byArray3[byArray3.length - 1] = -3;
                ((FieldSet)v).hashUpdate(digest, new String[0], byArray3);
                continue;
            }
            digest.update(byArray);
            digest.update(byArray2);
            digest.update((byte)-2);
            digest.update(this.getStringBytes((String)v));
            digest.update((byte)-1);
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            WriteOutputStream writeOutputStream = new WriteOutputStream(byteArrayOutputStream);
            this.inWriteFields(writeOutputStream, "", ',', '\u0000', '=', '.', false);
            writeOutputStream.flush();
            return "{" + byteArrayOutputStream.toString("UTF8") + "}";
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void readField(String string, String string2, char c, Filter filter) {
        int n = string.indexOf(c);
        if (n < 0) {
            this.fields.put(filter.filter(string), string2);
        } else {
            FieldSet fieldSet;
            String string3 = filter.filter(string.substring(0, n));
            Object v = this.fields.get(string3);
            if (v == null || !(v instanceof FieldSet)) {
                fieldSet = this.newFieldSet();
                this.fields.put(string3, fieldSet);
            } else {
                fieldSet = (FieldSet)v;
            }
            fieldSet.readField(string.substring(n + 1), string2, c, filter);
        }
    }

    protected FieldSet newFieldSet() {
        return new FieldSet();
    }

    private static class VoidFilter
    implements Filter {
        private VoidFilter() {
        }

        public String filter(String string) {
            return string;
        }
    }

    public static interface Filter {
        public String filter(String var1);
    }
}

