/*
 * Decompiled with CFR 0.152.
 */
import fecimpl.OnionFECEncoder;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import freenet.support.RandomAccessFileBucket2;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class test {
    public static void main(String[] stringArray) throws Throwable {
        new test().run();
    }

    public void run() throws Throwable {
        System.out.println("Starting");
        File file = new File("biginputfile.dat");
        long l = file.length();
        OnionFECEncoder onionFECEncoder = new OnionFECEncoder();
        FrostFECEncodeBucketFactory frostFECEncodeBucketFactory = new FrostFECEncodeBucketFactory();
        onionFECEncoder.init(l, frostFECEncodeBucketFactory);
        int n = onionFECEncoder.getSegmentCount();
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            int n2 = onionFECEncoder.getCheckBlockSize(i);
            int n3 = onionFECEncoder.getN(i) - onionFECEncoder.getK(i);
            System.out.println("segment=" + i + "  checkblocks=" + n3 + "  checkblocksize=" + n2);
            l2 += (long)(n2 * n3);
        }
        System.out.println("Preparing check blocks file, size=" + l2);
        frostFECEncodeBucketFactory.init("biginputfile.checks", l2);
        System.out.println("Processing segments");
        long l3 = 0L;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        for (int i = 0; i < n; ++i) {
            int n4 = onionFECEncoder.getK(i);
            int n5 = onionFECEncoder.getBlockSize(i);
            System.out.println("seg=" + i + "  fsize=" + l + "  blocks=" + n4 + "  bsize=" + n5);
            Bucket[] bucketArray = RandomAccessFileBucket2.segment(file, n5, l3, n4, true, randomAccessFile);
            System.out.println("lastb=" + bucketArray[bucketArray.length - 1].size());
            onionFECEncoder.encode(i, bucketArray, null);
            l3 += (long)onionFECEncoder.getSegmentSize(i);
        }
    }

    class FrostFECEncodeBucketFactory
    implements BucketFactory {
        int checkBlockCounter = 0;
        File checkBlocksFile;
        long actFileOffset = 0L;
        RandomAccessFile raf = null;

        FrostFECEncodeBucketFactory() {
        }

        public void init(String string, long l) throws IOException {
            this.checkBlocksFile = new File(string);
            this.checkBlocksFile.delete();
            this.raf = new RandomAccessFile(this.checkBlocksFile, "rw");
            this.raf.setLength(l);
        }

        public Bucket makeBucket(long l) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = new RandomAccessFileBucket2(this.checkBlocksFile, this.actFileOffset, l, false, this.raf);
            this.actFileOffset += l;
            return randomAccessFileBucket2;
        }

        public void freeBucket(Bucket bucket) throws IOException {
            System.out.println("FreeBucket");
        }
    }
}

