/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import freenet.support.RandomAccessFileBucket2;
import java.io.IOException;

public class StripedBucketArray2 {
    private RandomAccessFileBucket2[] Buckets = null;
    private BucketData[] srcData = null;

    public Bucket[] allocate(Bucket[] bucketArray) throws IOException {
        if (this.srcData != null) {
            throw new IllegalStateException("Release the previously allocated buckets!");
        }
        long l = bucketArray[0].size();
        Bucket[] bucketArray2 = new Bucket[bucketArray.length];
        try {
            this.srcData = new BucketData[bucketArray.length];
            for (int i = 0; i < bucketArray.length; ++i) {
                this.srcData[i] = StripedBucketArray2.makeBucketData(bucketArray[i]);
                bucketArray2[i] = this.srcData[i].rafb;
            }
        }
        catch (IOException iOException) {
            this.srcData = null;
            throw iOException;
        }
        return bucketArray2;
    }

    public void release() {
        if (this.srcData == null) {
            return;
        }
        for (int i = 0; i < this.srcData.length; ++i) {
            try {
                this.srcData[i].release();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.srcData = null;
    }

    public void setRange(long l, long l2) throws IOException {
        for (int i = 0; i < this.srcData.length; ++i) {
            this.srcData[i].rafb.setRange(this.srcData[i].offset + l, l2);
        }
    }

    private static BucketData makeBucketData(Bucket bucket) throws IOException {
        if (bucket instanceof RandomAccessFileBucket2) {
            return new BucketData((RandomAccessFileBucket2)bucket);
        }
        throw new IllegalArgumentException("Bucket must be of type RandomAccessFileBucket2.");
    }

    private static class BucketData {
        long offset = 0L;
        long len = 0L;
        boolean fromRAFB = false;
        RandomAccessFileBucket2 rafb = null;

        BucketData(RandomAccessFileBucket2 randomAccessFileBucket2) {
            RandomAccessFileBucket2.Range range = randomAccessFileBucket2.getRange();
            this.offset = range.offset;
            this.len = range.len;
            this.fromRAFB = true;
            this.rafb = randomAccessFileBucket2;
        }

        void release() {
            if (this.fromRAFB) {
                try {
                    this.rafb.setRange(this.offset, this.len);
                }
                catch (Exception exception) {}
            } else {
                this.rafb.release();
            }
            this.rafb = null;
        }
    }
}

