/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class RandomAccessFileBucket2
implements Bucket {
    RandomAccessFile raf = null;
    private File file = null;
    private long offset = -1L;
    private long localOffset = 0L;
    private long len = -1L;
    private boolean readOnly = false;
    private boolean released = false;
    private Vector streams = new Vector();

    public RandomAccessFileBucket2(File file, long l, long l2, boolean bl, RandomAccessFile randomAccessFile) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Can't read file: " + file.getAbsolutePath());
        }
        if (!file.canWrite() && !bl) {
            throw new IOException("Can't write to file: " + file.getAbsolutePath());
        }
        this.file = file;
        this.readOnly = bl;
        this.raf = randomAccessFile;
        this.setRange(l, l2);
    }

    public synchronized void setRange(long l, long l2) throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        if (this.streams.size() > 0) {
            throw new IllegalStateException("Can't reset range.  There are open streams.");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("Bad range arguments.");
        }
        if (l + l2 > this.file.length()) {
            l2 = this.file.length() - l;
        }
        this.offset = l;
        this.len = l2;
        this.localOffset = 0L;
    }

    public final synchronized Range getRange() {
        return new Range(this.offset, this.len);
    }

    public final synchronized boolean hasOpenStreams() {
        return this.streams.size() > 0;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        RAInputStream rAInputStream = new RAInputStream(this, this.file.getAbsolutePath());
        this.streams.addElement(rAInputStream);
        return rAInputStream;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessBucket: " + this.getName());
        }
        if (this.readOnly) {
            throw new IOException("Tried to write a read-only Bucket.");
        }
        RAOutputStream rAOutputStream = new RAOutputStream(this, this.file.getAbsolutePath());
        this.streams.addElement(rAOutputStream);
        return rAOutputStream;
    }

    public String getName() {
        return this.file.getAbsolutePath() + " [" + this.offset + ", " + (this.offset + this.len - 1L) + "]";
    }

    public synchronized void resetWrite() {
        if (this.isReleased()) {
            throw new RuntimeException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        this.localOffset = 0L;
    }

    public long size() {
        return this.len;
    }

    public synchronized boolean release() {
        if (this.released) {
            return true;
        }
        for (int i = 0; i < this.streams.size(); ++i) {
            try {
                if (this.streams.elementAt(i) instanceof InputStream) {
                    ((InputStream)this.streams.elementAt(i)).close();
                    continue;
                }
                if (!(this.streams.elementAt(i) instanceof OutputStream)) continue;
                ((OutputStream)this.streams.elementAt(i)).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.streams.removeAllElements();
        this.streams.trimToSize();
        this.released = true;
        return true;
    }

    public final synchronized boolean isReleased() {
        return this.released;
    }

    public void finalize() throws Throwable {
        if (!this.released) {
            this.release();
        }
    }

    public static Bucket[] segment(File file, int n, long l, int n2, boolean bl, RandomAccessFile randomAccessFile) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Can't read file: " + file.getAbsolutePath());
        }
        if (!file.canWrite() && !bl) {
            throw new IOException("Can't write to file: " + file.getAbsolutePath());
        }
        if (l < 0L || l >= file.length() - 1L) {
            throw new IllegalArgumentException("offset: " + l);
        }
        long l2 = file.length() - l;
        int n3 = (int)(l2 / (long)n);
        if (l2 % (long)n != 0L) {
            ++n3;
        }
        if (n2 == -1) {
            n2 = n3;
        } else if (n2 > n3 || n2 < 1) {
            throw new IllegalArgumentException("blocks: " + n2);
        }
        Bucket[] bucketArray = new Bucket[n2];
        for (int i = 0; i < n2; ++i) {
            long l3 = (long)(i * n) + l;
            int n4 = n;
            if (i == n3 - 1) {
                n4 = (int)(l2 - (long)((n3 - 1) * n));
            }
            bucketArray[i] = new RandomAccessFileBucket2(file, l3, n4, bl, randomAccessFile);
        }
        return bucketArray;
    }

    private class RAOutputStream
    extends OutputStream {
        private RandomAccessFileBucket2 rafb = null;
        private String prefix = "";

        public RAOutputStream(RandomAccessFileBucket2 randomAccessFileBucket22, String string) throws IOException {
            this.rafb = randomAccessFileBucket22;
            RandomAccessFileBucket2.this.raf.seek(randomAccessFileBucket22.offset + randomAccessFileBucket22.localOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                int n2 = this.bytesLeft();
                if (n2 < 1) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                RandomAccessFileBucket2.this.raf.write(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                int n = this.bytesLeft();
                if (n < byArray.length) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                RandomAccessFileBucket2.this.raf.write(byArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                int n3 = this.bytesLeft();
                if (n3 < n2) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                RandomAccessFileBucket2.this.raf.write(byArray, n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                if (this.rafb.streams.contains(this)) {
                    this.rafb.streams.removeElement(this);
                }
                this.rafb.streams.trimToSize();
                long l = RandomAccessFileBucket2.this.raf.getFilePointer() - this.rafb.offset;
                if (l > 0L) {
                    this.rafb.localOffset = l;
                }
            }
        }

        private final void checkValid() throws IOException {
            if (this.rafb.isReleased()) {
                throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.prefix);
            }
        }

        private final int bytesLeft() throws IOException {
            return (int)(this.rafb.offset + this.rafb.len - RandomAccessFileBucket2.this.raf.getFilePointer());
        }
    }

    class RAInputStream
    extends InputStream {
        private RandomAccessFileBucket2 rafb = null;

        public RAInputStream(RandomAccessFileBucket2 randomAccessFileBucket22, String string) throws IOException {
            this.rafb = randomAccessFileBucket22;
            RandomAccessFileBucket2.this.raf.seek(RandomAccessFileBucket2.this.offset);
        }

        private final int bytesLeft() throws IOException {
            return (int)(this.rafb.offset + this.rafb.len - RandomAccessFileBucket2.this.raf.getFilePointer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                if (this.bytesLeft() < 1) {
                    return -1;
                }
                return RandomAccessFileBucket2.this.raf.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                int n = this.bytesLeft();
                if (n < 1) {
                    return -1;
                }
                if (n > byArray.length) {
                    n = byArray.length;
                }
                return RandomAccessFileBucket2.this.raf.read(byArray, 0, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                int n3 = this.bytesLeft();
                if (n3 < 1) {
                    return -1;
                }
                if (n3 > n2) {
                    n3 = n2;
                }
                return RandomAccessFileBucket2.this.raf.read(byArray, n, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                int n = this.bytesLeft();
                if (n < 1) {
                    return -1L;
                }
                if ((long)n > l) {
                    n = (int)l;
                }
                return RandomAccessFileBucket2.this.raf.skipBytes(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                return this.bytesLeft();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                if (this.rafb.streams.contains(this)) {
                    this.rafb.streams.removeElement(this);
                }
                this.rafb.streams.trimToSize();
            }
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
        }

        public boolean markSupported() {
            return false;
        }
    }

    public static class Range {
        public long offset;
        public long len;

        Range(long l, long l2) {
            this.offset = l;
            this.len = l2;
        }
    }
}

