/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class RandomAccessFileBucket
implements Bucket {
    private static final boolean vociferous = false;
    private File file = null;
    private long offset = -1L;
    private long localOffset = 0L;
    private long len = -1L;
    private boolean readOnly = false;
    private boolean released = false;
    private Vector streams = new Vector();

    public RandomAccessFileBucket(File file, long l, long l2, boolean bl) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Can't read file: " + file.getAbsolutePath());
        }
        if (!file.canWrite() && !bl) {
            throw new IOException("Can't write to file: " + file.getAbsolutePath());
        }
        this.file = file;
        this.readOnly = bl;
        this.setRange(l, l2);
    }

    public synchronized void setRange(long l, long l2) throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        if (this.streams.size() > 0) {
            throw new IllegalStateException("Can't reset range.  There are open streams.");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("Bad range arguments.");
        }
        if (l + l2 > this.file.length()) {
            l2 = this.file.length() - l;
        }
        this.offset = l;
        this.len = l2;
        this.localOffset = 0L;
    }

    public final synchronized Range getRange() {
        return new Range(this.offset, this.len);
    }

    public final synchronized boolean hasOpenStreams() {
        return this.streams.size() > 0;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        RAInputStream rAInputStream = new RAInputStream(this, this.file.getAbsolutePath());
        this.streams.addElement(rAInputStream);
        return rAInputStream;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessBucket: " + this.getName());
        }
        if (this.readOnly) {
            throw new IOException("Tried to write a read-only Bucket.");
        }
        RAOutputStream rAOutputStream = new RAOutputStream(this, this.file.getAbsolutePath());
        this.streams.addElement(rAOutputStream);
        return rAOutputStream;
    }

    public String getName() {
        return this.file.getAbsolutePath() + " [" + this.offset + ", " + (this.offset + this.len - 1L) + "]";
    }

    public synchronized void resetWrite() {
        if (this.isReleased()) {
            throw new RuntimeException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        this.localOffset = 0L;
    }

    public long size() {
        return this.len;
    }

    public synchronized boolean release() {
        if (this.released) {
            return true;
        }
        for (int i = 0; i < this.streams.size(); ++i) {
            try {
                if (this.streams.elementAt(i) instanceof InputStream) {
                    ((InputStream)this.streams.elementAt(i)).close();
                    continue;
                }
                if (!(this.streams.elementAt(i) instanceof OutputStream)) continue;
                ((OutputStream)this.streams.elementAt(i)).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.streams.removeAllElements();
        this.streams.trimToSize();
        this.released = true;
        return true;
    }

    public final synchronized boolean isReleased() {
        return this.released;
    }

    public void finalize() throws Throwable {
        if (!this.released) {
            this.release();
        }
    }

    public static Bucket[] segment(File file, int n, long l, int n2, boolean bl) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Can't read file: " + file.getAbsolutePath());
        }
        if (!file.canWrite() && !bl) {
            throw new IOException("Can't write to file: " + file.getAbsolutePath());
        }
        if (l < 0L || l >= file.length() - 1L) {
            throw new IllegalArgumentException("offset: " + l);
        }
        long l2 = file.length() - l;
        int n3 = (int)(l2 / (long)n);
        if (l2 % (long)n != 0L) {
            ++n3;
        }
        if (n2 == -1) {
            n2 = n3;
        } else if (n2 > n3 || n2 < 1) {
            throw new IllegalArgumentException("blocks: " + n2);
        }
        Bucket[] bucketArray = new Bucket[n2];
        for (int i = 0; i < n2; ++i) {
            long l3 = (long)(i * n) + l;
            int n4 = n;
            if (i == n3 - 1) {
                n4 = (int)(l2 - (long)((n3 - 1) * n));
            }
            bucketArray[i] = new RandomAccessFileBucket(file, l3, n4, bl);
        }
        return bucketArray;
    }

    private class RAOutputStream
    extends OutputStream {
        private RandomAccessFileBucket rafb = null;
        private RandomAccessFile raf = null;
        private String prefix = "";

        public RAOutputStream(RandomAccessFileBucket randomAccessFileBucket2, String string) throws IOException {
            this.rafb = randomAccessFileBucket2;
            this.raf = new RandomAccessFile(randomAccessFileBucket2.file, "rw");
            this.raf.seek(randomAccessFileBucket2.offset + randomAccessFileBucket2.localOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                this.checkValid();
                int n2 = this.bytesLeft();
                if (n2 < 1) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                this.raf.write(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray) throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                this.checkValid();
                int n = this.bytesLeft();
                if (n < byArray.length) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                this.raf.write(byArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                this.checkValid();
                int n3 = this.bytesLeft();
                if (n3 < n2) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                this.raf.write(byArray, n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                this.checkValid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                this.checkValid();
                if (this.rafb.streams.contains(this)) {
                    this.rafb.streams.removeElement(this);
                }
                this.rafb.streams.trimToSize();
                long l = this.raf.getFilePointer() - this.rafb.offset;
                if (l > 0L) {
                    this.rafb.localOffset = l;
                }
                this.raf.close();
            }
        }

        private final void checkValid() throws IOException {
            if (this.rafb.isReleased()) {
                throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.prefix);
            }
        }

        private final int bytesLeft() throws IOException {
            return (int)(this.rafb.offset + this.rafb.len - this.raf.getFilePointer());
        }
    }

    class RAInputStream
    extends InputStream {
        private RandomAccessFileBucket rafb = null;
        private RandomAccessFile raf = null;
        private String prefix = "";

        public RAInputStream(RandomAccessFileBucket randomAccessFileBucket2, String string) throws IOException {
            this.rafb = randomAccessFileBucket2;
            this.raf = new RandomAccessFile(randomAccessFileBucket2.file, "r");
            this.raf.seek(RandomAccessFileBucket.this.offset);
        }

        private final int bytesLeft() throws IOException {
            return (int)(this.rafb.offset + this.rafb.len - this.raf.getFilePointer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                if (this.bytesLeft() < 1) {
                    return -1;
                }
                return this.raf.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray) throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                int n = this.bytesLeft();
                if (n < 1) {
                    return -1;
                }
                if (n > byArray.length) {
                    n = byArray.length;
                }
                return this.raf.read(byArray, 0, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                int n3 = this.bytesLeft();
                if (n3 < 1) {
                    return -1;
                }
                if (n3 > n2) {
                    n3 = n2;
                }
                return this.raf.read(byArray, n, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                int n = this.bytesLeft();
                if (n < 1) {
                    return -1L;
                }
                if ((long)n > l) {
                    n = (int)l;
                }
                return this.raf.skipBytes(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                return this.bytesLeft();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            RandomAccessFileBucket randomAccessFileBucket = this.rafb;
            synchronized (randomAccessFileBucket) {
                this.raf.close();
                if (this.rafb.streams.contains(this)) {
                    this.rafb.streams.removeElement(this);
                }
                this.rafb.streams.trimToSize();
            }
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
        }

        public boolean markSupported() {
            return false;
        }
    }

    public static class Range {
        public long offset;
        public long len;

        Range(long l, long l2) {
            this.offset = l;
            this.len = l2;
        }
    }
}

