/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import freenet.support.io.NullInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileBucket
implements Bucket {
    protected File file;
    protected boolean restart = true;
    protected boolean newFile;
    protected long length;
    protected long fileRestartCounter;
    protected static String tempDir;

    public FileBucket(File file) {
        this.file = file;
        this.newFile = false;
        this.fileRestartCounter = 0L;
        this.length = file.length();
    }

    public FileBucket() {
        this.file = new File("tempdir/" + System.currentTimeMillis());
        this.newFile = true;
        this.length = 0L;
        this.file.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        FileBucket fileBucket = this;
        synchronized (fileBucket) {
            boolean bl;
            boolean bl2 = bl = !this.restart;
            if (this.restart) {
                ++this.fileRestartCounter;
            }
            this.restart = false;
            return this.newFileBucketOutputStream(this.file.getPath(), bl, this.fileRestartCounter);
        }
    }

    protected FileBucketOutputStream newFileBucketOutputStream(String string, boolean bl, long l) throws IOException {
        return new FileBucketOutputStream(string, bl, l);
    }

    protected void resetLength() {
        long l = this.length;
        this.length = 0L;
    }

    public InputStream getInputStream() throws IOException {
        return this.file.exists() ? new FileBucketInputStream(this.file) : new NullInputStream();
    }

    public String getName() {
        return this.file.getName();
    }

    public void resetWrite() {
        this.restart = true;
    }

    public long size() {
        return this.length;
    }

    public File getFile() {
        return this.file;
    }

    protected void deleteFile() {
        this.file.delete();
    }

    public void finalize() throws Throwable {
        if (this.newFile && this.file.exists()) {
            this.deleteFile();
        }
    }

    public static final synchronized String getTempDir() {
        return tempDir;
    }

    public static final synchronized void setTempDir(String string) {
        File file = new File(string);
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            throw new IllegalArgumentException("Bad Temp Directory: " + file.getAbsolutePath());
        }
        tempDir = string;
    }

    static {
        String string;
        tempDir = null;
        tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null && (string = System.getProperty("os.name")) != null) {
            String[] stringArray;
            String[] stringArray2 = null;
            if (string.equalsIgnoreCase("Linux")) {
                stringArray2 = stringArray = new String[]{"/tmp", "/var/tmp"};
            } else if (string.equalsIgnoreCase("Windows")) {
                stringArray2 = stringArray = new String[]{"C:\\TEMP", "C:\\WINDOWS\\TEMP"};
            }
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    File file = new File(stringArray2[i]);
                    if (!file.exists() || !file.isDirectory() || !file.canWrite()) continue;
                    tempDir = stringArray2[i];
                    break;
                }
            }
        }
        if (tempDir == null) {
            tempDir = System.getProperty("user.dir");
        }
    }

    class FileBucketInputStream
    extends FileInputStream {
        Exception e;

        public FileBucketInputStream(File file) throws IOException {
            super(file);
        }
    }

    class FileBucketOutputStream
    extends FileOutputStream {
        long restartCount;
        Exception e;

        protected FileBucketOutputStream(String string, boolean bl, long l) throws FileNotFoundException {
            super(string, bl);
            this.restartCount = l;
            if (!bl) {
                FileBucket.this.resetLength();
            }
        }

        protected void confirmWriteSynchronized() {
            if (FileBucket.this.fileRestartCounter > this.restartCount) {
                throw new IllegalStateException("writing to file after restart");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray) throws IOException {
            FileBucket fileBucket = FileBucket.this;
            synchronized (fileBucket) {
                this.confirmWriteSynchronized();
                super.write(byArray);
                FileBucket.this.length += (long)byArray.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            FileBucket fileBucket = FileBucket.this;
            synchronized (fileBucket) {
                this.confirmWriteSynchronized();
                super.write(byArray, n, n2);
                FileBucket.this.length += (long)n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            FileBucket fileBucket = FileBucket.this;
            synchronized (fileBucket) {
                this.confirmWriteSynchronized();
                if (FileBucket.this.fileRestartCounter > this.restartCount) {
                    throw new IllegalStateException("writing to file after restart");
                }
                super.write(n);
                ++FileBucket.this.length;
            }
        }
    }
}

