/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ArrayBucket
implements Bucket {
    private Vector data = new Vector();
    private boolean reset;
    private String name;

    public ArrayBucket() {
        this("ArrayBucket");
    }

    public ArrayBucket(byte[] byArray) {
        this("ArrayBucket");
        this.data.addElement(byArray);
    }

    public ArrayBucket(String string) {
        this.name = string;
    }

    public OutputStream getOutputStream() {
        return new ArrayBucketOutputStream(this.reset);
    }

    public InputStream getInputStream() {
        return new ArrayBucketInputStream();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            stringBuffer.append(new String(byArray));
        }
        return new String(stringBuffer);
    }

    public void read(InputStream inputStream) throws IOException {
        int n;
        ArrayBucketOutputStream arrayBucketOutputStream = new ArrayBucketOutputStream(this.reset);
        byte[] byArray = new byte[65535];
        while ((n = inputStream.read(byArray)) != -1) {
            ((OutputStream)arrayBucketOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)arrayBucketOutputStream).close();
    }

    public long size() {
        long l = 0L;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            l += (long)byArray.length;
        }
        return l;
    }

    public String getName() {
        return this.name;
    }

    public void resetWrite() {
        this.reset = true;
    }

    private class ArrayBucketInputStream
    extends InputStream {
        Enumeration e;
        ByteArrayInputStream in;

        public ArrayBucketInputStream() {
            this.e = ArrayBucket.this.data.elements();
        }

        public int read() {
            return this.priv_read();
        }

        private int priv_read() {
            int n;
            if (this.in == null) {
                if (this.e.hasMoreElements()) {
                    this.in = new ByteArrayInputStream((byte[])this.e.nextElement());
                } else {
                    return -1;
                }
            }
            if ((n = this.in.read()) == -1) {
                this.in = null;
                return this.priv_read();
            }
            return n;
        }

        public int read(byte[] byArray) {
            return this.priv_read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) {
            return this.priv_read(byArray, n, n2);
        }

        private int priv_read(byte[] byArray, int n, int n2) {
            int n3;
            if (this.in == null) {
                if (this.e.hasMoreElements()) {
                    this.in = new ByteArrayInputStream((byte[])this.e.nextElement());
                } else {
                    return -1;
                }
            }
            if ((n3 = this.in.read(byArray, n, n2)) == -1) {
                this.in = null;
                return this.priv_read(byArray, n, n2);
            }
            return n3;
        }

        public int available() {
            if (this.in == null) {
                if (this.e.hasMoreElements()) {
                    this.in = new ByteArrayInputStream((byte[])this.e.nextElement());
                } else {
                    return 0;
                }
            }
            return this.in.available();
        }
    }

    private class ArrayBucketOutputStream
    extends ByteArrayOutputStream {
        boolean reset;
        boolean done = false;

        public ArrayBucketOutputStream(boolean bl) {
            this.reset = bl;
        }

        public void close() {
            this.done = true;
            if (this.reset) {
                ArrayBucket.this.data.removeAllElements();
                ArrayBucket.this.data.trimToSize();
            }
            this.reset = false;
            ArrayBucket.this.data.addElement(this.toByteArray());
        }
    }
}

